
% Steady state delamination for various layer thicknesses
%--------------------------------------------------------------------------

clear all 
close all
clc

cd 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack\Linear_moisture_full'
addpath 'C:\Users\EBosco\Documents\MATLAB\export_fig'
%-------------------------------------------------------------------------
% Input parameters



b2b1 = [ 0.1, 0.3, 3,10];
E2E1 = [0.1, 0.3, 1 , 3, 10];%linspace(.1,1,101);

h1 = 1;
h2 = linspace(1,1000,10001);%[1, 3, 5, 10, 100, 1000];
h = h1+h2;

h_Fl ='h2_1';
E1 = 1;
E2 = E1*E2E1;
nu1 = 0.3;
nu2 = 0.3;
G1 = E1/(2*(1+nu1));
G2 = E2/(2*(1+nu2));

b1 = 1;
b2 = b1*b2b1;

DChi_1 = 1;
DChi_2 = 0;

for lh = 1:length(h2)
DChi_c(lh) = (DChi_1*h2(lh)+DChi_2*h1)/(h1+h2(lh));
DChi_l(lh) = (DChi_1-DChi_2)/(h1+h2(lh));
end
% Plane strain quantities

E1bar = E1/(1-nu1^2);
E2bar = E2/(1-nu2^2);
b1bar = b1*(1+nu1);
b2bar = b2*(1+nu2);

% Dundur_alpha = (E1bar -E2bar)/(E1bar+E2bar);
% Dundur_beta = 1/2*((1-2*nu2)/G2 - (1-2*nu1)/G1)/((1-nu2)/G2+(1-nu1)/G1);
% Estar = 2*(E1bar^(-1)+E2bar^(-1))^(-1);
% coefGD = (1-Dundur_beta^2)/Estar;

SIGMA = E1bar*b1bar*(DChi_1-DChi_2);

sigma_inf_c = zeros(length(b2b1),length(E2E1),length(h2));
SIGMA_inf_c = zeros(length(b2b1),length(E2E1),length(h2));
SIGMA_inf_c2 = zeros(length(b2b1),length(E2E1),length(h2));


betastar_c = zeros(length(b2b1),length(E2E1),length(h2));
betastar_l = zeros(length(b2b1),length(E2E1),length(h2));
betastar_l2 = zeros(length(b2b1),length(E2E1),length(h2));
gamma = zeros(length(b2b1),length(E2E1),length(h2));

G_ss_const = zeros(length(b2b1),length(E2E1),length(h2));
G_ss_constlin = zeros(length(b2b1),length(E2E1),length(h2));
G_ss_lin = zeros(length(b2b1),length(E2E1),length(h2));

kappa2 = zeros(length(b2b1),length(h2));
kappa1 = b1bar*DChi_l;


% Normalization stresses
for i = 1:length(b2b1)
    for lh = 1:length(h2)
       kappa2(i,lh) = b2bar(i)*DChi_l(lh);
 
     for j = 1 :length(E2E1)
        betastar_c(i,j,lh) = (E1bar*h1*b1bar+E2bar(j)*h2(lh)*b2bar(i))/((E1bar*h1+E2bar(j)*h2(lh)));
        betastar_l(i,j,lh) = (E1bar*h1^2*b1bar-E2bar(j)*h2(lh)^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2(lh))*(h1+h2(lh))*b1bar);
        betastar_l2(i,j,lh) = (E1bar*h1^2*b1bar-E2bar(j)*h2(lh)^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2(lh))*(h1+h2(lh))*b2bar(i));

        sigma_inf_c(i,j,lh) = E1bar*(betastar_c(i,j,lh) - b1bar)*DChi_c(lh);
        SIGMA_inf_c(i,j,lh) = SIGMA*betastar_l(i,j,lh);  
        SIGMA_inf_c2(i,j,lh) = E2bar(j)*(E1bar*h1^2*b1bar-E2bar(j)*h2(lh)^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2(lh)))*DChi_l(lh);
        sigma_inf_linear1(i,j,lh) =   SIGMA*(betastar_l(i,j,lh)-1/2);
        
        sigmaTOP_1(lh,i,j) = sigma_inf_c(i,j,lh) + SIGMA_inf_c(i,j,lh)*(betastar_l(i,j,lh)-h1/(h1+h2(lh)));
        G_ss_const(i,j,lh) = 1/2* sigma_inf_c(i,j,lh)^2*h1/E1bar*(1+E1bar/E2bar(j)*h1/h2(lh));
        
        gamma(i,j,lh) = h1^2/(3*h(lh)^2) + betastar_l(i,j,lh)^2-betastar_l(i,j,lh)*h1/h(lh) + ...
            E2bar(j)*b2bar(i)^2/(E1bar*b1bar^2*h1)*(h2(lh)^3/(4*h(lh)^2)+betastar_l2(i,j,lh)^2*h2(lh)+betastar_l2(i,j,lh)*h2(lh)^2/h(lh));
       
        
        G_ss_lin(i,j,lh) = 1/2*SIGMA^2/E1bar*h1*gamma(i,j,lh);
        
%        G_ss_0(i,j,lh) = 1/(2*E1bar)*(SIGMA_inf_c(i,j,lh)^2*h1-SIGMA_inf_c(i,j,lh)*E1bar*kappa1*h1^2+E1bar^2*kappa1^2*h1^3/3) + ...
  %      1/(2*E2bar(j))*(SIGMA_inf_c2(i,j,lh)^2*h2(lh)+E2bar(j)*kappa2(i,lh)*h2(lh)^2*SIGMA_inf_c2(i,j,lh)+E2bar(j)^2*kappa2(i,lh)^2*h2(lh)^3/3) - ...
  %      1/24*E2bar(j)*b2bar(i)^2*DChi_l(lh)^2*h2(lh)^3;
        %coefficiente(i,j) =  G_ss_lin0(i,j)*2*E1bar/SIGMA^2/h1;
        G_ss_constlin(i,j,lh) = SIGMA*sigma_inf_c(i,j,lh)/E1bar* (-h1/(2*h(lh))+betastar_l(i,j,lh)- (betastar_l2(i,j,lh) ...
            +h2(lh)/(2*h(lh)))*b2bar(i)/b1bar);
     end
    end
end


G_ss = G_ss_const + G_ss_lin + G_ss_constlin ;

sigma_ss = zeros(length(h2),length(E2E1));
SIGMA_delam_ss = zeros(length(h2),length(b2b1),length(E2E1));
 Gdc = 1;
for lh = 1 :length(h2)
    for i = 1:length(b2b1)
        for j = 1 :length(E2E1)
            
       

            % Ste ady state stress
            if betastar_l(i,j,lh) > 0
             SIGMA_delam_ss(lh,i,j) =   sqrt(2*Gdc*E1bar/(h1*(gamma(i,j,lh)/betastar_l(i,j,lh)^2)));
%SIGMA_delam_ss(i,j,nn) =  sqrt(2*Gdc(nn)*E1bar/(h1*(gamma(i,j,lh)/betastar_l(i,j)^2)))
            else
            SIGMA_delam_ss(lh,i,j) =  sqrt(2*Gdc*E1bar/(h1*(gamma(i,j,lh)/betastar_l(i,j,lh)^2)));

            end
            sigma_ss(lh,j) = sqrt(2*Gdc*E1bar/(h1*(1+E1bar/E2bar(j)*h1/h2(lh))));
            
            sigma_ss_tot(lh,i,j) =  sigma_ss(lh,j) + SIGMA_delam_ss(lh,i,j);
            end
        end
end
    

%%
 
sigma_inf_c_beta1 = zeros(length(E2E1),length(h2));

sigma_inf_c_beta1(:,:)=sigma_inf_c(1,:,:);

 
sigma_inf_c_beta4 = zeros(length(E2E1),length(h2));

sigma_inf_c_beta4(:,:)=sigma_inf_c(4,:,:);

figure
%axis([0 .6 0.25 1.25])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
stry = ' ${{\sigma}}_{1}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 1;
plot(h2,sigma_inf_c_beta1(1,:)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
%plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
plot(h2,sigma_inf_c_beta1(3,:)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
%plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
plot(h2,sigma_inf_c_beta1(5,:)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)

plot(h2,sigmaTOP_1(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'r-','LineWidth', 2)
%plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
plot(h2,sigmaTOP_1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'r-.','LineWidth', 2)
%plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
plot(h2,sigmaTOP_1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),'r:','LineWidth', 3.5)
%plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)

%lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
%'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
% 'FontSize', 15);

%%

figure
axis([0 1000 0 1.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
stry = ' ${\bar{\sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 \Gamma_{{d}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 1;
plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0 75 135]/255)

%plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

export_fig(['sigma_ss_const_h'],'-jpg','-eps', '-r300', '-transparent')

%%
figure
axis([0 1000 0 1.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
stry = ' ${{\Sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 \Gamma_{{d}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 4;
plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0 75 135]/255)

%plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
%plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

export_fig(['sigma_ss_lin_h'],'-jpg','-eps', '-r300', '-transparent')

%%
figure
axis([0 1000 0 2.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
%stry = ' $ {{\Sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
stry = ' $ {{\sigma}}_{ss}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{dc}})}$';

% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 1;
% plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)

% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)
plot(h2,sigma_ss_tot(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0 75 135]/255)

% bflag = 4;
% % plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% % plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% % plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% % plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% % plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)
% 
% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

export_fig(['sigma_ss_tot_beta',num2str(bflag),'_h'],'-jpg','-eps', '-r300', '-transparent')
%%
%%figure
axis([0 1000 0 2.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
%stry = ' $ {{\Sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
stry = ' $ {{\sigma}}_{ss}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{dc}})}$';

% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 1;
% plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)

% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)
plot(h2,sigma_ss_tot(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_ss_tot(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0 75 135]/255)

% bflag = 4;
% % plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% % plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% % plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% % plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% % plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)
% 
% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

export_fig(['sigma_ss_tot_beta',num2str(bflag),'_h'],'-jpg','-eps', '-r300', '-transparent')

%%


figure
axis([0 1000 0 2])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
%stry = ' $ {{\Sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
stry = ' $ {{\Sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 \Gamma_{{d}})}$';

% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 2;

etaPlot = zeros(length(h2),length(b2b1),length(E2E1));
for i = 1:length(b2b1)
    for lh = 1:length(h2)
      for j = 1 :length(E2E1)
         etaPlot(lh,i,j) = betastar_l(i,j,lh);
     end
    end
end 

% betastar_l1 = betastar_l(bflag,1,:);
% betastar_l2 = betastar_l(bflag,2,:);
% betastar_l3 = betastar_l(bflag,3,:);
% betastar_l4 = betastar_l(bflag,4,:);
% betastar_l5 = betastar_l(bflag,5,:);

% plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)

% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)
plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0 75 135]/255)


 tt = text(150,1.8,['{Shrinkage}'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(150,1.65,['\textbf{Swelling}'],'Interpreter','latex');
tt.FontSize = 17;
% plot(h2,etaPlot(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-r','LineWidth', 2)
% plot(h2,etaPlot(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--r','LineWidth', 2)
% plot(h2,etaPlot(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.r','LineWidth', 2)
% plot(h2,etaPlot(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':r','LineWidth', 2)
% plot(h2,etaPlot(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':r','LineWidth', 3.5)

% plot(h2,betastar_l1(bflag,:)*(E1bar*Gdc/h1)^(-0.5),'-r','LineWidth', 2)
% plot(h2,betastar_l2(bflag,:)*(E1bar*Gdc/h1)^(-0.5),'--r','LineWidth', 2)
% plot(h2,betastar_l3(bflag,:)*(E1bar*Gdc/h1)^(-0.5),'-.r','LineWidth', 2)
% plot(h2,betastar_l4(bflag,:)*(E1bar*Gdc/h1)^(-0.5),':r','LineWidth', 2)
% plot(h2,betastar_l5(bflag,:)*(E1bar*Gdc/h1)^(-0.5),':r','LineWidth', 3.5)
% bflag = 4;
% plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)
% 
% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

%export_fig(['Sigma_ss_beta',num2str(bflag),'_h'],'-jpg','-eps', '-r300', '-transparent')
%%
