%%
%--------------------------------------------------------------------------

% Failure map for constant part of the stress
%--------------------------------------------------------------------------

%E2E1=.1

% Intersection point
Gdc1 = 0.586; sig1 =0.4378;%.422;%0.4378;
Gd1_plot = linspace(0,Gdc1,51);

sig1_plot = sig1*sqrt(Gd1_plot/GIc);


% extra intersection points

G1_list = [0.6 0.65 0.7 .75  0.8 .85 .9 1 1.2 1.4 1.5 2 2.16];
sig1_list0 = [.436, .423 .411 .3985 .389, .379, .37 .3535,.326 ,.304, .294 .257, .248 ];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G1_list)
sig1_list(j) =sig1_list0(j)*sqrt(G1_list(j)/GIc);
end

Gd1_plot = [Gd1_plot,  G1_list,2.5];
sig1_plot =[sig1_plot,  sig1_list, sig1_list(end)];


%E2E1=.3

% Intersection point
Gdc2 = 0.5125; sig2 =0.7088;
Gd2_plot = linspace(0,Gdc2,51);
sig2_plot = sig2*sqrt(Gd2_plot/GIc);


% extra intersection points

G2_list = [0.6 .65 0.7 .75 .8 .85 .9 .915];
sig2_list0 = [.6625 .638 .616  .596 .578 .561 .5455 .541];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G2_list)
sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
end

Gd2_plot = [Gd2_plot,  G2_list,2.5];
sig2_plot =[sig2_plot,  sig2_list, sig2_list(end)];

%Gd2_plot = [Gd2_plot, 2.5];
%sig2_plot =[sig2_plot, sig2_plot(end)];

%E2E1=1

% Intersection point
Gdc3 = 0.4375; sig3 =1.066;%1.066; %1
Gd3_plot = linspace(0,Gdc3,51);
sig3_plot = sig3*sqrt(Gd3_plot/GIc);

% extra intersection points

G3_list = [.45 .46 .47 .48 .49 .492];
sig3_list0 = [1.0525 1.0415 1.03 1.02 1.009 1.007];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end



Gd3_plot = [Gd3_plot, G3_list, 2.5];
sig3_plot =[sig3_plot, sig3_list sig3_plot(end)];

%E2E1=3

% Intersection point
Gdc4 = 0.4235; sig4 =1.293; %1.225
Gd4_plot = linspace(0,Gdc4,51);
sig4_plot = sig4*sqrt(Gd4_plot/GIc);

Gd4_plot = [Gd4_plot, 2.5];
sig4_plot =[sig4_plot, sig4_plot(end)];

%E2E1=10

% Intersection point
Gdc5 = 0.4315; sig5 =1.396;%1.349; %;
Gd5_plot = linspace(0,Gdc5,51);
sig5_plot = sig5*sqrt(Gd5_plot/GIc);

Gd5_plot = [Gd5_plot, 2.5];
sig5_plot =[sig5_plot, sig5_plot(end)];


% Failure map graph

figure
axis([0 2.5 0 1])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_d/\Gamma_I$';
stry = ' $\bar{\sigma}_{c,min}\sqrt{h_1/(\bar{E}_1 \Gamma_{{I}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0:.2:1);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1_plot,sig1_plot*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd2_plot,sig2_plot*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd3_plot,sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd4_plot,sig4_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd5_plot,sig5_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5,'Color', [0 75 135]/255)

 GGG = [Gd1_plot(end-1), Gdc1, Gdc2, Gd2_plot(end-1),  Gdc3, Gd3_plot(end-1), Gd4_plot(end-1), Gd5_plot(end-1)];
 SSS = [sig1_plot(end-1)*(E1bar*GIc/h1)^(-0.5), sig1*(E1bar*GIc/h1)^(-0.5)*sqrt(Gdc1/GIc), ...
     sig2*(E1bar*GIc/h1)^(-0.5)*sqrt(Gdc2/GIc), sig2_plot(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     sig3*(E1bar*GIc/h1)^(-0.5)*sqrt(Gdc3/GIc),...
     sig3_plot(end-1)*(E1bar*GIc/h1)^(-0.5),sig4_plot(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     sig5_plot(end-1)*(E1bar*GIc/h1)^(-0.5)];
 plot(GGG,SSS,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)
% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.2,0.151,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.7,0.73,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(1.05,0.2,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;

 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

export_fig(['Fail_mech',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%



%--------------------------------------------------------------------------
% Failure map for linear part of the stress Sigma
% bflag = 4;
%--------------------------------------------------------------------------

% Intersection point
% Gdc1_S4 = 0.565; Sig14 =1.681;
% %Gdc1_S4 = 0.484; Sig14 =1.764;%0.4378;
% 
% Gd1S_plot4 = linspace(0,Gdc1_S4,21);
% 
% Sig1_plot4 = Sig14*sqrt(Gd1S_plot4/GIc);
% 
% 
% Gd1S_plot4 = [Gd1S_plot4 1];
% Sig1_plot4 =[Sig1_plot4,  Sig1_plot4(end)];



% Intersection point
Gdc2_S4 = 0.452; Sig24 =.433;
%Gdc2_S4 = 0.45; Sig24 =1.126;

Gd2S_plot4 = linspace(0,Gdc2_S4,101);

Sig2_plot4 = Sig24*sqrt(Gd2S_plot4/GIc);


% extra intersection points

G2_list = [0.5, .55, .6, .65, .7, .73, .75];
sig2_list0 = [.41375,.3955,.37975,.365 ,.352, .345, .34 ];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G2_list)
sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
end

Gd2S_plot4 = [Gd2S_plot4, G2_list, 1];
Sig2_plot4 =[Sig2_plot4,  sig2_list, Sig2_plot4(end)];




% Intersection point
%Gdc3_S4 = 0.4085; Sig34 =0.7765;%0.4378;
Gdc3_S4 = 0.4085; Sig34 =0.8735;%0.4378;

Gd3S_plot4 = linspace(0,Gdc3_S4,101);

Sig3_plot4 = Sig34*sqrt(Gd3S_plot4/GIc);

% extra intersection points

G3_list = [0.42, 0.43, 0.44, .445];
sig3_list0 = [.8617,.852,.8425, .8371 ];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end



Gd3S_plot4 = [Gd3S_plot4 G3_list  1];
Sig3_plot4 =[Sig3_plot4 sig3_list Sig3_plot4(end)];

% Intersection point
Gdc4_S4 = 0.4075; Sig44 =1.131;%0.4378;
%Gdc4_S4 = 0.4685; Sig44 =1.074;

Gd4S_plot4 = linspace(0,Gdc4_S4,101);

Sig4_plot4 = Sig44*sqrt(Gd4S_plot4/GIc);


Gd4S_plot4 = [Gd4S_plot4 1];
Sig4_plot4 =[Sig4_plot4,  Sig4_plot4(end)];

% Intersection point
%Gdc5_S4 = 0.419; Sig54 =0.5551;%0.4378;
Gdc5_S4 = 0.455; Sig54 =1.212;%0.4378;

Gd5S_plot4 = linspace(0,Gdc5_S4,101);

Sig5_plot4 = Sig54*sqrt(Gd5S_plot4/GIc);


Gd5S_plot4 = [Gd5S_plot4 1];
Sig5_plot4 =[Sig5_plot4,  Sig5_plot4(end)];

 % Failure map graph
bflag =4;
figure
axis([0 1 0 1])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_d/\Gamma_I$';
stry = ' ${\Sigma}_{c,min}\sqrt{h_1/(\bar{E}_1 \Gamma_{{I}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0:.2:.8);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
% plot(Gd1S_plot4,Sig1_plot4*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2)
 plot(Gd2S_plot4,Sig2_plot4*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2,'Color', [0 75 135]/255)
plot(Gd3S_plot4,Sig3_plot4*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2, 'Color', [0 75 135]/255)
 plot(Gd4S_plot4,Sig4_plot4*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2, 'Color', [0 75 135]/255)
 plot(Gd5S_plot4,Sig5_plot4*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5, 'Color', [0 75 135]/255)

  GGG = [Gdc2_S4, Gd2S_plot4(end-1),Gdc3_S4, Gd3S_plot4(end-1), Gd4S_plot4(end-1), Gd5S_plot4(end-1)];
  SSS = [Sig24*sqrt(Gdc2_S4/GIc)*(E1bar*GIc/h1)^(-0.5), Sig2_plot4(end-1)*(E1bar*GIc/h1)^(-0.5),Sig34*sqrt(Gdc3_S4/GIc)*(E1bar*GIc/h1)^(-0.5),  ...
      Sig3_plot4(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot4(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plot4(end-1)*(E1bar*GIc/h1)^(-0.5)];
  plot(GGG,SSS,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)
% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(.62,0.62,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.05,0.62,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.53,0.1,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;


 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northwest', ...
 'FontSize', 15);


export_fig(['Fail_mech_lin_beta',num2str(bflag),h_Fl],'-jpg','-r300', '-transparent')



%%

%--------------------------------------------------------------------------
% Failure map for linear part of the stress Sigma
% bflag = 1;
%--------------------------------------------------------------------------

% Intersection point
Gdc1_S = 0.37; Sig1 =1.912;%0.4378;
Gd1S_plot = linspace(0,Gdc1_S,101);

Sig1_plot = Sig1*sqrt(Gd1S_plot/GIc);

Gd1S_plot = [Gd1S_plot, 1];
Sig1_plot =[Sig1_plot, Sig1_plot(end)];

%
Gdc2_S = 0.395; Sig2 =1.348;
Gd2S_plot = linspace(0,Gdc2_S,101);

Sig2_plot = Sig2*sqrt(Gd2S_plot/GIc);

Gd2S_plot = [Gd2S_plot, 1];
Sig2_plot =[Sig2_plot, Sig2_plot(end)];
%
Gdc3_S = 0.405; Sig3 =0.657;%0.4378;
Gd3S_plot = linspace(0,Gdc3_S,101);

Sig3_plot = Sig3*sqrt(Gd3S_plot/GIc);

Gd3S_plot = [Gd3S_plot, 1];
Sig3_plot =[Sig3_plot, Sig3_plot(end)];
%

Gdc4_S = 0.4075; Sig4 =0.2223;%0.4378;
Gd4S_plot = linspace(0,Gdc4_S,101);

Sig4_plot = Sig4*sqrt(Gd4S_plot/GIc);

Gd4S_plot = [Gd4S_plot, 1];
Sig4_plot =[Sig4_plot, Sig4_plot(end)];

%


Gdc5_S = 0.4095; Sig5 =4.729;%0.4378;
Gd5S_plot = linspace(0,Gdc5_S,21);

Sig5_plot = Sig5*sqrt(Gd5S_plot/GIc);

Gd5S_plot = [Gd5S_plot, 1];
Sig5_plot =[Sig5_plot, Sig5_plot(end)];


bflag =1;
figure
axis([0 .6 0 1.2])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_d/\Gamma_I$';
stry = ' ${\Sigma}_{c,min}\sqrt{h_1/(\bar{E}_1 \Gamma_{{I}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0:.3:1.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1S_plot,Sig1_plot*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd2S_plot,Sig2_plot*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2,'Color', [0 75 135]/255)
plot(Gd3S_plot,Sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd4S_plot,Sig4_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2,'Color', [0 75 135]/255)
% plot(Gd5S_plot,Sig5_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5)

  GGG = [Gd1S_plot(end-1), Gd2S_plot(end-1), Gd3S_plot(end-1), Gd4S_plot(end-1)];
  SSS = [Sig1_plot(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plot(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot(end-1)*(E1bar*GIc/h1)^(-0.5)];
  plot(GGG,SSS,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)
% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.15,0.4,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.45,1.0,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;



 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$',},'Interpreter','latex', 'location', 'northwest', ...
 'FontSize', 15);

export_fig(['Fail_mech_lin_beta',num2str(bflag),h_Fl],'-jpg','-eps', '-r300', '-transparent')


%%
%--------------------------------------------------------------------------
% Failure map OVERALL
% bflag = 4;
%--------------------------------------------------------------------------

 bflag = 4;
%--------------------------------------------------------------------------

% Intersection point
Gdc1_S4TOT = 0.59; Sig14TOT =0.4387; % l/h = 0.45
%Gdc1_S4 = 0.484; Sig14 =1.764;%0.4378;

Gd1S_plot4TOT = linspace(0,Gdc1_S4TOT,101);
Sig1_plot4TOT = Sig14TOT*sqrt(Gd1S_plot4TOT/GIc);
% extra intersection points

G1_list = [ .62, .65, .67, 0.7, 0.8, 0.9, 1, 1.2, 1.5, 2, 2.15 ]; %note 2.15 value at which transition occurs
sig1_list0 = [0.431, 0.4235, .4182, .411 .389 .37 .3535 0.3255 0.2941 .2569, 2*0.124];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G1_list)
sig1_list(j) =sig1_list0(j)*sqrt(G1_list(j)/GIc);
end


Gd1S_plot4TOT = [Gd1S_plot4TOT,G1_list, 2.5];
Sig1_plot4TOT =[Sig1_plot4TOT, sig1_list, sig1_list(end)];




% Intersection point
Gdc2_S4TOT = 0.4885; Sig24TOT =1.141; % l/h = 0.4
%Gdc2_S4 = 0.45; Sig24 =1.126;

Gd2S_plot4TOT = linspace(0,Gdc2_S4TOT,101);

Sig2_plot4TOT = Sig24TOT*sqrt(Gd2S_plot4TOT/GIc);

% extra intersection points

G2_list = [  0.5, 0.55, .61, 0.65, .7, .8 ];
sig2_list0 = [1.131, 1.0845, 1.034, 1.0035, 0.9687, 0.9075];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G2_list)
sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
end

Gd2S_plot4TOT = [Gd2S_plot4TOT G2_list 2.5];
Sig2_plot4TOT =[Sig2_plot4TOT, sig2_list, Sig2_plot4TOT(end)];


% Intersection point
%Gdc3_S4 = 0.4085; Sig34 =0.7765;%0.4378;
Gdc3_S4TOT = 0.424; Sig34TOT =1.94;%0.4378; % l/h = 0.15

Gd3S_plot4TOT = linspace(0,Gdc3_S4TOT,101);

Sig3_plot4TOT = Sig34TOT*sqrt(Gd3S_plot4TOT/GIc);
% extra intersection points

G3_list = [.45, .46, .47];
sig3_list0 = [1.885, 1.865, 1.8455];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end

Gd3S_plot4TOT = [Gd3S_plot4TOT G3_list 2.5];
Sig3_plot4TOT =[Sig3_plot4TOT, sig3_list, Sig3_plot4TOT(end)];

% Intersection point
%Gdc4_S4 = 0.4075; Sig44 =0.6239;%0.4378;
Gdc4_S4TOT = 0.415; Sig44TOT =2.424;%0.4378; % l/h = 0.15

Gd4S_plot4TOT = linspace(0,Gdc4_S4TOT,101);

Sig4_plot4TOT = Sig44TOT*sqrt(Gd4S_plot4TOT/GIc);


Gd4S_plot4TOT = [Gd4S_plot4TOT 2.5];
Sig4_plot4TOT =[Sig4_plot4TOT,  Sig4_plot4TOT(end)];

% Intersection point
%Gdc5_S4 = 0.419; Sig54 =0.5551;%0.4378;
Gdc5_S4TOT = 0.41; Sig54TOT =2.645;%0.4378; % l/h = 0.15

Gd5S_plot4TOT = linspace(0,Gdc5_S4TOT,101);

Sig5_plot4TOT = Sig54TOT*sqrt(Gd5S_plot4TOT/GIc);


Gd5S_plot4TOT = [Gd5S_plot4TOT 2.5];
Sig5_plot4TOT =[Sig5_plot4TOT,  Sig5_plot4TOT(end)];

%%bflag =4;
figure
axis([0 2.5 0 2])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_d/\Gamma_I$';
stry = ' ${\sigma}_{c,min}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{I}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0.0:.4:2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

set(gca,'YTickLabel',{'0','0.2','0.4','0.6','0.8','1'})


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1S_plot4TOT,Sig1_plot4TOT*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd2S_plot4TOT,Sig2_plot4TOT*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2,'Color', [0 75 135]/255)
plot(Gd3S_plot4TOT,Sig3_plot4TOT*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd4S_plot4TOT,Sig4_plot4TOT*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd5S_plot4TOT,Sig5_plot4TOT*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5,'Color', [0 75 135]/255)

  GGG = [Gdc1_S4TOT, Gdc2_S4TOT,Gdc3_S4TOT, Gd1S_plot4TOT(end-1), Gd2S_plot4TOT(end-1), Gd3S_plot4TOT(end-1), Gd4S_plot4TOT(end-1), Gd5S_plot4TOT(end-1)];
  SSS = [ Sig14TOT*sqrt(Gdc1_S4TOT/GIc)*(E1bar*GIc/h1)^(-0.5),Sig24TOT*sqrt(Gdc2_S4TOT/GIc)*(E1bar*GIc/h1)^(-0.5), ...
      Sig34TOT*sqrt(Gdc3_S4TOT/GIc)*(E1bar*GIc/h1)^(-0.5),Sig1_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5)];
  plot(GGG,SSS,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)
% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.64,1.35,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.14,0.09,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.82,.4,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;


 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

export_fig(['Fail_mech_TOT_beta',num2str(bflag),h_Fl],'-jpg', '-r300', '-transparent')


%% Function of E2/E1

bflag =4;
figure
axis([0 1 0 10])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_{{dc}}/\Gamma_{{Ic}}$';
stry = ' $\bar{E}_2/\bar{E}_1$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.0:1:2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
set(gca, 'YScale', 'log')

tt = text(0.62,1.75,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.15,1.5,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.62,0.15,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;
%set(gca,'YTickLabel',{'0','0.5','1'})

GGG = [Gdc1_S4TOT, Gdc2_S4TOT,Gdc3_S4TOT, Gd1S_plot4TOT(end-1), Gd2S_plot4TOT(end-1), Gd3S_plot4TOT(end-1), Gd4S_plot4TOT(end-1), Gd5S_plot4TOT(end-1)];

E2E1pl = [E2E1(1), E2E1(2), E2E1(3), E2E1(1), E2E1(2), E2E1(3), E2E1(4), E2E1(5)];

  
  plot(GGG,E2E1pl,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)

%%

%-------------------------------------------------------------------------
%%
%--------------------------------------------------------------------------
% Failure map for total part of the stress Sigma(0)
% bflag = 1;
%--------------------------------------------------------------------------


% Intersection point
Gdc1_STOT = 0.425; Sig1TOT =2.339;%0.4378;
Gd1S_plotTOT = linspace(0,Gdc1_STOT,51);

Sig1_plotTOT = Sig1TOT*sqrt(Gd1S_plotTOT/GIc);

Gd1S_plotTOT = [Gd1S_plotTOT, 1];
Sig1_plotTOT =[Sig1_plotTOT, Sig1_plotTOT(end)];

%
Gdc2_STOT = 0.45; Sig2TOT =2.029;%0.4378;
Gd2S_plotTOT = linspace(0,Gdc2_STOT,51);

Sig2_plotTOT = Sig2TOT*sqrt(Gd2S_plotTOT/GIc);

Gd2S_plotTOT = [Gd2S_plotTOT, 1];
Sig2_plotTOT =[Sig2_plotTOT, Sig2_plotTOT(end)];
%
Gdc3_STOT = 0.48; Sig3TOT =1.657;%0.4378;
Gd3S_plotTOT = linspace(0,Gdc3_STOT,21);

Sig3_plotTOT = Sig3TOT*sqrt(Gd3S_plotTOT/GIc);

Gd3S_plotTOT = [Gd3S_plotTOT, 1];
Sig3_plotTOT =[Sig3_plotTOT, Sig3_plotTOT(end)];
%

Gdc4_STOT = 0.495; Sig4TOT =1.447;%0.4378;
Gd4S_plotTOT = linspace(0,Gdc4_STOT,51);

Sig4_plotTOT = Sig4TOT*sqrt(Gd4S_plotTOT/GIc);

Gd4S_plotTOT = [Gd4S_plotTOT, 1];
Sig4_plotTOT =[Sig4_plotTOT, Sig4_plotTOT(end)];

%

Gdc5_STOT = 0.5; Sig5TOT =1.349;%0.4378;
Gd5S_plotTOT = linspace(0,Gdc5_STOT,51);

Sig5_plotTOT = Sig5TOT*sqrt(Gd5S_plotTOT/GIc);

Gd5S_plotTOT = [Gd5S_plotTOT, 1];
Sig5_plotTOT =[Sig5_plotTOT, Sig5_plotTOT(end)];

% Failure map graph
bflag =1;
figure
axis([0 .6 0.4 1.6])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_d/\Gamma_I$';
stry = ' ${\sigma}_{c,min}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{I}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0.4:.6:1.6);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

set(gca,'YTickLabel',{'0.2','0.5','0.8'})

 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1S_plotTOT,Sig1_plotTOT*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd2S_plotTOT,Sig2_plotTOT*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2,'Color', [0 75 135]/255)
plot(Gd3S_plotTOT,Sig3_plotTOT*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd4S_plotTOT,Sig4_plotTOT*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd5S_plotTOT,Sig5_plotTOT*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5,'Color', [0 75 135]/255)

  GGG = [Gd1S_plotTOT(end-1), Gd2S_plotTOT(end-1), Gd3S_plotTOT(end-1), Gd4S_plotTOT(end-1), Gd5S_plotTOT(end-1)];
  SSS = [Sig1_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5)];
 % plot(GGG,SSS,'o','MarkerFaceColor','Color', [0 75 135]/255, 'MarkerEdgeColor' ,'k')
   plot(GGG,SSS,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)

% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.48,1.5,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.07,1.0,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

% tt = text(0.62,0.27,['Mech. 2'],'Interpreter','latex');
%tt.FontSize = 17;


 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northwest', ...
 'FontSize', 15);

export_fig(['Fail_mech_TOT_beta',num2str(bflag),h_Fl],'-jpg', '-r300', '-transparent')

%% Function of E2/E1

bflag =4;
figure
axis([0 1 0 10])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_{{dc}}/\Gamma_{{Ic}}$';
stry = ' $\bar{E}_2/\bar{E}_1$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.0:1:2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
set(gca, 'YScale', 'log')

tt = text(0.62,1.75,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.15,1.5,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.62,0.15,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;
%set(gca,'YTickLabel',{'0','0.5','1'})

  GGG = [Gd1S_plotTOT(end-1), Gd2S_plotTOT(end-1), Gd3S_plotTOT(end-1), Gd4S_plotTOT(end-1), Gd5S_plotTOT(end-1)];

E2E1pl = [E2E1(1), E2E1(2), E2E1(3), E2E1(4), E2E1(5)];

  
  plot(GGG,E2E1pl,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)




%%

bflag =4;
figure
axis([0 1 0 10])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_{{dc}}/\Gamma_{{Ic}}$';
stry = ' $\bar{E}_2/\bar{E}_1$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.0:1:2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
set(gca, 'YScale', 'log')

tt = text(0.62,1.75,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.15,1.5,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.62,0.15,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;
%set(gca,'YTickLabel',{'0','0.5','1'})

GGG = [Gdc1_S4TOT, Gdc2_S4TOT,Gdc3_S4TOT, Gd1S_plot4TOT(end-1), Gd2S_plot4TOT(end-1), Gd3S_plot4TOT(end-1), Gd4S_plot4TOT(end-1), Gd5S_plot4TOT(end-1)];

E2E1pl = [E2E1(1), E2E1(2), E2E1(3), E2E1(1), E2E1(2), E2E1(3), E2E1(4), E2E1(5)];

  
  plot(GGG,E2E1pl,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)


%%
% construct fail strength for mechanism 1 for beta = 0.3 and beta = 3

SSS_beta03 = [2.216*sqrt(0.41), 1.843*sqrt(0.46), 1.456*sqrt(0.47), 1.322*sqrt(0.42), 1.204*sqrt(0.43)];

SSS_beta3 = [0.538*sqrt(0.5), 0.4478*sqrt(0.5) ,0.406*sqrt(0.515)];



%%
%

 % Failure map graph
bflag =4;
figure
axis([0 .8 0.05 .35])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_d/\Gamma_I$';
stry = ' ${\sigma}_{1c,min}(0)\sqrt{h_1/(\bar{E}_1 G_{{Ic}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0.05:.1:0.35);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1S_plot4TOT,Sig1_plot4TOT*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2)
 plot(Gd2S_plot4TOT,Sig2_plot4TOT*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2)
plot(Gd3S_plot4TOT,Sig3_plot4TOT*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(Gd4S_plot4TOT,Sig4_plot4TOT*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2)
 plot(Gd5S_plot4TOT,Sig5_plot4TOT*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5)

  GGG = [Gd1S_plot4TOT(end-1), Gd2S_plot4TOT(end-1), Gd3S_plot4TOT(end-1), Gd4S_plot4TOT(end-1), Gd5S_plot4TOT(end-1)];
  SSS = [Sig1_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5)];
  plot(GGG,SSS,'o','MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k')
% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.62,0.07,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.24,0.18,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.62,0.27,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;


 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northwest', ...
 'FontSize', 15);

export_fig(['Fail_mech_TOT_beta',num2str(bflag),h_Fl],'-jpg','-eps', '-r300', '-transparent')
%%
%

 