% Failure mechanism for total stress
%-------------------------------------------------------------------------
% bflag = 1;

GIc =1;
h1 = 1;

h_Fl ='h2_10';
E1 = 1;
nu1 = 0.3;


% Plane strain quantities

E1bar = E1/(1-nu1^2);

% Intersection point

% Intersection point
Gdc1 = 0.0962; sig1 =0.5028;
Gd1_plot = linspace(0,Gdc1,101);

sig1_plot = sig1*sqrt(Gd1_plot/GIc);

% extra intersection points
%G1_list = [.1, .15, 0.2,0.25, .35, .45, 0.5, .6, .7];
%sig1_list0 = [0.995,0.8715, 0.7825, .715,.6105, .557, 0.531, 0.489, 0.455 ];

G1_list = [0.1, 0.125, 0.15, 0.175, 0.2, 0.25 ,0.3 ,  .4, 0.5, 0.6 ,0.7 ];   
sig1_list0 = [0.4974, 0.464, 0.436, 0.4115, 0.391, 0.3575, 0.3315, 0.2923,0.2651 , 0.245, .2275];

for j =1:length(G1_list)
sig1_list(j) =sig1_list0(j)*sqrt(G1_list(j)/GIc);
end

Gd1_plot = [Gd1_plot, G1_list, 1];
sig1_plot =[sig1_plot, sig1_list, sig1_list(end)];

%----------
%E2E1=.3

% Intersection point
Gdc2 = 0.1375; sig2 =0.8137;


Gd2_plot = linspace(0,Gdc2,101);
sig2_plot = sig2*sqrt(Gd2_plot/GIc);

% extra intersection points

G2_list = [0.14 ,0.15,0.175, 0.2, 0.225, 0.25, 0.3, 0.35, 0.4, 0.45];
sig2_list0 = [.809, .795, .7605, .7277,.6975,.67, .6225,  .5825, .548, .519,  ];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G2_list)
sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
end


Gd2_plot = [Gd2_plot,G2_list, 1];
sig2_plot =[sig2_plot, sig2_list, sig2_list(end)];

%----------

%E2E1=1

% Intersection point
Gdc3 = 0.22; sig3 = .9719;

Gd3_plot = linspace(0,Gdc3,101);
sig3_plot = sig3*sqrt(Gd3_plot/GIc);

% extra intersection points
G3_list = [0.23, 0.25, .275 0.3, 0.35 ];
sig3_list0 = [.9627,.945, .921, .895, .843 ];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end



Gd3_plot = [Gd3_plot, G3_list, 1];
sig3_plot =[sig3_plot, sig3_list, sig3_list(end)];

%----------

%E2E1=3

% % Intersection point
Gdc4 = 0.31; sig4 =1.026; 
Gd4_plot = linspace(0,Gdc4,101);
sig4_plot = sig4*sqrt(Gd4_plot/GIc);

% extra intersection points
G4_list = [ 0.315,0.325, .35, 0.375];
sig4_list0 = [1.023, 1.019, 1.003, .982 ];
%0.5,, 0.785
for j =1:length(G4_list)
sig4_list(j) =sig4_list0(j)*sqrt(G4_list(j)/GIc);
end



Gd4_plot = [Gd4_plot, G4_list, 1];
sig4_plot =[sig4_plot,  sig4_list, sig4_list(end)];

%E2E1=10

% Intersection point
Gdc5 = 0.395; sig5 =1.045;

Gd5_plot = linspace(0,Gdc5,101);
sig5_plot = sig5*sqrt(Gd5_plot/GIc);


% extra intersection points
%G5_list = [ 0.5 ];
%sig5_list0 = [ 0.724];
%0.5,, 0.785
%for j =1:length(G5_list)
%sig5_list(j) =sig5_list0(j)*sqrt(G5_list(j)/GIc);
%end
Gd5_plot = [Gd5_plot,  1];
sig5_plot =[sig5_plot,  sig5_plot(end)];

% Failure map graph

figure
axis([0 .6 0 .75])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$G_{{dc}}/G_{{Ic}}$';
stry = ' ${\sigma}_{c,min}(0)\sqrt{h_1/(\bar{E}_1 G_{{Ic}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0:.25:.75);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1_plot,sig1_plot*(E1bar*GIc/h1)^(-0.5),'-','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd2_plot,sig2_plot*(E1bar*GIc/h1)^(-0.5),'--','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd3_plot,sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd4_plot,sig4_plot*(E1bar*GIc/h1)^(-0.5),':','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd5_plot,sig5_plot*(E1bar*GIc/h1)^(-0.5),':','LineWidth', 3,'Color', [0 75 135]/255)
 % Transition Points
 GGG = [Gdc1, Gdc2, Gdc3, Gdc4, Gdc5];
 SIG = [sig1, sig2, sig3, sig4, sig5];
 for j = 1:length(GGG)
     SSS(j) = SIG(j)*sqrt(GGG(j))*(E1bar*GIc/h1)^(-0.5);
 end
%SSS(1)= SSS(1)-corS;
%GGG(2)=GGG(2)+corG;
  plot(GGG,SSS,'o','MarkerFaceColor',  [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)

 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

 tt = text(0.05,0.87/2,['Mech. 3'],'Interpreter','latex');
 tt.FontSize = 17;
% 
  tt = text(0.48,1.32/2,['Mech. 1'],'Interpreter','latex');
 tt.FontSize = 17;
% 
  tt = text(0.43,0.75/2,['Mech. 2'],'Interpreter','latex');
 tt.FontSize = 17;
% 
  lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
 '$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
  'FontSize', 15);

export_fig(['Fail_mech_h2_10_full_beta01'],'-jpg','-eps', '-r300', '-transparent')

%%

% Failure mechanism for total stress
%-------------------------------------------------------------------------
% bflag = 4;

GIc =1;
h1 = 1;

h_Fl ='h2_10';
E1 = 1;
nu1 = 0.3;


% Plane strain quantities

E1bar = E1/(1-nu1^2);

% Intersection point

% Intersection point
Gdc1 = 0.096; sig1 =0.9957;
Gd1_plot = linspace(0,Gdc1,101);

sig1_plot = sig1*sqrt(Gd1_plot/GIc);

% extra intersection points
%G1_list = [.1, .15, 0.2,0.25, .35, .45, 0.5, .6, .7];
%sig1_list0 = [0.995,0.8715, 0.7825, .715,.6105, .557, 0.531, 0.489, 0.455 ];

G1_list = [0.1, 0.11, 0.125 0.15 0.175 0.2,0.25 0.3, 0.4 0.5 0.55 .6 .73];    
sig1_list0 = [.985, .958,  .919, .8628, 1.629/2 1.547/2 1.415/2 1.312/2 1.16/2 1.05/2 1.005/2 0.484 .4401];

for j =1:length(G1_list)
sig1_list(j) =sig1_list0(j)*sqrt(G1_list(j)/GIc);
end

Gd1_plot = [Gd1_plot, G1_list, 1];
sig1_plot =[sig1_plot, sig1_list, sig1_list(end)];

%----------
%E2E1=.3

% Intersection point
Gdc2 = 0.1375; sig2 =2.44/2;


Gd2_plot = linspace(0,Gdc2,101);
sig2_plot = sig2*sqrt(Gd2_plot/GIc);

% extra intersection points

G2_list = [0.14 0.16 0.18 0.2 0.25 .3, 0.4  0.5];
sig2_list0 = [2.435 2.35  2.275 2.2 2.03 1.89 1.67 1.505]/2;
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G2_list)
sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
end


Gd2_plot = [Gd2_plot,G2_list, 1];
sig2_plot =[sig2_plot, sig2_list, sig2_list(end)];

%----------

%E2E1=1

% Intersection point
Gdc3 = 0.224; sig3 = 2.685/2;

Gd3_plot = linspace(0,Gdc3,101);
sig3_plot = sig3*sqrt(Gd3_plot/GIc);

% extra intersection points
G3_list = [.225,  0.25, 0.275 ,0.3 , 0.35, 0.4  .41];
sig3_list0 = [2.683/2 2.631/2 2.5655/2 2.503/2 2.37/2 2.235/2 1.102];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end



Gd3_plot = [Gd3_plot, G3_list, 1];
sig3_plot =[sig3_plot, sig3_list, sig3_list(end)];

%----------

%E2E1=3

% % Intersection point
Gdc4 = 0.315; sig4 =2.769/2; 
Gd4_plot = linspace(0,Gdc4,101);
sig4_plot = sig4*sqrt(Gd4_plot/GIc);

% extra intersection points
G4_list = [ 0.325, .35, 0.375, 0.42];
sig4_list0 = [2.7685,2.7355, 2.6925, 2.577]/2;
%0.5,, 0.785
for j =1:length(G4_list)
sig4_list(j) =sig4_list0(j)*sqrt(G4_list(j)/GIc);
end



Gd4_plot = [Gd4_plot, G4_list, 1];
sig4_plot =[sig4_plot,  sig4_list, sig4_list(end)];

%E2E1=10

% Intersection point
Gdc5 = 0.4; sig5 =2.801/2;

Gd5_plot = linspace(0,Gdc5,101);
sig5_plot = sig5*sqrt(Gd5_plot/GIc);


% extra intersection points
G5_list = [ 0.44 ];
sig5_list0 = [ 1.373];
%0.5,, 0.785
for j =1:length(G5_list)
    sig5_list(j) =sig5_list0(j)*sqrt(G5_list(j)/GIc);
end
Gd5_plot = [Gd5_plot, G5_list  1];
sig5_plot =[sig5_plot, sig5_list  sig5_list(end)];

% Failure map graph

figure
axis([0 1 0 1])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_{{d}}/\Gamma_{{I}}$';
stry = ' ${\sigma}_{c,min}^{\infty,\alpha}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{I}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0:.3:.9);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1_plot,sig1_plot*(E1bar*GIc/h1)^(-0.5),'-','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd2_plot,sig2_plot*(E1bar*GIc/h1)^(-0.5),'--','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd3_plot,sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0 75 135]/255)
  plot(Gd4_plot,sig4_plot*(E1bar*GIc/h1)^(-0.5),':','LineWidth', 2,'Color', [0 75 135]/255)
  plot(Gd5_plot,sig5_plot*(E1bar*GIc/h1)^(-0.5),':','LineWidth', 3,'Color', [0 75 135]/255)
%  % Transition Points
  GGG = [Gdc1, G1_list(end) Gdc2, G2_list(end) Gdc3, G3_list(end) Gdc4, G4_list(end) Gdc5 G5_list(end)];
  SIG = [sig1, sig1_list0(end), sig2, sig2_list0(end), sig3, sig3_list0(end), sig4, sig4_list0(end), sig5 sig5_list0(end)];
  for j = 1:length(GGG)
      SSS(j) = SIG(j)*sqrt(GGG(j))*(E1bar*GIc/h1)^(-0.5);
  end
  
% %SSS(1)= SSS(1)-corS;
% %GGG(2)=GGG(2)+corG;
   plot(GGG,SSS,'o','MarkerFaceColor',  [0 75 135]/255, 'MarkerEdgeColor', [0 75 135]/255)

 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

 tt = text(0.025,1.4/2,['Mech. 3'],'Interpreter','latex');
 tt.FontSize = 17;
% 
  tt = text(0.7,0.43,['Mech. 1'],'Interpreter','latex');
 tt.FontSize = 17;
% 
  tt = text(0.3,0.22,['Mech. 2'],'Interpreter','latex');
 tt.FontSize = 17;
% 
  lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
 '$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
  'FontSize', 15);

export_fig(['Fail_mech_h2_10_full_beta10'],'-jpg','-eps', '-r300', '-transparent')
%%
%
% Gdc2_S = 0.14; Sig2 =0.8391;%0.4378;
% Gd2S_plot = linspace(0,Gdc2_S,21);
% 
% Sig2_plot = Sig2*sqrt(Gd2S_plot/GIc);
% 
% Gd2S_plot = [Gd2S_plot, 1];
% Sig2_plot =[Sig2_plot, Sig2_plot(end)];
%
% Gdc3_S = 0.237; Sig3 =0.7679;%0.4378;
% Gd3S_plot = linspace(0,Gdc3_S,21);
% 
% Sig3_plot = Sig3*sqrt(Gd3S_plot/GIc);
% 
% Gd3S_plot = [Gd3S_plot, 1];
% Sig3_plot =[Sig3_plot, Sig3_plot(end)];
% %

% Gdc4_S = 0.36; 
% Sig4 =0.7464;%0.4378;
% Gd4S_plot = linspace(0,Gdc4_S,21);
% 
% Sig4_plot = Sig4*sqrt(Gd4S_plot/GIc);
% 
% Gd4S_plot = [Gd4S_plot, 1];
% Sig4_plot =[Sig4_plot, Sig4_plot(end)];

%

% Gdc5_S = 0.4685; Sig5 =0.7466;%0.7382
% Gd5S_plot = linspace(0,Gdc5_S,21);
% 
% Sig5_plot = Sig5*sqrt(Gd5S_plot/GIc);
% 
% Gd5S_plot = [Gd5S_plot, 1];
% Sig5_plot =[Sig5_plot, Sig5_plot(end)];
%%
% Intersection point
Gdc1_S4 = 0.565; Sig14 =1.681;
%Gdc1_S4 = 0.484; Sig14 =1.764;%0.4378;

Gd1S_plot4 = linspace(0,Gdc1_S4,21);

Sig1_plot4 = Sig14*sqrt(Gd1S_plot4/GIc);


Gd1S_plot4 = [Gd1S_plot4 1];
Sig1_plot4 =[Sig1_plot4,  Sig1_plot4(end)];

%%
% Failure map graph

figure
axis([0 .5 0.1 0.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$G_{{dc}}/G_{{Ic}}$';
stry = ' $\bar{\sigma}_{1c,min}(0)\sqrt{h_1/(\bar{E}_1 G_{{Ic}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',.1:.2:.9);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
plot(Gd1S_plot,Sig1_plot*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2)
 plot(Gd2S_plot,Sig2_plot*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2)
plot(Gd3S_plot,Sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(Gd4S_plot,Sig4_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2)
 plot(Gd5S_plot,Sig5_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5)

  GGG = [Gd1S_plot(end-1), Gd2S_plot(end-1), Gd3S_plot(end-1), Gd4S_plot(end-1), Gd5S_plot(end-1)];
  SSS = [Sig1_plot(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plot(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig5_plot(end-1)*(E1bar*GIc/h1)^(-0.5)];
  plot(GGG,SSS,'o','MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k')
  
   lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
 'FontSize', 15);

export_fig(['Fail_mech_TOT_beta',num2str(1),h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% bflag 4

% Intersection point
Gdc1_S4 = 0.565; Sig14 =1.681;
%Gdc1_S4 = 0.484; Sig14 =1.764;%0.4378;

Gd1S_plot4 = linspace(0,Gdc1_S4,21);

Sig1_plot4 = Sig14*sqrt(Gd1S_plot4/GIc);


Gd1S_plot4 = [Gd1S_plot4 1];
Sig1_plot4 =[Sig1_plot4,  Sig1_plot4(end)];



% Intersection point
Gdc2_S4 = 0.55; Sig24 =1.064;
%Gdc2_S4 = 0.45; Sig24 =1.126;

Gd2S_plot4 = linspace(0,Gdc2_S4,21);

Sig2_plot4 = Sig24*sqrt(Gd2S_plot4/GIc);


Gd2S_plot4 = [Gd2S_plot4 1];
Sig2_plot4 =[Sig2_plot4,  Sig2_plot4(end)];


% Intersection point
%Gdc3_S4 = 0.4085; Sig34 =0.7765;%0.4378;
Gdc3_S4 = 0.5; Sig34 =0.7254;%0.4378;

Gd3S_plot4 = linspace(0,Gdc3_S4,21);

Sig3_plot4 = Sig34*sqrt(Gd3S_plot4/GIc);


Gd3S_plot4 = [Gd3S_plot4 1];
Sig3_plot4 =[Sig3_plot4,  Sig3_plot4(end)];

% Intersection point
%Gdc4_S4 = 0.4075; Sig44 =0.6239;%0.4378;
Gdc4_S4 = 0.4685; Sig44 =0.5928;%0.4378;

Gd4S_plot4 = linspace(0,Gdc4_S4,21);

Sig4_plot4 = Sig44*sqrt(Gd4S_plot4/GIc);


Gd4S_plot4 = [Gd4S_plot4 1];
Sig4_plot4 =[Sig4_plot4,  Sig4_plot4(end)];

% Intersection point
%Gdc5_S4 = 0.419; Sig54 =0.5551;%0.4378;
Gdc5_S4 = 0.455; Sig54 =0.5388;%0.4378;

Gd5S_plot4 = linspace(0,Gdc5_S4,21);

Sig5_plot4 = Sig54*sqrt(Gd5S_plot4/GIc);


Gd5S_plot4 = [Gd5S_plot4 1];
Sig5_plot4 =[Sig5_plot4,  Sig5_plot4(end)];


%% ---------------------------------------------------------------------------



% sigma_tun = sigma_tun_c + sigma_tun_l;
% Failure map for linear part of the stress Sigma
% bflag = 4;





% Intersection point
Gdc1_S4 = 0.565; Sig14 =1.681;
%Gdc1_S4 = 0.484; Sig14 =1.764;%0.4378;

Gd1S_plot4 = linspace(0,Gdc1_S4,21);

Sig1_plot4 = Sig14*sqrt(Gd1S_plot4/GIc);


Gd1S_plot4 = [Gd1S_plot4 1];
Sig1_plot4 =[Sig1_plot4,  Sig1_plot4(end)];



% Intersection point
Gdc2_S4 = 0.55; Sig24 =1.064;
%Gdc2_S4 = 0.45; Sig24 =1.126;

Gd2S_plot4 = linspace(0,Gdc2_S4,21);

Sig2_plot4 = Sig24*sqrt(Gd2S_plot4/GIc);


Gd2S_plot4 = [Gd2S_plot4 1];
Sig2_plot4 =[Sig2_plot4,  Sig2_plot4(end)];


% Intersection point
%Gdc3_S4 = 0.4085; Sig34 =0.7765;%0.4378;
Gdc3_S4 = 0.5; Sig34 =0.7254;%0.4378;

Gd3S_plot4 = linspace(0,Gdc3_S4,21);

Sig3_plot4 = Sig34*sqrt(Gd3S_plot4/GIc);


Gd3S_plot4 = [Gd3S_plot4 1];
Sig3_plot4 =[Sig3_plot4,  Sig3_plot4(end)];

% Intersection point
%Gdc4_S4 = 0.4075; Sig44 =0.6239;%0.4378;
Gdc4_S4 = 0.4685; Sig44 =0.5928;%0.4378;

Gd4S_plot4 = linspace(0,Gdc4_S4,21);

Sig4_plot4 = Sig44*sqrt(Gd4S_plot4/GIc);


Gd4S_plot4 = [Gd4S_plot4 1];
Sig4_plot4 =[Sig4_plot4,  Sig4_plot4(end)];

% Intersection point
%Gdc5_S4 = 0.419; Sig54 =0.5551;%0.4378;
Gdc5_S4 = 0.455; Sig54 =0.5388;%0.4378;

Gd5S_plot4 = linspace(0,Gdc5_S4,21);

Sig5_plot4 = Sig54*sqrt(Gd5S_plot4/GIc);


Gd5S_plot4 = [Gd5S_plot4 1];
Sig5_plot4 =[Sig5_plot4,  Sig5_plot4(end)];


%%

% bflag = 1;


% Intersection point
Gdc1_S = 0.385; Sig1 =8.492;%0.4378;
Gd1S_plot = linspace(0,Gdc1_S,21);

Sig1_plot = Sig1*sqrt(Gd1S_plot/GIc);

Gd1S_plot = [Gd1S_plot, 1];
Sig1_plot =[Sig1_plot, Sig1_plot(end)];

%
Gdc2_S = 0.395; Sig2 =7.233;%0.4378;
Gd2S_plot = linspace(0,Gdc2_S,21);

Sig2_plot = Sig2*sqrt(Gd2S_plot/GIc);

Gd2S_plot = [Gd2S_plot, 1];
Sig2_plot =[Sig2_plot, Sig2_plot(end)];
%
Gdc3_S = 0.405; Sig3 =5.845;%0.4378;
Gd3S_plot = linspace(0,Gdc3_S,21);

Sig3_plot = Sig3*sqrt(Gd3S_plot/GIc);

Gd3S_plot = [Gd3S_plot, 1];
Sig3_plot =[Sig3_plot, Sig3_plot(end)];
%

Gdc4_S = 0.4075; Sig4 =5.082;%0.4378;
Gd4S_plot = linspace(0,Gdc4_S,21);

Sig4_plot = Sig4*sqrt(Gd4S_plot/GIc);

Gd4S_plot = [Gd4S_plot, 1];
Sig4_plot =[Sig4_plot, Sig4_plot(end)];

%

Gdc5_S = 0.4095; Sig5 =4.729;%0.4378;
Gd5S_plot = linspace(0,Gdc5_S,21);

Sig5_plot = Sig5*sqrt(Gd5S_plot/GIc);

Gd5S_plot = [Gd5S_plot, 1];
Sig5_plot =[Sig5_plot, Sig5_plot(end)];
%%
% Failure map for constant part of the stress
% Failure map
%E2E1=.1;

% Intersection point
Gdc1 = 0.0965; sig1 =1.006;
Gd1_plot = linspace(0,Gdc1,21);

sig1_plot = sig1*sqrt(Gd1_plot/GIc);

% extra intersection points
G1_list = [.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.5, 0.75];
sig1_list0 = [0.995, 0.8715, 0.782, 0.715, 0.663, 0.621, 0.586, 0.53, 0.4437];

for j =1:length(G1_list)
sig1_list(j) =sig1_list0(j)*sqrt(G1_list(j)/GIc);
end

Gd1_plot = [Gd1_plot, G1_list, 1];
sig1_plot =[sig1_plot, sig1_list, sig1_list(end)];


%E2E1=.3

% Intersection point
Gdc2 = 0.1385; sig2 =1.228;
Gd2_plot = linspace(0,Gdc2,21);
sig2_plot = sig2*sqrt(Gd2_plot/GIc);

% extra intersection points
G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .512];
sig2_list0 = [1.2015, 1.155, 1.107,1.0225 , .9515,0.8915, 0.84075, 0.7505];
%0.5,, 0.785
for j =1:length(G2_list)
sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
end


Gd2_plot = [Gd2_plot,G2_list, 1];
sig2_plot =[sig2_plot, sig2_list, sig2_list(end)];

%E2E1=1

% Intersection point
Gdc3 = 0.225; sig3 = 1.349;
Gd3_plot = linspace(0,Gdc3,21);
sig3_plot = sig3*sqrt(Gd3_plot/GIc);

% extra intersection points
G3_list = [0.25, 0.3, 0.35, 0.4, 0.4125 ];
sig3_list0 = [1.323, 1.26, 1.1925,1.125, 1.108];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end



Gd3_plot = [Gd3_plot, G3_list, 1];
sig3_plot =[sig3_plot, sig3_list, sig3_list(end)];

%E2E1=3

% Intersection point
Gdc4 = 0.325; sig4 =1.392; 
Gd4_plot = linspace(0,Gdc4,21);
sig4_plot = sig4*sqrt(Gd4_plot/GIc);

% extra intersection points
G4_list = [ 0.335, 0.345, 0.4 ,0.42 ];
sig4_list0 = [1.3875, 1.38, 1.326, 1.296];
%0.5,, 0.785
for j =1:length(G4_list)
sig4_list(j) =sig4_list0(j)*sqrt(G4_list(j)/GIc);
end



Gd4_plot = [Gd4_plot, G4_list, 1];
sig4_plot =[sig4_plot,  sig4_list, sig4_list(end)];

%E2E1=10

% Intersection point
Gdc5 = 0.405; sig5 =1.408;
Gd5_plot = linspace(0,Gdc5,21);
sig5_plot = sig5*sqrt(Gd5_plot/GIc);


% extra intersection points
G5_list = [ 0.44 ];
sig5_list0 = [ 1.382];
%0.5,, 0.785
for j =1:length(G5_list)
sig5_list(j) =sig5_list0(j)*sqrt(G5_list(j)/GIc);
end



Gd5_plot = [Gd5_plot,  G5_list, 1];
sig5_plot =[sig5_plot,  sig5_list, sig5_list(end)];


figure
axis([0 1 0 1])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\Gamma_{{d}}/\Gamma_{{I}}$';
stry = ' $\bar{\sigma}_{c,min}\sqrt{h_1/(\bar{E}_1 \Gamma_{{I}})}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0:.2:1);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 plot(Gd1_plot,sig1_plot*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd2_plot,sig2_plot*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd3_plot,sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd4_plot,sig4_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2,'Color', [0 75 135]/255)
 plot(Gd5_plot,sig5_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5,'Color', [0 75 135]/255)
 % Transition Points
 GGG = [Gdc1, G1_list(end) Gdc2,  G2_list(end) Gdc3, G3_list(end) Gdc4, Gdc5, G4_list(end),G5_list(end)];
 SIG = [sig1, sig1_list0(end) sig2, sig2_list0(end) sig3,  sig3_list0(end) sig4, sig5, sig4_list0(end),sig5_list0(end)];
 for j = 1:length(GGG)
     SSS(j) = SIG(j)*sqrt(GGG(j))*(E1bar*GIc/h1)^(-0.5);
 end

  plot(GGG,SSS,'o','MarkerFaceColor', [0 75 135]/255, 'MarkerEdgeColor',[0 75 135]/255)
 tt = text(0.05,0.75,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.48,0.72,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.22,0.18,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;

  
 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 13);
  
% export_fig(['Fail_mech',h_Fl],'-jpg','-eps', '-r300', '-transparent')
%%

% Failure mechanism for linear stress
%-------------------------------------------------------------------------
% bflag = 1;

GIc =1;
h1 = 1;

h_Fl ='h2_10';
E1 = 1;
nu1 = 0.3;


% Plane strain quantities

E1bar = E1/(1-nu1^2);

% Intersection point

% Intersection point
Gdc1 = 0.097; sig1 =20.55;
Gd1_plot = linspace(0,Gdc1,21);



sig1_plot = sig1*sqrt(Gd1_plot/GIc);

% extra intersection points
%G1_list = [.1, .15, 0.2,0.25, .35, .45, 0.5, .6, .7];
%sig1_list0 = [0.995,0.8715, 0.7825, .715,.6105, .557, 0.531, 0.489, 0.455 ];

G1_list = [.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45];
sig1_list0 = [20.394, 17.714, 15.7325, 14.263, 13.1285, 12.223, 11.488 ,10.8625 ];

sig1_list = [];
for j =1:length(G1_list)
sig1_list(j) =sig1_list0(j)*sqrt(G1_list(j)/GIc);
end

Gd1_plot = [Gd1_plot, G1_list, 1];
sig1_plot =[sig1_plot, sig1_list, sig1_list(end)];

%----------
% %E2E1=.3
% 
% % Intersection point
% Gdc2 = 0.1385; sig2 =0.8391;
% 
% 
% Gd2_plot = linspace(0,Gdc2,21);
% sig2_plot = sig2*sqrt(Gd2_plot/GIc);
% 
% % extra intersection points
% 
% G2_list = [0.15, 0.2, 0.3,0.4, .5, .6];
% sig2_list0 = [0.826, 0.761, 0.659, 0.586, 0.53, 0.487 ];
% %G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
% %sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
% %0.5,, 0.785
% for j =1:length(G2_list)
% sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
% end
% 
% 
% Gd2_plot = [Gd2_plot,G2_list, 1];
% sig2_plot =[sig2_plot, sig2_list, sig2_list(end)];

%----------

%E2E1=1

% Intersection point
Gdc3 = 0.21; sig3 = 15.64;

Gd3_plot = linspace(0,Gdc3,21);
sig3_plot = sig3*sqrt(Gd3_plot/GIc);

% extra intersection points
G3_list = [.22,  0.25 ,0.3];
sig3_list0 = [15.512 ,15.02, 14.08];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end



Gd3_plot = [Gd3_plot, G3_list, 1];
sig3_plot =[sig3_plot, sig3_list, sig3_list(end)];

%----------

% %E2E1=3
% 
% % Intersection point
% Gdc4 = 0.36; sig4 =0.7464; 
% Gd4_plot = linspace(0,Gdc4,21);
% sig4_plot = sig4*sqrt(Gd4_plot/GIc);
% 
% % extra intersection points
% G4_list = [ 0.37,  0.4 ,0.42 , 0.44, 0.47, .48];
% sig4_list0 = [0.7435, 0.7335, 0.725, 0.716, 0.694, 0.687];
% %0.5,, 0.785
% for j =1:length(G4_list)
% sig4_list(j) =sig4_list0(j)*sqrt(G4_list(j)/GIc);
% end
% 
% 
% 
% Gd4_plot = [Gd4_plot, G4_list, 1];
% sig4_plot =[sig4_plot,  sig4_list, sig4_list(end)];

%E2E1=10

% Intersection point
Gdc5 = 0.35; sig5 =15.04;

Gd5_plot = linspace(0,Gdc5,21);
sig5_plot = sig5*sqrt(Gd5_plot/GIc);


Gd5_plot = [Gd5_plot,  1];
sig5_plot =[sig5_plot,   sig5_plot(end)];



%%
figure
%axis([0 .6 0.15 0.55])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$G_{{dc}}/G_{{Ic}}$';
stry = ' ${\sigma}_{1c,min}(0)\sqrt{h_1/(\bar{E}_1 G_{{Ic}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',.15:.2:.55);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1_plot,sig1_plot*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2)
 %plot(Gd2_plot+corG,sig2_plot*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2)
 plot(Gd3_plot,sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2)
 %plot(Gd4_plot,sig4_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2)
 plot(Gd5_plot,sig5_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3)
 % Transition Points
 GGG = [Gdc1,  Gdc3,  Gdc5];
 SIG = [sig1,  sig3,  sig5];
 for j = 1:length(GGG)
     SSS(j) = SIG(j)*sqrt(GGG(j))*(E1bar*GIc/h1)^(-0.5);
 end
 



  plot(GGG,SSS,'o','MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k')
