MISE Synthetic Dataset
======================

Version 1.0

Gary Doran (Gary.B.Doran.Jr@jpl.nasa.gov)
Kiri L. Wagstaff (Kiri.L.Wagstaff@jpl.nasa.gov)

## Overview

This dataset contains synthetic observations similar to those that will be
produced by the Mapping Imaging Spectrometer for Europa (MISE) instrument. The
dataset was created by taking visible Galileo Solid-State Imaging (SSI)
experiment observations resized to 300x300 pixels, using pixel intensity as a
proxy for albedo, and linearly mixing two 451-channel ice spectra in proportion
to albedo for each pixel.

The contents of this directory include the original SSI images and PDS label
files, rescaled versions of the images, and the spectral cubes in HDF5 format
corresponding to synthetic MISE digital number (DN) measurements. The cube files
contain two datasets, `cube` containing the DN values, and `wavelengths`, which
holds the wavelength in nanometers corresponding to each value in a spectrum.

The dataset was created to evaluate the radiation robustness of the Reed-Xiaoli
(RX) algorithm used for spectral anomaly detection. For the radiation robustness
analysis, only the first 421 channels of the spectra are used.

## Contents

 - **original**: the original JPEG observations and PDS label files
 - **scaled**: rescaled versions of the SSI observations
 - **cubes**: spectral cubes holding the 16-bit digital representations of
   synethetic MISE observations
