d=0.001;
b=1;
a=1/3;
BBar = 1;

%chi2_B_max = 1e-4;
%chi2_B_min = 1e-20;
chi2_B_max = 1e+100;
chi2_B_min = 1e-200;
lambda_min = 1e-26;
lambda_max = 1e-18;

ls = [2,3,4,5];
N = numel(ls);
filenames={...
    '/Users/mattland/Box Sync/work19/20190709-01-regcoilPM_analytic_benchmark/20190709-01-026-coilAspect30_aOverB0.33_n2_ntheta96_nzeta4_nfp128_mpol24_sym/regcoil_out.benchmark.nc', ...
    '/Users/mattland/Box Sync/work19/20190709-01-regcoilPM_analytic_benchmark/20190709-01-027-coilAspect30_aOverB0.33_n3_ntheta96_nzeta4_nfp128_mpol24_sym/regcoil_out.benchmark.nc', ...
    '/Users/mattland/Box Sync/work19/20190709-01-regcoilPM_analytic_benchmark/20190709-01-028-coilAspect30_aOverB0.33_n4_ntheta96_nzeta4_nfp128_mpol24_sym/regcoil_out.benchmark.nc', ...
    '/Users/mattland/Box Sync/work19/20190709-01-regcoilPM_analytic_benchmark/20190709-01-029-coilAspect30_aOverB0.33_n5_ntheta96_nzeta4_nfp128_mpol24_sym/regcoil_out.benchmark.nc'};
    
abs_M_numerical_mean = zeros(N,1);
abs_M_numerical_std = zeros(N,1);
mu0 = 4*pi*(1e-7);
%abs_M_analytic = BBar * b * ((b/a) .^ (ls-1)) ./ (d * mu0 * ls);
b1=b;
b2=b+d;
ns = ls + 1;
abs_M_analytic = BBar * (ns-2)./(mu0 * (ns-1)) .* ((b1/a).^(ns-2)) ./ (1-((b1/b2).^(ns-2)));

for j = 1:numel(ls)
    filename = filenames{j};
    lambda = ncread(filename,'lambda');
    chi2_B = ncread(filename,'chi2_B');
    abs_M = ncread(filename,'abs_M');
    mask = (lambda > lambda_min) & (lambda < lambda_max) & (chi2_B > chi2_B_min) & (chi2_B < chi2_B_max);
    %size(abs_M)
    data = abs_M(:,:,:,mask);
    data = data(:);
    size(data)
    abs_M_numerical_mean(j) = mean(data);
    abs_M_numerical_std(j) = std(data);
end

figure(2)
clf
set(gcf,'color','w')
plot(ls,abs_M_analytic,'o-','displayname','Analytic')
hold on
errorbar(ls,abs_M_numerical_mean,abs_M_numerical_std,'x--','displayname','REGCOIL_PM','markersize',10)
xlabel('Poloidal mode number $\ell$','interpreter','latex','fontsize',16)
title('|M| [Amperes / meter]','fontsize',15)
legend('location','northwest')
set(legend,'fontsize',15,'interpreter','none')
set(gca,'fontsize',16)
xlim([1.6,5.4])
export_fig(['/Users/mattland/Box Sync/work20/',mfilename,'.pdf'])
