theta = linspace(0,2*pi,129);
theta_q = linspace(0,2*pi,65);
a = 1/2;
b=1;
n = 3;

figure(100)
clf
set(gcf,'color','w','position',[131   137   693   420])

scale=0.8;
theta00 = 1.9;

subplot(1,2,2)
plot(a*cos(theta), a*sin(theta), 'r','linewidth',2)
hold on
plot(b*cos(theta), b*sin(theta), 'color',[0,0.7,0],'linewidth',2)
axis equal off
theta0 = theta00;
x = b*cos(theta0);
y = b*sin(theta0);
d=1.5;
plot([x,x+d*sin(theta0)],[y,y-d*cos(theta0)],'color',[0,0.7,0],'linewidth',2)
theta0 = theta0 + pi;
x = b*cos(theta0);
y = b*sin(theta0);
plot([x,x-d*sin(theta0)],[y,y+d*cos(theta0)],'color',[0,0.7,0],'linewidth',2)

theta0 = theta00;
x = a*cos(theta0);
y = a*sin(theta0);
d=0.85;
plot([x,x+d*sin(theta0)],[y,y-d*cos(theta0)],'r','linewidth',2)
theta0 = theta0 + pi;
x = a*cos(theta0);
y = a*sin(theta0);
plot([x,x-d*sin(theta0)],[y,y+d*cos(theta0)],'r','linewidth',2)

x = b*cos(theta_q);
y = b*sin(theta_q);
qx = cos(theta_q) .* cos(n*theta_q);
qy = sin(theta_q) .* cos(n*theta_q);
quiver(x,y,qx,qy,scale,'k')

subplot(1,2,1)
plot(a*cos(theta), a*sin(theta), 'r','linewidth',2)
hold on
plot(b*cos(theta), b*sin(theta), 'color',[0,0.7,0],'linewidth',2)
axis equal off

theta0 = theta00;
x = b*cos(theta0);
y = b*sin(theta0);
d=1.5;
plot([x,x+d*sin(theta0)],[y,y-d*cos(theta0)],'color',[0,0.7,0],'linewidth',2)
theta0 = theta0 + pi;
x = b*cos(theta0);
y = b*sin(theta0);
plot([x,x-d*sin(theta0)],[y,y+d*cos(theta0)],'color',[0,0.7,0],'linewidth',2)

theta0 = theta00;
x = a*cos(theta0);
y = a*sin(theta0);
d=0.85;
plot([x,x+d*sin(theta0)],[y,y-d*cos(theta0)],'r','linewidth',2)
theta0 = theta0 + pi;
x = a*cos(theta0);
y = a*sin(theta0);
plot([x,x-d*sin(theta0)],[y,y+d*cos(theta0)],'r','linewidth',2)


x = b*cos(theta_q);
y = b*sin(theta_q);
qx = cos((n+1)*theta_q);
qy = sin((n+1)*theta_q);
quiver(x,y,qx,qy,scale/2,'k')

plasma_shifty = 0.05;
% Create textbox
annotation(gcf,'textbox',...
    [0.220779220779221 0.339476190476191+plasma_shifty 0.075036075036075 0.0833333333333334],...
    'String',{'plasma','surface'},'edgecolor','none','color','r');


magnet_shiftx = 0.02;
magnet_shifty = -0.03;
% Create textbox
annotation(gcf,'textbox',...
    [0.295372294372294+magnet_shiftx 0.704761904761905+magnet_shifty 0.0754790764790765 0.0666666666666673],...
    'String',{'magnet surface'},...
    'FitBoxToText','off','edgecolor','none','color',[0,0.7,0]);

shift = 0.44;
% Create textbox
annotation(gcf,'textbox',...
    [0.220779220779221+shift 0.339476190476191+plasma_shifty 0.075036075036075 0.0833333333333334],...
    'String',{'plasma','surface'},'edgecolor','none','color','r');

% Create textbox
annotation(gcf,'textbox',...
    [0.295372294372294+shift+magnet_shiftx 0.704761904761905+magnet_shifty 0.0754790764790765 0.0666666666666673],...
    'String',{'magnet surface'},...
    'FitBoxToText','off','edgecolor','none','color',[0,0.7,0]);


% Create textbox
annotation(gcf,'textbox',...
    [0.128860028860029, 0.692857142857144, 0.01, 0.06],...
    'String',{'(a)'},'fontsize',16,'FitBoxToText','off','edgecolor','none');

annotation(gcf,'textbox',...
    [0.558, 0.692857142857144, 0.01, 0.06],...
    'String',{'(b)'},'fontsize',16,'FitBoxToText','off','edgecolor','none');

export_fig(['/Users/mattland/Box Sync/work20/',mfilename,'.pdf'])
