% Note: use "camlight HEADLIGHT" to add extra light.

%wout_filename = '/Users/mattland/Box Sync/work20/wout_c09r00_fixedBoundary_0.5T_vacuum_ns201.nc';
wout_filename = '/Users/mattland/regcoil_pm/equilibria/wout_d23p4_tm.nc';

vv_filename = '/Users/mattland/regcoil_pm/equilibria/nescin.w7x_winding_surface_from_Drevlak';

nfp = double(ncread(wout_filename,'nfp'));
xm = ncread(wout_filename,'xm');
xn = ncread(wout_filename,'xn');
rmnc = ncread(wout_filename,'rmnc');
zmns = ncread(wout_filename,'zmns');

phishift = -pi/5;

Ntheta = 150;
Nphi = 300;
theta1D = linspace(0,2*pi,Ntheta);
phi1D = linspace(0,2*pi,Nphi);
[phi,theta] = meshgrid(phi1D,theta1D);

R = zeros(size(phi));
Z = zeros(size(phi));
for imn = 1:numel(xm)
    angle = xm(imn) * theta - xn(imn) * phi;
    R = R + rmnc(imn,end) * cos(angle);
    Z = Z + zmns(imn,end) * sin(angle);
end
X = R .* cos(phi - phishift);
Y = R .* sin(phi - phishift);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Now read vv file

phi1D = linspace(0,pi,Nphi) - 2*pi/5;
[phi,theta] = meshgrid(phi1D,theta1D);

f = fopen(vv_filename,'r');
while true
    line = fgetl(f);
    if numel(strfind(line,'Current Surface:')) > 0
        break
    end
end
line = fgetl(f);
line = fgetl(f);
NFourier = str2num(line);
line = fgetl(f);
line = fgetl(f);
%for j = 1:NFourier
Rvv = zeros(size(phi));
Zvv = zeros(size(phi));

for j = 1:NFourier
    line = fgetl(f);
    data = sscanf(line,'%f');
    m=data(1);
    n=data(2);
    rmnc=data(3);
    zmns=data(4);
    angle = m * theta + nfp * n * phi;
    Rvv = Rvv + rmnc * cos(angle);
    Zvv = Zvv + zmns * sin(angle);
end
Xvv = Rvv .* cos(phi - phishift);
Yvv = Rvv .* sin(phi - phishift);

separation = 0.25 + 0.1*cos(3*theta);
ROuter = Rvv + separation .* cos(theta);
ZOuter = Zvv + separation .* sin(theta);
XOuter = ROuter .* cos(phi - phishift);
YOuter = ROuter .* sin(phi - phishift);

Xedge = [Xvv(:,1), XOuter(:,1)];
Yedge = [Yvv(:,1), YOuter(:,1)];
Zedge = [Zvv(:,1), ZOuter(:,1)];

Xedge2 = [Xvv(:,end), XOuter(:,end)];
Yedge2 = [Yvv(:,end), YOuter(:,end)];
Zedge2 = [Zvv(:,end), ZOuter(:,end)];

figure(10)
clf
set(gcf,'color','w')
set(gcf,'position',[69          94        1026         604])
green = [0,0.7,0];

h = surf(X, Y, Z,'facecolor','r','edgecolor','none');
set(h,'AmbientStrength',0.6,'DiffuseStrength',0.6);
hold on
h = surf(Xvv, Yvv, Zvv,'facecolor',[0.2,0.2,1],'edgecolor','none');
set(h,'AmbientStrength',0.6,'DiffuseStrength',0.9);
h = surf(XOuter, YOuter, ZOuter,'facecolor',green,'edgecolor','none');
set(h,'AmbientStrength',0.6,'DiffuseStrength',0.6);
h = surf( Xedge,  Yedge,  Zedge,'facecolor',green,'edgecolor','none','facealpha',0.7);
set(h,'AmbientStrength',0.6,'DiffuseStrength',0.6);
h = surf(Xedge2, Yedge2, Zedge2,'facecolor',green,'edgecolor','none','facealpha',0.7);
set(h,'AmbientStrength',0.6,'DiffuseStrength',0.6);
plot3(Xvv(:,1), Yvv(:,1), Zvv(:,1), 'b', 'linewidth',2)
plot3(Xvv(:,end), Yvv(:,end), Zvv(:,end), 'b', 'linewidth',2)
plot3(XOuter(:,1), YOuter(:,1), ZOuter(:,1), 'g', 'linewidth',2)
plot3(XOuter(:,end), YOuter(:,end), ZOuter(:,end), 'g', 'linewidth',2)
%light
daspect([1,1,1])
axis vis3d off
set(gca,'clipping','off')
%zoom(1.6)
camlight HEADLIGHT
lighting gouraud
%set(gca,'CameraTarget',[0.380722686199786 0.508922777091779 1.67938843947946e-05])
set(gca,'CameraTarget',[1.3, 0, -.3])
campos([-35.0530622009616         -50.5986786653049          13.5018353267582])

figure1 = gcf();
myfontsize = 20;
%{
% Create textarrow
annotation(figure1,'textarrow',[0.41130604288499 0.489278752436647],...
    [0.31953642384106 0.360927152317881],'String',{'Plasma surface \it{S}'},'fontsize',myfontsize,'color',[0.5,0,0]);

% Create textarrow
annotation(figure1,'textarrow',[0.815789473684211 0.824561403508772],...
    [0.327814569536424 0.365894039735099],...
    'String',{'Inner magnet surface \it{I}'},'fontsize',myfontsize,'color',[0,0,0.8]);

% Create textarrow
annotation(figure1,'textarrow',[0.844054580896686 0.852826510721247],...
    [0.733443708609272 0.675496688741722],...
    'String',{'Outer magnet surface \it{O}'},'fontsize',myfontsize,'color',[0,0.5,0]);

% Create textarrow
annotation(figure1,'textarrow',[0.930799220272904 0.942495126705653],...
    [0.771523178807947 0.516556291390728],'String',{'Magnetization region'},'fontsize',myfontsize,'color',[0,0.5,0]);
%}

%{
% Create textarrow
annotation(figure1,'textarrow',[0.368421052631579 0.398635477582846],...
    [0.321192052980132 0.339403973509934],'Color',[0.5 0 0],...
    'String',{'Plasma surface \it{S}'},...
    'FontSize',20);

% Create textarrow
annotation(figure1,'textarrow',[0.759259259259258 0.768031189083819],...
    [0.339403973509934 0.377483443708609],'Color',[0 0 0.8],...
    'String',{'Inner magnet surface \it{I}'},...
    'FontSize',20);

% Create textarrow
annotation(figure1,'textarrow',[0.8635477582846 0.87037037037037],...
    [0.753311258278146 0.54635761589404],'Color',[0 0.5 0],...
    'String',{'Magnetization region'},...
    'FontSize',20);

% Create textarrow
annotation(figure1,'textarrow',[0.723196881091618 0.766081871345027],...
    [0.826158940397351 0.701986754966887],'Color',[0 0.5 0],...
    'String',{'Outer magnet surface \it{O}'},...
    'FontSize',20);
%}


% Create textarrow
annotation(figure1,'textarrow',[0.759259259259258 0.768031189083819],...
    [0.344370860927153 0.382450331125828],'Color',[0 0 0.8],...
    'String',{'Inner magnet surface \it{I}'},...
    'FontSize',20);

% Create textarrow
annotation(figure1,'textarrow',[0.730019493177388 0.772904483430797],...
    [0.817880794701987 0.693708609271523],'Color',[0 0.5 0],...
    'String',{'Outer magnet surface \it{O}'},...
    'FontSize',20);

% Create textarrow
annotation(figure1,'textarrow',[0.378167641325536 0.408382066276803],...
    [0.331125827814569 0.349337748344371],'Color',[0.5 0 0],...
    'String',{'Plasma surface \it{S} '},...
    'FontSize',20);

% Create textarrow
annotation(figure1,'textarrow',[0.861598440545808 0.868421052631579],...
    [0.756622516556292 0.549668874172186],'Color',[0 0.5 0],...
    'String',{'Magnetization region \it{V}'},...
    'FontSize',20);

% Create textarrow
annotation(figure1,'textarrow',[0.888888888888889 0.873294346978557],...
    [0.461920529801324 0.470198675496689],'String',{'Thickness \it{d}'},'FontSize',20);

% Create arrow
annotation(figure1,'arrow',[0.839181286549707 0.853801169590643],...
    [0.492377483443709 0.483443708609272]);
rotate3d on

export_fig(['/Users/mattland/Box Sync/work20/',mfilename,'.png'],'-r300')
