function weather_model2sar();
% % interpolate the weather model-based APS from the DEM resolutions to the InSAR observations pixels 
%  
% by Kang Wang on 10/27/2019

fparms='parms_candis.mat';
parms=load(fparms);
currdir=pwd;
coordinates_type=parms.coordinates_type;
x1=parms.x1;
y1=parms.y1;
%day_sar=parms.day_sar;
[date_sar]=textread('dates.dat','%s\n');
day_sar=datenum(date_sar,'yyyymmdd');
nsar=length(day_sar);
dir_weather_model=parms.dir_weather_model;
%inc=parms.inc;
%inc=40;
if strcmp(coordinates_type,'radar');
  [xinc,yinc,inc]=grdread2('inc_ra.grd');
else
  [xinc,yinc,inc]=grdread2('inc_ll.grd');
end

[XINC,YINC]=meshgrid(xinc,yinc);
indx_inc_good=~isnan(inc);
xinc_good=double(XINC(indx_inc_good));
yinc_good=double(YINC(indx_inc_good));
zinc_good=double(inc(indx_inc_good));

[X1,Y1]=meshgrid(x1,y1);
X1=double(X1);
Y1=double(Y1);

inc_out=griddata(xinc_good,yinc_good,zinc_good,X1,Y1);

cmd_str=['mkdir -p ',dir_weather_model];
system(cmd_str);
nsar=length(day_sar);

coordinates_type=parms.coordinates_type;

if strcmp(coordinates_type,'radar')
  str1 = ['_ERA_ra'];
  str2 = ['_ERA_ra_interp'];
else
  str1 = ['_ERA_ll'];
  str2 = ['_ERA_ll_interp'];
end


for k=1:nsar;
  this_day=day_sar(k);
  this_date=datestr(this_day,'yyyymmdd');
  disp(['working on ',this_date, ' [',num2str(k),'/',num2str(nsar),']']);
  [x2,y2,z2]=grdread2([dir_weather_model,'/',this_date,str1,'.grd']);
  [X2,Y2]=meshgrid(x2,y2);
  indx_good=~isnan(z2);
  xin=double(X2(indx_good));
  yin=double(Y2(indx_good));
  zin=double(z2(indx_good));
  zout=griddata(xin,yin,zin,X1,Y1); 
  zout=zout./cosd(inc_out); % project on the line-of-sight
  grdwrite2(x1,y1,zout,[dir_weather_model,'/',this_date,str2,'.grd'])
end
