function unwrap2losin();
% make the 
fparms='parms_candis.mat';
parms=load(fparms);
currdir=pwd;
coordinates_type=parms.coordinates_type;

currdir=pwd;
wavelength=parms.wavelength;
funwrap=parms.unwrap_file;
flos=parms.los_file;
fcorr =parms.corr_file;
isweight = parms.is_weight;
dir_intf=parms.dir_intf;
dir_weather_model = parms.dir_weather_model;

frun=parms.intf_list;

if exist(frun,'file');
    [intf_list]=textread(frun,'%s\n');
    nlist=length(intf_list);
    disp(['Number of Total Interferograms: ',num2str(nlist)]);
    day1_all=zeros(nlist,1);
    day2_all=zeros(nlist,1);
    for k=1:nlist;
        intf_now=intf_list{k};
        date1_now=intf_now(1:8);
        date2_now=intf_now(10:17);
        day1_all(k)=datenum(date1_now,'yyyymmdd');
        day2_all(k)=datenum(date2_now,'yyyymmdd');
    end


else
     error(['intf_list ',frun, 'does not exist.']);
end

for k=1:nlist;
       date1_now=datestr(day1_all(k),'yyyymmdd');
       date2_now=datestr(day2_all(k),'yyyymmdd');
       dir_now=[dir_intf,'/',date1_now,'_',date2_now];

       disp(['loading phase  for        ',date1_now,'_',date2_now,'   [',num2str(k),'/',num2str(nlist),']']);
       if (exist([dir_now,'/',funwrap],'file'));
       [x1,y1,zzin]=grdread2([dir_now,'/',funwrap]);
       zout = -wavelength *zzin/4/pi;
       grdwrite2(x1,y1,zout,[dir_now,'/',flos]);
       else
         disp(['*** Warning: unwrapping file for ', date1_now,'_',date2_now ,' not found !'])
       end
end

[X1,Y1]=meshgrid(x1,y1);
xpixel=X1(:);
ypixel=Y1(:);

% save the coordinates
setparm_candis('x1',x1);
setparm_candis('y1',y1);
setparm_candis('xpixel',xpixel);
setparm_candis('ypixel',ypixel);



