function sbas2grd(iint,fparms);
% write out the grd files from the SBAS results
% Note: The output folder will be determined from the smooth value
%
% Usage: sbas2grd(iint,fparms);
%  
% iint   ---- index of the iteration 
% fparms ---- optional (default is 'parms_candis.mat');
%

if nargin<2;
    fparms='parms_candis.mat';
end
parms=load(fparms);
smooth=parms.smooth;
coordinates_type = parms.coordinates_type;
smooth_name=sprintf('%010.4e',smooth);
dir_out=['SBAS_SMOOTH_',smooth_name];
fsmooth=fopen('smooth.dir','w');
fprintf(fsmooth,'%s\n',dir_out);
fclose(fsmooth);

x1=parms.x1;
y1=parms.y1;
day_sar=parms.day_sar;


nx=length(x1);
ny=length(y1);
day_sar=parms.day_sar;
nsar=length(day_sar);


if (~exist(dir_out,'dir'));
  disp(['Creating folder ',dir_out]);
  mkdir(dir_out);
end
%[xpixel,ypixel,los_out,dh_out,vel_out]=merge_sbas_out(iint,'PATCH.list');
[xpixel,ypixel,los_out,dh_out,vel_out1,vel_out2,vel_out3,amp_out,phs_out]=merge_sbas_out(iint,'PATCH.list');

for k=1:nsar;
   this_day=day_sar(k);
   this_date=datestr(this_day,'yyyymmdd');
   los_this_date=los_out(:,k);
   zthis_date=reshape(los_this_date,ny,nx);
   if strcmp(coordinates_type,'geographic');
       name_this_date=['LOS_',this_date,'_INT',num2str(iint),'_ll.grd'];
   elseif strcmp(coordinates_type,'radar')
      name_this_date=['LOS_',this_date,'_INT',num2str(iint),'.grd'];
   else
     error(['***Unrecognized coordinates_type ',coordinates_type]);
   end
   disp(['writing ', name_this_date]);
   grdwrite2(x1,y1,zthis_date,[dir_out,'/',name_this_date]);
end

vel1_grd=reshape(vel_out1,ny,nx);
vel2_grd=reshape(vel_out2,ny,nx);
vel3_grd=reshape(vel_out3,ny,nx);
dh_grd=reshape(dh_out,ny,nx);
amp_grd=reshape(amp_out,ny,nx);
phs_grd=reshape(phs_out,ny,nx);
if strcmp(coordinates_type,'geographic');
    grdwrite2(x1,y1,vel1_grd,[dir_out,'/','vel1_INT',num2str(iint),'_ll.grd']);
    grdwrite2(x1,y1,vel2_grd,[dir_out,'/','vel2_INT',num2str(iint),'_ll.grd']);
    grdwrite2(x1,y1,vel3_grd,[dir_out,'/','vel3_INT',num2str(iint),'_ll.grd']);
    grdwrite2(x1,y1,dh_grd,[dir_out,'/','dh_INT',num2str(iint),'_ll.grd']);
    grdwrite2(x1,y1,amp_grd,[dir_out,'/','amp_INT',num2str(iint),'_ll.grd']);
    grdwrite2(x1,y1,phs_grd,[dir_out,'/','phs_INT',num2str(iint),'_ll.grd']);
elseif strcmp(coordinates_type,'radar')
   grdwrite2(x1,y1,vel1_grd,[dir_out,'/','vel1_INT',num2str(iint),'.grd']);
   grdwrite2(x1,y1,vel2_grd,[dir_out,'/','vel2_INT',num2str(iint),'.grd']);
   grdwrite2(x1,y1,vel3_grd,[dir_out,'/','vel3_INT',num2str(iint),'.grd']);
   grdwrite2(x1,y1,dh_grd,[dir_out,'/','dh_INT',num2str(iint),'.grd']);
   grdwrite2(x1,y1,amp_grd,[dir_out,'/','amp_INT',num2str(iint),'.grd']);
   grdwrite2(x1,y1,phs_grd,[dir_out,'/','phs_INT',num2str(iint),'.grd']);
else
  error(['***Unrecognized coordinates_type ',coordinates_type]);
end
