function los_out=remove_deformation(day1,day2,day_sar,los_in,los_ts);
%
% remove the deformation from the input interferograms 
% 
% Usage: los_out=remove_deformation(day1,day2,day_sar,los_in,los_ts);
%
% los_ts: time series of the LOS displacements
%
nintf=length(day1);
los_out=zeros(size(los_in),'single');

for k=1:nintf;
  indx1=find(day1(k)==day_sar);
  indx2=find(day2(k)==day_sar);
  dphi=los_ts(:,indx2)-los_ts(:,indx1);
  
  los_out(:,k)=los_in(:,k)-dphi;
end
