function los_out=remove_aps(day1,day2,day_sar,los_in,aps_in);
%
% Usage: los_out=remove_aps(day1,day2,day_sar,los_in,aps_in);
%
% aps_in: time series of the APS
%

nintf=length(day1);
los_out=zeros(size(los_in),'single');

for k=1:nintf;
  indx1=find(day1(k)==day_sar);
  indx2=find(day2(k)==day_sar);
  dphi=aps_in(:,indx2)-aps_in(:,indx1);
  
  los_out(:,k)=los_in(:,k)-dphi;
end
