function plot_vel_ll(nint,smooth,fparms);
% plot out the velocity
%
%  Usage: plot_vel_ll(iint,smooth,fparms);
%
% required argument:  nnint
%
% options: nnint, fparms
%
% by Kang Wang in April. 2018

if (nargin<3);
  fparms='parms_candis.mat';
end

parms=load(fparms);
if (nargin<2);
   smooth = parms.smooth;
end

cmin=parms.cmin;
cmax=parms.cmax;

region_plot = parms.region_plot;


smooth_name=sprintf('%010.4e',smooth);
dir_out=['SBAS_SMOOTH_',smooth_name];

x1=parms.x1;
y1=parms.y1;
nx=length(x1);
ny=length(y1);
day_sar=parms.day_sar;
nsar=length(day_sar);

currdir=pwd;

disp(['Ploting velocity from ',dir_out]);

grdin=[dir_out,'/','vel_INT',num2str(nint),'_ll.grd'];
[x1,y1,z1]=grdread2(grdin);
velout=1000*z1;

if (length(region_plot)>3);
  region=region_plot(1:4);
else
  region=[min(x1) max(x1) min(y1) max(y1)];
end

hf=figure;
set(hf,'visible','off');
hi=imagesc(x1,y1,velout);
set(hi,'alphadata',~isnan(velout));
set(gca,'YDir','normal');
axis equal
caxis([cmin cmax]);
colorbar;
colormap(jet);
axis(region);
title(['Velocity (mm/yr)']);
saveas(hf,['vel_INT',num2str(nint),'_ll'],'png');

