function plot_unwrap_phase(varargin);
%  
% generate mosaic plot of unwrapped phase in radar coordinates
%
% Usage: plot_unwrap_phase();
%
% available options:
%  
%   'dir_intf'  ---- direction of the interferograms
%   'unwrap_file' ---- interferograms name
%   'intf_list' ---- list of interferograms
%   'cmin'      ---- min value for color
%   'cmax'      ---- max value for color
%   'wavelenth' ---- radar wavlength (m) 

fparms='parms_candis.mat';
if (exist(fparms,'file'));
  parms=load(fparms);
end

dir_intf=parms.dir_intf;
funwrap=parms.unwrap_file;
frun=parms.intf_list;
cmin=parms.cmin;
cmax=parms.cmax;
wavelength=parms.wavelength;
Nx=6;
Ny=6;



if (~isempty(varargin))
   for c=1:floor(length(varargin)/2);
       try
        switch varargin{c*2-1};
            case 'dir_intf'
                dir_intf=char(varargin{c*2});
            case 'unwrap_file'
                funwrap=char(varargin{c*2});
            case 'intf_list'
                frun=char(varargin{c*2});
            case 'cmin'
                cmin=varargin{c*2};
            case 'cmax'
                cmax=varargin{c*2};
            case 'Nx'
                Nx=varargin{c*2};
            case 'Ny'
                Ny=varargin{c*2};
                
        end
       catch
           error(['Unrecognized Keyword: ',varargin{c*2-1}]);
       end
   end
end

[intf_list]=textread(frun,'%s\n');
nintf=length(intf_list);

disp(['readding data from ',dir_intf]);

for k=1:nintf;
   cintf=intf_list{k};
   grdin=[dir_intf,'/',cintf,'/',funwrap];
   disp(['loading ',grdin, '[',num2str(k),'/',num2str(nintf),']']);
   [x1,y1,z1]=grdread2(grdin);
   zz{k}=-1000*wavelength*z1/4/pi;
   xx{k}=x1;
   yy{k}=y1;
   tt{k}=[cintf(5:6),'/',cintf(7:8),'/',cintf(3:4),'-',...
                   cintf(14:15),'/',cintf(16:17),'/',cintf(12:13)];
end

plot_insar_panels_ra(xx,yy,zz,tt,Nx,Ny,'ColorRange',[cmin cmax],'FigureName','UNWRAP_RA');