function [data_out]=plot_ts_point_ll(iint,smooth,R,out_flag);
% plot the time sereis at a selected points
%
%  Usage:
%        [data_out]=plot_ts_point(iint,smooth,R,out_flag);

if nargin<2;
    parms=load('parms_candis.mat');
    smooth=parms.smooth;
end

if nargin<3;
    R=0.005;
    out_flag=0;

end

smooth_name=sprintf('%010.4e',smooth);
dir_out=['SBAS_SMOOTH_',smooth_name];
disp(['Ploting data from ',dir_out]);


day_sar=parms.day_sar;
nsar=length(day_sar);
tsar=day_sar-day_sar(1);
yrsar=days2yr(day_sar);


for k=1:nsar;
  this_date=datestr(day_sar(k),'yyyymmdd');
  disp(['Loading data of ',this_date]);
  [x1,y1,z1]=grdread2([dir_out,'/','LOS_',this_date,'_INT',num2str(iint),'_ll.grd']); 
  zin{k}=1000*z1;
end

[X1,Y1]=meshgrid(x1,y1);
xx1=X1(:);
yy1=Y1(:);

hf=figure('units','normalized','outerposition',[0.1 0.1 0.6 0.9]);
hv1=[0.05 0.2 0.4 0.6];
subplot('position',hv1);
h=imagesc(x1,y1,z1*1000);
set(gca,'YDir','normal');
axis equal
colorbar;
colormap(jet);
set(h,'alphadata',~isnan(z1));
hold on

do_more = 'y';

while strcmp(do_more,'y');

 [xpt,ypt]=ginput(1);
 [xcir,ycir]=polygon_circle(xpt,ypt,R);
 plot(xcir,ycir,'k-','LineWidth',2);
%hold off

 indx=inpolygon(xx1,yy1,xcir,ycir);

 yout=zeros(nsar,1);
 rms_out=zeros(nsar,1);
 for k=1:nsar;
    znow=zin{k};
    zfind=znow(indx);
    zgood=zfind(~isnan(zfind));
    yout(k)=mean(zgood);
    rms_out(k)=std(zgood);
 end
 
 data_out=[tsar;yout;rms_out];
  xname = sprintf('%010.4f',xpt);
  yname = sprintf('%010.4f',ypt);
 if (out_flag>0);
   fout=fopen(['pt_ts_',xname,'_',yname,'.dat'],'w');
   fprintf(fout,'%d %12.3f %12.3f\n',[day_sar,yout,rms_out]');
   fclose(fout);
 end

 hv2=[0.52 0.2 0.45 0.6];
 subplot('position',hv2);
 errorbar(yrsar,yout,rms_out,'-s','MarkerSize',10,...
   'MarkerEdgeColor','red','MarkerFaceColor','red');
  xlabel('Time (days)');
  ylabel('LOS Displacement (mm)')
    do_more = 'f';
     while(~ismember(do_more(1),['y','n']));
        do_more=input('Check more  (y/n)?\n','s');
      end 
 
end
