function plot_los_ts_panels(nint,fparms);
% plot out the LOS time series  
%
%  Usage: plot_anc_panels(iint);
%
%
%
if (nargin<2);
   fparms='parms_candis.mat';
end

parms=load(fparms);
cmin=parms.cmin;
cmax=parms.cmax;


x1=parms.x1;
y1=parms.y1;
day_sar=parms.day_sar;
nx=length(x1);
ny=length(y1);
nsar=length(day_sar);

currdir=pwd;
%fdata=['LOS_TS_INT',num2str(nint),'.mat'];

patch_list=textread('PATCH.list','%s\n');
npatch=length(patch_list);

los_out=[];
for k=1:npatch;
  data=load([currdir,'/','PATCH_',num2str(k),'/','sbas_out_INT',num2str(nint),'.mat']);
  los_out=[los_out;data.los_out_patch];
  clear data;
end


los_out=los_out*1000;


for k=1:nsar;
    this_day=day_sar(k);
    this_date=datestr(this_day,'yyyymmdd');
    this_los=los_out(:,k);
    los_panel{k}=reshape(this_los,ny,nx);
    title_panel{k}=[this_date(3:4),'/',this_date(5:6),'/',this_date(7:8)];
    xx{k}=x1;
    yy{k}=y1;
    clear this_los;
end

clear los_out;

plot_insar_panels_ll(xx,yy,los_panel,title_panel,6,6,'ColorRange',[cmin cmax],'FigureName',['LOS_TS_INT',num2str(nint)],'dir_figure',['./SBAS_INT',num2str(nint)]);





