function plot_los_ts_ll(nint,smooth,fparms);
% plot out the LOS time series  
%
%  Usage: plot_anc_panels(iint);
%
%
%

if (nargin<3);
  fparms='parms_candis.mat';
end

parms=load(fparms);
if (nargin<2);
   smooth = parms.smooth;
end

cmin=parms.cmin;
cmax=parms.cmax;
coordinates_type = parms.coordinates_type;

region_plot = parms.region_plot;


smooth_name=sprintf('%010.4e',smooth);
dir_out=['SBAS_SMOOTH_',smooth_name];


x1=parms.x1;
y1=parms.y1;
day_sar=parms.day_sar;
nx=length(x1);
ny=length(y1);
nsar=length(day_sar);

currdir=pwd;
%fdata=['LOS_TS_INT',num2str(nint),'.mat'];


disp(['Ploting data from ',dir_out]);

for k=1:nsar;
    this_day=day_sar(k);
    this_date=datestr(this_day,'yyyymmdd');
    grdin=[dir_out,'/','LOS_',this_date,'_INT',num2str(nint),'_ll.grd'];
    [x1,y1,z1]=grdread2(grdin);
    los_panel{k}=1000*z1;
    title_panel{k}=[this_date(3:4),'/',this_date(5:6),'/',this_date(7:8)];
    xx{k}=x1;
    yy{k}=y1;
    clear z1;
end

clear los_out;

 plot_insar_panels_ll(xx,yy,los_panel,title_panel,7,8,'ColorRange',[cmin cmax],'FigureName',['LOS_LL_TS_INT',num2str(nint)],'dir_figure',[dir_out],'Region',region_plot);





