function plot_anc_panels(nint,fparms);
% plot out the ANC  
%
%  Usage: plot_anc_panels(iint);
%
%
%
if (nargin<2);
   fparms='parms_candis.mat';
end

parms=load(fparms);
cmin=parms.cmin;
cmax=parms.cmax;

fdata=['ANC_INT',num2str(nint),'.mat'];
data=load(fdata);
x1=data.x1;
y1=data.y1;

nx=length(x1);
ny=length(y1);
aps=data.aps_out;
day_sar=data.day_sar;
nsar=length(day_sar);

%aps_good=aps(~isnan(aps));
clear data;

for k=1:nsar;
    this_day=day_sar(k);
    this_date=datestr(this_day,'yyyymmdd');
    this_aps=1000*aps(:,k);
    aps_panel{k}=reshape(this_aps,ny,nx);
    title_panel{k}=[this_date(3:4),'/',this_date(5:6),'/',this_date(7:8)];
    xx{k}=x1;
    yy{k}=y1;
    clear this_aps;
end

clear aps;
plot_insar_panels_ll(xx,yy,aps_panel,title_panel,6,6,'ColorRange',[cmin cmax],'FigureName',['APS_INT',num2str(nint)],'dir_figure','.');





