function parms_default_candis()
% generate the default parameter files for candis
% by Kang Wang on 01/11/2018

parmfile='parms_candis.mat';
parent_flag=0;

if exist(['.' filesep parmfile],'file')
    parms=load(parmfile);
elseif exist(['..' filesep parmfile],'file')
    parmfile=['..' filesep parmfile];
    parms=load(parmfile);
    parent_flag=1;
else
    parms=struct('Created',date);
end

parmfields_before=fieldnames(parms);
num_fields=size(parmfields_before,1);

warning_message = 0;

if ~isfield(parms,'dir_intf');
    warning_message = 1;
    parms.dir_intf=[];
end

if ~isfield(parms,'intf_list');
    warning_message =1;
    parms.intf_list=['dates.run'];
end

if ~isfield(parms,'wavelength');
    parms.wavelength=0.0554658;
end

if ~isfield(parms,'baseline_info');
    warning_message = 1;
    parms.baseline_info='baseline.dat';
end

if ~isfield(parms,'coordinates_type');
    parms.coordinates_type='geographic';
end

if ~isfield(parms,'min_bt');
    parms.min_bt=0;
end

if ~isfield(parms,'max_bt');
    parms.max_bt=150;
end

if ~isfield(parms,'min_bp');
    parms.min_bp=0;
end

if ~isfield(parms,'max_bp');
    parms.max_bp=300;
end

if ~isfield(parms,'max_t_stack');
    parms.max_t_stack=90;
end

if ~isfield(parms,'smooth');
    parms.smooth=0;
end

if ~isfield(parms,'unwrap_file');
    parms.unwrap_file='unwrap.grd';
end

if ~isfield(parms,'los_file');
    parms.los_file = 'los.grd';
end

if ~isfield(parms,'corr_file');
    parms.corr_file = 'corr_patch.grd';
end

if ~isfield(parms,'is_weight'); % weigth the interferograms? [0/1];
   parms.is_weight = 0;
end

if ~isfield(parms,'dem_flag');
    parms.dem_flag=0;
end

if ~isfield(parms,'dates_to_use');
    parms.dates_to_use=['dates.dat'];
end

if ~isfield(parms,'date_start');
   parms.date_start = [];
end

if ~isfield(parms,'date_end');
   parms.date_end=[];
end

if ~isfield(parms,'nstack_min');
    parms.nstack_min=2; % only use interferograms whose two scenes both have APS estimations
end

if ~isfield(parms,'output_grd');
    parms.output_grd='n';
end

if ~isfield(parms,'num_patches');
    parms.num_patches=4;
end

if ~isfield(parms,'num_cores');
    parms.num_cores=2;
end

if ~isfield(parms,'reference_point');
    parms.reference_point=[];
end


if ~isfield(parms,'sbas_type');
   parms.sbas_type=['SBAS'];
end

if ~isfield(parms,'nsbas_ratio');
   parms.nsbas_ratio=[0.6];
end  
 
if ~isfield(parms,'num_iteration');
  parms.num_iteration = 4;
end

if ~isfield(parms,'remove_deformation');
  parms.remove_deformation = 'n';
end

if ~isfield(parms,'sbas_steps');
  parms.sbas_steps=[0:1:parms.num_iteration];
end

if ~isfield(parms,'correction_aps_weather_model');
  parms.correction_aps_weather_model = 0;
end

if ~isfield(parms,'dir_weather_model');
  parms.dir_weather_model=['./ERA5'];
end

if ~isfield(parms,'value_spline');
  parms.value_spline = 1.0;
end

if ~isfield(parms,'hgt_file');
  parms.dem_file = 'hgt.mat';
end

if ~isfield(parms,'ginsar'); % G-InSAR option
  parms.ginsar=0;
end

if ~isfield(parms,'ginsar_file');
  parms.ginsar_file = 'los_ginsar_res.grd';
end

if ~isfield(parms,'dir_gps');
  parms.dir_gps ='./GPS';
end



%if ~isfield(parms,'deramp_mask_polygon');
%  parms.deramp_mask_polygon='mask_polygon.txt';
%end

if ~isfield(parms,'xy_units');
  parms.xy_units='degrees';
end

if ~isfield(parms,'incident_file');
  parms.incident_file = 'inc.mat';
end

if ~isfield(parms,'radar_range');
  parms.radar_range = 864000.0;
end

if ~isfield(parms,'vel_flag');
  parms.vel_flag=0;
end

if ~isfield(parms,'cmin');
  parms.cmin=-150; 
end

if ~isfield(parms,'cmax');
 parms.cmax=150;
end

if ~isfield(parms,'gamma');
  parms.gamma=0.1;  % for penalizing the solution for unwrapping ambiguity
end

if ~isfield(parms,'sbas_intf_list');
  parms.sbas_intf_list = parms.intf_list;
end

if ~isfield(parms,'region');
  parms.region = [-1.0e9 1.0e9 -1.0e9 1.0e9]; %[xmin xmax ymin ymax] only pixels in this region will be processed
end

if ~isfield(parms,'region_plot');
  parms.region_plot=[];
end

if ~isfield(parms,'remove_weather_model');
    parms.remove_weather_model = 0;
end

if ~isfield(parms,'deramp');
    parms.deramp = 0;
end

if ~isfield(parms,'deformation_type');
    parms.deformation_type = 'linear'; % assuming linear deformation process by default
end


if ~isfield(parms,'day1');
    parms.day1=[]; %first acquisition time
end

if ~isfield(parms,'day2');
    parms.day2=[]; %second acquisition time
end

if ~isfield(parms,'dBp');
    parms.dBp=[]; %perpendicular baseline
end

if ~isfield(parms,'day_sar');
    parms.day_sar=[]; %aquisition time
end

if ~isfield(parms,'x1');
    parms.x1=[]; %vector of the horizontal line
end 

if ~isfield(parms,'y1');
    parms.y1=[]; %vector of vertical column
end

if ~isfield(parms,'pi1');
    parms.pi1=[]; %start index of patch
end

if ~isfield(parms,'pi2');
    parms.pi2=[]; %end index of patch
end

if ~isfield(parms,'xpixel');
    parms.xpixel=[]; %aquisition time
end

if ~isfield(parms,'ypixel');
    parms.ypixel=[]; %aquisition time
end

if ~isfield(parms,'xref');
    parms.xref=[]; %range of x for reference
end

if ~isfield(parms,'yref');
    parms.yref=[]; %range of y for reference
end

if ~isfield(parms,'indx_ref');
    parms.indx_ref=[]; %index of reference point
end

if ~isfield(parms,'xbound');
    parms.xbound=[]; %range of x for processing
end

if ~isfield(parms,'ybound');
    parms.ybound=[]; %range of y for processing
end


if ~isfield(parms,'max_diff_days');
  parms.max_diff_days=3; % maximum different days on opposite side
end



parmfields=fieldnames(parms);
if size(parmfields,1)~=num_fields
    try
        save(parmfile,'-struct','parms')
        for i=1:size(parmfields,1)
            if isempty(strmatch(parmfields{i},parmfields_before))
               parmname=parmfields{i};
               value=getfield(parms,parmname);
               if isempty(value)
                   value='[]';
               end
               if isnumeric(value)               
                   if size(value,1)>1                   
                       value_str = '[';
                       for ll=1:size(value,1)
                           if ll==size(value,1)
                               value_str = [value_str num2str(value(ll,:)) ];
                           else
                                value_str = [value_str num2str(value(ll,:)) '; '];
                           end
                       end
                       value_str = [value_str ']'];
                   else
                       value_str = num2str(value);
                   end
                   logit_candis([parmname,' = ',value_str],'CANDIS.log',parent_flag);
                   clear value_str
               else
                   if size(value,1)>1
                      value_str = '[';
                      for ll=1:size(value,1)
                           if ll==size(value,1)
                               value_str = [value_str num2str(value(ll,:)) ];
                           else
                                value_str = [value_str num2str(value(ll,:)) '; '];
                           end
                       end
                       value_str = [value_str ']'];
                   else
                       value_str = value;
                   end
                   logit_candis([parmname,' = ',value_str],'CANDIS.log',parent_flag);
                   clear value_str
               end
            end
        end
        
    catch
        fprintf('Warning: missing parameters could not be updated (no write access)\n')
    end
end


if warning_message == 1;
  disp(['Please check default value for ','dir_intf']);
  disp(['Please check default value for ','baseline_info']);
  disp(['Please check default value for ','intf_list']);
end
