function [xpixel,ypixel,los_out,dh_out,vel_out1,vel_out2,vel_out3,amp_out,phs_out]=merge_sbas_out(iint,flist);

if nargin<2;
    flist='PATCH.list';
end

currdir=pwd;

[patch_list]=textread(flist,'%s\n');
npatch=length(patch_list);

xpixel=[];
ypixel=[];
los_out=[];
dh_out=[];
vel_out1=[];
vel_out2=[];
vel_out3=[];
amp_out=[];
phs_out=[];
for k=1:npatch;
  this_patch=patch_list{k};
  disp(['Reading data from ',this_patch]);
  data=load([currdir,'/',this_patch,'/','sbas_out_INT',num2str(iint),'.mat']);

  xpixel=[xpixel;data.xpixel_patch];
  ypixel=[ypixel;data.ypixel_patch];
  los_out=[los_out;data.los_out_patch];
  dh_out=[dh_out;data.dh_out_patch];
  vel_out1=[vel_out1;data.vel_out1_patch];
  vel_out2=[vel_out2;data.vel_out2_patch];
  vel_out3=[vel_out3;data.vel_out3_patch];
  amp_out=[amp_out; data.amp_out_patch];
  phs_out=[phs_out; data.phs_out_patch];
end
