function [xpixel,ypixel,los_out]=merge_phase_in(flist);

if nargin<1;
    flist='PATCH.list';
end

currdir=pwd;

[patch_list]=textread(flist,'%s\n');
npatch=length(patch_list);
xpixel=[];
ypixel=[];
los_out=[];

for k=1:npatch;
  this_patch=patch_list{k};
  disp(['Reading input phase from ',this_patch]);
  data=load([currdir,'/',this_patch,'/','sbas_in.mat']);
  xpixel=[xpixel;data.xpixel_patch];
  ypixel=[ypixel;data.ypixel_patch];
  los_out=[los_out;data.los_in_patch];
end

