function gps2insar()
% get the difference between the GPS and InSAR 
%
% references:
%
% Neely, W. R., Borsa, A. A., & Silverii, F. (2019). GInSAR: A cGPS Correction for Enhanced InSAR Time Series. IEEE Transactions on Geoscience and Remote Sensing, 1–11. https://doi.org/10.1109/TGRS.2019.2934118
% 
% by Kang Wang on 10/28/2019

p=load('parms_candis.mat');
dir_intf=p.dir_intf;
dir_era=p.dir_weather_model;
frun=p.intf_list;
intf_list=textread([frun],'%s\n');
nintf=length(intf_list);
los_file=p.los_file; % input file name
dir_gps=p.dir_gps;
ginsar_file = p.ginsar_file; %output file name
coordinates_type = p.coordinates_type;
[gps_id,lon_gps,lat_gps,zgps,rgps,agps,hgps]=textread([dir_gps,'/gps.list'],'%s %f %f %f %f %f %f\n');
[lon_look,lat_look,zlook,ve,vn,vz]=textread([dir_gps,'/look.xyz'],'%f %f %f %f %f %f\n');
%%%% not all sites in the input list are available, so only use those
%%%% having data from UNAVCO


ngps=length(gps_id);

[x1,y1,z1]=grdread2([dir_intf,'/',intf_list{1},'/',los_file]);
[X1,Y1]=meshgrid(x1,y1);

dx=mean(diff(x1));
dy=mean(diff(y1));

xmin=min(x1)-100*dx;
xmax=max(x1)+100*dx;
ymin=min(y1)-100*dy;
ymax=max(y1)+100*dy;

if strcmp(coordinates_type,'radar');
   xgps=rgps;
   ygps=agps;
else
   xgps=lon_gps;
   ygps=lat_gps;
end


igood=0;

xgps_good=[];
ygps_good=[];

igps_good=[];
for k=1:ngps;
  this_site=gps_id{k};
  xnow=xgps(k);
  ynow=ygps(k);
%  fgps=[dir_gps,'/',this_site,'.cwu.final_igs08.pos'];
  fgps=[dir_gps,'/',this_site,'.cwu.igs08.pos'];
  if (exist(fgps,'file') & xnow > xmin & xnow < xmax & ynow > ymin & ynow <ymax);
    igood = igood +1;
    [date_gps,N_gps{igood},E_gps{igood},U_gps{igood},sig_n,sig_e,sig_u]=read_GPS_PBO(fgps);
    day_gps{igood}=datenum(date_gps,'yyyymmdd');
    igps_good=[igps_good;k];
    xgps_good=[xgps_good;xnow];
    ygps_good=[ygps_good;ynow];

   else
      continue
  end
end

ngood=igood;

% look vectors for all GPS sites
ve_gps=griddata(lon_look,lat_look,ve,lon_gps,lat_gps,'nearest');  
vn_gps=griddata(lon_look,lat_look,vn,lon_gps,lat_gps,'nearest');
vz_gps=griddata(lon_look,lat_look,vz,lon_gps,lat_gps,'nearest');

ve_good=ve_gps(igps_good);
vn_good=vn_gps(igps_good);
vz_good=vz_gps(igps_good);



[x1,y1,z1]=grdread2([dir_intf,'/',intf_list{1},'/',los_file]);
[X1,Y1]=meshgrid(x1,y1);

disp(['input data file name: ', los_file]);

for k=1:nintf;
  this_intf=intf_list{k};
  disp(['workig on intf ', this_intf,' [',num2str(k),'/',num2str(nintf),']']);
  fintf=[dir_intf,'/',this_intf,'/',los_file];
  [xin,yin,zin]=grdread2(fintf);
  
  dx=mean(diff(xin));
  dy=mean(diff(yin));
   date1=this_intf(1:8);
   date2=this_intf(10:17);

   day1=datenum(date1,'yyyymmdd');
   day2=datenum(date2,'yyyymmdd');

   dlos_insar=NaN(ngood,1);
   for nn=1:ngood;
       indx=find((xin>xgps_good(nn)-5*dx) & (xin<xgps_good(nn)+5*dx));
       indy=find((yin>ygps_good(nn)-5*dy) & (yin<ygps_good(nn)+5*dy));
       los_find=zin(indy,indx);
       los_good=los_find(~isnan(los_find));
       if length(los_good)>0;
          dlos_insar(nn)=mean(los_good);
       end
   end
%
%  get the GPS observations projected onto the line-of-sights
   dlos_gps=NaN(ngood,1);

   for nn=1:ngood;
      day_now=day_gps{nn};
     indx1=find(day_now>day1-2 & day_now<day1+2);
     indx2=find(day_now>day2-2 & day_now<day2+2);
     enow = E_gps{nn};
     nnow = N_gps{nn};
     unow = U_gps{nn};
     if length(indx1)>0 & length(indx2)>0
        e1=mean(enow(indx1));
        n1=mean(nnow(indx1));
        z1=mean(unow(indx1));

        e2=mean(enow(indx2));
        n2=mean(nnow(indx2));
        z2=mean(unow(indx2));

        de=e2-e1;
        dn=n2-n1;
        dz=z2-z1;

        dlos_gps(nn)=de*ve_good(nn)+dn*vn_good(nn)+dz*vz_good(nn);

     end
   end

   res_dlos = dlos_gps-dlos_insar;  %difference between the GPS and InSAR
   indx_good=~isnan(res_dlos);
   xgood=xgps_good(indx_good);
   ygood=ygps_good(indx_good);
   zgood=res_dlos(indx_good);

    nstation_use = length(zgood);
    if (nstation_use >=10);
       disp(['... number of stations used for this interferogram: ',num2str(nstation_use)]);
       f=fit([xgood,ygood],zgood,'poly22');
       res_model=feval(f,X1(:),Y1(:));
       zout=reshape(res_model,size(zin));
    else
       disp(['*** Warning: number of stations available: ',num2str(nstation_use),'  No estimation for this interferogram...']);
       zout = zeros(size(zin));
    end

%    figure;
%    subplot(1,2,1);
%    h=imagesc(xin,yin,zin);
%    colorbar
%    colormap(jet)
%    set(h,'alphadata',~isnan(zin));
%    caxis([-0.05 0.05]);

%    subplot(1,2,2)
%    h=imagesc(xin,yin,zin+zout);
%    colorbar
%    colormap(jet)
%    set(h,'alphadata',~isnan(zin));
%    caxis([-0.05 0.05]);
    grdwrite2(xin,yin,zin+zout,[dir_intf,'/',this_intf,'/',ginsar_file]);

end
