function [value,parmname]=getparm_candis(parmname,printflag);


parms_default_candis;

if nargin<2
    printflag=0;
end

parmfile='parms_candis.mat';

if exist(['.' filesep parmfile],'file')
    parms=load(parmfile);
elseif exist(['..' filesep parmfile],'file')
    parmfile=['..' filesep parmfile];
    parms = load(parmfile);
else
    error([parmfile ' not found'])
end


if nargin < 1
    disp(orderfields(parms))
else
    parmnum_tmp=strcmp(parmname,fieldnames(parms));
    parmnum = find(parmnum_tmp>0);
    if length(parmnum)>1
        error(['Parameter ',parmname,'* is not unique'])
    elseif isempty(parmnum)
        parmname=[];
        value=[];
    else
        parmnames=fieldnames(parms);
        parmname=parmnames{parmnum};
        value=getfield(parms,parmname);
    end
    if printflag~=0
        if isnumeric(value)
            fprintf(['   PARM: %s=',repmat('%g ',1,200)],parmname,value)
            fprintf('\n')
        else
            fprintf('   PARM: %s=''%s''\n',parmname,value)
        end
    end
end
