function get_sq_intf_list(fdates,fout);
%  generate a squentinel intferogram list from the input dates
%
% Usage = get_eq_int_list(fdates,fout);
%
% by Kang Wang on in Jan. 2018
%

if (nargin<2);
  fout='intf_sq.list';
end

disp(['Reading dates info from ', fdates]);

[dates_in]=textread(fdates,'%s\n');
day_in=datenum(dates_in,'yyyymmdd');
day_new=sort(unique(day_in));
nday=length(day_new);

disp(['Creating sequential interferogram list ',fout]);

fid=fopen(fout,'w');
for k=1:nday-1;
  day1=day_new(k);
  day2=day_new(k+1);
  date1=datestr(day1,'yyyymmdd');
  date2=datestr(day2,'yyyymmdd');
  disp([date1,'_',date2]);
  fprintf(fid,'%s\n',[date1,'_',date2]);
end

fclose(fid);
