function [indx_out1,indx_out2,indx_sar1,indx_sar2]=get_index_nearest(day1,day2,day_sar,day_in,day_min,day_max);
% find the interograms to stack for a given acquisitions
%
%  Usage: [indx_intf1,indx_intf2,indx_sar1,indx_sar2]=get_index_nearest(day1,day2,day_sar,day_in,day_min,day_max);
%
% The code first tries to find interferograms of the same time spans on
% both ends. If not enough found, the condition is relaxed so that it can
% always find enough interferorams on both sides
% by Kang Wang on 07/13/2017
% Last updated by Kang Wang in March, 2018


indx1=find(day1>=(day_in+day_min)&day2==day_in); %backward search for interferograms connecting to  day_in
indx2=find(day2<=(day_in+day_max)&day1==day_in); %

N1=length(indx1);  %number of backward interferograms
N2=length(indx2);  %number of forward interferograms
day1_find=day1(indx1);
day2_find=day2(indx2);
%max_diff=2;  % maximum shift allowed
p=load('parms_candis.mat');
max_diff=p.max_diff_days;

[Nmin,indx_min]=min([N1,N2]);
if (Nmin>0);

   day_backward=day1(indx1); %
   day_forward=day2(indx2);

   dt1=day_in-day_backward;
   dt2=day_forward-day_in;
   [dt1_sort,indx_sort1]=sort(dt1);
   [dt2_sort,indx_sort2]=sort(dt2);

  if (indx_min==1); %number of backward interferograms N1 is smaller
%    First try to find the exact match, if not found, relax the conditions...      
     dt=abs(day2_find-day_in);
     indx_out1=[];
     indx_out2=[];
     for k=1:N1;
        dt_now=abs(day1_find(k)-day_in);
        indx_tmp=find(abs(dt-dt_now)<max_diff);
        if (length(indx_tmp)>0);
            indx_find=indx2(indx_tmp(1));
            indx_out1=[indx_out1;indx1(k)];
            indx_out2=[indx_out2;indx_find];
        end
     end
      
     if (length(indx_out1)<N1);
%       Not found enough, now relax the condition         
%        dt2_match=dt2_sort(1:N1);
%        Dt=abs(dt2_match-dt1_sort);
%        indx_good=find(Dt<max_diff);  % maximum offset 30 days
     
%        intf1=indx_sort1(indx_good);
%        intf2=indx_sort2(indx_good);

%       indx_out1=indx1(intf1);
%       indx_out2=indx2(intf2);

        indx_out1=[];
        indx_out2=[];
        dt_matched=[];
        for k=1:N1;
            dt1_now=dt1_sort(k);
            dt_left=setdiff(dt2_sort,dt_matched);
            indx_tmp=knnsearch(dt_left,dt1_now);
            dt2_now=dt_left(indx_tmp);
            
            indx_tmp1=find(dt1==dt1_now);
            indx_tmp2=find(dt2==dt2_now);
            indx_out1_tmp=indx1(indx_tmp1);
            indx_out2_tmp=indx2(indx_tmp2);
            if (abs(dt1_now-dt2_now)<=max_diff);
            
             indx_out1=[indx_out1;indx_out1_tmp];
             indx_out2=[indx_out2;indx_out2_tmp];
             dt_matched=[dt_matched;dt2_now];

            end
            
        end
     end
  elseif (indx_min==2); %number of forward interferograms N2 is smaller
      
      dt= abs(day1_find-day_in);
      indx_out1=[];
      indx_out2=[];

    for k=1:N2;
      dt_now=abs(day2_find(k)-day_in);
      indx_tmp=find(abs(dt-dt_now)<max_diff);
      if (length(indx_tmp)>0);
         indx_find=indx1(indx_tmp(1));
         indx_out1=[indx_out1;indx_find];
         indx_out2=[indx_out2;indx2(k)];
      end
    end

    if (length(indx_out2)<N2);
%        dt1_match=dt1_sort(1:N2);
%        Dt=abs(dt1_match-dt2_sort);
%        indx_good=find(Dt<max_diff);
%        intf1=indx_sort1(indx_good);
%        intf2=indx_sort2(indx_good);
%        indx_out1=indx1(intf1);
%       indx_out2=indx2(intf2);
       
        indx_out1=[];
        indx_out2=[];
        dt_matched=[];
        for k=1:N2;
            dt2_now=dt2_sort(k);
            dt_left=setdiff(dt1_sort,dt_matched);
            indx_tmp=knnsearch(dt_left,dt2_now);
            dt1_now=dt_left(indx_tmp);
            
            indx_tmp1=find(dt1==dt1_now);
            indx_tmp2=find(dt2==dt2_now);
            indx_out1_tmp=indx1(indx_tmp1);
            indx_out2_tmp=indx2(indx_tmp2);
             if (abs(dt1_now-dt2_now)<=max_diff);
              indx_out1=[indx_out1;indx_out1_tmp];
              indx_out2=[indx_out2;indx_out2_tmp];
              dt_matched=[dt_matched;dt1_now];

            end
            
        end
       
    end
     
  else
     error(['Wrong Value of day1 day2 and day_sar....']);
  end

  dd1_find=day1(indx_out1);
  dd2_find=day2(indx_out2);
  [sar1_find,indx_sar1]=ismember(dd1_find,day_sar);
  [sar2_find,indx_sar2]=ismember(dd2_find,day_sar);

   
else

  indx_out1=[];
  indx_out2=[];
  indx_sar1=[];
  indx_sar2=[];
  return;
end
