function anc=get_anc(day_sar,aps_in,varargin);
%
%Usage: anc=get_anc(day_sar,aps_in,indx_box);
%
% added the option to calculate the ANC for a small area defined by the pixel index
% Last Update by Kang Wang on 07/07/2017

Nsar=length(day_sar);
rms_alpha=zeros(Nsar,1);


for i=1:Nsar;
 this_image_all=aps_in(:,i);
 if length (varargin) >0 ;
   indx_box = varargin{1};
   this_image=this_image_all(indx_box);
 else
   this_image=this_image_all;
 end
 indx_good=~isnan(this_image);
 alpha_good=this_image(indx_good);
 Ngood=length(alpha_good);
 alpha_mean=mean(alpha_good);
% alpha_mean=0;
 rms_alpha(i)=sqrt(sum((alpha_good-alpha_mean).^2)/Ngood);
end

anc=10*rms_alpha/max(rms_alpha);
