function get_APS_from_ERA_grid(x1,y1);%
%get the APS at InSAR pixels for each SAR aquisition
%
% Usage: get_APS_from_ERA_grid(x1,y1);
% 
% x1 and y1 are vectors describing the coordiantes of horizontal and vertical axes (geographic coordinates)
%
% by Kang Wan gon 10/22/2019

p1=load('parms_aps.mat');

[X1,Y1]=meshgrid(x1,y1);
xpixel=X1(:);
ypixel=Y1(:);
% indx_good=~isnan(z1);
% xpixel=X1(indx_good);
% ypixel=Y1(indx_good);


nx=length(x1);
ny=length(y1);

[date_sar]=textread('dates.dat','%s');
nsar=length(date_sar);

%fout=fopen('dates_era_grid.txt','w');
parfor k=1:nsar;

  this_date=date_sar{k};
  disp(['working on ',this_date, ' [',num2str(k),'/',num2str(nsar),']']);

  fdry = [p1.era_datapath,'/',this_date,'_ZHD.xyz'];
  fwet = [p1.era_datapath,'/',this_date,'_ZWD.xyz'];

  if (exist(fdry,'file')  & exist(fdry,'file'));
   [xyz_input,xyz_dry] = load_weather_model_SAR(fdry,[xpixel ypixel]);
   [xyz_input,xyz_wet] = load_weather_model_SAR(fwet,[xpixel ypixel]);
   zwet=xyz_wet(:,3);
   zdry=xyz_dry(:,3);
   zall=zwet+zdry;
   zout=reshape(zall,ny,nx);
   zout=zout/100;
   grdwrite2(x1,y1,zout,[p1.era_datapath,'/',this_date,'_ERA_ll.grd']);
  
%   fprintf(fout,'%s\n',date_sar{k});
%   figure
%   imagesc(x1,y1,zout);
%   axis equal
%   colorbar
%   colormap(jet)

  end

end

%fclose(fout);
