function geocode_sbas_gmtsar(iint,res,smooth);
%
% geocode the SBAS results (GMTSAR format)
%
% Usage: geocode_sbas_gmtsar(iint,res,smooth);
%       
% iint --- iteration index
% res  --- resolution in meters 
% smooth --- smooth value for the smooth, for foler name
%           (optional, by default uses the value in 'parms_candis.mat')
%
%

currdir = pwd;
Usage=['Usage: geocode_sbas_gmtsar(iint,res);'];
if (nargin<1);
   error(Usage);
end
fparms='parms_candis.mat';
parms=load(fparms);
day_sar=parms.day_sar;
nsar=length(day_sar);
ncores=parms.num_cores;
if (nargin<3);
 smooth=parms.smooth;
end

smooth_name=sprintf('%010.4e',smooth);
dir_out=['SBAS_SMOOTH_',smooth_name];
disp(['Generating the proj commands for ',dir_out]);

cd(dir_out);

fout=fopen(['proj_int',num2str(iint),'.cmd'],'w');
for k=1:nsar;
  this_date=datestr(day_sar(k),'yyyymmdd');
  grdin=['LOS_',this_date,'_INT',num2str(iint),'.grd'];
  grdout=[grdin(1:length(grdin)-4),'_ll.grd'];
%  disp(['geocoding ',grdin]);
%  proj_ra2ll_gmtsar(grdin,res);
  cmd=['proj_ra2ll_igppsar.csh ','trans.dat ',grdin,'  ',grdout,' ',num2str(res)];
  fprintf(fout,'%s\n',cmd);
end

grdv1=['vel1_INT',num2str(iint),'.grd'];
grdv2=['vel2_INT',num2str(iint),'.grd'];
grdv3=['vel3_INT',num2str(iint),'.grd'];
grdout1=['vel1_INT',num2str(iint),'_ll.grd'];
grdout2=['vel2_INT',num2str(iint),'_ll.grd'];
grdout3=['vel3_INT',num2str(iint),'_ll.grd'];
if (parms.vel_flag>0);
 cmd1=['proj_ra2ll_igppsar.csh ','trans.dat ',grdv1,'  ',grdout1,' ',num2str(res)];
 cmd2=['proj_ra2ll_igppsar.csh ','trans.dat ',grdv2,'  ',grdout2,' ',num2str(res)];
 cmd3=['proj_ra2ll_igppsar.csh ','trans.dat ',grdv3,'  ',grdout3,' ',num2str(res)];
 fprintf(fout,'%s\n',cmd1);
 fprintf(fout,'%s\n',cmd2);
 fprintf(fout,'%s\n',cmd3);
end

grd1=['amp_INT',num2str(iint),'.grd'];
grd2=['amp_INT',num2str(iint),'_ll.grd'];
grd3=['phs_INT',num2str(iint),'.grd'];
grd4=['phs_INT',num2str(iint),'_ll.grd'];

cmd1=['proj_ra2ll_igppsar.csh ','trans.dat ',grd1,'  ',grd2,' ',num2str(res)];
cmd2=['proj_ra2ll_igppsar.csh ','trans.dat ',grd3,'  ',grd4,' ',num2str(res)];
fprintf(fout,'%s\n',cmd1);
fprintf(fout,'%s\n',cmd2);
fclose(fout);

f_cmd=fopen(['run_proj_int',num2str(iint)],'w');
fprintf(f_cmd,['parallel --jobs ',num2str(ncores),' < ','proj_int',num2str(iint),'.cmd']);


%disp(['geocoding ',grdvel]);
%proj_ra2ll_gmtsar(grdvel,res);

%disp(['geocoding ',grdvel]);
%proj_ra2ll_gmtsar(grddh,res);

cd(currdir);
