function era2intf()
% generate the synthetic interferograms from ERA models

p=load('parms_candis.mat');
dir_intf=p.dir_intf;
dir_era=p.dir_weather_model;
frun=p.intf_list;
intf_list=textread([frun],'%s\n');
nintf=length(intf_list);
los_file=p.los_file;
coordinates_type=p.coordinates_type;

if strcmp(coordinates_type,'radar')
 str_wm =['_ERA_ra_interp.grd'];
else 
 str_wm =['_ERA_ll_interp.grd'];
end

for k=1:nintf;
  this_intf=intf_list{k};
  disp(['workig on intf ', this_intf,' [',num2str(k),'/',num2str(nintf),']']);
  fintf=[dir_intf,'/',this_intf,'/',los_file];
  disp(['reading data from ', fintf]);
  [xin,yin,zin]=grdread2(fintf);
  date1=this_intf(1:8);
  date2=this_intf(10:17);
%  fera1=[dir_era,'/',date1,'_ERA_ra_interp.grd'];
%  fera2=[dir_era,'/',date2,'_ERA_ra_interp.grd'];
  fera1=[dir_era,'/',date1,str_wm];
  fera2=[dir_era,'/',date2,str_wm];

  [x2,y2,z1]=grdread2(fera1);
  [x2,y2,z2]=grdread2(fera2);
  zera=-(z2-z1); 
  grdwrite2(xin,yin,zera,[dir_intf,'/',this_intf,'/','los_era.grd']);

  if p.correction_aps_weather_model >0
     zdiff=zin-zera;
     grdwrite2(xin,yin,zdiff,[dir_intf,'/',this_intf,'/','los_era_res.grd']);
  end

end
