function check_closure(date1,date2,date3,dir_root,funwrap)
% 
% check the phase closure along a loop formed by three dates
%
% Usage: check_closure(date1,date2,date3,dir_root,funwrap);
%

title1=[date1(3:4),'/',date1(5:6),'/',date1(7:8),'-',date2(3:4),'/',date2(5:6),'/',date2(7:8)];
title2=[date2(3:4),'/',date2(5:6),'/',date2(7:8),'-',date3(3:4),'/',date3(5:6),'/',date3(7:8)];
title3=[date1(3:4),'/',date1(5:6),'/',date1(7:8),'-',date3(3:4),'/',date3(5:6),'/',date3(7:8)];
title4=['sum.'];

if (nargin<4);
  fparms='parms_candis.mat';
  parms=load(fparms);
  dir_root=parms.dir_intf;
  funwrap=parms.unwrap_file;  
end

funwrap=funwrap(1:length(funwrap)-4);

[x1,y1,z1]=grdread2([dir_root,'/',date1,'_',date2,'/',funwrap,'.grd']);
[x2,y2,z2]=grdread2([dir_root,'/',date2,'_',date3,'/',funwrap,'.grd']);
[x3,y3,z3]=grdread2([dir_root,'/',date1,'_',date3,'/',funwrap,'.grd']);

dz=z1+z2-z3;


xmin=min(x1);
xmax=max(x1);
ymin=min(y1);
ymax=max(y1);
Rx=xmax-xmin;
Ry=ymax-ymin;

hf=figure;
hs1=[0.05 0.5 0.42 0.42];
subplot('position',hs1);
h1=imagesc(x1,y1,z1);
set(gca,'YDir','normal');
%axis equal
hcolor=colorbar('east','Position',[0.44 0.5 0.01 0.42]);
ylabel(hcolor,['Phase (rad.)']);
cmin=min(z1(:));
cmax=max(z1(:));
R=cmax-cmin;
cmin=cmin+0.1*R;
cmax=cmax-0.1*R;
strcmd=['makecpt -Cjet -T',num2str(cmin),'/',num2str(cmax),'/1',' -D >los.cpt'];
system([strcmd]);
cmap=importcpt('los.cpt');
colormap(cmap);
set(h1,'alphadata',~isnan(z1));
axis([xmin xmax ymin ymax]);
set(gca,'XTick',[]);
text(xmin+0.5*Rx,ymin+0.9*Ry,title1,'interpreter','none','HorizontalAlignment','center','FontWeight','Bold','FontSize',15)

hs2=[0.52 0.5 0.42 0.42];
subplot('position',hs2);
h1=imagesc(x3,y3,z2);
set(gca,'YDir','normal');
%axis equal
hcolor=colorbar('east','Position',[0.91 0.5 0.01 0.42]);
ylabel(hcolor,['Phase (rad.)']);
cmin=min(z2(:));
cmax=max(z2(:));
R=cmax-cmin;
cmin=cmin+0.1*R;
cmax=cmax-0.1*R;
strcmd=['makecpt -Cjet -T',num2str(cmin),'/',num2str(cmax),'/1',' -D >los.cpt'];
system([strcmd]);
cmap=importcpt('los.cpt');
colormap(cmap);
set(h1,'alphadata',~isnan(z2));
axis([xmin xmax ymin ymax]);
set(gca,'YTick',[]);
set(gca,'XTick',[]);
text(xmin+0.5*Rx,ymin+0.9*Ry,title2,'interpreter','none','HorizontalAlignment','center','FontWeight','Bold','FontSize',15)


hs3=[0.05 0.05 0.42 0.42];
subplot('position',hs3);
h1=imagesc(x3,y3,z3);
set(gca,'YDir','normal');
%axis equal
hcolor=colorbar('east','Position',[0.44 0.05 0.01 0.42]);
ylabel(hcolor,['Phase (rad.)']);
cmin=min(z3(:));
cmax=max(z3(:));
R=cmax-cmin;
cmin=cmin+0.1*R;
cmax=cmax-0.1*R;
strcmd=['makecpt -Cjet -T',num2str(cmin),'/',num2str(cmax),'/1',' -D >los.cpt'];
system([strcmd]);
cmap=importcpt('los.cpt');
colormap(cmap);
set(h1,'alphadata',~isnan(z3));
axis([xmin xmax ymin ymax]);
text(xmin+0.5*Rx,ymin+0.9*Ry,title3,'interpreter','none','HorizontalAlignment','center','FontWeight','Bold','FontSize',15)


hs4=[0.52 0.05 0.42 0.42];
subplot('position',hs4);
h1=imagesc(x3,y3,dz/2/pi);
set(gca,'YDir','normal');
%axis equal
hcolor=colorbar('east','Position',[0.91 0.05 0.01 0.42]);
ylabel(hcolor,['Sum. (2\pi)']);

cmin=min(dz(:));
cmax=max(dz(:));
R=cmax-cmin;
cmin=cmin+0.1*R;
cmax=cmax-0.1*R;
strcmd=['makecpt -Cjet -T',num2str(cmin),'/',num2str(cmax),'/1',' -D >los.cpt'];
system([strcmd]);
cmap=importcpt('los.cpt');
colormap(cmap);set(h1,'alphadata',~isnan(dz));
caxis([-2 2])
axis([xmin xmax ymin ymax]);
set(gca,'YTick',[]);

text(xmin+0.5*Rx,ymin+0.9*Ry,title4,'interpreter','none','HorizontalAlignment','center','FontWeight','Bold','FontSize',15)
