function candis_sbas(iint,fparms);
% doing SBAS on all patches
% 
% Usage: candis_sbas(iit,fparms);
%
%
% 

if nargin<2;
 fparms='parms_candis.mat';
end
parms=load(fparms);
ncores=parms.num_cores;

disp(['running SBAS on all patches for Iteration :',num2str(iint)]);
patch_list=textread('PATCH.list','%s\n');
npatch=length(patch_list);
if (ncores > 1);
    disp(['Trying with ',num2str(ncores),' cores ...']);
    parpool(ncores);
  parfor k=1:npatch;
      patch_id=patch_list{k};
      disp(['running SBAS on ',patch_id]);
      sbas_patch(patch_id,iint);
  end
   delete(gcp('nocreate'));
else
  for k=1:npatch;
     patch_id=patch_list{k};
     disp(['running SBAS on ',patch_id]);
     sbas_patch(patch_id,iint);
  end
end

