function candis_preproc_patch(frun);
%  prepare the input file for SBAS 
%
%  Usage: candis_preproc(f_intf_list);
%
%  f_intf_list is optional; use value parms.intf_list if not specified
%  
% Last Updated by Kang Wang on 04/09/2018
%

coordinates_type = getparm_candis('coordinates_type');
if strcmp(coordinates_type,'radar')
  if exist('ref.ra','file');
     data_ref=load('ref.ra');
     xref = data_ref(:,1);
     yref = data_ref(:,2);
     setparm_candis('reference_point',[xref yref]);
  else
    setparm_candis('reference_point',[]);
  end

  if (exist('bounds.ra','file'));
     bds=load('bounds.ra');
     xmin = bds(1);
     xmax = bds(2);
     ymin = bds(3);
     ymax = bds(4);
     region = [xmin xmax ymin ymax];
     display('Processing pixles within bounds of bounds.ra ');
  else
%     xmin = -1.0e9;
%     xmax =  1.0e9;
%     ymin = -1.0e9;
%     ymax =  1.0e9;
     region = [];
     display(['Processing all pixels...'])
  end
  setparm_candis('region',region);

end

if strcmp(coordinates_type,'geographic')
  if exist('ref.ll','file');
     data_ref=load('ref.ll');
     xref = data_ref(:,1);
     yref = data_ref(:,2);
     setparm_candis('reference_point',[xref yref]);
  else
     setparm_candis('reference_point',[]);
  end

  if exist('bounds.ll','file');
    bds=load('bounds.ll');
    xmin = bds(1);
    xmax = bds(2);
    ymin = bds(3);
    ymax = bds(4);
    region=[xmin xmax ymin ymax];
    display('Processing pixles within bounds of bounds.ll ');
  else
%     xmin = -1.0e9;
%     xmax =  1.0e9;
%     ymin = -1.0e9;
%     ymax =  1.0e9;
     region=[];
     display(['Processing all pixels...'])
  end
     setparm_candis('region',region);
end


fparms='parms_candis.mat';
currdir=pwd;
parms=load(fparms);
wavelength=parms.wavelength;
funwrap=parms.unwrap_file;
fcorr =parms.corr_file;
isweight = parms.is_weight;
dir_intf=parms.dir_intf;
if strcmp(dir_intf(length(dir_intf)),'/');
    dir_intf=dir_intf(1:length(dir_intf));
end
[path_unwrap,name_unwrap,ext_unwrap]=fileparts(funwrap);

dir_intf=parms.dir_intf;
fbl=parms.baseline_info;
if (nargin<1);
  frun=parms.intf_list;
else
  setparm_candis('sbas_intf_list',frun);
end
fuse=parms.dates_to_use;
fhgt=parms.dem_file;
finc=parms.incident_file;

max_bp=parms.max_bp;
min_bp=parms.min_bp;

min_bt=parms.min_bt;
max_bt=parms.max_bt;
npatch=parms.num_patches;
sbas_type=parms.sbas_type;
ref=parms.reference_point;

deramp=parms.deramp;
coordinates_type=parms.coordinates_type;
if (strcmp(coordinates_type,'geographic'));
  mask_deramp='eq_mask_ll.dat';
else
  mask_deramp='eq_mask_ra.dat';
end


%rwm=parms.remove_weather_model;
%if (rwm>0);
%   faps_wm = parms.aps_weather_model;
%   data_aps_wm = load(faps_wm);
%   day_aps = data_aps_wm.day_sar;
%   aps_wm = data_aps_wm.aps;
%end


if exist(fbl,'file');
    [date_tmp,bp_tmp]=textread(fbl,'%s %f\n');
else
    error(['baseline_info ',fbl,' does not exist.']);
end

if exist(frun,'file');
    [intf_list]=textread(frun,'%s\n');
    nlist=length(intf_list);
    disp(['Number of Total Interferograms: ',num2str(nlist)]);
    day1_all=zeros(nlist,1);
    day2_all=zeros(nlist,1);
    for k=1:nlist;
        intf_now=intf_list{k};
        date1_now=intf_now(1:8);
        date2_now=intf_now(10:17);
        day1_all(k)=datenum(date1_now,'yyyymmdd');
        day2_all(k)=datenum(date2_now,'yyyymmdd');
    end
    
     
else
     error(['intf_list ',frun, 'does not exist.']);
end

day_tmp1=datenum(date_tmp,'yyyymmdd');
[day_tmp2,indx_tmp1]=unique(day_tmp1);
bp_tmp2=bp_tmp(indx_tmp1);
[day_tmp3,indx_tmp2]=sort(day_tmp2);
bp_tmp3=bp_tmp2(indx_tmp2);

if exist(fuse,'file')>0;
    [dates_use]=textread(fuse,'%s\n');
else
    disp(['Warning: dates_to_use ',fuse, ' does not exist. Use all dates...']);
    logit_candis(['Warning: dates_to_use ',fuse, ' does not exist. Use all dates...'])
end

day_use_tmp=datenum(dates_use,'yyyymmdd');
day_use=sort(unique(day_use_tmp));

[indx_use_tmp,tmp]=ismember(day_tmp3,day_use);
indx_use=find(indx_use_tmp>0);
indx_not_use=find(indx_use_tmp<1);
day_sar=day_tmp3(indx_use); 
bp_sar=bp_tmp3(indx_use);  %baseline after excluding the bad dates

nsar=length(day_sar);
disp(['Number of SAR acquisitions to use :',num2str(nsar)]);
logit_candis(['Number of SAR acquisitions to use: ',num2str(nsar)]);

day_not_use=day_tmp3(indx_not_use);
for k=1:length(day_not_use);
  date_not_use=datestr(day_not_use(k),'yyyymmdd');
  %disp(['Exclude interferograms containing: ',date_not_use]);
  logit_candis(['Exclude interferograms containing: ',date_not_use]);
end


[indx_tmp1]=~ismember(day1_all,day_not_use);
[indx_tmp2]=~ismember(day2_all,day_not_use);
indx_tmp=indx_tmp1.*indx_tmp2;
indx_new=find(indx_tmp>0);

day1_new=day1_all(indx_new);
day2_new=day2_all(indx_new);

nintf=length(day1_new);
%disp(['Number of Interferograms contained in the dates_to_use: ',num2str(nintf)]);
logit_candis(['Number of Interferograms contained in the dates_to_use: ',num2str(nintf)]);

day1=[];
day2=[];
dBp=[];

for k=1:nintf;
   day1_now=day1_new(k);
   day2_now=day2_new(k);
   dt=abs(day1_now-day2_now);
   indx1=find(day_sar==day1_now);
   indx2=find(day_sar==day2_now);
   Bp=abs(bp_sar(indx1)-bp_sar(indx2));
   if (dt>=min_bt & dt<=max_bt & Bp>= min_bp & Bp<=max_bp);
     day1=[day1;day1_now];
     day2=[day2;day2_now];
     dBp=[dBp;bp_sar(indx2)-bp_sar(indx1)];
   end
end

nintf=length(day1);
disp(['Number of Interferograms to use: ',num2str(nintf)]);
logit_candis(['Number of Interferograms satisfying the baseline criteria: ',num2str(nintf)]);

for k=1:1;
  date1_now=datestr(day1(k),'yyyymmdd');
  date2_now=datestr(day2(k),'yyyymmdd');
  dir_now=[dir_intf,'/',date1_now,'_',date2_now];
  grdfile1=[dir_now,'/',funwrap];
  [x1,y1,z1]=grdread2(grdfile1);
end

%%%%%%%%%%%%%%########
dx=mean(diff(x1));
dy=mean(diff(y1));

%%%%%% prepare the coordinates of the region of interest %%%%%
if (length(region(:))>0);
 xmin = region(1);
 xmax = region(2);
 ymin = region(3);
 ymax = region(4);

 indx_x = find(x1>=xmin & x1<=xmax);
 indx_y = find(y1>=ymin & y1<=ymax);

  x1_new=x1(indx_x);
  y1_new=y1(indx_y);
  [X1,Y1]=meshgrid(x1_new,y1_new);
  xpixel=X1(:);
  ypixel=Y1(:);
  x1_out=x1_new;
  y1_out=y1_new;
else
  x1_new = x1;
  y1_new = y1;
  [X1,Y1]=meshgrid(x1_new,y1_new);
  xpixel = X1(:);
  ypixel = Y1(:);
  x1_out=x1_new;
  y1_out=y1_new; 
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%
if (length(ref)>1);
     xref = ref(1);
     yref = ref(2);
%     ix_ref=find(xpixel>=(xref-5*dx) & xpixel<=(xref+5*dx));
%     iy_ref=find(ypixel>=(yref-5*dy) & ypixel<=(yref+5*dy));
     indx_ref=find(X1>=(xref-5*dx) & X1<=(xref+5*dx) & Y1>=(yref-5*dy) & Y1<=(yref+5*dy));
     disp(['reference point around: [',num2str(xref),',',num2str(yref),']']);
else
     indx_ref =[];
end

if (length(region(:))>0);
  npixel_all=length(Z1_new(:));
else
  npixel_all=length(Z1(:));
end

if exist(finc,'file');
   inc_data=load(finc);
   inc=inc_data.inc;
else 
   disp(['Warning: no incident file found: use default inc angle: 38.0 deg.']);
   logit_candis(['use default incident angle: 38.0 deg.']);
%   inc=38.0*ones(npixel_all,1);
   inc = 38.0;
end



%%%%%%%%%%%%%%%% prepare pixels and DEM file for deramping %%%%%%%%%%%%%
if (deramp==1);
   if (exist(mask_deramp,'file'));
      disp(['Using data in polygon of ',mask_deramp,' for estimating the ramp...']);
      mask_data=load(mask_deramp);
      xmask=mask_data(:,1);
      ymask=mask_data(:,2);
      indx_ramp=~inpolygon(xpixel,ypixel,xmask,ymask);
      xramp=xpixel(indx_ramp);
      yramp=ypixel(indx_ramp);
   else
      disp(['Using data of all pixels for estimating the ramp ...']);
      indx_ramp=[1:length(xpixel)]';
      xramp=xpixel;
      yramp=ypixel;
   end

   if strcmp(coordinates_type,'geographic');
      [xdem,ydem,zdem]=grdread2('dem.grd');
   elseif strcmp(coordinates_type,'radar');
      [xdem,ydem,zdem]=grdread2('dem_ra.grd');
   else
      error(['***Unrecognized coordinates_type ',coordinates_type]);
   end

   [XDEM,YDEM]=meshgrid(xdem,ydem);
   xtopo=double(XDEM(:));
   ytopo=double(YDEM(:));
   ztopo=double(zdem(:)/1000);
   indx_topo_good = ~isnan(ztopo);
   xtopo_good=xtopo(indx_topo_good);
   ytopo_good=ytopo(indx_topo_good);
   ztopo_good=ztopo(indx_topo_good);
%   topo_pixel=griddata(xtopo_good,ytopo_good,ztopo_good,xpixel,ypixel);
   topo_pixel=griddata(xtopo_good,ytopo_good,ztopo_good,xpixel,ypixel,'nearest');
   topo_ramp=topo_pixel(indx_ramp);
   clear xtopo ytopo ztopo XDEM YDEM

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5


%%%%
npixel_all = length(Z1(:)); % number of pixel per interferogram
npixel_patch = ceil(npixel_all/npatch); %number of pixel per patch
pi1 = zeros(npatch,1);
pi2 = zeros(npatch,1);

   
f_patch_list=fopen('PATCH.list','w');
for n=1:npatch;
   patch_id = [upper('patch_'),num2str(n)];
   fprintf(f_patch_list,'%s\n',[upper('patch_'),num2str(n)]);
   dir_patch=[upper('patch_'),num2str(n)];
   if ~exist(dir_patch,'dir')
     mkdir(dir_patch);
   end

   if (n<npatch);
     indx1 = (n-1)*npixel_patch+1;
     indx2 = indx1+npixel_patch-1;
   else
     indx1=(npatch-1)*npixel_patch+1;
     indx2=npixel_all;
   end

   n_this_patch=length([indx1:indx2]);

   disp(['Making phase for ',patch_id]);
   los_in_patch = zeros(n_this_patch,nintf,'single');
   if (isweight>0);
     corr_in_patch = zeros(n_this_patch,intf,'single');
   else 
     corr_in_patch = 1;
   end


   for k = 1:nintf;
     date1_now = datestr(day1(k),'yyyymmdd');
     date2_now = datestr(day2(k),'yyyymmdd');
     dir_now = [dir_intf,'/',date1_now,'_',date2_now];
     disp(['working on interferogram:  ',date1_now,'_',date2_now,'   [',num2str(k),'/',num2str(nintf),']']);    
     [x1,y1,z1]=grdread2([dir_now,'/',funwrap]);
      if (length(region(:))>0);
        z1_new = z1(indx_y,indx_x);
        los_this_intf = -wavelength*z1_new(:)/4/pi;
      else
        los_this_intf = -wavelength*z1(:)/4/pi;
      end     
      if (deramp==1);
       disp(['deramping the interferogram             : ',date1_now,'_',date2_now]);
       los_ramp = los_this_intf(indx_ramp);
       pfit = fit_ramp_topo(los_ramp,xramp,yramp,topo_ramp);
       los_model =pfit(1)*xpixel+pfit(2)*ypixel+pfit(3)*topo_pixel+pfit(4);
       los_this_intf_new=los_this_intf-los_model;

      else 
       los_this_intf_new=los_this_intf; 
      end

      if (length(ix_ref)>0);
       disp(['setting reference point for interferogram: ',date1_now,'_',date2_now]);
       ref_this_intf=los_this_intf_new(indx_ref);
       good_ref = ref_this_intf(~isnan(ref_this_intf));
       if (length(good_ref)>0);
         ref_now = mean(good_ref);
       else
        disp(['Warning: no good pixels around the reference point for ',date1_now,'_',date2_now]);
        ref_now =0;
       end
       los_this_intf_new2=los_this_intf_new -ref_now;
      else
       los_this_intf_new2=los_this_intf_new;
      end
      los_in_patch(:,k)=los_this_intf_new2(indx1:indx2);


      if (isweight>0);
        [x2,y2,z2]=grdread2([dir_now,'/',fcorr]);
         if (length(x1)~=length(x2) | length(y1)~=length(y2));
           error(['Size of ', funwrap ' != ', fcorr]);
         end
         z2(isnan(z2))=0;
         if (length(region(:))>0);
            z2_new = z2(indx_y,indx_x);
            corr_this_intf = z2_new(:);
     
         else
            corr_this_intf = z2(:);
         end
         corr_in_patch(:,k)=corr_this_intf(indx1:indx2);
      end

   end

   if length(inc(:))>1;
     inc_patch = inc(indx1:indx2);
   else
     inc_patch = 38;
   end
   xpixel_patch=xpixel(indx1:indx2);
   ypixel_patch=ypixel(indx1:indx2);
   save([currdir,'/',patch_id,'/sbas_in_INT',num2str(0),'.mat'],'day1','day2','dBp','day_sar',...,
       'los_in_patch','xpixel_patch','ypixel_patch','inc_patch','corr_patch');  
   
end
fclose(f_patch_list);


x1 = x1_out;
y1 = y1_out;
%save([currdir,'/','sbas_info.mat'],'day1','day2','day_sar',...
%    'dBp','x1','y1','xpixel','ypixel','pi1','pi2','indx_ref');
