function candis_preproc(frun);
%  prepare the input file for SBAS 
%
%  Usage: candis_preproc(f_intf_list);
%
%  f_intf_list is optional; use value parms.intf_list if not specified
%  
% Last Updated by Kang Wang on 04/09/2018
%
% Last Updated by Kang Wang on 08/16/2019

fparms='parms_candis.mat';
parms=load(fparms);
currdir=pwd;
coordinates_type=parms.coordinates_type;

xbound=parms.xbound;
ybound=parms.ybound;
xref=parms.xref;
yref=parms.yref;
xpixel=parms.xpixel;
ypixel=parms.ypixel;



if (length(xbound)<2);
   xmin=-1.0e9;
   xmax=1.0e9;
else
   xmin=xbound(1);
   xmax=xbound(2);
end

if (length(ybound)<2);
    ymin=-1.0e9;
    ymax=1.0e9;
else
    ymin=ybound(1);
    ymax=ybound(2);
end



region=[xmin xmax ymin ymax];
setparm_candis('region',[xmin xmax ymin ymax]);

currdir=pwd;
wavelength=parms.wavelength;
funwrap=parms.unwrap_file;
flos=parms.los_file;
fcorr =parms.corr_file;
isweight = parms.is_weight;
dir_intf=parms.dir_intf;
dir_weather_model = parms.dir_weather_model;

if strcmp(dir_intf(length(dir_intf)),'/');
    dir_intf=dir_intf(1:length(dir_intf));
end

if strcmp(dir_weather_model(length(dir_weather_model)),'/');
    dir_weather_model=dir_weather_model(1:length(dir_weather_model));
end

[path_unwrap,name_unwrap,ext_unwrap]=fileparts(flos);

dir_intf=parms.dir_intf;
fbl=parms.baseline_info;
if (nargin<1);
  frun=parms.intf_list;
else
  setparm_candis('sbas_intf_list',frun);
end
fuse=parms.dates_to_use;
fhgt=parms.dem_file;
finc=parms.incident_file;

max_bp=parms.max_bp;
min_bp=parms.min_bp;

min_bt=parms.min_bt;
max_bt=parms.max_bt;
npatch=parms.num_patches;
sbas_type=parms.sbas_type;

date_start = parms.date_start;
date_end=parms.date_end;

if length(date_start)<1;
   day_start = -1.0e5; %a negative number
else
   day_start = datenum(date_start,'yyyymmdd');
end

if length(date_end)<1;
   day_end=1.0e15; % a very large number
else
   day_end= datenum(date_end,'yyyymmdd');
end
%ref=parms.reference_point;

deramp=parms.deramp;
coordinates_type=parms.coordinates_type;
if (strcmp(coordinates_type,'geographic'));
  mask_deramp='eq_mask_ll.dat';
else
  mask_deramp='eq_mask_ra.dat';
end


%rwm=parms.remove_weather_model;
%if (rwm>0);
%   faps_wm = parms.aps_weather_model;
%   data_aps_wm = load(faps_wm);
%   day_aps = data_aps_wm.day_sar;
%   aps_wm = data_aps_wm.aps;
%end


if exist(fbl,'file');
    [date_tmp,bp_tmp]=textread(fbl,'%s %f\n');
else
    error(['baseline_info ',fbl,' does not exist.']);
end

if exist(frun,'file');
    [intf_list]=textread(frun,'%s\n');
    nlist=length(intf_list);
    disp(['Number of Total Interferograms: ',num2str(nlist)]);
    day1_all=zeros(nlist,1);
    day2_all=zeros(nlist,1);
    for k=1:nlist;
        intf_now=intf_list{k};
        date1_now=intf_now(1:8);
        date2_now=intf_now(10:17);
        day1_all(k)=datenum(date1_now,'yyyymmdd');
        day2_all(k)=datenum(date2_now,'yyyymmdd');
    end
    
     
else
     error(['intf_list ',frun, 'does not exist.']);
end

day_tmp1=datenum(date_tmp,'yyyymmdd');
[day_tmp2,indx_tmp1]=unique(day_tmp1);
bp_tmp2=bp_tmp(indx_tmp1);
[day_tmp3,indx_tmp2]=sort(day_tmp2);
bp_tmp3=bp_tmp2(indx_tmp2);

if exist(fuse,'file')>0;
    [dates_use]=textread(fuse,'%s\n');
    day_use_tmp=datenum(dates_use,'yyyymmdd');
    day_use1=sort(unique(day_use_tmp));
else
    disp(['Warning: dates_to_use ',fuse, ' does not exist. Trying with all dates...']);
    logit_candis(['Warning: dates_to_use ',fuse, ' does not exist. Trying with all dates...']);
    day_use1 = day_tmp3;
end

indx_use=find(day_use1>=day_start&day_use1<=day_end);
day_use=sort(unique(day_use1(indx_use)));

fout1=fopen('dates.use','w');
for k=1:length(unique(day_use));
  fprintf(fout1,'%s\n',datestr(day_use(k),'yyyymmdd'));
end
fclose(fout1);

[indx_use_tmp,tmp]=ismember(day_tmp3,day_use);
indx_use=find(indx_use_tmp>0);
indx_not_use=find(indx_use_tmp<1);
day_sar=day_tmp3(indx_use); 
bp_sar=bp_tmp3(indx_use);  %baseline after excluding the bad dates

nsar=length(day_sar);
disp(['Number of SAR acquisitions to use :',num2str(nsar)]);
logit_candis(['Number of SAR acquisitions to use: ',num2str(nsar)]);

day_not_use=day_tmp3(indx_not_use);
for k=1:length(day_not_use);
  date_not_use=datestr(day_not_use(k),'yyyymmdd');
  %disp(['Exclude interferograms containing: ',date_not_use]);
  logit_candis(['Exclude interferograms containing: ',date_not_use]);
end


[indx_tmp1]=~ismember(day1_all,day_not_use);
[indx_tmp2]=~ismember(day2_all,day_not_use);
indx_tmp=indx_tmp1.*indx_tmp2;
indx_new=find(indx_tmp>0);

day1_new=day1_all(indx_new);
day2_new=day2_all(indx_new);

nintf=length(day1_new);
%disp(['Number of Interferograms contained in the dates_to_use: ',num2str(nintf)]);
logit_candis(['Number of Interferograms contained in the dates_to_use: ',num2str(nintf)]);

day1=[];
day2=[];
dBp=[];

for k=1:nintf;
   day1_now=day1_new(k);
   day2_now=day2_new(k);
   dt=abs(day1_now-day2_now);
   indx1=find(day_sar==day1_now);
   indx2=find(day_sar==day2_now);
   Bp=abs(bp_sar(indx1)-bp_sar(indx2));
   if (dt>=min_bt & dt<=max_bt & Bp>= min_bp & Bp<=max_bp);
     day1=[day1;day1_now];
     day2=[day2;day2_now];
     dBp=[dBp;bp_sar(indx2)-bp_sar(indx1)];
   end
end

nintf=length(day1);
disp(['Number of Interferograms to use: ',num2str(nintf)]);
logit_candis(['Number of Interferograms satisfying the baseline criteria: ',num2str(nintf)]);

for k=1:1;
  date1_now=datestr(day1(k),'yyyymmdd');
  date2_now=datestr(day2(k),'yyyymmdd');
  dir_now=[dir_intf,'/',date1_now,'_',date2_now];
  grdfile1=[dir_now,'/',flos];
  [x1,y1,Z1]=grdread2(grdfile1);
  if (isweight>0);
   grdfile2=[dir_now,'/',fcorr];
   [x2,y2,Z2]=grdread2(grdfile2);
   Z2(isnan(Z2))=0;
  end

  [X1,Y1]=meshgrid(x1,y1);
   xall =X1(:);
   yall =Y1(:);
end

dx=mean(diff(x1));
dy=mean(diff(y1));

if (length(region(:))>0);
 xmin = region(1);
 xmax = region(2);
 ymin = region(3);
 ymax = region(4);

 indx_x = find(x1>=xmin & x1<=xmax);
 indx_y = find(y1>=ymin & y1<=ymax);
 indx_box = find(xall >=xmin & xall<=xmax & yall >=ymin & yall <=ymax);

 Z1_new=Z1(indx_y,indx_x);
 x1_new=x1(indx_x);
 y1_new=y1(indx_y);
 [X1_new,Y1_new]=meshgrid(x1_new,y1_new);
 xpixel=X1_new(:);
 ypixel=Y1_new(:);
else
 xpixel = xall;
 ypixel = yall;
end


if ((length(xref)>1) && (length(yref)>1) );
  fprintf('%s\n',['Using pixels within in xref and yref as reference pixels']);
  indx_ref=find(xpixel>= min(xref) & xpixel<= max(xref) & ypixel>= min(yref) & ypixel<= max(yref));
   xxref=mean(xref);
   yyref=mean(yref);

elseif ((length(xref)==1) && (length(yref)==1));
  fprintf('%s\n',['Using pixels aroun [',sprintf('%.4f',xref), ',', sprintf('%.4f',yref), 'as reference pixel']);     
  xc_ref=xref;
  yc_ref=yref;
  indx_ref=find(xpixel>= xc_ref-10*dx & xpixel<= xc_ref+10*dx & ypixel>= yc_ref-10*dy & ypixel<= yc_ref+10*dy);
  xxref=mean(xpixel(indx_ref));
  yyref=mean(ypixel(indx_ref));  

elseif (exist('ref.xy','file'))
   fprintf('%s\n',['Using pixels around the value in ref.xy as reference pixels']);
   ref_data=load('ref.xy');
   xc_ref=mean(ref_data(:,1));
   yc_ref=mean(ref_data(:,2));
   indx_ref=find(xpixel>= xc_ref-5*dx & xpixel<= xc_ref+5*dx & ypixel>= yc_ref-5*dy & ypixel<= yc_ref+5*dy);
   xxref=mean(xpixel(indx_ref));
   yyref=mean(ypixel(indx_ref));
else
   fprintf('%s\n',['No reference pointion information given!'])
   indx_ref=[];
end




npixel_all=length(xpixel);
if exist(finc,'file');
   inc_data=load(finc);
   inc=inc_data.inc;
else 
   disp(['Warning: no incident file found: use default inc angle: 38.0 deg.']);
   logit_candis(['use default incident angle: 38.0 deg.']);
%   inc=38.0*ones(npixel_all,1);
   inc = 38.0;
end



%%%%%%%%%%%%%%%% prepare pixels and DEM file for deramping %%%%%%%%%%%%%
if (deramp==1);
   if (exist(mask_deramp,'file'));
      disp(['Using data in polygon of ',mask_deramp,' for estimating the ramp...']);
      mask_data=load(mask_deramp);
      xmask=mask_data(:,1);
      ymask=mask_data(:,2);
      indx_ramp=~inpolygon(xpixel,ypixel,xmask,ymask);
      xramp=xpixel(indx_ramp);
      yramp=ypixel(indx_ramp);
   else
      disp(['Using data of all pixels for estimating the ramp ...']);
      indx_ramp=[1:length(xpixel)]';
      xramp=xpixel;
      yramp=ypixel;
   end

   if strcmp(coordinates_type,'geographic');
      [xdem,ydem,zdem]=grdread2('dem.grd');
   elseif strcmp(coordinates_type,'radar');
      [xdem,ydem,zdem]=grdread2('dem_ra.grd');
   else
      error(['***Unrecognized coordinates_type ',coordinates_type]);
   end

   [XDEM,YDEM]=meshgrid(xdem,ydem);
   xtopo=double(XDEM(:));
   ytopo=double(YDEM(:));
   ztopo=double(zdem(:)/1000);
   indx_topo_good = ~isnan(ztopo);
   xtopo_good=xtopo(indx_topo_good);
   ytopo_good=ytopo(indx_topo_good);
   ztopo_good=ztopo(indx_topo_good);
%   topo_pixel=griddata(xtopo_good,ytopo_good,ztopo_good,xpixel,ypixel);
   topo_pixel=griddata(xtopo_good,ytopo_good,ztopo_good,xpixel,ypixel,'nearest');
   topo_ramp=topo_pixel(indx_ramp);
   clear xtopo ytopo ztopo XDEM YDEM

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5

los_in=zeros(npixel_all,nintf,'single');
if (isweight>0);
  corr_in = zeros(npixel_all,nintf,'single'); %  create a matrix to hold the correlation if needed
end


for k=1:nintf;
       date1_now=datestr(day1(k),'yyyymmdd');
       date2_now=datestr(day2(k),'yyyymmdd');
       dir_now=[dir_intf,'/',date1_now,'_',date2_now];
       disp(['loading LOS disp. for        ',date1_now,'_',date2_now,'   [',num2str(k),'/',num2str(nintf),']']);
       [x1,y1,zzin]=grdread2([dir_now,'/',flos]);
       if (isweight>0);
          disp(['loading correlation for  ',date1_now,'_',date2_now,'   [',num2str(k),'/',num2str(nintf),']']);
         [x2,y2,corr_all]=grdread2([dir_now,'/',fcorr]);
         corr_all(isnan(corr_all))=0; %fix bad values
         if (length(x1)~=length(x2) | length(y1)~=length(y2));
           error(['Size of ', flos ' != ', fcorr]);
         end
       end

%         los_this_intf=-wavelength*phs_all(:)/4/pi;
         los_this_intf=zzin; % in the new version, the input is los displacement

         if (isweight>0);
           if (length(region(:))>0);
              corr_tmp = corr_all(indx_y,indx_x);
              corr_in(:,k) = corr_tmp(:);
           else
              corr_tmp = corr_all;
              corr_in(:,k)=corr_tmp(:);
           end
         end

       if (deramp==1); % deramp the interferogram before CSS
          disp(['deramping the interferograms....']);
          los_ramp=los_this_intf(indx_ramp);
          pfit=fit_ramp_topo(los_ramp,xramp,yramp,topo_ramp);
          los_model=pfit(1)*xpixel+pfit(2)*ypixel+pfit(3)*topo_pixel+pfit(4);
          los_model=reshape(los_model,size(los_this_intf));

       else
          los_model=0;
       end
      
       los_this_intf_new=los_this_intf-los_model;
     
        if (length(region(:))>0);
          los_box = los_this_intf_new(indx_box);
        else
          los_box=los_this_intf_new;
       end

       if (length(indx_ref)>0);
          ref_this_intf=los_box(indx_ref);
          good_ref=ref_this_intf(~isnan(ref_this_intf));
            if (length(good_ref)>0);
              disp(['Setting reference point for interferogram ',date1_now,'_',date2_now, '  [',num2str(k),'/',num2str(nintf),']']);
              ref_now=mean(good_ref);
            else
              disp(['Warning: no good pixels around the reference point; use the closest point ...']);
              indx_good_pixel = ~isnan(los_box);
              los_good=los_box(indx_good_pixel);
              xgood=xpixel(indx_good_pixel);
              ygood=ypixel(indx_good_pixel);
              dl = sqrt((xgood-xxref).^2+(ygood-yyref).^2);
              [dl_min,indx_min]=min(dl);
              ref_now=mean(los_good(indx_min));
            end
        else
           ref_now = 0;
        end

       los_this_intf = los_box-ref_now;
       los_in(:,k)=los_this_intf;
end


   
f_patch_list=fopen('PATCH.list','w');
for k=1:npatch;
   fprintf(f_patch_list,'%s\n',[upper('patch_'),num2str(k)]);
   dir_patch=[upper('patch_'),num2str(k)];
   if ~exist(dir_patch,'dir')
     mkdir(dir_patch);
   end
end
fclose(f_patch_list);

disp(['saving the data to ',num2str(npatch),' patches...']);

npixel_patch=ceil(npixel_all/npatch);
pi1=zeros(npatch,1);
pi2=zeros(npatch,1);

for nn=1:npatch;
   patch_id=[upper('patch_'),num2str(nn)];
  if (nn<npatch)
     indx1 = (nn-1)*npixel_patch+1;
     indx2 = indx1+npixel_patch-1;

  else
    indx1=(npatch-1)*npixel_patch+1;
    indx2=npixel_all;
  end
      
   px1 = indx1;
   px2 = indx2;
   pi1(nn)=px1;
   pi2(nn)=px2;
   disp(['patch_',num2str(nn),' from line ',num2str(indx1),' to ',num2str(indx2),'...']);
   los_in_patch=los_in(indx1:indx2,:);

   if (isweight>0);
     corr_patch = corr_in(indx1:indx2,:);
    else
     corr_patch = 1;
   end

   if length(inc(:))>1;
     inc_patch = inc(indx1:indx2);
   else
     inc_patch = 38;
   end
 
   xpixel_patch=xpixel(indx1:indx2);
   ypixel_patch=ypixel(indx1:indx2);
   save([currdir,'/',patch_id,'/sbas_in_INT',num2str(0),'.mat'],'day1','day2','dBp','day_sar',...,
       'los_in_patch','xpixel_patch','ypixel_patch','inc_patch','corr_patch');
end

if (length(region(:))>0);
  x1 = x1_new;
  y1 = y1_new;
end 

setparm_candis('day1',day1);
setparm_candis('day2',day2);
setparm_candis('dBp',dBp);
setparm_candis('day_sar',day_sar);
setparm_candis('x1',x1);
setparm_candis('y1',y1);
setparm_candis('xpixel',xpixel);
setparm_candis('ypixel',ypixel);
setparm_candis('pi1',pi1);
setparm_candis('pi2',pi2);
%setparm_candis('inc',inc);
setparm_candis('indx_ref',indx_ref);
