function candis_fix_unwrap_new(fparm);

if nargin<1;
    fparm='parms_candis.mat';
end

fparm='parms_candis.mat';
currdir=pwd;
parms=load(fparm);
dir_intf=parms.dir_intf;
if strcmp(dir_intf(length(dir_intf)),'/');
  dir_intf=dir_intf(1:length(dir_intf)-1);
end
fbl=parms.baseline_info;
frun=parms.intf_list;
fuse=parms.dates_to_use;
funwrap=parms.unwrap_file;
funwrap=funwrap(1:length(funwrap)-4);
max_bp=parms.max_bp;
min_bp=parms.min_bp;

min_bt=parms.min_bt;
max_bt=parms.max_bt;

if exist(fbl,'file');
    [date_tmp,bp_tmp]=textread(fbl,'%s %f\n');
else
    error(['baseline_info ',fbl,' does not exist.']);
end

if exist(frun,'file');
    [intf_list]=textread(frun,'%s\n');
    nlist=length(intf_list);
    disp(['Number of Total Interferograms: ',num2str(nlist)]);
    day1_all=zeros(nlist,1);
    day2_all=zeros(nlist,1);
    for k=1:nlist;
        intf_now=intf_list{k};
        date1_now=intf_now(1:8);
        date2_now=intf_now(10:17);
        day1_all(k)=datenum(date1_now,'yyyymmdd');
        day2_all(k)=datenum(date2_now,'yyyymmdd');
    end


else
     error(['dates_run ',run, 'does not exist.']);
end

day_tmp1=datenum(date_tmp,'yyyymmdd');
[day_tmp2,indx_tmp1]=unique(day_tmp1);
bp_tmp2=bp_tmp(indx_tmp1);
[day_tmp3,indx_tmp2]=sort(day_tmp2);
bp_tmp3=bp_tmp2(indx_tmp2);

if exist(fuse,'file')>0;
    [dates_use]=textread(fuse,'%s\n');
else
    disp(['Warning: dates_to_use ',fuse, ' does not exist. Use all dates...']);
    logit_candis(['Warning: dates_to_use ',fuse, ' does not exist. Use all dates...'])
end

day_use_tmp=datenum(dates_use,'yyyymmdd');
day_use=sort(unique(day_use_tmp));


[indx_use_tmp,tmp]=ismember(day_tmp3,day_use);
indx_use=find(indx_use_tmp>0);
indx_not_use=find(indx_use_tmp<1);
day_sar=day_tmp3(indx_use);
bp_sar=bp_tmp3(indx_use);  %baseline after excluding the bad dates

nsar=length(day_sar);
disp(['Number of SAR acquisitions to use :',num2str(nsar)]);

day_not_use=day_tmp3(indx_not_use);

[indx_tmp1]=~ismember(day1_all,day_not_use);
[indx_tmp2]=~ismember(day2_all,day_not_use);
indx_tmp=indx_tmp1.*indx_tmp2;
indx_new=find(indx_tmp>0);

day1_new=day1_all(indx_new);
day2_new=day2_all(indx_new);

nintf=length(day1_new);

day1=[];
day2=[];
dBp=[];

for k=1:nintf;
   day1_now=day1_new(k);
   day2_now=day2_new(k);
   dt=abs(day1_now-day2_now);
   indx1=find(day_sar==day1_now);
   indx2=find(day_sar==day2_now);
   Bp=abs(bp_sar(indx1)-bp_sar(indx2));
   if (dt>=min_bt & dt<=max_bt & Bp>= min_bp & Bp<=max_bp);
     day1=[day1;day1_now];
     day2=[day2;day2_now];
     dBp=[dBp;bp_sar(indx2)-bp_sar(indx1)];
   end
end

nintf=length(day1);
disp(['Number of Interferograms to use: ',num2str(nintf)]);

for k=1:nintf;
    date1=datestr(day1(k),'yyyymmdd');
    date2=datestr(day2(k),'yyyymmdd');
    this_intf=[date1,'_',date2];
    disp(['reading the intf ',this_intf, '   [',num2str(k),'/',num2str(nintf),']']);
    [xx,yy,zin{k}]=grdread2([dir_intf,'/',this_intf,'/',funwrap,'.grd']);
end


C_indx=combnk([1:nsar],3);
nloop=size(C_indx,1);
ngood=0;
intf_good=[];


C_indx4=combnk([1:nsar],4);
nloop4=size(C_indx4,1);
ngood4=0;
intf_good4=[];



for n=1:nloop;
   c_now=C_indx(n,:);
   indx1=c_now(1);
   indx2=c_now(2);
   indx3=c_now(3);
   dd1=day_sar(indx1);
   dd2=day_sar(indx2);
   dd3=day_sar(indx3);

   dd=sort([dd1 dd2 dd3]);
   d1=dd(1);
   d2=dd(2);
   d3=dd(3);

   iid1=find(day1==d1 & day2==d2);
   iid2=find(day1==d2 & day2==d3);
   iid3=find(day1==d1 & day2==d3);
   nn1=length(iid1);
   nn2=length(iid2);
   nn3=length(iid3);

  if (nn1>0 & nn2>0 & nn3>0);
    ngood=ngood +1;
    intf_good=[intf_good;[iid1 iid2 iid3]];
  end
end

disp(['Number of unique Triangulars   :',num2str(ngood)]);

for n=1:nloop4;
   c_now4=C_indx4(n,:);
   indx1=c_now4(1);
   indx2=c_now4(2);
   indx3=c_now4(3);
   indx4=c_now4(4);
   dd1=day_sar(indx1);
   dd2=day_sar(indx2);
   dd3=day_sar(indx3);
   dd4=day_sar(indx4);

   dd=sort([dd1 dd2 dd3 dd4]);
   d1=dd(1);
   d2=dd(2);
   d3=dd(3);
   d4=dd(4);

   iid1=find(day1==d1 & day2==d2);
   iid2=find(day1==d2 & day2==d3);
   iid3=find(day1==d3 & day2==d4);
   iid4=find(day1==d1 & day2==d4);
   
   nn1=length(iid1);
   nn2=length(iid2);
   nn3=length(iid3);
   nn4=length(iid4);

  if (nn1>0 & nn2>0 & nn3>0 & nn4);
    ngood4=ngood4 +1;
    intf_good4=[intf_good4;[iid1 iid2 iid3 iid4]];
  end
end
disp(['Number of unique squares   :',num2str(ngood4)]);

G1=zeros(ngood,nintf);
d1=zeros(ngood,1);

G2=zeros(ngood4,nintf);
d2=zeros(ngood4,1);

f_log1=fopen('phs.res','w');

for k=1:ngood;
    loop_now=intf_good(k,:);
    indx1=loop_now(1);
    indx2=loop_now(2);
    indx3=loop_now(3);
    str1=[datestr(day1(indx1),'yyyymmdd'),'_',datestr(day2(indx1),'yyyymmdd')];
    str2=[datestr(day1(indx2),'yyyymmdd'),'_',datestr(day2(indx2),'yyyymmdd')];
    str3=[datestr(day1(indx3),'yyyymmdd'),'_',datestr(day2(indx3),'yyyymmdd')];
    disp(['working on loop ',num2str(k),'/',num2str(ngood),'  ',str1,'+',str2,'-',str3]);
    zloop=zin{indx1}+zin{indx2}-zin{indx3};
    zloop_good=zloop(~isnan(zloop));
    phs_res=median(round(zloop_good/2/pi));
    date1_loop=datestr(day1(indx1),'yyyymmdd');
    date2_loop=datestr(day2(indx1),'yyyymmdd');
    date3_loop=datestr(day2(indx3),'yyyymmdd');

    fprintf(f_log1,'%3d %s %s %s\n',phs_res,date1_loop, date2_loop, date3_loop);
    d1(k)=phs_res;
    G1(k,indx1)=1;
    G1(k,indx2)=1;
    G1(k,indx3)=-1;
end
fclose(f_log1);



for k=1:ngood4;
    loop_now=intf_good4(k,:);
    indx1=loop_now(1);
    indx2=loop_now(2);
    indx3=loop_now(3);
    indx4=loop_now(4);
    str1=[datestr(day1(indx1),'yyyymmdd'),'_',datestr(day2(indx1),'yyyymmdd')];
    str2=[datestr(day1(indx2),'yyyymmdd'),'_',datestr(day2(indx2),'yyyymmdd')];
    str3=[datestr(day1(indx3),'yyyymmdd'),'_',datestr(day2(indx3),'yyyymmdd')];
    str4=[datestr(day1(indx4),'yyyymmdd'),'_',datestr(day2(indx4),'yyyymmdd')];
    disp(['working on loop ',num2str(k),'/',num2str(ngood4),'  ',str1,'+',str2,'+',str3,'-',str4]);
    zloop=zin{indx1}+zin{indx2}+zin{indx3}-zin{indx4};
    zloop_good=zloop(~isnan(zloop));
    phs_res=median(round(zloop_good/2/pi));
    date1_loop=datestr(day1(indx1),'yyyymmdd');
    date2_loop=datestr(day2(indx1),'yyyymmdd');
    date3_loop=datestr(day2(indx3),'yyyymmdd');

%    fprintf(f_log1,'%3d %s %s %s\n',phs_res,date1_loop, date2_loop, date3_loop);
    d2(k)=phs_res;
    G2(k,indx1)=1;
    G2(k,indx2)=1;
    G2(k,indx3)=1;
    G2(k,indx4)=-1;
end
G=[G1;G2];
d=[d1;d2];



f_log2=fopen('phs.shift','w');
disp(['Updating the interferograms ...']);
for k=1:nintf;
    this_intf=intf_list{k};
    disp(['adding ',num2str(-mm(k)),'*2pi to ',this_intf, '   [',num2str(k),'/',num2str(nintf),']']);
    zout_new=zin{k}-mm(k)*2*pi;
    fprintf(f_log2,'%s %10.2f %12.6f\n',this_intf,[mm(k),dres(k)]);
    grdwrite2(xx,yy,zout_new,[dir_intf,'/',this_intf,'/',funwrap,'_new.grd']);
end
fclose(f_log2);
