function candis_css_linear(step1,step2,fparms);
% Doing the css and SBAS for lienar deformation processes
%
%  Usage: candis_css_nolineaer(step1,step2,fparms);
%
%
% by Kang Wang in Jan. 2018
currdir=pwd;

if (nargin <3);
     fparms='parms_candis.mat';
     parms=load(fparms);
end

if (nargin<1);
   num_iteration=parms.num_iteration;
   step1 = 0;
   step2 = num_iteration;
end

info=load('sbas_info.mat');
day_sar=info.day_sar;
day1=info.day1;
day2=info.day2;
x1=info.x1;
y1=info.y1;
pi1=info.pi1;
pi2=info.pi2;
dBp=info.dBp;
indx_ref=info.indx_ref;

nx=length(x1);
ny=length(y1);


xpixel=info.xpixel;
ypixel=info.ypixel;
nsar=length(day_sar);
nintf=length(day1);

num_iteration=parms.num_iteration;
max_t_stack=parms.max_t_stack;
sbas_steps=parms.sbas_steps;
smooth=parms.smooth;
pvalue = parms.value_spline;
npatch=parms.num_patches;
deramp=parms.deramp;
%mask_deramp=parms.deramp_mask_polygon;
coordinates_type=parms.coordinates_type;
if (strcmp(coordinates_type,'geographic'));
  mask_deramp='eq_mask_ll.dat';
else
  mask_deramp='eq_mask_ra.dat';
end


los_in_all=[];
disp(['Loading original phase data ..']);

for n=1:npatch;
  disp(['... working on PATCH_',num2str(n)]);
  data=load([currdir,'/','PATCH_',num2str(n),'/','sbas_in_INT',num2str(0),'.mat']);
  los_in_all=[los_in_all;data.los_in_patch];
  incpatch{n}=data.inc_patch;
  xpatch{n}=data.xpixel_patch;
  ypatch{n}=data.ypixel_patch;
  clear data;
end

if (deramp==2);
   if (exist(mask_deramp,'file'));
      disp(['Using data in polygon of ',mask_deramp,' for estimating the ramp...']);
      mask_data=load(mask_deramp);
      xmask=mask_data(:,1);
      ymask=mask_data(:,2);
      indx_ramp=~inpolygon(xpixel,ypixel,xmask,ymask);
      xramp=xpixel(indx_ramp);
      yramp=ypixel(indx_ramp);
   else
      disp(['Using data of all pixels for estimating the ramp ...']);
      indx_ramp=[1:length(xpixel)]';
      xramp=xpixel;
      yramp=ypixel;
   end
   
   if strcmp(coordinates_type,'geographic');
      [xdem,ydem,zdem]=grdread2('dem.grd');
   elseif strcmp(coordinates_type,'radar');
      [xdem,ydem,zdem]=grdread2('dem_ra.grd');
   else
      error(['***Unrecognized coordinates_type ',coordinates_type]);
   end

   [XDEM,YDEM]=meshgrid(xdem,ydem);
   xtopo=double(XDEM(:));
   ytopo=double(YDEM(:));
   ztopo=double(zdem(:)/1000);
   indx_topo_good = ~isnan(ztopo);
   xtopo_good=xtopo(indx_topo_good);
   ytopo_good=ytopo(indx_topo_good);
   ztopo_good=ztopo(indx_topo_good);
%   topo_pixel=griddata(xtopo,ytopo,ztopo,xpixel,ypixel,'nearest');
   topo_pixel=griddata(xtopo_good,ytopo_good,ztopo_good,xpixel,ypixel,'nearest');
   topo_ramp=topo_pixel(indx_ramp);
   clear xtopo ytopo ztopo XDEM YDEM

end

day_min=-max_t_stack;
day_max=max_t_stack;

disp(['###Start the Common-Scene-Stacking (CSS)###... ']);
disp(['Time interval to stack  : ',num2str(day_min) ,' to ',num2str(day_max),' days']);

if (step1 < 0 | step2 > num_iteration |step1 > step2);
   error(['The step1 and step2 are not correct: ',num2str(step1),' ',num2str(step2)]);
end

for k=step1:step2;
   disp(['##### Iteration: ',num2str(k),'######']);
   if (k<1);
       tt1=1:floor(nsar/2);
       nn1=length(tt1);
      nn2=nsar-nn1;
      tt2=nn2:-1:1;
      xxx=[tt1 tt2];
      ANC=10*xxx/max(xxx); %start from the middle
   else
         disp(['Doing the CSS assuming linear deformation process...']);
         [aps_out,nstack]=calculate_aps_linear(day1,day2,los_in_all,day_sar,day_min,day_max,ANC);  
         ANC=get_anc(day_sar,aps_out);    
   
        disp(['Saving the APS data ... '])
        save([currdir,'/','ANC_INT',num2str(k),'.mat'],'ANC','aps_out',...
         'day_sar','nstack','x1','y1','xpixel','ypixel','-v7.3');

        los_in_clean=remove_aps(day1,day2,day_sar,los_in_all,aps_out);
       for nnn=1:nintf;
          date1_now=datestr(day1(nnn),'yyyymmdd');
          date2_now=datestr(day2(nnn),'yyyymmdd');
          los_this_intf=los_in_clean(:,nnn);
          if (ismember(k,floor(sbas_steps)));
             if (deramp==2);
               disp(['Deramping the interferogram ',date1_now,'_',date2_now, '  [',num2str(nnn),'/',num2str(nintf),']']);
               los_ramp=los_this_intf(indx_ramp);
               pfit=fit_ramp_topo(los_ramp,xramp,yramp,topo_ramp);
               los_model=pfit(1)*xpixel+pfit(2)*ypixel+pfit(3)*topo_pixel+pfit(4);
               los_this_intf_new=los_this_intf-los_model;
             else
               los_this_intf_new=los_this_intf;
             end
          else
              los_this_intf_new=los_this_intf;
          end

          if (length(indx_ref)>0);
            ref_this_intf=los_this_intf_new(indx_ref);
            good_ref=ref_this_intf(~isnan(ref_this_intf));
            if (length(good_ref)>0);
              disp(['Setting reference point for interferogram ',date1_now,'_',date2_now, '  [',num2str(nnn),'/',num2str(nintf),']']);
              ref_now=mean(good_ref);
            else
              disp(['Warning: no good pixels around the reference point...']);
              ref_now=0;
            end
          else
              ref_now=0;
          end

          los_in_clean(:,nnn)=los_this_intf_new-ref_now;
       end
  
        los_in_patch_new=make_patch(los_in_clean,pi1,pi2);
        npatch=length(los_in_patch_new);
        disp(['... writing SBAS input for Iteration # ',num2str(k)]);
        for n=1:npatch;
          los_in_patch=los_in_patch_new{n};
          xpixel_patch=xpatch{n};
          ypixel_patch=ypatch{n};
          inc_patch=incpatch{n};
          disp(['... ... working on ','PATCH_',num2str(n)]);
          save([currdir,'/','PATCH_',num2str(n),'/','sbas_in_','INT',num2str(k),'.mat'],...
             'day1','day2','dBp','day_sar','los_in_patch','xpixel_patch','ypixel_patch','inc_patch');       
          clear los_in_patch xpixel_patch ypixel_patch inc_patch
       end
        clear los_in_patch_new;
       
   end

      if (ismember(k,floor(sbas_steps)))
          disp(['Doing the SBAS for Iteration #: ',num2str(k)]);
          setparm_candis('value_spline',1);
          candis_sbas(k);
      end
end
