function candis(start_step,end_step);
% Matlab Code for Atmospheric Noise Depression through Iterative Stacking (MCANDIS);
%
%  Usage: mcandis(start_step, end_step);
%
%%%%%%%%%%%  Steps:  %%%%%%%%%%%
%  0:  fix the unwrapping ambiguity
%  1:  convert the unwrapped phase into native matlab format
%  2:  do the Common-Scene-Stacking (CSS) and SBAS
%  
%
% Kang Wang (kwang@seismo.berkeley.edu), Jan. 2018


currdir=pwd;

disp(['#############################################################']);
disp(['Codes for Atmospheric Noise Depression via Iterative Stacking']);
disp(['#################     CANDIS (Version 1.0)      #############']);

if nargin<1 || isempty(start_step)==1
    start_step=1;
end

if nargin<2 || isempty(end_step)==1
    end_step=2;
end

if (start_step == 0 & end_step>=start_step);
  disp(['MCANDIS Step 0 --- fix the unwrapping ambiguity']);
  candis_fix_unwrap;
  funwrap = getparm_candis('unwrap_file');
  funwrap=funwrap(1:length(funwrap)-4);
  funwrap=[funwrap,'_new.grd'];
  setparm_candis('unwrap_file',funwrap);
end

if (start_step == 1 & end_step>=start_step);
    disp(['MCANDIS Step 1 --- ','preparing for mat files']);
    candis_preproc;
end

if (start_step == 2 & end_step >= start_step);
   disp(['MCANDIS STEP 2 --- ','Doing the CSS and SBAS'])
    candis_css;
end


