function [aps_out,nstack]=calculate_aps_old(day1,day2,los_in,day_sar,day_min,day_max,ANC);
% 
% Usage:[aps_out,nstack]=calculate_aps_old(day1,day2,los_in,day_sar,day_min,day_max,ANC);
%
%
% by Kang Wang on 06/30/2017
% 
[npixel,nintf]=size(los_in);

%los_out=remove_deformation(day1,day2,day_sar,los_in,los_ts);
los_out=los_in;
nsar=length(day_sar);
[anc_sort,indx_sort]=sort(ANC,'descend');

aps_out=zeros(npixel,nsar,'single');
nstack=zeros(nsar,1);
for k=1:nsar;
    indx_now=indx_sort(k);
    day_in=day_sar(indx_now);

    date_in=datestr(day_in,'yyyymmdd');
    disp(['...Calculating the APS on ', date_in]);
    
%    [indx1,indx2,indx_sar1,indx_sar2]=get_index(day1,day2,day_sar,day_in,day_min,day_max);
     [indx1,indx2,indx_sar1,indx_sar2]=get_index_nearest(day1,day2,day_sar,day_in,day_min,day_max);

    nbackward=length(indx1);
    nforward=length(indx2);
    nstack(indx_now)=nbackward+nforward;
    if (nbackward>0)
      for nn=1:nbackward;
          date1=datestr(day1(indx1(nn)),'yyyymmdd');
          date2=datestr(day2(indx1(nn)),'yyyymmdd');
          dt1 = day2(indx1(nn))-day1(indx1(nn));
          dt_tmp=sprintf('%04d',dt1);
          disp(['=====>',date1,'_',date2,'        [',dt_tmp,' days]']);
      end
    end
    
    
    if (nforward>0);
      for nn=1:nforward;
        date1=datestr(day1(indx2(nn)),'yyyymmdd');
        date2=datestr(day2(indx2(nn)),'yyyymmdd');
        dt2 = -(day1(indx2(nn))-day2(indx2(nn)));
        dt_tmp=sprintf('%04d',dt2);
        disp(['      ',date1,'_',date2,'<=====','  [',dt_tmp,' days',']']);
      end
    end
    
    los_out_new=remove_aps(day1,day2,day_sar,los_out,aps_out);  %remove the aps from the interferograms
    if (nbackward>0);

        los_backward=los_out_new(:,indx1);
    else
        los_backward=[];
    end
    
    if (nforward>0);
        los_forward=-los_out_new(:,indx2);
    else
        los_forward=[];
    end

    if ((nbackward+nforward)>0);
      aps_out(:,indx_now)=(sum([los_backward,los_forward]')')/(nbackward+nforward);
    end
end

