(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1827781,      36688]
NotebookOptionsPosition[   1813366,      36432]
NotebookOutlinePosition[   1813722,      36448]
CellTagsIndexPosition[   1813679,      36445]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Supplementary material for :
  Possible fates of the spread of SARS - CoV - 2 in the Mexican context\
\>", "Title",
 CellChangeTimes->{{3.8060728558377247`*^9, 3.806072874506007*^9}, {
   3.8060729091596727`*^9, 3.806072923861532*^9}, 3.8082228963917923`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"0c34a4d5-f223-48ed-8f6b-ab58ad0db82c"],

Cell["\<\
ROYAL SOCIETY OPEN SCIENCE
Authors: Ivan Santamar\[IAcute]a - Holek, V\[IAcute]ctor Casta\[NTilde]o
10 August 2020\
\>", "Text",
 CellChangeTimes->{{3.8082241589535522`*^9, 3.80822419320979*^9}, {
  3.808652159633827*^9, 
  3.808652160117051*^9}},ExpressionUUID->"472d73b6-02f4-49fd-a884-\
617602385d29"],

Cell["\<\
This notebook is self-contained up to September 7, which is the day of the \
last actualization of the data.\[NonBreakingSpace]
The notebook is separated into sections and consists of two main parts: data \
and model.

The data part contains the tables of data of the pandemic.\[NonBreakingSpace]

The model part contains four programs (identical) embedded into a Manipulate \
command that facilitates the use of the equations when doing the fit of the \
data. The difference among the programs is the number of susceptible \
individuals and, therefore, the transmission constants ke, ki, and kv. The \
other parameters are equal and had remained fixed since July. Model sections \
are indicated by colors and the number of susceptible individuals.
Sections including summaries of the plots are also included for comparison.

The fit up to this day may be done by increasing the original number of \
susceptible individuals from 185 thousand to 900 thousand, 1.5millions, \
3millions, and 4.5 million. \[NonBreakingSpace]Each case is treated \
separately. This implies that the rates ki, ke and kv should decrease.\
\>", "Text",
 CellChangeTimes->{{3.806072931868651*^9, 3.80607297399611*^9}, {
   3.808220714788095*^9, 3.808220724911553*^9}, 3.808651662278597*^9, {
   3.80865169906406*^9, 3.8086521580559807`*^9}, {3.8086522359781227`*^9, 
   3.808652264710704*^9}, {3.8086530871351423`*^9, 3.808653090827804*^9}},
 Background->RGBColor[
  1, 0.5, 0],ExpressionUUID->"12a1e6fa-8e68-4bd6-90d3-516cabee0169"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DATA actualization until September 7
\
\>", "Title",
 CellChangeTimes->{{3.7968045829137897`*^9, 3.7968045882628*^9}, {
   3.796804621933743*^9, 3.796804623070675*^9}, {3.797073561954385*^9, 
   3.797073565243182*^9}, {3.797514069392561*^9, 3.797514070236122*^9}, {
   3.7988092299821587`*^9, 3.798809230358961*^9}, {3.798925187769965*^9, 
   3.798925188226013*^9}, {3.799272132213627*^9, 3.7992721322232323`*^9}, {
   3.800221289028778*^9, 3.800221347936035*^9}, {3.800221673151938*^9, 
   3.800221684845744*^9}, {3.800395572680925*^9, 3.800395601115426*^9}, {
   3.803740450015065*^9, 3.803740475383841*^9}, 3.803741002143422*^9, {
   3.8058107416756268`*^9, 3.8058107595383797`*^9}, {3.80822069323736*^9, 
   3.808220730722134*^9}, {3.808224133519175*^9, 3.8082241375493383`*^9}, 
   3.808650169039452*^9},
 Background->RGBColor[
  0.9, 1, 1],ExpressionUUID->"caad0943-f8db-446d-b2d0-0297cd3f2e0b"],

Cell[TextData[{
 "The data of confirmed cases, recovered individuals, and the number of \
deaths was collected from:\n\n",
 StyleBox["https://en.wikipedia.org/wiki/COVID-19_pandemic_in_Mexico",
  FontColor->RGBColor[0, 0, 1]],
 "\n\nand\n\n",
 StyleBox["https://es.wikipedia.org/wiki/Pandemia_de_enfermedad_por_\
coronavirus_de_2020_en_M\[EAcute]xico",
  FontColor->RGBColor[0, 0, 1]],
 "\n\nThese sites offer a succinct and comprehensible presentation of the \
data as well as a timeline of the data. Included are also other graphics and \
useful information."
}], "Text",
 CellChangeTimes->{{3.8086503424730463`*^9, 3.808650524214499*^9}, {
   3.808650570151395*^9, 3.808650573175918*^9}, 3.808652306602357*^9, {
   3.808652647738027*^9, 3.808652650634597*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"062256c8-8868-4e78-b68b-b1f8c4b112a8"],

Cell["\<\
The data of confirmed cases, recovered individuals, and the number of deaths \
was collected from:

https://en.wikipedia.org/wiki/COVID-19_pandemic_in_Mexico

and

https://es.wikipedia.org/wiki/Pandemia_de_enfermedad_por_coronavirus_de_2020_\
en_M\[EAcute]xico

These sites offer a succinct and comprehensible presentation of the data as \
well as a timeline of the data. Included are also other graphics and useful \
information.

The data in this notebook is included as a table of days and case numbers \
(confirmed, recovered, and deaths) which is actualized manually. Different \
colors indicate some tendency to change the data. Al data used in the program \
solving the differential equations of the model are included in the following \
sets :

DatosAcumuladosDias = Data of the number of cumulated cases in days
DatosRecuperadosDias = Data of recovered individuals in days
DatosFallecidosDias = Data of the number of\[NonBreakingSpace]deaths \
\[NonBreakingSpace]in days

After this input, the sets are converted to a number of days and two \
subsidiary sets are calculated:

CASOSporDIAresta = Data of the Daily cases

CasosACTIVOS = Data of the Pre-recovered active cases

Date notation was changed to the number of days to make them compatible with \
the results of the numerical solution of the set of differential equations. \
The number of active cases was calculated by subtraction of the recovered and \
death populations from the cumulative number of cases. The daily cases were \
calculated by the difference between the cumulative number of cases in two \
consecutive days.\[NonBreakingSpace]

  \
\>", "Text",
 CellChangeTimes->{{3.808650576134156*^9, 3.808650912996314*^9}, {
  3.808651140172174*^9, 3.808651149099153*^9}, {3.8086511799243813`*^9, 
  3.808651182277894*^9}, {3.808651213973815*^9, 3.808651243262628*^9}, {
  3.8086526982749653`*^9, 3.808652713803533*^9}, {3.8086527614466057`*^9, 
  3.808652773488559*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"318b461b-4311-443d-a4f6-e92e9bbfdeb9"],

Cell[TextData[{
 StyleBox["WARNING!\nThe parameter ",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["DIAMX",
  FontColor->GrayLevel[0]],
 StyleBox[" indicates the current day of the pandemic and is important to be \
actualized when data are actualized. It is used to pass from dates to day \
numbers.",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",
 CellChangeTimes->{{3.808651250810645*^9, 3.808651399077773*^9}},
 Background->RGBColor[
  1, 1, 0],ExpressionUUID->"c05b1fdd-aa8d-4039-9ead-536e0d131043"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DIAMX", "=", "191"}]], "Input",
 CellChangeTimes->{{3.800221500492736*^9, 3.800221501490363*^9}, {
   3.80091317206987*^9, 3.8009131759712353`*^9}, {3.800997238130829*^9, 
   3.800997238282597*^9}, {3.801084628185405*^9, 3.801084628581266*^9}, {
   3.801171181681563*^9, 3.801171181938858*^9}, {3.801257878525425*^9, 
   3.80125787870368*^9}, {3.801345270888129*^9, 3.801345271310254*^9}, {
   3.801478880400825*^9, 3.801478880866083*^9}, {3.801517080100547*^9, 
   3.801517080735471*^9}, {3.801600403146298*^9, 3.80160040340565*^9}, {
   3.801774246411722*^9, 3.801774246604497*^9}, {3.8017831638278*^9, 
   3.801783164422385*^9}, {3.8018611390864983`*^9, 3.801861140050918*^9}, {
   3.8019458020109377`*^9, 3.8019458027602882`*^9}, {3.802033492360792*^9, 
   3.802033492837962*^9}, {3.802121222774067*^9, 3.802121223026062*^9}, {
   3.8022953986188107`*^9, 3.802295426898527*^9}, {3.80238200139711*^9, 
   3.802382001761489*^9}, {3.802471067677095*^9, 3.802471067902955*^9}, {
   3.802625788333169*^9, 3.802625788854766*^9}, {3.802725258624052*^9, 
   3.80272525926709*^9}, {3.802725296464864*^9, 3.802725297069518*^9}, {
   3.80281102880468*^9, 3.8028110292667*^9}, {3.802897221327157*^9, 
   3.8028972218637*^9}, {3.8029854420391903`*^9, 3.8029854424876328`*^9}, 
   3.803074180208973*^9, {3.803158027650619*^9, 3.8031580279956217`*^9}, {
   3.803242054973138*^9, 3.803242055364435*^9}, {3.803415803083754*^9, 
   3.8034158035162897`*^9}, {3.803416058455886*^9, 3.80341605870057*^9}, {
   3.8035662324346237`*^9, 3.803566232793509*^9}, {3.8035911527614803`*^9, 
   3.8035911534160147`*^9}, {3.803763095498407*^9, 3.803763095587356*^9}, {
   3.8037689664754963`*^9, 3.803768966953231*^9}, {3.803848197836647*^9, 
   3.803848198514052*^9}, {3.803937034714993*^9, 3.8039370354954443`*^9}, {
   3.804022703488462*^9, 3.804022704150588*^9}, {3.804108356609429*^9, 
   3.8041083587269773`*^9}, {3.804193621559724*^9, 3.804193621773994*^9}, {
   3.804279955783763*^9, 3.8042799564478283`*^9}, {3.804367989136251*^9, 
   3.8043679897060432`*^9}, {3.804368037533655*^9, 3.804368038201397*^9}, {
   3.8044524475529537`*^9, 3.80445244809548*^9}, {3.804544198106159*^9, 
   3.804544198364832*^9}, {3.8047147922913713`*^9, 3.804714799706936*^9}, {
   3.8048001257866*^9, 3.804800126254798*^9}, {3.8048844174903107`*^9, 
   3.8048844180334053`*^9}, {3.804970811033873*^9, 3.8049708117976522`*^9}, {
   3.805145025786131*^9, 3.805145027115794*^9}, {3.805145554977771*^9, 
   3.8051455554586067`*^9}, {3.805232478509961*^9, 3.805232479239541*^9}, {
   3.805317501297358*^9, 3.805317501792902*^9}, {3.805318552583466*^9, 
   3.8053185528304033`*^9}, {3.805402789664032*^9, 3.805402789906632*^9}, {
   3.805491584088875*^9, 3.805491585343534*^9}, {3.805576127431013*^9, 
   3.805576128029024*^9}, {3.805749982748413*^9, 3.805749983514999*^9}, {
   3.805750268596459*^9, 3.805750269719014*^9}, {3.805838821303109*^9, 
   3.8058388218480597`*^9}, {3.8059208774268847`*^9, 3.805920877623493*^9}, {
   3.806072499568398*^9, 3.80607249999047*^9}, {3.806183609948094*^9, 
   3.8061836153641*^9}, {3.806266377020776*^9, 3.806266377410771*^9}, {
   3.806441450453513*^9, 3.806441451140576*^9}, {3.8064415242399817`*^9, 
   3.8064415248745327`*^9}, {3.806699354911767*^9, 3.8066993557085543`*^9}, {
   3.8068718892814827`*^9, 3.8068718898069897`*^9}, {3.806871929326964*^9, 
   3.806871929626585*^9}, {3.806959592909774*^9, 3.806959593531143*^9}, {
   3.8071310639978857`*^9, 3.80713106477677*^9}, {3.807131179999209*^9, 
   3.8071311804933243`*^9}, {3.807218657878497*^9, 3.807218658355732*^9}, {
   3.8072187074575853`*^9, 3.8072187079536543`*^9}, {3.807389216898653*^9, 
   3.807389217264695*^9}, {3.807562084757976*^9, 3.807562085407045*^9}, {
   3.8076514129997272`*^9, 3.8076514141871243`*^9}, {3.80773866964822*^9, 
   3.807738669969789*^9}, {3.807902729728922*^9, 3.807902730329665*^9}, {
   3.8079028702351627`*^9, 3.8079028708052187`*^9}, {3.808082715270267*^9, 
   3.808082715512748*^9}, {3.8082236258578377`*^9, 3.808223626338024*^9}, {
   3.808223852835877*^9, 3.808223853294057*^9}, {3.808429114010118*^9, 
   3.808429114871684*^9}, {3.80842915689121*^9, 3.808429157460003*^9}, {
   3.808602042034137*^9, 3.808602043867619*^9}},
 Background->RGBColor[1, 1, 0],
 CellLabel->"In[2]:=",ExpressionUUID->"6b4badac-f558-4a02-bca6-3a7f276fba88"],

Cell[BoxData["191"], "Output",
 CellChangeTimes->{
  3.800913179297031*^9, 3.800997330184147*^9, 3.801084760431196*^9, 
   3.801085202888074*^9, 3.8011712546467876`*^9, 3.801258069014017*^9, 
   3.801345433491684*^9, 3.801346287787427*^9, 3.801479030278386*^9, 
   3.801517163069109*^9, 3.801600623466873*^9, 3.801612547882967*^9, 
   3.801612672136446*^9, 3.801612786012319*^9, 3.801774337158781*^9, 
   3.801861227870994*^9, 3.801995994607183*^9, 3.8020336037798347`*^9, 
   3.802121409474148*^9, 3.8022955889500103`*^9, 3.802382130272614*^9, 
   3.802382163765517*^9, 3.802382200561276*^9, 3.802471158140296*^9, 
   3.8026258693911133`*^9, 3.802725390421414*^9, 3.802725556662759*^9, 
   3.802725659322196*^9, 3.8028111127111273`*^9, 3.8028115648542624`*^9, 
   3.802897380030176*^9, 3.8029855940515738`*^9, 3.802986708284108*^9, 
   3.802986883306138*^9, 3.802987549275249*^9, 3.803074264538554*^9, 
   3.803158113293124*^9, 3.803300039318802*^9, 3.8034159462044487`*^9, 
   3.8034161275480623`*^9, 3.803416264149591*^9, 3.803417668774091*^9, 
   3.803418909343463*^9, 3.803419662249279*^9, 3.8034995427647657`*^9, 
   3.803501389420528*^9, 3.80350143917106*^9, 3.803502205894162*^9, 
   3.803503454622139*^9, 3.803565359513842*^9, 3.803565416037188*^9, 
   3.803566322200611*^9, 3.803567707994316*^9, 3.803567756467901*^9, 
   3.803571456115509*^9, 3.80357151434533*^9, 3.803571592893177*^9, 
   3.803591510965179*^9, 3.803664641751526*^9, 3.803665404719842*^9, 
   3.803665546449751*^9, 3.803666473586494*^9, 3.803667551088252*^9, 
   3.80373571806607*^9, 3.8037359750001*^9, 3.803736434158616*^9, 
   3.803736512668377*^9, 3.803736625259069*^9, 3.803736802435122*^9, 
   3.803740894863093*^9, 3.803763126431264*^9, 3.803763246010253*^9, 
   3.803763308769712*^9, 3.803764149161276*^9, 3.8037647187562857`*^9, 
   3.803769059864423*^9, 3.803769099603304*^9, 3.803769349530908*^9, 
   3.803847899223405*^9, 3.803848053214941*^9, 3.803848107206506*^9, 
   3.80384820069313*^9, 3.803937139835919*^9, 3.803937300650752*^9, 
   3.804026593439932*^9, 3.804108468615891*^9, 3.804108556841321*^9, 
   3.8041098790620317`*^9, 3.80419368877098*^9, 3.804193777124566*^9, 
   3.804368098793861*^9, 3.8044525800009003`*^9, 3.8044527950636253`*^9, 
   3.804452961293738*^9, 3.804453067408514*^9, 3.804453202525426*^9, 
   3.80454443238136*^9, 3.804715158505183*^9, 3.804715231068367*^9, 
   3.804717494088221*^9, 3.8048002231283827`*^9, 3.804853827804261*^9, 
   3.804860583623722*^9, 3.804868188332819*^9, 3.804871039192358*^9, 
   3.804884625748918*^9, 3.8049632443066177`*^9, 3.804966590863687*^9, 
   3.804967278898387*^9, 3.8049709838631*^9, 3.805032057834828*^9, 
   3.805049850824174*^9, 3.8051451663578663`*^9, 3.8051456553633013`*^9, 
   3.805145853006798*^9, 3.805146045817379*^9, 3.805201928291266*^9, 
   3.805232574412094*^9, 3.8052327663470583`*^9, 3.805317647334524*^9, 
   3.8053184745036173`*^9, 3.805318557610181*^9, 3.805319447647026*^9, 
   3.8053195557732983`*^9, 3.805402864941959*^9, 3.80540340281992*^9, 
   3.805491728463996*^9, 3.805578705321582*^9, 3.8056390295573063`*^9, 
   3.805725935738502*^9, 3.80572602855588*^9, 3.8057358616446037`*^9, 
   3.805750041724676*^9, 3.805750090541621*^9, 3.8057503683037*^9, 
   3.8058083443695507`*^9, 3.805811134779244*^9, 3.805838877307302*^9, 
   3.805920953223543*^9, {3.8060721494324017`*^9, 3.8060721746222258`*^9}, 
   3.806072606020849*^9, 3.8060728158347197`*^9, 3.806175566945753*^9, 
   3.806183937592662*^9, 3.806184002886869*^9, 3.8063533089849873`*^9, 
   3.806353503903717*^9, 3.8063536871865273`*^9, 3.806441723760995*^9, 
   3.806441848700335*^9, 3.8064421359745417`*^9, 3.8066996336955976`*^9, 
   3.8066997673482313`*^9, 3.806701293929572*^9, 3.8067013978438587`*^9, 
   3.806772439994795*^9, 3.806872046052998*^9, 3.8068721608469963`*^9, 
   3.8070067465082684`*^9, 3.8070069066934643`*^9, 3.80713137494991*^9, 
   3.807389424072837*^9, 3.807389629444191*^9, 3.807562304155923*^9, 
   3.807651532815805*^9, 3.807738738051901*^9, 3.807738956191214*^9, 
   3.807903007938567*^9, 3.808082935145918*^9, 3.808222332950964*^9, 
   3.808223953001602*^9, 3.808429338796764*^9, 3.8086022230063457`*^9, 
   3.808651498766182*^9},
 Background->RGBColor[1, 1, 0],
 CellLabel->"Out[2]=",ExpressionUUID->"59938714-d42f-4a6f-a393-e2bb88dce927"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DatosAcumuladosDias", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "2"}], "}"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "3"}], "}"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "4"}], "}"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "5"}], "}"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "6"}], "}"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "7"}], "}"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "8"}], "}"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "9"}], "}"}], ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "10"}], "}"}], ",", "7"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "11"}], "}"}], ",", "8"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "12"}], "}"}], ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "13"}], "}"}], ",", "19"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "14"}], "}"}], ",", "26"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "15"}], "}"}], ",", "43"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "16"}], "}"}], ",", "65"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "17"}], "}"}], ",", "92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "18"}], "}"}], ",", "93"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "19"}], "}"}], ",", "118"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "20"}], "}"}], ",", "164"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "21"}], "}"}], ",", "203"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "22"}], "}"}], ",", "251"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "23"}], "}"}], ",", "316"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "24"}], "}"}], ",", "367"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "25"}], "}"}], ",", "405"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "26"}], "}"}], ",", "537"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "27"}], "}"}], ",", "585"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "28"}], "}"}], ",", "717"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "29"}], "}"}], ",", "848"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "30"}], "}"}], ",", "993"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "31"}], "}"}], ",", "1138"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "1"}], "}"}], ",", "1215"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "2"}], "}"}], ",", "1378"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "3"}], "}"}], ",", "1510"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "4"}], "}"}], ",", "1688"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "5"}], "}"}], ",", "1890"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "6"}], "}"}], ",", "2143"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "7"}], "}"}], ",", "2439"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "8"}], "}"}], ",", "2785"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "9"}], "}"}], ",", "3181"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "10"}], "}"}], ",", "3441"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "11"}], "}"}], ",", "4126"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "12"}], "}"}], ",", "4219"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "13"}], "}"}], ",", "4661"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "14"}], "}"}], ",", "5014"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "15"}], "}"}], ",", "5399"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "16"}], "}"}], ",", "5847"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "17"}], "}"}], ",", "6297"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "18"}], "}"}], ",", "6875"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "19"}], "}"}], ",", "7497"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "20"}], "}"}], ",", "8261"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "21"}], "}"}], ",", "8772"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "22"}], "}"}], ",", "9501"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "23"}], "}"}], ",", "10544"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "24"}], "}"}], ",", "11633"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "25"}], "}"}], ",", "12872"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "26"}], "}"}], ",", "13842"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "27"}], "}"}], ",", "14677"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "28"}], "}"}], ",", "16752"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "29"}], "}"}], ",", "18585"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "30"}], "}"}], ",", "19224"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "1"}], "}"}], ",", "20739"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "2"}], "}"}], ",", "22088"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "3"}], "}"}], ",", "23471"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "4"}], "}"}], ",", "24905"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "5"}], "}"}], ",", "26025"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "6"}], "}"}], ",", "27634"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "7"}], "}"}], ",", "29616"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "8"}], "}"}], ",", "31522"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "9"}], "}"}], ",", "33460"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "10"}], "}"}], ",", "35022"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "11"}], "}"}], ",", "36327"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "12"}], "}"}], ",", "38324"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "13"}], "}"}], ",", "40186"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "14"}], "}"}], ",", "42595"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "15"}], "}"}], ",", "45032"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "16"}], "}"}], ",", "47144"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "17"}], "}"}], ",", "49219"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "18"}], "}"}], ",", "51633"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "19"}], "}"}], ",", "54346"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "20"}], "}"}], ",", "56594"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "21"}], "}"}], ",", "59567"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "22"}], "}"}], ",", "62527"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "23"}], "}"}], ",", "65856"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "24"}], "}"}], ",", "68620"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "25"}], "}"}], ",", "71105"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "26"}], "}"}], ",", "74560"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "27"}], "}"}], ",", "78023"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "28"}], "}"}], ",", "81400"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "29"}], "}"}], ",", "84627"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "30"}], "}"}], ",", "87512"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "31"}], "}"}], ",", "90664"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "1"}], "}"}], ",", "93435"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "2"}], "}"}], ",", "97326"}], "}"}], 
     ",", 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "3"}], "}"}], ",", "101368"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], ",", 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "4"}], "}"}], ",", "105680"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "5"}], "}"}], ",", "110026"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "6"}], "}"}], ",", "113619"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "7"}], "}"}], ",", "117103"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "8"}], "}"}], ",", "120102"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "9"}], "}"}], ",", "124301"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "10"}], "}"}], ",", "129184"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "11"}], "}"}], ",", "133974"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "12"}], "}"}], ",", "139196"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "13"}], "}"}], ",", "142690"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "14"}], "}"}], ",", "146837"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "15"}], "}"}], ",", "150264"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "16"}], "}"}], ",", "154863"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "17"}], "}"}], ",", "159793"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "18"}], "}"}], ",", "165030"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "19"}], "}"}], ",", "170485"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "20"}], "}"}], ",", "175202"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "21"}], "}"}], ",", "180545"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "22"}], "}"}], ",", "185122"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "23"}], "}"}], ",", "191410"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "24"}], "}"}], ",", "196847"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "25"}], "}"}], ",", "202951"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "26"}], "}"}], ",", "208392"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "27"}], "}"}], ",", "212802"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "28"}], "}"}], ",", "216852"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "29"}], "}"}], ",", "220657"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "6", ",", "30"}], "}"}], ",", "226089"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "1"}], "}"}], ",", "231770"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "2"}], "}"}], ",", "238511"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "3"}], "}"}], ",", "245251"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "4"}], "}"}], ",", "252165"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "5"}], "}"}], ",", "256848"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "6"}], "}"}], ",", "261750"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "7"}], "}"}], ",", "268008"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "8"}], "}"}], ",", "275003"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "9"}], "}"}], ",", "282283"}], "}"}],
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "10"}], "}"}], ",", "289174"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "11"}], "}"}], ",", "295268"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "12"}], "}"}], ",", "299750"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "13"}], "}"}], ",", "304435"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "14"}], "}"}], ",", "311486"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "15"}], "}"}], ",", "317635"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "16"}], "}"}], ",", "324041"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "17"}], "}"}], ",", "331298"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "18"}], "}"}], ",", "338913"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "19"}], "}"}], ",", "344224"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "20"}], "}"}], ",", "349396"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "21"}], "}"}], ",", "356255"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "22"}], "}"}], ",", "362274"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "23"}], "}"}], ",", "370712"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "24"}], "}"}], ",", "378285"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "25"}], "}"}], ",", "385036"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "26"}], "}"}], ",", "390516"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "27"}], "}"}], ",", "395489"}], "}"}],
      
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[",",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "28"}], "}"}], ",", "402697"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "29"}], "}"}], ",", "408449"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "30"}], "}"}], ",", "416179"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "7", ",", "31"}], "}"}], ",", "424637"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "1"}], "}"}], ",", "434193"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "2"}], "}"}], ",", "439394"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "3"}], "}"}], ",", "443813"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "4"}], "}"}], ",", "449961"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "5"}], "}"}], ",", "456100"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "6"}], "}"}], ",", "462690"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "7"}], "}"}], ",", "469407"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "8"}], "}"}], ",", "475902"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "9"}], "}"}], ",", "480278"}], "}"}],
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "10"}], "}"}], ",", "485836"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "11"}], "}"}], ",", "492522"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "12"}], "}"}], ",", "498380"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "13"}], "}"}], ",", "505751"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "14"}], "}"}], ",", "511369"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "15"}], "}"}], ",", "517714"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "16"}], "}"}], ",", "522162"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "17"}], "}"}], ",", "525733"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "18"}], "}"}], ",", "531239"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "19"}], "}"}], ",", "537031"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "20"}], "}"}], ",", "543806"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "21"}], "}"}], ",", "549734"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "22"}], "}"}], ",", "556216"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "23"}], "}"}], ",", "560164"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "24"}], "}"}], ",", "563705"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "25"}], "}"}], ",", "568621"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "26"}], "}"}], ",", "573888"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "27"}], "}"}], ",", "579914"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "28"}], "}"}], ",", "585738"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "29"}], "}"}], ",", "591712"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "30"}], "}"}], ",", "595841"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "8", ",", "31"}], "}"}], ",", "599560"}], "}"}],
      
      FontColor->RGBColor[0, 0, 1]], 
     StyleBox[",",
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "9", ",", "1"}], "}"}], ",", "606036"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[",",
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "9", ",", "2"}], "}"}], ",", "610957"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[",",
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "9", ",", "3"}], "}"}], ",", "616894"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[",",
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "9", ",", "4"}], "}"}], ",", "623090"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[",",
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "9", ",", "5"}], "}"}], ",", "629409"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[",",
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "9", ",", "6"}], "}"}], ",", "634023"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[",",
      FontColor->RGBColor[0.6, 0.4, 0.2]], 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2020", ",", "9", ",", "7"}], "}"}], ",", "637509"}], "}"}],
      FontColor->RGBColor[0.6, 0.4, 0.2]]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.797017740230104*^9, 3.79701794798272*^9}, {
   3.797017995346635*^9, 3.797018023871563*^9}, {3.797018091933869*^9, 
   3.7970183211449842`*^9}, {3.797018458030752*^9, 3.797018598379075*^9}, {
   3.797018700757321*^9, 3.797019279354981*^9}, {3.797019445345806*^9, 
   3.797019561662569*^9}, {3.797019603782502*^9, 3.7970196700783463`*^9}, {
   3.797019974421164*^9, 3.797020293344799*^9}, {3.797020343120846*^9, 
   3.7970204083775377`*^9}, {3.797020693347599*^9, 3.797020719648819*^9}, {
   3.7971506652649097`*^9, 3.797150677729621*^9}, {3.797248858183114*^9, 
   3.7972488650066767`*^9}, {3.797248943613656*^9, 3.797248949933453*^9}, {
   3.797323526452758*^9, 3.797323548947661*^9}, {3.797379633573987*^9, 
   3.7973796520906067`*^9}, {3.7973797765249653`*^9, 3.797379776802938*^9}, {
   3.797514083946597*^9, 3.797514109958404*^9}, {3.79767683327921*^9, 
   3.797676866605398*^9}, {3.79767690035366*^9, 3.797676901250183*^9}, {
   3.797677138799879*^9, 3.79767714077127*^9}, {3.797719925222033*^9, 
   3.797719939205167*^9}, {3.797803597124579*^9, 3.797803618503488*^9}, {
   3.797889092777871*^9, 3.797889102136108*^9}, {3.798133445758709*^9, 
   3.798133466887425*^9}, {3.7981339236310472`*^9, 3.798133955180625*^9}, {
   3.798134161022296*^9, 3.798134162250388*^9}, {3.7983173275613194`*^9, 
   3.798317345697177*^9}, {3.798317511473131*^9, 3.7983175256534853`*^9}, {
   3.798317884342507*^9, 3.79831789983817*^9}, {3.798492504912569*^9, 
   3.798492508536203*^9}, {3.798492606471712*^9, 3.7984926124281187`*^9}, {
   3.7984926555383244`*^9, 3.798492671400387*^9}, 3.798492800265951*^9, {
   3.798578853634886*^9, 3.7985788694693213`*^9}, {3.798753800954205*^9, 
   3.798753809133039*^9}, {3.798753868556082*^9, 3.798753875175343*^9}, {
   3.798753961190269*^9, 3.798753964275428*^9}, {3.798753997615157*^9, 
   3.798754000652186*^9}, 3.798924725282736*^9, {3.7989248059795856`*^9, 
   3.7989248225543327`*^9}, {3.798925100994693*^9, 3.7989251047763767`*^9}, {
   3.798925195739175*^9, 3.798925225458065*^9}, {3.799012642734312*^9, 
   3.79901268243039*^9}, 3.799270030557063*^9, {3.799270067573721*^9, 
   3.799270068744195*^9}, {3.7992701558759813`*^9, 3.7992701625425043`*^9}, {
   3.799270233109193*^9, 3.7992702600326977`*^9}, {3.799270330501322*^9, 
   3.799270388999321*^9}, {3.799411882505023*^9, 3.799411887384212*^9}, {
   3.799411973367633*^9, 3.799411978527076*^9}, {3.799442572861416*^9, 
   3.799442576898596*^9}, {3.799442631206695*^9, 3.799442635546479*^9}, {
   3.799529913231882*^9, 3.799529925893938*^9}, {3.799614650452078*^9, 
   3.799614667283926*^9}, {3.799704430973173*^9, 3.799704444755702*^9}, {
   3.799789361526125*^9, 3.799789368166637*^9}, {3.799789475268998*^9, 
   3.799789479121441*^9}, {3.7998762112751503`*^9, 3.799876236372952*^9}, {
   3.799962333142214*^9, 3.799962351896154*^9}, {3.800047642347453*^9, 
   3.800047661866726*^9}, {3.800137618593885*^9, 3.800137635402217*^9}, {
   3.800221201012464*^9, 3.8002212178299427`*^9}, {3.800221273977392*^9, 
   3.800221282873189*^9}, {3.800221647668519*^9, 3.8002216590056133`*^9}, {
   3.8002217629753447`*^9, 3.8002217776350317`*^9}, {3.800318859148239*^9, 
   3.800318864699197*^9}, {3.800318908405122*^9, 3.800318944123962*^9}, 
   3.8003953484708643`*^9, {3.800395523175632*^9, 3.800395564460472*^9}, {
   3.8003956340553513`*^9, 3.800395636631752*^9}, {3.800480784016917*^9, 
   3.800480817989332*^9}, {3.80056517358108*^9, 3.800565176947098*^9}, {
   3.800565300942589*^9, 3.800565322468547*^9}, {3.8007255930792913`*^9, 
   3.8007256298695908`*^9}, {3.8007377327738323`*^9, 3.800737745880158*^9}, {
   3.8008266148064423`*^9, 3.8008266502665243`*^9}, {3.800910700482526*^9, 
   3.8009107257399063`*^9}, {3.8009972443194227`*^9, 3.800997259393876*^9}, {
   3.800997325625736*^9, 3.800997325834611*^9}, {3.801084636782508*^9, 
   3.8010846402663383`*^9}, {3.8010847085356503`*^9, 3.801084717645793*^9}, {
   3.801171159016118*^9, 3.801171172491085*^9}, {3.801257885661701*^9, 
   3.801257892927568*^9}, {3.801258017070634*^9, 3.801258021283201*^9}, {
   3.801345315709379*^9, 3.8013453196485767`*^9}, {3.801345364066552*^9, 
   3.801345373238715*^9}, {3.801478924135738*^9, 3.801478949774725*^9}, {
   3.801517090044526*^9, 3.801517102367792*^9}, {3.8015171370978622`*^9, 
   3.801517137584558*^9}, {3.801600410460903*^9, 3.8016004390942507`*^9}, {
   3.801612453109701*^9, 3.80161245341072*^9}, {3.801612494223115*^9, 
   3.801612511517054*^9}, {3.80177422796894*^9, 3.801774239540786*^9}, {
   3.801783174987904*^9, 3.801783188864087*^9}, {3.801861156421253*^9, 
   3.8018611663566437`*^9}, {3.801945827014099*^9, 3.8019458309540577`*^9}, {
   3.8019959206414547`*^9, 3.801995933228904*^9}, {3.80203350115853*^9, 
   3.802033504168833*^9}, {3.8020335519132833`*^9, 3.802033556400977*^9}, {
   3.802121246364752*^9, 3.802121250728698*^9}, {3.8021213416484957`*^9, 
   3.802121346257512*^9}, {3.8022954068507013`*^9, 3.802295443275195*^9}, {
   3.8022955778039207`*^9, 3.8022955866835527`*^9}, {3.802382014140798*^9, 
   3.802382046824404*^9}, 3.802382198865107*^9, {3.802471074077767*^9, 
   3.802471090141643*^9}, {3.802625795770041*^9, 3.8026258135261297`*^9}, {
   3.802725272519392*^9, 3.802725315949218*^9}, {3.802725472680476*^9, 
   3.802725490952928*^9}, {3.8027255250530643`*^9, 3.8027255270980377`*^9}, {
   3.802811037708069*^9, 3.802811048080456*^9}, {3.8028972282573442`*^9, 
   3.802897230682167*^9}, {3.8028973351522017`*^9, 3.8028973415804243`*^9}, {
   3.802985493398292*^9, 3.802985520292204*^9}, {3.803074187767523*^9, 
   3.803074209045764*^9}, {3.80315804357633*^9, 3.803158066892644*^9}, {
   3.803242062098898*^9, 3.803242064893826*^9}, {3.803299975565217*^9, 
   3.803299986073457*^9}, {3.8034157951255493`*^9, 3.803415798584256*^9}, {
   3.803415870991118*^9, 3.803415876439948*^9}, {3.803416022551874*^9, 
   3.8034160515045443`*^9}, {3.803566178453251*^9, 3.803566221064383*^9}, {
   3.803591176686255*^9, 3.80359118042524*^9}, {3.8035914241976357`*^9, 
   3.803591429314733*^9}, {3.8037405013982763`*^9, 3.803740635479657*^9}, {
   3.803741031362671*^9, 3.80374103346798*^9}, {3.803762711843623*^9, 
   3.803762763593614*^9}, {3.803768979866303*^9, 3.8037689905464153`*^9}, {
   3.80384784134508*^9, 3.803847855355871*^9}, {3.8039370425343513`*^9, 
   3.8039370798550777`*^9}, {3.804022710482491*^9, 3.804022720351829*^9}, {
   3.804026556036565*^9, 3.804026561022056*^9}, {3.8041083923459*^9, 
   3.804108410430122*^9}, {3.804193615684044*^9, 3.8041936367103157`*^9}, {
   3.8042799675154667`*^9, 3.804279972729579*^9}, {3.804368000747436*^9, 
   3.80436803354521*^9}, {3.804452459179566*^9, 3.804452465251389*^9}, {
   3.804452507242244*^9, 3.8044525141440153`*^9}, {3.804544187439522*^9, 
   3.804544246720834*^9}, {3.804544290258504*^9, 3.804544296897893*^9}, {
   3.804714806741537*^9, 3.804714813005486*^9}, {3.804714880781001*^9, 
   3.804714891723084*^9}, {3.80471497647884*^9, 3.804714977813147*^9}, 
   3.804715142407876*^9, {3.80471740372351*^9, 3.804717413242766*^9}, {
   3.804800133757905*^9, 3.804800156157757*^9}, {3.804884428019867*^9, 
   3.8048844594944983`*^9}, {3.804970816938438*^9, 3.8049708288394957`*^9}, {
   3.804970879329719*^9, 3.804970887023972*^9}, {3.8051449563980713`*^9, 
   3.8051449622196417`*^9}, {3.805145018783135*^9, 3.80514502004714*^9}, {
   3.805145070341858*^9, 3.805145076548739*^9}, {3.805145565842785*^9, 
   3.805145598878536*^9}, {3.805232491065201*^9, 3.8052325259425373`*^9}, {
   3.8053175094234123`*^9, 3.8053175177533073`*^9}, {3.805317585219817*^9, 
   3.8053175945429173`*^9}, 3.805317720282319*^9, {3.8054027861904984`*^9, 
   3.805402820719151*^9}, {3.805491592863491*^9, 3.805491619105784*^9}, {
   3.805576137624402*^9, 3.8055761408141727`*^9}, {3.805578677190448*^9, 
   3.805578683074893*^9}, {3.805749989096323*^9, 3.805749999294156*^9}, {
   3.8057502821379557`*^9, 3.805750297805485*^9}, {3.80583879618579*^9, 
   3.8058388162068872`*^9}, {3.805920883437071*^9, 3.805920894955958*^9}, {
   3.8060725136871367`*^9, 3.806072517225814*^9}, {3.806072558081195*^9, 
   3.8060725624606333`*^9}, {3.806183622810748*^9, 3.806183633408876*^9}, {
   3.8061836675938883`*^9, 3.806183676576392*^9}, {3.8061837977358227`*^9, 
   3.806183805474462*^9}, {3.806266385177785*^9, 3.8062663900543137`*^9}, {
   3.806353253106361*^9, 3.806353261884922*^9}, {3.80644146091951*^9, 
   3.80644146368049*^9}, {3.806441532925192*^9, 3.806441547999762*^9}, {
   3.806441663298489*^9, 3.8064416686698923`*^9}, {3.806699335019189*^9, 
   3.806699384414776*^9}, {3.806699514781188*^9, 3.806699518280547*^9}, 
   3.8066996154492683`*^9, {3.80670135827052*^9, 3.806701366104357*^9}, {
   3.806871904741734*^9, 3.806871956256716*^9}, {3.8068721269963217`*^9, 
   3.8068721574068108`*^9}, {3.807006622259376*^9, 3.807006629891567*^9}, {
   3.80700666488374*^9, 3.8070066740782347`*^9}, {3.807131069498445*^9, 
   3.807131085639773*^9}, {3.807131168941846*^9, 3.807131184523251*^9}, {
   3.807131307128337*^9, 3.80713131176278*^9}, {3.807389207524171*^9, 
   3.807389214022337*^9}, {3.807389254452825*^9, 3.8073892604137573`*^9}, {
   3.807389410098691*^9, 3.807389421107822*^9}, {3.8075620808448877`*^9, 
   3.8075621343351603`*^9}, {3.80756229728323*^9, 3.807562301650196*^9}, {
   3.807651422116714*^9, 3.807651456844983*^9}, {3.8077386821795197`*^9, 
   3.807738696844144*^9}, {3.807902737359701*^9, 3.80790274086985*^9}, {
   3.8079027959705257`*^9, 3.8079027994592733`*^9}, {3.80790288067627*^9, 
   3.807902888671282*^9}, {3.8079029268801622`*^9, 3.8079029500291862`*^9}, {
   3.8080827220389023`*^9, 3.808082725174609*^9}, {3.808082761697584*^9, 
   3.808082766286565*^9}, {3.8080828402443743`*^9, 3.808082886521184*^9}, {
   3.808223765815399*^9, 3.808223777026578*^9}, {3.8082238752797213`*^9, 
   3.808223907925264*^9}, {3.808429121363783*^9, 3.808429153783657*^9}, {
   3.8084291916358547`*^9, 3.808429199970997*^9}, {3.808429330720058*^9, 
   3.808429337255411*^9}, {3.808602049071*^9, 3.808602078820706*^9}, 
   3.808602162360862*^9, {3.808602194779984*^9, 3.808602199333539*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"0567182b-7bb8-4a20-ade1-d5f3fb01f965"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatosAcumuladosDias", "[", 
  RowBox[{"[", "177", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.802382180688251*^9, 3.8023822095521173`*^9}, {
  3.802725301127537*^9, 3.8027253017705727`*^9}, {3.802725612133606*^9, 
  3.802725612778853*^9}, {3.804368043174226*^9, 3.804368044015938*^9}, {
  3.80531773019783*^9, 3.805317730270146*^9}, {3.8060726351735907`*^9, 
  3.806072636049973*^9}, {3.8063533878081703`*^9, 3.8063533878256273`*^9}, {
  3.8068721800062*^9, 3.806872181055444*^9}, {3.807389431633491*^9, 
  3.807389431651692*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"2061e45e-047e-4beb-9145-f4cc6fea5da1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2020", ",", "8", ",", "24"}], "}"}], ",", "563705"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.802382190108111*^9, 3.802382227442266*^9}, 
   3.802471158274654*^9, 3.802625869524745*^9, 3.802725390547833*^9, 
   3.8027255567802887`*^9, 3.802725613468608*^9, 3.8027256594946423`*^9, 
   3.8028111128450212`*^9, 3.802811564989326*^9, 3.802897380164111*^9, 
   3.8029855941856003`*^9, 3.8029867083840733`*^9, 3.802986883404141*^9, 
   3.802987549348237*^9, 3.803074264689658*^9, 3.80315811344331*^9, 
   3.803300039475247*^9, 3.8034159463552*^9, 3.8034161276984777`*^9, 
   3.803416264250557*^9, 3.80341766887402*^9, 3.803418909459663*^9, 
   3.803419662350713*^9, 3.803499542866116*^9, 3.803501389537174*^9, 
   3.803501439271213*^9, 3.8035022059965754`*^9, 3.8035034547388163`*^9, 
   3.803565359650285*^9, 3.803565416152831*^9, 3.803566322383152*^9, 
   3.8035677080941677`*^9, 3.803567756574792*^9, 3.803571456268799*^9, 
   3.803571514475761*^9, 3.803571593059861*^9, 3.803591511148782*^9, 
   3.803664641849543*^9, 3.803665404821454*^9, 3.803665546567898*^9, 
   3.803666473688985*^9, 3.803667551204897*^9, 3.803735718184094*^9, 
   3.8037359751010523`*^9, 3.803736434257722*^9, 3.803736512794533*^9, 
   3.803736625372389*^9, 3.80373680253642*^9, 3.8037408950134583`*^9, 
   3.803763126567387*^9, 3.8037632461096697`*^9, 3.8037633088772917`*^9, 
   3.8037641492745237`*^9, 3.8037647188555326`*^9, 3.803769059996745*^9, 
   3.803769099740897*^9, 3.803769349614789*^9, 3.8038478993734703`*^9, 
   3.8038480533249283`*^9, 3.8038481072736397`*^9, 3.803848200826819*^9, 
   3.803937139969589*^9, 3.803937300752338*^9, 3.804026593575458*^9, 
   3.804108468799323*^9, 3.804108556960466*^9, 3.804109879178137*^9, 
   3.8041936889558077`*^9, 3.804193777292756*^9, 3.804368098960919*^9, 
   3.804452580201087*^9, 3.8044527951804447`*^9, 3.8044529614100523`*^9, 
   3.8044530675105457`*^9, 3.80445320264007*^9, 3.8045444335168953`*^9, 
   3.804715158689981*^9, 3.80471523117074*^9, 3.8047174942719173`*^9, 
   3.804800224454431*^9, 3.804853829278687*^9, 3.8048605837428083`*^9, 
   3.804868190040278*^9, 3.804871039359099*^9, 3.804884625930008*^9, 
   3.804963245041991*^9, 3.804966590934952*^9, 3.804967279025972*^9, 
   3.8049709846842127`*^9, 3.805032057955093*^9, 3.8050498521707087`*^9, 
   3.80514516651935*^9, 3.80514565553062*^9, 3.805145853175014*^9, 
   3.805146045907032*^9, 3.8052019284327507`*^9, 3.8052325745973377`*^9, 
   3.8052327664644737`*^9, 3.805317647520286*^9, 3.805318474705042*^9, 
   3.805318557833558*^9, 3.805319447797604*^9, 3.805319555856841*^9, 
   3.8054028651100492`*^9, 3.80540340291868*^9, 3.805491728614998*^9, 
   3.8055787055051327`*^9, 3.8056390296304827`*^9, 3.805725935905293*^9, 
   3.80572602867352*^9, 3.805735861868567*^9, 3.805750042035535*^9, 
   3.805750091012562*^9, 3.805750368675275*^9, 3.805808344501967*^9, 
   3.805811134947381*^9, 3.805838877388996*^9, 3.8059209533062572`*^9, {
   3.8060721495068083`*^9, 3.806072174793708*^9}, 3.806072606201757*^9, 
   3.806072636528494*^9, 3.806072815934564*^9, 3.8061755670498543`*^9, 
   3.806183937762525*^9, 3.806184002972474*^9, 3.806353309152047*^9, 
   3.806353542646194*^9, 3.8063536874108953`*^9, 3.806441723927753*^9, 
   3.806441848782823*^9, 3.806442136078568*^9, 3.8066996338630257`*^9, 
   3.806699767436717*^9, 3.806701294046821*^9, 3.8067013980272293`*^9, 
   3.806772440074942*^9, 3.806872046221397*^9, 3.806872161153674*^9, 
   3.806872194007022*^9, 3.807006746692912*^9, 3.807006906807795*^9, 
   3.807131375099612*^9, 3.807389424293139*^9, 3.8073896295867357`*^9, 
   3.807562304360197*^9, 3.8076515329990664`*^9, 3.8077387382186403`*^9, 
   3.807738956270049*^9, 3.8079030081051483`*^9, 3.808082935313622*^9, 
   3.808222333037423*^9, 3.808223953181924*^9, 3.8084293391465197`*^9, 
   3.808602223329741*^9, 3.808651499718863*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"7248fbe8-f163-474a-a0d8-2f1c8b245f58"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"DatosAcumuladosDias", ",", 
   RowBox[{"DateTicksFormat", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MonthShort\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\""}], 
     "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.797019690792389*^9, {3.7970204489281387`*^9, 3.7970204571159697`*^9}, {
   3.7970212013580008`*^9, 3.797021209955295*^9}, {3.797167195942843*^9, 
   3.797167201301429*^9}, {3.803848220090766*^9, 3.8038482270103397`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"f685d440-2923-478c-bf57-41bfe77cf114"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxV0g1QFHUcxvEVIRAUTwUERT0Qy+zFK5UcGpv1BQMlPPGFd71Ey3TKmywH
R8bWl7FTGzwZVLBx3NEgNMvLt6FSORnDK3G4VHyP1rd8gfBETCXQ3Oee/81w
Mzu/+8xv726/uxczZ1HaPD9JkqqeH/p8/jLtlZvGet9K8vPDctHnIN32rmOF
Dbqdr/kcptuT7nOkbuPKzjbv8Tlat3Kusx3SuE7WhnW2YYbPRt3yFz4P023d
5fMI3eoZnxN0uzuElUTd0tDxtGzWbUoTltLRX+Dbw/ZyYSUX/W6f56K/Tdjy
EfqHTBBehP4pws7F6F8q7FmC/p3C5qXoPyXsUtD/WDhpJfpjE+n5a9CfIqys
Q/8S4aAN6FeFXRvRf1K4vQj9D4Vtm9A/aCJdsgX9ycKWrehfLGzbhv5twkdV
9LuEQ3eiv0W4ugz90e/SlyrQP1H42m70W4UHOtD/tfAyWP5VeNQ+9N8T3rwf
/VFJdN+D6B8vfP4Q+j8RLq1Ef4nw5Z/RXy2cfAT9TbQS60R/RDL3scfQL9NK
YTX6F4p9yXH0bxL7yhr0V4l93G/ovyPc7ST6+0zi+btr0f8OLeW40T+fll88
jf4isa+B1cO0Uz6L/r/Fvqge/b0mc994Dv1v03LaBfTPE15wEf0baKX9Evp/
oqWmK+i/LvauBvSHptAzNfSPpp1RV9E/h9YOw46vxPmHrqH/EC1vv47+q7Sl
9gb6Q97j73fcRP8o4YBb6J9NW4Juo38tbYy/g/4DtLz2LvobhHc0oj8oldcX
/g/63xT+shn9ObQU5kH/GtrphI0/0oac++i/LM4f2YL+gCleW7s/QP9wWvkL
1jJp065W9K8W+9yH6P9BOPZf9F+gHXWw6mfm9VY/Qv+rtFL1GP3ptHTqCfpX
0OqVNvR/R5uO/If+etqzuR39z2hLWgf6X57qtTvjKfqn09K6Z+hfTjuyJH0q
FbTWATtO04aFXfSptdMVTbDhpTTe33Q/fcpT6fxbsHUZbVvRVZ9qGW0a4q9P
dx1dUQdLbbQhL0CfprhpXgcFv6BPSyptKIXt+bQ9N1Cfzh10fmCQPj219Oga
2PiIlq3d9GmOmc7va4OVybSaH4z+z2nbPVjbTieVhqD/d9o9qTv6W+n8AT3Q
P3CG15EeWE2ih7pC0f8prWT1xNxGOx7AphO0mm1A/326yQXb+8/0ek9CL/Qn
0hnlsGcRbQ/ojf6tdMlk2Hycri2GlWb6sV8f9Eeme909D9bG0XEnYMPHtG10
GPq30Kv3wtZjtOIXjv5G2jwNdodneF1wNNz7XGhbdAT6F9AWFbYU0wci+qL/
KG1SYOdt2l0Pe3pn8noGR6J/DB1XDJs/pP2bYWUjXftBFPp/oVvvwtpNeoLS
D/2GLF7vH7CcQBdH9Ef/XPqbJbBaSNvPwe5K8fkx0ZjX6YJy2NQjm88jZAD6
36IzzLD9fdr0LexcT1f0HIj+g2K/EDZqdE4DbA7O4f2IH4T+kTni/w07ZtGu
Bliz0ZNCjOjfT6fGw/KfdGEebA3MZU8JrL5B19bA7mza+gSW1tBJkTHod9At
I2DLJTorC7b7z+L/axXsfJ0u3gd7MugwDTauop2hsej/nvYbDivnaUMK7Ogy
m/dzOay9Qvcrgw0z6YIzsKzQN7oORv9uetwoWD1Lp2bC7qf0us8Gj/0f7zjl
sQ==
      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{3.7920096*^9, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->
   FrontEndValueCache[{{Automatic, Automatic}, {Charting`FindScaledTicks[
       (Charting`getDateTicks[Automatic, {"MonthShort", "/", "Day"}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, Automatic]& )[
       
        SlotSequence[1]], {Identity, Identity}]& , Charting`ScaledFrameTicks[
       (Charting`getDateTicks[
       Charting`getDateTicks[Automatic, {"MonthShort", "/", "Day"}, 
         (Map[DateList, {
           SlotSequence[1]}]& )[
          SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
         Automatic]& , {"MonthShort", "/", "Day"}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, None]& )[
        SlotSequence[1]], {Identity, Identity}]& }}, {{
     Automatic, Automatic}, {{{3.792096*^9, 
        FormBox["\"3/02\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.798144*^9, 
        FormBox["\"5/11\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.804192*^9, 
        FormBox["\"7/20\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.81024*^9, 
        FormBox["\"9/28\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.792096*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7933056*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7945152*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7957248*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7969344*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.798144*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7993536*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8005632*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8017728*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8029824*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.804192*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8054016*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8066112*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8078208*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}}, {{3.792096*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.798144*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.804192*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.81024*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.792096*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7933056*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7945152*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7957248*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7969344*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.798144*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7993536*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8005632*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8017728*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8029824*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.804192*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8054016*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8066112*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8078208*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{3.7920096*^9, 3.8084256*^9}, {0, 637509.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{{}, Automatic}]], "Output",
 CellChangeTimes->{
  3.797020457613255*^9, 3.7970207372244453`*^9, {3.797021206595524*^9, 
   3.7970212113391027`*^9}, 3.797022891661726*^9, 3.7970728009026527`*^9, 
   3.797150740068777*^9, {3.79716719799438*^9, 3.797167201867378*^9}, {
   3.7972572665877533`*^9, 3.797257294174864*^9}, 3.7973236046406527`*^9, 
   3.797323671176504*^9, 3.797356644445985*^9, 3.7973566819558697`*^9, {
   3.7973797116147213`*^9, 3.797379730033536*^9}, 3.79737977848221*^9, 
   3.797514200857044*^9, 3.797515455832568*^9, 3.797515623713974*^9, 
   3.7975291715158863`*^9, 3.79767700516462*^9, 3.7976771763987627`*^9, 
   3.7977199881640778`*^9, 3.797720140854887*^9, 3.797772684763771*^9, 
   3.797802806671813*^9, 3.797803712340623*^9, 3.7978891721243067`*^9, 
   3.797890884252604*^9, 3.797930603362656*^9, 3.797937399311705*^9, 
   3.797961653313464*^9, 3.7979764517443323`*^9, 3.7979792936567802`*^9, 
   3.798027475311002*^9, 3.798047069369137*^9, 3.798049682688551*^9, 
   3.7980568135200977`*^9, {3.798134524072791*^9, 3.798134534378098*^9}, 
   3.79813457259454*^9, 3.7983176442311974`*^9, 3.7983179794318237`*^9, {
   3.798492793361804*^9, 3.798492805679637*^9}, 3.798492951503133*^9, 
   3.798578948843378*^9, 3.798579033019767*^9, 3.798579122227645*^9, 
   3.798579205543293*^9, 3.7987541431227016`*^9, 3.798754466772831*^9, 
   3.7988277612628727`*^9, 3.798925329895071*^9, 3.798925758741548*^9, {
   3.7990127702361*^9, 3.799012795163829*^9}, 3.799013072318182*^9, 
   3.799270449367701*^9, 3.799272129429474*^9, 3.799412046579752*^9, 
   3.79944274657003*^9, 3.799530014975029*^9, 3.79961472386462*^9, 
   3.7996147744580097`*^9, 3.7997045851639977`*^9, 3.799789559088654*^9, 
   3.7998763359418697`*^9, 3.799876439936224*^9, {3.7999624254414062`*^9, 
   3.799962447237185*^9}, 3.800047732389304*^9, 3.800137733219942*^9, 
   3.8002214255983477`*^9, 3.8002217021765413`*^9, 3.800319069571025*^9, 
   3.800395764251788*^9, 3.800480898314579*^9, 3.8005653272602997`*^9, 
   3.800725632242343*^9, 3.800737758915403*^9, 3.8007379805541353`*^9, 
   3.800738047713697*^9, 3.8008266650183067`*^9, 3.800827677751864*^9, 
   3.800910863785531*^9, 3.800912940368999*^9, 3.800913179486676*^9, 
   3.800997330744391*^9, 3.801084760715144*^9, 3.801085206724469*^9, 
   3.8011712551478662`*^9, 3.801258069265901*^9, 3.801345433677107*^9, 
   3.801346288073567*^9, 3.801479030900086*^9, 3.8015171636281776`*^9, 
   3.8016006240001383`*^9, 3.801612548416212*^9, 3.801612672567299*^9, 
   3.80161278633847*^9, 3.801774337726427*^9, 3.801861228458314*^9, 
   3.801995994874707*^9, 3.8020336040483932`*^9, 3.802121409727436*^9, 
   3.8022955895906982`*^9, 3.802382130529378*^9, 3.802382200981894*^9, 
   3.802471159014674*^9, 3.8026258697161922`*^9, 3.80272539072386*^9, 
   3.802725556916183*^9, 3.8027256596503277`*^9, 3.802811113094647*^9, 
   3.8028115651571817`*^9, 3.802897380526136*^9, 3.802985594345973*^9, 
   3.802986708658595*^9, 3.802986883667549*^9, 3.8029875497095823`*^9, 
   3.803074264858898*^9, 3.803158113612281*^9, 3.803300039782318*^9, 
   3.803415946919553*^9, 3.803416127858317*^9, 3.8034162645021257`*^9, 
   3.8034176689896727`*^9, 3.8034189097676373`*^9, 3.803419662601069*^9, 
   3.803499543083742*^9, 3.8035013900580063`*^9, 3.803501439784623*^9, 
   3.803502206529271*^9, 3.803503455324656*^9, 3.803565360527381*^9, 
   3.803565416837306*^9, 3.803566322581221*^9, 3.803567708799591*^9, 
   3.80356775731317*^9, 3.80357145714721*^9, 3.8035715153423862`*^9, 
   3.803571593677854*^9, 3.8035915113761883`*^9, 3.8036646419831667`*^9, 
   3.803665405490782*^9, 3.8036655474489193`*^9, 3.803666474586195*^9, 
   3.803667552034349*^9, 3.8037357190390787`*^9, 3.803735975221862*^9, 
   3.803736434862751*^9, 3.80373651334085*^9, 3.803736625826152*^9, 
   3.803736803137179*^9, 3.8037408952668343`*^9, 3.803763126737329*^9, 
   3.8037632468974323`*^9, 3.803763309669629*^9, 3.803764149390109*^9, 
   3.803764719689252*^9, 3.8037690601431723`*^9, 3.8037690999048653`*^9, 
   3.8037693504600077`*^9, 3.803847899963646*^9, 3.8038480534508*^9, 
   3.803848108073217*^9, {3.8038482009842157`*^9, 3.803848227685195*^9}, 
   3.803937140205721*^9, 3.803937301008794*^9, 3.804026593849451*^9, 
   3.804108469104985*^9, 3.804108557525532*^9, 3.804109879651046*^9, 
   3.804193689307743*^9, 3.804193777504303*^9, 3.804368099193965*^9, 
   3.804452580571731*^9, 3.8044527958323507`*^9, 3.804452962082958*^9, 
   3.804453068281082*^9, 3.804453203525003*^9, 3.804544433689273*^9, 
   3.8047151589458857`*^9, 3.804715231862103*^9, 3.804717494651723*^9, 
   3.804800224985282*^9, 3.804853836292201*^9, 3.80486058417284*^9, 
   3.804868190507698*^9, 3.804871039892399*^9, 3.804884626234728*^9, 
   3.804963245229793*^9, 3.80496659214785*^9, 3.8049672806757*^9, 
   3.804970984923027*^9, 3.80503205930479*^9, 3.805049852391501*^9, 
   3.8051451670609283`*^9, 3.805145655733489*^9, 3.805145853360281*^9, 
   3.805146046740059*^9, 3.805201928856381*^9, 3.805232574823729*^9, 
   3.805232767097796*^9, 3.805317647964774*^9, 3.8053184751971197`*^9, 
   3.805318558028613*^9, 3.805319447968918*^9, 3.805319556489141*^9, 
   3.805402865532135*^9, 3.80540340304766*^9, 3.8054917287999573`*^9, 
   3.8055787058046637`*^9, 3.805639029749382*^9, 3.805725936821199*^9, 
   3.805726029518959*^9, 3.805735862348942*^9, 3.805750042344103*^9, 
   3.805750091789298*^9, 3.8057503689922543`*^9, 3.8058083446972847`*^9, 
   3.8058111351517878`*^9, 3.805838877511367*^9, 3.805920953450674*^9, {
   3.806072150032208*^9, 3.806072174985787*^9}, 3.8060726064225082`*^9, 
   3.8060728166204433`*^9, 3.806175567352522*^9, 3.806183938272648*^9, 
   3.80618400309372*^9, 3.806353309716357*^9, 3.80635354830377*^9, 
   3.806353687685289*^9, 3.806441724388989*^9, 3.80644184966247*^9, 
   3.8064421370922537`*^9, 3.806699634145225*^9, 3.806699768142161*^9, 
   3.8067012947304153`*^9, 3.806701398234826*^9, 3.806772440203014*^9, 
   3.806872046500361*^9, 3.806872161343711*^9, 3.807006747306579*^9, 
   3.807006906954484*^9, 3.8071313756523237`*^9, 3.807389424807301*^9, 
   3.8073896297634153`*^9, 3.807562304888064*^9, 3.807651533343199*^9, 
   3.8077387387145987`*^9, 3.807738957140498*^9, 3.807903008385213*^9, 
   3.8080829359489594`*^9, 3.808222333525612*^9, 3.808223953393079*^9, 
   3.808429339674245*^9, 3.808602223966297*^9, 3.808651499949646*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"f2df8b49-c293-48ef-8833-566f5159a763"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DatosRecuperadosDias", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "1"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "2"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "3"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "4"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "5"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "6"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "7"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "8"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "9"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "10"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "11"}], "}"}], ",", "1"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "12"}], "}"}], ",", "1"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "13"}], "}"}], ",", "1"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "14"}], "}"}], ",", "1"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "15"}], "}"}], ",", "3"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "16"}], "}"}], ",", "3"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "17"}], "}"}], ",", "4"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "18"}], "}"}], ",", "4"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "19"}], "}"}], ",", "4"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "20"}], "}"}], ",", "4"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "21"}], "}"}], ",", "4"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "22"}], "}"}], ",", "4"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "23"}], "}"}], ",", "35"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "24"}], "}"}], ",", "35"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "25"}], "}"}], ",", "37"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "26"}], "}"}], ",", "37"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "27"}], "}"}], ",", "37"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "28"}], "}"}], ",", "41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "29"}], "}"}], ",", "41"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "30"}], "}"}], ",", "55"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "31"}], "}"}], ",", "58"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "1"}], "}"}], ",", "758"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "2"}], "}"}], ",", "758"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "3"}], "}"}], ",", "758"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "4"}], "}"}], ",", "758"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "5"}], "}"}], ",", "758"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "6"}], "}"}], ",", "758"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "7"}], "}"}], ",", "1771"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "8"}], "}"}], ",", "1771"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "9"}], "}"}], ",", "1859"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "10"}], "}"}], ",", "1859"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "11"}], "}"}], ",", "1964"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "12"}], "}"}], ",", "1859"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "13"}], "}"}], ",", "1859"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "14"}], "}"}], ",", "1964"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "15"}], "}"}], ",", "1964"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "16"}], "}"}], ",", "2282"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "17"}], "}"}], ",", "2451"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "18"}], "}"}], ",", "2451"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "19"}], "}"}], ",", "2451"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "20"}], "}"}], ",", "2451"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "21"}], "}"}], ",", "5095"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "22"}], "}"}], ",", "5459"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "23"}], "}"}], ",", "5459"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "24"}], "}"}], ",", "6437"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "25"}], "}"}], ",", "7437"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "26"}], "}"}], ",", "7437"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "27"}], "}"}], ",", "8354"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "28"}], "}"}], ",", "9088"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "29"}], "}"}], ",", "9088"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "30"}], "}"}], ",", "11718"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "1"}], "}"}], ",", "12377"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "2"}], "}"}], ",", "13447"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "3"}], "}"}], ",", "13447"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "4"}], "}"}], ",", "13447"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "5"}], "}"}], ",", "13447"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "6"}], "}"}], ",", "13447"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "7"}], "}"}], ",", "13447"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "8"}], "}"}], ",", "21717"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "9"}], "}"}], ",", "21824"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "10"}], "}"}], ",", "23100"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "11"}], "}"}], ",", "23100"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "11"}], "}"}], ",", "23100"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "12"}], "}"}], ",", "24466"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "14"}], "}"}], ",", "28475"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "15"}], "}"}], ",", "30451"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "16"}], "}"}], ",", "30451"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "17"}], "}"}], ",", "33329"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "18"}], "}"}], ",", "33329"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "19"}], "}"}], ",", "37325"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "20"}], "}"}], ",", "38876"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "21"}], "}"}], ",", "38876"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "22"}], "}"}], ",", "38876"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "23"}], "}"}], ",", "44919"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "24"}], "}"}], ",", "47424"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "25"}], "}"}], ",", "49890"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "26"}], "}"}], ",", "52219"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "27"}], "}"}], ",", "54383"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "28"}], "}"}], ",", "56638"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "29"}], "}"}], ",", "59610"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "30"}], "}"}], ",", "59610"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "31"}], "}"}], ",", "64326"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "1"}], "}"}], ",", "67491"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "2"}], "}"}], ",", "70308"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "3"}], "}"}], ",", "73271"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "4"}], "}"}], ",", "75448"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "5"}], "}"}], ",", "75448"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "6"}], "}"}], ",", "81544"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "7"}], "}"}], ",", "84419"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "8"}], "}"}], ",", "84419"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "9"}], "}"}], ",", "84419"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "10"}], "}"}], ",", "91412"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "11"}], "}"}], ",", "98064"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "12"}], "}"}], ",", "101767"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "13"}], "}"}], ",", "101767"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "14"}], "}"}], ",", "108110"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "15"}], "}"}], ",", "108110"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "16"}], "}"}], ",", "108110"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "17"}], "}"}], ",", "119355"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "18"}], "}"}], ",", "123095"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "19"}], "}"}], ",", "127332"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "20"}], "}"}], ",", "131186"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "21"}], "}"}], ",", "135279"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "22"}], "}"}], ",", "140118"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "23"}], "}"}], ",", "144488"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "24"}], "}"}], ",", "144488"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "25"}], "}"}], ",", "144488"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "26"}], "}"}], ",", "144488"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "27"}], "}"}], ",", "153797"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "28"}], "}"}], ",", "153797"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "29"}], "}"}], ",", "131264"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "30"}], "}"}], ",", "134957"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "1"}], "}"}], ",", "138319"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "2"}], "}"}], ",", "142593"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "3"}], "}"}], ",", "147205"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "4"}], "}"}], ",", "147205"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "5"}], "}"}], ",", "155604"}], 
      "\[IndentingNewLine]", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "6"}], "}"}], ",", "159657"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "7"}], "}"}], ",", "163646"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "8"}], "}"}], ",", "163646"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "9"}], "}"}], ",", "172230"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "10"}], "}"}], ",", "177097"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "11"}], "}"}], ",", "180852"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "12"}], "}"}], ",", "184764"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "13"}], "}"}], ",", "189063"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "14"}], "}"}], ",", "193976"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "15"}], "}"}], ",", "193976"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "16"}], "}"}], ",", "203464"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "17"}], "}"}], ",", "208436"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "18"}], "}"}], ",", "208436"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "19"}], "}"}], ",", "217423"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "20"}], "}"}], ",", "222068"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "21"}], "}"}], ",", "227165"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "22"}], "}"}], ",", "227165"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "23"}], "}"}], ",", "236209"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "24"}], "}"}], ",", "236209"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "25"}], "}"}], ",", "242692"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "26"}], "}"}], ",", "247178"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "27"}], "}"}], ",", "256777"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "28"}], "}"}], ",", "261457"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "29"}], "}"}], ",", "267147"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "30"}], "}"}], ",", "272187"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "31"}], "}"}], ",", "272187"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "1"}], "}"}], ",", "272187"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "2"}], "}"}], ",", "289394"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "3"}], "}"}], ",", "289394"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "4"}], "}"}], ",", "295677"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "5"}], "}"}], ",", "300254"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "6"}], "}"}], ",", "300254"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "7"}], "}"}], ",", "313386"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "8"}], "}"}], ",", "318638"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "9"}], "}"}], ",", "322465"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "10"}], "}"}], ",", "322465"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "11"}], "}"}], ",", "332800"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "12"}], "}"}], ",", "336635"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "13"}], "}"}], ",", "341507"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "14"}], "}"}], ",", "345653"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "15"}], "}"}], ",", "351372"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "16"}], "}"}], ",", "355101"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "17"}], "}"}], ",", "359347"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "18"}], "}"}], ",", "363307"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "19"}], "}"}], ",", "367537"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "20"}], "}"}], ",", "367537"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "21"}], "}"}], ",", "376409"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "22"}], "}"}], ",", "380492"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "23"}], "}"}], ",", "383872"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "24"}], "}"}], ",", "389124"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "25"}], "}"}], ",", "393101"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "26"}], "}"}], ",", "396758"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "27"}], "}"}], ",", "400479"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "28"}], "}"}], ",", "404667"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "29"}], "}"}], ",", "409127"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "30"}], "}"}], ",", "412580"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "31"}], "}"}], ",", "416738"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "1"}], "}"}], ",", "421373"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "2"}], "}"}], ",", "424990"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "3"}], "}"}], ",", "430287"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "4"}], "}"}], ",", "434667"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "5"}], "}"}], ",", "438754"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "6"}], "}"}], ",", "442268"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "7"}], "}"}], ",", "446715"}], "}"}]}],
     "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.797020495647118*^9, 3.797020499172813*^9}, {
   3.7970205709302387`*^9, 3.7970205724573936`*^9}, {3.7970206322956743`*^9, 
   3.797020642827138*^9}, {3.79702067558571*^9, 3.797020687038226*^9}, {
   3.79702076519874*^9, 3.797020796005786*^9}, {3.797020855101871*^9, 
   3.797021172335073*^9}, 3.797021253156377*^9, {3.7970213139394417`*^9, 
   3.797021315163931*^9}, {3.797021395324675*^9, 3.797021407848268*^9}, {
   3.79702148714268*^9, 3.7970215024509773`*^9}, {3.797021630983317*^9, 
   3.797021661877626*^9}, {3.797150709089779*^9, 3.797150722063205*^9}, {
   3.797257122205345*^9, 3.7972571430817947`*^9}, {3.797323586824851*^9, 
   3.797323601646514*^9}, {3.7973796640546827`*^9, 3.7973796802812767`*^9}, 
   3.797379736051948*^9, {3.797514127435569*^9, 3.797514139959879*^9}, {
   3.797676889525743*^9, 3.79767690370973*^9}, {3.79767716680717*^9, 
   3.797677171741783*^9}, {3.797719956236965*^9, 3.797719961252804*^9}, {
   3.797803626142013*^9, 3.7978036307670317`*^9}, {3.797889113478256*^9, 
   3.797889121274971*^9}, {3.798134340576833*^9, 3.798134374486166*^9}, 
   3.798134405211487*^9, 3.7981344489391947`*^9, {3.7981345117850237`*^9, 
   3.798134512511129*^9}, {3.79831744442743*^9, 3.798317452427864*^9}, {
   3.7983176053931923`*^9, 3.798317610137116*^9}, {3.7983179444380083`*^9, 
   3.798317953598781*^9}, {3.798492557680984*^9, 3.79849256753955*^9}, {
   3.7984927448539457`*^9, 3.79849281785187*^9}, {3.798578881138155*^9, 
   3.7985788951127*^9}, {3.798753940016861*^9, 3.798753943350422*^9}, {
   3.79875402512761*^9, 3.79875404464892*^9}, {3.798754085108692*^9, 
   3.79875409060964*^9}, {3.798925176118369*^9, 3.7989251800802298`*^9}, {
   3.798925240038815*^9, 3.798925251860117*^9}, {3.799012693981997*^9, 
   3.799012707447648*^9}, {3.7992702208806143`*^9, 3.799270226397613*^9}, {
   3.7992703128719254`*^9, 3.799270316804894*^9}, {3.799270375671955*^9, 
   3.799270398981276*^9}, {3.7994119859945498`*^9, 3.799412004383024*^9}, {
   3.799442645057989*^9, 3.799442649003028*^9}, 3.799521488941749*^9, {
   3.799529932925153*^9, 3.799529961421617*^9}, {3.799614675620335*^9, 
   3.799614694474227*^9}, {3.7997045140843563`*^9, 3.799704533596884*^9}, {
   3.799789489806801*^9, 3.7997895057965517`*^9}, {3.799876244799741*^9, 
   3.799876250072836*^9}, {3.799962363509046*^9, 3.799962387756901*^9}, {
   3.8000476699570923`*^9, 3.800047682304627*^9}, {3.800137643072755*^9, 
   3.8001376599642*^9}, {3.800221357974975*^9, 3.800221373818473*^9}, {
   3.800318960912537*^9, 3.800318977811701*^9}, {3.800395646273378*^9, 
   3.800395651304077*^9}, {3.800480826021422*^9, 3.80048083906245*^9}, {
   3.8005653361012363`*^9, 3.8005653566610823`*^9}, {3.800725673752228*^9, 
   3.8007257025020943`*^9}, {3.800737771677552*^9, 3.8007377755891447`*^9}, {
   3.8007380249174643`*^9, 3.800738039423168*^9}, {3.800826676517198*^9, 
   3.800826703329872*^9}, {3.800910735327085*^9, 3.800910786892721*^9}, {
   3.800997280431095*^9, 3.80099728902738*^9}, {3.8009973196127987`*^9, 
   3.80099731989522*^9}, {3.801084728280374*^9, 3.8010847335737743`*^9}, {
   3.801171191541172*^9, 3.80117123150861*^9}, {3.801258035262536*^9, 
   3.8012580385113583`*^9}, {3.801345385984641*^9, 3.801345388643656*^9}, {
   3.801478962690405*^9, 3.801478988880508*^9}, {3.801517122632516*^9, 
   3.801517132423086*^9}, {3.801600503956914*^9, 3.8016005064244003`*^9}, {
   3.801612524113665*^9, 3.801612526303495*^9}, {3.801774270319188*^9, 
   3.8017743053836937`*^9}, {3.801783199643792*^9, 3.80178320337761*^9}, {
   3.801783245309793*^9, 3.801783252184993*^9}, {3.801861173151657*^9, 
   3.801861199224428*^9}, {3.801945889429574*^9, 3.801945893605047*^9}, {
   3.801995947676334*^9, 3.8019959505576477`*^9}, {3.802033564829452*^9, 
   3.802033567916986*^9}, {3.8021213561782618`*^9, 3.8021213591781816`*^9}, {
   3.802295450978772*^9, 3.8022954836160717`*^9}, {3.8023820565206757`*^9, 
   3.802382065646091*^9}, {3.802471101036366*^9, 3.8024711266323442`*^9}, {
   3.802625826826653*^9, 3.802625841906188*^9}, {3.802725323352227*^9, 
   3.802725350854838*^9}, {3.802725542245722*^9, 3.802725545183969*^9}, {
   3.8028110625245457`*^9, 3.8028110745936213`*^9}, {3.802897350211526*^9, 
   3.802897354116399*^9}, {3.8029855323312674`*^9, 3.8029855499953337`*^9}, {
   3.803074221586936*^9, 3.803074236431183*^9}, {3.803158058941327*^9, 
   3.8031580809457407`*^9}, {3.803242080039962*^9, 3.803242084203393*^9}, {
   3.803415883356887*^9, 3.803415893551216*^9}, {3.803416065296033*^9, 
   3.803416095114887*^9}, {3.8035662443401127`*^9, 3.803566287615118*^9}, {
   3.8035914401775103`*^9, 3.803591460446732*^9}, {3.803740642690571*^9, 
   3.803740673708885*^9}, {3.803740815034059*^9, 3.803740891082816*^9}, {
   3.803762778398312*^9, 3.803762782806045*^9}, {3.803762823062421*^9, 
   3.8037628248615417`*^9}, {3.803768997840206*^9, 3.803769002204574*^9}, {
   3.8037690887885513`*^9, 3.8037690974095716`*^9}, {3.8038478648512573`*^9, 
   3.8038478674437733`*^9}, {3.803937090136924*^9, 3.80393710898345*^9}, {
   3.804022777450563*^9, 3.804022780486465*^9}, {3.8040265743615828`*^9, 
   3.804026580425466*^9}, {3.804108418570273*^9, 3.8041084252214413`*^9}, {
   3.8041936518731117`*^9, 3.804193665611445*^9}, {3.804280051954632*^9, 
   3.8042800549976473`*^9}, {3.804368054682229*^9, 3.8043680750441647`*^9}, {
   3.804452527700574*^9, 3.804452548148234*^9}, {3.804544303855221*^9, 
   3.804544313227762*^9}, {3.8045444215277967`*^9, 3.8045444299170237`*^9}, {
   3.804714898992714*^9, 3.80471490379117*^9}, {3.8047174842418203`*^9, 
   3.804717491222226*^9}, {3.8048001654392138`*^9, 3.804800184323929*^9}, {
   3.804884483918906*^9, 3.8048844957253723`*^9}, {3.80488459510961*^9, 
   3.8048845978708*^9}, {3.804970907837228*^9, 3.804970928045735*^9}, {
   3.805145089277851*^9, 3.805145103611113*^9}, {3.805145614125901*^9, 
   3.80514561760662*^9}, {3.8051458058353024`*^9, 3.805145811153345*^9}, {
   3.805232537577582*^9, 3.8052325411605186`*^9}, {3.805317610998197*^9, 
   3.8053176168917418`*^9}, {3.805402812984418*^9, 3.805402836223344*^9}, {
   3.805491632517606*^9, 3.805491636492697*^9}, {3.8055762085705338`*^9, 
   3.805576222803967*^9}, {3.805750006643152*^9, 3.805750019038885*^9}, {
   3.805750312950588*^9, 3.805750315955359*^9}, {3.805838849353445*^9, 
   3.8058388658992558`*^9}, {3.80592090587232*^9, 3.805920917005643*^9}, {
   3.806072571741387*^9, 3.806072584575756*^9}, {3.806183685681579*^9, 
   3.806183701843729*^9}, {3.8063532709589453`*^9, 3.806353285775538*^9}, 
   3.806353671686975*^9, {3.806441559733609*^9, 3.8064415771708508`*^9}, {
   3.806441695924432*^9, 3.8064417115149317`*^9}, {3.80669940701967*^9, 
   3.806699414802754*^9}, {3.806699470628912*^9, 3.806699476852703*^9}, {
   3.8066995287996483`*^9, 3.806699533909565*^9}, 3.806699623756572*^9, {
   3.806701380296865*^9, 3.806701383200572*^9}, {3.806871972313067*^9, 
   3.80687199855091*^9}, {3.806872106496648*^9, 3.806872110513245*^9}, {
   3.807006680903668*^9, 3.807006685694954*^9}, {3.8071311955028677`*^9, 
   3.807131203145027*^9}, {3.807131277478842*^9, 3.807131288757719*^9}, {
   3.807131362108827*^9, 3.807131369921822*^9}, {3.8073892690927763`*^9, 
   3.80738928564596*^9}, {3.807389381887548*^9, 3.8073893890882463`*^9}, {
   3.8075621452331057`*^9, 3.8075621732380037`*^9}, {3.807562266875296*^9, 
   3.8075622792488747`*^9}, {3.807651467885659*^9, 3.8076514969844923`*^9}, {
   3.8077387028183737`*^9, 3.807738714837264*^9}, {3.8079028207754498`*^9, 
   3.807902833665894*^9}, {3.807902959234417*^9, 3.807902978477435*^9}, {
   3.808082778333125*^9, 3.808082791634638*^9}, {3.808082891346674*^9, 
   3.808082912406315*^9}, {3.808223787215252*^9, 3.808223802212029*^9}, {
   3.8082239210004663`*^9, 3.808223933422028*^9}, {3.808429210296482*^9, 
   3.8084292284533587`*^9}, {3.808429319605678*^9, 3.808429324168908*^9}, {
   3.808602086516383*^9, 3.808602097797971*^9}, {3.8086022066053534`*^9, 
   3.808602210717113*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"2eda1d03-a05e-4b44-84c8-c4d1ae4ea4a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"DatosAcumuladosDias", ",", "DatosRecuperadosDias"}], "}"}], ",", 
   
   RowBox[{"DateTicksFormat", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MonthShort\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\""}], 
     "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"O", ",", "X"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "29"}], "}"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.797021226734414*^9, {3.797021675263153*^9, 3.79702170254869*^9}, {
   3.797021879497856*^9, 3.797021903940579*^9}, {3.7970220278895483`*^9, 
   3.797022042726293*^9}, {3.797022074040937*^9, 3.797022109767948*^9}, {
   3.797529181584649*^9, 3.7975292757242603`*^9}, {3.7999627134440517`*^9, 
   3.799962727757566*^9}, {3.8000477482799397`*^9, 3.800047753859048*^9}, {
   3.8035639048372593`*^9, 3.803563919779344*^9}, {3.803563966061183*^9, 
   3.803563986905841*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"e4a35663-bc6f-4efc-8b7d-576358164a6f"],

Cell[BoxData[
 GraphicsBox[{{}, {
    {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[6], 
     AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox["O", {0., 0.}], CompressedData["
1:eJxV0glMk3ccxvGXAhNBsSogKmpB3Jw77OYxwuLyiscQGVZUbrQT3Zxmo5mb
wUjc6xFXddFKUNGF+EaHQ+dm50HYplKJw25i6LyvsddrHjCs11QGOt+nz78J
Td78+snvbft+37exMwvTZwdKklTz/Ah4fhgkvMy75ebRvreS/Pywnvc7RLcj
cLSwUbfrNb8jdHsz/Y7WbVra0ZZdfsfoVs50tFNK6mBtSEcbp/lt0i1/4fcQ
3bYdfg/TrZ70O1G3p11YGadbGjyGli26zenCUib6i/172LFdWMlHv8fvWehv
FbZ+hP5BY4UL0T9J2DUf/QuFvQvQv03YshD9x4XdCvofCycvRX/cOHrOCvSn
Ciur0L9AOGQt+lVh9zr0HxNuK0H/Q2H7evQPGE+XbUT/BGHrZvTPF7aXo79c
+JCKfrdw+Db03xOurUB/zLv0hUr0jxe+shP9NuH+TvR/LbwIln8VHrEH/XeE
N+xFf+9kutd+9I8RPluF/k+EN1Wjv0z44s/orxWecBD9zbQS50J/1ATu4w6j
X6aVNbXonyf2ZUfQv17sq+vQXyP28b+h/5Zw52Po75nC83fWo/8dWsrzoH8O
Lb94Av0lYl8Hqwdol3wK/X+Lfclp9HefyH3TGfS/Tcvp59A/W3juefSvpZW2
C+j/iZaaL6H/qti7G9EfnkpnaOhPoF29L6N/Jq0dgJ1fifOrrqC/ipa3XEX/
Zdpafw39Ye/x99uvo3+EcPAN9M+grSE30b+SNo28hf59tLzyNvobhbc2oT8k
jdcX+Q/63xT+sgX9ebQU4UX/Ctrlgk0/0sa8u+i/KM4ffg/9wZN8tnW5j/6h
tPIXrGXT5h0P0L9c7PMfov8H4bh/0X+OdjbAqsHC6619hP5XaaXmMfozaen4
E/QvodVLrej/jjYf/A/9p2nvhjb0P6Ot6e3of3myz56sp+ifSkurnqF/Me3M
kfSpVNJaO+w8QRvnBehTa6Mrm2HjS+m8v5kGfcqT6aIbsG0RbV8SqE+1gjYP
CtKnp4GubIClVtpYEKxPc/wUn0NCX9CnNY02boIdRbQjv5M+XVvpok4h+vTW
0wl1sOkRLds669MSO5Xf1worE2m1KBT9n9P2O7C2hU7eFIb+32lPShf0P6CL
+nVFf/9pPkd7YTWZHuwOR/+ntJLTDbOcdt6HzUdpNdeI/rt0sxt29M3weVdi
d/SPo7O2w95C2hHcA/2b6bKJsOUIXV8KKy30Y0NP9Edn+tylANaS6PijsPFj
2p4Qgf6N9PLdsO0wrRgi0d9EW6bAnsgsn4sPRfqeC22PiUL/XNqqwtZSel9U
L/Qfos0K7LpJe07D3h7ZvJ6B0egfRceXwpYP6aAWWFlH13/QG/2/0A9uw9p1
eqzSB/3GHF7vH7CcSJdG9UX/LPqbBbC6hnacgT3V4vOjYjCv0sXbYXPXXD6P
sH7of4vOssCO92nzt7BrNV3ZrT/694v9PNik0XmNsCU0j/dj5AD0D88T/2/Y
OZ12N8KanU4JM6F/L502Epb/pNcUwLZO+ewpg9U36Po62JNL257A0go6OToW
/U763jDYeoHOyYEdQdP5/1oGu16nS/fA3iw6QoNNy2hXeBz6v6cNQ2HlLG1M
hZ0BM3g/F8PaK3SfCtiYQRefhGWFvhY4EP076aQRsHqKTsuGPU/pVZ8NHP0/
EOvlsw==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], AbsolutePointSize[6], 
     AbsoluteThickness[1.6], 
     GeometricTransformationBox[InsetBox["X", {0., 0.}], CompressedData["
1:eJx91H9s1GQcx/FukzHZhoXBHMzooaITTzwNBPBnt4M5HIxug224CZWMuEjc
yvyRQ1GqEDhFpRCNRjasLirogVUkgqIUg7Ag6kW3MSWYykQGnKPDKWPK4e5z
3575/mOT9skrfe7pvdum4xY1lC1OEQRhz+CeNLgnC9h8H0iRfOG/TfmRW0/J
Z7Zu4nYquT3Pcsshbq2D2xQKmO0J3OK8hJ27Bw/SCm51C7fxA3f4QsJpUuyY
52f2lSUsxqws59bf4bbC3M4At2f8dGZ5jmstP2ZtGbfZknBBzPY33GI/t3T1
DNfTY1ZncRuPJ1wcc9hwLcxG/9euzTXo/5NbuaqQWZ/JbT3C7TRze1pdhzai
/yy3dsU95Ixm9Bdy26prcxP6N/Lz0lfc6hk+3xhTxBz2u257E/31rq9rQf9r
3MqX3HqE28qeST6xHf2S6/Id6F/CLb/ievwu9O9xnfk5+k9y21n3kkst9N/l
2tqL/jpudYPrrv3o303WvK3o/821/yD6RxQz+27nVhZz6+u4rV3cThdZmtyO
/uGz6P/IsDzV9boO9C/6f5svkLVfD6P/F7L17RH0p88m7z6K/sncxkKyp9BG
/3PcwsdkY9ox9P9M1v6GlbQSZv1WbquGbPccR/9qspB3Av0fkqWabvQfISsr
TqJ3yBz6/Yun0Hsz2Xr3dMz2fLKU+zv6V3FL29z5dWfQ30n2PeGgP1mm+RN6
0e8lq12wUEnWlpxF/zPcyvuuu/9AfzvZ19SH/ovczg2lzJ65ZKn0L/Q/TRZ6
z6F/M1nt7Ef/99z2P2S7dgD915cxS6Xc6pNk85oL6H+brGZG0f8dWcq+iP4B
sp4ixEbfteVxB1bCSgnZHJsUG/UAWWqBrbe4nUPcnnPc8ri5ceftT46NWjG3
+RhZSMX17TfIdctg8SA5cAyW+shpdVhfvXIerdcPG0Xc4UayEcX1hGZy0VMp
6D9Ads7DSi+3nltBzzd1CPpnkIs2wU4D2chKRf/rFe77Dcv7yFNHDUV/D9na
Cps5lcx2AVnqSEP/w2Rj6aXof5Vb3UsOPD8M/afd87np6B9dFXf3p+nxdbl9
D5GD7Rnof5lb/4LsMTLR302WvcPRP3I+3Y+qy9B/Jzl4CpYfJHtLRPSvJ0ea
YPMzbvs4tyjeF3frlhHov41brSX3pY9E/0vkQDkc3sktdJE3e7LQn1kd985G
WJlCXrUN1h/gttZWu9/3UejfQY6shT02OaMTlofVxN2WMxr9k8i+RthcQH40
BNtB8qEeWNxODnmz0X+UvK8eVofez2zcQq49D4eryb5pl2NcTRbqYZ9JFi1Y
+Yk8KQrrlyyIu2pKDvonkpcvhZ0qcuQj2LOS3NQPy1vJ+sQx6D9MDjbAZtJC
en6fwPaN5IADixXkO/xj0a+RQ2tg9T1y8ABstJHVKByOkiP+3Px/Ada84xg=

      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{3.7920096*^9, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->
   FrontEndValueCache[{{Automatic, Automatic}, {Charting`FindScaledTicks[
       (Charting`getDateTicks[Automatic, {"MonthShort", "/", "Day"}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, Automatic]& )[
       
        SlotSequence[1]], {Identity, Identity}]& , Charting`ScaledFrameTicks[
       (Charting`getDateTicks[
       Charting`getDateTicks[Automatic, {"MonthShort", "/", "Day"}, 
         (Map[DateList, {
           SlotSequence[1]}]& )[
          SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
         Automatic]& , {"MonthShort", "/", "Day"}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, None]& )[
        SlotSequence[1]], {Identity, Identity}]& }}, {{
     Automatic, Automatic}, {{{3.792096*^9, 
        FormBox["\"3/02\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.798144*^9, 
        FormBox["\"5/11\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.804192*^9, 
        FormBox["\"7/20\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.81024*^9, 
        FormBox["\"9/28\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.792096*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7933056*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7945152*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7957248*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7969344*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.798144*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7993536*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8005632*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8017728*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8029824*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.804192*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8054016*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8066112*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8078208*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}}, {{3.792096*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.798144*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.804192*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.81024*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.792096*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7933056*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7945152*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7957248*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7969344*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.798144*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.7993536*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8005632*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8017728*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8029824*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.804192*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8054016*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8066112*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.8078208*^9, 
        FormBox[
         TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {
        0.008333333333333333, 0.}}}}}],
  GridLines->{{3.8023776*^9}, {}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{3.7920096*^9, 3.8084256*^9}, {0, 637509.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{{}, Automatic}]], "Output",
 CellChangeTimes->{
  3.7970212299005623`*^9, 3.79702126625692*^9, 3.797021417809779*^9, 
   3.797021508071101*^9, {3.797021650474533*^9, 3.797021703222117*^9}, {
   3.797021892516551*^9, 3.797021905387848*^9}, {3.797022082261084*^9, 
   3.797022111534073*^9}, 3.797022891931552*^9, 3.7970728012380466`*^9, 
   3.797150740379191*^9, {3.797257266983589*^9, 3.79725729437399*^9}, 
   3.797323605285542*^9, 3.797323671478743*^9, 3.797356645257674*^9, 
   3.797356682446516*^9, {3.797379712453147*^9, 3.797379739342389*^9}, 
   3.797379781634717*^9, 3.7975142012366867`*^9, 3.797515456053734*^9, 
   3.797515623949353*^9, 3.797529186789476*^9, {3.797529226545477*^9, 
   3.797529276820738*^9}, 3.797677005488935*^9, 3.79767717694615*^9, 
   3.797719988500993*^9, 3.797720141114664*^9, 3.797772684998664*^9, 
   3.797802806987718*^9, 3.797803712755965*^9, 3.7978891725781403`*^9, 
   3.797890884466875*^9, 3.7979306035495043`*^9, 3.7979373998165703`*^9, 
   3.797961653706216*^9, 3.7979764520352*^9, 3.797979294647417*^9, 
   3.7980274755138893`*^9, 3.798047069602151*^9, 3.7980496829221907`*^9, 
   3.798056813741981*^9, {3.798134524371361*^9, 3.7981345346261063`*^9}, 
   3.798134572834098*^9, 3.79831764459534*^9, 3.79831797966087*^9, 
   3.798492793920899*^9, 3.7984928244604053`*^9, 3.798492951804948*^9, 
   3.798578949096621*^9, 3.798579033281742*^9, 3.79857912277532*^9, 
   3.798579206665415*^9, 3.7987541433627443`*^9, 3.798754467045786*^9, 
   3.798827761619608*^9, 3.798925330258492*^9, 3.7989257590346537`*^9, {
   3.7990127705055113`*^9, 3.79901279569801*^9}, 3.7990130725908012`*^9, 
   3.799270449624653*^9, 3.7992721297434893`*^9, 3.799412046812414*^9, 
   3.79944274682213*^9, 3.799530015212079*^9, 3.799614724256652*^9, 
   3.7996147752069798`*^9, 3.799704585509562*^9, 3.79978955936005*^9, 
   3.799876336195897*^9, 3.799876440512808*^9, {3.799962425728899*^9, 
   3.7999624475430517`*^9}, 3.79996273836018*^9, {3.800047732724949*^9, 
   3.80004775460681*^9}, 3.800137733515047*^9, 3.800221425862626*^9, 
   3.800319070061164*^9, 3.8003957645160503`*^9, 3.800480898631567*^9, 
   3.8005653602867727`*^9, {3.800725694650291*^9, 3.800725704428988*^9}, {
   3.800737819230481*^9, 3.800737822270575*^9}, 3.8007379808629847`*^9, {
   3.800738042157992*^9, 3.800738048098795*^9}, 3.800826706239088*^9, 
   3.800827678022032*^9, 3.800910864049095*^9, 3.800912940648295*^9, 
   3.800913179704525*^9, 3.800997331208941*^9, 3.801084761014798*^9, 
   3.80108520709938*^9, 3.801171256339904*^9, 3.8012580695713263`*^9, 
   3.8013454339453707`*^9, 3.8013462884352493`*^9, 3.801479031378859*^9, 
   3.801517164046238*^9, 3.801600624452654*^9, 3.801612548834219*^9, 
   3.801612672794528*^9, 3.8016127865855103`*^9, 3.801774338238349*^9, 
   3.801861228937067*^9, 3.801995995192368*^9, 3.802033604362747*^9, 
   3.8021214100514297`*^9, 3.802295590046438*^9, 3.802382130725259*^9, 
   3.802382201208626*^9, 3.802471159528458*^9, 3.802625869984315*^9, 
   3.802725391048295*^9, 3.802725557300905*^9, 3.8027256599140997`*^9, 
   3.802811113366955*^9, 3.8028115654697723`*^9, 3.802897380855954*^9, 
   3.802985594643014*^9, 3.802986708887092*^9, 3.8029868838917294`*^9, 
   3.802987550013969*^9, 3.803074265146756*^9, 3.803158113921278*^9, 
   3.80330004025523*^9, 3.803415947370611*^9, 3.803416128138358*^9, 
   3.803416264751358*^9, 3.803417669228189*^9, 3.8034189100937634`*^9, 
   3.803419662846304*^9, 3.803499543254599*^9, 3.803501390206986*^9, 
   3.8035014399294977`*^9, 3.803502206674025*^9, 3.803503455472022*^9, 
   3.803563933989678*^9, {3.8035639671704884`*^9, 3.803563987348036*^9}, 
   3.8035653608766537`*^9, 3.803565417123118*^9, 3.803566322953434*^9, 
   3.803567708947708*^9, 3.8035677575020523`*^9, 3.8035714573323183`*^9, 
   3.8035715155266237`*^9, 3.8035715938631067`*^9, 3.803591511719554*^9, 
   3.803664642278329*^9, 3.803665405790406*^9, 3.803665547742167*^9, 
   3.803666474886001*^9, 3.803667552239818*^9, 3.8037357192413387`*^9, 
   3.803735975372311*^9, 3.8037364350198*^9, 3.803736513891562*^9, 
   3.803736626000887*^9, 3.803736803283906*^9, 3.803740895595324*^9, 
   3.803763127039812*^9, 3.803763247198238*^9, 3.803763309949977*^9, 
   3.803764149625392*^9, 3.803764719982107*^9, 3.8037690604474916`*^9, 
   3.803769100485738*^9, 3.803769350783037*^9, 3.8038479004154673`*^9, 
   3.8038480536872663`*^9, 3.8038481082448874`*^9, 3.803848201227112*^9, 
   3.803937140498843*^9, 3.803937301270533*^9, 3.804026594140394*^9, 
   3.804108469496991*^9, 3.8041085580318193`*^9, 3.804109880122716*^9, 
   3.804193689666353*^9, 3.8041937778187304`*^9, 3.804368099551674*^9, 
   3.8044525809985113`*^9, 3.804452796144299*^9, 3.804452962398135*^9, 
   3.804453068715994*^9, 3.804453203887776*^9, 3.804544434076017*^9, 
   3.804715159317771*^9, 3.80471523217458*^9, 3.804717495196055*^9, 
   3.804800225405603*^9, 3.804853841895623*^9, 3.8048605847936707`*^9, 
   3.804868190808716*^9, 3.8048710405161047`*^9, 3.804884626670608*^9, 
   3.804963245394397*^9, 3.804966592348722*^9, 3.804967280943206*^9, 
   3.804970985305738*^9, 3.805032060162364*^9, 3.805049852879424*^9, 
   3.805145167605714*^9, 3.805145656080081*^9, 3.805145853909863*^9, 
   3.805146047030778*^9, 3.805201929361101*^9, 3.8052325751782312`*^9, 
   3.805232767433805*^9, 3.8053176482716*^9, 3.805318475705764*^9, 
   3.805318558274386*^9, 3.805319448233754*^9, 3.80531955684302*^9, 
   3.805402865954007*^9, 3.805403403345693*^9, 3.805491729171319*^9, 
   3.8055787062321863`*^9, 3.8056390300337667`*^9, 3.80572593810188*^9, 
   3.805726029854397*^9, 3.8057358627363157`*^9, 3.805750043164094*^9, 
   3.805750092633559*^9, 3.805750369735083*^9, 3.805808344945595*^9, 
   3.8058111355005198`*^9, 3.8058388776854267`*^9, 3.8059209537236567`*^9, {
   3.806072150256838*^9, 3.8060721752508163`*^9}, 3.806072606858512*^9, 
   3.806072816972248*^9, 3.806175567778373*^9, 3.806183938938184*^9, 
   3.806184003387684*^9, 3.806353310312522*^9, {3.806353675129307*^9, 
   3.806353688237063*^9}, 3.806441724849636*^9, 3.80644184998595*^9, 
   3.8064421374445333`*^9, 3.806699634577313*^9, 3.8066997684681387`*^9, 
   3.806701295058598*^9, 3.8067013986248283`*^9, 3.806772440495716*^9, 
   3.806872046921075*^9, 3.80687216173374*^9, 3.807006747838785*^9, 
   3.8070069071836557`*^9, 3.807131376317699*^9, 3.807389425367015*^9, 
   3.807389630032217*^9, 3.8075623054200363`*^9, 3.807651533745099*^9, 
   3.807738739189999*^9, 3.807738957441409*^9, 3.8079030087777967`*^9, 
   3.808082936746592*^9, 3.808222333782886*^9, 3.808223953781868*^9, 
   3.808429340221991*^9, 3.80860222449057*^9, 3.808651500335101*^9},
 CellLabel->"Out[7]=",ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"9ebd0e7e-ba0f-4b76-8f0c-9b5e5cf26f77"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DatosFallecidosDias", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "1"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "2"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "3"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "4"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "5"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "6"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "7"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "8"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "9"}], "}"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "10"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "11"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "12"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "13"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "14"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "15"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "16"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "17"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "18"}], "}"}], ",", "0"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "19"}], "}"}], ",", "1"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "20"}], "}"}], ",", "1"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "21"}], "}"}], ",", "2"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "22"}], "}"}], ",", "2"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "23"}], "}"}], ",", "3"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "24"}], "}"}], ",", "4"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "25"}], "}"}], ",", "6"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "26"}], "}"}], ",", "7"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "27"}], "}"}], ",", "8"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "28"}], "}"}], ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "29"}], "}"}], ",", "16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "30"}], "}"}], ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "3", ",", "31"}], "}"}], ",", "29"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "1"}], "}"}], ",", "29"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "2"}], "}"}], ",", "37"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "3"}], "}"}], ",", "50"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "4"}], "}"}], ",", "60"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "5"}], "}"}], ",", "79"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "6"}], "}"}], ",", "94"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "7"}], "}"}], ",", "125"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "8"}], "}"}], ",", "141"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "9"}], "}"}], ",", "174"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "10"}], "}"}], ",", "194"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "11"}], "}"}], ",", "273"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "12"}], "}"}], ",", "275"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "13"}], "}"}], ",", "296"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "14"}], "}"}], ",", "332"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "15"}], "}"}], ",", "406"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "16"}], "}"}], ",", "449"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "17"}], "}"}], ",", "486"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "18"}], "}"}], ",", "546"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "19"}], "}"}], ",", "650"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "20"}], "}"}], ",", "686"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "21"}], "}"}], ",", "712"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "22"}], "}"}], ",", "857"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "23"}], "}"}], ",", "970"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "24"}], "}"}], ",", "1069"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "25"}], "}"}], ",", "1221"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "26"}], "}"}], ",", "1305"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "27"}], "}"}], ",", "1351"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "28"}], "}"}], ",", "1569"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "28"}], "}"}], ",", "1569"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "29"}], "}"}], ",", "1749"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "4", ",", "30"}], "}"}], ",", "1859"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "1"}], "}"}], ",", "1972"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "2"}], "}"}], ",", "2061"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "3"}], "}"}], ",", "2154"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "4"}], "}"}], ",", "2271"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "5"}], "}"}], ",", "2507"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "6"}], "}"}], ",", "2704"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "7"}], "}"}], ",", "2961"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "8"}], "}"}], ",", "3169"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "9"}], "}"}], ",", "3353"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "10"}], "}"}], ",", "3465"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "11"}], "}"}], ",", "3573"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "12"}], "}"}], ",", "3926"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "13"}], "}"}], ",", "4220"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "14"}], "}"}], ",", "4477"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "15"}], "}"}], ",", "4767"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "16"}], "}"}], ",", "5045"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "17"}], "}"}], ",", "5177"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "18"}], "}"}], ",", "5332"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "19"}], "}"}], ",", "5666"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "20"}], "}"}], ",", "6090"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "21"}], "}"}], ",", "6510"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "22"}], "}"}], ",", "6989"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "23"}], "}"}], ",", "7179"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "24"}], "}"}], ",", "7394"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "25"}], "}"}], ",", "7633"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "26"}], "}"}], ",", "8134"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "27"}], "}"}], ",", "8597"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "28"}], "}"}], ",", "9044"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "29"}], "}"}], ",", "9415"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "30"}], "}"}], ",", "9779"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "5", ",", "31"}], "}"}], ",", "9930"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "1"}], "}"}], ",", "10167"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "2"}], "}"}], ",", "10637"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "3"}], "}"}], ",", "11727"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "4"}], "}"}], ",", "12545"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "5"}], "}"}], ",", "13170"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "6"}], "}"}], ",", "13296"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "7"}], "}"}], ",", "13699"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "8"}], "}"}], ",", "14053"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "9"}], "}"}], ",", "14649"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "10"}], "}"}], ",", "15357"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "11"}], "}"}], ",", "15994"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "12"}], "}"}], ",", "16448"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "13"}], "}"}], ",", "16872"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "14"}], "}"}], ",", "17141"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "15"}], "}"}], ",", "17580"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "16"}], "}"}], ",", "18310"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "17"}], "}"}], ",", "19080"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "18"}], "}"}], ",", "19747"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "19"}], "}"}], ",", "20394"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "20"}], "}"}], ",", "20781"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "21"}], "}"}], ",", "21825"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "22"}], "}"}], ",", "22584"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "23"}], "}"}], ",", "23377"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "24"}], "}"}], ",", "24342"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "25"}], "}"}], ",", "25060"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "26"}], "}"}], ",", "25779"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "27"}], "}"}], ",", "26381"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "28"}], "}"}], ",", "26648"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "29"}], "}"}], ",", "27121"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "6", ",", "30"}], "}"}], ",", "27769"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "1"}], "}"}], ",", "28510"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "2"}], "}"}], ",", "29189"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "3"}], "}"}], ",", "29843"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "4"}], "}"}], ",", "30366"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "5"}], "}"}], ",", "30639"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "6"}], "}"}], ",", "31119"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "7"}], "}"}], ",", "32014"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "8"}], "}"}], ",", "32796"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "9"}], "}"}], ",", "33526"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "10"}], "}"}], ",", "34191"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "11"}], "}"}], ",", "34730"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "12"}], "}"}], ",", "35006"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "13"}], "}"}], ",", "35491"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "14"}], "}"}], ",", "36327"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "15"}], "}"}], ",", "36906"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "16"}], "}"}], ",", "37574"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "17"}], "}"}], ",", "38310"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "18"}], "}"}], ",", "38888"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "19"}], "}"}], ",", "39184"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "20"}], "}"}], ",", "39485"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "21"}], "}"}], ",", "40400"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "22"}], "}"}], ",", "41190"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "23"}], "}"}], ",", "41908"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "24"}], "}"}], ",", "42645"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "25"}], "}"}], ",", "43374"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "26"}], "}"}], ",", "43680"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "27"}], "}"}], ",", "44022"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "28"}], "}"}], ",", "44876"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "29"}], "}"}], ",", "45361"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "30"}], "}"}], ",", "46000"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "7", ",", "31"}], "}"}], ",", "46688"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "1"}], "}"}], ",", "47472"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "2"}], "}"}], ",", "47746"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "3"}], "}"}], ",", "48012"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "4"}], "}"}], ",", "48869"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "5"}], "}"}], ",", "49698"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "6"}], "}"}], ",", "50517"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "7"}], "}"}], ",", "51311"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "8"}], "}"}], ",", "52006"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "9"}], "}"}], ",", "52298"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "10"}], "}"}], ",", "53003"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "11"}], "}"}], ",", "53929"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "12"}], "}"}], ",", "54666"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "13"}], "}"}], ",", "55293"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "14"}], "}"}], ",", "55908"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "15"}], "}"}], ",", "56543"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "16"}], "}"}], ",", "56757"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "17"}], "}"}], ",", "57023"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "18"}], "}"}], ",", "57774"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "19"}], "}"}], ",", "58481"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "20"}], "}"}], ",", "59106"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "21"}], "}"}], ",", "59610"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "22"}], "}"}], ",", "60254"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "23"}], "}"}], ",", "60480"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "25"}], "}"}], ",", "61450"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "26"}], "}"}], ",", "62076"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "27"}], "}"}], ",", "62594"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "28"}], "}"}], ",", "63146"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "29"}], "}"}], ",", "63819"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "30"}], "}"}], ",", "64158"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "8", ",", "31"}], "}"}], ",", "64414"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "1"}], "}"}], ",", "65241"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "2"}], "}"}], ",", "65816"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "3"}], "}"}], ",", "66329"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "4"}], "}"}], ",", "66851"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "5"}], "}"}], ",", "67558"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "6"}], "}"}], ",", "67558"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2020", ",", "9", ",", "7"}], "}"}], ",", "67781"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.797022177647904*^9, 3.79702217891927*^9}, {
   3.797022374852412*^9, 3.797022715127534*^9}, {3.797150694685977*^9, 
   3.797150727537623*^9}, 3.79724897697611*^9, {3.797257103082835*^9, 
   3.797257112000679*^9}, {3.79732356505619*^9, 3.797323576101506*^9}, {
   3.797379692415923*^9, 3.797379708030616*^9}, {3.797514158198916*^9, 
   3.79751416610809*^9}, {3.7975142370348473`*^9, 3.797514259000519*^9}, {
   3.7976769315202303`*^9, 3.797676950845831*^9}, {3.79767715487586*^9, 
   3.7976771587620783`*^9}, {3.797719971250147*^9, 3.797719983054791*^9}, {
   3.797720099439518*^9, 3.7977200996667023`*^9}, 3.797720183813146*^9, {
   3.7978036587931223`*^9, 3.797803675463438*^9}, {3.7978891287388153`*^9, 
   3.7978891405407753`*^9}, {3.798134185179235*^9, 3.79813421193467*^9}, {
   3.798134254076236*^9, 3.798134259894899*^9}, {3.798317364324706*^9, 
   3.798317381874556*^9}, {3.798317543901431*^9, 3.798317552824358*^9}, {
   3.798317919135008*^9, 3.79831793209655*^9}, {3.798492621499271*^9, 
   3.798492629476285*^9}, {3.7984926863662443`*^9, 3.798492690531239*^9}, {
   3.7985789025307217`*^9, 3.798578910433929*^9}, {3.798753893595161*^9, 
   3.798753928597097*^9}, {3.79875410611314*^9, 3.798754114409191*^9}, {
   3.798925128371304*^9, 3.798925144622508*^9}, {3.79892526094554*^9, 
   3.798925270278399*^9}, {3.799012716906406*^9, 3.7990127402703857`*^9}, {
   3.7992701802252617`*^9, 3.7992701905223417`*^9}, {3.7992702781162977`*^9, 
   3.799270291840742*^9}, {3.7992704100185957`*^9, 3.7992704210343847`*^9}, {
   3.799412012234462*^9, 3.799412024266032*^9}, {3.7994426765700808`*^9, 
   3.799442693786162*^9}, {3.7995299670434437`*^9, 3.799529984815044*^9}, {
   3.7996147019324903`*^9, 3.799614718525676*^9}, {3.799704472085548*^9, 
   3.799704505518436*^9}, {3.799789511470292*^9, 3.799789520508091*^9}, {
   3.799876277258953*^9, 3.7998762916326447`*^9}, {3.7999623997946787`*^9, 
   3.799962420054269*^9}, {3.800047692142991*^9, 3.8000476979537086`*^9}, {
   3.800137667457077*^9, 3.800137701765108*^9}, {3.800221383153512*^9, 
   3.800221399824903*^9}, {3.800318986136553*^9, 3.800319016882001*^9}, {
   3.800395663426643*^9, 3.800395688310307*^9}, {3.8003957254068327`*^9, 
   3.800395726089447*^9}, {3.8004808472969418`*^9, 3.8004808667830276`*^9}, {
   3.80056536790653*^9, 3.800565387913805*^9}, {3.80072571560885*^9, 
   3.800725735766315*^9}, {3.800737832893544*^9, 3.800737857209552*^9}, {
   3.800826719081114*^9, 3.800826738077003*^9}, {3.800910802964292*^9, 
   3.800910832097416*^9}, {3.800997299484803*^9, 3.8009973137121077`*^9}, {
   3.801084741071125*^9, 3.801084753312899*^9}, {3.801171219230598*^9, 
   3.8011712409632053`*^9}, {3.8012580465525303`*^9, 3.801258060257019*^9}, {
   3.801345412107415*^9, 3.8013454271386633`*^9}, {3.8014789993600407`*^9, 
   3.801479024252193*^9}, {3.801517146694612*^9, 3.801517156959257*^9}, {
   3.8016006101586447`*^9, 3.801600613839279*^9}, {3.801612538899523*^9, 
   3.8016125429914637`*^9}, {3.801774312132543*^9, 3.801774325653203*^9}, {
   3.801783271705104*^9, 3.801783299125546*^9}, {3.801861207522183*^9, 
   3.80186122173036*^9}, {3.801945902303252*^9, 3.8019459051705637`*^9}, {
   3.8019959633934803`*^9, 3.801995964878811*^9}, {3.8020335859098177`*^9, 
   3.802033597502903*^9}, {3.802121377296216*^9, 3.802121390104432*^9}, {
   3.802295491986965*^9, 3.8022955092492647`*^9}, {3.8022955661021748`*^9, 
   3.802295566920032*^9}, {3.802382097181747*^9, 3.802382116929615*^9}, {
   3.802471148398991*^9, 3.802471155861185*^9}, {3.802625854350773*^9, 
   3.80262586405254*^9}, {3.802725358897046*^9, 3.802725382630414*^9}, {
   3.802725503754815*^9, 3.802725505136787*^9}, {3.80281110128902*^9, 
   3.802811110145218*^9}, {3.802897365376281*^9, 3.802897376036401*^9}, {
   3.8029855632669353`*^9, 3.802985590391848*^9}, {3.803074249102669*^9, 
   3.803074261622365*^9}, {3.803158090329184*^9, 3.8031581038750477`*^9}, {
   3.803242094324687*^9, 3.8032420968793077`*^9}, {3.803300004114168*^9, 
   3.803300005154098*^9}, {3.80341590140184*^9, 3.8034159360012627`*^9}, {
   3.803416104215247*^9, 3.8034161250554647`*^9}, {3.8035663021845837`*^9, 
   3.803566318975494*^9}, {3.8035914740739717`*^9, 3.803591483945655*^9}, {
   3.803740685419695*^9, 3.803740809068378*^9}, {3.803762793193104*^9, 
   3.8037628083381977`*^9}, {3.8037690292211933`*^9, 3.803769055817666*^9}, {
   3.803847882437646*^9, 3.8038478960112143`*^9}, {3.803937118876947*^9, 
   3.803937136776568*^9}, {3.8040227878400927`*^9, 3.804022791263069*^9}, {
   3.8040265861770973`*^9, 3.8040265908092012`*^9}, {3.804108454385992*^9, 
   3.804108465614263*^9}, {3.804193676104241*^9, 3.8041936868617287`*^9}, {
   3.804280064044259*^9, 3.804280071779685*^9}, {3.804368088384521*^9, 
   3.8043680917587423`*^9}, {3.804452558240272*^9, 3.804452572058667*^9}, {
   3.804544367371634*^9, 3.804544410504074*^9}, {3.804714935876501*^9, 
   3.804714947659689*^9}, 3.804715156636283*^9, {3.804717432911324*^9, 
   3.804717435410789*^9}, {3.8048001943645782`*^9, 3.804800217272637*^9}, {
   3.804884608152906*^9, 3.804884622199609*^9}, {3.804970966222036*^9, 
   3.804970980596016*^9}, {3.805145115933309*^9, 3.805145132776957*^9}, {
   3.805145638246998*^9, 3.805145643577524*^9}, {3.8052325527396297`*^9, 
   3.805232568684963*^9}, {3.8053176274713297`*^9, 3.805317642533614*^9}, {
   3.805402844241128*^9, 3.80540285977491*^9}, {3.8054916482530003`*^9, 
   3.8054916691409273`*^9}, {3.80557630720411*^9, 3.8055763119582033`*^9}, {
   3.805578696340274*^9, 3.805578696905006*^9}, {3.805750024792987*^9, 
   3.805750060232593*^9}, {3.805750341595766*^9, 3.805750364972075*^9}, {
   3.805838836711032*^9, 3.80583884374888*^9}, {3.805920926513007*^9, 
   3.8059209448553543`*^9}, {3.8060725944287357`*^9, 3.806072603732106*^9}, {
   3.806183708199513*^9, 3.806183722278817*^9}, {3.806183832574856*^9, 
   3.8061838378222523`*^9}, {3.806353295199461*^9, 3.806353306218762*^9}, {
   3.80644158621533*^9, 3.806441600591825*^9}, {3.8064417189788513`*^9, 
   3.8064417209683857`*^9}, {3.806699423095203*^9, 3.806699448583426*^9}, {
   3.806699547674137*^9, 3.806699551919454*^9}, 3.806699630652725*^9, {
   3.806701391934874*^9, 3.806701393859353*^9}, {3.8068720087546873`*^9, 
   3.8068720430505323`*^9}, {3.8068720829607773`*^9, 3.806872084438858*^9}, {
   3.807006714506287*^9, 3.80700673006389*^9}, {3.807131226472939*^9, 
   3.807131264442939*^9}, {3.807389300463367*^9, 3.807389313303111*^9}, {
   3.807389368624316*^9, 3.807389368992762*^9}, {3.807562182855825*^9, 
   3.807562201496747*^9}, {3.807562250954073*^9, 3.80756226135546*^9}, {
   3.807651505609826*^9, 3.80765153091179*^9}, {3.80773872283599*^9, 
   3.8077387354816313`*^9}, {3.807902842197283*^9, 3.807902855785527*^9}, {
   3.807902985941844*^9, 3.807903005549098*^9}, {3.808082798349649*^9, 
   3.808082809818472*^9}, {3.808082921483571*^9, 3.80808293199699*^9}, {
   3.808223809757626*^9, 3.808223826183989*^9}, {3.808223941836009*^9, 
   3.808223951017477*^9}, {3.8084292377726088`*^9, 3.808429260206243*^9}, {
   3.808429304795033*^9, 3.808429314163848*^9}, {3.808602105914604*^9, 
   3.8086021341147423`*^9}, {3.8086022201597767`*^9, 3.808602220857826*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"8af9945c-791d-4692-a275-811bab3fa86e"],

Cell[CellGroupData[{

Cell["\<\
IN TERMS OF THE DAY NUMBER 
(EN NUMERO DE DIA)\
\>", "Subsection",
 CellChangeTimes->{{3.797073157179414*^9, 3.797073165401186*^9}, {
  3.797073557619711*^9, 3.797073560516425*^9}, {3.808650968065662*^9, 
  3.808650982171364*^9}},ExpressionUUID->"eb8c675e-5c24-4bf5-a2f2-\
299f4e26b0e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DAD", "=", 
  RowBox[{"DatosAcumuladosDias", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.797073110064866*^9, 3.797073126858862*^9}, 
   3.7972573867955713`*^9},
 CellLabel->"In[9]:=",ExpressionUUID->"7638c27d-5da6-4835-bece-d656a95c2b05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "6", ",", "7", ",", "7", 
   ",", "7", ",", "7", ",", "8", ",", "13", ",", "19", ",", "26", ",", "43", 
   ",", "65", ",", "92", ",", "93", ",", "118", ",", "164", ",", "203", ",", 
   "251", ",", "316", ",", "367", ",", "405", ",", "537", ",", "585", ",", 
   "717", ",", "848", ",", "993", ",", "1138", ",", "1215", ",", "1378", ",", 
   "1510", ",", "1688", ",", "1890", ",", "2143", ",", "2439", ",", "2785", 
   ",", "3181", ",", "3441", ",", "4126", ",", "4219", ",", "4661", ",", 
   "5014", ",", "5399", ",", "5847", ",", "6297", ",", "6875", ",", "7497", 
   ",", "8261", ",", "8772", ",", "9501", ",", "10544", ",", "11633", ",", 
   "12872", ",", "13842", ",", "14677", ",", "16752", ",", "18585", ",", 
   "19224", ",", "20739", ",", "22088", ",", "23471", ",", "24905", ",", 
   "26025", ",", "27634", ",", "29616", ",", "31522", ",", "33460", ",", 
   "35022", ",", "36327", ",", "38324", ",", "40186", ",", "42595", ",", 
   "45032", ",", "47144", ",", "49219", ",", "51633", ",", "54346", ",", 
   "56594", ",", "59567", ",", "62527", ",", "65856", ",", "68620", ",", 
   "71105", ",", "74560", ",", "78023", ",", "81400", ",", "84627", ",", 
   "87512", ",", "90664", ",", "93435", ",", "97326", ",", "101368", ",", 
   "105680", ",", "110026", ",", "113619", ",", "117103", ",", "120102", ",", 
   "124301", ",", "129184", ",", "133974", ",", "139196", ",", "142690", ",", 
   "146837", ",", "150264", ",", "154863", ",", "159793", ",", "165030", ",", 
   "170485", ",", "175202", ",", "180545", ",", "185122", ",", "191410", ",", 
   "196847", ",", "202951", ",", "208392", ",", "212802", ",", "216852", ",", 
   "220657", ",", "226089", ",", "231770", ",", "238511", ",", "245251", ",", 
   "252165", ",", "256848", ",", "261750", ",", "268008", ",", "275003", ",", 
   "282283", ",", "289174", ",", "295268", ",", "299750", ",", "304435", ",", 
   "311486", ",", "317635", ",", "324041", ",", "331298", ",", "338913", ",", 
   "344224", ",", "349396", ",", "356255", ",", "362274", ",", "370712", ",", 
   "378285", ",", "385036", ",", "390516", ",", "395489", ",", "402697", ",", 
   "408449", ",", "416179", ",", "424637", ",", "434193", ",", "439394", ",", 
   "443813", ",", "449961", ",", "456100", ",", "462690", ",", "469407", ",", 
   "475902", ",", "480278", ",", "485836", ",", "492522", ",", "498380", ",", 
   "505751", ",", "511369", ",", "517714", ",", "522162", ",", "525733", ",", 
   "531239", ",", "537031", ",", "543806", ",", "549734", ",", "556216", ",", 
   "560164", ",", "563705", ",", "568621", ",", "573888", ",", "579914", ",", 
   "585738", ",", "591712", ",", "595841", ",", "599560", ",", "606036", ",", 
   "610957", ",", "616894", ",", "623090", ",", "629409", ",", "634023", ",", 
   "637509"}], "}"}]], "Output",
 CellChangeTimes->{
  3.797529301466909*^9, 3.79767700576667*^9, 3.7976771773706408`*^9, 
   3.79771998877645*^9, 3.7977200501899757`*^9, 3.7977201045151987`*^9, 
   3.7977201413859367`*^9, 3.797720189025405*^9, {3.797772685159897*^9, 
   3.797772696658717*^9}, 3.797802807440359*^9, {3.797803712970134*^9, 
   3.797803732580145*^9}, {3.797803781515766*^9, 3.797803810437726*^9}, {
   3.797889172722536*^9, 3.797889184261281*^9}, 3.797890884641241*^9, 
   3.797930603688129*^9, 3.797937399962472*^9, 3.797961654044804*^9, 
   3.797976452349784*^9, 3.7979792948674994`*^9, 3.7980274756994667`*^9, {
   3.798047033966617*^9, 3.7980470698021727`*^9}, 3.798049683044664*^9, 
   3.798056813872521*^9, {3.798134524767715*^9, 3.798134534749937*^9}, 
   3.798134573110846*^9, 3.798317644987*^9, 3.7983179798602324`*^9, 
   3.7984927940489407`*^9, 3.798492835109623*^9, 3.798492907464348*^9, 
   3.798492952114183*^9, 3.798578949302384*^9, 3.798579033550939*^9, 
   3.7985791229123363`*^9, 3.7985792098030567`*^9, 3.7987541435871553`*^9, 
   3.7987544671784573`*^9, 3.7988277625111027`*^9, 3.798925330589842*^9, 
   3.7989257591944523`*^9, {3.799012770732519*^9, 3.799012795905672*^9}, 
   3.799013072816287*^9, 3.799270449847703*^9, 3.7992721300911503`*^9, 
   3.799412047004587*^9, 3.799442746936737*^9, 3.799530015515224*^9, 
   3.799614724444106*^9, 3.799614775415358*^9, 3.799704585753378*^9, 
   3.799789559687758*^9, 3.7998763363965597`*^9, 3.7998764413135138`*^9, {
   3.799962425831067*^9, 3.799962447822062*^9}, 3.800047732902377*^9, 
   3.800137733784739*^9, 3.800221426075974*^9, 3.80022171454921*^9, 
   3.80031907029154*^9, {3.800395764709833*^9, 3.800395776139516*^9}, 
   3.800480898863212*^9, 3.800565394952026*^9, 3.800725739378117*^9, 
   3.800737866708311*^9, 3.800737981115459*^9, 3.80073804841486*^9, 
   3.8008267447704897`*^9, 3.800827678130266*^9, 3.8009108643212223`*^9, 
   3.800912940858367*^9, 3.800913179823028*^9, 3.800997331339476*^9, 
   3.80108476134947*^9, 3.801085207499621*^9, 3.8011712566709538`*^9, 
   3.801258069790701*^9, 3.801345434159658*^9, 3.801346289690926*^9, 
   3.8014790316154013`*^9, 3.801517164255498*^9, 3.8016006246365013`*^9, 
   3.8016125490336313`*^9, 3.801612672938895*^9, 3.801612786765254*^9, 
   3.801774338461514*^9, 3.801861229141761*^9, 3.801995995478552*^9, 
   3.802033604548991*^9, 3.8021214102414913`*^9, 3.802295590179083*^9, 
   3.802382130893795*^9, 3.8023822013466187`*^9, 3.8024711597425623`*^9, 
   3.802625870348257*^9, 3.802725391250128*^9, 3.802725557491103*^9, 
   3.802725660039789*^9, 3.802811113747909*^9, 3.802811565697712*^9, 
   3.802897381105007*^9, 3.8029855948420773`*^9, 3.80298670905156*^9, 
   3.802986884057889*^9, 3.8029875504473047`*^9, 3.8030742654072733`*^9, 
   3.803158114167576*^9, 3.803300040557434*^9, 3.803415947591428*^9, 
   3.803416128618292*^9, 3.803416264918763*^9, 3.803417669370494*^9, 
   3.803418910378203*^9, 3.8034196630184927`*^9, 3.8034995434158783`*^9, 
   3.8035013902898684`*^9, 3.8035014399843063`*^9, 3.8035022067309933`*^9, 
   3.803503455574967*^9, 3.803565361069139*^9, 3.803565417291149*^9, 
   3.8035663232499027`*^9, 3.803567709046303*^9, 3.803567757578402*^9, 
   3.80357145740744*^9, 3.803571515599937*^9, 3.80357159395151*^9, 
   3.80359151213526*^9, 3.803664642452688*^9, 3.803665405974271*^9, 
   3.803665547920073*^9, 3.803666475061167*^9, 3.803667552309403*^9, 
   3.803735719319838*^9, 3.803735975452248*^9, 3.803736435129237*^9, 
   3.8037365140223417`*^9, 3.803736626079023*^9, 3.803736803364231*^9, 
   3.803740895837351*^9, 3.803763127288362*^9, 3.8037632473472643`*^9, 
   3.803763310114338*^9, 3.803764149785447*^9, 3.8037647201228323`*^9, 
   3.803769060720811*^9, 3.8037691006596622`*^9, 3.803769350958241*^9, 
   3.8038479006653233`*^9, 3.803848053845993*^9, 3.8038481082986183`*^9, 
   3.8038482013798513`*^9, 3.803937140959375*^9, 3.803937301658025*^9, 
   3.804026594497327*^9, 3.804108469772787*^9, 3.804108558217338*^9, 
   3.804109880320217*^9, 3.8041936902300453`*^9, 3.8041937781324587`*^9, 
   3.8043680999334383`*^9, 3.80445258125428*^9, 3.804452796333445*^9, 
   3.804452962581506*^9, 3.804453068898041*^9, 3.804453204094097*^9, 
   3.804544434336632*^9, 3.8047151596972713`*^9, 3.804715232370535*^9, 
   3.8047174954753513`*^9, 3.804800225874112*^9, 3.804853843361286*^9, 
   3.804860585047361*^9, 3.804868191058367*^9, 3.804871040683634*^9, 
   3.804884626931004*^9, 3.804963245482736*^9, 3.8049665924344597`*^9, 
   3.8049672810206833`*^9, 3.80497098585489*^9, 3.805032060499836*^9, 
   3.805049853243616*^9, 3.805145167754058*^9, 3.8051456563541927`*^9, 
   3.805145854153013*^9, 3.805146047190591*^9, 3.80520192959916*^9, 
   3.805232575587051*^9, 3.8052327676170464`*^9, 3.805317648659889*^9, 
   3.80531847590316*^9, 3.805318558462451*^9, 3.8053194484021263`*^9, 
   3.8053195573128643`*^9, 3.805402866233224*^9, 3.805403403560218*^9, 
   3.805491729464403*^9, 3.805578706490489*^9, 3.805639030243189*^9, 
   3.805725939116543*^9, 3.805726030043913*^9, 3.805735862858779*^9, 
   3.805750043870433*^9, 3.805750093322801*^9, 3.80575037045247*^9, 
   3.805808345027465*^9, 3.8058111358832273`*^9, 3.8058388777542467`*^9, 
   3.8059209538183403`*^9, {3.806072150462784*^9, 3.806072175856792*^9}, 
   3.806072607181328*^9, 3.806072817161173*^9, 3.80617556811384*^9, 
   3.806183939167243*^9, 3.8061840040696583`*^9, 3.80635331052733*^9, 
   3.8063536886756573`*^9, 3.806441725186565*^9, 3.806441850163587*^9, 
   3.8064421376470947`*^9, 3.806699634860305*^9, 3.806699768645152*^9, 
   3.806701295243129*^9, 3.806701398943972*^9, 3.806772440756178*^9, 
   3.806872047168394*^9, 3.806872161888064*^9, 3.8070067480865583`*^9, 
   3.807006907322033*^9, 3.807131376550617*^9, 3.8073894255397*^9, 
   3.8073896302130337`*^9, 3.80756230559109*^9, 3.8076515340205097`*^9, 
   3.807738739446973*^9, 3.8077389575859327`*^9, 3.8079030090962667`*^9, 
   3.808082937045578*^9, 3.808222334093828*^9, 3.808223954065555*^9, 
   3.808429340369299*^9, 3.8086022247437477`*^9, 3.8086515004883633`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"2f3fe794-e4f6-46f8-8b3b-77486067a344"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatosAcumulados", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"DAD", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "DIAMX"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7970729333416862`*^9, 3.797072946884502*^9}, {
   3.797073031440246*^9, 3.797073066184914*^9}, {3.797073124362422*^9, 
   3.797073141672263*^9}, {3.797073471827609*^9, 3.7970734810720587`*^9}, {
   3.797257393463262*^9, 3.7972573954111223`*^9}, {3.797257522799972*^9, 
   3.797257529066646*^9}, {3.797323718340048*^9, 3.797323718572611*^9}, {
   3.797380058866678*^9, 3.7973800593258533`*^9}, {3.797514216729869*^9, 
   3.797514216956697*^9}, {3.797676967098487*^9, 3.797676967612433*^9}, {
   3.79772003815841*^9, 3.797720038683861*^9}, {3.7978037181397*^9, 
   3.7978037181819077`*^9}, {3.797889146384162*^9, 3.79788914864361*^9}, {
   3.7981345422853403`*^9, 3.798134543401209*^9}, {3.7983176168648863`*^9, 
   3.798317617002811*^9}, {3.798317961301238*^9, 3.798317961686121*^9}, {
   3.798492840398363*^9, 3.7984928408525143`*^9}, {3.7985789182312517`*^9, 
   3.798578918725258*^9}, {3.7987541193287973`*^9, 3.798754119723298*^9}, {
   3.798925282331293*^9, 3.798925283082114*^9}, {3.799012748632622*^9, 
   3.799012748909404*^9}, {3.7992704263584137`*^9, 3.799270426842087*^9}, {
   3.7994120289202423`*^9, 3.799412029308255*^9}, {3.799442698998605*^9, 
   3.799442699301097*^9}, 3.799529989996496*^9, {3.799614755129697*^9, 
   3.799614755355199*^9}, {3.799704547134172*^9, 3.799704547482378*^9}, {
   3.799789530617803*^9, 3.799789531456709*^9}, {3.7998763105896463`*^9, 
   3.7998763110877647`*^9}, {3.799962431442554*^9, 3.7999624316207848`*^9}, {
   3.800047705158367*^9, 3.8000477053711042`*^9}, {3.80013770844814*^9, 
   3.800137708597005*^9}, {3.800221405257598*^9, 3.800221406062056*^9}, {
   3.80022171861843*^9, 3.8002217378392687`*^9}, {3.80031902378018*^9, 
   3.800319024468995*^9}, 3.800395743728001*^9, {3.800480873147191*^9, 
   3.80048087355554*^9}, {3.800565398291658*^9, 3.80056539846134*^9}, {
   3.800725743099784*^9, 3.80072574510886*^9}, {3.800737870771678*^9, 
   3.8007378709806004`*^9}, {3.8008267478559027`*^9, 
   3.8008267481251297`*^9}, {3.800910839450809*^9, 3.800910839786371*^9}, 
   3.800913158620324*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"08e35caa-75a8-4cd9-b31a-f9506ec68782"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "19"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "43"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "65"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "92"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "93"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "118"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "164"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "203"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "251"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "316"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "367"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "405"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "537"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "585"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "717"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "848"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "993"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "1138"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "1215"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "1378"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "1510"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "1688"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "1890"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "2143"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "2439"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "2785"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "3181"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "3441"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "4126"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "4219"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "4661"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "5014"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "5399"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "5847"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "6297"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "6875"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "7497"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51", ",", "8261"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"52", ",", "8772"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"53", ",", "9501"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"54", ",", "10544"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "11633"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56", ",", "12872"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"57", ",", "13842"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"58", ",", "14677"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59", ",", "16752"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "18585"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61", ",", "19224"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62", ",", "20739"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63", ",", "22088"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "23471"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"65", ",", "24905"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"66", ",", "26025"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67", ",", "27634"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"68", ",", "29616"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"69", ",", "31522"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70", ",", "33460"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"71", ",", "35022"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72", ",", "36327"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"73", ",", "38324"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"74", ",", "40186"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"75", ",", "42595"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76", ",", "45032"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"77", ",", "47144"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", "49219"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"79", ",", "51633"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80", ",", "54346"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "56594"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"82", ",", "59567"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"83", ",", "62527"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84", ",", "65856"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85", ",", "68620"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "71105"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87", ",", "74560"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88", ",", "78023"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"89", ",", "81400"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "84627"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91", ",", "87512"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"92", ",", "90664"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "93435"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"94", ",", "97326"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95", ",", "101368"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"96", ",", "105680"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "110026"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"98", ",", "113619"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99", ",", "117103"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "120102"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"101", ",", "124301"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"102", ",", "129184"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"103", ",", "133974"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104", ",", "139196"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"105", ",", "142690"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"106", ",", "146837"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"107", ",", "150264"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"108", ",", "154863"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"109", ",", "159793"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"110", ",", "165030"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"111", ",", "170485"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"112", ",", "175202"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"113", ",", "180545"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114", ",", "185122"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"115", ",", "191410"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"116", ",", "196847"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"117", ",", "202951"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"118", ",", "208392"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"119", ",", "212802"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"120", ",", "216852"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"121", ",", "220657"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"122", ",", "226089"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", "231770"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"124", ",", "238511"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125", ",", "245251"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"126", ",", "252165"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"127", ",", "256848"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"128", ",", "261750"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"129", ",", "268008"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"130", ",", "275003"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"131", ",", "282283"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"132", ",", "289174"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"133", ",", "295268"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"134", ",", "299750"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"135", ",", "304435"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"136", ",", "311486"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"137", ",", "317635"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"138", ",", "324041"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"139", ",", "331298"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"140", ",", "338913"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"141", ",", "344224"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"142", ",", "349396"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143", ",", "356255"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"144", ",", "362274"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"145", ",", "370712"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"146", ",", "378285"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"147", ",", "385036"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148", ",", "390516"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"149", ",", "395489"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"150", ",", "402697"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"151", ",", "408449"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"152", ",", "416179"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"153", ",", "424637"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"154", ",", "434193"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"155", ",", "439394"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156", ",", "443813"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"157", ",", "449961"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"158", ",", "456100"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"159", ",", "462690"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"160", ",", "469407"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"161", ",", "475902"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"162", ",", "480278"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"163", ",", "485836"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"164", ",", "492522"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"165", ",", "498380"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"166", ",", "505751"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"167", ",", "511369"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"168", ",", "517714"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"169", ",", "522162"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"170", ",", "525733"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"171", ",", "531239"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"172", ",", "537031"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"173", ",", "543806"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"174", ",", "549734"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"175", ",", "556216"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"176", ",", "560164"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"177", ",", "563705"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"178", ",", "568621"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"179", ",", "573888"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180", ",", "579914"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"181", ",", "585738"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"182", ",", "591712"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"183", ",", "595841"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"184", ",", "599560"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"185", ",", "606036"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"186", ",", "610957"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"187", ",", "616894"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"188", ",", "623090"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"189", ",", "629409"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"190", ",", "634023"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191", ",", "637509"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7973800666318817`*^9, 3.797450850712431*^9, 3.797452110418269*^9, 
   3.797513878471341*^9, {3.797514201791205*^9, 3.797514217772976*^9}, 
   3.7975154563008213`*^9, 3.79751562417223*^9, {3.797529292651146*^9, 
   3.7975293018059893`*^9}, 3.797677006120949*^9, 3.79767717789939*^9, 
   3.797719989193358*^9, 3.79772005084247*^9, 3.797720104888019*^9, 
   3.797720141583399*^9, 3.797720189326638*^9, {3.797772685309342*^9, 
   3.7977726968657827`*^9}, 3.797802807577927*^9, {3.797803713080534*^9, 
   3.797803732742285*^9}, {3.7978037817091722`*^9, 3.797803810754739*^9}, {
   3.797889172859766*^9, 3.797889184528482*^9}, 3.797890884767602*^9, 
   3.797930603747799*^9, 3.797937400090823*^9, 3.797961654145059*^9, 
   3.7979764524717903`*^9, 3.797979294984291*^9, 3.798027475798666*^9, {
   3.798047034349564*^9, 3.798047069918276*^9}, 3.7980496831563177`*^9, 
   3.798056814019066*^9, {3.7981345248917303`*^9, 3.798134534856462*^9}, 
   3.798134573257408*^9, 3.798317645157392*^9, 3.7983179799937*^9, 
   3.798492794205777*^9, 3.798492835360126*^9, 3.798492907696682*^9, 
   3.7984929522808447`*^9, 3.798578949422475*^9, 3.798579033701255*^9, 
   3.798579122990431*^9, 3.798579209906086*^9, 3.7987541438244257`*^9, 
   3.798754467488072*^9, 3.7988277626602373`*^9, 3.7989253306799583`*^9, 
   3.79892575935178*^9, {3.799012770873719*^9, 3.7990127960149307`*^9}, 
   3.799013072951269*^9, 3.79927044998065*^9, 3.799272130219966*^9, 
   3.7994120471197577`*^9, 3.7994427471103888`*^9, 3.79953001562809*^9, 
   3.7996147245666227`*^9, 3.799614775551256*^9, 3.799704585894816*^9, 
   3.799789559801427*^9, 3.7998763364951982`*^9, 3.799876441464035*^9, {
   3.799962425979967*^9, 3.799962448056176*^9}, 3.8000477330692167`*^9, 
   3.8001377338929358`*^9, 3.800221426185862*^9, {3.8002217199125443`*^9, 
   3.800221738440753*^9}, 3.80031907044238*^9, {3.800395764827655*^9, 
   3.800395776274502*^9}, 3.80048089906767*^9, 3.8005653990249157`*^9, 
   3.800725745903359*^9, 3.800737871398011*^9, 3.800737981249584*^9, 
   3.8007380485624437`*^9, 3.8008267486579227`*^9, 3.800827678242577*^9, 
   3.800910864406164*^9, 3.800912941042153*^9, 3.800913179921979*^9, 
   3.80099733143819*^9, 3.8010847614830217`*^9, 3.801085207615904*^9, 
   3.801171256787369*^9, 3.801258069916975*^9, 3.801345434295063*^9, 
   3.801346290638215*^9, 3.801479031749732*^9, 3.801517164376915*^9, 
   3.801600624752986*^9, 3.801612549174944*^9, 3.801612673005507*^9, 
   3.8016127869973*^9, 3.80177433861292*^9, 3.801861229276546*^9, 
   3.801995995583868*^9, 3.802033604665682*^9, 3.8021214103763533`*^9, 
   3.8022955902810097`*^9, 3.802382131102338*^9, 3.802382201430348*^9, 
   3.802471159879696*^9, 3.8026258704895363`*^9, 3.8027253914117517`*^9, 
   3.802725557617744*^9, 3.802725660135008*^9, 3.802811113882738*^9, 
   3.8028115658101254`*^9, 3.802897381318885*^9, 3.802985594987376*^9, 
   3.802986709155754*^9, 3.802986884135253*^9, 3.802987550494331*^9, 
   3.803074265531515*^9, 3.803158114293255*^9, 3.803300040718495*^9, 
   3.803415947712829*^9, 3.803416128762959*^9, 3.803416265002613*^9, 
   3.803417669424913*^9, 3.803418910461791*^9, 3.803419663101994*^9, 
   3.803499543477771*^9, 3.8035013903731613`*^9, 3.80350144005777*^9, 
   3.80350220681569*^9, 3.803503455674971*^9, 3.803565361152663*^9, 
   3.8035654173713284`*^9, 3.803566323567994*^9, 3.8035677091306963`*^9, 
   3.8035677576619997`*^9, 3.80357145747598*^9, 3.803571515664402*^9, 
   3.803571594046405*^9, 3.803591512298841*^9, 3.8036646425353813`*^9, 
   3.8036654060560102`*^9, 3.8036655480040913`*^9, 3.803666475142289*^9, 
   3.803667552409286*^9, 3.803735719421198*^9, 3.803735975536553*^9, 
   3.803736435189877*^9, 3.803736514120886*^9, 3.803736626142935*^9, 
   3.803736803437167*^9, 3.803740895989551*^9, 3.803763127418955*^9, 
   3.803763247400978*^9, 3.803763310198079*^9, 3.803764149853388*^9, 
   3.803764720174363*^9, 3.803769060850256*^9, 3.803769100794073*^9, 
   3.803769351068198*^9, 3.8038479008050756`*^9, 3.803848053945417*^9, 
   3.8038481083593607`*^9, 3.803848201495285*^9, 3.803937141109707*^9, 
   3.803937301738481*^9, 3.804026594650519*^9, 3.804108469954022*^9, 
   3.804108558265491*^9, 3.804109880400319*^9, 3.804193690398505*^9, 
   3.8041937782821217`*^9, 3.804368100114689*^9, 3.804452581422596*^9, 
   3.804452796411743*^9, 3.804452962665936*^9, 3.804453068980072*^9, 
   3.804453204177383*^9, 3.804544434504003*^9, 3.8047151598782587`*^9, 
   3.804715232454996*^9, 3.804717495669385*^9, 3.804800226057249*^9, 
   3.80485384377915*^9, 3.8048605851777287`*^9, 3.804868191180835*^9, 
   3.804871040823979*^9, 3.804884627113262*^9, 3.804963245559106*^9, 
   3.804966592481001*^9, 3.804967281105282*^9, 3.8049709860576*^9, 
   3.80503206064402*^9, 3.8050498533571243`*^9, 3.80514516789179*^9, 
   3.805145656613832*^9, 3.8051458543283453`*^9, 3.805146047248415*^9, 
   3.8052019297290573`*^9, 3.805232575765087*^9, 3.805232767700563*^9, 
   3.805317648972423*^9, 3.805318475941708*^9, 3.8053185586100616`*^9, 
   3.805319448535695*^9, 3.8053195575436783`*^9, 3.805402866415064*^9, 
   3.805403403636282*^9, 3.805491729620955*^9, 3.8055787066625767`*^9, 
   3.805639030362007*^9, 3.80572593936401*^9, 3.805726030123467*^9, 
   3.805735862980888*^9, 3.805750044206772*^9, 3.8057500938483047`*^9, 
   3.805750370772482*^9, 3.8058083451074038`*^9, 3.805811136008913*^9, 
   3.805838877787833*^9, 3.805920953862338*^9, {3.8060721505340757`*^9, 
   3.806072176221558*^9}, 3.806072607392864*^9, 3.8060728172561283`*^9, 
   3.806175568237809*^9, 3.806183939367421*^9, 3.806184004157402*^9, 
   3.806353310681196*^9, 3.80635368892483*^9, 3.8064417253494797`*^9, 
   3.806441850237626*^9, 3.806442137727069*^9, 3.806699635034083*^9, 
   3.806699768716309*^9, 3.8067012953171988`*^9, 3.8067013990981693`*^9, 
   3.80677244083463*^9, 3.806872047344105*^9, 3.8068721620294228`*^9, 
   3.80700674826544*^9, 3.8070069074379177`*^9, 3.807131376703166*^9, 
   3.807389425664624*^9, 3.807389630286119*^9, 3.8075623057409077`*^9, 
   3.8076515343585157`*^9, 3.8077387396287193`*^9, 3.8077389576628847`*^9, 
   3.8079030092578573`*^9, 3.808082937354887*^9, 3.808222334173314*^9, 
   3.80822395438625*^9, 3.808429340520397*^9, 3.808602224925399*^9, 
   3.8086515005666103`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"c3163e60-941b-4243-8582-fc5c3ec5b248"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DRD", "=", 
  RowBox[{"DatosRecuperadosDias", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.797073110064866*^9, 3.797073126858862*^9}, {
   3.797073180378119*^9, 3.79707318839802*^9}, 3.7977201561334143`*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"807ad068-a7a8-471d-b14a-09d1c0f06810"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "3", ",", 
   "3", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "4", ",", "35",
    ",", "35", ",", "37", ",", "37", ",", "37", ",", "41", ",", "41", ",", 
   "55", ",", "58", ",", "758", ",", "758", ",", "758", ",", "758", ",", 
   "758", ",", "758", ",", "1771", ",", "1771", ",", "1859", ",", "1859", ",",
    "1964", ",", "1859", ",", "1859", ",", "1964", ",", "1964", ",", "2282", 
   ",", "2451", ",", "2451", ",", "2451", ",", "2451", ",", "5095", ",", 
   "5459", ",", "5459", ",", "6437", ",", "7437", ",", "7437", ",", "8354", 
   ",", "9088", ",", "9088", ",", "11718", ",", "12377", ",", "13447", ",", 
   "13447", ",", "13447", ",", "13447", ",", "13447", ",", "13447", ",", 
   "21717", ",", "21824", ",", "23100", ",", "23100", ",", "23100", ",", 
   "24466", ",", "28475", ",", "30451", ",", "30451", ",", "33329", ",", 
   "33329", ",", "37325", ",", "38876", ",", "38876", ",", "38876", ",", 
   "44919", ",", "47424", ",", "49890", ",", "52219", ",", "54383", ",", 
   "56638", ",", "59610", ",", "59610", ",", "64326", ",", "67491", ",", 
   "70308", ",", "73271", ",", "75448", ",", "75448", ",", "81544", ",", 
   "84419", ",", "84419", ",", "84419", ",", "91412", ",", "98064", ",", 
   "101767", ",", "101767", ",", "108110", ",", "108110", ",", "108110", ",", 
   "119355", ",", "123095", ",", "127332", ",", "131186", ",", "135279", ",", 
   "140118", ",", "144488", ",", "144488", ",", "144488", ",", "144488", ",", 
   "153797", ",", "153797", ",", "131264", ",", "134957", ",", "138319", ",", 
   "142593", ",", "147205", ",", "147205", ",", "155604", ",", "159657", ",", 
   "163646", ",", "163646", ",", "172230", ",", "177097", ",", "180852", ",", 
   "184764", ",", "189063", ",", "193976", ",", "193976", ",", "203464", ",", 
   "208436", ",", "208436", ",", "217423", ",", "222068", ",", "227165", ",", 
   "227165", ",", "236209", ",", "236209", ",", "242692", ",", "247178", ",", 
   "256777", ",", "261457", ",", "267147", ",", "272187", ",", "272187", ",", 
   "272187", ",", "289394", ",", "289394", ",", "295677", ",", "300254", ",", 
   "300254", ",", "313386", ",", "318638", ",", "322465", ",", "322465", ",", 
   "332800", ",", "336635", ",", "341507", ",", "345653", ",", "351372", ",", 
   "355101", ",", "359347", ",", "363307", ",", "367537", ",", "367537", ",", 
   "376409", ",", "380492", ",", "383872", ",", "389124", ",", "393101", ",", 
   "396758", ",", "400479", ",", "404667", ",", "409127", ",", "412580", ",", 
   "416738", ",", "421373", ",", "424990", ",", "430287", ",", "434667", ",", 
   "438754", ",", "442268", ",", "446715"}], "}"}]], "Output",
 CellChangeTimes->{
  3.797720156757016*^9, 3.797720189583267*^9, {3.797772685427784*^9, 
   3.797772696994761*^9}, 3.7978028077127323`*^9, {3.7978037132075653`*^9, 
   3.7978037328713017`*^9}, {3.797803781858651*^9, 3.797803810924056*^9}, {
   3.797889173033491*^9, 3.797889184691761*^9}, 3.797890884891842*^9, 
   3.79793060381393*^9, 3.797937400224187*^9, 3.7979616542184753`*^9, 
   3.7979764526070213`*^9, 3.797979295100368*^9, 3.7980274758786287`*^9, {
   3.7980470345271463`*^9, 3.798047070136588*^9}, 3.798049683275093*^9, 
   3.798056814150921*^9, {3.798134525026965*^9, 3.798134534984663*^9}, 
   3.7981345734383087`*^9, 3.798317645342078*^9, 3.798317980110312*^9, 
   3.798492794374331*^9, 3.798492835533285*^9, 3.798492907880241*^9, 
   3.7984929524440002`*^9, 3.798578949534944*^9, 3.7985790338494883`*^9, 
   3.798579123063943*^9, 3.798579210002082*^9, 3.798754143935377*^9, 
   3.7987544676233587`*^9, 3.798827762806807*^9, 3.798925330765554*^9, 
   3.7989257597902412`*^9, {3.799012771000073*^9, 3.799012796132523*^9}, 
   3.799013073268251*^9, 3.79927045011277*^9, 3.799272130358727*^9, 
   3.799412047238696*^9, 3.7994427472953978`*^9, 3.799530015745515*^9, 
   3.799614724727798*^9, 3.799614775685384*^9, 3.7997045860432577`*^9, 
   3.799789559919836*^9, 3.7998763365988827`*^9, 3.7998764416283216`*^9, {
   3.799962426160226*^9, 3.799962448263034*^9}, 3.800047733236845*^9, 
   3.800137734009276*^9, 3.800221426311316*^9, 3.800319070592587*^9, {
   3.800395764967249*^9, 3.800395776391452*^9}, 3.80048089921708*^9, 
   3.8005654014052353`*^9, 3.800725748611808*^9, 3.800737873815783*^9, 
   3.800737981402027*^9, 3.800738048717149*^9, 3.800826755323841*^9, 
   3.800827678360361*^9, 3.800910864504829*^9, 3.800912941203734*^9, 
   3.800913180021885*^9, 3.8009973315436573`*^9, 3.801084761621459*^9, 
   3.801085207732757*^9, 3.8011712568867617`*^9, 3.801258070031736*^9, 
   3.8013454344663477`*^9, 3.8013462908736687`*^9, 3.801479031888748*^9, 
   3.801517164488175*^9, 3.801600624871686*^9, 3.801612549308093*^9, 
   3.801612673106485*^9, 3.801612787049191*^9, 3.801774338763032*^9, 
   3.8018612294305277`*^9, 3.801995995715376*^9, 3.802033604904442*^9, 
   3.802121410632656*^9, 3.802295590381217*^9, 3.802382131297731*^9, 
   3.8023822014798813`*^9, 3.802471160017097*^9, 3.802625870594738*^9, 
   3.802725391556417*^9, 3.802725557732998*^9, 3.802725660262916*^9, 
   3.802811113999422*^9, 3.802811565907928*^9, 3.802897381433999*^9, 
   3.802985595092545*^9, 3.8029867092364483`*^9, 3.802986884185608*^9, 
   3.80298755054624*^9, 3.80307426568088*^9, 3.803158114433673*^9, 
   3.803300040860972*^9, 3.803415947828292*^9, 3.803416128918026*^9, 
   3.803416265120062*^9, 3.803417669493457*^9, 3.803418910527697*^9, 
   3.803419663218717*^9, 3.803499543550686*^9, 3.80350139045439*^9, 
   3.803501440158491*^9, 3.803502206920224*^9, 3.80350345575313*^9, 
   3.803565361234672*^9, 3.803565417457862*^9, 3.803566323770012*^9, 
   3.803567709213902*^9, 3.803567757744815*^9, 3.803571457556015*^9, 
   3.803571515748535*^9, 3.803571594147045*^9, 3.803591512433546*^9, 
   3.80366464262014*^9, 3.803665406141799*^9, 3.803665548086067*^9, 
   3.803666475204934*^9, 3.8036675524933*^9, 3.80373571952139*^9, 
   3.8037359756193542`*^9, 3.8037364352588243`*^9, 3.803736514205463*^9, 
   3.803736626324353*^9, 3.8037368035032187`*^9, 3.803740896116796*^9, 
   3.803763127557125*^9, 3.803763247461172*^9, 3.803763310262328*^9, 
   3.8037641499109383`*^9, 3.803764720242732*^9, 3.8037690609884157`*^9, 
   3.803769100927722*^9, 3.803769351135167*^9, 3.803847900932458*^9, 
   3.803848054045192*^9, 3.8038481084267073`*^9, 3.803848202197062*^9, 
   3.8039371412448*^9, 3.8039373018199587`*^9, 3.804026594817931*^9, 
   3.804108470121222*^9, 3.804108558315221*^9, 3.8041098804671392`*^9, 
   3.804193690563699*^9, 3.804193778432638*^9, 3.804368100300808*^9, 
   3.8044525815878687`*^9, 3.804452796500415*^9, 3.804452962747596*^9, 
   3.8044530690468807`*^9, 3.804453204258708*^9, 3.804544434682598*^9, 
   3.8047151600627832`*^9, 3.8047152325378933`*^9, 3.804717495847945*^9, 
   3.8048002262374697`*^9, 3.8048538446039762`*^9, 3.804860585248804*^9, 
   3.804868191300086*^9, 3.804871040988544*^9, 3.804884627301813*^9, 
   3.804963245623992*^9, 3.804966592532462*^9, 3.804967281190362*^9, 
   3.804970986234041*^9, 3.805032060796481*^9, 3.805049853463722*^9, 
   3.8051451680279427`*^9, 3.805145656783558*^9, 3.805145854492105*^9, 
   3.805146047322905*^9, 3.805201929824606*^9, 3.8052325759355392`*^9, 
   3.805232767777062*^9, 3.8053176491284*^9, 3.8053184759980707`*^9, 
   3.80531855878059*^9, 3.805319448680572*^9, 3.8053195576930103`*^9, 
   3.80540286658184*^9, 3.8054034036897984`*^9, 3.805491729788574*^9, 
   3.805578706846513*^9, 3.8056390304450407`*^9, 3.805725939449019*^9, 
   3.8057260302100573`*^9, 3.805735863116974*^9, 3.805750044518158*^9, 
   3.805750094134964*^9, 3.805750371047822*^9, 3.805808345192792*^9, 
   3.805811136146659*^9, 3.805838877842448*^9, 3.80592095391963*^9, {
   3.806072150593474*^9, 3.806072176556308*^9}, 3.8060726075909853`*^9, 
   3.806072817356338*^9, 3.806175568351672*^9, 3.806183939568735*^9, 
   3.8061840042405376`*^9, 3.806353310851943*^9, 3.806353689196321*^9, 
   3.806441725520549*^9, 3.806441850321154*^9, 3.806442137813237*^9, 
   3.8066996352013283`*^9, 3.8066997687836857`*^9, 3.806701295400622*^9, 
   3.8067013992630157`*^9, 3.806772440902556*^9, 3.806872047579019*^9, 
   3.806872162166883*^9, 3.807006748432926*^9, 3.8070069075297728`*^9, 
   3.8071313768571863`*^9, 3.8073894257983313`*^9, 3.807389630352271*^9, 
   3.8075623058797398`*^9, 3.807651534536302*^9, 3.807738739824808*^9, 
   3.807738957746737*^9, 3.807903009407003*^9, 3.8080829374855747`*^9, 
   3.808222334236917*^9, 3.808223954586034*^9, 3.808429340670045*^9, 
   3.808602225095272*^9, 3.808651500636807*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"fc47e4ee-8903-461d-96af-c8178abb786b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatosRecuperados", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"DRD", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "DIAMX"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7970729333416862`*^9, 3.797072946884502*^9}, {
   3.797073031440246*^9, 3.797073066184914*^9}, {3.797073124362422*^9, 
   3.797073141672263*^9}, {3.797073194346695*^9, 3.7970732027362137`*^9}, {
   3.797073474504737*^9, 3.7970735019996347`*^9}, {3.797257400594162*^9, 
   3.7972574007639*^9}, {3.797257513145404*^9, 3.7972575187306213`*^9}, {
   3.7973237147210083`*^9, 3.797323714905068*^9}, {3.797380054596187*^9, 
   3.797380055819046*^9}, {3.79751422258057*^9, 3.797514222782954*^9}, {
   3.797676969349368*^9, 3.7976769696241817`*^9}, {3.797720040673362*^9, 
   3.79772004090701*^9}, {3.797803721244204*^9, 3.797803721665172*^9}, {
   3.797803796136611*^9, 3.7978038026980333`*^9}, {3.797889153849333*^9, 
   3.7978891541432247`*^9}, {3.7981345466748543`*^9, 3.798134547237784*^9}, {
   3.798317619705514*^9, 3.7983176198772783`*^9}, {3.798317963198184*^9, 
   3.7983179633429337`*^9}, {3.79849284290976*^9, 3.79849284307323*^9}, {
   3.7985789244574213`*^9, 3.798578925389824*^9}, {3.798754123433964*^9, 
   3.798754123894568*^9}, {3.798925285869533*^9, 3.79892528652878*^9}, {
   3.7990127513881483`*^9, 3.7990127515793247`*^9}, {3.799270430280167*^9, 
   3.7992704304489183`*^9}, {3.799412032115053*^9, 3.799412032208927*^9}, {
   3.799442701922524*^9, 3.799442702126359*^9}, 3.799529994075264*^9, {
   3.799614759159153*^9, 3.7996147592642517`*^9}, {3.799704550663085*^9, 
   3.799704551056327*^9}, {3.7997895344309273`*^9, 3.7997895351884727`*^9}, {
   3.799876315350872*^9, 3.799876315593096*^9}, {3.799962435603395*^9, 
   3.7999624357795057`*^9}, {3.800047709687101*^9, 3.800047710015284*^9}, {
   3.8001377113227053`*^9, 3.800137711426759*^9}, {3.800221409350102*^9, 
   3.800221409575945*^9}, {3.80031902769871*^9, 3.800319027818544*^9}, 
   3.800395747392653*^9, {3.800480876777507*^9, 3.800480878398899*^9}, {
   3.8005654052226677`*^9, 3.800565405473402*^9}, {3.800725751901182*^9, 
   3.800725752587579*^9}, {3.800737878845063*^9, 3.800737879048205*^9}, {
   3.800826757665516*^9, 3.8008267579459543`*^9}, {3.800910843199603*^9, 
   3.8009108434414253`*^9}, {3.800913127467804*^9, 3.800913132894683*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"0e458381-6ec3-4490-b0b8-4b53046546fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "35"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "41"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "41"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "55"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "58"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "758"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "758"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "758"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "758"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "758"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "758"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "1771"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "1771"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "1859"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "1859"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "1964"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "1859"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "1859"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "1964"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "1964"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "2282"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "2451"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "2451"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "2451"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51", ",", "2451"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"52", ",", "5095"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"53", ",", "5459"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"54", ",", "5459"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "6437"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56", ",", "7437"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"57", ",", "7437"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"58", ",", "8354"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59", ",", "9088"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "9088"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61", ",", "11718"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62", ",", "12377"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63", ",", "13447"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "13447"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"65", ",", "13447"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"66", ",", "13447"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67", ",", "13447"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"68", ",", "13447"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"69", ",", "21717"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70", ",", "21824"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"71", ",", "23100"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72", ",", "23100"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"73", ",", "23100"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"74", ",", "24466"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"75", ",", "28475"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76", ",", "30451"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"77", ",", "30451"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", "33329"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"79", ",", "33329"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80", ",", "37325"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "38876"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"82", ",", "38876"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"83", ",", "38876"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84", ",", "44919"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85", ",", "47424"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "49890"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87", ",", "52219"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88", ",", "54383"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"89", ",", "56638"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "59610"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91", ",", "59610"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"92", ",", "64326"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "67491"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"94", ",", "70308"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95", ",", "73271"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"96", ",", "75448"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "75448"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"98", ",", "81544"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99", ",", "84419"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "84419"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"101", ",", "84419"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"102", ",", "91412"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"103", ",", "98064"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104", ",", "101767"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"105", ",", "101767"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"106", ",", "108110"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"107", ",", "108110"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"108", ",", "108110"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"109", ",", "119355"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"110", ",", "123095"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"111", ",", "127332"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"112", ",", "131186"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"113", ",", "135279"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114", ",", "140118"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"115", ",", "144488"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"116", ",", "144488"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"117", ",", "144488"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"118", ",", "144488"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"119", ",", "153797"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"120", ",", "153797"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"121", ",", "131264"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"122", ",", "134957"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", "138319"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"124", ",", "142593"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125", ",", "147205"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"126", ",", "147205"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"127", ",", "155604"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"128", ",", "159657"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"129", ",", "163646"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"130", ",", "163646"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"131", ",", "172230"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"132", ",", "177097"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"133", ",", "180852"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"134", ",", "184764"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"135", ",", "189063"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"136", ",", "193976"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"137", ",", "193976"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"138", ",", "203464"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"139", ",", "208436"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"140", ",", "208436"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"141", ",", "217423"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"142", ",", "222068"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143", ",", "227165"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"144", ",", "227165"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"145", ",", "236209"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"146", ",", "236209"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"147", ",", "242692"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148", ",", "247178"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"149", ",", "256777"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"150", ",", "261457"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"151", ",", "267147"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"152", ",", "272187"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"153", ",", "272187"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"154", ",", "272187"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"155", ",", "289394"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156", ",", "289394"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"157", ",", "295677"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"158", ",", "300254"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"159", ",", "300254"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"160", ",", "313386"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"161", ",", "318638"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"162", ",", "322465"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"163", ",", "322465"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"164", ",", "332800"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"165", ",", "336635"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"166", ",", "341507"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"167", ",", "345653"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"168", ",", "351372"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"169", ",", "355101"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"170", ",", "359347"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"171", ",", "363307"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"172", ",", "367537"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"173", ",", "367537"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"174", ",", "376409"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"175", ",", "380492"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"176", ",", "383872"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"177", ",", "389124"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"178", ",", "393101"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"179", ",", "396758"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180", ",", "400479"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"181", ",", "404667"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"182", ",", "409127"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"183", ",", "412580"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"184", ",", "416738"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"185", ",", "421373"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"186", ",", "424990"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"187", ",", "430287"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"188", ",", "434667"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"189", ",", "438754"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"190", ",", "442268"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191", ",", "446715"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.79738006703518*^9, 3.7974508508835163`*^9, 3.7974521105159597`*^9, 
   3.797513878675439*^9, {3.797514201958291*^9, 3.7975142232947197`*^9}, 
   3.797515456439986*^9, 3.7975156243551683`*^9, 3.797529301994645*^9, 
   3.797677006329664*^9, 3.797677178264716*^9, 3.797719989508623*^9, 
   3.797720051221242*^9, 3.797720105281603*^9, 3.797720141878693*^9, 
   3.797720189827653*^9, {3.797772685545023*^9, 3.797772697125229*^9}, 
   3.797802807867423*^9, {3.79780371334103*^9, 3.797803733008156*^9}, {
   3.797803782013988*^9, 3.79780381109102*^9}, {3.79788917319608*^9, 
   3.797889184869248*^9}, 3.7978908851033287`*^9, 3.797930603880804*^9, 
   3.7979374003385353`*^9, 3.797961654300617*^9, 3.797976452773417*^9, 
   3.7979792952172337`*^9, 3.7980274759514027`*^9, {3.798047034746476*^9, 
   3.798047070235217*^9}, 3.798049683635315*^9, 3.7980568142885933`*^9, {
   3.798134525178577*^9, 3.798134535098634*^9}, 3.798134573575204*^9, 
   3.7983176455714493`*^9, 3.798317980226921*^9, 3.798492794539455*^9, 
   3.798492835717168*^9, 3.7984929080425673`*^9, 3.798492952644463*^9, 
   3.79857894965693*^9, 3.798579034001775*^9, 3.798579123146674*^9, 
   3.7985792101383667`*^9, 3.798754144059306*^9, 3.798754467755836*^9, 
   3.798827763685166*^9, 3.798925330863661*^9, 3.798925760545436*^9, {
   3.799012771117092*^9, 3.799012796233265*^9}, 3.799013073401716*^9, 
   3.799270450225904*^9, 3.799272130559564*^9, 3.799412047354369*^9, 
   3.799442747678632*^9, 3.799530015861484*^9, 3.7996147248824778`*^9, 
   3.799614775818643*^9, 3.799704586227768*^9, 3.799789560053547*^9, 
   3.799876336739771*^9, 3.799876441936824*^9, {3.799962426318944*^9, 
   3.799962448445654*^9}, 3.8000477334282513`*^9, 3.800137734124896*^9, 
   3.800221426529513*^9, 3.800319070743145*^9, {3.800395765073721*^9, 
   3.8003957765256243`*^9}, 3.800480899365129*^9, 3.80056540593023*^9, 
   3.800725753199381*^9, 3.800737879532325*^9, 3.800737981533584*^9, 
   3.800738049067223*^9, 3.800826758333481*^9, 3.800827678480945*^9, 
   3.800910864606799*^9, 3.8009129413292837`*^9, 3.800913180123144*^9, 
   3.800997331659595*^9, 3.801084761748068*^9, 3.801085207850423*^9, 
   3.801171256987596*^9, 3.801258070153182*^9, 3.801345434616791*^9, 
   3.8013462914636374`*^9, 3.801479032018742*^9, 3.801517164611342*^9, 
   3.80160062498769*^9, 3.801612549438243*^9, 3.8016126731730127`*^9, 
   3.8016127870953293`*^9, 3.801774338913199*^9, 3.8018612295808697`*^9, 
   3.801995996015564*^9, 3.802033605039139*^9, 3.8021214107821827`*^9, 
   3.802295590481094*^9, 3.802382131425488*^9, 3.802382201580901*^9, 
   3.802471160147298*^9, 3.80262587071542*^9, 3.802725391704524*^9, 
   3.80272555785028*^9, 3.802725660392489*^9, 3.802811114120832*^9, 
   3.802811565989743*^9, 3.802897381567395*^9, 3.802985595210753*^9, 
   3.802986709319516*^9, 3.802986884259039*^9, 3.8029875505938463`*^9, 
   3.803074265832143*^9, 3.803158114584195*^9, 3.803300041024617*^9, 
   3.803415947947228*^9, 3.803416129085649*^9, 3.803416265200791*^9, 
   3.803417669576262*^9, 3.803418910600904*^9, 3.803419663303225*^9, 
   3.803499543611372*^9, 3.8035013905406446`*^9, 3.8035014402237663`*^9, 
   3.803502206993869*^9, 3.8035034558413486`*^9, 3.803565361319813*^9, 
   3.8035654175570717`*^9, 3.803566323985324*^9, 3.803567709297739*^9, 
   3.803567757825799*^9, 3.803571457634101*^9, 3.8035715158322077`*^9, 
   3.8035715942471313`*^9, 3.803591512566489*^9, 3.803664642723322*^9, 
   3.80366540622535*^9, 3.8036655481717978`*^9, 3.8036664752719307`*^9, 
   3.803667552576269*^9, 3.803735719621976*^9, 3.803735975703402*^9, 
   3.8037364353226223`*^9, 3.8037365142913237`*^9, 3.803736626375928*^9, 
   3.80373680358844*^9, 3.803740896254987*^9, 3.8037631277080803`*^9, 
   3.803763247530491*^9, 3.8037633103316927`*^9, 3.803764149963344*^9, 
   3.803764720303863*^9, 3.803769061137739*^9, 3.8037691010612717`*^9, 
   3.8037693512518167`*^9, 3.8038479010659637`*^9, 3.803848055014329*^9, 
   3.803848108490896*^9, 3.8038482025199966`*^9, 3.803937141378409*^9, 
   3.803937301886229*^9, 3.804026594966284*^9, 3.8041084702890987`*^9, 
   3.8041085583642817`*^9, 3.8041098805320253`*^9, 3.80419369074225*^9, 
   3.804193778576556*^9, 3.804368100482267*^9, 3.804452581759781*^9, 
   3.804452796585154*^9, 3.8044529628314133`*^9, 3.804453069109417*^9, 
   3.804453204325803*^9, 3.8045444348390827`*^9, 3.804715160242208*^9, 
   3.804715232601313*^9, 3.804717496065568*^9, 3.804800226424974*^9, 
   3.804853844910406*^9, 3.804860585347969*^9, 3.8048681914195127`*^9, 
   3.80487104110188*^9, 3.804884627483778*^9, 3.804963245694065*^9, 
   3.8049665925830603`*^9, 3.80496728126793*^9, 3.8049709864200373`*^9, 
   3.805032060941845*^9, 3.805049853564558*^9, 3.805145168161171*^9, 
   3.805145656948518*^9, 3.805145854662768*^9, 3.805146047384201*^9, 
   3.8052019299169197`*^9, 3.805232576104754*^9, 3.8052327678490057`*^9, 
   3.805317649295444*^9, 3.805318476105513*^9, 3.805318558930253*^9, 
   3.8053194488011312`*^9, 3.80531955835524*^9, 3.805402866747037*^9, 
   3.805403403790844*^9, 3.805491729951831*^9, 3.8055787070273046`*^9, 
   3.805639030546218*^9, 3.805725939515136*^9, 3.805726030290225*^9, 
   3.805735863247994*^9, 3.8057500448238153`*^9, 3.805750094399954*^9, 
   3.805750371332574*^9, 3.805808345304229*^9, 3.805811136277075*^9, 
   3.805838877904027*^9, 3.805920953965239*^9, {3.806072150655203*^9, 
   3.806072177074224*^9}, 3.8060726077962217`*^9, 3.806072817435522*^9, 
   3.806175568474015*^9, 3.8061839399502573`*^9, 3.806184004324039*^9, 
   3.806353311286483*^9, 3.806353689478264*^9, 3.806441725852511*^9, 
   3.8064418503826323`*^9, 3.806442137893609*^9, 3.80669963536657*^9, 
   3.806699768846014*^9, 3.806701295483509*^9, 3.806701399448522*^9, 
   3.8067724410034018`*^9, 3.806872047712185*^9, 3.806872162317726*^9, 
   3.80700674875027*^9, 3.807006907613188*^9, 3.807131377141519*^9, 
   3.807389425928317*^9, 3.807389630417313*^9, 3.807562306015527*^9, 
   3.807651534824264*^9, 3.8077387401728354`*^9, 3.8077389578290653`*^9, 
   3.8079030095623503`*^9, 3.808082937625443*^9, 3.808222334288047*^9, 
   3.808223954781457*^9, 3.808429340817523*^9, 3.808602225424405*^9, 
   3.8086515007005453`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"0ee46ff2-117f-46be-b40c-904db8343c5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DFD", "=", 
  RowBox[{"DatosFallecidosDias", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "2"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.797073110064866*^9, 3.797073126858862*^9}, {
   3.797073180378119*^9, 3.79707322245613*^9}, 3.797720162076877*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"4fc78e25-81fe-4692-a43a-c48de999c9c5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "2", ",", "2", ",", "3", 
   ",", "4", ",", "6", ",", "7", ",", "8", ",", "12", ",", "16", ",", "20", 
   ",", "29", ",", "29", ",", "37", ",", "50", ",", "60", ",", "79", ",", 
   "94", ",", "125", ",", "141", ",", "174", ",", "194", ",", "273", ",", 
   "275", ",", "296", ",", "332", ",", "406", ",", "449", ",", "486", ",", 
   "546", ",", "650", ",", "686", ",", "712", ",", "857", ",", "970", ",", 
   "1069", ",", "1221", ",", "1305", ",", "1351", ",", "1569", ",", "1569", 
   ",", "1749", ",", "1859", ",", "1972", ",", "2061", ",", "2154", ",", 
   "2271", ",", "2507", ",", "2704", ",", "2961", ",", "3169", ",", "3353", 
   ",", "3465", ",", "3573", ",", "3926", ",", "4220", ",", "4477", ",", 
   "4767", ",", "5045", ",", "5177", ",", "5332", ",", "5666", ",", "6090", 
   ",", "6510", ",", "6989", ",", "7179", ",", "7394", ",", "7633", ",", 
   "8134", ",", "8597", ",", "9044", ",", "9415", ",", "9779", ",", "9930", 
   ",", "10167", ",", "10637", ",", "11727", ",", "12545", ",", "13170", ",", 
   "13296", ",", "13699", ",", "14053", ",", "14649", ",", "15357", ",", 
   "15994", ",", "16448", ",", "16872", ",", "17141", ",", "17580", ",", 
   "18310", ",", "19080", ",", "19747", ",", "20394", ",", "20781", ",", 
   "21825", ",", "22584", ",", "23377", ",", "24342", ",", "25060", ",", 
   "25779", ",", "26381", ",", "26648", ",", "27121", ",", "27769", ",", 
   "28510", ",", "29189", ",", "29843", ",", "30366", ",", "30639", ",", 
   "31119", ",", "32014", ",", "32796", ",", "33526", ",", "34191", ",", 
   "34730", ",", "35006", ",", "35491", ",", "36327", ",", "36906", ",", 
   "37574", ",", "38310", ",", "38888", ",", "39184", ",", "39485", ",", 
   "40400", ",", "41190", ",", "41908", ",", "42645", ",", "43374", ",", 
   "43680", ",", "44022", ",", "44876", ",", "45361", ",", "46000", ",", 
   "46688", ",", "47472", ",", "47746", ",", "48012", ",", "48869", ",", 
   "49698", ",", "50517", ",", "51311", ",", "52006", ",", "52298", ",", 
   "53003", ",", "53929", ",", "54666", ",", "55293", ",", "55908", ",", 
   "56543", ",", "56757", ",", "57023", ",", "57774", ",", "58481", ",", 
   "59106", ",", "59610", ",", "60254", ",", "60480", ",", "61450", ",", 
   "62076", ",", "62594", ",", "63146", ",", "63819", ",", "64158", ",", 
   "64414", ",", "65241", ",", "65816", ",", "66329", ",", "66851", ",", 
   "67558", ",", "67558", ",", "67781"}], "}"}]], "Output",
 CellChangeTimes->{{3.797720162488765*^9, 3.79772019008001*^9}, {
   3.7977726856607037`*^9, 3.797772697260469*^9}, 3.7978028080197783`*^9, {
   3.797803713496221*^9, 3.797803733167499*^9}, {3.797803782165783*^9, 
   3.79780381122256*^9}, {3.79788917334489*^9, 3.7978891850637083`*^9}, 
   3.7978908853491993`*^9, 3.797930603948862*^9, 3.7979374004584513`*^9, 
   3.797961654368207*^9, 3.797976452924349*^9, 3.7979792953338614`*^9, 
   3.798027476033505*^9, {3.798047034909927*^9, 3.798047070352845*^9}, 
   3.798049683736692*^9, 3.79805681442013*^9, {3.798134525291728*^9, 
   3.798134535221012*^9}, 3.798134573763232*^9, 3.798317645739294*^9, 
   3.798317980364479*^9, 3.79849279469267*^9, 3.79849283590688*^9, 
   3.79849290824708*^9, 3.798492952812767*^9, 3.7985789498907013`*^9, 
   3.798579034199561*^9, 3.798579123230727*^9, 3.798579210256132*^9, 
   3.798754144193969*^9, 3.79875446804598*^9, 3.798827763849435*^9, 
   3.798925330948769*^9, 3.798925761425828*^9, {3.799012771233471*^9, 
   3.799012796348995*^9}, 3.7990130735350733`*^9, 3.799270450367364*^9, 
   3.799272130695692*^9, 3.799412047473755*^9, 3.799442748234919*^9, 
   3.7995300159787617`*^9, 3.799614725033409*^9, 3.799614775972352*^9, 
   3.799704586375112*^9, 3.79978956017029*^9, 3.7998763368503942`*^9, 
   3.7998764420304737`*^9, {3.7999624264864187`*^9, 3.7999624485877047`*^9}, 
   3.800047733587988*^9, 3.800137734224641*^9, 3.80022142666438*^9, 
   3.800319070912813*^9, {3.800395765179048*^9, 3.80039577664114*^9}, 
   3.8004808995148573`*^9, 3.800565407986203*^9, 3.800725763809082*^9, 
   3.800737883851159*^9, 3.8007379816670513`*^9, 3.8007380494010553`*^9, 
   3.800826773610618*^9, 3.800827678619114*^9, 3.8009108647243156`*^9, 
   3.800912941459515*^9, 3.800913180657742*^9, 3.800997331776842*^9, 
   3.8010847618893642`*^9, 3.801085207967565*^9, 3.801171257105297*^9, 
   3.801258070267262*^9, 3.801345434759096*^9, 3.801346291584894*^9, 
   3.801479032155838*^9, 3.801517164745749*^9, 3.801600625105077*^9, 
   3.8016125495535173`*^9, 3.801612673239264*^9, 3.801612787179922*^9, 
   3.801774339731038*^9, 3.801861229732376*^9, 3.801995996248575*^9, 
   3.802033605173595*^9, 3.80212141091222*^9, 3.802295590580391*^9, 
   3.8023821315424623`*^9, 3.8023822016804667`*^9, 3.802471160399234*^9, 
   3.802625870826952*^9, 3.802725391839028*^9, 3.802725557964465*^9, 
   3.8027256605081778`*^9, 3.802811114254094*^9, 3.802811566075959*^9, 
   3.802897381701744*^9, 3.802985595324051*^9, 3.802986709403215*^9, 
   3.80298688434128*^9, 3.802987550646504*^9, 3.803074265981806*^9, 
   3.803158114733904*^9, 3.803300041198927*^9, 3.803415948064674*^9, 
   3.803416129236608*^9, 3.80341626527127*^9, 3.803417669642667*^9, 
   3.803418910683167*^9, 3.8034196633840637`*^9, 3.8034995436837597`*^9, 
   3.803501390622405*^9, 3.803501440289735*^9, 3.803502207064063*^9, 
   3.803503455923154*^9, 3.803565361402676*^9, 3.8035654176413183`*^9, 
   3.803566324184249*^9, 3.803567709380869*^9, 3.80356775791459*^9, 
   3.803571457723476*^9, 3.803571515915242*^9, 3.803571594348116*^9, 
   3.803591512740757*^9, 3.803664642803515*^9, 3.803665406309414*^9, 
   3.80366554827176*^9, 3.80366647534486*^9, 3.80366755265991*^9, 
   3.8037357197213287`*^9, 3.803735975787003*^9, 3.8037364353934097`*^9, 
   3.803736514374383*^9, 3.803736626428541*^9, 3.803736803672098*^9, 
   3.8037408964059362`*^9, 3.803763127956079*^9, 3.803763247598312*^9, 
   3.803763310396294*^9, 3.8037641500117188`*^9, 3.803764720376449*^9, 
   3.803769061272767*^9, 3.803769101194716*^9, 3.80376935135069*^9, 
   3.8038479012166233`*^9, 3.803848055248732*^9, 3.8038481085589046`*^9, 
   3.803848202642603*^9, 3.80393714151196*^9, 3.803937301953827*^9, 
   3.804026595119198*^9, 3.8041084704535933`*^9, 3.804108558417214*^9, 
   3.804109880602088*^9, 3.804193690895397*^9, 3.80419377871693*^9, 
   3.804368100649145*^9, 3.804452581968182*^9, 3.804452796665717*^9, 
   3.804452962910266*^9, 3.804453069180439*^9, 3.804453204393332*^9, 
   3.80454443498778*^9, 3.80471516043325*^9, 3.804715232670465*^9, 
   3.804717496245595*^9, 3.804800226604752*^9, 3.804853845418147*^9, 
   3.804860585544854*^9, 3.804868191533023*^9, 3.8048710412778797`*^9, 
   3.804884627669285*^9, 3.804963245758933*^9, 3.804966592631706*^9, 
   3.804967281338711*^9, 3.804970986651829*^9, 3.8050320610660152`*^9, 
   3.805049853647315*^9, 3.8051451682925873`*^9, 3.8051456571176443`*^9, 
   3.805145854844368*^9, 3.805146047456563*^9, 3.805201930009795*^9, 
   3.805232576267509*^9, 3.805232767915402*^9, 3.8053176494867487`*^9, 
   3.805318476207633*^9, 3.8053185590812683`*^9, 3.8053194489191837`*^9, 
   3.805319558462483*^9, 3.8054028669434357`*^9, 3.805403403839402*^9, 
   3.8054917301014853`*^9, 3.80557870719318*^9, 3.805639030632983*^9, 
   3.805725939581913*^9, 3.8057260303574333`*^9, 3.8057358633623*^9, 
   3.805750045123556*^9, 3.805750094692257*^9, 3.805750371621985*^9, 
   3.805808345393682*^9, 3.8058111364138517`*^9, 3.805838877959567*^9, 
   3.805920954014724*^9, {3.806072150714765*^9, 3.8060721772355347`*^9}, 
   3.8060726080285883`*^9, 3.8060728175234528`*^9, 3.80617556860281*^9, 
   3.806183940154089*^9, 3.806184004407729*^9, 3.806353311445101*^9, 
   3.806353689761158*^9, 3.8064417260213947`*^9, 3.806441850454712*^9, 
   3.8064421379810266`*^9, 3.806699635536522*^9, 3.806699768917266*^9, 
   3.806701295548312*^9, 3.8067013996304197`*^9, 3.806772441068411*^9, 
   3.806872047845484*^9, 3.806872162467627*^9, 3.807006748918108*^9, 
   3.807006907690501*^9, 3.8071313772903957`*^9, 3.8073894260806723`*^9, 
   3.807389630469842*^9, 3.80756230623071*^9, 3.807651534959441*^9, 
   3.807738740361557*^9, 3.8077389579125633`*^9, 3.807903009731186*^9, 
   3.808082937780634*^9, 3.808222334333218*^9, 3.808223954965001*^9, 
   3.808429340951108*^9, 3.8086022255971403`*^9, 3.808651500769332*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"0df0e705-0559-4cf3-af2e-0dee08709963"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatosFallecidos", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"DFD", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "DIAMX"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7970729333416862`*^9, 3.797072946884502*^9}, {
   3.797073031440246*^9, 3.797073066184914*^9}, {3.797073124362422*^9, 
   3.797073141672263*^9}, {3.797073194346695*^9, 3.797073227161374*^9}, {
   3.797073476398714*^9, 3.7970734766437063`*^9}, 3.797073511349863*^9, {
   3.797257402312318*^9, 3.7972574027068863`*^9}, {3.7972575086943197`*^9, 
   3.797257508996378*^9}, {3.797323683249838*^9, 3.7973237126714*^9}, {
   3.7973800498773937`*^9, 3.797380051061563*^9}, {3.7974510926463213`*^9, 
   3.797451093477413*^9}, {3.797514270488723*^9, 3.797514282108192*^9}, {
   3.797676971313252*^9, 3.797676971463181*^9}, {3.7977200461867943`*^9, 
   3.797720046357628*^9}, {3.7978037264961767`*^9, 3.797803727275073*^9}, {
   3.797803786962743*^9, 3.79780378734686*^9}, {3.797889157829762*^9, 
   3.7978891580750093`*^9}, {3.7981345505641317`*^9, 
   3.7981345521677923`*^9}, {3.798317623119606*^9, 3.798317623263316*^9}, {
   3.798317965986154*^9, 3.798317966109243*^9}, {3.798492845914405*^9, 
   3.798492846085074*^9}, {3.798578929582858*^9, 3.79857893011756*^9}, {
   3.798754127176594*^9, 3.7987541275912457`*^9}, {3.798925289731393*^9, 
   3.798925290653469*^9}, {3.7990127546262407`*^9, 3.799012754978038*^9}, {
   3.7992704340031843`*^9, 3.799270434181755*^9}, {3.7994427063842793`*^9, 
   3.799442718201145*^9}, 3.799529997049898*^9, {3.7996147623330803`*^9, 
   3.799614762453937*^9}, {3.799704554288794*^9, 3.7997045547379923`*^9}, {
   3.7997895386319523`*^9, 3.799789539944302*^9}, {3.799876318626947*^9, 
   3.799876318974627*^9}, {3.799962439578779*^9, 3.7999624397595043`*^9}, {
   3.800047713178177*^9, 3.800047713291849*^9}, {3.800137716441481*^9, 
   3.800137716567482*^9}, {3.800221412857759*^9, 3.800221413038422*^9}, {
   3.800319031378516*^9, 3.800319055737932*^9}, 3.8003957506892433`*^9, {
   3.800480881934598*^9, 3.800480882253405*^9}, {3.800565410888302*^9, 
   3.800565411071164*^9}, {3.8007257676687593`*^9, 3.80072576832638*^9}, {
   3.8007378858908043`*^9, 3.800737886116284*^9}, {3.8008267774406767`*^9, 
   3.800826778004429*^9}, {3.80091084646642*^9, 3.8009108466418953`*^9}, {
   3.800912926477956*^9, 3.800912929806378*^9}, 3.800913137591096*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"ea467880-ad8c-4414-afae-7099e6b250fc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "37"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "50"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "60"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "79"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "94"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "125"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "141"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "174"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "194"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "273"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "275"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "296"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "332"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "406"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "449"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "486"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "546"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "650"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51", ",", "686"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"52", ",", "712"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"53", ",", "857"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"54", ",", "970"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "1069"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56", ",", "1221"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"57", ",", "1305"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"58", ",", "1351"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59", ",", "1569"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "1569"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61", ",", "1749"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62", ",", "1859"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63", ",", "1972"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "2061"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"65", ",", "2154"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"66", ",", "2271"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67", ",", "2507"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"68", ",", "2704"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"69", ",", "2961"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70", ",", "3169"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"71", ",", "3353"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72", ",", "3465"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"73", ",", "3573"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"74", ",", "3926"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"75", ",", "4220"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76", ",", "4477"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"77", ",", "4767"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", "5045"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"79", ",", "5177"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80", ",", "5332"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "5666"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"82", ",", "6090"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"83", ",", "6510"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84", ",", "6989"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85", ",", "7179"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "7394"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87", ",", "7633"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88", ",", "8134"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"89", ",", "8597"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "9044"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91", ",", "9415"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"92", ",", "9779"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "9930"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"94", ",", "10167"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95", ",", "10637"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"96", ",", "11727"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "12545"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"98", ",", "13170"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99", ",", "13296"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "13699"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"101", ",", "14053"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"102", ",", "14649"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"103", ",", "15357"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104", ",", "15994"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"105", ",", "16448"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"106", ",", "16872"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"107", ",", "17141"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"108", ",", "17580"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"109", ",", "18310"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"110", ",", "19080"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"111", ",", "19747"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"112", ",", "20394"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"113", ",", "20781"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114", ",", "21825"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"115", ",", "22584"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"116", ",", "23377"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"117", ",", "24342"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"118", ",", "25060"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"119", ",", "25779"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"120", ",", "26381"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"121", ",", "26648"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"122", ",", "27121"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", "27769"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"124", ",", "28510"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125", ",", "29189"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"126", ",", "29843"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"127", ",", "30366"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"128", ",", "30639"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"129", ",", "31119"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"130", ",", "32014"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"131", ",", "32796"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"132", ",", "33526"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"133", ",", "34191"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"134", ",", "34730"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"135", ",", "35006"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"136", ",", "35491"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"137", ",", "36327"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"138", ",", "36906"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"139", ",", "37574"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"140", ",", "38310"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"141", ",", "38888"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"142", ",", "39184"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143", ",", "39485"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"144", ",", "40400"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"145", ",", "41190"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"146", ",", "41908"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"147", ",", "42645"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148", ",", "43374"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"149", ",", "43680"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"150", ",", "44022"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"151", ",", "44876"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"152", ",", "45361"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"153", ",", "46000"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"154", ",", "46688"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"155", ",", "47472"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156", ",", "47746"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"157", ",", "48012"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"158", ",", "48869"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"159", ",", "49698"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"160", ",", "50517"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"161", ",", "51311"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"162", ",", "52006"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"163", ",", "52298"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"164", ",", "53003"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"165", ",", "53929"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"166", ",", "54666"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"167", ",", "55293"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"168", ",", "55908"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"169", ",", "56543"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"170", ",", "56757"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"171", ",", "57023"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"172", ",", "57774"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"173", ",", "58481"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"174", ",", "59106"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"175", ",", "59610"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"176", ",", "60254"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"177", ",", "60480"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"178", ",", "61450"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"179", ",", "62076"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180", ",", "62594"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"181", ",", "63146"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"182", ",", "63819"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"183", ",", "64158"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"184", ",", "64414"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"185", ",", "65241"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"186", ",", "65816"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"187", ",", "66329"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"188", ",", "66851"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"189", ",", "67558"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"190", ",", "67558"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191", ",", "67781"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7975142879535513`*^9, 3.797515456601696*^9, 3.797515624520217*^9, 
   3.7975293021797733`*^9, 3.797677006570404*^9, 3.7976771786482573`*^9, 
   3.797719990194604*^9, 3.797720052004032*^9, 3.797720106093103*^9, 
   3.797720142448694*^9, 3.797720190216516*^9, {3.797772686061158*^9, 
   3.797772697414913*^9}, 3.79780280817188*^9, {3.797803713623748*^9, 
   3.79780373331071*^9}, {3.797803782315578*^9, 3.797803811387445*^9}, {
   3.7978891734975348`*^9, 3.797889185267337*^9}, 3.797890887400866*^9, 
   3.797930604033081*^9, 3.797937400708848*^9, 3.79796165444847*^9, 
   3.797976453055962*^9, 3.797979295451975*^9, 3.7980274761846113`*^9, {
   3.7980470351310797`*^9, 3.79804707047095*^9}, 3.79804968386007*^9, 
   3.798056815125369*^9, {3.798134525409657*^9, 3.79813453533575*^9}, 
   3.798134573930173*^9, 3.7983176460046883`*^9, 3.798317980495658*^9, 
   3.7984927948530684`*^9, 3.798492836084178*^9, 3.7984929084317636`*^9, 
   3.7984929529787397`*^9, 3.7985789500244083`*^9, 3.7985790343376637`*^9, 
   3.798579123295354*^9, 3.7985792103543043`*^9, 3.798754144327322*^9, 
   3.7987544689242077`*^9, 3.798827764571076*^9, 3.798925331030944*^9, 
   3.798925761507709*^9, {3.799012771348802*^9, 3.799012796566011*^9}, 
   3.799013073650818*^9, 3.7992704504973516`*^9, 3.799272130821804*^9, 
   3.799412047589768*^9, 3.799442748431254*^9, 3.7995300160955153`*^9, 
   3.799614725312995*^9, 3.799614776103113*^9, 3.799704586524461*^9, 
   3.79978956028712*^9, 3.7998763369680223`*^9, 3.7998764421636143`*^9, {
   3.7999624268641157`*^9, 3.799962448759975*^9}, 3.800047733754848*^9, 
   3.800137734326952*^9, 3.800221426796129*^9, 3.800319071060948*^9, {
   3.8003957652952557`*^9, 3.8003957767578573`*^9}, 3.800480899683226*^9, 
   3.800565411402512*^9, 3.800725768957287*^9, 3.8007378864858837`*^9, 
   3.800737981801127*^9, 3.800738049916737*^9, 3.8008267790472097`*^9, 
   3.800827678731962*^9, 3.800910864839706*^9, {3.800912930529798*^9, 
   3.800912941591964*^9}, 3.800913180969615*^9, 3.800997331891507*^9, 
   3.801084762040023*^9, 3.8010852081006927`*^9, 3.801171257226416*^9, 
   3.8012580703868504`*^9, 3.801345434899001*^9, 3.8013462919768057`*^9, 
   3.801479032418455*^9, 3.801517164928588*^9, 3.8016006252402573`*^9, 
   3.801612549671958*^9, 3.801612673305634*^9, 3.8016127873315067`*^9, 
   3.8017743401333447`*^9, 3.801861229999329*^9, 3.8019959963655653`*^9, 
   3.802033605302127*^9, 3.802121411046517*^9, 3.8022955907482777`*^9, 
   3.802382131659062*^9, 3.8023822017818127`*^9, 3.8024711605351343`*^9, 
   3.8026258709502373`*^9, 3.802725391969144*^9, 3.802725558084412*^9, 
   3.802725660625231*^9, 3.8028111143848352`*^9, 3.802811566176342*^9, 
   3.802897381835771*^9, 3.8029855954233503`*^9, 3.802986709520159*^9, 
   3.802986884406543*^9, 3.802987550697041*^9, 3.8030742661288223`*^9, 
   3.803158114885193*^9, 3.803300041964826*^9, 3.803415948227457*^9, 
   3.803416129403034*^9, 3.803416265354124*^9, 3.8034176697396183`*^9, 
   3.8034189107868643`*^9, 3.803419663451226*^9, 3.8034995437491903`*^9, 
   3.80350139070726*^9, 3.803501440356241*^9, 3.8035022071491337`*^9, 
   3.8035034560087442`*^9, 3.803565361490428*^9, 3.803565417741288*^9, 
   3.803566324425788*^9, 3.8035677094647293`*^9, 3.803567758010158*^9, 
   3.8035714578539658`*^9, 3.80357151599931*^9, 3.803571594498385*^9, 
   3.8035915129249067`*^9, 3.8036646429095182`*^9, 3.803665406392556*^9, 
   3.803665548352736*^9, 3.80366647540971*^9, 3.803667552740748*^9, 
   3.8037357198224783`*^9, 3.803735975869792*^9, 3.803736435456962*^9, 
   3.80373651446624*^9, 3.8037366264760637`*^9, 3.803736803755355*^9, 
   3.8037408965324993`*^9, 3.803763128052314*^9, 3.803763247661796*^9, 
   3.803763310466078*^9, 3.8037641500638237`*^9, 3.8037647204595823`*^9, 
   3.8037690614011793`*^9, 3.803769101328561*^9, 3.803769351414164*^9, 
   3.803847901492725*^9, 3.803848055402172*^9, 3.803848108626025*^9, 
   3.803848202766642*^9, 3.8039371417612*^9, 3.8039373020205507`*^9, 
   3.804026595286338*^9, 3.804108470650766*^9, 3.804108558482676*^9, 
   3.804109880666787*^9, 3.804193691047956*^9, 3.804193778865674*^9, 
   3.804368100851462*^9, 3.804452582141638*^9, 3.8044527967508707`*^9, 
   3.8044529629785357`*^9, 3.804453069244021*^9, 3.804453204476749*^9, 
   3.804544435145289*^9, 3.8047151606613903`*^9, 3.8047152327344*^9, 
   3.804717496427989*^9, 3.804800226820866*^9, 3.8048538458500423`*^9, 
   3.804860585609776*^9, 3.804868191649867*^9, 3.8048710413893967`*^9, 
   3.804884628021082*^9, 3.804963245827729*^9, 3.804966592681923*^9, 
   3.804967281423114*^9, 3.804970986804801*^9, 3.8050320611919613`*^9, 
   3.805049853759512*^9, 3.805145168459126*^9, 3.805145657301837*^9, 
   3.8051458550109653`*^9, 3.8051460475407963`*^9, 3.805201930097183*^9, 
   3.805232576437202*^9, 3.805232767983384*^9, 3.8053176496437597`*^9, 
   3.8053184763277082`*^9, 3.8053185592634983`*^9, 3.805319449034782*^9, 
   3.8053195585811663`*^9, 3.805402867116848*^9, 3.8054034038916597`*^9, 
   3.805491730255508*^9, 3.805578707529037*^9, 3.805639030713563*^9, 
   3.805725939648695*^9, 3.805726030443774*^9, 3.8057358635649557`*^9, 
   3.805750045443306*^9, 3.805750094975101*^9, 3.805750371933401*^9, 
   3.805808345492309*^9, 3.805811136538938*^9, 3.805838878001412*^9, 
   3.805920954089954*^9, {3.806072150785507*^9, 3.806072177406492*^9}, 
   3.806072608229382*^9, 3.806072817623959*^9, 3.806175568823497*^9, 
   3.806183940352922*^9, 3.806184004492223*^9, 3.806353311578017*^9, 
   3.8063536900120363`*^9, 3.806441726202188*^9, 3.806441850538951*^9, 
   3.806442138063181*^9, 3.806699635849142*^9, 3.806699768979115*^9, 
   3.806701295615624*^9, 3.806701399818387*^9, 3.806772441135854*^9, 
   3.8068720481104803`*^9, 3.8068721626197433`*^9, 3.807006749100169*^9, 
   3.80700690778263*^9, 3.807131377440136*^9, 3.807389426215761*^9, 
   3.80738963053725*^9, 3.807562306383219*^9, 3.807651535093359*^9, 
   3.8077387405602093`*^9, 3.8077389579965982`*^9, 3.807903010062602*^9, 
   3.8080829379218807`*^9, 3.8082223343847723`*^9, 3.808223955173547*^9, 
   3.8084293411193647`*^9, 3.808602225780779*^9, 3.8086515008337297`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"900e915a-7805-410e-926c-36d05bf0b8b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "DatosAcumulados", ",", "DatosRecuperados", ",", "DatosFallecidos"}], 
    "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.79996275064209*^9, 3.799962789438053*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"2676e3e7-9faa-497f-8a4c-655c60bec2d7"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJx11n9MVXUcxvHTVfIqhLdCREO7Xm7OtVa3FCLLPJgVohFhKV6hTpL2wz9k
qzlarH0rV8Qfho4M3FxnlXZzbTEr51rqiTW6LZr0QytzdDKbpWQ3tUKDfp3n
3R/eLTf3+NpznvO58xdMW7GmdmXIsqy9//z8N/UjM5df2OdmOCsjWVmQlUX/
k8VZGc1yLMvxLE/P2s0gL8/KmeQV5GzySqW5GSeUdg2+mlxKXkP/n3mvacCz
8H24VOk8iMvwGnyt0nsYlysza/F1yppHz/3caYOvV1Y+iW9QPvA0nsPnacM3
KsPP4bm8bwO2lcMb2eHW5+krlJ0v0GNnM/08nt9Cj/e49Dcp81+mxz1b6ecr
D6bo8eHt9Pw5Te2mx49h6xZl6Q56vOlN+luVE9+mx1/spK9Udu2ix1+/Q79A
uWA3vWxiHn2VMvYevWzW99AvVHa+Ty+bXb30i5TxD+nx2I/ob9Pz2/voZau+
n746SHv6p/Sy1Yut24P07M/pZWvjfnr9vfeOH5D5d2DXfsnz+KGvZE82wwfZ
36EcPMReNukB9niJz172Jn3LvjZI/11sy2bnYfay/eJ37GWn7wj7xcqR79nj
nKPsZSf8A3s5WvYj+zv1/mePsccvHWcv+xN+Yo+fOcH+LmVBhr3sedjIkfpf
2PP8rJPslwTZlHeKvWy+wUZOvHaaPX3Dr+z1/5KJ/cZe7t6Hjez3/M6e5/cO
sa9TfnyGveweOsteTuz+g72c2TTMflmQTu0Ie7m/7k/2stX2F3u5O2lVaJ/U
5xvBthxZfZ5s5NQg9mRvaYj98sDNR7Ettz4xir2cuGw0ezm1D1v1uteYw14O
jzufPX0X9uT2hjHs9XWgeUyYvVzei/k6YTeNZS9HzmLr7sBu8zj2cuvP2MiV
Xbns5f6qPPb36P6UC9jLRRls5BnpfPaySY5n7wTuPoWjsrs8wvvkwTR25Ndn
X8j75bpt2JXbcy7inty5EPtyXwe27g08FLqY+3JeI7bl+AfYkVvLC7gvr3sD
u7IJTeC+XLMY+3LLHmyt0PuKC7kvOy625bcKJ3JfThhs5P792JXXlRRxX453
YF8efQJbjfr9WDWJ+/LpY9iW55vJ3JdbP8FG7ii8hPvyK2uxJ7cfwD77OcXc
1/ctLdtwVB7KncJ9ua4GO3LiVcz3PanxU7lPvxp7cv0A9uV42aXcXxm4sgtH
5fQAtuWq3Cj35eoybOT1jdiVWzqxJ/f1Yl9uOoOtVbpfNI378smZ2JaTSezI
5ils5I4d2JULfOzJXn6M+3LoKmzdHziyCEfl1OPYlidvxY7c8hk28pFRJdyX
55ViT65ehn257ZGSir8BL+a5Xg==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd0WtoT2EcB/AHmWFjGGbz4rittf7p7zIzhmdmM8bs4jL3g42Vskte/Imc
oojEe7OO9gI1WiSXyKM0S/LKraROLhmGYbGRuZzv97w4v1OnX59+53u+z+lM
2FpbXt1fKXX73/1/4upaoMKXDjNeOEk4WThFeLywJTxReLJwOh2cM0M4Uzgi
PJUOviMqPI0z+K7pwjOEZwpnCc8SzsZ08ujZwjn0QnqO8FzhXHoRPU94Pl1M
L+BczqkxWw/zOWGVJ/bCaqHYC6t8zJZT3AsrnjPhdPjcgVUB39fEfYHYF4p8
Yfh5tVjk6UdnuC/CTG/mXlgtEXthtRTz7WXu6Yor3BeHHfyHKde5X4aZeIt7
4eA/lRnuaXOH+5KwHfpVG/cr/OlE2rmn8+9zXxq2FnaEjbAqE3lYZz1mHlal
tKFPPGG+PGwt7MDO66fMw+bhc+Yr4JsvmBd2YKvQY15YrfSnm/OSedj5RTvC
Rlit8qf36Q3zsMp4yzysN3QwD9sH3jG/Gvnj75mHzdkPzMM67SPzwmoNnq/5
zDwc3dvFPKwzvzAP172iVSW+Z+dX5oUduuMb83C0sZv5tWFrYQfWZd+Zh9WX
H8yvw3me9TAv7MBe1U/mhdX6sDXcOuk383BdYh/zsB7zh/kN/jw5QOUhD8cO
0g7cmtoPNrBuptXGsLWwI2zgjLb+zG8KW8MqLuiHa/bQBo69pNVm3/E1QT+c
0RP0CxvY7Qv6bd9F+wfAFtzVS2thG47GDeT7mW+iXdgdFcc+2DtOe/Ds5EHs
3+LbXKAtYQ3rJ/Hsh936wewXduHY0SHs5z5tKPvhjhu02hq2BR95nMB+YRu2
3ET2w6WRYeyHiyqHs5/597QHR0qS2L/Nd2cjbQlrYRtuPz+C/cIu3D10JPvh
WAXtCasq3+esUeyHrzXQGj50kbaFHViVJrMf7jxGGzjhGe3Bj1JGs7/ad7SB
tuDdLbSGH3yibbglMob98N1dtCts4Kpe2mNfzlj2b8f5d9EWnGRoDc/so224
MjuF/fC+etqFOy/RBm7soT345NRx7N/h+0gtbcHdV2kNx7poG87NT2U/3HKY
dvm+e7SB6/poD+7MT8v7CyjBt3c=
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[
     0.0055000000000000005`], AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1ntolXUcx/GfRRJUcgzByhGPQ6S8MS0tzcvPW5rX45xlafrothSCUgtB
meMnmKiEDLoQWPlYhDFFnE5F0/x5G7YMb7NVW/lMU3Ne2j9C/3TRPu/nj/Mb
jC+v8/l9nu85DzvnrOfCt0sr7zPGHL77e2/qp2OUKfyxhXwwcC5wt8CPBS4K
HAUuDtwrcO/ATwXuE7hf4AGBSwIPDDwo8DM4u0/PBh6cnWcOCfwcM7uPzzOz
+ziUmd23Yczsvr3AzO7bcGZ2H0Yws9c10hY+z1HBOVtoh90YHh/NfInHM09j
cs7PLOy5V8jHatr5PI6TBeTj6FeSY7uYfLxmbik5LsHmRR5fxsT+XfIJmvEK
cpyrIp9IXk2Oc6vJed35NeR4yXvkk3i+a8nxyQ3kk+lvJMf1NeRTNLt9QI4r
PiSfqln0ETle8wn5tEI7XLaJfLrmw5+R4zOfk+c1n0h4HbgJO/ztFk2PP/6S
/gzN6Cv6uHgrfXz0a/p4UC39Us1Ht9HH7djh7Tvo46qd9Pm7W1VHH2/eRR/v
2U0fD62nX8brxRYX76WPG/fRx2/tpz9Lc+o39PFDB+njS9jjs4fov6zZcJi+
7Bo9ffLaI/TJy4/S1/vMPX6MPu+7Ssz70LVgjxuO058tX2ugj91J+rLZ/x19
/Bc2r+r8kUb6eNn39PGnp+jjf36g/5rmiNP0ce4MfbwSe9kewmaOZt+z9GXX
hh35F+foy37iefpzdb4dW9lObqKP8xfoy6bLj/RfV96ErexONNOXzYqf6Mu+
38/056l/DFvZdP6FPnkV9vjJFvr6XHXNmM9Zu7qVvux7/Uqf81uxiZXfwBEu
/43ryW7sRTnG96dcn/PzcCKnddjL9g5OOd+9jf36HojLcCSnB7GV7QOX2C/7
2djhepx9r/yNPS6+zH45mYDNQs0DOJJ90e/sl91yHMvJOew43/8K+7leGfbk
1TjletexKf9/Rr2vsl82y7HFp3CMB1xjv2zzOJHdUuzlpBWnnB/3B/srlNfi
SE4fuc5+2VfgWLbrsZPjNpzI0ax29nO+Dqfs+xcbfe+7KTfYL6ebsJWTvTgm
b8ZO9oNvsl+ONmL+r7CtOMU9brH/DfXfxJFs1mEr20632S+76diR1+AEX8Be
jp/+k/3sm4nNIvkdHMlRC7ay69rBfrlmIHZySSlO5Lga+8CpnH+/w/4HFK7I
AQ==
      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 191.}, {0, 637509.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.799962761095755*^9, 3.799962790683177*^9}, 
   3.800047733926557*^9, 3.800137734463204*^9, 3.800221426932186*^9, 
   3.8003190712536163`*^9, {3.800395765430863*^9, 3.800395776893435*^9}, 
   3.800480899868677*^9, 3.800565414872044*^9, 3.800725772413075*^9, 
   3.800737891644829*^9, 3.800737981987833*^9, 3.8007380503517027`*^9, 
   3.800826784903469*^9, 3.800827678861413*^9, 3.8009108649798326`*^9, 
   3.8009129417380466`*^9, 3.800913181210002*^9, 3.800997332410043*^9, 
   3.8010847622062607`*^9, 3.801085208247398*^9, 3.801171257355694*^9, 
   3.801258070535266*^9, 3.801345435060081*^9, 3.801346292383985*^9, 
   3.8014790325613823`*^9, 3.801517165322212*^9, 3.8016006254889297`*^9, 
   3.801612550558443*^9, 3.8016126733936243`*^9, 3.8016127883693953`*^9, 
   3.801774340353359*^9, 3.801861230163714*^9, 3.801995996545917*^9, 
   3.802033605444866*^9, 3.8021214111917467`*^9, 3.802295591822381*^9, 
   3.8023821360537157`*^9, 3.8023822018924103`*^9, 3.802471160697667*^9, 
   3.802625871088456*^9, 3.802725392117584*^9, 3.802725558219418*^9, 
   3.802725660749052*^9, 3.8028111145277367`*^9, 3.802811566290732*^9, 
   3.802897381987417*^9, 3.8029855955429792`*^9, 3.802986709611368*^9, 
   3.80298688448451*^9, 3.802987550822791*^9, 3.803074266282851*^9, 
   3.803158115064251*^9, 3.8033000428362427`*^9, 3.803415948355076*^9, 
   3.803416129602829*^9, 3.8034162654438562`*^9, 3.803417669811595*^9, 
   3.803418910881082*^9, 3.803419663535458*^9, 3.803499543823269*^9, 
   3.803501390805814*^9, 3.803501440438409*^9, 3.803502207245895*^9, 
   3.803503456114087*^9, 3.80356536159685*^9, 3.8035654178441687`*^9, 
   3.803566324664916*^9, 3.8035677095537863`*^9, 3.80356775811449*^9, 
   3.803571457947487*^9, 3.8035715160917807`*^9, 3.803571594603232*^9, 
   3.80359151316442*^9, 3.803664643011448*^9, 3.803665406491115*^9, 
   3.803665548448697*^9, 3.803666475500938*^9, 3.803667552828755*^9, 
   3.8037357199405527`*^9, 3.803735975998561*^9, 3.803736435548476*^9, 
   3.8037365145541267`*^9, 3.803736626542612*^9, 3.8037368038765163`*^9, 
   3.803740896667327*^9, 3.8037631281686287`*^9, 3.803763247738508*^9, 
   3.803763310555505*^9, 3.803764150148823*^9, 3.803764720546726*^9, 
   3.803769061544318*^9, 3.803769101468478*^9, 3.80376935159764*^9, 
   3.803847901627495*^9, 3.803848056629027*^9, 3.803848108706443*^9, 
   3.8038482029094133`*^9, 3.803937141932456*^9, 3.803937302105976*^9, 
   3.8040265955610247`*^9, 3.804108470841321*^9, 3.804108558602949*^9, 
   3.804109880754476*^9, 3.804193691212801*^9, 3.804193779014326*^9, 
   3.8043681010446587`*^9, 3.804452582345368*^9, 3.804452796860358*^9, 
   3.8044529630695763`*^9, 3.804453069331355*^9, 3.804453204572338*^9, 
   3.8045444361744757`*^9, 3.804715160876652*^9, 3.80471523282662*^9, 
   3.804717496630433*^9, 3.80480022702747*^9, 3.8048538466772413`*^9, 
   3.804860585701194*^9, 3.804868191782384*^9, 3.804871041532086*^9, 
   3.804884628222911*^9, 3.8049632459178877`*^9, 3.8049665927540617`*^9, 
   3.804967281521915*^9, 3.804970986988742*^9, 3.805032061344564*^9, 
   3.805049854262261*^9, 3.805145168625086*^9, 3.805145657533132*^9, 
   3.805145856121215*^9, 3.805146047643916*^9, 3.8052019302866573`*^9, 
   3.805232576682206*^9, 3.8052327680676537`*^9, 3.805317656328594*^9, 
   3.80531847651197*^9, 3.805318560028468*^9, 3.8053194491570263`*^9, 
   3.8053195588830214`*^9, 3.805402867307431*^9, 3.8054034039666023`*^9, 
   3.8054917304268417`*^9, 3.805578707717329*^9, 3.805639030812952*^9, 
   3.8057259397299623`*^9, 3.805726030537492*^9, 3.8057358637076473`*^9, 
   3.805750045749589*^9, 3.805750095261485*^9, 3.805750372227957*^9, 
   3.805808345596613*^9, 3.805811136693325*^9, 3.805838878067099*^9, 
   3.8059209548271227`*^9, {3.80607215092269*^9, 3.8060721775953903`*^9}, 
   3.806072608446765*^9, 3.806072817730886*^9, 3.806175569545092*^9, 
   3.806183940562956*^9, 3.806184004592554*^9, 3.806353316034823*^9, 
   3.8063536902748528`*^9, 3.806441726402944*^9, 3.806441850632413*^9, 
   3.8064421381567163`*^9, 3.806699636043706*^9, 3.806699769069399*^9, 
   3.80670129569919*^9, 3.806701399997642*^9, 3.806772441228116*^9, 
   3.806872048265312*^9, 3.8068721628169603`*^9, 3.807006749394857*^9, 
   3.807006907890415*^9, 3.8071313777076817`*^9, 3.8073894264473133`*^9, 
   3.8073896306083107`*^9, 3.807562306625595*^9, 3.80765153530754*^9, 
   3.807738740839007*^9, 3.8077389580905237`*^9, 3.8079030102402277`*^9, 
   3.808082938204729*^9, 3.80822233453487*^9, 3.808223955380827*^9, 
   3.808429341380048*^9, 3.808602226083865*^9, 3.808651500936561*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"af0b69f4-2806-4a29-accb-a185e9ffc3b5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculation of the number of cases per day 
(c\[AAcute]lculo de casos por d\[IAcute]a, resta)\
\>", "Section",
 CellChangeTimes->{{3.797514311906958*^9, 3.7975143261459312`*^9}, {
  3.800395779386647*^9, 3.8003957803750134`*^9}, {3.8058111254840527`*^9, 
  3.8058111265590343`*^9}, {3.808650928083109*^9, 
  3.8086509608752117`*^9}},ExpressionUUID->"70c6b726-2f7c-40e2-851f-\
b645632c193b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DIAS", "=", 
   RowBox[{"DatosAcumulados", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.797450913485744*^9, 3.797450924248348*^9}, {
  3.797451208831294*^9, 3.797451210515486*^9}, {3.7974512418345013`*^9, 
  3.797451250955474*^9}, {3.797451309185382*^9, 3.797451310249241*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"dfb81509-871a-4f25-b50b-315b66bb8f72"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CASOS", "=", 
   RowBox[{"DatosAcumulados", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.797451312411251*^9, 3.797451353266633*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"35fadb83-82ea-4d84-8f46-74861971ae6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CASOSporDIAresta", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"DIAS", "[", 
       RowBox[{"[", 
        RowBox[{"i", "+", "1"}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"CASOS", "[", 
        RowBox[{"[", 
         RowBox[{"i", "+", "1"}], "]"}], "]"}], "-", 
       RowBox[{"CASOS", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"DIAMX", "-", "1"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.797451288702804*^9, {3.797451340765141*^9, 3.797451371654481*^9}, {
   3.797451404637993*^9, 3.797451421233851*^9}, {3.797512196679906*^9, 
   3.797512200445767*^9}, {3.797514295948998*^9, 3.797514302140386*^9}, {
   3.797676987963908*^9, 3.797676988225606*^9}, {3.797720202771431*^9, 
   3.797720203026431*^9}, {3.7978037400505447`*^9, 3.797803740517174*^9}, {
   3.797803817299664*^9, 3.797803824117277*^9}, {3.797889163269758*^9, 
   3.797889164179007*^9}, {3.798134557468151*^9, 3.798134557609429*^9}, {
   3.798317628638575*^9, 3.798317629407218*^9}, {3.7983179700931377`*^9, 
   3.798317970208872*^9}, {3.798492849355235*^9, 3.798492923335156*^9}, {
   3.798492959021213*^9, 3.798492972090921*^9}, {3.798578934346529*^9, 
   3.798578935046528*^9}, {3.798754130962173*^9, 3.798754131485037*^9}, {
   3.798925293693055*^9, 3.798925293829914*^9}, {3.799012758567169*^9, 
   3.7990127592891083`*^9}, {3.799270437320078*^9, 3.799270437524012*^9}, {
   3.7994120364274883`*^9, 3.799412036743784*^9}, {3.7994427256707172`*^9, 
   3.799442730463867*^9}, {3.799530001305894*^9, 3.799530001544937*^9}, {
   3.799530142986821*^9, 3.799530143191745*^9}, {3.7996147659552526`*^9, 
   3.79961476626271*^9}, {3.799704558806356*^9, 3.799704559181013*^9}, {
   3.799789543035782*^9, 3.7997895435744143`*^9}, {3.7998763223344193`*^9, 
   3.799876323173061*^9}, {3.7999624432629757`*^9, 3.799962443420805*^9}, {
   3.800047716434002*^9, 3.800047716632662*^9}, {3.800137722050597*^9, 
   3.800137722182329*^9}, {3.800221417306625*^9, 3.8002214180643463`*^9}, {
   3.800319037117984*^9, 3.800319059027644*^9}, 3.800395754789013*^9, {
   3.800480886399291*^9, 3.800480886876892*^9}, {3.800565421098528*^9, 
   3.800565421802433*^9}, {3.800725779068988*^9, 3.800725779405266*^9}, {
   3.800737898249502*^9, 3.800737898931261*^9}, {3.800826795105421*^9, 
   3.800826795701502*^9}, {3.800910852307098*^9, 3.800910854093943*^9}, {
   3.800913142659171*^9, 3.800913143543132*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"3f942296-60db-4a83-8f38-ec8a92246f54"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"15", ",", "17"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "27"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "46"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "39"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"22", ",", "48"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "65"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"24", ",", "51"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"25", ",", "38"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"26", ",", "132"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"27", ",", "48"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"28", ",", "132"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "131"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", "145"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "145"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"32", ",", "77"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"33", ",", "163"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"34", ",", "132"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"35", ",", "178"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"36", ",", "202"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "253"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"38", ",", "296"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"39", ",", "346"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "396"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "260"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"42", ",", "685"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"43", ",", "93"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"44", ",", "442"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"45", ",", "353"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"46", ",", "385"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"47", ",", "448"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"48", ",", "450"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"49", ",", "578"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50", ",", "622"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51", ",", "764"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"52", ",", "511"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"53", ",", "729"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"54", ",", "1043"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"55", ",", "1089"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"56", ",", "1239"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"57", ",", "970"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"58", ",", "835"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"59", ",", "2075"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"60", ",", "1833"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"61", ",", "639"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"62", ",", "1515"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"63", ",", "1349"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "1383"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"65", ",", "1434"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"66", ",", "1120"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67", ",", "1609"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"68", ",", "1982"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"69", ",", "1906"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"70", ",", "1938"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"71", ",", "1562"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"72", ",", "1305"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"73", ",", "1997"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"74", ",", "1862"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"75", ",", "2409"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"76", ",", "2437"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"77", ",", "2112"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"78", ",", "2075"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"79", ",", "2414"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"80", ",", "2713"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"81", ",", "2248"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"82", ",", "2973"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"83", ",", "2960"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"84", ",", "3329"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85", ",", "2764"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"86", ",", "2485"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"87", ",", "3455"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"88", ",", "3463"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"89", ",", "3377"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"90", ",", "3227"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91", ",", "2885"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"92", ",", "3152"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"93", ",", "2771"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"94", ",", "3891"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"95", ",", "4042"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"96", ",", "4312"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "4346"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"98", ",", "3593"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"99", ",", "3484"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "2999"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"101", ",", "4199"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"102", ",", "4883"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"103", ",", "4790"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"104", ",", "5222"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"105", ",", "3494"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"106", ",", "4147"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"107", ",", "3427"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"108", ",", "4599"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"109", ",", "4930"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"110", ",", "5237"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"111", ",", "5455"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"112", ",", "4717"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"113", ",", "5343"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"114", ",", "4577"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"115", ",", "6288"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"116", ",", "5437"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"117", ",", "6104"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"118", ",", "5441"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"119", ",", "4410"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"120", ",", "4050"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"121", ",", "3805"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"122", ",", "5432"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", "5681"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"124", ",", "6741"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125", ",", "6740"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"126", ",", "6914"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"127", ",", "4683"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"128", ",", "4902"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"129", ",", "6258"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"130", ",", "6995"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"131", ",", "7280"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"132", ",", "6891"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"133", ",", "6094"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"134", ",", "4482"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"135", ",", "4685"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"136", ",", "7051"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"137", ",", "6149"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"138", ",", "6406"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"139", ",", "7257"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"140", ",", "7615"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"141", ",", "5311"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"142", ",", "5172"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"143", ",", "6859"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"144", ",", "6019"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"145", ",", "8438"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"146", ",", "7573"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"147", ",", "6751"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148", ",", "5480"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"149", ",", "4973"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"150", ",", "7208"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"151", ",", "5752"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"152", ",", "7730"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"153", ",", "8458"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"154", ",", "9556"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"155", ",", "5201"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"156", ",", "4419"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"157", ",", "6148"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"158", ",", "6139"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"159", ",", "6590"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"160", ",", "6717"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"161", ",", "6495"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"162", ",", "4376"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"163", ",", "5558"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"164", ",", "6686"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"165", ",", "5858"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"166", ",", "7371"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"167", ",", "5618"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"168", ",", "6345"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"169", ",", "4448"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"170", ",", "3571"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"171", ",", "5506"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"172", ",", "5792"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"173", ",", "6775"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"174", ",", "5928"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"175", ",", "6482"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"176", ",", "3948"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"177", ",", "3541"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"178", ",", "4916"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"179", ",", "5267"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"180", ",", "6026"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"181", ",", "5824"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"182", ",", "5974"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"183", ",", "4129"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"184", ",", "3719"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"185", ",", "6476"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"186", ",", "4921"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"187", ",", "5937"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"188", ",", "6196"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"189", ",", "6319"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"190", ",", "4614"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191", ",", "3486"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.797451372161501*^9, {3.797451406177332*^9, 3.797451421567336*^9}, 
   3.797452110866633*^9, 3.797513274777845*^9, 3.797513879231029*^9, 
   3.797514202793599*^9, 3.797514309038679*^9, 3.7975143584382353`*^9, 
   3.797515458374763*^9, 3.797515624744924*^9, 3.797529310713225*^9, 
   3.7976770067892323`*^9, 3.797677179002878*^9, 3.7977199905646667`*^9, 
   3.7977201432381887`*^9, {3.797720195647901*^9, 3.797720206836047*^9}, {
   3.7977726865297337`*^9, 3.797772703024228*^9}, 3.797802808603056*^9, {
   3.79780371429284*^9, 3.797803743714569*^9}, {3.797803818424284*^9, 
   3.7978038356866007`*^9}, {3.797889174933187*^9, 3.797889193972155*^9}, 
   3.797890888861732*^9, 3.797930604135*^9, 3.797937400857542*^9, 
   3.7979616545848*^9, 3.7979764532232933`*^9, 3.7979792955960283`*^9, 
   3.798027476286497*^9, 3.7980470706571913`*^9, 3.798049684024061*^9, 
   3.798056818057089*^9, {3.7981345255513287`*^9, 3.79813453585581*^9}, {
   3.79813457411548*^9, 3.798134578743639*^9}, 3.7983176462125874`*^9, 
   3.798317980633952*^9, 3.798492795031761*^9, {3.798492862822063*^9, 
   3.798492972485635*^9}, 3.798578950181349*^9, 3.798579034557742*^9, 
   3.798579123413722*^9, 3.7985792105382023`*^9, 3.798754144480549*^9, 
   3.798754469580131*^9, 3.79882776493293*^9, 3.7989253311352777`*^9, 
   3.798925761740828*^9, {3.7990127714872637`*^9, 3.799012796686328*^9}, 
   3.7990130767909403`*^9, 3.7992704506380787`*^9, 3.799272130993168*^9, 
   3.799412047740649*^9, 3.799442749108489*^9, 3.799530016246236*^9, 
   3.799530144636697*^9, 3.799614725481303*^9, 3.799614776259534*^9, 
   3.79970458670199*^9, 3.799789560458825*^9, 3.799876337109104*^9, 
   3.799876442332108*^9, {3.799962427589941*^9, 3.799962448957438*^9}, 
   3.800047734004344*^9, 3.8001377346000967`*^9, 3.800221427103684*^9, 
   3.800319071303215*^9, {3.800395765569471*^9, 3.800395784099638*^9}, 
   3.800480900040662*^9, 3.800565428581506*^9, 3.800725782849135*^9, 
   3.800737903628229*^9, 3.800737982415361*^9, 3.800738050409898*^9, 
   3.800826796700831*^9, 3.800827678912442*^9, 3.8009108650979967`*^9, 
   3.800912941898485*^9, 3.800913181325042*^9, 3.800997332543577*^9, 
   3.801084762349738*^9, 3.801085208320107*^9, 3.801171257460579*^9, 
   3.801258070596233*^9, 3.801345435113887*^9, 3.801346292634963*^9, 
   3.8014790326251183`*^9, 3.8015171663157377`*^9, 3.8016006256299458`*^9, 
   3.801612550661708*^9, 3.801612673490748*^9, 3.801612789353332*^9, 
   3.801774340500618*^9, 3.801861230265995*^9, 3.801995996629944*^9, 
   3.802033605503827*^9, 3.802121411244186*^9, 3.802295591889616*^9, 
   3.80238213741047*^9, 3.802382201955002*^9, 3.802471160788332*^9, 
   3.802625871190628*^9, 3.802725392172937*^9, 3.80272555828059*^9, 
   3.802725660801875*^9, 3.802811114633271*^9, 3.8028115664280863`*^9, 
   3.802897382071643*^9, 3.802985595622937*^9, 3.8029867097058573`*^9, 
   3.802986884579804*^9, 3.802987550939281*^9, 3.803074266360621*^9, 
   3.803158115150063*^9, 3.803300042970189*^9, 3.803415948449008*^9, 
   3.803416129686904*^9, 3.803416265554472*^9, 3.803417669911673*^9, 
   3.803418910997473*^9, 3.803419663653779*^9, 3.803499543917818*^9, 
   3.803501390849895*^9, 3.8035014404916897`*^9, 3.8035022072951603`*^9, 
   3.8035034561496143`*^9, 3.8035653617390747`*^9, 3.8035654179938927`*^9, 
   3.8035663247389708`*^9, 3.803567709610673*^9, 3.80356775816232*^9, 
   3.803571458004499*^9, 3.803571516146612*^9, 3.8035715946811037`*^9, 
   3.803591513327338*^9, 3.803664643137409*^9, 3.803665406603118*^9, 
   3.8036655485646477`*^9, 3.803666475577209*^9, 3.8036675528741617`*^9, 
   3.803735719987454*^9, 3.803735976052526*^9, 3.803736435585779*^9, 
   3.8037365146073513`*^9, 3.803736626607666*^9, 3.803736803913745*^9, 
   3.8037408967437057`*^9, 3.8037631282201757`*^9, 3.803763247792692*^9, 
   3.803763310631716*^9, 3.803764150194412*^9, 3.80376472058008*^9, 
   3.803769061620327*^9, 3.803769101502039*^9, 3.80376935220534*^9, 
   3.803847901733287*^9, 3.803848056869206*^9, 3.8038481087573977`*^9, 
   3.8038482029810534`*^9, 3.803937142079767*^9, 3.803937302149667*^9, 
   3.804026595722609*^9, 3.804108471026888*^9, 3.804108558652274*^9, 
   3.804109880886553*^9, 3.804193691418703*^9, 3.804193779314198*^9, 
   3.8043681012372847`*^9, 3.80445258252811*^9, 3.804452796918768*^9, 
   3.804452963105011*^9, 3.804453069377442*^9, 3.8044532046236067`*^9, 
   3.804544436551154*^9, 3.804715161089116*^9, 3.804715232863154*^9, 
   3.804717496818017*^9, 3.804800227233994*^9, 3.804853846971464*^9, 
   3.8048605857440157`*^9, 3.80486819184169*^9, 3.80487104159354*^9, 
   3.804884628439253*^9, 3.804963245993376*^9, 3.804966592811583*^9, 
   3.804967281566312*^9, 3.804970987156537*^9, 3.805032061446393*^9, 
   3.805049854565054*^9, 3.805145168683749*^9, 3.80514565772243*^9, 
   3.805145856338359*^9, 3.805146047696746*^9, 3.805201930340824*^9, 
   3.8052325768580627`*^9, 3.805232768108358*^9, 3.805317656904314*^9, 
   3.805318476611553*^9, 3.8053185600993977`*^9, 3.8053194492209167`*^9, 
   3.8053195589446*^9, 3.80540286749123*^9, 3.805403404039815*^9, 
   3.805491730622485*^9, 3.805578707928502*^9, 3.805639030871168*^9, 
   3.805725939772914*^9, 3.805726030591017*^9, 3.8057358637674627`*^9, 
   3.805750046076989*^9, 3.805750095589842*^9, 3.805750372539879*^9, 
   3.80580834565009*^9, 3.805811136887372*^9, 3.8058388781232147`*^9, 
   3.805920954871961*^9, {3.806072151309569*^9, 3.806072177666915*^9}, 
   3.80607260865578*^9, 3.8060728177901363`*^9, 3.8061755696124077`*^9, 
   3.8061839406848087`*^9, 3.8061840046392813`*^9, 3.806353316284329*^9, 
   3.806353690547284*^9, 3.8064417266102037`*^9, 3.806441850684132*^9, 
   3.806442138209269*^9, 3.8066996362026787`*^9, 3.8066997691107073`*^9, 
   3.806701295742464*^9, 3.80670140018991*^9, 3.8067724412616577`*^9, 
   3.80687204842625*^9, 3.806872162879342*^9, 3.807006749583517*^9, 
   3.807006907958165*^9, 3.807131377765271*^9, 3.807389426504505*^9, 
   3.807389630682764*^9, 3.807562306688936*^9, 3.80765153547079*^9, 
   3.80773874102564*^9, 3.807738958142726*^9, 3.807903010428814*^9, 
   3.808082938573317*^9, 3.808222334610038*^9, 3.8082239555236998`*^9, 
   3.808429341449456*^9, 3.808602226226791*^9, 3.808651501055234*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"76723a12-7957-4651-8de2-e16837db70cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "CASOSporDIAresta", "]"}]], "Input",
 CellChangeTimes->{{3.797451381437378*^9, 3.797451387507697*^9}, {
  3.797512202705934*^9, 3.797512204237186*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"82cfe86c-aee8-4a5b-84a9-dfeb26325a36"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1k2IVXUYx/HDYBItZCgXs4i4hsgQEc14m8bJyaP2Yjmmjm9Z1twmX6bA
HARLMOgwYsEEMaGWgdWtzGq07HUqq+nQIgyhRatZBN1atGkjbYqCqPh/nsU9
F4Yf3/md3/P8/8//nHPvotF9w7s6siyb/e/vf/XJk1xakfTyCndWeGGFu/Ks
7XN1xa9V/GsrvLjCSyr57ry973V5e9/r8/a+N9AeeiPtq/z/Ftpb6bcUL6N1
eie9KWmxulJ3Db05ab4B97v+rkrdyA/wG5V1Rb3lFX8waSP41qS1Ubyiwrn1
bFIHN3byV7bXL3C+m78KP8LHzX3t+yj2U9w8wL8taXmQj/Nx/u1Jx47wcb6N
f4d6h/i483G+c+mM+nFOT1JzrOECd07wncv4YT5uPcO/O+mlp/j4wtP8tUmH
pvh43vP8oaQ7jvLxhuf465J2TfJxX5N/T9JTJ/n4T+vN1ic9+yIfLzzOdx+e
xHFfjr3gelxYb4kXvyS/Ub9X5PGFl+XwGn6Jx07IDyfdeUwe11+Vx13qlfiH
1+Xdt1e8IR/3sfkUOOZV4h8jvzlp75vyeOo1eTzwljyu4WxL0o5peXxCvQI/
an0l/sf12dakC87I41F+gfvekceTp+U9B8235fHp6I93vyePj52Tvzfp3Pvy
+C9c4CvPyuN+6822J33MPHK8J/L4qo/k8cyH8vdZ38fyeEj9Ai9Vr8Tfxvzu
T/rHB/J4lX4FPqB+idd/Ir8j6V7ryfFPri/wz+qXeOoz+QeSDqqX47lP5fFK
fokH1MseTHrKeeT4/LvyuD/yuGdGfiTplvPyeDMucMcX8nhtzN97fYl51fB+
+8vxJvn4Xhn/Un38m35N/L39l3jCflt4XfR/KOmz6tfwZdEfz/9cf7w9+uOv
v9I/OM4b13ELX7TebDTpYeuN78VDpf74uPoNPBLzxWPOp4n3xv2Ou623hQ/G
+T2ctHdWf3wk+uPpb/THG+P+xKvNt4nnmV+J/7a/Fp41z8z3/KD91PAIP8dd
6sfvghn7LfA1cf74F/sr8cXYP/49nr9dSb+z3hpuxPOMf/U+aOCJ6I+b+jXx
E9ZT4u7YPx6O/fsdM+f9WMPT8T7GdefZwEdj/nhS/SYuY/94a/THi7zPsj1J
F3jea3go5o+XRX/cE+8XXDe/Jj4X54/ne95aePmZ/F+de5Tn
      
      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 191.}, {0, 9556.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.797451388695817*^9, 3.797451424696124*^9}, 
   3.797452110953579*^9, 3.79751327766401*^9, 3.797513879423408*^9, 
   3.797514203451432*^9, 3.797514358592225*^9, 3.797515460167506*^9, 
   3.797515624896851*^9, 3.7975293108303957`*^9, 3.797677006959908*^9, 
   3.797677180084157*^9, 3.7977199908236513`*^9, 3.797720143507676*^9, {
   3.797720195858905*^9, 3.797720209258897*^9}, {3.797772686656847*^9, 
   3.797772703146223*^9}, 3.7978028090006037`*^9, {3.797803714949518*^9, 
   3.797803743880624*^9}, {3.797803829812379*^9, 3.7978038358050613`*^9}, {
   3.797889175114805*^9, 3.7978891941059103`*^9}, 3.7978908894487953`*^9, 
   3.797930604206271*^9, 3.7979374009880133`*^9, 3.7979616546636763`*^9, 
   3.7979764533416147`*^9, 3.797979295720023*^9, 3.7980274765187597`*^9, 
   3.798047070769938*^9, 3.798049684150383*^9, 3.798056818152945*^9, {
   3.7981345256841583`*^9, 3.798134536015601*^9}, {3.798134574272257*^9, 
   3.798134578921741*^9}, 3.798317646415751*^9, 3.798317980768014*^9, 
   3.798492795243294*^9, {3.7984928632351227`*^9, 3.7984928902390003`*^9}, {
   3.798492935733715*^9, 3.7984929820384417`*^9}, 3.7985789503153877`*^9, 
   3.798579034704938*^9, 3.798579123837858*^9, 3.798579210662376*^9, 
   3.798754144611012*^9, 3.798754469732595*^9, 3.798827765659789*^9, 
   3.7989253312355833`*^9, 3.7989257619562883`*^9, {3.799012771607325*^9, 
   3.799012796803555*^9}, 3.799013076924343*^9, 3.799270450777796*^9, 
   3.7992721311385403`*^9, 3.799412047875222*^9, 3.799442749728717*^9, 
   3.799530016368329*^9, 3.799614725629582*^9, 3.799614776398144*^9, 
   3.799704586882744*^9, 3.799789560588252*^9, 3.799876337248177*^9, 
   3.799876442444627*^9, {3.799962427748002*^9, 3.799962449132353*^9}, 
   3.800047734167596*^9, 3.800137734729473*^9, 3.800221427219763*^9, 
   3.80031907147507*^9, {3.800395765686378*^9, 3.800395784223661*^9}, 
   3.800480900199107*^9, 3.8005654331920424`*^9, 3.8007257869005623`*^9, 
   3.800737908910132*^9, 3.8007379826014967`*^9, 3.80073805056747*^9, 
   3.800826804785541*^9, 3.8008276790345573`*^9, 3.8009108652409782`*^9, 
   3.800912942034176*^9, 3.800913181500865*^9, 3.800997332669725*^9, 
   3.801084762495336*^9, 3.801085208787586*^9, 3.801171257627338*^9, 
   3.801258070728409*^9, 3.8013454352627583`*^9, 3.801346292884481*^9, 
   3.8014790330620604`*^9, 3.801517167999078*^9, 3.801600625735338*^9, 
   3.801612550842366*^9, 3.8016126736098948`*^9, 3.801612789618498*^9, 
   3.801774340650566*^9, 3.801861230412736*^9, 3.801995996797865*^9, 
   3.802033605636817*^9, 3.8021214113791523`*^9, 3.802295592018364*^9, 
   3.802382141867588*^9, 3.8023822020524473`*^9, 3.802471160939452*^9, 
   3.802625871313155*^9, 3.802725392315835*^9, 3.802725558404999*^9, 
   3.80272566092078*^9, 3.8028111147744293`*^9, 3.8028115665240803`*^9, 
   3.80289738220107*^9, 3.802985595742651*^9, 3.802986709786088*^9, 
   3.802986884654282*^9, 3.802987551183275*^9, 3.80307426653874*^9, 
   3.803158115326158*^9, 3.803300043116029*^9, 3.803415948578171*^9, 
   3.803416129852233*^9, 3.803416265632381*^9, 3.803417669985672*^9, 
   3.8034189110743933`*^9, 3.8034196637601347`*^9, 3.803499543998909*^9, 
   3.803501390933702*^9, 3.8035014405687037`*^9, 3.803502207377489*^9, 
   3.803503456237809*^9, 3.803565361836946*^9, 3.803565418085174*^9, 
   3.803566324974203*^9, 3.803567709684136*^9, 3.803567758253428*^9, 
   3.803571458090684*^9, 3.803571516229651*^9, 3.80357159477254*^9, 
   3.8035915134790173`*^9, 3.803664643241559*^9, 3.80366540711625*^9, 
   3.803665548679409*^9, 3.8036664756677637`*^9, 3.803667552955303*^9, 
   3.8037357200824757`*^9, 3.803735976129795*^9, 3.8037364356906443`*^9, 
   3.803736514687113*^9, 3.80373662666705*^9, 3.80373680399203*^9, 
   3.803740896876298*^9, 3.803763128372613*^9, 3.803763247867959*^9, 
   3.803763310708906*^9, 3.8037641502597313`*^9, 3.803764720654502*^9, 
   3.8037690617726583`*^9, 3.803769101630085*^9, 3.803769352281177*^9, 
   3.803847901874926*^9, 3.803848056992989*^9, 3.8038481088212633`*^9, 
   3.803848203980822*^9, 3.80393714222078*^9, 3.803937302232664*^9, 
   3.804026595888249*^9, 3.8041084712114153`*^9, 3.804108558782289*^9, 
   3.804109880974399*^9, 3.80419369158512*^9, 3.804193779459414*^9, 
   3.804368101416094*^9, 3.8044525827207727`*^9, 3.804452797040924*^9, 
   3.80445296319865*^9, 3.804453069498767*^9, 3.8044532047442627`*^9, 
   3.804544436668995*^9, 3.8047151612930193`*^9, 3.8047152329518147`*^9, 
   3.804717497027341*^9, 3.804800227439762*^9, 3.804853847342318*^9, 
   3.804860585842781*^9, 3.804868192069406*^9, 3.804871041740774*^9, 
   3.8048846286353207`*^9, 3.8049632460873833`*^9, 3.804966592881316*^9, 
   3.8049672816501017`*^9, 3.8049709873161993`*^9, 3.805032061616336*^9, 
   3.8050498550845137`*^9, 3.80514516884311*^9, 3.805145657900385*^9, 
   3.8051458565197287`*^9, 3.805146047779331*^9, 3.805201930467799*^9, 
   3.805232577048594*^9, 3.805232768188168*^9, 3.8053176643243103`*^9, 
   3.805318476757855*^9, 3.805318560279169*^9, 3.805319449350458*^9, 
   3.805319559049438*^9, 3.805402867678422*^9, 3.805403404111861*^9, 
   3.8054917307927437`*^9, 3.805578708118741*^9, 3.8056390309703817`*^9, 
   3.805725939853772*^9, 3.8057260306781607`*^9, 3.805735863913212*^9, 
   3.805750046378392*^9, 3.805750095883271*^9, 3.80575037282878*^9, 
   3.8058083457513313`*^9, 3.805811137027853*^9, 3.8058388781856728`*^9, 
   3.805920954945798*^9, {3.806072151412507*^9, 3.806072177879319*^9}, 
   3.8060726088754*^9, 3.806072817887477*^9, 3.806175569722476*^9, 
   3.806183940892297*^9, 3.80618400473689*^9, 3.806353316441969*^9, 
   3.806353690783614*^9, 3.806441726805304*^9, 3.806441850765563*^9, 
   3.806442138346593*^9, 3.806699636396181*^9, 3.806699769194418*^9, 
   3.806701295821377*^9, 3.80670140036336*^9, 3.806772441341547*^9, 
   3.806872048581382*^9, 3.8068721630294447`*^9, 3.8070067497818203`*^9, 
   3.807006908055731*^9, 3.807131377938088*^9, 3.807389426645782*^9, 
   3.80738963075107*^9, 3.807562306873781*^9, 3.8076515356202593`*^9, 
   3.8077387412320232`*^9, 3.807738958224165*^9, 3.807903010605658*^9, 
   3.808082938746035*^9, 3.8082223346801977`*^9, 3.808223955715692*^9, 
   3.808429341604415*^9, 3.808602226415409*^9, 3.808651501251556*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"a849cd01-9390-4fd8-80fa-5d0843e5f46c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CasosPORdiaHOPKINS", "=", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "23"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13", ",", "15"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"14", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"15", ",", "31"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"16", ",", "12"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"17", ",", "27"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"18", ",", "47"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"19", ",", "39"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "51"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"21", ",", "66"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"22", ",", "54"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"23", ",", "39"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"24", ",", "74"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"25", ",", "113"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"26", ",", "132"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"27", ",", "132"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"28", ",", "152"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"29", ",", "105"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "124"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"31", ",", "171"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"32", ",", "149"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"33", ",", "187"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"34", ",", "210"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"35", ",", "257"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"36", ",", "295"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"37", ",", "354"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"38", ",", "397"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"39", ",", "264"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "408"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"41", ",", "377"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"42", ",", "443"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"43", ",", "358"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"44", ",", "393"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"45", ",", "455"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"46", ",", "459"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"47", ",", "587"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"48", ",", "630"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"49", ",", "774"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "513"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"51", ",", "739"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"52", ",", "1050"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"53", ",", "1096"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"54", ",", "1248"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"55", ",", "980"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"56", ",", "844"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"57", ",", "859"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"58", ",", "1232"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"59", ",", "1050"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"60", ",", "1431"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"61", ",", "1524"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"62", ",", "1357"}], "}"}]}], "}"}]}], ";"}], "\n"}]], "Input",\

 CellChangeTimes->{{3.797512210715201*^9, 3.797512747953198*^9}, {
  3.797512783548861*^9, 3.7975129320174828`*^9}, {3.797512964353292*^9, 
  3.7975129749208612`*^9}, {3.797513033204815*^9, 3.797513244542314*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"73088539-d787-4d92-ac23-f14ddb9e1ebf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{"CasosPORdiaHOPKINS", ",", "CASOSporDIAresta"}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.797513251884263*^9, 3.7975132691404743`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"ee3b05de-b508-4fde-a8ec-29362dcf6286"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdkbtKA0EUQAerlCksUlisEkREJGp8azKJz6hRSSUScIkExcYlhRpMsWih
pJCIaNp8Qj4lpZ/hJ6jcM4G5A8vh7JmZ3WHGa7eV+ogxJvf3/FPGT96nsb4n
lCeVj1rjjZTqY8oDNX9C9bTqk6pP4ctwGs7CGevPc+/zMKP6HFyH88J4D1/A
t/AsXsIX8VN8CR76/zlcv4JX8FWhreJr9ND/r6FvwEu4yfpzPAcvIOcO67gV
9mrsi4dX9AL73dDxZEQvCqMGHQ/u6Jxz8EDHY7d+G29CvHNP3xH2H+l46Pbf
Zb7bH49adO6tj7t7PHui79Of6Xjmlc69JmI6nnqhHwivO3Q8eKdz7/EHxHtv
9CPO06bj37gpC61bX/a/Z46F1S86PujST4TZT/sLTo1lRg==
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1k2IVXUYx/HDYBItZCgXs4i4hsgQEc14m8bJyaP2Yjmmjm9Z1twmX6bA
HARLMOgwYsEEMaGWgdWtzGq07HUqq+nQIgyhRatZBN1atGkjbYqCqPh/nsU9
F4Yf3/md3/P8/8//nHPvotF9w7s6siyb/e/vf/XJk1xakfTyCndWeGGFu/Ks
7XN1xa9V/GsrvLjCSyr57ry973V5e9/r8/a+N9AeeiPtq/z/Ftpb6bcUL6N1
eie9KWmxulJ3Db05ab4B97v+rkrdyA/wG5V1Rb3lFX8waSP41qS1Ubyiwrn1
bFIHN3byV7bXL3C+m78KP8LHzX3t+yj2U9w8wL8taXmQj/Nx/u1Jx47wcb6N
f4d6h/i483G+c+mM+nFOT1JzrOECd07wncv4YT5uPcO/O+mlp/j4wtP8tUmH
pvh43vP8oaQ7jvLxhuf465J2TfJxX5N/T9JTJ/n4T+vN1ic9+yIfLzzOdx+e
xHFfjr3gelxYb4kXvyS/Ub9X5PGFl+XwGn6Jx07IDyfdeUwe11+Vx13qlfiH
1+Xdt1e8IR/3sfkUOOZV4h8jvzlp75vyeOo1eTzwljyu4WxL0o5peXxCvQI/
an0l/sf12dakC87I41F+gfvekceTp+U9B8235fHp6I93vyePj52Tvzfp3Pvy
+C9c4CvPyuN+6822J33MPHK8J/L4qo/k8cyH8vdZ38fyeEj9Ai9Vr8Tfxvzu
T/rHB/J4lX4FPqB+idd/Ir8j6V7ryfFPri/wz+qXeOoz+QeSDqqX47lP5fFK
fokH1MseTHrKeeT4/LvyuD/yuGdGfiTplvPyeDMucMcX8nhtzN97fYl51fB+
+8vxJvn4Xhn/Un38m35N/L39l3jCflt4XfR/KOmz6tfwZdEfz/9cf7w9+uOv
v9I/OM4b13ELX7TebDTpYeuN78VDpf74uPoNPBLzxWPOp4n3xv2Ou623hQ/G
+T2ctHdWf3wk+uPpb/THG+P+xKvNt4nnmV+J/7a/Fp41z8z3/KD91PAIP8dd
6sfvghn7LfA1cf74F/sr8cXYP/49nr9dSb+z3hpuxPOMf/U+aOCJ6I+b+jXx
E9ZT4u7YPx6O/fsdM+f9WMPT8T7GdefZwEdj/nhS/SYuY/94a/THi7zPsj1J
F3jea3go5o+XRX/cE+8XXDe/Jj4X54/ne95aePmZ/F+de5Tn
      
      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 191.}, {0, 9556.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.7975132523898773`*^9, 3.797513281038875*^9}, 
   3.79751387957967*^9, 3.797514203860154*^9, 3.7975143587638187`*^9, 
   3.797515460380239*^9, 3.797515624976678*^9, 3.797529310987637*^9, 
   3.7976770072805223`*^9, 3.797677180618946*^9, 3.7977199909656687`*^9, 
   3.797720143688806*^9, {3.797720196116762*^9, 3.7977202157857313`*^9}, {
   3.79777268677591*^9, 3.7977727032884827`*^9}, 3.7978028090872297`*^9, {
   3.797803715031846*^9, 3.7978037440455217`*^9}, 3.797803835941031*^9, {
   3.7978891752550497`*^9, 3.79788919423558*^9}, 3.7978908900015383`*^9, 
   3.797930604317087*^9, 3.797937401086369*^9, 3.797961655496462*^9, 
   3.797976453552791*^9, 3.797979295988018*^9, 3.798027476625086*^9, 
   3.79804707086656*^9, 3.798049684227023*^9, 3.798056818292925*^9, {
   3.798134525764524*^9, 3.798134536090788*^9}, {3.79813457435966*^9, 
   3.798134579046177*^9}, 3.798317646493642*^9, 3.798317980915461*^9, 
   3.798492795794443*^9, {3.798492863632042*^9, 3.7984928904301357`*^9}, {
   3.7984929404042177`*^9, 3.798492953460951*^9}, 3.798492988349813*^9, 
   3.7985789504674*^9, 3.798579034868348*^9, 3.798579124031994*^9, 
   3.798579210806918*^9, 3.7987541448543653`*^9, 3.798754469923217*^9, 
   3.798827766539241*^9, 3.7989253313754787`*^9, 3.798925762091291*^9, {
   3.799012771745592*^9, 3.7990127970209293`*^9}, 3.799013077101808*^9, 
   3.799270450910227*^9, 3.7992721312108383`*^9, 3.799412048693905*^9, 
   3.799442749983759*^9, 3.799530016691802*^9, 3.799614725718481*^9, 
   3.799614776537539*^9, 3.79970458695687*^9, 3.799789560813352*^9, 
   3.799876337376996*^9, 3.79987644259518*^9, {3.7999624278809557`*^9, 
   3.79996244921029*^9}, 3.800047734238914*^9, 3.800137734968336*^9, 
   3.800221427309664*^9, 3.800319071544508*^9, {3.800395765861438*^9, 
   3.800395784377459*^9}, 3.800480900255033*^9, 3.800565437757475*^9, 
   3.800725792796092*^9, 3.8007379210412416`*^9, 3.800737982764604*^9, 
   3.8007380506662407`*^9, 3.80082681705205*^9, 3.8008276791229773`*^9, 
   3.800910865508956*^9, 3.800912942129147*^9, 3.800913181576762*^9, 
   3.8009973327429113`*^9, 3.8010847625702477`*^9, 3.801085208895535*^9, 
   3.801171257710164*^9, 3.801258070931005*^9, 3.801345436448737*^9, 
   3.801346293202879*^9, 3.801479033546802*^9, 3.801517168199402*^9, 
   3.801600625851459*^9, 3.801612551011097*^9, 3.801612673705822*^9, 
   3.801612789803*^9, 3.80177434074883*^9, 3.801861230493204*^9, 
   3.801995996895667*^9, 3.802033605740932*^9, 3.802121411479673*^9, 
   3.802295592107499*^9, 3.8023821462960987`*^9, 3.802382202129034*^9, 
   3.8024711610232983`*^9, 3.8026258714065323`*^9, 3.80272539242418*^9, 
   3.802725558483684*^9, 3.8027256610143423`*^9, 3.8028111148559237`*^9, 
   3.802811566676425*^9, 3.802897382302484*^9, 3.802985595827862*^9, 
   3.802986709899527*^9, 3.802986884774741*^9, 3.802987551350066*^9, 
   3.8030742666116037`*^9, 3.803158115403483*^9, 3.803300043239252*^9, 
   3.8034159486693583`*^9, 3.803416129932228*^9, 3.803416265755516*^9, 
   3.803417670084709*^9, 3.803418911297567*^9, 3.803419663863134*^9, 
   3.803499544097239*^9, 3.8035013910070744`*^9, 3.803501440636643*^9, 
   3.803502207449315*^9, 3.803503456307827*^9, 3.803565361979774*^9, 
   3.8035654182092752`*^9, 3.803566325052462*^9, 3.803567709737681*^9, 
   3.803567758324566*^9, 3.80357145814643*^9, 3.8035715162990847`*^9, 
   3.803571594883222*^9, 3.803591513551886*^9, 3.8036646433620367`*^9, 
   3.80366540722151*^9, 3.803665548817725*^9, 3.803666475834613*^9, 
   3.8036675530284843`*^9, 3.803735720190835*^9, 3.8037359762042913`*^9, 
   3.803736435760433*^9, 3.803736514758*^9, 3.803736626742977*^9, 
   3.803736804043418*^9, 3.8037408969554033`*^9, 3.803763128459313*^9, 
   3.803763247981977*^9, 3.803763310823575*^9, 3.803764150366255*^9, 
   3.8037647207518044`*^9, 3.803769061866611*^9, 3.803769101719146*^9, 
   3.803769352405177*^9, 3.803847901958712*^9, 3.803848057071042*^9, 
   3.8038481088891573`*^9, 3.8038482041084623`*^9, 3.803937142293996*^9, 
   3.8039373023297577`*^9, 3.804026595965376*^9, 3.804108471292691*^9, 
   3.804108558911813*^9, 3.80410988108386*^9, 3.8041936916956787`*^9, 
   3.8041937796039057`*^9, 3.804368101511715*^9, 3.8044525827956247`*^9, 
   3.804452797164741*^9, 3.804452963328026*^9, 3.804453069609193*^9, 
   3.804453204875311*^9, 3.804544436835623*^9, 3.8047151613685913`*^9, 
   3.804715233096861*^9, 3.8047174971568937`*^9, 3.804800227543242*^9, 
   3.8048538481811333`*^9, 3.804860585990184*^9, 3.804868192241274*^9, 
   3.80487104184496*^9, 3.804884628734544*^9, 3.804963246178244*^9, 
   3.8049665929486923`*^9, 3.804967281724874*^9, 3.804970987411162*^9, 
   3.805032061835279*^9, 3.8050498551964808`*^9, 3.805145168959763*^9, 
   3.8051456579892282`*^9, 3.805145856597982*^9, 3.805146047926762*^9, 
   3.805201930621849*^9, 3.805232577118484*^9, 3.8052327683300533`*^9, 
   3.805317671588214*^9, 3.8053184768747387`*^9, 3.80531856036276*^9, 
   3.805319449647285*^9, 3.805319559187319*^9, 3.805402867760644*^9, 
   3.805403404215436*^9, 3.805491730882264*^9, 3.805578708199551*^9, 
   3.805639031107765*^9, 3.805725939962019*^9, 3.8057260308067293`*^9, 
   3.805735863983775*^9, 3.8057500464768677`*^9, 3.8057500959679737`*^9, 
   3.8057503729266357`*^9, 3.805808345840695*^9, 3.80581113710568*^9, 
   3.805838878283927*^9, 3.8059209550085173`*^9, {3.8060721514634123`*^9, 
   3.8060721788935547`*^9}, 3.8060726089722147`*^9, 3.806072818014885*^9, 
   3.8061755698402147`*^9, 3.80618394097691*^9, 3.806184004908703*^9, 
   3.8063533165909567`*^9, 3.80635369090933*^9, 3.806441726894579*^9, 
   3.80644185088419*^9, 3.806442138457425*^9, 3.806699636474544*^9, 
   3.806699769341155*^9, 3.806701295943448*^9, 3.806701400451243*^9, 
   3.806772441448193*^9, 3.806872048665249*^9, 3.806872163118422*^9, 
   3.807006749841032*^9, 3.807006908127529*^9, 3.807131378043635*^9, 
   3.8073894267009907`*^9, 3.8073896308308563`*^9, 3.8075623069474697`*^9, 
   3.807651535734868*^9, 3.807738741318161*^9, 3.807738958377225*^9, 
   3.807903010700523*^9, 3.808082938848195*^9, 3.808222334755268*^9, 
   3.808223955801749*^9, 3.808429341688644*^9, 3.808602226502429*^9, 
   3.8086515013465757`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"32d2db6a-6da0-45bb-ae00-a710cbc2fab7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculation of pre-recovered active individuals. 
(c\[AAcute]lculo de casos de pre-recuperados activos)\
\>", "Section",
 CellChangeTimes->{{3.797514341180213*^9, 3.7975143507823*^9}, {
  3.808651017870277*^9, 
  3.8086510512420063`*^9}},ExpressionUUID->"675c867c-427a-45cf-b37e-\
d4c5fcc321be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CasosACTIVOS", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"DIAS", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"CASOS", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "-", 
        RowBox[{"DFD", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "-", 
        RowBox[{"DRD", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "DIAMX"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.7975137517878313`*^9, 3.797513756314724*^9}, 
   3.797513793479055*^9, {3.79751383379558*^9, 3.797513860252582*^9}, {
   3.797513901936245*^9, 3.7975139210042467`*^9}, {3.79751436246632*^9, 
   3.797514362776701*^9}, 3.797529321102496*^9, {3.7976770014099503`*^9, 
   3.797677001751152*^9}, {3.7977200046253567`*^9, 3.797720005099712*^9}, {
   3.7978038450156517`*^9, 3.797803845436411*^9}, {3.7978892102064342`*^9, 
   3.7978892104380693`*^9}, {3.797889321479988*^9, 3.797889327338212*^9}, {
   3.79813456487206*^9, 3.798134566421255*^9}, {3.798317633590192*^9, 
   3.798317638234055*^9}, {3.7983179755041857`*^9, 3.798317975626652*^9}, {
   3.798492857519573*^9, 3.798492857825317*^9}, {3.7985789427243977`*^9, 
   3.7985789432481194`*^9}, {3.798754136848456*^9, 3.7987541374213333`*^9}, {
   3.798925300296812*^9, 3.798925301272006*^9}, {3.7990127643034487`*^9, 
   3.799012764723547*^9}, {3.7992704431843233`*^9, 3.799270443475586*^9}, {
   3.7994120393560343`*^9, 3.799412039447548*^9}, {3.799442735657802*^9, 
   3.799442735790709*^9}, {3.799442839848641*^9, 3.799442845966476*^9}, {
   3.799530007261808*^9, 3.799530007865591*^9}, {3.799614770587291*^9, 
   3.7996147707376223`*^9}, {3.799704564106432*^9, 3.799704577317116*^9}, {
   3.799789548216865*^9, 3.799789549586163*^9}, {3.799876328071179*^9, 
   3.799876328317428*^9}, {3.799962456992094*^9, 3.7999624572467823`*^9}, {
   3.800047722649645*^9, 3.80004772288034*^9}, {3.800137727673215*^9, 
   3.8001377277883053`*^9}, {3.800221422519912*^9, 3.800221422773814*^9}, {
   3.800319046987911*^9, 3.800319047211728*^9}, 3.800395759913547*^9, {
   3.8004808914117107`*^9, 3.800480892590394*^9}, {3.800565441821498*^9, 
   3.800565441983761*^9}, {3.8007257967851133`*^9, 3.800725797646544*^9}, {
   3.8007379250632153`*^9, 3.800737925174232*^9}, {3.8008268308781023`*^9, 
   3.800826831500805*^9}, {3.800910858203878*^9, 3.800910858396751*^9}, 
   3.800913149991013*^9, 3.8063537147628508`*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"0419d52c-1f2f-42b7-acf4-e19a95c9b49d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "CasosACTIVOS", ",", "CasosPORdiaHOPKINS", ",", "CASOSporDIAresta"}], 
    "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.797514380220788*^9, 3.797514380972509*^9}, {
  3.7977202885090113`*^9, 3.797720313751069*^9}, {3.797889367296174*^9, 
  3.7978893701491823`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"f82b4190-db77-45d3-912d-ce3bcc2dbe64"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJx11nto1WUcx/GHiJjEgaOTCBL9KZFhS5ZaOa+PXbxuNU+6aaX98rb+0DzC
GhEYDzElL3+cYkV/VPxoROkfciKxkpWPl24W7STrIor83B+iEHoyLyt1dPm8
nz/2gwbjsxef5/t8f2cbhzN21cbC2puMMQf++f439VWdzQ92aNZkMp/JkZm8
/X9yVCajjMdlfGfGd2V8dyYnkJPIOrKBnEg+QtaTj5P3kS1D77HBk/HTeIoy
XY3vVybP4Qfw8/hBZbwJT1W69qHPmXTgacrKy3g6+xyeofSdeKby01fxLGV5
J56tXF/ClvmXeA489RX6OcrqFnpcv4P+IWU79zlc10X/sHKA53V4fpjn71B9
jR6X36B/VNn5Dj1emNDPVXZ10+MZ79PPU+7+gB4v+5B+vtLupseNe+gX8Ho+
osc376VfqJwQ7sf94f5FytoyPR6DTaOyI/T4t4/pm5TrscO9n9A/phz4gh5v
3kfP/3XbZ/Q4t5++WXnHAaXFdYc4L7uxR2RPX/mK+cXqG48yL5se7nf02zzz
uAebgnL4YeZld5D7Hf2wr5nHLZw3T7AvzONFnHeym/gl87j7W+aXyH3ss7LZ
HubpO79nXrafV5hfqpz1HfOyi7HDg/x+POf3c194n1nwA/Oye72XeTwJe9nn
jjHfKt/D81jZzAvz9O30nj73I/PL9HpGcJ/FnT8xjzvovWwuhP3LlS9y3sq2
4Tjzsu/6mXn6EX3MP6n+PLb4zC/M41bu97Ld8CvzT8mbTzIvm7fD88t+cdgv
uxPY6H3cDWcf7+v2XNgv+/fCPOeP0JsVclPYL0e7Uubpr/YzL9sGerNSPnua
eTnqPs+8HM+5wDz9sCrzzyhfwFYu9WInV1ouMi+nTb8zH8ubcCSXT2MrV1f+
Icdy6ST3Obl4L30i59/EXjZv4ZR972Lz7H9Zf8sl9su2cJn9cnEDfSy7Y9jR
uyvsl0sdzHvZbMGp3Jxis0oec5X9cv4b7rOyax9gv1zfip3s23DC+cnc5+Wo
B6dysh0bfW4ojmQ+kqMbf7JfjsdfZz+fM2ronZy/9S/201+k9/Sj6fmcEm29
xv41ykOcj+T8qbBfrvbhmH40844+F/bLroC9nPiwXy5exmatnucKjuT4GrZy
5TCOcW3YL7u5OJH9QX5fXi7306fsW05v1mnfEhzJzSc4b+mP41hOb+O8k0tb
ccL80bCf84M4lau1N9jfpuc/G/bL6Xh6KxeX4liOV2An2z04kUu5QfbLzQWc
4ppB+zeP//GZ
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdkbtKA0EUQAerlCksUlisEkREJGp8azKJz6hRSSUScIkExcYlhRpMsWih
pJCIaNp8Qj4lpZ/hJ6jcM4G5A8vh7JmZ3WHGa7eV+ogxJvf3/FPGT96nsb4n
lCeVj1rjjZTqY8oDNX9C9bTqk6pP4ctwGs7CGevPc+/zMKP6HFyH88J4D1/A
t/AsXsIX8VN8CR76/zlcv4JX8FWhreJr9ND/r6FvwEu4yfpzPAcvIOcO67gV
9mrsi4dX9AL73dDxZEQvCqMGHQ/u6Jxz8EDHY7d+G29CvHNP3xH2H+l46Pbf
Zb7bH49adO6tj7t7PHui79Of6Xjmlc69JmI6nnqhHwivO3Q8eKdz7/EHxHtv
9CPO06bj37gpC61bX/a/Z46F1S86PujST4TZT/sLTo1lRg==
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1k2IVXUYx/HDYBItZCgXs4i4hsgQEc14m8bJyaP2Yjmmjm9Z1twmX6bA
HARLMOgwYsEEMaGWgdWtzGq07HUqq+nQIgyhRatZBN1atGkjbYqCqPh/nsU9
F4Yf3/md3/P8/8//nHPvotF9w7s6siyb/e/vf/XJk1xakfTyCndWeGGFu/Ks
7XN1xa9V/GsrvLjCSyr57ry973V5e9/r8/a+N9AeeiPtq/z/Ftpb6bcUL6N1
eie9KWmxulJ3Db05ab4B97v+rkrdyA/wG5V1Rb3lFX8waSP41qS1Ubyiwrn1
bFIHN3byV7bXL3C+m78KP8LHzX3t+yj2U9w8wL8taXmQj/Nx/u1Jx47wcb6N
f4d6h/i483G+c+mM+nFOT1JzrOECd07wncv4YT5uPcO/O+mlp/j4wtP8tUmH
pvh43vP8oaQ7jvLxhuf465J2TfJxX5N/T9JTJ/n4T+vN1ic9+yIfLzzOdx+e
xHFfjr3gelxYb4kXvyS/Ub9X5PGFl+XwGn6Jx07IDyfdeUwe11+Vx13qlfiH
1+Xdt1e8IR/3sfkUOOZV4h8jvzlp75vyeOo1eTzwljyu4WxL0o5peXxCvQI/
an0l/sf12dakC87I41F+gfvekceTp+U9B8235fHp6I93vyePj52Tvzfp3Pvy
+C9c4CvPyuN+6822J33MPHK8J/L4qo/k8cyH8vdZ38fyeEj9Ai9Vr8Tfxvzu
T/rHB/J4lX4FPqB+idd/Ir8j6V7ryfFPri/wz+qXeOoz+QeSDqqX47lP5fFK
fokH1MseTHrKeeT4/LvyuD/yuGdGfiTplvPyeDMucMcX8nhtzN97fYl51fB+
+8vxJvn4Xhn/Un38m35N/L39l3jCflt4XfR/KOmz6tfwZdEfz/9cf7w9+uOv
v9I/OM4b13ELX7TebDTpYeuN78VDpf74uPoNPBLzxWPOp4n3xv2Ou623hQ/G
+T2ctHdWf3wk+uPpb/THG+P+xKvNt4nnmV+J/7a/Fp41z8z3/KD91PAIP8dd
6sfvghn7LfA1cf74F/sr8cXYP/49nr9dSb+z3hpuxPOMf/U+aOCJ6I+b+jXx
E9ZT4u7YPx6O/fsdM+f9WMPT8T7GdefZwEdj/nhS/SYuY/94a/THi7zPsj1J
F3jea3go5o+XRX/cE+8XXDe/Jj4X54/ne95aePmZ/F+de5Tn
      
      "]]}, {}}, {}, {}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 191.}, {0, 124197.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.79751438148208*^9, 3.797515460465803*^9, 3.7975156250892*^9, 
   3.797677007558379*^9, 3.7976771808802643`*^9, 3.7977199962900457`*^9, 
   3.7977201492993107`*^9, 3.797720239258844*^9, {3.797720274819118*^9, 
   3.797720314393689*^9}, {3.7977726869586153`*^9, 3.797772734526005*^9}, 
   3.7978028093056498`*^9, 3.797803715249844*^9, {3.797803850808971*^9, 
   3.797803855336665*^9}, 3.797889175465354*^9, 3.797889217125092*^9, {
   3.797889335920948*^9, 3.797889370767212*^9}, 3.797890890276689*^9, 
   3.797930604505375*^9, 3.7979374012813387`*^9, 3.797961655738262*^9, 
   3.797976453782584*^9, 3.7979792962011213`*^9, 3.798027476820895*^9, 
   3.798047071027339*^9, 3.798049684406309*^9, 3.798056818440846*^9, {
   3.798134525958804*^9, 3.798134536284424*^9}, {3.798134574580945*^9, 
   3.798134586064933*^9}, 3.79831764675047*^9, 3.7983179810629597`*^9, 
   3.798492795994156*^9, 3.798492953716617*^9, 3.798578950606954*^9, 
   3.798579035069417*^9, 3.798579124200164*^9, 3.7985792111011467`*^9, 
   3.798754144987495*^9, 3.798754470220812*^9, 3.7988277677728577`*^9, 
   3.7989253316368923`*^9, 3.79892576236276*^9, {3.799012771990856*^9, 
   3.799012797264881*^9}, 3.799013077295725*^9, 3.799270451113462*^9, 
   3.799272131424608*^9, 3.799412049841556*^9, 3.799416605610484*^9, 
   3.7994427506578493`*^9, 3.799530016915401*^9, 3.799614725923026*^9, 
   3.799614776692067*^9, 3.799704587171137*^9, 3.7997895610199127`*^9, 
   3.799876337584165*^9, 3.799876442920072*^9, {3.7999624281143*^9, 
   3.799962462726913*^9}, 3.8000477344994583`*^9, 3.800137735092861*^9, 
   3.800221427540326*^9, 3.8003190721649637`*^9, 3.800395766113611*^9, 
   3.800480900518119*^9, 3.8005654469832497`*^9, 3.800725800728956*^9, 
   3.8007379288385897`*^9, 3.800737983036817*^9, 3.800738050969964*^9, 
   3.800826839103483*^9, 3.800827679284491*^9, 3.8009108657022943`*^9, 
   3.800912942325623*^9, 3.800913182196138*^9, 3.8009973331755457`*^9, 
   3.8010847638743763`*^9, {3.801085209433957*^9, 3.8010852282753677`*^9}, 
   3.801171258043241*^9, 3.80125807248829*^9, 3.801345436971754*^9, 
   3.801346293653878*^9, 3.8014790340751553`*^9, 3.801517168600499*^9, 
   3.801600626197495*^9, 3.801612551355607*^9, 3.801612674013513*^9, 
   3.80161279102839*^9, 3.8017743410626297`*^9, 3.8018612308844976`*^9, 
   3.8019959973204403`*^9, 3.802033606081019*^9, 3.802121411815714*^9, 
   3.802295593156999*^9, 3.802382161921261*^9, 3.8023822024425697`*^9, 
   3.802471161439951*^9, 3.802625871741021*^9, 3.802725392783119*^9, 
   3.802725558819437*^9, 3.802725661374811*^9, 3.802811115225898*^9, 
   3.8028115670705957`*^9, 3.802897382650923*^9, 3.802985596227497*^9, 
   3.802986710252493*^9, 3.802986885129147*^9, 3.802987553038275*^9, 
   3.8030742669765577`*^9, 3.8031581157833*^9, 3.803300043680298*^9, 
   3.803415949035399*^9, 3.803416130306872*^9, 3.803416266158971*^9, 
   3.8034176703481407`*^9, 3.80341891196628*^9, 3.803419664904146*^9, 
   3.803499544308014*^9, 3.803501391207323*^9, 3.8035014408328447`*^9, 
   3.803502207630309*^9, 3.8035034565167*^9, 3.803565362389853*^9, 
   3.8035654185635023`*^9, 3.803566325557005*^9, 3.8035677099252157`*^9, 
   3.803567758574127*^9, 3.803571458380168*^9, 3.803571516516386*^9, 
   3.803571595051931*^9, 3.803591513874894*^9, 3.803664643715866*^9, 
   3.803665407704369*^9, 3.803665549174238*^9, 3.8036664761846046`*^9, 
   3.803667553267441*^9, 3.80373572042859*^9, 3.803735976428426*^9, 
   3.803736435949402*^9, 3.8037365149708357`*^9, 3.8037366269251223`*^9, 
   3.803736804218012*^9, 3.803740897310063*^9, 3.803763128772046*^9, 
   3.803763248309546*^9, 3.80376331114439*^9, 3.803764150681291*^9, 
   3.803764721096005*^9, 3.8037690622126703`*^9, 3.803769102058947*^9, 
   3.803769352780051*^9, 3.803847902330633*^9, 3.803848057393585*^9, 
   3.80384810906257*^9, 3.8038482044278803`*^9, 3.803937142659583*^9, 
   3.803937302708898*^9, 3.80402659635675*^9, 3.804108471727068*^9, 
   3.8041085594904613`*^9, 3.804109881503817*^9, 3.804193692079357*^9, 
   3.804193779942608*^9, 3.804368101931901*^9, 3.804452583212068*^9, 
   3.804452797555134*^9, 3.804452963741988*^9, 3.8044530700765343`*^9, 
   3.804453205935198*^9, 3.804544437226102*^9, 3.8047151618445187`*^9, 
   3.804715233499654*^9, 3.804717497673882*^9, 3.804800228043461*^9, 
   3.8048538513816023`*^9, 3.804860586687635*^9, 3.804868192605051*^9, 
   3.804871042225148*^9, 3.804884629165577*^9, 3.80496324637925*^9, 
   3.804966593117343*^9, 3.804967281948778*^9, 3.8049709877702312`*^9, 
   3.805032062494215*^9, 3.805049855747957*^9, 3.805145169330393*^9, 
   3.805145658852825*^9, 3.8051458574820757`*^9, 3.805146048299568*^9, 
   3.805201931477982*^9, 3.805232577544713*^9, 3.805232768723295*^9, 
   3.805317678722931*^9, 3.805318477262591*^9, 3.805318560764413*^9, 
   3.805319450055051*^9, 3.8053195595628443`*^9, 3.8054028681760893`*^9, 
   3.8054034045644484`*^9, 3.805491731261503*^9, 3.805578708628899*^9, 
   3.8056390314622498`*^9, 3.8057259403212347`*^9, 3.8057260311698427`*^9, 
   3.805735864222775*^9, 3.805750047036512*^9, 3.805750096487356*^9, 
   3.8057503734166927`*^9, 3.805808346081202*^9, 3.805811137459071*^9, 
   3.805838878478334*^9, 3.805920955207492*^9, {3.806072151638719*^9, 
   3.806072179427784*^9}, 3.8060726093843184`*^9, 3.806072818411561*^9, 
   3.806175570250164*^9, 3.806183941409659*^9, 3.80618400551158*^9, 
   3.806353321202532*^9, 3.8063536915484123`*^9, 3.80644172717141*^9, 
   3.806441851178577*^9, 3.806442138759377*^9, 3.806699636764009*^9, 
   3.80669976964783*^9, 3.806701296251161*^9, 3.806701400696599*^9, 
   3.8067724417552643`*^9, 3.806872048959344*^9, 3.806872163372283*^9, 
   3.807006750139223*^9, 3.807006908372203*^9, 3.8071313783025427`*^9, 
   3.8073894269732733`*^9, 3.8073896311452827`*^9, 3.807562307274804*^9, 
   3.807651536003394*^9, 3.80773874159111*^9, 3.8077389586723957`*^9, 
   3.807903010971562*^9, 3.8080829391394444`*^9, 3.8082223351014147`*^9, 
   3.8082239560560627`*^9, 3.80842934194326*^9, 3.808602226787644*^9, 
   3.808651501455517*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"48b5feb1-7a29-4832-834f-b020b215546e"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.808220861865172*^9, 3.808220862420031*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"7903d7e1-6cd3-46d4-ab9d-046eb8db4d6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
First estimation of the susceptible individuals. 
The urban population in Mexico is about 77 % of the total population\
\>", "Section",
 CellChangeTimes->{{3.797586516819861*^9, 3.797586550772427*^9}, {
  3.8058106754697933`*^9, 3.8058107073856573`*^9}, {3.80822086690895*^9, 
  3.8082208799439907`*^9}, {3.808651058376327*^9, 3.808651059722823*^9}},
 Background->RGBColor[
  0.88, 1, 0.88],ExpressionUUID->"a2b72455-1d7c-4753-99eb-1c8bdb7920ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"130000000", "*", "0.77"}]], "Input",
 CellChangeTimes->{{3.797586367018857*^9, 3.797586413305456*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"ca64412a-b8f5-4ae2-bd7d-1aeec59dea43"],

Cell[BoxData["1.001`*^8"], "Output",
 CellChangeTimes->{
  3.797586418476511*^9, 3.797677007729134*^9, 3.797677181007977*^9, 
   3.797719996583764*^9, 3.797720149654806*^9, 3.797720351020095*^9, {
   3.7977726869982243`*^9, 3.7977727345823717`*^9}, 3.797802809752466*^9, 
   3.797803715296928*^9, 3.797803855430341*^9, 3.797889175518114*^9, 
   3.797890890353057*^9, 3.797930604584922*^9, 3.7979374013252287`*^9, 
   3.797961655799053*^9, 3.7979764538933277`*^9, 3.7979792963236628`*^9, 
   3.798027476903434*^9, 3.798056294386107*^9, 3.798056818519251*^9, 
   3.798134596536029*^9, 3.798317692264697*^9, {3.798317986390645*^9, 
   3.7983180026419783`*^9}, 3.7985790361108313`*^9, 3.798579124277348*^9, 
   3.7992704512163153`*^9, 3.799412050846909*^9, 3.799530017018862*^9, 
   3.799614725965351*^9, 3.799614776739337*^9, 3.7997045872442017`*^9, 
   3.799789561056346*^9, 3.799876337618466*^9, 3.7998764430018806`*^9, 
   3.79996246954432*^9, 3.800910865811164*^9, 3.801600626240121*^9, 
   3.801612674075541*^9, 3.801612791101927*^9, 3.801774341118826*^9, 
   3.801861230995934*^9, 3.8020336061179523`*^9, 3.802121411863646*^9, 
   3.80229559320879*^9, 3.802382202533986*^9, 3.802471161483303*^9, 
   3.802625871780724*^9, 3.802725392821506*^9, 3.8027255588688087`*^9, 
   3.8027256614264603`*^9, 3.802811115268157*^9, 3.80281156711199*^9, 
   3.8028973827037563`*^9, 3.802985596274564*^9, 3.802986710320653*^9, 
   3.802986885227662*^9, 3.8029875531568947`*^9, 3.803074267011613*^9, 
   3.803158115831686*^9, 3.803300043730276*^9, 3.80341594907944*^9, 
   3.8034161303547163`*^9, 3.8034162662401876`*^9, 3.803417670389933*^9, 
   3.8034189120853987`*^9, 3.803419664991434*^9, 3.803499544440796*^9, 
   3.803501391241457*^9, 3.803501440876007*^9, 3.8035022076664753`*^9, 
   3.803503456566945*^9, 3.803565362489249*^9, 3.803565418661057*^9, 
   3.803566325606804*^9, 3.803567709965131*^9, 3.803567758614249*^9, 
   3.803571458424041*^9, 3.803571516549491*^9, 3.803571595081522*^9, 
   3.803591513907345*^9, 3.8036646438906517`*^9, 3.803665408064176*^9, 
   3.803665549256885*^9, 3.8036664762659273`*^9, 3.8036675533107653`*^9, 
   3.8037357204727783`*^9, 3.8037359764717493`*^9, 3.803736435995912*^9, 
   3.8037365150091877`*^9, 3.8037366269403677`*^9, 3.803736804257229*^9, 
   3.803740897353372*^9, 3.803763128801688*^9, 3.803763248383135*^9, 
   3.8037633112169447`*^9, 3.803764150764902*^9, 3.803764721158746*^9, 
   3.803769062254612*^9, 3.803769102095707*^9, 3.8037693528568497`*^9, 
   3.8038479023991337`*^9, 3.803848057438137*^9, 3.803848109093684*^9, 
   3.8038482044659758`*^9, 3.803937142709607*^9, 3.803937302791153*^9, 
   3.804026596410948*^9, 3.804108471773365*^9, 3.804108559603732*^9, 
   3.804109881602409*^9, 3.8041936921300898`*^9, 3.8041937830728207`*^9, 
   3.804368101983757*^9, 3.804452583260261*^9, 3.804452797636649*^9, 
   3.804452963852469*^9, 3.8044530701672077`*^9, 3.804453206783877*^9, 
   3.8045444372911654`*^9, 3.8047151618809137`*^9, 3.80471523359229*^9, 
   3.8047174977120047`*^9, 3.804800228091717*^9, 3.804853851769882*^9, 
   3.804860586781839*^9, 3.8048846292061043`*^9, 3.804963246409502*^9, 
   3.804966593150754*^9, 3.804967281993347*^9, 3.804970987823591*^9, 
   3.80503206259793*^9, 3.805049855883412*^9, 3.805145169428318*^9, 
   3.8051456589111423`*^9, 3.8051458575367327`*^9, 3.8051460483929777`*^9, 
   3.805201931628673*^9, 3.8052325776209927`*^9, 3.8052327688206253`*^9, 
   3.805317679290133*^9, 3.805318477308094*^9, 3.80531856081964*^9, 
   3.8053194539191504`*^9, 3.805319559633671*^9, 3.805402868218582*^9, 
   3.8054034046388073`*^9, 3.805491731305317*^9, 3.805578708679471*^9, 
   3.805639031596464*^9, {3.805725921816208*^9, 3.805725940400428*^9}, 
   3.8057260312673273`*^9, 3.805735864271275*^9, 3.805750047089054*^9, 
   3.805750096543749*^9, 3.805750373468595*^9, 3.8058083461082706`*^9, 
   3.805811137505175*^9, 3.805838878527609*^9, 3.8059209552571917`*^9, {
   3.8060721516739492`*^9, 3.806072179498932*^9}, 3.806072609425661*^9, 
   3.8060728185066967`*^9, 3.8061755703364964`*^9, 3.806183941453721*^9, 
   3.806184005628862*^9, 3.806353321368678*^9, 3.806353691724547*^9, 
   3.806441727220483*^9, 3.8064418512748003`*^9, 3.80644213882679*^9, 
   3.806699636803088*^9, 3.806699769718835*^9, 3.806701296336183*^9, 
   3.806701400752253*^9, 3.806772441835874*^9, 3.806872049011283*^9, 
   3.8068721634205503`*^9, 3.80700675018583*^9, 3.807006908417307*^9, 
   3.807131378341897*^9, 3.807389427045252*^9, 3.807389631236903*^9, 
   3.807562307312879*^9, 3.8076515360420628`*^9, 3.8077387416272*^9, 
   3.807738958748041*^9, 3.807903011013279*^9, 3.808082939191524*^9, 
   3.808222335220159*^9, 3.808223956105564*^9, 3.808429342052319*^9, 
   3.808602226845487*^9, 3.808651501556632*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"83710972-1871-4698-ae40-c732b742338f"]
}, Open  ]],

Cell["\<\
Multiplicando por el factor de proporci\[OAcute]n de contagiados en Italia, \
europa, da alrededor e3 300000 infectados\
\>", "Text",
 CellChangeTimes->{{3.797586555387422*^9, 3.79758660466499*^9}, 
   3.79767718788167*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"dd7c13bc-51a6-40fc-aae8-1ea715c8c3a4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.001`*^8", "*", "0.003"}]], "Input",
 CellChangeTimes->{{3.797586443993606*^9, 3.797586468670848*^9}, 
   3.797586504885851*^9},
 CellLabel->"In[26]:=",ExpressionUUID->"0dcebe52-95ec-40d5-ab97-be6011268a10"],

Cell[BoxData["300300.`"], "Output",
 CellChangeTimes->{{3.797586480341517*^9, 3.797586506134841*^9}, 
   3.797677007922594*^9, 3.797677181173669*^9, 3.7977199968614902`*^9, 
   3.797720149953724*^9, 3.797720351177126*^9, {3.7977726871135397`*^9, 
   3.797772734700409*^9}, 3.797802809894944*^9, 3.7978037154447002`*^9, 
   3.797803855543819*^9, 3.7978891756863823`*^9, 3.797890890436592*^9, 
   3.797930604681365*^9, 3.797937401440886*^9, 3.7979616558496017`*^9, 
   3.797976453977934*^9, 3.797979296437503*^9, 3.7980274769863653`*^9, 
   3.7980562944557533`*^9, 3.798056818602194*^9, 3.7981345966577377`*^9, 
   3.798317692403126*^9, {3.798317986527213*^9, 3.7983180028048162`*^9}, 
   3.798579036463004*^9, 3.798579124361066*^9, 3.7992704513341713`*^9, 
   3.799412051283938*^9, 3.7995300171320353`*^9, 3.79961472611553*^9, 
   3.799614776838633*^9, 3.7997045874120626`*^9, 3.799789561156232*^9, 
   3.7998763377226877`*^9, 3.799876443085586*^9, 3.799962469631415*^9, 
   3.800910865926296*^9, 3.801600626408081*^9, 3.801612674175994*^9, 
   3.8016127912065477`*^9, 3.8017743412519617`*^9, 3.801861231161603*^9, 
   3.80203360623571*^9, 3.8021214119953413`*^9, 3.802295593322378*^9, 
   3.802382202699191*^9, 3.802471161667728*^9, 3.80262587189846*^9, 
   3.802725392953842*^9, 3.802725558987093*^9, 3.8027256615271587`*^9, 
   3.80281111540047*^9, 3.802811567213407*^9, 3.8028973828379087`*^9, 
   3.802985596390815*^9, 3.8029867103891697`*^9, 3.8029868853119793`*^9, 
   3.80298755330519*^9, 3.8030742671361217`*^9, 3.803158115983581*^9, 
   3.8033000438637743`*^9, 3.803415949229238*^9, 3.803416130504409*^9, 
   3.803416266323564*^9, 3.803417670457712*^9, 3.80341891224992*^9, 
   3.803419665154161*^9, 3.803499544523501*^9, 3.803501391363736*^9, 
   3.80350144095982*^9, 3.8035022077507477`*^9, 3.8035034566616983`*^9, 
   3.803565362573205*^9, 3.803565418744836*^9, 3.803566325823658*^9, 
   3.803567710069653*^9, 3.803567758698288*^9, 3.8035714585259*^9, 
   3.8035715166149607`*^9, 3.803571595152031*^9, 3.803591514037442*^9, 
   3.803664643974175*^9, 3.8036654083307943`*^9, 3.803665549340817*^9, 
   3.803666476331625*^9, 3.803667553395146*^9, 3.803735720573546*^9, 
   3.803735976555888*^9, 3.803736436079805*^9, 3.803736515093548*^9, 
   3.803736626991222*^9, 3.8037368043404303`*^9, 3.803740897486515*^9, 
   3.8037631288933783`*^9, 3.803763248449719*^9, 3.803763311284706*^9, 
   3.803764150848415*^9, 3.8037647212291203`*^9, 3.8037690623870087`*^9, 
   3.803769102201839*^9, 3.803769352955675*^9, 3.803847902532751*^9, 
   3.8038480575552053`*^9, 3.803848109197904*^9, 3.8038482046754436`*^9, 
   3.80393714284249*^9, 3.803937302858651*^9, 3.804026596567141*^9, 
   3.804108471956779*^9, 3.804108559703915*^9, 3.804109881702808*^9, 
   3.804193692326455*^9, 3.804193783204875*^9, 3.804368102185173*^9, 
   3.8044525834429817`*^9, 3.804452797720831*^9, 3.8044529639495573`*^9, 
   3.8044530702525187`*^9, 3.804453207001781*^9, 3.8045444373675547`*^9, 
   3.804715162052993*^9, 3.804715233691173*^9, 3.804717497895944*^9, 
   3.8048002282920723`*^9, 3.804853851934512*^9, 3.804860586885577*^9, 
   3.804884629406425*^9, 3.804963246477147*^9, 3.8049665931929092`*^9, 
   3.804967282074348*^9, 3.804970987991685*^9, 3.8050320626982737`*^9, 
   3.805049856019093*^9, 3.805145169596558*^9, 3.805145659089572*^9, 
   3.8051458577384167`*^9, 3.805146048493082*^9, 3.805201931746416*^9, 
   3.805232577806281*^9, 3.8052327689214153`*^9, 3.805317679485754*^9, 
   3.805318477421726*^9, 3.805318561000342*^9, 3.80531945400883*^9, 
   3.8053195596988077`*^9, 3.805402868401932*^9, 3.805403404707571*^9, 
   3.8054917314687366`*^9, 3.805578708880506*^9, 3.805639031681444*^9, {
   3.8057259219166603`*^9, 3.80572594050632*^9}, 3.805726031351392*^9, 
   3.805735864400984*^9, 3.8057500473922358`*^9, 3.805750096860581*^9, 
   3.805750373755309*^9, 3.8058083461933517`*^9, 3.805811137640892*^9, 
   3.805838878577024*^9, 3.805920955311714*^9, {3.8060721517386*^9, 
   3.806072179652039*^9}, 3.8060726096422787`*^9, 3.8060728186094913`*^9, 
   3.8061755704031677`*^9, 3.806183941675434*^9, 3.8061840057468653`*^9, 
   3.806353321557186*^9, 3.8063536920650663`*^9, 3.806441727392055*^9, 
   3.8064418513909683`*^9, 3.806442138896307*^9, 3.806699636991832*^9, 
   3.8066997698049173`*^9, 3.80670129641752*^9, 3.806701400916527*^9, 
   3.8067724419185743`*^9, 3.806872049166482*^9, 3.806872163571485*^9, 
   3.807006750368084*^9, 3.807006908511232*^9, 3.807131378510203*^9, 
   3.807389427182308*^9, 3.807389631333498*^9, 3.807562307467863*^9, 
   3.8076515361727448`*^9, 3.8077387418306503`*^9, 3.8077389588318644`*^9, 
   3.8079030111776533`*^9, 3.808082939363752*^9, 3.808222335305326*^9, 
   3.808223956303502*^9, 3.8084293422241364`*^9, 3.808602227067737*^9, 
   3.808651501639926*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"4b5349c2-d4fa-43e2-b735-12d12f3a1af2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Model nomenclature", "Title",
 CellChangeTimes->{{3.808220915997079*^9, 3.808220924152011*^9}, {
  3.8082223513171673`*^9, 3.8082223608907757`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"2b4a590c-3c81-4755-8f94-d5dcb4d7fd54"],

Cell[TextData[{
 StyleBox["The sectors of the compartmental model are:\n\nS: Susceptible\n",
  FontSize->24,
  FontWeight->"Regular"],
 StyleBox["E: Unreported",
  FontSize->24,
  FontWeight->"Regular",
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["\nI: Infected\nA: Pre-recovered-Active\nR: Recovered\nD: Number of \
deaths\n\nThe parameeters of the equations are:\n\n",
  FontSize->24,
  FontWeight->"Regular"],
 StyleBox["\[Mu]: Not used.",
  FontSize->24,
  FontWeight->"Regular",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\nkv: direct virus transmission rate.\nke: unreported transmission \
rate.\nki: infected transmission rate.\n\[CapitalDelta]ki: rate decrease \
factor by the domestic confinement start.\n\[CapitalDelta]kds2: rate decrease \
factor by the domestic confinement reforcement.\n\[CapitalDelta]kf2: rate \
increase factor by the domestic confinement end.\n\[Alpha]: inverse time of \
an unreported individual (E) starts to present of sympthoms.\n",
  FontSize->24,
  FontWeight->"Regular"],
 StyleBox["\[Beta]: Not used.\n",
  FontSize->24,
  FontWeight->"Regular",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\[Gamma]: inverse time after the which the symptoms from a \
seriously ill individual disappear.\n\[Delta]: inverse time endured from the \
beginning of symptoms until death.\n\[Epsilon]: inverse time period during \
which an infected individual maintains manifests active symptoms.",
  FontSize->24,
  FontWeight->"Regular",
  FontColor->GrayLevel[0]],
 StyleBox["\nr,g,a: proportions of individuals that recover, die, or are pre- \
recovered from the total number of known infected individuals, and satisfy \
the condition r + d + a = 1\np: proportion of people who die.",
  FontSize->24,
  FontWeight->"Regular"]
}], "Text",
 CellChangeTimes->{{3.808220930642721*^9, 3.8082211021207314`*^9}, {
  3.8082216508195543`*^9, 3.808221848219915*^9}, {3.808221903345488*^9, 
  3.8082221417498817`*^9}, {3.808222174620677*^9, 3.8082222219097223`*^9}, {
  3.808222291645155*^9, 3.8082223025189047`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"91a0936d-a739-407d-9133-b76278903d75"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FIT ASSUMING 
900 THOUSAND SUSCEPTIBLE INDIVIDUALS, new trend of recovered individuas\
\>", "Title",
 CellChangeTimes->{{3.797586516819861*^9, 3.797586550772427*^9}, {
   3.8058106754697933`*^9, 3.8058107073856573`*^9}, {3.8058107958350067`*^9, 
   3.805810821808531*^9}, {3.805810936434065*^9, 3.805810959767067*^9}, 
   3.805811090796736*^9, {3.808220896280839*^9, 3.808220896475276*^9}, {
   3.808652415077499*^9, 3.808652424010038*^9}},
 Background->RGBColor[
  1, 1, 0],ExpressionUUID->"2a528168-9d25-452d-b9ab-3134705cd6c5"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  TemplateBox[{
   "NIntegrate","nlim",
    "\"\\!\\(\\*RowBox[{\\\"z\\\"}]\\) = \\!\\(\\*RowBox[{\\\"t\\\"}]\\) is \
not a valid limit of integration.\"",2,253,505,21718307563882191640,"Local"},
   "MessageTemplate"], "]"}]], "Input",
 CellChangeTimes->{3.7971526887681*^9},
 CellLabel->"In[27]:=",ExpressionUUID->"254d3b0f-ec87-4138-8b43-509c5f69a769"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", "=", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          StyleBox[
           RowBox[{"(*", " ", "SUSCEPTIBLE", "*)"}],
           FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->GrayLevel[0]], 
          RowBox[{
           StyleBox[
            RowBox[{
             RowBox[{
              RowBox[{"S", "'"}], "[", "t", "]"}], "\[Equal]", 
             RowBox[{
              RowBox[{"\[Mu]", "*", 
               RowBox[{"S", "[", "t", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"kv", "+", " ", 
                 RowBox[{"ke", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Ex", "[", "t", "]"}]}], "+", 
                 RowBox[{"ki", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Inf", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"S", "[", "t", "]"}]}]}]}],
            FontColor->GrayLevel[0]], 
           StyleBox[",",
            FontColor->GrayLevel[0]], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0.5, 0]], 
           StyleBox[
            RowBox[{"(*", "EXPOSED", "*)"}],
            FontColor->RGBColor[1, 0, 1]], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0, 1],
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{
            StyleBox[
             RowBox[{
              RowBox[{"Ex", "'"}], "[", "t", "]"}],
             FontColor->GrayLevel[0]], 
            StyleBox["\[Equal]",
             FontColor->GrayLevel[0]], 
            RowBox[{
             StyleBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{"kv", "+", " ", 
                 RowBox[{"ke", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Ex", "[", "t", "]"}]}], "+", 
                 RowBox[{"ki", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Inf", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"S", "[", "t", "]"}]}],
              FontColor->GrayLevel[0]], 
             StyleBox["-",
              FontColor->GrayLevel[0]], 
             RowBox[{
              RowBox[{
               StyleBox["(",
                FontColor->GrayLevel[0]], 
               RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "*", 
              RowBox[{"Ex", "[", "t", "]"}]}]}]}], ",", 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{"(*", " ", "INFECTED", "*)"}], 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{
            RowBox[{
             RowBox[{"Inf", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Alpha]", "*", 
              RowBox[{"Ex", "[", "t", "]"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Gamma]", "*", "r"}], "+", 
                RowBox[{"\[Delta]", "*", "g"}], "+", 
                RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
              RowBox[{"Inf", "[", "t", "]"}]}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "ACTIVE", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"A", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Epsilon]", "*", "a", "*", 
              RowBox[{"Inf", "[", "t", "]"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Delta]", "*", 
                 StyleBox["p",
                  FontColor->RGBColor[1, 0, 0]]}], 
                StyleBox["+",
                 FontColor->RGBColor[1, 0, 0]], 
                RowBox[{"\[Gamma]", "*", 
                 StyleBox[
                  RowBox[{"(", 
                   RowBox[{"1", "-", "p"}], ")"}],
                  FontColor->RGBColor[1, 0, 0]]}]}], ")"}], "*", 
              RowBox[{"A", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
           
           RowBox[{"(*", " ", "RECOVERED", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"R", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Beta]", "*", 
              RowBox[{"Ex", "[", "t", "]"}]}], "+", 
             RowBox[{"\[Gamma]", "*", 
              StyleBox["r",
               FontColor->RGBColor[1, 0, 0]], 
              StyleBox["*",
               FontColor->RGBColor[1, 0, 0]], 
              RowBox[{"Inf", "[", "t", "]"}]}], "+", 
             RowBox[{"\[Gamma]", "*", 
              StyleBox[
               RowBox[{"(", 
                RowBox[{"1", "-", "p"}], ")"}],
               FontColor->RGBColor[1, 0, 0]], "*", 
              RowBox[{"A", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "DEAD", " ", "*)"}], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0.5, 0]], 
           RowBox[{
            RowBox[{
             RowBox[{"d", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"\[Delta]", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"g", "*", 
                RowBox[{"Inf", "[", "t", "]"}]}], "+", 
               RowBox[{
                StyleBox["p",
                 FontColor->RGBColor[1, 0, 0]], "*", " ", 
                RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}]}], ",", " ", 
           RowBox[{"(*", 
            RowBox[{
            "0.1", " ", "pq", " ", "es", " ", "el", " ", "10", " ", "por", 
             " ", "ciento", " ", "de", " ", "los", " ", "infectados"}], 
            "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{"(*", " ", 
            RowBox[{"INITIAL", " ", "CONDITIONS"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"S", "[", "0", "]"}], "\[Equal]", "PM"}], ",", 
           RowBox[{
            RowBox[{"Ex", "[", "0", "]"}], "\[Equal]", "0"}], ",", " ", 
           RowBox[{
            RowBox[{"Inf", "[", "0", "]"}], "\[Equal]", "3"}], ",", 
           RowBox[{
            RowBox[{"A", "[", "0", "]"}], "\[Equal]", "0.0"}], ",", 
           RowBox[{
            RowBox[{"R", "[", "0", "]"}], "\[Equal]", "0.0"}], ",", 
           RowBox[{
            RowBox[{"d", "[", "0", "]"}], "\[Equal]", "0.0"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"S", ",", "Ex", ",", "Inf", ",", "A", ",", "R", ",", "d"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
         RowBox[{"Method", "\[Rule]", "\"\<StiffnessSwitching\>\""}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "7"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "6"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"REPRESENTATION", " ", "AND", " ", "PLOTS"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"QQ1", "=", 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{
              StyleBox["Plot",
               FontColor->RGBColor[1, 0.5, 0]], 
              StyleBox["[",
               FontColor->RGBColor[1, 0.5, 0]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox["[",
                 FontColor->RGBColor[1, 0.5, 0]], 
                RowBox[{
                 RowBox[{
                  StyleBox["{",
                   FontColor->RGBColor[1, 0.5, 0]], 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Inf", "[", "t", "]"}], ";", 
                    StyleBox[
                    RowBox[{"Ex", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[";",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[
                    RowBox[{"R", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]]}], 
                   StyleBox[",",
                    FontColor->RGBColor[1, 0.5, 0]], 
                   StyleBox[
                    RowBox[{"d", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], ",", 
                   RowBox[{
                    RowBox[{"A", "[", "t", "]"}], ";", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"R", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox["+",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[
                    RowBox[{"d", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox["+",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    RowBox[{"A", "[", "t", "]"}]}]}]}], 
                  StyleBox["}",
                   FontColor->RGBColor[1, 0.5, 0]]}], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[" ",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\t",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "\"\<Inf[t]\>\"", ";", "\"\<Ex[t]\>\"", ";", 
                    "\"\<R[t]\>\""}], ",", "\"\<d[t]\>\"", ",", 
                   "\"\<A[t]\>\"", ",", "\"\<R[t]+d[t]+A[t]\>\""}], "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[" ",
                FontColor->RGBColor[1, 0.5, 0]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"5", ",", "tshow"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "cota"}], "}"}]}], "}"}],
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"Thickness", "[", ".003725", "]"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "12", ",", "2"}], "}"}], "]"}]}], "}"}],
                     ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Green", "[", "1.5", "]"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".007251", "]"}]}], "}"}], ";", 
                    
                    RowBox[{"{", 
                    RowBox[{"Orange", 
                    RowBox[{"(*", "Blue", "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Orange", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ",", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Cyan", ",", 
                    RowBox[{"Thickness", "[", ".01051", "]"}]}], "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Orange", 
                    RowBox[{"(*", "Black", "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Green", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "12"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               RowBox[{
                StyleBox["GridLines",
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0.5, 0]], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"38200", ",", "120000"}], 
                   RowBox[{"(*", "65200", "*)"}], "}"}]}], "}"}]}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dotted", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotRange", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"0.7", "*", "tmax"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "None"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FillingStyle", "->", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.1", "]"}], ",", "Blue"}], 
                  "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]]}], 
              StyleBox["]",
               FontColor->RGBColor[1, 0.5, 0]]}], 
             StyleBox[",",
              FontColor->RGBColor[1, 0.5, 0]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[1, 0.5, 0]], 
             RowBox[{"DateListPlot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "DatosFallecidos", ",", "DatosRecuperados", ",", 
                 "DatosAcumulados"}], "}"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotTheme", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Bussiness\>\"", ",", "\"\<OpenMarkersThick\>\""}], 
                  "}"}]}],
                FontColor->RGBColor[0, 0, 1]]}], "]"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           StyleBox["Plot",
            FontColor->RGBColor[1, 0, 0]], 
           StyleBox["[",
            FontColor->RGBColor[1, 0, 0]], 
           RowBox[{
            RowBox[{
             StyleBox["Evaluate",
              FontColor->RGBColor[1, 0, 0]], 
             StyleBox["[",
              FontColor->RGBColor[0, 0, 1]], 
             RowBox[{
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox[
                 RowBox[{"Inf", "[", "t", "]"}],
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[",",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"Ex", "[", "t", "]"}],
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["/.",
               FontColor->RGBColor[1, 0.5, 0]], 
              StyleBox["s",
               FontColor->RGBColor[1, 0.5, 0]]}], 
             StyleBox["]",
              FontColor->RGBColor[1, 0.5, 0]]}], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[" ",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\t",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             StyleBox["PlotLegends",
              FontColor->RGBColor[1, 0, 0]], 
             StyleBox["\[Rule]",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<S\>\"", ";", "\"\<Inf\>\""}], ",", 
                "\"\<Ex\>\""}], "}"}],
              FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             StyleBox["PlotRange",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox["\[Rule]",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox["All",
              FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"ImageSize", "\[Rule]", "450"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", "Black", "}"}], ";", 
                 RowBox[{"{", 
                  RowBox[{"Red", 
                   RowBox[{"(*", 
                    RowBox[{"Blue", "[", "2", "]"}], "*)"}], ",", 
                   RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Green", "[", "1.5", "]"}], 
                  RowBox[{"(*", "Red", "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"5", ",", "3", ",", "3"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".003745", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Magenta", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Black", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", "DotDashed",
                   ",", 
                  RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], "}"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"Frame", "->", "True"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"GridLines", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "130", "}"}], ",", "None"}], "}"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"GridLinesStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             FormBox[
              RowBox[{"\[IndentingNewLine]", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<infection probability\>\"", ",", "30"}], 
                    "]"}], "]"}]}], "}"}]}]}],
              TraditionalForm],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FrameStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
               "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FrameTicksStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "20"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"Filling", "\[Rule]", "Axis"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FillingStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]]}], 
           StyleBox["]",
            FontColor->RGBColor[1, 0, 0]]}]}], "}"}], ",", 
        RowBox[{
         StyleBox["{",
          FontColor->RGBColor[0, 0, 1]], " ", 
         RowBox[{
          RowBox[{"Q1", "=", 
           RowBox[{
            StyleBox["Show",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["[",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             RowBox[{
              StyleBox["ListPlot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               StyleBox[
                RowBox[{"{", 
                 RowBox[{
                 "CasosACTIVOS", ",", "CasosPORdiaHOPKINS", ",", 
                  "CASOSporDIAresta"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotMarkers", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Automatic", ",", "12"}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "tshow"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "117800"}], "}"}]}], "}"}],
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"DIAMX", ",", "Red"}], "}"}], "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}], 
             StyleBox[",",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox[
              RowBox[{"(*", "THEORETICAL", "*)"}],
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[0, 0, 1]], 
             RowBox[{
              StyleBox["Plot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["[",
                 FontColor->RGBColor[0, 0, 1]], 
                RowBox[{
                 StyleBox[
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"A", "[", "t", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Gamma]", "*", "r"}], "+", 
                    RowBox[{"\[Delta]", "*", "g"}], "+", 
                    RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", "t"}], "}"}]}], "]"}], "-", 
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", 
                    RowBox[{"t", "-", "1"}]}], "}"}]}], "]"}]}], ")"}]}], ",", 
                    RowBox[{"0.4", "*", 
                    RowBox[{"A", "[", "t", "]"}]}]}], "}"}],
                  FontColor->RGBColor[0, 0, 1]], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\t",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<S\>\"", ";", "\"\<A[t]\>\""}], ",", 
                   "\"\<Casos por d\[IAcute]a\>\""}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotRange", "\[Rule]", "Automatic"}],
                FontColor->RGBColor[1, 0, 1]], 
               RowBox[{
                StyleBox["(*",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "370"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "35000"}], "}"}]}], "}"}],
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["*)",
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", "Black", "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Orange", 
                    RowBox[{"(*", "Black", "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}]}], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{"Orange", 
                    RowBox[{"(*", "Red", "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Black", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Black", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    "DotDashed", ",", 
                    RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", "98", "}"}], ",", "None"}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FillingStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}]}], 
            StyleBox["]",
             FontColor->RGBColor[0, 0, 1]]}]}], 
          StyleBox[",",
           FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->RGBColor[0, 0, 1]], 
          RowBox[{
           StyleBox["Plot",
            FontColor->RGBColor[0, 0, 1]], 
           StyleBox["[",
            FontColor->RGBColor[0, 0, 1]], 
           RowBox[{
            RowBox[{
             StyleBox["Evaluate",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox["[",
              FontColor->RGBColor[0, 0, 1]], 
             RowBox[{
              StyleBox[
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"ki", "*", 
                  FractionBox[
                   RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Inf", "[", "t", "]"}]}], "PM"]}], ",", 
                 RowBox[{"ke", "*", 
                  FractionBox[
                   RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Ex", "[", "t", "]"}]}], "PM"]}], ",", 
                 RowBox[{
                  FractionBox["1", "1000"], 
                  FractionBox[
                   RowBox[{"Ex", "[", "t", "]"}], 
                   RowBox[{"Inf", "[", "t", "]"}]]}]}], "}"}],
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["/.",
               FontColor->RGBColor[1, 0.5, 0]], 
              StyleBox["s",
               FontColor->RGBColor[1, 0.5, 0]]}], 
             StyleBox["]",
              FontColor->RGBColor[1, 0.5, 0]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\t",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"PlotLegends", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                "\"\<S\>\"", ";", 
                 "\"\<ki*\!\(\*FractionBox[\(S[t]*Inf[t]\), \(PM\)]\)\>\""}], 
                ",", "\"\<ke*\!\(\*FractionBox[\(S[t]*Ex[t]\), \(PM\)]\)\>\"",
                 ",", "\"\<\!\(\*FractionBox[\(1\), \
\(1000\)]\)\!\(\*FractionBox[\(Ex[t]\), \(Inf[t]\)]\)\>\""}], "}"}]}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             StyleBox["PlotRange",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox["\[Rule]",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "98"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.001"}], ",", "0.0215000"}], "}"}]}], "}"}],
              FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"ImageSize", "\[Rule]", "450"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", "Black", "}"}], ";", 
                 RowBox[{"{", 
                  RowBox[{"Blue", 
                   RowBox[{"(*", 
                    RowBox[{"Blue", "[", "2", "]"}], "*)"}], ",", 
                   RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"Red", 
                  RowBox[{"(*", "Red", "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"2", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".00745", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Magenta", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Black", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", "DotDashed",
                   ",", 
                  RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], "}"}]}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"Frame", "->", "True"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"GridLines", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "98", "}"}], ",", "None"}], "}"}]}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"GridLinesStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             FormBox[
              RowBox[{"\[IndentingNewLine]", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<infection probability\>\"", ",", "30"}], 
                    "]"}], "]"}]}], "}"}]}]}],
              TraditionalForm],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"FrameStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
               "]"}]}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"FrameTicksStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "20"}], "]"}]}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"Filling", "\[Rule]", "Axis"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"FillingStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], "]"}]}],
             FontColor->RGBColor[0, 0, 1]]}], 
           StyleBox["]",
            FontColor->RGBColor[0, 0, 1]]}], 
          StyleBox[",",
           FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->RGBColor[0, 0, 1]], 
          RowBox[{
           StyleBox["D1",
            FontColor->RGBColor[0, 0, 1]], 
           StyleBox["=",
            FontColor->RGBColor[0, 0, 1]], 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{
              StyleBox["ListPlot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               StyleBox[
                RowBox[{"{", "CASOSporDIAresta", "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "tshow"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "9500"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "1.3"}], ",", 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"DIAMX", ",", "Red"}], "}"}], "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}], 
             StyleBox[",",
              FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
             RowBox[{
              StyleBox["Plot",
               FontColor->GrayLevel[0]], 
              StyleBox["[",
               FontColor->GrayLevel[0]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->GrayLevel[0]], 
                StyleBox["[",
                 FontColor->GrayLevel[0]], 
                RowBox[{
                 StyleBox[
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Gamma]", "*", "r"}], "+", 
                    RowBox[{"\[Delta]", "*", "g"}], "+", 
                    RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", "t"}], "}"}]}], "]"}], "-", 
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", 
                    RowBox[{"t", "-", "1"}]}], "}"}]}], "]"}]}], ")"}]}], 
                   "}"}],
                  FontColor->GrayLevel[0]], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[
                RowBox[{"(*", 
                 RowBox[{"Evaluate", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ki", "*", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Inf", "[", "t", "]"}]}], "PM"]}], ",", 
                    RowBox[{"ke", "*", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Ex", "[", "t", "]"}]}], "PM"]}], ",", 
                    RowBox[{
                    FractionBox["1", "1000"], 
                    FractionBox[
                    RowBox[{"Ex", "[", "t", "]"}], 
                    RowBox[{"Inf", "[", "t", "]"}]]}]}], "}"}], "/.", "s"}], 
                  "]"}], "*)"}],
                FontColor->GrayLevel[0.5]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\t",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<S\>\"", ";", "\"\<casos diarios\>\""}], 
                  RowBox[{"(*", 
                   RowBox[{
                   "\"\<ki*\!\(\*FractionBox[\(S[t]*Inf[t]\), \(PM\)]\)\>\"", 
                    ",", "\"\<ke*\!\(\*FractionBox[\(S[t]*Ex[t]\), \
\(PM\)]\)\>\"", ",", 
                    "\"\<\!\(\*FractionBox[\(1\), \
\(1000\)]\)\!\(\*FractionBox[\(Ex[t]\), \(Inf[t]\)]\)\>\""}], "*)"}], "}"}]}],
                
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[" ",
                FontColor->GrayLevel[0]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["Automatic",
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", "Black", "}"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"Orange", 
                    RowBox[{"(*", "Red", "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}]}], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{"Red", 
                    RowBox[{"(*", "Red", "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "5", ",", "2"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".003745", "]"}]}], "}"}], ",", 
                   
                   RowBox[{"{", 
                    RowBox[{"Magenta", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Black", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    "DotDashed", ",", 
                    RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", "98", "}"}], ",", "None"}], "}"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<infection probability\>\"", ",", "30"}], 
                    "]"}], "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FillingStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], 
                  "]"}]}],
                FontColor->GrayLevel[0]]}], 
              StyleBox["]",
               FontColor->GrayLevel[0]]}]}], "\[IndentingNewLine]", "]"}]}]}], 
         StyleBox["\[IndentingNewLine]",
          FontColor->RGBColor[0, 0, 1]], 
         StyleBox["}",
          FontColor->RGBColor[0, 0, 1]]}]}], 
       StyleBox["}",
        FontColor->RGBColor[0, 0, 1]]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<PLOT BOUND\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cota", ",", "972000", ",", "\"\<cota\>\""}], "}"}], ",", "5", 
     ",", "2390000"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<MAXIMAL TIME\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmax", ",", "tshow", ",", "\"\<tmax\>\""}], "}"}], ",", "10", 
     ",", "600"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<SHOW TIME\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tshow", ",", "579", ",", "\"\<tshow\>\""}], "}"}], ",", "10", 
     ",", "600"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<HOUSE CONFINEMENT START\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tic", ",", "23", ",", "\"\<tic\>\""}], "}"}], ",", "10", ",", 
     "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<ECONOMIC PRESSURE INATTENTION\>\"", ",", "12", ",", "Bold"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tds2", ",", "51", ",", "\"\<tds2\>\""}], "}"}], ",", "30", ",",
      "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<END-DOWN HOME CONFINEMENT\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tf2", ",", "90", ",", "\"\<tf2\>\""}], "}"}], ",", "30", ",", 
     "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<INFECTION RATE DECREASE AT ti\>\"", ",", "12", ",", "Bold"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]ki", ",", "0.25", 
       RowBox[{"(*", 
        RowBox[{"de", " ", "uno", " ", "solo", " ", "es", " ", "0.41"}], 
        "*)"}], ",", "\"\<\[CapitalDelta]ki\>\""}], "}"}], ",", "0", ",", 
     "2"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<INFECTION RATE INCREASE AT tds2\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]kds2", ",", "0.23", ",", 
       "\"\<\[CapitalDelta]kds2\>\""}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<INFECTION RATE INCREASE AT HC END at tf2\>\"", ",", "12", ",", 
     "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]kf2", ",", "0.0", ",", "\"\<\[CapitalDelta]kf2\>\""}], 
      "}"}], ",", "0", ",", "50"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"PARAMETERS", " ", "SUSCEPTIBLE"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"SUSCEPTIBLE\",FontColor->GrayLevel[0]]\)\>\"", ",", 
     "12", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "0", ",", "\"\<\[Mu]\>\""}], "}"}], ",", "0.0", 
     ",", "0.0000006"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PM", ",", 
       RowBox[{"900", "*", 
        SuperscriptBox["10", "3"]}], 
       RowBox[{"(*", 
        RowBox[{"1500", "*", 
         SuperscriptBox["10", "3"], " ", "ver", " ", "como", " ", "cambian", 
         " ", "ke", " ", "y", " ", "ki"}], "*)"}], ",", "\"\<PM\>\""}], "}"}],
      ",", "100", ",", 
     RowBox[{"130", "*", 
      SuperscriptBox["10", "5"]}]}], "}"}], ",", " ", 
   RowBox[{"(*", 
    RowBox[{
    "THE", " ", "ESTIMATION", " ", "OF", " ", "THE", " ", "NUMBER", " ", "OF",
      " ", "SUSCEPTIBLE", " ", "INDIVIDUALS"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kv", ",", "0.00012", ",", "\"\<kv\>\""}], "}"}], ",", 
     "0.0000001", ",", "0.51"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ke", ",", 
       RowBox[{"1.3", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "7"}]]}], 
       RowBox[{"(*", 
        RowBox[{"1.4", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "7"}]], " ", "BEFORE", " ", "CORRECTING", " ", "THE", 
         " ", "NUMBER", " ", "OF", " ", "RECOVERED860"}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"7.6", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"4.6", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "8"}]]}], "*)"}], ",", 
       "\"\<\!\(\*StyleBox[\"ke\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.00", ",", "0.00001"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ki", ",", 
       RowBox[{"1.05", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "7"}]]}], 
       RowBox[{"(*", 
        RowBox[{"1.1", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "7"}]], "BEFORE", " ", "CORRECTING", " ", "THE", " ", 
         "NUMBER", " ", "OF", " ", "RECOVERED860"}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"7.6", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"5.4", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "8"}]]}], "*)"}], ",", 
       "\"\<\!\(\*StyleBox[\"ki\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.00", ",", "0.00001"}], "}"}], ",", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"PARAMETERS", " ", "EXPOSED"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"EXPOSED\",FontColor->RGBColor[1, 0, 0]]\)\>\"", ",",
      "12", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "0.07", ",", "\"\<\[Alpha]\>\""}], "}"}], ",", 
     "0.0001", ",", "0.56"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Beta]", ",", "0.0", ",", "\"\<\[Beta]\>\""}], "}"}], ",", 
     "0.0", ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0.07", ",", "\"\<\[Epsilon]\>\""}], "}"}], 
     ",", "0.0", ",", "0.52"}], "}"}], ",", "Delimiter", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"PARAMETROS", " ", "INFECTED"}], ",", " ", 
     RowBox[{"RECOVERED", " ", "AND", " ", "DEAD"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<PARAMETERS \!\(\*StyleBox[\"I\",FontColor->GrayLevel[0.5]]\), R AND \
D\>\"", ",", "12", ",", "Bold"}], "]"}], ",", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<a+r+g=1\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "0.08", ",", "\"\<a\>\""}], "}"}], ",", "0.001", 
       ",", "0.61"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0.87", ",", "\"\<r\>\""}], "}"}], ",", "0.001", 
       ",", "1.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"g", ",", "0.05", ",", "\"\<g\>\""}], "}"}], ",", "0.001", 
       ",", "0.61"}], "}"}], ","}], "   ", 
    RowBox[{"(*", 
     RowBox[{
     "BEFORE", " ", "CORRECTING", " ", "THE", " ", "NUMEBR", " ", "OF", " ", 
      "RECOVERED"}], "*)"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0.15", ",", "\"\<a\>\""}], "}"}], ",", "0.001", ",", 
     "0.61"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", "0.81", ",", "\"\<r\>\""}], "}"}], ",", "0.001", ",", 
     "1.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", ",", "0.04", ",", "\"\<g\>\""}], "}"}], ",", "0.001", ",", 
     "0.61"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Gamma]", ",", "0.015", ",", "\"\<\[Gamma]\>\""}], "}"}], ",", 
     RowBox[{"7.6", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "9"}]]}], ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", "0.038", ",", "\"\<\[Delta]\>\""}], "}"}], ",", 
     RowBox[{"7.6", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "9"}]]}], ",", "0.16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["p",
        FontColor->GrayLevel[0]], ",", "0.09", ",", 
       "\"\<\!\(\*StyleBox[\"p\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.001", ",", "1.03"}], "}"}], ",", "Delimiter"}], "]"}]], "Input",
 CellChangeTimes->{{3.711729954340054*^9, 3.711729956324499*^9}, {
   3.711738971008939*^9, 3.711739003865344*^9}, {3.711739071037417*^9, 
   3.711739073781252*^9}, {3.712164671563403*^9, 3.7121647245927362`*^9}, {
   3.7121649553407907`*^9, 3.712164982647224*^9}, {3.712165387900572*^9, 
   3.712165388235567*^9}, {3.7121658711976223`*^9, 3.712165881043228*^9}, {
   3.712166061448382*^9, 3.712166151474473*^9}, {3.712274099753539*^9, 
   3.712274130071575*^9}, {3.712274280570286*^9, 3.712274331045611*^9}, {
   3.712274382535644*^9, 3.712274401902049*^9}, {3.713737129072657*^9, 
   3.713737166582645*^9}, {3.713737260799563*^9, 3.713737388466825*^9}, {
   3.713737454428985*^9, 3.7137374906047*^9}, {3.713737566576869*^9, 
   3.7137376029806433`*^9}, {3.713737658956127*^9, 3.713737669348387*^9}, {
   3.713738122417261*^9, 3.713738213406781*^9}, {3.713738363109664*^9, 
   3.713738376556579*^9}, {3.714077117026526*^9, 3.714077215134033*^9}, {
   3.714077270680789*^9, 3.714077288521551*^9}, {3.714077611146154*^9, 
   3.714077613892441*^9}, {3.714077748002359*^9, 3.714077786241764*^9}, {
   3.714077905595498*^9, 3.714077908897132*^9}, {3.714078543563571*^9, 
   3.714078554793433*^9}, {3.71407868294701*^9, 3.714078700083721*^9}, {
   3.714153549994382*^9, 3.7141535543193703`*^9}, {3.714153636150062*^9, 
   3.714153729234756*^9}, {3.7141538608724117`*^9, 3.7141538736245604`*^9}, {
   3.714154022538254*^9, 3.7141540755120077`*^9}, {3.714154213546674*^9, 
   3.714154214562076*^9}, {3.714154593540373*^9, 3.714154610274098*^9}, {
   3.714155228083674*^9, 3.7141552608320303`*^9}, {3.714155745380722*^9, 
   3.714155745485972*^9}, {3.7141557817788973`*^9, 3.714155785867587*^9}, {
   3.71415587815765*^9, 3.714155895192087*^9}, {3.7141559405292673`*^9, 
   3.714155955919264*^9}, {3.714156104670073*^9, 3.714156112073913*^9}, {
   3.7141562876058207`*^9, 3.7141563111267033`*^9}, {3.714156684779256*^9, 
   3.714156711074024*^9}, {3.714156760106388*^9, 3.714156798912208*^9}, {
   3.7141568351064167`*^9, 3.714156835324641*^9}, {3.714156962407461*^9, 
   3.714156967380425*^9}, {3.7141570136701612`*^9, 3.714157013845169*^9}, {
   3.7141573557611437`*^9, 3.7141573766467323`*^9}, {3.714157453862186*^9, 
   3.7141574715011587`*^9}, {3.71415752931112*^9, 3.714157549229629*^9}, {
   3.7142182106688547`*^9, 3.714218301450759*^9}, {3.714218720643467*^9, 
   3.7142187411565237`*^9}, {3.714218778588337*^9, 3.714218798530044*^9}, {
   3.714219061823141*^9, 3.714219062222157*^9}, {3.7142191073505173`*^9, 
   3.714219107748465*^9}, {3.71421916122999*^9, 3.714219184549033*^9}, {
   3.714220016628824*^9, 3.714220017491983*^9}, {3.714221875626923*^9, 
   3.714221875957148*^9}, {3.7142234934637003`*^9, 3.7142235922138147`*^9}, {
   3.714223658901909*^9, 3.714223689373168*^9}, {3.714223757116069*^9, 
   3.714223790667165*^9}, {3.7142238219221897`*^9, 3.7142238242659483`*^9}, {
   3.714224176109393*^9, 3.714224178484573*^9}, {3.714254957427874*^9, 
   3.714254990304831*^9}, {3.714255192399744*^9, 3.71425525692743*^9}, {
   3.7142558967880983`*^9, 3.7142560265826387`*^9}, {3.714480607780813*^9, 
   3.714480694764051*^9}, {3.7144816756794453`*^9, 3.714481705145686*^9}, {
   3.714481752207869*^9, 3.7144818923550997`*^9}, {3.7144819360517883`*^9, 
   3.7144822548085213`*^9}, {3.714482293945115*^9, 3.7144823155944967`*^9}, {
   3.7144823967523537`*^9, 3.71448240250736*^9}, {3.714482554835663*^9, 
   3.714482558973225*^9}, {3.714482591946042*^9, 3.714482632846595*^9}, {
   3.7144829762508917`*^9, 3.7144829767282887`*^9}, {3.714483335762742*^9, 
   3.714483338138266*^9}, {3.714483371050714*^9, 3.714483379709846*^9}, {
   3.7144835656192503`*^9, 3.714483584917036*^9}, {3.714483629367248*^9, 
   3.7144836685943832`*^9}, {3.714483763492577*^9, 3.714483812670677*^9}, {
   3.714483936705875*^9, 3.714483978240472*^9}, {3.714484016038878*^9, 
   3.714484036777749*^9}, {3.714484160784383*^9, 3.714484167464107*^9}, {
   3.714484265783801*^9, 3.714484286228016*^9}, {3.714484361896934*^9, 
   3.7144843643272142`*^9}, {3.714484619222576*^9, 3.714484656925007*^9}, {
   3.714484745111253*^9, 3.71448494340764*^9}, {3.714485121244102*^9, 
   3.714485284675353*^9}, {3.714485355583222*^9, 3.714485360863946*^9}, {
   3.714485833764636*^9, 3.71448587230623*^9}, {3.714486062143754*^9, 
   3.714486064403838*^9}, {3.7144861027240877`*^9, 3.714486118239365*^9}, {
   3.714486150266515*^9, 3.7144862013793364`*^9}, {3.714486390329928*^9, 
   3.714486390636106*^9}, {3.7144864572787533`*^9, 3.714486468900818*^9}, {
   3.714486526051447*^9, 3.7144865644872217`*^9}, {3.7144867818769293`*^9, 
   3.71448687388052*^9}, {3.7144869049769793`*^9, 3.7144869054731627`*^9}, {
   3.714487065468987*^9, 3.714487139819433*^9}, {3.714487183410347*^9, 
   3.71448738833537*^9}, {3.717349693320345*^9, 3.717349740453195*^9}, {
   3.717350079168056*^9, 3.717350086380246*^9}, {3.71845690929853*^9, 
   3.71845695398526*^9}, {3.7184572214710903`*^9, 3.718457222852251*^9}, {
   3.718816638664481*^9, 3.718816661542137*^9}, {3.718816800003872*^9, 
   3.718816865906147*^9}, {3.718817085865926*^9, 3.71881709162357*^9}, {
   3.718817176704772*^9, 3.718817270224373*^9}, {3.718817305763151*^9, 
   3.718817338336203*^9}, {3.718817370909346*^9, 3.718817387608567*^9}, {
   3.718817556716817*^9, 3.718817563675448*^9}, {3.7188331351875153`*^9, 
   3.718833582993123*^9}, {3.7188336605246277`*^9, 3.71883366642411*^9}, {
   3.718833795557376*^9, 3.7188338112253942`*^9}, {3.718833858783062*^9, 
   3.718833860507453*^9}, {3.718833938318581*^9, 3.718833993299055*^9}, {
   3.71883406564876*^9, 3.718834188554323*^9}, {3.718834340226613*^9, 
   3.7188343812737083`*^9}, {3.718834420356894*^9, 3.7188344223231564`*^9}, {
   3.718834458196169*^9, 3.718834580327383*^9}, {3.718834629078668*^9, 
   3.718834671951363*^9}, {3.718834811705233*^9, 3.71883481383969*^9}, {
   3.718835150774345*^9, 3.7188351982555532`*^9}, {3.718835291268371*^9, 
   3.718835298128435*^9}, {3.71883541892013*^9, 3.71883561316371*^9}, 
   3.718836177353386*^9, 3.7188363187304068`*^9, {3.7188372124374743`*^9, 
   3.71883721502043*^9}, 3.718920796592367*^9, {3.718921264274316*^9, 
   3.7189213106504717`*^9}, {3.718921727148834*^9, 3.718921770858821*^9}, {
   3.7189221315661488`*^9, 3.718922197028365*^9}, {3.718922284818552*^9, 
   3.718922329443248*^9}, {3.718923118932888*^9, 3.718923120772099*^9}, {
   3.795542833486764*^9, 3.7955428689584293`*^9}, {3.79554292552002*^9, 
   3.795542968561204*^9}, {3.795543050114479*^9, 3.795543121634713*^9}, {
   3.795543259490137*^9, 3.79554335328308*^9}, {3.7955434292288847`*^9, 
   3.7955434953754272`*^9}, {3.795543536550571*^9, 3.795543629443152*^9}, {
   3.7955436698698606`*^9, 3.7955437094943132`*^9}, {3.79554376062488*^9, 
   3.795543763574217*^9}, {3.795544091574581*^9, 3.795544181638977*^9}, {
   3.795544234105466*^9, 3.795544242376464*^9}, {3.7955442751855507`*^9, 
   3.7955443767703876`*^9}, {3.79554441525065*^9, 3.795544445418798*^9}, {
   3.795544481619906*^9, 3.795544737148284*^9}, {3.7955447830389547`*^9, 
   3.795544840901479*^9}, {3.795544880217484*^9, 3.795544943819026*^9}, {
   3.795544975865534*^9, 3.795545401715242*^9}, {3.795545442316824*^9, 
   3.795545545653615*^9}, {3.795545615465994*^9, 3.795545641856735*^9}, {
   3.795545806572172*^9, 3.7955458167863894`*^9}, {3.795545855026129*^9, 
   3.795545857301654*^9}, {3.795546016906817*^9, 3.795546020896883*^9}, {
   3.795546071523148*^9, 3.79554610355268*^9}, {3.795546149016691*^9, 
   3.795546149246221*^9}, {3.7955461803008957`*^9, 3.795546200161718*^9}, 
   3.7955463121976433`*^9, {3.79554639390663*^9, 3.795546484705008*^9}, {
   3.795546529562613*^9, 3.7955465576466427`*^9}, {3.795546623599684*^9, 
   3.7955467089033813`*^9}, {3.795546765817113*^9, 3.7955467745895567`*^9}, {
   3.795546804795845*^9, 3.7955468320431643`*^9}, {3.795547793519363*^9, 
   3.7955478434120903`*^9}, {3.79554906007896*^9, 3.795549068183605*^9}, {
   3.795549203657187*^9, 3.795549206627883*^9}, {3.795549314288898*^9, 
   3.795549366964684*^9}, 3.7955493999694977`*^9, {3.7955494796254063`*^9, 
   3.795549588248067*^9}, {3.795549626052507*^9, 3.795549671647861*^9}, {
   3.795549764337006*^9, 3.795549828495717*^9}, {3.795549889785903*^9, 
   3.795549959245913*^9}, {3.795549997418252*^9, 3.795550001665606*^9}, {
   3.7955500602511377`*^9, 3.795550096456211*^9}, {3.795550164870023*^9, 
   3.795550234078429*^9}, {3.795550274843696*^9, 3.795550287651503*^9}, {
   3.7955503188745613`*^9, 3.7955504671761637`*^9}, {3.795550500831319*^9, 
   3.795550501108577*^9}, {3.795550540770461*^9, 3.79555054106678*^9}, {
   3.795550642259984*^9, 3.795550696530199*^9}, {3.795550758856057*^9, 
   3.795550774570706*^9}, {3.795550839779332*^9, 3.795550867832979*^9}, {
   3.795550943571944*^9, 3.795550958371125*^9}, {3.7955513320814657`*^9, 
   3.7955513740830307`*^9}, {3.795551448524562*^9, 3.795551450610718*^9}, {
   3.7955515553295*^9, 3.795551556297287*^9}, {3.7955516013845243`*^9, 
   3.795551601838323*^9}, {3.7955516460941687`*^9, 3.795551671725256*^9}, {
   3.795551961421616*^9, 3.795551961736171*^9}, {3.795552291168591*^9, 
   3.7955522998775883`*^9}, {3.79555241213992*^9, 3.7955524512904243`*^9}, {
   3.7955524818950787`*^9, 3.795552482239216*^9}, {3.7955525224177*^9, 
   3.795552631029708*^9}, 3.795552666820373*^9, {3.795552772392921*^9, 
   3.7955527786726637`*^9}, {3.7955528956652412`*^9, 
   3.7955529051819363`*^9}, {3.7955529352005987`*^9, 3.7955529394172163`*^9}, 
   3.795552999243191*^9, {3.7955530372920237`*^9, 3.7955530488779497`*^9}, {
   3.795553082611936*^9, 3.795553089971964*^9}, {3.795619758878785*^9, 
   3.79561986744661*^9}, {3.7956201674531403`*^9, 3.795620291205554*^9}, {
   3.795621117321761*^9, 3.795621118054132*^9}, {3.79562116077145*^9, 
   3.7956211777577677`*^9}, {3.795621261114653*^9, 3.795621354689126*^9}, {
   3.795621425337575*^9, 3.7956214257403793`*^9}, {3.795621656777135*^9, 
   3.795621686537797*^9}, {3.795621746782164*^9, 3.795621759347026*^9}, {
   3.795621802584236*^9, 3.795621811032847*^9}, {3.7956218421093073`*^9, 
   3.795621842526598*^9}, {3.795621908343255*^9, 3.795621908747498*^9}, {
   3.795622025823073*^9, 3.795622038510187*^9}, {3.795622071711728*^9, 
   3.7956221001721363`*^9}, {3.795628535270376*^9, 3.795628577925654*^9}, {
   3.795628610605863*^9, 3.7956286433155622`*^9}, {3.795628679367074*^9, 
   3.795628707583602*^9}, {3.795628742783091*^9, 3.7956287459951067`*^9}, {
   3.795628787663509*^9, 3.795628801526518*^9}, {3.795628922522523*^9, 
   3.7956289456147547`*^9}, {3.79562906866321*^9, 3.795629141331089*^9}, {
   3.795629229443163*^9, 3.795629230245015*^9}, 3.7956296628177233`*^9, {
   3.7956297537535343`*^9, 3.79562976979946*^9}, {3.795629877018758*^9, 
   3.795629975815221*^9}, {3.7956301053017597`*^9, 3.795630135255445*^9}, {
   3.7956301932189417`*^9, 3.795630207161447*^9}, {3.795630238385459*^9, 
   3.795630321365858*^9}, {3.795630439800235*^9, 3.7956304475886*^9}, {
   3.795630515236383*^9, 3.795630522841693*^9}, {3.79563057851457*^9, 
   3.795630614623487*^9}, {3.7956306967809877`*^9, 3.795630728797262*^9}, {
   3.795630777418799*^9, 3.79563082718865*^9}, {3.7956309542611*^9, 
   3.795630960533284*^9}, {3.795631066538382*^9, 3.795631067658787*^9}, {
   3.795631264225235*^9, 3.795631264603104*^9}, {3.795631359712523*^9, 
   3.7956313726504927`*^9}, {3.795631497181748*^9, 3.795631500708872*^9}, {
   3.795631613554055*^9, 3.795631614332947*^9}, {3.795631768763275*^9, 
   3.7956318097362843`*^9}, {3.795631949939711*^9, 3.795631973448934*^9}, {
   3.795632015476939*^9, 3.795632016841352*^9}, {3.7956320752522583`*^9, 
   3.795632134585699*^9}, {3.795632172494339*^9, 3.7956322218183537`*^9}, {
   3.795633317991721*^9, 3.795633484183844*^9}, {3.795633561920763*^9, 
   3.795633628229082*^9}, {3.79563366217828*^9, 3.795633733418969*^9}, {
   3.7956338166385593`*^9, 3.795633855817371*^9}, {3.7956338954258432`*^9, 
   3.795633899505522*^9}, {3.795633947672361*^9, 3.795633947856947*^9}, {
   3.7956340930491257`*^9, 3.7956341061102533`*^9}, {3.7956342542349253`*^9, 
   3.795634260512282*^9}, {3.795634294529277*^9, 3.795634307223027*^9}, {
   3.7956343759492407`*^9, 3.7956343765209713`*^9}, {3.795634409994919*^9, 
   3.795634462146207*^9}, 3.79563461018738*^9, {3.795634651524535*^9, 
   3.795634653004127*^9}, {3.795634840615506*^9, 3.795634848639057*^9}, 
   3.795634998797332*^9, {3.795635079995406*^9, 3.795635107959752*^9}, {
   3.795635205986425*^9, 3.795635206343422*^9}, {3.795635252665676*^9, 
   3.795635253244371*^9}, 3.795635398156228*^9, 3.795635610749309*^9, {
   3.7956356537967587`*^9, 3.795635654338224*^9}, {3.795635793244348*^9, 
   3.795635824855201*^9}, {3.795635934068881*^9, 3.7956360044485703`*^9}, {
   3.795636097593938*^9, 3.7956361032554407`*^9}, {3.795636134463891*^9, 
   3.7956361727213182`*^9}, {3.795636252290803*^9, 3.795636252524802*^9}, {
   3.795636414294186*^9, 3.7956364365539703`*^9}, {3.795636473148243*^9, 
   3.7956364811840982`*^9}, {3.795782038550267*^9, 3.7957820425561323`*^9}, {
   3.795782158066917*^9, 3.795782190858387*^9}, {3.795782318071961*^9, 
   3.795782379459877*^9}, {3.795782409609447*^9, 3.795782430968006*^9}, {
   3.795782467107799*^9, 3.795782469777012*^9}, {3.795782528996743*^9, 
   3.795782541043078*^9}, {3.795782583486823*^9, 3.7957826400352182`*^9}, {
   3.7957827217478123`*^9, 3.795782780936268*^9}, {3.79578284243869*^9, 
   3.795782844526272*^9}, {3.7957828880539417`*^9, 3.795782908253017*^9}, {
   3.795782967365428*^9, 3.795782975150702*^9}, {3.7957830478185883`*^9, 
   3.79578304830961*^9}, 3.79578316061954*^9, {3.795783206263489*^9, 
   3.7957832755958433`*^9}, {3.795783336921857*^9, 3.795783373835546*^9}, 
   3.795783429996449*^9, {3.795783926568275*^9, 3.795783962362857*^9}, {
   3.7957841357063427`*^9, 3.7957841436143436`*^9}, {3.795784210681275*^9, 
   3.795784227507436*^9}, {3.795784275375592*^9, 3.7957843585651207`*^9}, {
   3.795784430402952*^9, 3.7957845764459*^9}, {3.7957846073810787`*^9, 
   3.79578464978973*^9}, {3.795784690186502*^9, 3.79578469557662*^9}, {
   3.795784726720399*^9, 3.79578477557012*^9}, {3.795784879537244*^9, 
   3.795784896727394*^9}, {3.795784931712525*^9, 3.7957849612629957`*^9}, {
   3.795785091865172*^9, 3.79578509352359*^9}, {3.7957851342284803`*^9, 
   3.795785202223896*^9}, {3.795785240601211*^9, 3.795785517246338*^9}, {
   3.7957855717382708`*^9, 3.795785691170412*^9}, {3.795785724811449*^9, 
   3.7957857456163883`*^9}, {3.795785780222782*^9, 3.795785857457346*^9}, {
   3.79578590881527*^9, 3.7957859385660753`*^9}, {3.7957860088510237`*^9, 
   3.7957860187191057`*^9}, {3.7957860799316063`*^9, 3.795786197387046*^9}, {
   3.79578626058457*^9, 3.795786342884363*^9}, {3.795786401088601*^9, 
   3.795786421582399*^9}, {3.795786491543186*^9, 3.795786493111671*^9}, {
   3.795786561005953*^9, 3.795786669933839*^9}, {3.7957867097704697`*^9, 
   3.7957867161298113`*^9}, {3.795786747371985*^9, 3.79578679880169*^9}, {
   3.795786897867231*^9, 3.795786917981254*^9}, {3.795786952349931*^9, 
   3.795787029015183*^9}, {3.795787070412734*^9, 3.7957870882648573`*^9}, {
   3.795787129608507*^9, 3.7957873221813183`*^9}, {3.795787462003189*^9, 
   3.795787503328148*^9}, {3.7957875436611223`*^9, 3.795787577010062*^9}, {
   3.795787631212851*^9, 3.7957876998340797`*^9}, {3.7957877422529573`*^9, 
   3.795787836704728*^9}, {3.7957878828711042`*^9, 3.795787886003565*^9}, {
   3.795788040892144*^9, 3.795788043815192*^9}, {3.79578812161808*^9, 
   3.795788292746806*^9}, {3.7957883797882843`*^9, 3.7957883850250273`*^9}, 
   3.795788461287445*^9, {3.795788496652103*^9, 3.795788509781102*^9}, {
   3.795788560811792*^9, 3.795788565974078*^9}, 3.795788701731401*^9, {
   3.795788860061337*^9, 3.79578887258953*^9}, {3.795788938469411*^9, 
   3.795788965083379*^9}, {3.795789086526349*^9, 3.795789121737391*^9}, {
   3.795789197027936*^9, 3.79578919804062*^9}, {3.795789235390772*^9, 
   3.7957892504128*^9}, {3.795789396553404*^9, 3.795789495191134*^9}, {
   3.7957895380845337`*^9, 3.795789614413537*^9}, {3.795789686063385*^9, 
   3.795789696532198*^9}, {3.795789732313293*^9, 3.795789785336784*^9}, 
   3.795789816211685*^9, {3.7957898590734053`*^9, 3.79578993557655*^9}, {
   3.7957900148586893`*^9, 3.795790067259357*^9}, {3.795790155133347*^9, 
   3.795790155336876*^9}, {3.795790212473962*^9, 3.7957902246112843`*^9}, {
   3.795790390463283*^9, 3.7957904766086617`*^9}, {3.795790515825863*^9, 
   3.7957905196037617`*^9}, 3.795790562923875*^9, 3.795790607603211*^9, {
   3.7957906537881947`*^9, 3.795790698528111*^9}, {3.7957907736974707`*^9, 
   3.7957907923333397`*^9}, {3.7957908325218153`*^9, 3.795790832719103*^9}, {
   3.7957908732771873`*^9, 3.795790893808628*^9}, {3.79579097657778*^9, 
   3.795790995378788*^9}, {3.795791075748415*^9, 3.795791105673283*^9}, {
   3.795791154627924*^9, 3.7957911812033052`*^9}, {3.795791239902069*^9, 
   3.79579124312953*^9}, {3.795791343901161*^9, 3.79579137222087*^9}, {
   3.795791407952795*^9, 3.795791487581029*^9}, {3.795791527029274*^9, 
   3.795791534845467*^9}, {3.795791699343894*^9, 3.795791699591612*^9}, 
   3.795791755176799*^9, {3.795791954410819*^9, 3.795792022417221*^9}, {
   3.795792056614357*^9, 3.795792069917982*^9}, 3.7957921218508167`*^9, {
   3.795792183610845*^9, 3.7957921837900057`*^9}, {3.795792250989039*^9, 
   3.79579226699269*^9}, {3.795792359012446*^9, 3.795792370768964*^9}, {
   3.795792424573536*^9, 3.7957924889027853`*^9}, {3.795792556135523*^9, 
   3.7957925792284813`*^9}, {3.795792644707506*^9, 3.795792648977167*^9}, {
   3.795792684767106*^9, 3.795792691401483*^9}, {3.795792834066074*^9, 
   3.795792842253647*^9}, {3.795792893016034*^9, 3.7957929166082363`*^9}, 
   3.795795069933032*^9, {3.795871800234085*^9, 3.795871800972404*^9}, {
   3.795872252446134*^9, 3.7958722653669853`*^9}, {3.795872306995584*^9, 
   3.795872308458313*^9}, {3.795872354899898*^9, 3.795872356566513*^9}, {
   3.7958723950608664`*^9, 3.7958723987124643`*^9}, {3.795884821169723*^9, 
   3.795884822513941*^9}, 3.795885284130666*^9, {3.795885757435296*^9, 
   3.795885757667183*^9}, {3.79588582512621*^9, 3.795885826973892*^9}, 
   3.795885988470344*^9, {3.795886192310576*^9, 3.795886192783255*^9}, {
   3.795886406104313*^9, 3.795886406377469*^9}, {3.7958864829633703`*^9, 
   3.795886484287353*^9}, {3.795886685833653*^9, 3.795886699210099*^9}, {
   3.7959619746843033`*^9, 3.795962079190208*^9}, {3.795962281801262*^9, 
   3.7959622930745993`*^9}, {3.795962396099584*^9, 3.795962412702341*^9}, {
   3.795962520729247*^9, 3.795962523393054*^9}, 3.795962555213168*^9, {
   3.79596263222163*^9, 3.795962669889114*^9}, {3.795962915781598*^9, 
   3.7959629195094643`*^9}, {3.795962971705114*^9, 3.795963127249728*^9}, {
   3.795963224793157*^9, 3.795963226627987*^9}, {3.795963281725286*^9, 
   3.795963415452134*^9}, {3.795963473425249*^9, 3.795963513818653*^9}, {
   3.7959635820623817`*^9, 3.795963712128467*^9}, {3.795963754910881*^9, 
   3.7959637593392553`*^9}, {3.795963978463779*^9, 3.795963982623062*^9}, {
   3.7959666351679993`*^9, 3.7959666571581*^9}, {3.795966793618206*^9, 
   3.795966793945874*^9}, 3.795967009845729*^9, 3.7959671283216667`*^9, {
   3.795967182576317*^9, 3.795967244988328*^9}, {3.795967321475349*^9, 
   3.795967321836473*^9}, {3.795967445386503*^9, 3.795967445809318*^9}, {
   3.795967513816394*^9, 3.795967519050474*^9}, {3.7959676927197523`*^9, 
   3.795967693114888*^9}, {3.795967736097077*^9, 3.795967752014271*^9}, {
   3.795973688438389*^9, 3.7959737159460773`*^9}, {3.7959743168115892`*^9, 
   3.79597432554944*^9}, {3.7959744107132673`*^9, 3.795974465293338*^9}, {
   3.795974523968869*^9, 3.7959745246391487`*^9}, {3.795974557761415*^9, 
   3.795974558503807*^9}, {3.795974691548337*^9, 3.795974693749115*^9}, {
   3.795974823787969*^9, 3.7959748429633207`*^9}, 3.795975595403973*^9, {
   3.795975863186112*^9, 3.795975864211837*^9}, {3.795976048360815*^9, 
   3.795976050698009*^9}, {3.795976391963375*^9, 3.795976395653542*^9}, {
   3.795976873313151*^9, 3.795976878533328*^9}, 3.795977021027217*^9, 
   3.795977968770607*^9, {3.7959781961778793`*^9, 3.795978197801511*^9}, {
   3.795978310880726*^9, 3.795978311468658*^9}, 3.795978382391324*^9, 
   3.795978445228447*^9, {3.795978824109964*^9, 3.795978858036015*^9}, {
   3.7959788914687634`*^9, 3.795978920647616*^9}, {3.7959789774917088`*^9, 
   3.795978981707431*^9}, {3.79598065898599*^9, 3.7959806727971363`*^9}, {
   3.795980769872815*^9, 3.79598082792426*^9}, {3.795984537384864*^9, 
   3.795984693379177*^9}, {3.795984750695738*^9, 3.795984805027725*^9}, {
   3.795984886089673*^9, 3.79598492562556*^9}, {3.795985005324977*^9, 
   3.79598506521591*^9}, {3.795985103627927*^9, 3.795985104165694*^9}, {
   3.795985253089327*^9, 3.795985253333955*^9}, {3.795987665089242*^9, 
   3.795987667840519*^9}, {3.79598771784698*^9, 3.7959877845517673`*^9}, {
   3.795987832462161*^9, 3.795987833001898*^9}, {3.795987895554861*^9, 
   3.7959879014633207`*^9}, {3.795987946779649*^9, 3.7959879533421173`*^9}, {
   3.795988007547707*^9, 3.795988018366753*^9}, {3.79598808486059*^9, 
   3.7959881100792027`*^9}, {3.795988370836257*^9, 3.795988378327428*^9}, {
   3.79604319976866*^9, 3.796043203544798*^9}, {3.796063034107813*^9, 
   3.796063040666891*^9}, {3.796067755179847*^9, 3.796067802263405*^9}, {
   3.7960678629482937`*^9, 3.796067942509198*^9}, 3.7960680076913652`*^9, {
   3.79614399872834*^9, 3.7961440061692057`*^9}, {3.796144114063304*^9, 
   3.796144125360137*^9}, {3.796144351838642*^9, 3.7961443631417933`*^9}, 
   3.796144557902656*^9, {3.7961446252074738`*^9, 3.796144628890374*^9}, {
   3.796144744097889*^9, 3.796144745207116*^9}, {3.7961448753804617`*^9, 
   3.796144948334313*^9}, {3.7961450559452457`*^9, 3.796145061741774*^9}, {
   3.796145123936844*^9, 3.7961451261866417`*^9}, {3.7961451885587063`*^9, 
   3.796145251863511*^9}, {3.796145320444511*^9, 3.796145331588994*^9}, {
   3.796145391789847*^9, 3.7961454153941803`*^9}, {3.796145823491817*^9, 
   3.796145850845285*^9}, {3.796148166824999*^9, 3.796148221329546*^9}, 
   3.7961482682110767`*^9, {3.796148327682073*^9, 3.796148333663377*^9}, {
   3.796148426774181*^9, 3.796148439219535*^9}, {3.796148473621236*^9, 
   3.796148518362858*^9}, {3.796148587808404*^9, 3.796148589019163*^9}, {
   3.796148772516304*^9, 3.79614887158712*^9}, {3.796148954380567*^9, 
   3.7961489608349*^9}, {3.7961490533623667`*^9, 3.796149092203207*^9}, {
   3.796149324480781*^9, 3.796149324937952*^9}, 3.79614936300769*^9, {
   3.796149472118259*^9, 3.7961494824228277`*^9}, {3.796149822542852*^9, 
   3.796149843601817*^9}, {3.796150103253405*^9, 3.796150103559535*^9}, {
   3.796150382278118*^9, 3.7961504275863132`*^9}, {3.7961505105954227`*^9, 
   3.796150512387224*^9}, {3.79615066872824*^9, 3.796150697260598*^9}, {
   3.7961508191177187`*^9, 3.796150852190157*^9}, {3.796153296356193*^9, 
   3.796153305131878*^9}, 3.796153488333665*^9, {3.79615355500797*^9, 
   3.796153561657349*^9}, {3.796153613266623*^9, 3.796153613615288*^9}, {
   3.796153730075674*^9, 3.7961537303493433`*^9}, {3.796154678561607*^9, 
   3.796154690732443*^9}, 3.7961547265171213`*^9, {3.796154834823373*^9, 
   3.796154857645343*^9}, {3.7961553193122873`*^9, 3.796155334012926*^9}, {
   3.7961554988427963`*^9, 3.79615549979047*^9}, {3.796155608743649*^9, 
   3.7961556093953943`*^9}, {3.7961661135176077`*^9, 3.796166222112976*^9}, {
   3.796166515764112*^9, 3.796166516433709*^9}, {3.796166578851849*^9, 
   3.7961665794552717`*^9}, {3.796166619051751*^9, 3.796166636235293*^9}, {
   3.796167058728642*^9, 3.79616708290261*^9}, 3.796231628961974*^9, {
   3.79623173450136*^9, 3.796231748894548*^9}, {3.796232015211972*^9, 
   3.796232016643446*^9}, {3.796232056675623*^9, 3.796232059822484*^9}, {
   3.796232116089229*^9, 3.79623214102667*^9}, {3.7962324248969393`*^9, 
   3.796232477975512*^9}, {3.796232612117436*^9, 3.796232639781281*^9}, 
   3.7962369978912897`*^9, {3.796238414582427*^9, 3.796238414865282*^9}, {
   3.796238775038488*^9, 3.796238775818585*^9}, {3.796243243246073*^9, 
   3.7962432496462593`*^9}, {3.7962434258022537`*^9, 3.796243426047179*^9}, {
   3.796243861414206*^9, 3.7962438796430283`*^9}, {3.796243946365484*^9, 
   3.796243946628785*^9}, {3.796244023245954*^9, 3.7962440259268847`*^9}, {
   3.796244084379698*^9, 3.796244096911824*^9}, 3.796244505817897*^9, {
   3.796244734108919*^9, 3.796244734747982*^9}, {3.79624487019346*^9, 
   3.7962450631252213`*^9}, {3.79624512914935*^9, 3.7962453912196074`*^9}, {
   3.7962454234871798`*^9, 3.7962455292475653`*^9}, 3.796245588786468*^9, {
   3.7962456228575487`*^9, 3.796245686458912*^9}, {3.79624571779784*^9, 
   3.7962457297902803`*^9}, {3.796245790400628*^9, 3.79624582815373*^9}, 
   3.796245859361577*^9, {3.796245895663015*^9, 3.7962459432639303`*^9}, {
   3.7962461012150393`*^9, 3.796246128723042*^9}, 3.796246631594844*^9, 
   3.796253050325*^9, {3.7962530846306877`*^9, 3.7962530908424187`*^9}, {
   3.796295687503014*^9, 3.7962956884526367`*^9}, {3.7962957224563093`*^9, 
   3.796295722802951*^9}, {3.796295881455064*^9, 3.796295907619411*^9}, {
   3.7963060313992577`*^9, 3.7963060377093773`*^9}, {3.796306075438685*^9, 
   3.796306091145516*^9}, 3.796312418576045*^9, {3.796312479724236*^9, 
   3.796312517341816*^9}, {3.796312617702938*^9, 3.7963126221981077`*^9}, 
   3.796312689601602*^9, 3.796313007779277*^9, {3.796320176106082*^9, 
   3.7963201778803787`*^9}, {3.796320277642991*^9, 3.796320316294492*^9}, {
   3.796320549479745*^9, 3.7963205502556887`*^9}, {3.7963205815100613`*^9, 
   3.796320586718637*^9}, {3.796321407624894*^9, 3.796321437292712*^9}, {
   3.796321530363267*^9, 3.796321555882612*^9}, 3.7963216374723997`*^9, {
   3.796321711604445*^9, 3.796321713992167*^9}, {3.796321914280046*^9, 
   3.796322020161519*^9}, {3.7963221924036818`*^9, 3.796322211308152*^9}, {
   3.796322336681686*^9, 3.796322338345292*^9}, {3.796322391145218*^9, 
   3.796322392749201*^9}, {3.796322579576172*^9, 3.79632260108709*^9}, {
   3.796322735206897*^9, 3.7963227368883657`*^9}, {3.796322778177374*^9, 
   3.796322780013464*^9}, {3.796322834845953*^9, 3.796322837340107*^9}, {
   3.796322871017562*^9, 3.796322873170538*^9}, 3.796322915626602*^9, 
   3.796323069184888*^9, {3.796323143519342*^9, 3.796323144206091*^9}, 
   3.796323265376017*^9, {3.7963234179379473`*^9, 3.796323429927505*^9}, {
   3.796323620800558*^9, 3.796323647117614*^9}, {3.796323712777069*^9, 
   3.796323718076236*^9}, {3.796323920358451*^9, 3.796323937382332*^9}, 
   3.796323983791066*^9, {3.796324817671887*^9, 3.796324878522645*^9}, 
   3.7963252371975317`*^9, {3.796325268402731*^9, 3.796325315880575*^9}, {
   3.796325373433333*^9, 3.796325373633217*^9}, {3.796325474975294*^9, 
   3.796325507479507*^9}, {3.796325640104815*^9, 3.796325641751205*^9}, {
   3.796325679596095*^9, 3.796325791839862*^9}, {3.7963258545741043`*^9, 
   3.7963258695643587`*^9}, {3.796325908681182*^9, 3.7963259175172987`*^9}, {
   3.796325954800275*^9, 3.796325956141366*^9}, {3.796326012670237*^9, 
   3.796326017037485*^9}, {3.796326052000165*^9, 3.7963260566486807`*^9}, {
   3.796326136209002*^9, 3.7963261638541517`*^9}, {3.7963262416256*^9, 
   3.796326243029296*^9}, {3.796326273740347*^9, 3.796326322798009*^9}, {
   3.796326353027561*^9, 3.796326405505189*^9}, {3.796326604958446*^9, 
   3.79632661970893*^9}, {3.796326699933466*^9, 3.796326723767906*^9}, {
   3.796326844436062*^9, 3.796326847041471*^9}, {3.79632692719629*^9, 
   3.796326929295024*^9}, {3.796327741733053*^9, 3.796327741886134*^9}, {
   3.796328079987413*^9, 3.79632808284973*^9}, {3.7963326614348593`*^9, 
   3.796332666433504*^9}, {3.796332709057082*^9, 3.7963327478045797`*^9}, {
   3.796333211204359*^9, 3.796333211554408*^9}, {3.7963405628734426`*^9, 
   3.796340564909905*^9}, {3.796341543151524*^9, 3.796341652082521*^9}, {
   3.796342645848969*^9, 3.796342674295545*^9}, {3.796343896961636*^9, 
   3.7963439905093327`*^9}, {3.796344165315167*^9, 3.7963441704669724`*^9}, {
   3.796344332610862*^9, 3.796344340714231*^9}, {3.796390038370837*^9, 
   3.796390039831195*^9}, 3.7963900779044857`*^9, {3.796395459850585*^9, 
   3.79639553646961*^9}, {3.7963955690362997`*^9, 3.796395596373686*^9}, {
   3.796395709488295*^9, 3.7963957654063177`*^9}, {3.796396979988605*^9, 
   3.796397010922391*^9}, {3.796397152208412*^9, 3.796397155262257*^9}, {
   3.7963977978902884`*^9, 3.796397799374259*^9}, {3.79639799098955*^9, 
   3.796398000406397*^9}, {3.796398124997229*^9, 3.796398133248746*^9}, {
   3.796398246532144*^9, 3.79639826656104*^9}, {3.796398487738199*^9, 
   3.796398488114697*^9}, {3.796398582952883*^9, 3.796398583301922*^9}, {
   3.7963987942930317`*^9, 3.7963988025136433`*^9}, {3.796398946747178*^9, 
   3.796398954069174*^9}, 3.796399023043483*^9, 3.796399069134364*^9, {
   3.796405380047564*^9, 3.79640542509791*^9}, {3.7964054556528482`*^9, 
   3.796405456852017*^9}, {3.796405497215869*^9, 3.79640551928345*^9}, {
   3.796405646157737*^9, 3.796405695830586*^9}, {3.7964059013194647`*^9, 
   3.79640590172852*^9}, {3.796406463975782*^9, 3.796406464289102*^9}, 
   3.796406634517487*^9, {3.796406830542366*^9, 3.79640687777203*^9}, {
   3.796406908392961*^9, 3.79640692224809*^9}, {3.7964074397208033`*^9, 
   3.796407447972662*^9}, {3.796407649275099*^9, 3.796407658907888*^9}, {
   3.7964796011541433`*^9, 3.796479663291363*^9}, {3.796479730768956*^9, 
   3.796479753092635*^9}, {3.7964798260751247`*^9, 3.796479834246826*^9}, {
   3.796479870101748*^9, 3.7964798734068108`*^9}, {3.796479930608502*^9, 
   3.796479933328643*^9}, {3.796480004398383*^9, 3.7964800209087667`*^9}, {
   3.796480105842852*^9, 3.7964801436081553`*^9}, 3.796481030819693*^9, {
   3.7964810623931093`*^9, 3.7964810626953297`*^9}, {3.796556708501318*^9, 
   3.796556733065422*^9}, {3.796556771397098*^9, 3.796556778233973*^9}, {
   3.796556889988076*^9, 3.796556919818345*^9}, {3.79659233677481*^9, 
   3.7965923802846727`*^9}, {3.7965925293877563`*^9, 3.7965925307733994`*^9}, 
   3.796654597696393*^9, {3.79666802052382*^9, 3.796668218771001*^9}, {
   3.796668251200507*^9, 3.796668361262661*^9}, 3.796738272247373*^9, {
   3.7967383974012003`*^9, 3.7967384092164307`*^9}, {3.796738456110004*^9, 
   3.796738761913396*^9}, {3.796738806009933*^9, 3.796738820797655*^9}, {
   3.796738851363085*^9, 3.796738889984967*^9}, {3.7967389361488533`*^9, 
   3.796738971243726*^9}, {3.7967392245044403`*^9, 3.796739727213695*^9}, {
   3.796739762765933*^9, 3.79674015503539*^9}, {3.796740189670969*^9, 
   3.796740246928989*^9}, {3.796740278116856*^9, 3.796740525984818*^9}, {
   3.796740565280779*^9, 3.796740601552693*^9}, 3.796740635734288*^9, {
   3.796740669195282*^9, 3.7967407057057447`*^9}, {3.796740788119376*^9, 
   3.796740808592654*^9}, {3.796740854214398*^9, 3.796740906591227*^9}, {
   3.796740992476697*^9, 3.796741046279108*^9}, {3.7967411317720623`*^9, 
   3.796741258897694*^9}, {3.7967414060500917`*^9, 3.7967414269790277`*^9}, {
   3.796741482775373*^9, 3.796741528976499*^9}, {3.796741576438642*^9, 
   3.796741576772429*^9}, {3.796741649131901*^9, 3.796741650515518*^9}, {
   3.796741774847653*^9, 3.796741777125358*^9}, {3.796741935435877*^9, 
   3.796742112021306*^9}, {3.796742195940216*^9, 3.7967422874274406`*^9}, {
   3.7967424357846727`*^9, 3.796742438589723*^9}, {3.796742533336337*^9, 
   3.796742533565712*^9}, {3.7968048978124933`*^9, 3.796804939424164*^9}, {
   3.7968049700235662`*^9, 3.796805019649291*^9}, {3.796805122434277*^9, 
   3.796805167809613*^9}, {3.796805223002586*^9, 3.796805309445763*^9}, {
   3.7968055326260843`*^9, 3.796805613728622*^9}, {3.796805665158646*^9, 
   3.796805684291008*^9}, {3.7968057205227957`*^9, 3.796805724941358*^9}, {
   3.796805955008699*^9, 3.796805958318574*^9}, {3.796808988166815*^9, 
   3.796808996408897*^9}, {3.796809067010097*^9, 3.796809072900189*^9}, {
   3.79680912568118*^9, 3.7968092004070883`*^9}, 3.7968092491142187`*^9, 
   3.796809288328081*^9, {3.796809537848546*^9, 3.796809599496406*^9}, 
   3.796809784968053*^9, {3.796809866898178*^9, 3.796809876225396*^9}, {
   3.796812391139627*^9, 3.796812392645032*^9}, {3.79681248172602*^9, 
   3.796812490704588*^9}, {3.796812599334545*^9, 3.796812601642305*^9}, {
   3.796812700067618*^9, 3.79681270144523*^9}, {3.796812819508095*^9, 
   3.796812934857085*^9}, {3.796813177833337*^9, 3.796813279932248*^9}, 
   3.796813375724963*^9, 3.796813435978589*^9, {3.796813519341599*^9, 
   3.796813534294628*^9}, {3.796813593760249*^9, 3.7968136297277946`*^9}, {
   3.796813734785721*^9, 3.7968137474405537`*^9}, {3.796813787515952*^9, 
   3.796813788095991*^9}, {3.7968138482616587`*^9, 3.796813894886375*^9}, {
   3.79681879064122*^9, 3.796818793515326*^9}, {3.796819001056975*^9, 
   3.796819001178825*^9}, {3.796819208828334*^9, 3.796819306318972*^9}, {
   3.79681936366368*^9, 3.7968193648365192`*^9}, {3.7968194145796833`*^9, 
   3.796819417355493*^9}, {3.796819470853385*^9, 3.7968194754589043`*^9}, {
   3.796819542779346*^9, 3.7968195703777943`*^9}, {3.7968196656757507`*^9, 
   3.796819747933282*^9}, {3.796819783997835*^9, 3.7968197847231503`*^9}, {
   3.7968198293751497`*^9, 3.7968198495490026`*^9}, {3.796819987286673*^9, 
   3.796820003538178*^9}, {3.796820127655285*^9, 3.796820128172372*^9}, {
   3.7968202052353077`*^9, 3.796820206500946*^9}, {3.796820318691392*^9, 
   3.7968203338351583`*^9}, {3.796820364274345*^9, 3.796820365584697*^9}, {
   3.796820633791767*^9, 3.796820674501563*^9}, {3.796820728254716*^9, 
   3.7968207295819073`*^9}, {3.79682077257821*^9, 3.7968207729998283`*^9}, 
   3.796820810911643*^9, 3.796820866931031*^9, {3.7968209122270737`*^9, 
   3.796820936140534*^9}, {3.796820990608367*^9, 3.796820991338565*^9}, {
   3.796821141883944*^9, 3.796821156395502*^9}, {3.7968212846096373`*^9, 
   3.7968212885288343`*^9}, {3.796821375096676*^9, 3.7968213919533157`*^9}, {
   3.796931537553316*^9, 3.796931543383704*^9}, {3.796931642517569*^9, 
   3.7969316450253983`*^9}, {3.796931681630418*^9, 3.796931681854556*^9}, {
   3.796931814146784*^9, 3.796931847651236*^9}, {3.796991806574266*^9, 
   3.796991809645267*^9}, {3.796991851848833*^9, 3.796991871064665*^9}, 
   3.797073666550186*^9, {3.797075896981628*^9, 3.797075927604439*^9}, 
   3.797076303676764*^9, {3.797076658123082*^9, 3.797076681144524*^9}, {
   3.797076866624199*^9, 3.7970768929518843`*^9}, {3.797077562550383*^9, 
   3.797077563094884*^9}, {3.7970776024943333`*^9, 3.797077717753242*^9}, {
   3.797077763921255*^9, 3.797077772479678*^9}, {3.797078039590054*^9, 
   3.797078201971435*^9}, 3.797078254890016*^9, {3.7970785674941177`*^9, 
   3.797078568625804*^9}, {3.797078814066539*^9, 3.797078826012979*^9}, {
   3.797078915194463*^9, 3.7970789213556013`*^9}, {3.797079319269014*^9, 
   3.797079361076722*^9}, {3.797079589419943*^9, 3.7970795971465263`*^9}, {
   3.797079984699819*^9, 3.7970800328775787`*^9}, {3.797080647829763*^9, 
   3.797080649061801*^9}, 3.797080682783218*^9, {3.797081383990143*^9, 
   3.7970814082085447`*^9}, {3.797081539687645*^9, 3.797081550050671*^9}, {
   3.797082598933827*^9, 3.79708260316754*^9}, {3.797082676616591*^9, 
   3.797082676791235*^9}, {3.797082735584399*^9, 3.7970827367532167`*^9}, {
   3.797082807024291*^9, 3.797082811753497*^9}, {3.7970828912871103`*^9, 
   3.797082891448464*^9}, 3.797082970191451*^9, {3.797083900018495*^9, 
   3.797083902290001*^9}, {3.797084100037778*^9, 3.797084132233449*^9}, {
   3.797084205766026*^9, 3.797084206228506*^9}, {3.7970844103886557`*^9, 
   3.797084412543486*^9}, {3.79708450863822*^9, 3.797084513075551*^9}, {
   3.797084562556757*^9, 3.7970845639503107`*^9}, 3.7971509800007763`*^9, {
   3.797152059780654*^9, 3.797152113368915*^9}, {3.7971521443851013`*^9, 
   3.797152238001814*^9}, {3.797152276706863*^9, 3.7971523726306257`*^9}, {
   3.7971525787645283`*^9, 3.797152592271656*^9}, {3.797152854615745*^9, 
   3.797153008670083*^9}, {3.797153081431325*^9, 3.79715308283892*^9}, {
   3.7971531146947727`*^9, 3.797153118017477*^9}, {3.7971531595005198`*^9, 
   3.797153166450404*^9}, {3.7971532226558437`*^9, 3.7971532606992598`*^9}, 
   3.797153296196397*^9, {3.79715336576832*^9, 3.797153410172029*^9}, {
   3.79715346311416*^9, 3.797153525523177*^9}, {3.79715356050222*^9, 
   3.7971537264725237`*^9}, {3.7971537601768227`*^9, 3.797153785552458*^9}, {
   3.7971538451158657`*^9, 3.797153867482833*^9}, {3.7971539297328176`*^9, 
   3.797153966006263*^9}, {3.797154115895673*^9, 3.797154134268285*^9}, {
   3.797154177214539*^9, 3.797154183116432*^9}, {3.7971542273611813`*^9, 
   3.797154231729492*^9}, {3.7971542737149153`*^9, 3.797154308335451*^9}, {
   3.79715447221484*^9, 3.7971544833880453`*^9}, {3.7971545360628843`*^9, 
   3.7971545694502974`*^9}, {3.797279823701016*^9, 3.797279943908739*^9}, {
   3.797280013180243*^9, 3.797280044517342*^9}, {3.797280092875927*^9, 
   3.79728038190973*^9}, {3.797281771016262*^9, 3.797281771537709*^9}, {
   3.797281805268008*^9, 3.797281996875202*^9}, {3.797282085588092*^9, 
   3.79728244810813*^9}, {3.7972825095130587`*^9, 3.7972825330720654`*^9}, {
   3.79728259325913*^9, 3.7972826095412703`*^9}, {3.797282641866208*^9, 
   3.797282705116404*^9}, {3.7972827566818943`*^9, 3.797282820801462*^9}, {
   3.797282871312702*^9, 3.797282950398149*^9}, {3.797323177917885*^9, 
   3.7973231793084717`*^9}, {3.797331526907288*^9, 3.7973315665022173`*^9}, {
   3.7973316356439257`*^9, 3.797331640809825*^9}, {3.7973321558640633`*^9, 
   3.797332172017865*^9}, 3.7973342536180353`*^9, {3.797334331280519*^9, 
   3.797334433832974*^9}, 3.7973344676113033`*^9, {3.797334562399995*^9, 
   3.797334564304772*^9}, {3.797334639360813*^9, 3.797334665816297*^9}, {
   3.7973411857020187`*^9, 3.797341213212006*^9}, {3.797341249783452*^9, 
   3.7973412848955107`*^9}, {3.7973413339435596`*^9, 
   3.7973413805093517`*^9}, {3.797341443585741*^9, 3.797341613960485*^9}, {
   3.7973418645708227`*^9, 3.797341865420638*^9}, {3.797344317676363*^9, 
   3.79734431859445*^9}, {3.797344941282493*^9, 3.797344945655978*^9}, {
   3.797345677556473*^9, 3.797345679983494*^9}, {3.797345911026229*^9, 
   3.797345921687931*^9}, {3.797346026147314*^9, 3.7973460486376266`*^9}, {
   3.797346113271574*^9, 3.7973461164422903`*^9}, {3.797346478325686*^9, 
   3.797346490691127*^9}, {3.797346546473172*^9, 3.797346563056287*^9}, {
   3.797346601314229*^9, 3.797346601631826*^9}, {3.797452062281499*^9, 
   3.797452088957478*^9}, {3.7974521368480577`*^9, 3.79745217020685*^9}, {
   3.7974522031831017`*^9, 3.797452298367546*^9}, {3.7974523411460543`*^9, 
   3.79745240817336*^9}, {3.797452442951818*^9, 3.797452468501882*^9}, {
   3.797452527429447*^9, 3.797452590561534*^9}, {3.797452731234803*^9, 
   3.797452775818915*^9}, {3.797452841857147*^9, 3.7974528652273397`*^9}, {
   3.79750889988455*^9, 3.797508902035038*^9}, 3.797510285577508*^9, {
   3.797510461881536*^9, 3.797510510249043*^9}, {3.79751056280264*^9, 
   3.797510568358157*^9}, {3.797510628693767*^9, 3.797510634774271*^9}, {
   3.797510676884959*^9, 3.797510706629484*^9}, {3.797510896859397*^9, 
   3.7975110093843927`*^9}, {3.797511057595298*^9, 3.797511187887596*^9}, {
   3.797511226992189*^9, 3.797511230612555*^9}, {3.7975112898157377`*^9, 
   3.797511290837018*^9}, {3.797513395319191*^9, 3.797513395796212*^9}, 
   3.797514595044245*^9, {3.797514839148265*^9, 3.7975148834683867`*^9}, {
   3.7975150496415033`*^9, 3.797515052598505*^9}, {3.797515261564253*^9, 
   3.797515276391506*^9}, 3.797515323732005*^9, {3.797515655503483*^9, 
   3.7975156808903418`*^9}, {3.797515799748616*^9, 3.797515800569579*^9}, {
   3.797515845906011*^9, 3.797515849462096*^9}, {3.797515892563311*^9, 
   3.797515892917997*^9}, {3.797515969428893*^9, 3.797516007057863*^9}, {
   3.797516104776205*^9, 3.797516128614258*^9}, {3.7975161586803827`*^9, 
   3.797516199469749*^9}, {3.797516236103451*^9, 3.797516251478285*^9}, {
   3.7975162899035482`*^9, 3.79751629003854*^9}, {3.797516450568507*^9, 
   3.797516451527853*^9}, {3.797516485762706*^9, 3.797516530667007*^9}, {
   3.7975168547993317`*^9, 3.797516888046973*^9}, {3.797517029800837*^9, 
   3.79751703890654*^9}, 3.797517137972332*^9, {3.7975172341350594`*^9, 
   3.79751723853578*^9}, {3.79751733189524*^9, 3.797517347924594*^9}, {
   3.7975175065480556`*^9, 3.797517512537572*^9}, {3.797517688549988*^9, 
   3.797517712211672*^9}, {3.797517756153391*^9, 3.797517756442523*^9}, 
   3.7975178357660513`*^9, {3.79751792410627*^9, 3.797517924757914*^9}, {
   3.7975180226803503`*^9, 3.7975180539530163`*^9}, {3.797529408919166*^9, 
   3.797529414480257*^9}, {3.7975294784399242`*^9, 3.797529478705274*^9}, {
   3.797529519491878*^9, 3.797529540344461*^9}, {3.797529634401084*^9, 
   3.797529639350875*^9}, {3.797529829138413*^9, 3.797529852517025*^9}, {
   3.797529936278328*^9, 3.797529940109424*^9}, {3.797537468216333*^9, 
   3.797537469379879*^9}, {3.797537555372847*^9, 3.797537612334179*^9}, {
   3.7975376452030573`*^9, 3.797537730208625*^9}, {3.797537769679658*^9, 
   3.797537829924582*^9}, {3.797537864300857*^9, 3.797537933033333*^9}, 
   3.7975379730271597`*^9, {3.797542077560934*^9, 3.7975421222004213`*^9}, {
   3.797542187373836*^9, 3.797542218607027*^9}, 3.797542320911854*^9, {
   3.797542365589259*^9, 3.797542454984345*^9}, {3.79754249660141*^9, 
   3.797542512519508*^9}, {3.7975425921046457`*^9, 3.797542593739625*^9}, {
   3.797542743298471*^9, 3.797542743472287*^9}, {3.797542880200425*^9, 
   3.7975428873915033`*^9}, {3.797543001637987*^9, 3.797543001937518*^9}, {
   3.797543233295743*^9, 3.797543255873967*^9}, {3.797543289752713*^9, 
   3.7975432901007137`*^9}, {3.797546966475492*^9, 3.797546974204281*^9}, {
   3.797547010909947*^9, 3.797547019209733*^9}, {3.797547201577248*^9, 
   3.797547207116785*^9}, {3.797547275623417*^9, 3.797547331434538*^9}, 
   3.7975476121154947`*^9, {3.797547659036018*^9, 3.79754769543145*^9}, {
   3.797547735526702*^9, 3.7975477367060423`*^9}, {3.797547795647458*^9, 
   3.797547880186749*^9}, {3.797547966509417*^9, 3.797547993574769*^9}, {
   3.7975481195478563`*^9, 3.797548137320519*^9}, {3.7975482810459642`*^9, 
   3.797548282373872*^9}, {3.7975484190851316`*^9, 3.79754841969634*^9}, {
   3.797548486994825*^9, 3.7975484872311583`*^9}, {3.7975486055636377`*^9, 
   3.797548608379395*^9}, {3.797548672896881*^9, 3.7975486857278023`*^9}, {
   3.797548845821978*^9, 3.7975488847692127`*^9}, {3.797549039078047*^9, 
   3.797549053200542*^9}, {3.79754911547482*^9, 3.797549119578959*^9}, {
   3.7975491661249723`*^9, 3.797549167027133*^9}, {3.797549301251759*^9, 
   3.7975493026491613`*^9}, {3.797549407866441*^9, 3.797549410077469*^9}, {
   3.797549466141035*^9, 3.797549466851076*^9}, {3.7975495447946033`*^9, 
   3.79754954542354*^9}, {3.797549593112043*^9, 3.797549595053529*^9}, {
   3.797549739794289*^9, 3.797549740809392*^9}, {3.79754986036379*^9, 
   3.797549871573689*^9}, {3.797549932488205*^9, 3.797549933315956*^9}, {
   3.797549965785204*^9, 3.79754999211331*^9}, {3.7975500789809303`*^9, 
   3.797550079380224*^9}, {3.797550209358759*^9, 3.797550209806868*^9}, {
   3.797582328117691*^9, 3.7975823641412354`*^9}, {3.797582683743925*^9, 
   3.797582720105393*^9}, {3.797582776236977*^9, 3.797582828491601*^9}, {
   3.797582872086775*^9, 3.797582903732768*^9}, {3.797582941052218*^9, 
   3.797582970725237*^9}, {3.797583269758548*^9, 3.7975832776375847`*^9}, {
   3.797583320740802*^9, 3.797583321437213*^9}, {3.797583501846838*^9, 
   3.797583511866633*^9}, {3.7975868553070383`*^9, 3.797586855549313*^9}, {
   3.797586921197991*^9, 3.7975869214402742`*^9}, {3.797586986775113*^9, 
   3.797586990254025*^9}, {3.797595147576544*^9, 3.7975951958896723`*^9}, {
   3.797595236593396*^9, 3.7975952386109333`*^9}, {3.7975952731963377`*^9, 
   3.797595275064049*^9}, {3.797595320340025*^9, 3.7975953375022297`*^9}, {
   3.797595443431616*^9, 3.7975954999061413`*^9}, {3.797595536794709*^9, 
   3.797595537492826*^9}, {3.797595619938777*^9, 3.797595624162072*^9}, {
   3.7975956643069563`*^9, 3.797595692795018*^9}, {3.7975957272881117`*^9, 
   3.7975957302374487`*^9}, {3.7975957742014523`*^9, 
   3.7975958403895683`*^9}, {3.7975959629136887`*^9, 3.797595963293755*^9}, {
   3.797596045994772*^9, 3.7975960815652103`*^9}, {3.797596641865744*^9, 
   3.797596692580517*^9}, {3.797596770371904*^9, 3.797596802696116*^9}, {
   3.797596910524218*^9, 3.797596918289496*^9}, {3.797597102357624*^9, 
   3.797597163583275*^9}, {3.797614968540452*^9, 3.797614972112502*^9}, {
   3.797615016345066*^9, 3.7976150917645617`*^9}, {3.7976177535743513`*^9, 
   3.797617807629401*^9}, {3.797618322642334*^9, 3.7976183694743443`*^9}, {
   3.7976184541407833`*^9, 3.797618455049944*^9}, {3.797621102285034*^9, 
   3.797621191398114*^9}, {3.7976212298492107`*^9, 3.797621240212597*^9}, {
   3.7976215470497913`*^9, 3.797621547267066*^9}, {3.79762160314944*^9, 
   3.7976216202905293`*^9}, {3.7976219403207607`*^9, 
   3.7976219745801077`*^9}, {3.79762206483994*^9, 3.7976220654190493`*^9}, {
   3.797622793643197*^9, 3.7976227939551363`*^9}, {3.797622925293058*^9, 
   3.797622965577745*^9}, {3.7976230147779493`*^9, 3.797623028676499*^9}, {
   3.79762310707235*^9, 3.797623126378867*^9}, 3.7976231768535423`*^9, {
   3.79762323256273*^9, 3.797623274203373*^9}, {3.79762331363022*^9, 
   3.7976233577458897`*^9}, {3.797623653198434*^9, 3.797623671168624*^9}, {
   3.797625069162697*^9, 3.7976250698921003`*^9}, {3.7976251078929243`*^9, 
   3.797625128599909*^9}, {3.797625166790689*^9, 3.797625225405677*^9}, {
   3.797625680689851*^9, 3.797625700322901*^9}, {3.797668001703609*^9, 
   3.7976680018562613`*^9}, {3.797669213262343*^9, 3.797669220685843*^9}, {
   3.797669258368204*^9, 3.797669262038989*^9}, {3.797669305350305*^9, 
   3.797669305504862*^9}, {3.797669418493626*^9, 3.7976695228080606`*^9}, {
   3.797669640680822*^9, 3.797669641586235*^9}, 3.797670037030305*^9, 
   3.797670157351447*^9, {3.7976702840367737`*^9, 3.797670287472938*^9}, {
   3.797670425106696*^9, 3.79767056995201*^9}, {3.797670626943626*^9, 
   3.797670627428151*^9}, 3.797670714607057*^9, {3.797672045578052*^9, 
   3.7976720474825974`*^9}, {3.797672115850759*^9, 3.79767212521134*^9}, {
   3.797672737048945*^9, 3.7976727786865396`*^9}, {3.797672876191622*^9, 
   3.797673012070644*^9}, {3.7976731606818857`*^9, 3.7976732032709227`*^9}, {
   3.797673344189068*^9, 3.797673350479871*^9}, {3.7976734930680513`*^9, 
   3.7976734969990273`*^9}, {3.797673533432909*^9, 3.797673560327662*^9}, {
   3.797674988078849*^9, 3.7976750644458847`*^9}, {3.797675112553336*^9, 
   3.79767512001392*^9}, 3.797720485419755*^9, {3.797754733469994*^9, 
   3.797754743412225*^9}, {3.797771957292604*^9, 3.7977719967746*^9}, {
   3.7977720938459578`*^9, 3.7977721040357933`*^9}, {3.797772252250134*^9, 
   3.79777233717181*^9}, {3.797772404947442*^9, 3.797772415682664*^9}, {
   3.797772454528737*^9, 3.797772516930492*^9}, {3.797772633965805*^9, 
   3.797772659826988*^9}, 3.797773502054852*^9, 3.79777358384023*^9, {
   3.797773675112596*^9, 3.797773721141274*^9}, 3.7977737750212812`*^9, {
   3.797773840340431*^9, 3.797773905975724*^9}, {3.797773991720664*^9, 
   3.7977741291256943`*^9}, {3.7977741655021544`*^9, 3.797774178835925*^9}, {
   3.7977745779716387`*^9, 3.7977746173909187`*^9}, {3.7977746526872807`*^9, 
   3.7977746668958817`*^9}, {3.7977747913034077`*^9, 3.797775184601572*^9}, {
   3.79777527024362*^9, 3.797775317413054*^9}, {3.797775703365657*^9, 
   3.7977757190420437`*^9}, {3.7977760727885237`*^9, 
   3.7977760794340363`*^9}, {3.797776164164837*^9, 3.797776213504047*^9}, {
   3.7977763132057953`*^9, 3.7977763212068787`*^9}, {3.797776451550867*^9, 
   3.7977764676701612`*^9}, {3.797776635351859*^9, 3.797776686114523*^9}, {
   3.7977767244681473`*^9, 3.7977768342244*^9}, {3.797776868353793*^9, 
   3.7977768957426357`*^9}, {3.797777039170573*^9, 3.7977770394939413`*^9}, {
   3.797777213822466*^9, 3.7977772143145933`*^9}, {3.79777730111455*^9, 
   3.797777301423325*^9}, {3.7977773351252117`*^9, 3.797777350314681*^9}, {
   3.797777408901609*^9, 3.797777424997604*^9}, {3.797777594425847*^9, 
   3.797777594854897*^9}, {3.7977776250401697`*^9, 3.7977776602535963`*^9}, {
   3.797777717751348*^9, 3.797777758555829*^9}, {3.7977779153435087`*^9, 
   3.79777791569664*^9}, {3.797778004241736*^9, 3.7977780063083076`*^9}, {
   3.797778420481648*^9, 3.797778524762332*^9}, 3.7977785703082237`*^9, {
   3.7977786320960617`*^9, 3.797778657724875*^9}, {3.79777876055643*^9, 
   3.79777876641574*^9}, {3.797778797172803*^9, 3.797778828940732*^9}, {
   3.797778880101378*^9, 3.797778884057332*^9}, {3.797778922105631*^9, 
   3.797778925089591*^9}, {3.79777897414542*^9, 3.797779007082944*^9}, {
   3.79780290939342*^9, 3.797802963478507*^9}, {3.797803058340691*^9, 
   3.797803063746386*^9}, {3.79788946328209*^9, 3.797889463406644*^9}, {
   3.797893092305187*^9, 3.797893093896185*^9}, {3.7978931269224167`*^9, 
   3.797893139817588*^9}, {3.797893717287829*^9, 3.797893717481608*^9}, {
   3.797893830246911*^9, 3.797893839098949*^9}, 3.797893877355134*^9, {
   3.7978939720407143`*^9, 3.797893972558447*^9}, {3.7978942250952873`*^9, 
   3.797894231443734*^9}, {3.797894423874289*^9, 3.797894461063467*^9}, {
   3.797894606232973*^9, 3.7978946548043756`*^9}, {3.797903723581977*^9, 
   3.797903723934469*^9}, {3.797903785269288*^9, 3.797903799497127*^9}, {
   3.7979044224350224`*^9, 3.7979044246240673`*^9}, {3.797904575848905*^9, 
   3.7979045767060757`*^9}, {3.797904627444029*^9, 3.797904628655478*^9}, {
   3.79790483932099*^9, 3.797904840849924*^9}, {3.797905210547372*^9, 
   3.797905219208447*^9}, {3.797905253041835*^9, 3.79790525683337*^9}, {
   3.797905402323905*^9, 3.79790541503836*^9}, {3.797905455726218*^9, 
   3.797905458242447*^9}, {3.7979055005602818`*^9, 3.797905501108717*^9}, 
   3.7979055468702993`*^9, {3.797905632655157*^9, 3.797905687442583*^9}, {
   3.797905731589205*^9, 3.797905733229107*^9}, {3.797931055531683*^9, 
   3.797931060594227*^9}, {3.797933426046768*^9, 3.797933630584573*^9}, {
   3.797936814970159*^9, 3.797936897628769*^9}, {3.7979369693470097`*^9, 
   3.797937039390317*^9}, {3.7979370713024063`*^9, 3.797937136371656*^9}, {
   3.797937198512368*^9, 3.797937227628222*^9}, {3.7979372791111097`*^9, 
   3.797937305258915*^9}, {3.797937454309372*^9, 3.797937454429723*^9}, {
   3.797937499799117*^9, 3.797937527078933*^9}, {3.797937568502976*^9, 
   3.79793775671656*^9}, {3.7979383662137337`*^9, 3.7979383687194157`*^9}, {
   3.797938842984025*^9, 3.797938946368947*^9}, {3.797961850461128*^9, 
   3.797961852626499*^9}, {3.797962089856297*^9, 3.797962116023144*^9}, {
   3.797976169278831*^9, 3.797976205637557*^9}, {3.7979763108862658`*^9, 
   3.797976330383246*^9}, {3.797976365758539*^9, 3.797976419398527*^9}, 
   3.7979765634307117`*^9, {3.79797743061452*^9, 3.797977446081666*^9}, {
   3.7979774840309973`*^9, 3.7979774844942083`*^9}, {3.797977644018528*^9, 
   3.797977660230929*^9}, {3.797979085541809*^9, 3.797979124940777*^9}, {
   3.797979659902828*^9, 3.797979696938891*^9}, {3.797979736390151*^9, 
   3.7979798126775923`*^9}, {3.79797986724601*^9, 3.797979909018981*^9}, {
   3.7979804544763107`*^9, 3.797980498688059*^9}, {3.797980559618421*^9, 
   3.797980560219599*^9}, {3.7980265127949057`*^9, 3.798026610413505*^9}, 
   3.798026646075066*^9, {3.798026691979535*^9, 3.798026793525146*^9}, {
   3.7980268259943*^9, 3.798026933154195*^9}, {3.798026967322966*^9, 
   3.798027075741189*^9}, {3.7980271657660437`*^9, 3.798027174972373*^9}, {
   3.798027249533502*^9, 3.7980273679160213`*^9}, {3.7980274185594063`*^9, 
   3.798027430409987*^9}, {3.798027499569951*^9, 3.798027508585834*^9}, 
   3.798047107807888*^9, {3.798047220285203*^9, 3.79804722180928*^9}, {
   3.798047369448131*^9, 3.798047378010941*^9}, {3.798047416789997*^9, 
   3.798047421475749*^9}, {3.798048148009152*^9, 3.798048183209127*^9}, {
   3.798048260810451*^9, 3.798048280654661*^9}, {3.7980483140676823`*^9, 
   3.798048380329315*^9}, {3.798048412377964*^9, 3.798048440272663*^9}, {
   3.798048567996892*^9, 3.798048621762022*^9}, {3.798049325504383*^9, 
   3.798049562382885*^9}, {3.79804962833781*^9, 3.798049629126786*^9}, {
   3.7980497859869013`*^9, 3.7980498067103567`*^9}, {3.798049837079083*^9, 
   3.798049987729477*^9}, {3.798050150160358*^9, 3.7980501860794363`*^9}, {
   3.7980502723824263`*^9, 3.798050334154683*^9}, {3.798050369515078*^9, 
   3.798050372062192*^9}, 3.798050442254431*^9, {3.7980505419760733`*^9, 
   3.798050542071302*^9}, {3.798050833151536*^9, 3.798050847174946*^9}, {
   3.7980521127219133`*^9, 3.798052153638287*^9}, {3.798052213577222*^9, 
   3.79805222140876*^9}, {3.7980538345857067`*^9, 3.798053866602314*^9}, {
   3.7980539030452147`*^9, 3.798053956684903*^9}, {3.798054197429389*^9, 
   3.798054203031179*^9}, {3.7980543910451612`*^9, 3.798054411818644*^9}, {
   3.7980546932058268`*^9, 3.798054735253564*^9}, {3.798054813257128*^9, 
   3.79805482577372*^9}, {3.7980548964426203`*^9, 3.798054925162902*^9}, {
   3.798054963402794*^9, 3.79805508270415*^9}, {3.798055117986574*^9, 
   3.798055147570751*^9}, 3.798055181898471*^9, {3.798055225904221*^9, 
   3.798055229324971*^9}, {3.79805527335795*^9, 3.798055304954114*^9}, {
   3.798055353786487*^9, 3.7980553752059727`*^9}, {3.798055669646792*^9, 
   3.798055703295925*^9}, {3.7980557637981462`*^9, 3.7980557903647537`*^9}, 
   3.798055883722403*^9, {3.798055915517198*^9, 3.798055946268072*^9}, {
   3.798055993148244*^9, 3.79805601538556*^9}, {3.7980560883862257`*^9, 
   3.7980560885381947`*^9}, {3.798056158539693*^9, 3.7980561805095453`*^9}, 
   3.798056366813712*^9, 3.798056561155726*^9, {3.798056837054555*^9, 
   3.798056859802792*^9}, {3.79805693122505*^9, 3.7980569639169693`*^9}, {
   3.798056995076429*^9, 3.798057064300713*^9}, {3.798059294330504*^9, 
   3.798059305988307*^9}, {3.798059376458334*^9, 3.7980594089648533`*^9}, {
   3.798059441412032*^9, 3.798059443247561*^9}, {3.798059512053323*^9, 
   3.798059541720304*^9}, {3.798059577073234*^9, 3.798059579779894*^9}, {
   3.7980597256825047`*^9, 3.798059760928886*^9}, {3.7980601310060062`*^9, 
   3.798060134709709*^9}, {3.798063037164015*^9, 3.798063081704625*^9}, {
   3.798063169491325*^9, 3.798063171585589*^9}, {3.7980632081318073`*^9, 
   3.798063235920124*^9}, 3.798063327617244*^9, {3.798133171253236*^9, 
   3.798133197871292*^9}, 3.798134684176628*^9, {3.798144919381536*^9, 
   3.798144922985465*^9}, {3.798144954640765*^9, 3.798144981272437*^9}, {
   3.798145747219286*^9, 3.7981457565055*^9}, {3.798146143751648*^9, 
   3.798146174934678*^9}, {3.7981465529465322`*^9, 3.798146555265069*^9}, {
   3.7981466086926947`*^9, 3.798146649548831*^9}, {3.79814674059582*^9, 
   3.798146742229216*^9}, {3.798146932408803*^9, 3.798146956310627*^9}, {
   3.798147107783904*^9, 3.798147152448831*^9}, {3.798147207297317*^9, 
   3.798147209684864*^9}, {3.798147298088352*^9, 3.7981473132821817`*^9}, {
   3.7981473635486107`*^9, 3.798147364523988*^9}, {3.798147412527814*^9, 
   3.798147416127523*^9}, {3.798148255964527*^9, 3.798148260894539*^9}, {
   3.798148612655978*^9, 3.79814862294201*^9}, {3.798148689249605*^9, 
   3.798148726197002*^9}, {3.79814883456031*^9, 3.798148838101038*^9}, 
   3.7981490686283207`*^9, {3.798149136101178*^9, 3.7981491560841017`*^9}, {
   3.798149280537281*^9, 3.798149390141789*^9}, {3.798149720716406*^9, 
   3.798149879737773*^9}, {3.7981499151206903`*^9, 3.79814992754027*^9}, {
   3.7981499678764563`*^9, 3.798150012138183*^9}, {3.79815005357483*^9, 
   3.798150134194592*^9}, {3.798150170690545*^9, 3.7981501826412563`*^9}, {
   3.798150928850588*^9, 3.798150954174738*^9}, {3.798318068792777*^9, 
   3.798318069655357*^9}, {3.798493121416004*^9, 3.798493230154151*^9}, {
   3.798493283129459*^9, 3.7984933344386578`*^9}, {3.798579245346118*^9, 
   3.79857925248011*^9}, {3.798579292832243*^9, 3.798579296889366*^9}, {
   3.798579767678369*^9, 3.7985797699231052`*^9}, {3.798754532229393*^9, 
   3.798754532652792*^9}, 3.798754569469584*^9, 3.7987547838592663`*^9, {
   3.7988277037235107`*^9, 3.7988277062666483`*^9}, {3.7988279562070913`*^9, 
   3.798827956853524*^9}, {3.798827992216522*^9, 3.798828036549613*^9}, {
   3.798828091196773*^9, 3.798828111837081*^9}, {3.7990128982453203`*^9, 
   3.799012906231395*^9}, 3.799012970223682*^9, {3.799013110824852*^9, 
   3.7990131337985563`*^9}, {3.799246870851081*^9, 3.799246900589385*^9}, {
   3.7992469430494003`*^9, 3.799247265882361*^9}, {3.799247329896159*^9, 
   3.7992473319266167`*^9}, {3.7992474026046*^9, 3.799247873290213*^9}, 
   3.7992479118629704`*^9, {3.799248016283002*^9, 3.799248022986961*^9}, {
   3.7992480783342876`*^9, 3.799248132965448*^9}, {3.799248177965187*^9, 
   3.799248194463954*^9}, {3.799443045945136*^9, 3.799443117186407*^9}, {
   3.7994431560008717`*^9, 3.799443197472163*^9}, {3.799521556290141*^9, 
   3.799521558397606*^9}, {3.799530334430044*^9, 3.7995303346599073`*^9}, {
   3.799530482885274*^9, 3.799530496996481*^9}, {3.7996151943437853`*^9, 
   3.799615202135757*^9}, {3.799876389966445*^9, 3.799876403518902*^9}, {
   3.7998769653175898`*^9, 3.799876995519449*^9}, {3.7998770398158283`*^9, 
   3.799877045296874*^9}, 3.79996255193017*^9, 3.7999625926268806`*^9, {
   3.79996280752701*^9, 3.7999628126345654`*^9}, {3.800221797239027*^9, 
   3.800221880484393*^9}, {3.800726003513762*^9, 3.800726004086603*^9}, {
   3.8007380931435432`*^9, 3.800738093333202*^9}, {3.80073822554125*^9, 
   3.8007382302648497`*^9}, {3.8007383305502167`*^9, 3.800738330874628*^9}, {
   3.800738362767846*^9, 3.800738363342554*^9}, {3.800913675475236*^9, 
   3.8009136760224743`*^9}, {3.800913722308563*^9, 3.800913754782234*^9}, {
   3.800913801672739*^9, 3.8009140402570267`*^9}, {3.8009140713998337`*^9, 
   3.8009141264581947`*^9}, {3.800914161606687*^9, 3.80091420124496*^9}, {
   3.800914243401783*^9, 3.800914243998431*^9}, {3.800914276552603*^9, 
   3.800914293278104*^9}, {3.800997382334255*^9, 3.800997382509181*^9}, {
   3.802033760696176*^9, 3.802033761172234*^9}, {3.80315815639778*^9, 
   3.8031581569678373`*^9}, {3.803499566467369*^9, 3.803499569830131*^9}, {
   3.803499853563367*^9, 3.803499896790113*^9}, {3.80350003929173*^9, 
   3.803500049060433*^9}, {3.8035002177889357`*^9, 3.803500277656765*^9}, {
   3.8035004998708363`*^9, 3.80350050025648*^9}, {3.80350056483624*^9, 
   3.803500582599421*^9}, {3.803500638532484*^9, 3.803500670194105*^9}, {
   3.8035007355526133`*^9, 3.803500756533784*^9}, 3.80350145971017*^9, {
   3.803501558698328*^9, 3.803501574617985*^9}, {3.8035016668878927`*^9, 
   3.8035017114501143`*^9}, {3.803502201076708*^9, 3.803502203030672*^9}, {
   3.803502233131256*^9, 3.80350226631387*^9}, {3.8035022987946453`*^9, 
   3.80350233281973*^9}, {3.803502364132802*^9, 3.8035023643055887`*^9}, {
   3.8035024815705843`*^9, 3.803502505018696*^9}, {3.8035025580502787`*^9, 
   3.803502558733324*^9}, {3.8035050129450073`*^9, 3.8035050239875097`*^9}, {
   3.803565413508527*^9, 3.8035654143401737`*^9}, 3.8035655125467863`*^9, {
   3.803565942544024*^9, 3.803565952502283*^9}, {3.8035671307098417`*^9, 
   3.803567137082357*^9}, 3.8035676551594152`*^9, {3.8035677060808487`*^9, 
   3.803567706665925*^9}, {3.8035677478269453`*^9, 3.803567753892606*^9}, {
   3.80357126313503*^9, 3.8035712895759087`*^9}, {3.8035713662082443`*^9, 
   3.803571385528089*^9}, {3.803571446413059*^9, 3.80357145336091*^9}, {
   3.8035715128070583`*^9, 3.803571512988429*^9}, {3.803571563634557*^9, 
   3.803571577476709*^9}, {3.8036655401113358`*^9, 3.80366554325378*^9}, {
   3.8036656138693123`*^9, 3.803665630634988*^9}, {3.803666411385977*^9, 
   3.8036664115791187`*^9}, 3.803666469983989*^9, {3.803666501527894*^9, 
   3.803666524922624*^9}, {3.803666587294928*^9, 3.8036665876726837`*^9}, {
   3.8036671876935368`*^9, 3.803667187925108*^9}, {3.803667245023734*^9, 
   3.8036672454153357`*^9}, {3.803667327336878*^9, 3.803667329247562*^9}, {
   3.8036673603287783`*^9, 3.8036674302717667`*^9}, {3.8036675476656837`*^9, 
   3.803667549481945*^9}, {3.80373639175317*^9, 3.803736392245617*^9}, {
   3.803752083833164*^9, 3.803752167572749*^9}, {3.803752408384755*^9, 
   3.803752410665539*^9}, {3.8037524549256897`*^9, 3.8037524570381308`*^9}, {
   3.803752502307674*^9, 3.803752502583949*^9}, {3.8037526246710463`*^9, 
   3.803752626247835*^9}, {3.803763306268779*^9, 3.803763306793192*^9}, {
   3.803764714480618*^9, 3.80376471494683*^9}, {3.803848040475144*^9, 
   3.803848045414165*^9}, {3.803848081515448*^9, 3.80384812825616*^9}, {
   3.804108524797819*^9, 3.804108527456894*^9}, {3.804967260895643*^9, 
   3.804967262689321*^9}, {3.804968116385846*^9, 3.804968162598465*^9}, {
   3.805146040490041*^9, 3.805146070931037*^9}, {3.805726017617375*^9, 
   3.8057260225057487`*^9}, {3.805726245411634*^9, 3.8057262928644*^9}, {
   3.805726329162815*^9, 3.805726348715273*^9}, {3.8057263872241707`*^9, 
   3.805726447638145*^9}, {3.805726567592915*^9, 3.805726658198181*^9}, {
   3.8057354822825947`*^9, 3.805735482449832*^9}, {3.805735701801916*^9, 
   3.805735702333418*^9}, {3.805808379787483*^9, 3.805808383047873*^9}, {
   3.80580864695726*^9, 3.8058086494284782`*^9}, {3.806441842991075*^9, 
   3.8064418452600307`*^9}, {3.806442130558226*^9, 3.806442132021023*^9}, {
   3.8067003001759033`*^9, 3.8067003628023987`*^9}, {3.8067004473205843`*^9, 
   3.806700531703137*^9}, {3.8067005857352057`*^9, 3.806700757969384*^9}, {
   3.8067008533246183`*^9, 3.806700855122405*^9}, {3.806700916254463*^9, 
   3.806700979869143*^9}, {3.8067010279738503`*^9, 3.8067010510847387`*^9}, {
   3.806701095525461*^9, 3.80670112012109*^9}, {3.8067012730514317`*^9, 
   3.806701273609414*^9}, {3.806872298616498*^9, 3.806872327724937*^9}, {
   3.80773895474823*^9, 3.8077389548918858`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18,
 FontWeight->"Regular",
 Background->RGBColor[1, 1, 0],
 CellLabel->"In[28]:=",ExpressionUUID->"6bf469ed-d5a6-498e-8888-5287e39939b3"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.15, $CellContext`cota$$ = 
    972000, $CellContext`g$$ = 0.04, $CellContext`ke$$ = 
    1.3*^-7, $CellContext`ki$$ = 1.05*^-7, $CellContext`kv$$ = 
    0.00012, $CellContext`p$$ = 0.09, $CellContext`PM$$ = 
    900000, $CellContext`r$$ = 0.81, $CellContext`tds2$$ = 
    51, $CellContext`tf2$$ = 90, $CellContext`tic$$ = 
    23, $CellContext`tmax$$ = $CellContext`tshow$$, $CellContext`tshow$$ = 
    579, $CellContext`\[Alpha]$$ = 0.07, $CellContext`\[Beta]$$ = 
    0., $CellContext`\[Gamma]$$ = 0.015, $CellContext`\[Delta]$$ = 
    0.038, $CellContext`\[CapitalDelta]kds2$$ = 
    0.23, $CellContext`\[CapitalDelta]kf2$$ = 
    0., $CellContext`\[CapitalDelta]ki$$ = 0.25, $CellContext`\[Epsilon]$$ = 
    0.07, $CellContext`\[Mu]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[
       Style["PLOT BOUND", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`cota$$], 972000, "cota"}, 5, 2390000}, {
      Hold[
       Style["MAXIMAL TIME", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tmax$$], $CellContext`tshow$$, "tmax"}, 10, 600}, {
      Hold[
       Style["SHOW TIME", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tshow$$], 579, "tshow"}, 10, 600}, {
      Hold[
       Style["HOUSE CONFINEMENT START", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tic$$], 23, "tic"}, 10, 200}, {
      Hold[
       Style["ECONOMIC PRESSURE INATTENTION", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tds2$$], 51, "tds2"}, 30, 200}, {
      Hold[
       Style["END-DOWN HOME CONFINEMENT", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tf2$$], 90, "tf2"}, 30, 200}, {
      Hold[
       Style["INFECTION RATE DECREASE AT ti", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[CapitalDelta]ki$$], 0.25, "\[CapitalDelta]ki"}, 0, 
      2}, {
      Hold[
       Style["INFECTION RATE INCREASE AT tds2", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[CapitalDelta]kds2$$], 0.23, "\[CapitalDelta]kds2"},
       0, 2}, {
      Hold[
       Style["INFECTION RATE INCREASE AT HC END at tf2", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[CapitalDelta]kf2$$], 0., "\[CapitalDelta]kf2"}, 0, 
      50}, {
      Hold[
       Style[
       "\!\(\*StyleBox[\"SUSCEPTIBLE\",FontColor->GrayLevel[0]]\)", 12, 
        Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Mu]$$], 0, "\[Mu]"}, 0., 6.*^-7}, {{
       Hold[$CellContext`PM$$], 900000, "PM"}, 100, 13000000}, {{
       Hold[$CellContext`kv$$], 0.00012, "kv"}, 1.*^-7, 0.51}, {{
       Hold[$CellContext`ke$$], 1.3*^-7, 
       "\!\(\*StyleBox[\"ke\",FontColor->GrayLevel[0]]\)"}, 0., 0.00001}, {{
       Hold[$CellContext`ki$$], 1.05*^-7, 
       "\!\(\*StyleBox[\"ki\",FontColor->GrayLevel[0]]\)"}, 0., 0.00001}, {
      Hold[
       Style[
       "\!\(\*StyleBox[\"EXPOSED\",FontColor->RGBColor[1, 0, 0]]\)", 12, 
        Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Alpha]$$], 0.07, "\[Alpha]"}, 0.0001, 0.56}, {{
       Hold[$CellContext`\[Beta]$$], 0., "\[Beta]"}, 0., 0.2}, {{
       Hold[$CellContext`\[Epsilon]$$], 0.07, "\[Epsilon]"}, 0., 0.52}, {
      Hold[
       Style[
       "PARAMETERS \!\(\*StyleBox[\"I\",FontColor->GrayLevel[0.5]]\), R AND \
D", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["a+r+g=1", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`a$$], 0.15, "a"}, 0.001, 0.61}, {{
       Hold[$CellContext`r$$], 0.81, "r"}, 0.001, 1.1}, {{
       Hold[$CellContext`g$$], 0.04, "g"}, 0.001, 0.61}, {{
       Hold[$CellContext`\[Gamma]$$], 0.015, "\[Gamma]"}, 7.6*^-9, 0.1}, {{
       Hold[$CellContext`\[Delta]$$], 0.038, "\[Delta]"}, 7.6*^-9, 0.16}, {{
       Hold[$CellContext`p$$], 0.09, 
       "\!\(\*StyleBox[\"p\",FontColor->GrayLevel[0]]\)"}, 0.001, 1.03}}, 
    Typeset`size$$ = {1787., {520.634033203125, 526.365966796875}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`cota$94957$$ = 0, $CellContext`tmax$94958$$ = 
    0, $CellContext`tshow$94959$$ = 0, $CellContext`tic$94960$$ = 
    0, $CellContext`tds2$94961$$ = 0, $CellContext`tf2$94962$$ = 
    0, $CellContext`\[CapitalDelta]ki$94963$$ = 
    0, $CellContext`\[CapitalDelta]kds2$94964$$ = 
    0, $CellContext`\[CapitalDelta]kf2$94965$$ = 
    0, $CellContext`\[Mu]$94966$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.15, $CellContext`cota$$ = 
        972000, $CellContext`g$$ = 0.04, $CellContext`ke$$ = 
        1.3*^-7, $CellContext`ki$$ = 1.05*^-7, $CellContext`kv$$ = 
        0.00012, $CellContext`p$$ = 0.09, $CellContext`PM$$ = 
        900000, $CellContext`r$$ = 0.81, $CellContext`tds2$$ = 
        51, $CellContext`tf2$$ = 90, $CellContext`tic$$ = 
        23, $CellContext`tmax$$ = $CellContext`tshow$$, $CellContext`tshow$$ = 
        579, $CellContext`\[Alpha]$$ = 0.07, $CellContext`\[Beta]$$ = 
        0., $CellContext`\[Gamma]$$ = 0.015, $CellContext`\[Delta]$$ = 
        0.038, $CellContext`\[CapitalDelta]kds2$$ = 
        0.23, $CellContext`\[CapitalDelta]kf2$$ = 
        0., $CellContext`\[CapitalDelta]ki$$ = 
        0.25, $CellContext`\[Epsilon]$$ = 0.07, $CellContext`\[Mu]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`cota$$, $CellContext`cota$94957$$, 0], 
        Hold[$CellContext`tmax$$, $CellContext`tmax$94958$$, 0], 
        Hold[$CellContext`tshow$$, $CellContext`tshow$94959$$, 0], 
        Hold[$CellContext`tic$$, $CellContext`tic$94960$$, 0], 
        Hold[$CellContext`tds2$$, $CellContext`tds2$94961$$, 0], 
        Hold[$CellContext`tf2$$, $CellContext`tf2$94962$$, 0], 
        Hold[$CellContext`\[CapitalDelta]ki$$, \
$CellContext`\[CapitalDelta]ki$94963$$, 0], 
        Hold[$CellContext`\[CapitalDelta]kds2$$, \
$CellContext`\[CapitalDelta]kds2$94964$$, 0], 
        Hold[$CellContext`\[CapitalDelta]kf2$$, \
$CellContext`\[CapitalDelta]kf2$94965$$, 0], 
        Hold[$CellContext`\[Mu]$$, $CellContext`\[Mu]$94966$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`s$ = 
         NDSolve[{
           Derivative[
             1][$CellContext`S][$CellContext`t] == $CellContext`\[Mu]$$ \
$CellContext`S[$CellContext`t] - ($CellContext`kv$$ + $CellContext`ke$$ (
                1 - $CellContext`\[CapitalDelta]ki$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Ex[$CellContext`t] + $CellContext`ki$$ (
                1 - $CellContext`\[CapitalDelta]ki$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Inf[$CellContext`t]) $CellContext`S[$CellContext`t], 
            Derivative[
             1][$CellContext`Ex][$CellContext`t] == ($CellContext`kv$$ + \
$CellContext`ke$$ (1 - $CellContext`\[CapitalDelta]ki$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                  HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Ex[$CellContext`t] + $CellContext`ki$$ (
                 1 - $CellContext`\[CapitalDelta]ki$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                  HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Inf[$CellContext`t]) $CellContext`S[$CellContext`t] - \
($CellContext`\[Alpha]$$ + $CellContext`\[Beta]$$) \
$CellContext`Ex[$CellContext`t], 
            Derivative[
             1][$CellContext`Inf][$CellContext`t] == $CellContext`\[Alpha]$$ \
$CellContext`Ex[$CellContext`t] - ($CellContext`\[Gamma]$$ $CellContext`r$$ + \
$CellContext`\[Delta]$$ $CellContext`g$$ + $CellContext`\[Epsilon]$$ \
$CellContext`a$$) $CellContext`Inf[$CellContext`t], 
            Derivative[
             1][$CellContext`A][$CellContext`t] == $CellContext`\[Epsilon]$$ \
$CellContext`a$$ $CellContext`Inf[$CellContext`t] - ($CellContext`\[Delta]$$ \
$CellContext`p$$ + $CellContext`\[Gamma]$$ (
                1 - $CellContext`p$$)) $CellContext`A[$CellContext`t], 
            Derivative[
             1][$CellContext`R][$CellContext`t] == $CellContext`\[Beta]$$ \
$CellContext`Ex[$CellContext`t] + $CellContext`\[Gamma]$$ $CellContext`r$$ \
$CellContext`Inf[$CellContext`t] + $CellContext`\[Gamma]$$ (
               1 - $CellContext`p$$) $CellContext`A[$CellContext`t], 
            Derivative[
             1][$CellContext`d][$CellContext`t] == $CellContext`\[Delta]$$ \
($CellContext`g$$ $CellContext`Inf[$CellContext`t] + $CellContext`p$$ \
$CellContext`A[$CellContext`t]), $CellContext`S[
             0] == $CellContext`PM$$, $CellContext`Ex[0] == 
            0, $CellContext`Inf[0] == 3, $CellContext`A[0] == 
            0., $CellContext`R[0] == 0., $CellContext`d[0] == 
            0.}, {$CellContext`S, $CellContext`Ex, $CellContext`Inf, \
$CellContext`A, $CellContext`R, $CellContext`d}, {$CellContext`t, 
            0, $CellContext`tmax$$}, Method -> "StiffnessSwitching", 
           AccuracyGoal -> 7, PrecisionGoal -> 6]}, 
        Grid[{{$CellContext`QQ1 = Show[
             Plot[
              Evaluate[
               
               ReplaceAll[{$CellContext`Inf[$CellContext`t]; \
$CellContext`Ex[$CellContext`t]; $CellContext`R[$CellContext`t], 
                 $CellContext`d[$CellContext`t], \
$CellContext`A[$CellContext`t]; $CellContext`R[$CellContext`t] + \
$CellContext`d[$CellContext`t] + $CellContext`A[$CellContext`t]}, \
$CellContext`s$]], {$CellContext`t, 1, $CellContext`tmax$$}, 
              PlotLegends -> {
               "Inf[t]"; "Ex[t]"; "R[t]", "d[t]", "A[t]", "R[t]+d[t]+A[t]"}, 
              PlotRange -> {{5, $CellContext`tshow$$}, {
                0, $CellContext`cota$$}}, AspectRatio -> 1.3, ImageSize -> 
              450, PlotStyle -> {{Red, 
                  Thickness[0.003725], 
                  AbsoluteDashing[{2, 12, 2}]}; {
                  Green[1.5], 
                  AbsoluteDashing[{8, 5}], 
                  Thickness[0.007251]}; {Orange, 
                  AbsoluteDashing[{8, 5}], 
                  Thickness[0.00751]}, {Orange, 
                 AbsoluteDashing[{8, 5}], 
                 Thickness[0.00751]}, {Cyan, 
                  Thickness[0.01051]}; {Orange, 
                  AbsoluteDashing[{8, 5}], 
                  Thickness[0.00751]}, {Green, 
                 AbsoluteDashing[{8, 12}], 
                 Thickness[0.00751]}}, Frame -> True, 
              GridLines -> {{}, {38200, 120000}}, GridLinesStyle -> 
              Directive[Gray, Dotted, Thin], 
              PlotRange -> {{0, 0.7 $CellContext`tmax$$}, {0, 10000}}, 
              Filling -> None, FillingStyle -> Directive[
                Opacity[0.1], Blue], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20]], 
             
             DateListPlot[{$CellContext`DatosFallecidos, \
$CellContext`DatosRecuperados, $CellContext`DatosAcumulados}, PlotRange -> 
              All, Filling -> Axis, 
              PlotTheme -> {"Bussiness", "OpenMarkersThick"}]], 
           Plot[
            Evaluate[
             ReplaceAll[{
               $CellContext`Inf[$CellContext`t], 
               $CellContext`Ex[$CellContext`t]}, $CellContext`s$]], \
{$CellContext`t, 1, $CellContext`tmax$$}, PlotLegends -> {"S"; "Inf", "Ex"}, 
            PlotRange -> All, AspectRatio -> 1.3, ImageSize -> 450, 
            PlotStyle -> {{Black}; {Red, 
                AbsoluteDashing[{1, 6, 6}], 
                Thickness[0.0075]}, {
               Green[1.5], 
               AbsoluteDashing[{5, 3, 3}], 
               Thickness[0.003745]}, {Magenta, 
               AbsoluteDashing[{4, 10}], 
               Thickness[0.0075]}, {Black, DotDashed, 
               Thickness[0.0045]}}, Frame -> True, GridLines -> {{130}, None},
             GridLinesStyle -> Directive[Gray, Dashed, Thin], FrameLabel -> {
              Text[
               Style["day since first case", 30]], 
              Text[
               Style["infection probability", 30]]}, FrameStyle -> Directive[
              Thickness[0.005], Black], FrameTicksStyle -> 
            Directive[Black, 20], Filling -> Axis, FillingStyle -> Directive[
              Opacity[0.], Yellow]]}, {$CellContext`Q1 = Show[
             
             ListPlot[{$CellContext`CasosACTIVOS, \
$CellContext`CasosPORdiaHOPKINS, $CellContext`CASOSporDIAresta}, 
              PlotMarkers -> {Automatic, 12}, 
              PlotRange -> {{0, $CellContext`tshow$$}, {-1, 117800}}, 
              AspectRatio -> 1.3, ImageSize -> 450, Frame -> True, 
              GridLines -> {{{$CellContext`DIAMX, Red}}, {}}, GridLinesStyle -> 
              Directive[Gray, Dashed, Thin], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20]], 
             Plot[
              Evaluate[
               ReplaceAll[{
                 $CellContext`A[$CellContext`t], ($CellContext`\[Gamma]$$ \
$CellContext`r$$ + $CellContext`\[Delta]$$ $CellContext`g$$ + $CellContext`\
\[Epsilon]$$ $CellContext`a$$) (NIntegrate[
                    Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t}] - NIntegrate[
                   Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t - 1}]), 
                 0.4 $CellContext`A[$CellContext`t]}, $CellContext`s$]], \
{$CellContext`t, 1, $CellContext`tmax$$}, 
              PlotLegends -> {"S"; "A[t]", "Casos por d\[IAcute]a"}, 
              PlotRange -> Automatic, AspectRatio -> 1.3, ImageSize -> 450, 
              PlotStyle -> {{Black}; {Orange, 
                  AbsoluteDashing[{8, 5}], 
                  Thickness[0.0075]}, {Orange, 
                 AbsoluteDashing[{8, 5}], 
                 Thickness[0.0075]}, {Black, 
                 AbsoluteDashing[{8, 5}], 
                 Thickness[0.0075]}, {Black, DotDashed, 
                 Thickness[0.0045]}}, Frame -> True, 
              GridLines -> {{98}, None}, GridLinesStyle -> 
              Directive[Gray, Dashed, Thin], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20], Filling -> Axis, FillingStyle -> Directive[
                Opacity[0.], Yellow]]], 
           Plot[
            Evaluate[
             
             ReplaceAll[{$CellContext`ki$$ ($CellContext`S[$CellContext`t] \
$CellContext`Inf[$CellContext`t]/$CellContext`PM$$), $CellContext`ke$$ \
($CellContext`S[$CellContext`t] \
$CellContext`Ex[$CellContext`t]/$CellContext`PM$$), (1/
                1000) ($CellContext`Ex[$CellContext`t]/$CellContext`Inf[$\
CellContext`t])}, $CellContext`s$]], {$CellContext`t, 1, $CellContext`tmax$$},
             PlotLegends -> {
             "S"; "ki*\!\(\*FractionBox[\(S[t]*Inf[t]\), \(PM\)]\)", 
              "ke*\!\(\*FractionBox[\(S[t]*Ex[t]\), \(PM\)]\)", 
              "\!\(\*FractionBox[\(1\), \
\(1000\)]\)\!\(\*FractionBox[\(Ex[t]\), \(Inf[t]\)]\)"}, 
            PlotRange -> {{0, 98}, {-0.001, 0.0215}}, AspectRatio -> 1.3, 
            ImageSize -> 450, PlotStyle -> {{Black}; {Blue, 
                AbsoluteDashing[{8, 5}], 
                Thickness[0.0075]}, {Red, 
               AbsoluteDashing[{2, 5, 2}], 
               Thickness[0.00745]}, {Magenta, 
               AbsoluteDashing[{4, 10}], 
               Thickness[0.0075]}, {Black, DotDashed, 
               Thickness[0.0045]}}, Frame -> True, GridLines -> {{98}, None}, 
            GridLinesStyle -> Directive[Gray, Dashed, Thin], FrameLabel -> {
              Text[
               Style["day since first case", 30]], 
              Text[
               Style["infection probability", 30]]}, FrameStyle -> Directive[
              Thickness[0.005], Black], FrameTicksStyle -> 
            Directive[Black, 20], Filling -> Axis, FillingStyle -> Directive[
              Opacity[0.], Yellow]], $CellContext`D1 = Show[
             
             ListPlot[{$CellContext`CASOSporDIAresta}, PlotMarkers -> 
              Automatic, PlotRange -> {{0, $CellContext`tshow$$}, {0, 9500}}, 
              AspectRatio -> 1.3, ImageSize -> 450, Frame -> True, 
              GridLines -> {{{$CellContext`DIAMX, Red}}, {}}, GridLinesStyle -> 
              Directive[Gray, Dashed, Thin], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20]], 
             Plot[
              Evaluate[
               
               ReplaceAll[{($CellContext`\[Gamma]$$ $CellContext`r$$ + \
$CellContext`\[Delta]$$ $CellContext`g$$ + $CellContext`\[Epsilon]$$ \
$CellContext`a$$) (NIntegrate[
                    Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t}] - NIntegrate[
                   Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t - 
                    1}])}, $CellContext`s$]], {$CellContext`t, 
               1, $CellContext`tmax$$}, PlotLegends -> {"S"; "casos diarios"},
               PlotRange -> Automatic, AspectRatio -> 1.3, ImageSize -> 450, 
              PlotStyle -> {{Black}; {Orange, 
                  AbsoluteDashing[{8, 5}], 
                  Thickness[0.0075]}, {Red, 
                 AbsoluteDashing[{2, 5, 2}], 
                 Thickness[0.003745]}, {Magenta, 
                 AbsoluteDashing[{4, 10}], 
                 Thickness[0.0075]}, {Black, DotDashed, 
                 Thickness[0.0045]}}, Frame -> True, 
              GridLines -> {{98}, None}, GridLinesStyle -> 
              Directive[Gray, Dashed, Thin], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["infection probability", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20], Filling -> Axis, FillingStyle -> Directive[
                Opacity[0.], Yellow]]]}}]], "Specifications" :> {
        Style[
        "PLOT BOUND", 12, Bold], {{$CellContext`cota$$, 972000, "cota"}, 5, 
         2390000}, 
        Style[
        "MAXIMAL TIME", 12, 
         Bold], {{$CellContext`tmax$$, $CellContext`tshow$$, "tmax"}, 10, 
         600}, 
        Style[
        "SHOW TIME", 12, Bold], {{$CellContext`tshow$$, 579, "tshow"}, 10, 
         600}, 
        Style[
        "HOUSE CONFINEMENT START", 12, 
         Bold], {{$CellContext`tic$$, 23, "tic"}, 10, 200}, 
        Style[
        "ECONOMIC PRESSURE INATTENTION", 12, 
         Bold], {{$CellContext`tds2$$, 51, "tds2"}, 30, 200}, 
        Style[
        "END-DOWN HOME CONFINEMENT", 12, 
         Bold], {{$CellContext`tf2$$, 90, "tf2"}, 30, 200}, 
        Style[
        "INFECTION RATE DECREASE AT ti", 12, 
         Bold], {{$CellContext`\[CapitalDelta]ki$$, 0.25, 
          "\[CapitalDelta]ki"}, 0, 2}, 
        Style[
        "INFECTION RATE INCREASE AT tds2", 12, 
         Bold], {{$CellContext`\[CapitalDelta]kds2$$, 0.23, 
          "\[CapitalDelta]kds2"}, 0, 2}, 
        Style[
        "INFECTION RATE INCREASE AT HC END at tf2", 12, 
         Bold], {{$CellContext`\[CapitalDelta]kf2$$, 0., 
          "\[CapitalDelta]kf2"}, 0, 50}, 
        Style[
        "\!\(\*StyleBox[\"SUSCEPTIBLE\",FontColor->GrayLevel[0]]\)", 12, 
         Bold], {{$CellContext`\[Mu]$$, 0, "\[Mu]"}, 0., 
         6.*^-7}, {{$CellContext`PM$$, 900000, "PM"}, 100, 
         13000000}, {{$CellContext`kv$$, 0.00012, "kv"}, 1.*^-7, 
         0.51}, {{$CellContext`ke$$, 1.3*^-7, 
          "\!\(\*StyleBox[\"ke\",FontColor->GrayLevel[0]]\)"}, 0., 
         0.00001}, {{$CellContext`ki$$, 1.05*^-7, 
          "\!\(\*StyleBox[\"ki\",FontColor->GrayLevel[0]]\)"}, 0., 0.00001}, 
        Delimiter, 
        Style[
        "\!\(\*StyleBox[\"EXPOSED\",FontColor->RGBColor[1, 0, 0]]\)", 12, 
         Bold], {{$CellContext`\[Alpha]$$, 0.07, "\[Alpha]"}, 0.0001, 
         0.56}, {{$CellContext`\[Beta]$$, 0., "\[Beta]"}, 0., 
         0.2}, {{$CellContext`\[Epsilon]$$, 0.07, "\[Epsilon]"}, 0., 0.52}, 
        Delimiter, 
        Style[
        "PARAMETERS \!\(\*StyleBox[\"I\",FontColor->GrayLevel[0.5]]\), R AND \
D", 12, Bold], 
        Style[
        "a+r+g=1", 12, Bold], {{$CellContext`a$$, 0.15, "a"}, 0.001, 
         0.61}, {{$CellContext`r$$, 0.81, "r"}, 0.001, 
         1.1}, {{$CellContext`g$$, 0.04, "g"}, 0.001, 
         0.61}, {{$CellContext`\[Gamma]$$, 0.015, "\[Gamma]"}, 7.6*^-9, 
         0.1}, {{$CellContext`\[Delta]$$, 0.038, "\[Delta]"}, 7.6*^-9, 
         0.16}, {{$CellContext`p$$, 0.09, 
          "\!\(\*StyleBox[\"p\",FontColor->GrayLevel[0]]\)"}, 0.001, 1.03}, 
        Delimiter}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{2108., {551., 557.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.8035017141927958`*^9, 3.8035022102948112`*^9, {3.803502311375592*^9, 
   3.803502335730568*^9}, 3.803502367813633*^9, 3.803502509063905*^9, 
   3.8035025620382347`*^9, 3.803503456838585*^9, 3.803505027296296*^9, 
   3.8035653653687572`*^9, 3.803565421453579*^9, 3.803565515887779*^9, {
   3.8035659459927683`*^9, 3.803565955414762*^9}, 3.8035663264972563`*^9, 
   3.8035671411108418`*^9, 3.803567712641685*^9, 3.803567761678132*^9, 
   3.8035699281062098`*^9, 3.8035712936959343`*^9, 3.803571390107071*^9, 
   3.80357146173147*^9, 3.803571519823577*^9, 3.8035715953964243`*^9, 
   3.803571627401237*^9, 3.8035915143293467`*^9, 3.803664644163611*^9, 
   3.803665408560769*^9, 3.803665552704966*^9, 3.803665637147553*^9, 
   3.8036664169124613`*^9, 3.803666476508761*^9, {3.803666509014469*^9, 
   3.803666528813507*^9}, 3.80366659281584*^9, {3.803667193672741*^9, 
   3.80366720354327*^9}, 3.803667333879488*^9, 3.803667367739966*^9, {
   3.803667405929098*^9, 3.803667434819635*^9}, 3.803667556742828*^9, 
   3.803735720792756*^9, 3.8037358091235*^9, 3.8037359767325907`*^9, 
   3.80373623408386*^9, 3.803736399622044*^9, 3.803736436297056*^9, 
   3.803736515363903*^9, 3.8037366273192253`*^9, 3.803736804576623*^9, 
   3.8037408977310467`*^9, 3.8037518618940887`*^9, 3.803752415100247*^9, 
   3.803752457734049*^9, 3.803752503228197*^9, 3.803752544018609*^9, 
   3.803752630814492*^9, 3.803752675066904*^9, 3.80376312922122*^9, 
   3.8037632486116056`*^9, 3.803763314443193*^9, 3.80376415103444*^9, 
   3.803764724579123*^9, 3.803769062717368*^9, 3.803769102417049*^9, 
   3.8037693572357073`*^9, 3.803847903083105*^9, 3.8038480579275*^9, 
   3.8038481123451138`*^9, 3.803848145479895*^9, 3.80384820514115*^9, 
   3.803937143232788*^9, 3.803937303064151*^9, 3.804026596840373*^9, 
   3.80410856020951*^9, 3.804109882094096*^9, 3.8041936926325817`*^9, 
   3.80419378337957*^9, 3.804368103343813*^9, 3.804452583851973*^9, 
   3.804452797906995*^9, 3.804452964137464*^9, 3.8044530707674093`*^9, 
   3.804453207226398*^9, 3.804544437668273*^9, 3.8047151624785423`*^9, 
   3.80471523389115*^9, 3.804717498385725*^9, 3.804800228711969*^9, 
   3.804853852532234*^9, 3.80486058714745*^9, 3.804884629809042*^9, 
   3.804963249945037*^9, 3.8049665934131203`*^9, 3.804967282258334*^9, 
   3.804968171801352*^9, 3.804970988352241*^9, 3.805032063113707*^9, 
   3.8050498565151453`*^9, 3.805145170726734*^9, 3.8051456594071083`*^9, 
   3.8051458582273417`*^9, {3.805146052013482*^9, 3.805146081464691*^9}, 
   3.805201932213641*^9, 3.805232578197834*^9, 3.8052327691055527`*^9, 
   3.80531768042624*^9, 3.805318477952533*^9, 3.805318561567823*^9, 
   3.805319454172181*^9, 3.805319559858975*^9, 3.80540286881535*^9, 
   3.8054034049172487`*^9, 3.8054917318368587`*^9, 3.805578709268737*^9, 
   3.8056390319769487`*^9, 3.805661969993301*^9, {3.805725922159912*^9, 
   3.805725940671193*^9}, 3.805726031537516*^9, {3.805726273304482*^9, 
   3.805726297299876*^9}, 3.805726353069256*^9, {3.805726424379253*^9, 
   3.80572645191509*^9}, {3.805726636787312*^9, 3.805726665229312*^9}, 
   3.805735505822934*^9, {3.805735556257106*^9, 3.8057355599899673`*^9}, 
   3.8057358648042727`*^9, 3.8057500486162567`*^9, 3.805750097428606*^9, 
   3.8057503742651873`*^9, 3.8058083466277723`*^9, 3.805808388362225*^9, {
   3.805808425968454*^9, 3.8058084297156343`*^9}, 3.805808657248682*^9, 
   3.805811138323247*^9, 3.805838878745821*^9, 3.805920956072762*^9, {
   3.8060721520878*^9, 3.806072192619299*^9}, 3.806072610068172*^9, 
   3.806072689016308*^9, 3.806072818810388*^9, 3.806175570857443*^9, 
   3.8061839424312553`*^9, 3.80618400597219*^9, 3.806353322078272*^9, 
   3.8063536927692947`*^9, 3.806441727813211*^9, 3.806441854861602*^9, 
   3.806442142368208*^9, 3.8066996373825417`*^9, 3.806699769985611*^9, {
   3.806700348762577*^9, 3.8067003787238293`*^9}, 3.806700449323267*^9, 
   3.806700534410201*^9, {3.80670058875063*^9, 3.806700758945476*^9}, 
   3.8067008585322857`*^9, {3.8067009235833073`*^9, 3.806700983075089*^9}, {
   3.80670103558494*^9, 3.80670105836812*^9}, 3.806701127813171*^9, 
   3.80670129660387*^9, 3.806701401201707*^9, 3.806772445932673*^9, 
   3.806872049512802*^9, 3.806872163872982*^9, {3.8068723089153023`*^9, 
   3.8068723286639013`*^9}, 3.80700675116019*^9, 3.807006908728393*^9, 
   3.807131379114932*^9, 3.807389427735623*^9, 3.8073896318166656`*^9, 
   3.807562308044847*^9, 3.807651536522738*^9, 3.807738742663267*^9, 
   3.807738962446351*^9, 3.8079030115448723`*^9, 3.808082940240547*^9, 
   3.808222335669367*^9, 3.8082239566545877`*^9, 3.8084293427848587`*^9, 
   3.808602227811653*^9, 3.8086514696699533`*^9, 3.808651501856852*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"3203bb0c-2760-4019-b6a8-813182f797c0"]
}, Open  ]],

Cell["\<\
Note: The black line above is the number of active cases reported by the \
authorities. About 40% of the total number A(t)\
\>", "Text",
 CellChangeTimes->{{3.808222592116083*^9, 3.80822264288669*^9}, {
  3.808222691701346*^9, 3.808222692540728*^9}},
 FontColor->GrayLevel[0],
 Background->RGBColor[
  0.1313496604867628, 0.9996795605401694, 
   0.02362096589608606],ExpressionUUID->"1f6432c6-cb22-4808-94ab-\
33bcd6d29cff"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.7987548152667007`*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"5045d427-31d9-4fdb-b7bf-aa7c3ba0c964"],

Cell[BoxData[
 RowBox[{"Off", "[", 
  TemplateBox[{
   "NIntegrate","nlim",
    "\"\\!\\(\\*RowBox[{\\\"z\\\"}]\\) = \\!\\(\\*RowBox[{\\\"t\\\"}]\\) is \
not a valid limit of integration.\"",2,253,505,21718307563882191640,"Local"},
   "MessageTemplate"], "]"}]], "Input",
 CellChangeTimes->{3.7971526887681*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"b2ccfa4e-dfba-4e18-a5dc-b5eb23a78d47"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FIT ASSUMING 
1.5 MILLION SUSCEPTIBLE INDIVIDUALS, and the corrected data for recovered \
about June 26 \
\>", "Title",
 CellChangeTimes->{{3.803500846527546*^9, 3.803500862236145*^9}, {
  3.8058108432351627`*^9, 3.8058108683848343`*^9}, {3.805810902466919*^9, 
  3.805810919444186*^9}, {3.8058110418185997`*^9, 3.805811093111971*^9}},
 Background->RGBColor[
  1, 1, 0.85],ExpressionUUID->"b756fd3b-4ded-4fc5-887e-9b461a5a0d68"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", "=", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          StyleBox[
           RowBox[{"(*", " ", "SUSCEPTIBLE", "*)"}],
           FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->GrayLevel[0]], 
          RowBox[{
           StyleBox[
            RowBox[{
             RowBox[{
              RowBox[{"S", "'"}], "[", "t", "]"}], "\[Equal]", 
             RowBox[{
              RowBox[{"\[Mu]", "*", 
               RowBox[{"S", "[", "t", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"kv", "+", " ", 
                 RowBox[{"ke", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Ex", "[", "t", "]"}]}], "+", 
                 RowBox[{"ki", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Inf", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"S", "[", "t", "]"}]}]}]}],
            FontColor->GrayLevel[0]], 
           StyleBox[",",
            FontColor->GrayLevel[0]], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0.5, 0]], 
           StyleBox[
            RowBox[{"(*", "EXPOSED", "*)"}],
            FontColor->RGBColor[1, 0, 1]], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0, 1],
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{
            StyleBox[
             RowBox[{
              RowBox[{"Ex", "'"}], "[", "t", "]"}],
             FontColor->GrayLevel[0]], 
            StyleBox["\[Equal]",
             FontColor->GrayLevel[0]], 
            RowBox[{
             StyleBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{"kv", "+", " ", 
                 RowBox[{"ke", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Ex", "[", "t", "]"}]}], "+", 
                 RowBox[{"ki", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "+", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Inf", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"S", "[", "t", "]"}]}],
              FontColor->GrayLevel[0]], 
             StyleBox["-",
              FontColor->GrayLevel[0]], 
             RowBox[{
              RowBox[{
               StyleBox["(",
                FontColor->GrayLevel[0]], 
               RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "*", 
              RowBox[{"Ex", "[", "t", "]"}]}]}]}], ",", 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{"(*", " ", "INFECTED", "*)"}], 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{
            RowBox[{
             RowBox[{"Inf", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Alpha]", "*", 
              RowBox[{"Ex", "[", "t", "]"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Gamma]", "*", "r"}], "+", 
                RowBox[{"\[Delta]", "*", "g"}], "+", 
                RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
              RowBox[{"Inf", "[", "t", "]"}]}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "ACTIVE", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"A", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Epsilon]", "*", "a", "*", 
              RowBox[{"Inf", "[", "t", "]"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Delta]", "*", 
                 StyleBox["p",
                  FontColor->RGBColor[1, 0, 0]]}], 
                StyleBox["+",
                 FontColor->RGBColor[1, 0, 0]], 
                RowBox[{"\[Gamma]", "*", 
                 StyleBox[
                  RowBox[{"(", 
                   RowBox[{"1", "-", "p"}], ")"}],
                  FontColor->RGBColor[1, 0, 0]]}]}], ")"}], "*", 
              RowBox[{"A", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
           
           RowBox[{"(*", " ", "RECOVERED", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"R", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Beta]", "*", 
              RowBox[{"Ex", "[", "t", "]"}]}], "+", 
             RowBox[{"\[Gamma]", "*", 
              StyleBox["r",
               FontColor->RGBColor[1, 0, 0]], 
              StyleBox["*",
               FontColor->RGBColor[1, 0, 0]], 
              RowBox[{"Inf", "[", "t", "]"}]}], "+", 
             RowBox[{"\[Gamma]", "*", 
              StyleBox[
               RowBox[{"(", 
                RowBox[{"1", "-", "p"}], ")"}],
               FontColor->RGBColor[1, 0, 0]], "*", 
              RowBox[{"A", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "DEAD", " ", "*)"}], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0.5, 0]], 
           RowBox[{
            RowBox[{
             RowBox[{"d", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"\[Delta]", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"g", "*", 
                RowBox[{"Inf", "[", "t", "]"}]}], "+", 
               RowBox[{
                StyleBox["p",
                 FontColor->RGBColor[1, 0, 0]], "*", " ", 
                RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}]}], ",", " ", 
           RowBox[{"(*", 
            RowBox[{
            "0.1", " ", "pq", " ", "es", " ", "el", " ", "10", " ", "por", 
             " ", "ciento", " ", "de", " ", "los", " ", "infectados"}], 
            "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{"(*", " ", 
            RowBox[{"INITIAL", " ", "CONDITIONS"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"S", "[", "0", "]"}], "\[Equal]", "PM"}], ",", 
           RowBox[{
            RowBox[{"Ex", "[", "0", "]"}], "\[Equal]", "0"}], ",", " ", 
           RowBox[{
            RowBox[{"Inf", "[", "0", "]"}], "\[Equal]", "3"}], ",", 
           RowBox[{
            RowBox[{"A", "[", "0", "]"}], "\[Equal]", "0.0"}], ",", 
           RowBox[{
            RowBox[{"R", "[", "0", "]"}], "\[Equal]", "0.0"}], ",", 
           RowBox[{
            RowBox[{"d", "[", "0", "]"}], "\[Equal]", "0.0"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"S", ",", "Ex", ",", "Inf", ",", "A", ",", "R", ",", "d"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
         RowBox[{"Method", "\[Rule]", "\"\<StiffnessSwitching\>\""}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "7"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "6"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"REPRESENTATION", " ", "AND", " ", "PLOTS"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"QQ2", "=", 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{
              StyleBox["Plot",
               FontColor->RGBColor[1, 0.5, 0]], 
              StyleBox["[",
               FontColor->RGBColor[1, 0.5, 0]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox["[",
                 FontColor->RGBColor[1, 0.5, 0]], 
                RowBox[{
                 RowBox[{
                  StyleBox["{",
                   FontColor->RGBColor[1, 0.5, 0]], 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Inf", "[", "t", "]"}], ";", 
                    StyleBox[
                    RowBox[{"Ex", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[";",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[
                    RowBox[{"R", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]]}], 
                   StyleBox[",",
                    FontColor->RGBColor[1, 0.5, 0]], 
                   StyleBox[
                    RowBox[{"d", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], ",", 
                   RowBox[{
                    RowBox[{"A", "[", "t", "]"}], ";", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"R", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox["+",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[
                    RowBox[{"d", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox["+",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    RowBox[{"A", "[", "t", "]"}]}]}], ",", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Gamma]", "*", "r"}], "+", 
                    RowBox[{"\[Delta]", "*", "g"}], "+", 
                    RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", "t"}], "}"}]}], "]"}]}], 
                    ";"}]}], 
                  StyleBox["}",
                   FontColor->RGBColor[1, 0.5, 0]]}], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[" ",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\t",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "\"\<Inf[t]\>\"", ";", "\"\<Ex[t]\>\"", ";", 
                    "\"\<R[t]\>\""}], ",", "\"\<d[t]\>\"", ",", 
                   "\"\<A[t]\>\"", ",", "\"\<R[t]+d[t]+A[t]\>\""}], "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[" ",
                FontColor->RGBColor[1, 0.5, 0]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"5", ",", "tshow"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "cota"}], "}"}]}], "}"}],
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"Thickness", "[", ".004725", "]"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "6", ",", "6"}], "}"}], "]"}]}], "}"}], 
                    ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Green", "[", "1.5", "]"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "15"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0047251", "]"}]}], "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Magenta", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Magenta", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ",", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Cyan", ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Magenta", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Green", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               RowBox[{
                StyleBox["GridLines",
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0.5, 0]], "None"}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dotted", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotRange", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"0.7", "*", "tmax"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "None"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FillingStyle", "->", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.1", "]"}], ",", "Blue"}], 
                  "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]]}], 
              StyleBox["]",
               FontColor->RGBColor[1, 0.5, 0]]}], 
             StyleBox[",",
              FontColor->RGBColor[1, 0.5, 0]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[1, 0.5, 0]], 
             RowBox[{"DateListPlot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "DatosFallecidos", ",", "DatosRecuperados", ",", 
                 "DatosAcumulados"}], "}"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotTheme",
                 FontColor->RGBColor[1, 0, 0]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Bussiness\>\"", ",", "\"\<OpenMarkersThick\>\""}], 
                  "}"}],
                 FontColor->RGBColor[0, 0, 1]]}]}], "]"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           StyleBox["Plot",
            FontColor->RGBColor[1, 0, 0]], 
           StyleBox["[",
            FontColor->RGBColor[1, 0, 0]], 
           RowBox[{
            RowBox[{
             StyleBox["Evaluate",
              FontColor->RGBColor[1, 0, 0]], 
             StyleBox["[",
              FontColor->RGBColor[0, 0, 1]], 
             RowBox[{
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox[
                 RowBox[{"Inf", "[", "t", "]"}],
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[",",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"Ex", "[", "t", "]"}],
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox[",",
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox[
                 RowBox[{"S", "[", "t", "]"}],
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["/.",
               FontColor->RGBColor[1, 0.5, 0]], 
              StyleBox["s",
               FontColor->RGBColor[1, 0.5, 0]]}], 
             StyleBox["]",
              FontColor->RGBColor[1, 0.5, 0]]}], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[" ",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\t",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             StyleBox["PlotLegends",
              FontColor->RGBColor[1, 0, 0]], 
             StyleBox["\[Rule]",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<S\>\"", ";", "\"\<Inf\>\""}], ",", 
                "\"\<Ex\>\""}], "}"}],
              FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             StyleBox["PlotRange",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox["\[Rule]",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox["All",
              FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"ImageSize", "\[Rule]", "450"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", "Black", "}"}], ";", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Darker", "[", "Red", "]"}], 
                   RowBox[{"(*", 
                    RowBox[{"Blue", "[", "2", "]"}], "*)"}], ",", 
                   RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", ".00475", "]"}]}], "}"}]}], ",", 
                
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Green", "[", "1.5", "]"}], 
                  RowBox[{"(*", "Red", "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"4", ",", "6", ",", "4"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".004745", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Magenta", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Black", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", "DotDashed",
                   ",", 
                  RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], "}"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"Frame", "->", "True"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"GridLines", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "130", "}"}], ",", "None"}], "}"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"GridLinesStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             FormBox[
              RowBox[{"\[IndentingNewLine]", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<infection probability\>\"", ",", "30"}], 
                    "]"}], "]"}]}], "}"}]}]}],
              TraditionalForm],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FrameStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
               "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FrameTicksStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "20"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"Filling", "\[Rule]", "Axis"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FillingStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]]}], 
           StyleBox["]",
            FontColor->RGBColor[1, 0, 0]]}]}], "}"}], ",", 
        RowBox[{
         StyleBox["{",
          FontColor->RGBColor[0, 0, 1]], " ", 
         RowBox[{
          RowBox[{"Q2", "=", 
           RowBox[{
            StyleBox["Show",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["[",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             RowBox[{
              StyleBox["ListPlot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               StyleBox[
                RowBox[{"{", 
                 RowBox[{
                 "CasosACTIVOS", ",", "CasosPORdiaHOPKINS", ",", 
                  "CASOSporDIAresta"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotMarkers", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Automatic", ",", "12"}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "tshow"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "167800"}], "}"}]}], "}"}],
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"DIAMX", ",", "Red"}], "}"}], ",", "180"}], "}"}],
                    ",", 
                   RowBox[{"{", "}"}]}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}], 
             StyleBox[",",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox[
              RowBox[{"(*", "THEORETICAL", "*)"}],
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[0, 0, 1]], 
             RowBox[{
              StyleBox["Plot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["[",
                 FontColor->RGBColor[0, 0, 1]], 
                RowBox[{
                 StyleBox[
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"A", "[", "t", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Gamma]", "*", "r"}], "+", 
                    RowBox[{"\[Delta]", "*", "g"}], "+", 
                    RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", "t"}], "}"}]}], "]"}], "-", 
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", 
                    RowBox[{"t", "-", "1"}]}], "}"}]}], "]"}]}], ")"}]}]}], 
                   "}"}],
                  FontColor->RGBColor[0, 0, 1]], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\t",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<S\>\"", ";", "\"\<A[t]\>\""}], ",", 
                   "\"\<Casos por d\[IAcute]a\>\""}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotRange", "\[Rule]", "Automatic"}],
                FontColor->RGBColor[1, 0, 1]], 
               RowBox[{
                StyleBox["(*",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "370"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "35000"}], "}"}]}], "}"}],
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["*)",
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", "Black", "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Magenta", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Magenta", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ",", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Magenta", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Black", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    "DotDashed", ",", 
                    RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}]}], 
                  "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", "98", "}"}], ",", "None"}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FillingStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}]}], 
            StyleBox["]",
             FontColor->RGBColor[0, 0, 1]]}]}], 
          StyleBox[",",
           FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->RGBColor[0, 0, 1]], 
          RowBox[{
           StyleBox["D2",
            FontColor->RGBColor[0, 0, 1]], 
           StyleBox["=",
            FontColor->RGBColor[0, 0, 1]], 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{
              StyleBox["ListPlot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               StyleBox[
                RowBox[{"{", "CASOSporDIAresta", "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotMarkers",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[0, 0, 1]], 
                Graphics3DBox[
                 {GrayLevel[0], EdgeForm[None], Glow[
                   RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0]], 
                  CuboidBox[{0, 0, 0}]},
                 Boxed->False,
                 ImageSize->{13.693338432432654`, 12.},
                 
                 ViewPoint->{0.17134623817277983`, 0.2733380173970694, 
                  3.3683715345711907`},
                 
                 ViewVertical->{-0.5474806517236538, 0.6107600623868774, 
                  0.5720463986263885}]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "tshow"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "9500"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "1.3"}], ",", 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"DIAMX", ",", "Red"}], "}"}], "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}], 
             StyleBox[",",
              FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
             RowBox[{
              StyleBox["Plot",
               FontColor->GrayLevel[0]], 
              StyleBox["[",
               FontColor->GrayLevel[0]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->GrayLevel[0]], 
                StyleBox["[",
                 FontColor->GrayLevel[0]], 
                RowBox[{
                 StyleBox[
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Gamma]", "*", "r"}], "+", 
                    RowBox[{"\[Delta]", "*", "g"}], "+", 
                    RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", "t"}], "}"}]}], "]"}], "-", 
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", 
                    RowBox[{"t", "-", "1"}]}], "}"}]}], "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"0.1", "*", 
                    RowBox[{"A", "[", "t", "]"}]}], ";"}]}], "}"}],
                  FontColor->GrayLevel[0]], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[
                RowBox[{"(*", 
                 RowBox[{"Evaluate", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ki", "*", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Inf", "[", "t", "]"}]}], "PM"]}], ",", 
                    RowBox[{"ke", "*", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Ex", "[", "t", "]"}]}], "PM"]}], ",", 
                    RowBox[{
                    FractionBox["1", "1000"], 
                    FractionBox[
                    RowBox[{"Ex", "[", "t", "]"}], 
                    RowBox[{"Inf", "[", "t", "]"}]]}]}], "}"}], "/.", "s"}], 
                  "]"}], "*)"}],
                FontColor->GrayLevel[0.5]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\t",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<S\>\"", ";", "\"\<casos diarios\>\""}], 
                  RowBox[{"(*", 
                   RowBox[{
                   "\"\<ki*\!\(\*FractionBox[\(S[t]*Inf[t]\), \(PM\)]\)\>\"", 
                    ",", 
                    "\"\<ke*\!\(\*FractionBox[\(S[t]*Ex[t]\), \(PM\)]\)\>\"", 
                    ",", "\"\<\!\(\*FractionBox[\(1\), \
\(1000\)]\)\!\(\*FractionBox[\(Ex[t]\), \(Inf[t]\)]\)\>\""}], "*)"}], "}"}]}],
                
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[" ",
                FontColor->GrayLevel[0]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["Automatic",
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", "Black", "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Magenta", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Red", 
                    RowBox[{"(*", "Red", "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00245", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Magenta", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Black", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    "DotDashed", ",", 
                    RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", "98", "}"}], ",", "None"}], "}"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<infection probability\>\"", ",", "30"}], 
                    "]"}], "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FillingStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], 
                  "]"}]}],
                FontColor->GrayLevel[0]]}], 
              StyleBox["]",
               FontColor->GrayLevel[0]]}]}], "\[IndentingNewLine]", "]"}]}]}], 
         StyleBox["\[IndentingNewLine]",
          FontColor->RGBColor[0, 0, 1]], 
         StyleBox["}",
          FontColor->RGBColor[0, 0, 1]]}]}], 
       StyleBox["}",
        FontColor->RGBColor[0, 0, 1]]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<PLOT BOUND\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cota", ",", "1200000", ",", "\"\<cota\>\""}], "}"}], ",", "5", 
     ",", "9390000"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<MAXIMAL TIME\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmax", ",", "tshow", ",", "\"\<tmax\>\""}], "}"}], ",", "10", 
     ",", "16000"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<SHOW TIME\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tshow", ",", "579", ",", "\"\<tshow\>\""}], "}"}], ",", "10", 
     ",", "1600"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<HOUSE CONFINEMENT START\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tic", ",", "23", ",", "\"\<tic\>\""}], "}"}], ",", "10", ",", 
     "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<ECONOMIC PRESSURE INATTENTION\>\"", ",", "12", ",", "Bold"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tds2", ",", "51", ",", "\"\<tds2\>\""}], "}"}], ",", "30", ",",
      "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<END-DOWN HOME CONFINEMENT\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tf2", ",", "90", ",", "\"\<tf2\>\""}], "}"}], ",", "30", ",", 
     "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<INFECTION RATE DECREASE AT ti\>\"", ",", "12", ",", "Bold"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]ki", ",", "0.25", 
       RowBox[{"(*", 
        RowBox[{"de", " ", "uno", " ", "solo", " ", "es", " ", "0.41"}], 
        "*)"}], ",", "\"\<\[CapitalDelta]ki\>\""}], "}"}], ",", "0", ",", 
     "2"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<INFECTION RATE INCREASE AT tds2\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]kds2", ",", "0.23", ",", 
       "\"\<\[CapitalDelta]kds2\>\""}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<INFECTION RATE INCREASE AT HC END at tf2\>\"", ",", "12", ",", 
     "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]kf2", ",", "0.0", ",", "\"\<\[CapitalDelta]kf2\>\""}], 
      "}"}], ",", "0", ",", "50"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"PARAMETERS", " ", "SUSCEPTIBLE"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"SUSCEPTIBLE\",FontColor->GrayLevel[0]]\)\>\"", ",", 
     "12", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "0", ",", "\"\<\[Mu]\>\""}], "}"}], ",", "0.0", 
     ",", "0.0000006"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PM", ",", 
       RowBox[{"(*", 
        RowBox[{"1860", "*", 
         SuperscriptBox["10", "3"]}], "*)"}], 
       RowBox[{"1500", "*", 
        SuperscriptBox["10", "3"]}], ",", "\"\<PM\>\""}], "}"}], ",", "100", 
     ",", 
     RowBox[{"130", "*", 
      SuperscriptBox["10", "5"]}]}], "}"}], ",", " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "THE", " ", "ESTIMATION", " ", "OF", " ", "THE", " ", "NUMBER", " ", 
      "OF", " ", "SUSCEPTIBLE", " ", "INDIVIDUALS"}], ",", " ", 
     RowBox[{"1.5", " ", "million"}], ",", " ", 
     RowBox[{"1.0", " ", "million"}], ",", " ", 
     RowBox[{"0.85", " ", "million"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kv", ",", "0.000031", ",", "\"\<kv\>\""}], "}"}], ",", 
     "0.0000001", ",", "0.51"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ke", ",", 
       RowBox[{"11.62", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"7.7", "*", 
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]]}], "-", 
         RowBox[{"1.3", "millones"}]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"0.905", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "7"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"7.6", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"6.6", "*", 
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]]}], "-", 
         RowBox[{"1.5", "millones"}]}], "*)"}], ",", 
       "\"\<\!\(\*StyleBox[\"ke\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.00", ",", "0.00001"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ki", ",", 
       RowBox[{"15.00", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}], 
       RowBox[{"(*", 
        RowBox[{"6.5", "*", 
         RowBox[{
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]], "--"}], "1.3", "millones"}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"1.0", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "7"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"7.6", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"5.4", "*", 
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]]}], "-", 
         RowBox[{"1.5", "millones"}]}], "*)"}], ",", 
       "\"\<\!\(\*StyleBox[\"ki\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.00", ",", "0.00001"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"13", "Million"}], ":", " ", "ke"}], " ", "=", " ", 
      RowBox[{"7.7", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"6.5", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"kv", "=", "0.000009"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"5", "Million"}], ":", " ", "ke"}], " ", "=", " ", 
      RowBox[{"2.66", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"6.2", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"kv", "=", "0.000031"}], ",", " ", 
     RowBox[{"\[CapitalDelta]ki", "=", "0.25"}], ",", " ", 
     RowBox[{"\[CapitalDelta]kds2", "=", "0.23"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"3", "Million"}], ":", " ", "ke"}], " ", "=", " ", 
      RowBox[{"5.66", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"0.950", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"kv", "=", "0.000031"}], ",", " ", 
     RowBox[{"\[CapitalDelta]ki", "=", "0.25"}], ",", " ", 
     RowBox[{"\[CapitalDelta]kds2", "=", "0.23"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"1.5", 
        RowBox[{"Million", ":", " ", "ke"}]}]}], " ", "=", " ", 
      RowBox[{"11.62", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"15.50", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"1.0", 
        RowBox[{"Million", ":", " ", "ke"}]}]}], " ", "=", " ", 
      RowBox[{"1.105", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"0.94", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"0.85", 
        RowBox[{"Million", ":", " ", "ke"}]}]}], " ", "=", " ", 
      RowBox[{"1.46", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"1.0", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}]}], "*)"}], "\[IndentingNewLine]", "Delimiter",
    ",", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"PARAMETERS", " ", "EXPOSED"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"EXPOSED\",FontColor->RGBColor[1, 0, 0]]\)\>\"", ",",
      "12", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "0.07", ",", "\"\<\[Alpha]\>\""}], "}"}], ",", 
     "0.0001", ",", "0.56"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Beta]", ",", "0.0", ",", "\"\<\[Beta]\>\""}], "}"}], ",", 
     "0.0", ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0.07", ",", "\"\<\[Epsilon]\>\""}], "}"}], 
     ",", "0.0", ",", "0.52"}], "}"}], ",", "Delimiter", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"PARAMETROS", " ", "INFECTED"}], ",", " ", 
     RowBox[{"RECOVERED", " ", "AND", " ", "DEAD"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<PARAMETERS \!\(\*StyleBox[\"I\",FontColor->GrayLevel[0.5]]\), R AND \
D\>\"", ",", "12", ",", "Bold"}], "]"}], ",", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<a+r+g=1\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0.15", ",", "\"\<a\>\""}], "}"}], ",", "0.001", ",", 
     "0.61"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", "0.79", ",", "\"\<r\>\""}], "}"}], ",", "0.001", ",", 
     "1.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", ",", "0.06", ",", "\"\<g\>\""}], "}"}], ",", "0.001", ",", 
     "0.61"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Fit", " ", "1"}], ":", " ", 
       RowBox[{
       "all", " ", "difference", " ", "is", " ", "passed", " ", "to", " ", 
        "deaths", " ", "a"}]}], "=", "0.1"}], ",", " ", 
     RowBox[{"r", "=", "0.79"}], ",", " ", 
     RowBox[{"g", "=", "0.11"}], ",", " ", 
     RowBox[{"no", " ", "fit", " ", "of", " ", "active", " ", "data"}]}], 
    "*)"}], "\t", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Fit", " ", "2"}], ":", " ", 
       RowBox[{
       "the", " ", "difference", " ", "is", " ", "divided", " ", "between", 
        " ", "deaths", " ", "and", " ", "active", " ", "a"}]}], "=", "0.15"}],
      ",", " ", 
     RowBox[{"r", "=", "0.79"}], ",", " ", 
     RowBox[{"g", "=", "0.06"}], ",", " ", 
     RowBox[{"fits", " ", "active", " ", "data"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Gamma]", ",", "0.015", ",", "\"\<\[Gamma]\>\""}], "}"}], ",", 
     RowBox[{"7.6", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "9"}]]}], ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", "0.038", ",", "\"\<\[Delta]\>\""}], "}"}], ",", 
     RowBox[{"7.6", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "9"}]]}], ",", "0.16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["p",
        FontColor->GrayLevel[0]], ",", "0.094", ",", 
       "\"\<\!\(\*StyleBox[\"p\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.001", ",", "1.03"}], "}"}], ",", "Delimiter"}], "]"}]], "Input",
 CellChangeTimes->{{3.711729954340054*^9, 3.711729956324499*^9}, {
   3.711738971008939*^9, 3.711739003865344*^9}, {3.711739071037417*^9, 
   3.711739073781252*^9}, {3.712164671563403*^9, 3.7121647245927362`*^9}, {
   3.7121649553407907`*^9, 3.712164982647224*^9}, {3.712165387900572*^9, 
   3.712165388235567*^9}, {3.7121658711976223`*^9, 3.712165881043228*^9}, {
   3.712166061448382*^9, 3.712166151474473*^9}, {3.712274099753539*^9, 
   3.712274130071575*^9}, {3.712274280570286*^9, 3.712274331045611*^9}, {
   3.712274382535644*^9, 3.712274401902049*^9}, {3.713737129072657*^9, 
   3.713737166582645*^9}, {3.713737260799563*^9, 3.713737388466825*^9}, {
   3.713737454428985*^9, 3.7137374906047*^9}, {3.713737566576869*^9, 
   3.7137376029806433`*^9}, {3.713737658956127*^9, 3.713737669348387*^9}, {
   3.713738122417261*^9, 3.713738213406781*^9}, {3.713738363109664*^9, 
   3.713738376556579*^9}, {3.714077117026526*^9, 3.714077215134033*^9}, {
   3.714077270680789*^9, 3.714077288521551*^9}, {3.714077611146154*^9, 
   3.714077613892441*^9}, {3.714077748002359*^9, 3.714077786241764*^9}, {
   3.714077905595498*^9, 3.714077908897132*^9}, {3.714078543563571*^9, 
   3.714078554793433*^9}, {3.71407868294701*^9, 3.714078700083721*^9}, {
   3.714153549994382*^9, 3.7141535543193703`*^9}, {3.714153636150062*^9, 
   3.714153729234756*^9}, {3.7141538608724117`*^9, 3.7141538736245604`*^9}, {
   3.714154022538254*^9, 3.7141540755120077`*^9}, {3.714154213546674*^9, 
   3.714154214562076*^9}, {3.714154593540373*^9, 3.714154610274098*^9}, {
   3.714155228083674*^9, 3.7141552608320303`*^9}, {3.714155745380722*^9, 
   3.714155745485972*^9}, {3.7141557817788973`*^9, 3.714155785867587*^9}, {
   3.71415587815765*^9, 3.714155895192087*^9}, {3.7141559405292673`*^9, 
   3.714155955919264*^9}, {3.714156104670073*^9, 3.714156112073913*^9}, {
   3.7141562876058207`*^9, 3.7141563111267033`*^9}, {3.714156684779256*^9, 
   3.714156711074024*^9}, {3.714156760106388*^9, 3.714156798912208*^9}, {
   3.7141568351064167`*^9, 3.714156835324641*^9}, {3.714156962407461*^9, 
   3.714156967380425*^9}, {3.7141570136701612`*^9, 3.714157013845169*^9}, {
   3.7141573557611437`*^9, 3.7141573766467323`*^9}, {3.714157453862186*^9, 
   3.7141574715011587`*^9}, {3.71415752931112*^9, 3.714157549229629*^9}, {
   3.7142182106688547`*^9, 3.714218301450759*^9}, {3.714218720643467*^9, 
   3.7142187411565237`*^9}, {3.714218778588337*^9, 3.714218798530044*^9}, {
   3.714219061823141*^9, 3.714219062222157*^9}, {3.7142191073505173`*^9, 
   3.714219107748465*^9}, {3.71421916122999*^9, 3.714219184549033*^9}, {
   3.714220016628824*^9, 3.714220017491983*^9}, {3.714221875626923*^9, 
   3.714221875957148*^9}, {3.7142234934637003`*^9, 3.7142235922138147`*^9}, {
   3.714223658901909*^9, 3.714223689373168*^9}, {3.714223757116069*^9, 
   3.714223790667165*^9}, {3.7142238219221897`*^9, 3.7142238242659483`*^9}, {
   3.714224176109393*^9, 3.714224178484573*^9}, {3.714254957427874*^9, 
   3.714254990304831*^9}, {3.714255192399744*^9, 3.71425525692743*^9}, {
   3.7142558967880983`*^9, 3.7142560265826387`*^9}, {3.714480607780813*^9, 
   3.714480694764051*^9}, {3.7144816756794453`*^9, 3.714481705145686*^9}, {
   3.714481752207869*^9, 3.7144818923550997`*^9}, {3.7144819360517883`*^9, 
   3.7144822548085213`*^9}, {3.714482293945115*^9, 3.7144823155944967`*^9}, {
   3.7144823967523537`*^9, 3.71448240250736*^9}, {3.714482554835663*^9, 
   3.714482558973225*^9}, {3.714482591946042*^9, 3.714482632846595*^9}, {
   3.7144829762508917`*^9, 3.7144829767282887`*^9}, {3.714483335762742*^9, 
   3.714483338138266*^9}, {3.714483371050714*^9, 3.714483379709846*^9}, {
   3.7144835656192503`*^9, 3.714483584917036*^9}, {3.714483629367248*^9, 
   3.7144836685943832`*^9}, {3.714483763492577*^9, 3.714483812670677*^9}, {
   3.714483936705875*^9, 3.714483978240472*^9}, {3.714484016038878*^9, 
   3.714484036777749*^9}, {3.714484160784383*^9, 3.714484167464107*^9}, {
   3.714484265783801*^9, 3.714484286228016*^9}, {3.714484361896934*^9, 
   3.7144843643272142`*^9}, {3.714484619222576*^9, 3.714484656925007*^9}, {
   3.714484745111253*^9, 3.71448494340764*^9}, {3.714485121244102*^9, 
   3.714485284675353*^9}, {3.714485355583222*^9, 3.714485360863946*^9}, {
   3.714485833764636*^9, 3.71448587230623*^9}, {3.714486062143754*^9, 
   3.714486064403838*^9}, {3.7144861027240877`*^9, 3.714486118239365*^9}, {
   3.714486150266515*^9, 3.7144862013793364`*^9}, {3.714486390329928*^9, 
   3.714486390636106*^9}, {3.7144864572787533`*^9, 3.714486468900818*^9}, {
   3.714486526051447*^9, 3.7144865644872217`*^9}, {3.7144867818769293`*^9, 
   3.71448687388052*^9}, {3.7144869049769793`*^9, 3.7144869054731627`*^9}, {
   3.714487065468987*^9, 3.714487139819433*^9}, {3.714487183410347*^9, 
   3.71448738833537*^9}, {3.717349693320345*^9, 3.717349740453195*^9}, {
   3.717350079168056*^9, 3.717350086380246*^9}, {3.71845690929853*^9, 
   3.71845695398526*^9}, {3.7184572214710903`*^9, 3.718457222852251*^9}, {
   3.718816638664481*^9, 3.718816661542137*^9}, {3.718816800003872*^9, 
   3.718816865906147*^9}, {3.718817085865926*^9, 3.71881709162357*^9}, {
   3.718817176704772*^9, 3.718817270224373*^9}, {3.718817305763151*^9, 
   3.718817338336203*^9}, {3.718817370909346*^9, 3.718817387608567*^9}, {
   3.718817556716817*^9, 3.718817563675448*^9}, {3.7188331351875153`*^9, 
   3.718833582993123*^9}, {3.7188336605246277`*^9, 3.71883366642411*^9}, {
   3.718833795557376*^9, 3.7188338112253942`*^9}, {3.718833858783062*^9, 
   3.718833860507453*^9}, {3.718833938318581*^9, 3.718833993299055*^9}, {
   3.71883406564876*^9, 3.718834188554323*^9}, {3.718834340226613*^9, 
   3.7188343812737083`*^9}, {3.718834420356894*^9, 3.7188344223231564`*^9}, {
   3.718834458196169*^9, 3.718834580327383*^9}, {3.718834629078668*^9, 
   3.718834671951363*^9}, {3.718834811705233*^9, 3.71883481383969*^9}, {
   3.718835150774345*^9, 3.7188351982555532`*^9}, {3.718835291268371*^9, 
   3.718835298128435*^9}, {3.71883541892013*^9, 3.71883561316371*^9}, 
   3.718836177353386*^9, 3.7188363187304068`*^9, {3.7188372124374743`*^9, 
   3.71883721502043*^9}, 3.718920796592367*^9, {3.718921264274316*^9, 
   3.7189213106504717`*^9}, {3.718921727148834*^9, 3.718921770858821*^9}, {
   3.7189221315661488`*^9, 3.718922197028365*^9}, {3.718922284818552*^9, 
   3.718922329443248*^9}, {3.718923118932888*^9, 3.718923120772099*^9}, {
   3.795542833486764*^9, 3.7955428689584293`*^9}, {3.79554292552002*^9, 
   3.795542968561204*^9}, {3.795543050114479*^9, 3.795543121634713*^9}, {
   3.795543259490137*^9, 3.79554335328308*^9}, {3.7955434292288847`*^9, 
   3.7955434953754272`*^9}, {3.795543536550571*^9, 3.795543629443152*^9}, {
   3.7955436698698606`*^9, 3.7955437094943132`*^9}, {3.79554376062488*^9, 
   3.795543763574217*^9}, {3.795544091574581*^9, 3.795544181638977*^9}, {
   3.795544234105466*^9, 3.795544242376464*^9}, {3.7955442751855507`*^9, 
   3.7955443767703876`*^9}, {3.79554441525065*^9, 3.795544445418798*^9}, {
   3.795544481619906*^9, 3.795544737148284*^9}, {3.7955447830389547`*^9, 
   3.795544840901479*^9}, {3.795544880217484*^9, 3.795544943819026*^9}, {
   3.795544975865534*^9, 3.795545401715242*^9}, {3.795545442316824*^9, 
   3.795545545653615*^9}, {3.795545615465994*^9, 3.795545641856735*^9}, {
   3.795545806572172*^9, 3.7955458167863894`*^9}, {3.795545855026129*^9, 
   3.795545857301654*^9}, {3.795546016906817*^9, 3.795546020896883*^9}, {
   3.795546071523148*^9, 3.79554610355268*^9}, {3.795546149016691*^9, 
   3.795546149246221*^9}, {3.7955461803008957`*^9, 3.795546200161718*^9}, 
   3.7955463121976433`*^9, {3.79554639390663*^9, 3.795546484705008*^9}, {
   3.795546529562613*^9, 3.7955465576466427`*^9}, {3.795546623599684*^9, 
   3.7955467089033813`*^9}, {3.795546765817113*^9, 3.7955467745895567`*^9}, {
   3.795546804795845*^9, 3.7955468320431643`*^9}, {3.795547793519363*^9, 
   3.7955478434120903`*^9}, {3.79554906007896*^9, 3.795549068183605*^9}, {
   3.795549203657187*^9, 3.795549206627883*^9}, {3.795549314288898*^9, 
   3.795549366964684*^9}, 3.7955493999694977`*^9, {3.7955494796254063`*^9, 
   3.795549588248067*^9}, {3.795549626052507*^9, 3.795549671647861*^9}, {
   3.795549764337006*^9, 3.795549828495717*^9}, {3.795549889785903*^9, 
   3.795549959245913*^9}, {3.795549997418252*^9, 3.795550001665606*^9}, {
   3.7955500602511377`*^9, 3.795550096456211*^9}, {3.795550164870023*^9, 
   3.795550234078429*^9}, {3.795550274843696*^9, 3.795550287651503*^9}, {
   3.7955503188745613`*^9, 3.7955504671761637`*^9}, {3.795550500831319*^9, 
   3.795550501108577*^9}, {3.795550540770461*^9, 3.79555054106678*^9}, {
   3.795550642259984*^9, 3.795550696530199*^9}, {3.795550758856057*^9, 
   3.795550774570706*^9}, {3.795550839779332*^9, 3.795550867832979*^9}, {
   3.795550943571944*^9, 3.795550958371125*^9}, {3.7955513320814657`*^9, 
   3.7955513740830307`*^9}, {3.795551448524562*^9, 3.795551450610718*^9}, {
   3.7955515553295*^9, 3.795551556297287*^9}, {3.7955516013845243`*^9, 
   3.795551601838323*^9}, {3.7955516460941687`*^9, 3.795551671725256*^9}, {
   3.795551961421616*^9, 3.795551961736171*^9}, {3.795552291168591*^9, 
   3.7955522998775883`*^9}, {3.79555241213992*^9, 3.7955524512904243`*^9}, {
   3.7955524818950787`*^9, 3.795552482239216*^9}, {3.7955525224177*^9, 
   3.795552631029708*^9}, 3.795552666820373*^9, {3.795552772392921*^9, 
   3.7955527786726637`*^9}, {3.7955528956652412`*^9, 
   3.7955529051819363`*^9}, {3.7955529352005987`*^9, 3.7955529394172163`*^9}, 
   3.795552999243191*^9, {3.7955530372920237`*^9, 3.7955530488779497`*^9}, {
   3.795553082611936*^9, 3.795553089971964*^9}, {3.795619758878785*^9, 
   3.79561986744661*^9}, {3.7956201674531403`*^9, 3.795620291205554*^9}, {
   3.795621117321761*^9, 3.795621118054132*^9}, {3.79562116077145*^9, 
   3.7956211777577677`*^9}, {3.795621261114653*^9, 3.795621354689126*^9}, {
   3.795621425337575*^9, 3.7956214257403793`*^9}, {3.795621656777135*^9, 
   3.795621686537797*^9}, {3.795621746782164*^9, 3.795621759347026*^9}, {
   3.795621802584236*^9, 3.795621811032847*^9}, {3.7956218421093073`*^9, 
   3.795621842526598*^9}, {3.795621908343255*^9, 3.795621908747498*^9}, {
   3.795622025823073*^9, 3.795622038510187*^9}, {3.795622071711728*^9, 
   3.7956221001721363`*^9}, {3.795628535270376*^9, 3.795628577925654*^9}, {
   3.795628610605863*^9, 3.7956286433155622`*^9}, {3.795628679367074*^9, 
   3.795628707583602*^9}, {3.795628742783091*^9, 3.7956287459951067`*^9}, {
   3.795628787663509*^9, 3.795628801526518*^9}, {3.795628922522523*^9, 
   3.7956289456147547`*^9}, {3.79562906866321*^9, 3.795629141331089*^9}, {
   3.795629229443163*^9, 3.795629230245015*^9}, 3.7956296628177233`*^9, {
   3.7956297537535343`*^9, 3.79562976979946*^9}, {3.795629877018758*^9, 
   3.795629975815221*^9}, {3.7956301053017597`*^9, 3.795630135255445*^9}, {
   3.7956301932189417`*^9, 3.795630207161447*^9}, {3.795630238385459*^9, 
   3.795630321365858*^9}, {3.795630439800235*^9, 3.7956304475886*^9}, {
   3.795630515236383*^9, 3.795630522841693*^9}, {3.79563057851457*^9, 
   3.795630614623487*^9}, {3.7956306967809877`*^9, 3.795630728797262*^9}, {
   3.795630777418799*^9, 3.79563082718865*^9}, {3.7956309542611*^9, 
   3.795630960533284*^9}, {3.795631066538382*^9, 3.795631067658787*^9}, {
   3.795631264225235*^9, 3.795631264603104*^9}, {3.795631359712523*^9, 
   3.7956313726504927`*^9}, {3.795631497181748*^9, 3.795631500708872*^9}, {
   3.795631613554055*^9, 3.795631614332947*^9}, {3.795631768763275*^9, 
   3.7956318097362843`*^9}, {3.795631949939711*^9, 3.795631973448934*^9}, {
   3.795632015476939*^9, 3.795632016841352*^9}, {3.7956320752522583`*^9, 
   3.795632134585699*^9}, {3.795632172494339*^9, 3.7956322218183537`*^9}, {
   3.795633317991721*^9, 3.795633484183844*^9}, {3.795633561920763*^9, 
   3.795633628229082*^9}, {3.79563366217828*^9, 3.795633733418969*^9}, {
   3.7956338166385593`*^9, 3.795633855817371*^9}, {3.7956338954258432`*^9, 
   3.795633899505522*^9}, {3.795633947672361*^9, 3.795633947856947*^9}, {
   3.7956340930491257`*^9, 3.7956341061102533`*^9}, {3.7956342542349253`*^9, 
   3.795634260512282*^9}, {3.795634294529277*^9, 3.795634307223027*^9}, {
   3.7956343759492407`*^9, 3.7956343765209713`*^9}, {3.795634409994919*^9, 
   3.795634462146207*^9}, 3.79563461018738*^9, {3.795634651524535*^9, 
   3.795634653004127*^9}, {3.795634840615506*^9, 3.795634848639057*^9}, 
   3.795634998797332*^9, {3.795635079995406*^9, 3.795635107959752*^9}, {
   3.795635205986425*^9, 3.795635206343422*^9}, {3.795635252665676*^9, 
   3.795635253244371*^9}, 3.795635398156228*^9, 3.795635610749309*^9, {
   3.7956356537967587`*^9, 3.795635654338224*^9}, {3.795635793244348*^9, 
   3.795635824855201*^9}, {3.795635934068881*^9, 3.7956360044485703`*^9}, {
   3.795636097593938*^9, 3.7956361032554407`*^9}, {3.795636134463891*^9, 
   3.7956361727213182`*^9}, {3.795636252290803*^9, 3.795636252524802*^9}, {
   3.795636414294186*^9, 3.7956364365539703`*^9}, {3.795636473148243*^9, 
   3.7956364811840982`*^9}, {3.795782038550267*^9, 3.7957820425561323`*^9}, {
   3.795782158066917*^9, 3.795782190858387*^9}, {3.795782318071961*^9, 
   3.795782379459877*^9}, {3.795782409609447*^9, 3.795782430968006*^9}, {
   3.795782467107799*^9, 3.795782469777012*^9}, {3.795782528996743*^9, 
   3.795782541043078*^9}, {3.795782583486823*^9, 3.7957826400352182`*^9}, {
   3.7957827217478123`*^9, 3.795782780936268*^9}, {3.79578284243869*^9, 
   3.795782844526272*^9}, {3.7957828880539417`*^9, 3.795782908253017*^9}, {
   3.795782967365428*^9, 3.795782975150702*^9}, {3.7957830478185883`*^9, 
   3.79578304830961*^9}, 3.79578316061954*^9, {3.795783206263489*^9, 
   3.7957832755958433`*^9}, {3.795783336921857*^9, 3.795783373835546*^9}, 
   3.795783429996449*^9, {3.795783926568275*^9, 3.795783962362857*^9}, {
   3.7957841357063427`*^9, 3.7957841436143436`*^9}, {3.795784210681275*^9, 
   3.795784227507436*^9}, {3.795784275375592*^9, 3.7957843585651207`*^9}, {
   3.795784430402952*^9, 3.7957845764459*^9}, {3.7957846073810787`*^9, 
   3.79578464978973*^9}, {3.795784690186502*^9, 3.79578469557662*^9}, {
   3.795784726720399*^9, 3.79578477557012*^9}, {3.795784879537244*^9, 
   3.795784896727394*^9}, {3.795784931712525*^9, 3.7957849612629957`*^9}, {
   3.795785091865172*^9, 3.79578509352359*^9}, {3.7957851342284803`*^9, 
   3.795785202223896*^9}, {3.795785240601211*^9, 3.795785517246338*^9}, {
   3.7957855717382708`*^9, 3.795785691170412*^9}, {3.795785724811449*^9, 
   3.7957857456163883`*^9}, {3.795785780222782*^9, 3.795785857457346*^9}, {
   3.79578590881527*^9, 3.7957859385660753`*^9}, {3.7957860088510237`*^9, 
   3.7957860187191057`*^9}, {3.7957860799316063`*^9, 3.795786197387046*^9}, {
   3.79578626058457*^9, 3.795786342884363*^9}, {3.795786401088601*^9, 
   3.795786421582399*^9}, {3.795786491543186*^9, 3.795786493111671*^9}, {
   3.795786561005953*^9, 3.795786669933839*^9}, {3.7957867097704697`*^9, 
   3.7957867161298113`*^9}, {3.795786747371985*^9, 3.79578679880169*^9}, {
   3.795786897867231*^9, 3.795786917981254*^9}, {3.795786952349931*^9, 
   3.795787029015183*^9}, {3.795787070412734*^9, 3.7957870882648573`*^9}, {
   3.795787129608507*^9, 3.7957873221813183`*^9}, {3.795787462003189*^9, 
   3.795787503328148*^9}, {3.7957875436611223`*^9, 3.795787577010062*^9}, {
   3.795787631212851*^9, 3.7957876998340797`*^9}, {3.7957877422529573`*^9, 
   3.795787836704728*^9}, {3.7957878828711042`*^9, 3.795787886003565*^9}, {
   3.795788040892144*^9, 3.795788043815192*^9}, {3.79578812161808*^9, 
   3.795788292746806*^9}, {3.7957883797882843`*^9, 3.7957883850250273`*^9}, 
   3.795788461287445*^9, {3.795788496652103*^9, 3.795788509781102*^9}, {
   3.795788560811792*^9, 3.795788565974078*^9}, 3.795788701731401*^9, {
   3.795788860061337*^9, 3.79578887258953*^9}, {3.795788938469411*^9, 
   3.795788965083379*^9}, {3.795789086526349*^9, 3.795789121737391*^9}, {
   3.795789197027936*^9, 3.79578919804062*^9}, {3.795789235390772*^9, 
   3.7957892504128*^9}, {3.795789396553404*^9, 3.795789495191134*^9}, {
   3.7957895380845337`*^9, 3.795789614413537*^9}, {3.795789686063385*^9, 
   3.795789696532198*^9}, {3.795789732313293*^9, 3.795789785336784*^9}, 
   3.795789816211685*^9, {3.7957898590734053`*^9, 3.79578993557655*^9}, {
   3.7957900148586893`*^9, 3.795790067259357*^9}, {3.795790155133347*^9, 
   3.795790155336876*^9}, {3.795790212473962*^9, 3.7957902246112843`*^9}, {
   3.795790390463283*^9, 3.7957904766086617`*^9}, {3.795790515825863*^9, 
   3.7957905196037617`*^9}, 3.795790562923875*^9, 3.795790607603211*^9, {
   3.7957906537881947`*^9, 3.795790698528111*^9}, {3.7957907736974707`*^9, 
   3.7957907923333397`*^9}, {3.7957908325218153`*^9, 3.795790832719103*^9}, {
   3.7957908732771873`*^9, 3.795790893808628*^9}, {3.79579097657778*^9, 
   3.795790995378788*^9}, {3.795791075748415*^9, 3.795791105673283*^9}, {
   3.795791154627924*^9, 3.7957911812033052`*^9}, {3.795791239902069*^9, 
   3.79579124312953*^9}, {3.795791343901161*^9, 3.79579137222087*^9}, {
   3.795791407952795*^9, 3.795791487581029*^9}, {3.795791527029274*^9, 
   3.795791534845467*^9}, {3.795791699343894*^9, 3.795791699591612*^9}, 
   3.795791755176799*^9, {3.795791954410819*^9, 3.795792022417221*^9}, {
   3.795792056614357*^9, 3.795792069917982*^9}, 3.7957921218508167`*^9, {
   3.795792183610845*^9, 3.7957921837900057`*^9}, {3.795792250989039*^9, 
   3.79579226699269*^9}, {3.795792359012446*^9, 3.795792370768964*^9}, {
   3.795792424573536*^9, 3.7957924889027853`*^9}, {3.795792556135523*^9, 
   3.7957925792284813`*^9}, {3.795792644707506*^9, 3.795792648977167*^9}, {
   3.795792684767106*^9, 3.795792691401483*^9}, {3.795792834066074*^9, 
   3.795792842253647*^9}, {3.795792893016034*^9, 3.7957929166082363`*^9}, 
   3.795795069933032*^9, {3.795871800234085*^9, 3.795871800972404*^9}, {
   3.795872252446134*^9, 3.7958722653669853`*^9}, {3.795872306995584*^9, 
   3.795872308458313*^9}, {3.795872354899898*^9, 3.795872356566513*^9}, {
   3.7958723950608664`*^9, 3.7958723987124643`*^9}, {3.795884821169723*^9, 
   3.795884822513941*^9}, 3.795885284130666*^9, {3.795885757435296*^9, 
   3.795885757667183*^9}, {3.79588582512621*^9, 3.795885826973892*^9}, 
   3.795885988470344*^9, {3.795886192310576*^9, 3.795886192783255*^9}, {
   3.795886406104313*^9, 3.795886406377469*^9}, {3.7958864829633703`*^9, 
   3.795886484287353*^9}, {3.795886685833653*^9, 3.795886699210099*^9}, {
   3.7959619746843033`*^9, 3.795962079190208*^9}, {3.795962281801262*^9, 
   3.7959622930745993`*^9}, {3.795962396099584*^9, 3.795962412702341*^9}, {
   3.795962520729247*^9, 3.795962523393054*^9}, 3.795962555213168*^9, {
   3.79596263222163*^9, 3.795962669889114*^9}, {3.795962915781598*^9, 
   3.7959629195094643`*^9}, {3.795962971705114*^9, 3.795963127249728*^9}, {
   3.795963224793157*^9, 3.795963226627987*^9}, {3.795963281725286*^9, 
   3.795963415452134*^9}, {3.795963473425249*^9, 3.795963513818653*^9}, {
   3.7959635820623817`*^9, 3.795963712128467*^9}, {3.795963754910881*^9, 
   3.7959637593392553`*^9}, {3.795963978463779*^9, 3.795963982623062*^9}, {
   3.7959666351679993`*^9, 3.7959666571581*^9}, {3.795966793618206*^9, 
   3.795966793945874*^9}, 3.795967009845729*^9, 3.7959671283216667`*^9, {
   3.795967182576317*^9, 3.795967244988328*^9}, {3.795967321475349*^9, 
   3.795967321836473*^9}, {3.795967445386503*^9, 3.795967445809318*^9}, {
   3.795967513816394*^9, 3.795967519050474*^9}, {3.7959676927197523`*^9, 
   3.795967693114888*^9}, {3.795967736097077*^9, 3.795967752014271*^9}, {
   3.795973688438389*^9, 3.7959737159460773`*^9}, {3.7959743168115892`*^9, 
   3.79597432554944*^9}, {3.7959744107132673`*^9, 3.795974465293338*^9}, {
   3.795974523968869*^9, 3.7959745246391487`*^9}, {3.795974557761415*^9, 
   3.795974558503807*^9}, {3.795974691548337*^9, 3.795974693749115*^9}, {
   3.795974823787969*^9, 3.7959748429633207`*^9}, 3.795975595403973*^9, {
   3.795975863186112*^9, 3.795975864211837*^9}, {3.795976048360815*^9, 
   3.795976050698009*^9}, {3.795976391963375*^9, 3.795976395653542*^9}, {
   3.795976873313151*^9, 3.795976878533328*^9}, 3.795977021027217*^9, 
   3.795977968770607*^9, {3.7959781961778793`*^9, 3.795978197801511*^9}, {
   3.795978310880726*^9, 3.795978311468658*^9}, 3.795978382391324*^9, 
   3.795978445228447*^9, {3.795978824109964*^9, 3.795978858036015*^9}, {
   3.7959788914687634`*^9, 3.795978920647616*^9}, {3.7959789774917088`*^9, 
   3.795978981707431*^9}, {3.79598065898599*^9, 3.7959806727971363`*^9}, {
   3.795980769872815*^9, 3.79598082792426*^9}, {3.795984537384864*^9, 
   3.795984693379177*^9}, {3.795984750695738*^9, 3.795984805027725*^9}, {
   3.795984886089673*^9, 3.79598492562556*^9}, {3.795985005324977*^9, 
   3.79598506521591*^9}, {3.795985103627927*^9, 3.795985104165694*^9}, {
   3.795985253089327*^9, 3.795985253333955*^9}, {3.795987665089242*^9, 
   3.795987667840519*^9}, {3.79598771784698*^9, 3.7959877845517673`*^9}, {
   3.795987832462161*^9, 3.795987833001898*^9}, {3.795987895554861*^9, 
   3.7959879014633207`*^9}, {3.795987946779649*^9, 3.7959879533421173`*^9}, {
   3.795988007547707*^9, 3.795988018366753*^9}, {3.79598808486059*^9, 
   3.7959881100792027`*^9}, {3.795988370836257*^9, 3.795988378327428*^9}, {
   3.79604319976866*^9, 3.796043203544798*^9}, {3.796063034107813*^9, 
   3.796063040666891*^9}, {3.796067755179847*^9, 3.796067802263405*^9}, {
   3.7960678629482937`*^9, 3.796067942509198*^9}, 3.7960680076913652`*^9, {
   3.79614399872834*^9, 3.7961440061692057`*^9}, {3.796144114063304*^9, 
   3.796144125360137*^9}, {3.796144351838642*^9, 3.7961443631417933`*^9}, 
   3.796144557902656*^9, {3.7961446252074738`*^9, 3.796144628890374*^9}, {
   3.796144744097889*^9, 3.796144745207116*^9}, {3.7961448753804617`*^9, 
   3.796144948334313*^9}, {3.7961450559452457`*^9, 3.796145061741774*^9}, {
   3.796145123936844*^9, 3.7961451261866417`*^9}, {3.7961451885587063`*^9, 
   3.796145251863511*^9}, {3.796145320444511*^9, 3.796145331588994*^9}, {
   3.796145391789847*^9, 3.7961454153941803`*^9}, {3.796145823491817*^9, 
   3.796145850845285*^9}, {3.796148166824999*^9, 3.796148221329546*^9}, 
   3.7961482682110767`*^9, {3.796148327682073*^9, 3.796148333663377*^9}, {
   3.796148426774181*^9, 3.796148439219535*^9}, {3.796148473621236*^9, 
   3.796148518362858*^9}, {3.796148587808404*^9, 3.796148589019163*^9}, {
   3.796148772516304*^9, 3.79614887158712*^9}, {3.796148954380567*^9, 
   3.7961489608349*^9}, {3.7961490533623667`*^9, 3.796149092203207*^9}, {
   3.796149324480781*^9, 3.796149324937952*^9}, 3.79614936300769*^9, {
   3.796149472118259*^9, 3.7961494824228277`*^9}, {3.796149822542852*^9, 
   3.796149843601817*^9}, {3.796150103253405*^9, 3.796150103559535*^9}, {
   3.796150382278118*^9, 3.7961504275863132`*^9}, {3.7961505105954227`*^9, 
   3.796150512387224*^9}, {3.79615066872824*^9, 3.796150697260598*^9}, {
   3.7961508191177187`*^9, 3.796150852190157*^9}, {3.796153296356193*^9, 
   3.796153305131878*^9}, 3.796153488333665*^9, {3.79615355500797*^9, 
   3.796153561657349*^9}, {3.796153613266623*^9, 3.796153613615288*^9}, {
   3.796153730075674*^9, 3.7961537303493433`*^9}, {3.796154678561607*^9, 
   3.796154690732443*^9}, 3.7961547265171213`*^9, {3.796154834823373*^9, 
   3.796154857645343*^9}, {3.7961553193122873`*^9, 3.796155334012926*^9}, {
   3.7961554988427963`*^9, 3.79615549979047*^9}, {3.796155608743649*^9, 
   3.7961556093953943`*^9}, {3.7961661135176077`*^9, 3.796166222112976*^9}, {
   3.796166515764112*^9, 3.796166516433709*^9}, {3.796166578851849*^9, 
   3.7961665794552717`*^9}, {3.796166619051751*^9, 3.796166636235293*^9}, {
   3.796167058728642*^9, 3.79616708290261*^9}, 3.796231628961974*^9, {
   3.79623173450136*^9, 3.796231748894548*^9}, {3.796232015211972*^9, 
   3.796232016643446*^9}, {3.796232056675623*^9, 3.796232059822484*^9}, {
   3.796232116089229*^9, 3.79623214102667*^9}, {3.7962324248969393`*^9, 
   3.796232477975512*^9}, {3.796232612117436*^9, 3.796232639781281*^9}, 
   3.7962369978912897`*^9, {3.796238414582427*^9, 3.796238414865282*^9}, {
   3.796238775038488*^9, 3.796238775818585*^9}, {3.796243243246073*^9, 
   3.7962432496462593`*^9}, {3.7962434258022537`*^9, 3.796243426047179*^9}, {
   3.796243861414206*^9, 3.7962438796430283`*^9}, {3.796243946365484*^9, 
   3.796243946628785*^9}, {3.796244023245954*^9, 3.7962440259268847`*^9}, {
   3.796244084379698*^9, 3.796244096911824*^9}, 3.796244505817897*^9, {
   3.796244734108919*^9, 3.796244734747982*^9}, {3.79624487019346*^9, 
   3.7962450631252213`*^9}, {3.79624512914935*^9, 3.7962453912196074`*^9}, {
   3.7962454234871798`*^9, 3.7962455292475653`*^9}, 3.796245588786468*^9, {
   3.7962456228575487`*^9, 3.796245686458912*^9}, {3.79624571779784*^9, 
   3.7962457297902803`*^9}, {3.796245790400628*^9, 3.79624582815373*^9}, 
   3.796245859361577*^9, {3.796245895663015*^9, 3.7962459432639303`*^9}, {
   3.7962461012150393`*^9, 3.796246128723042*^9}, 3.796246631594844*^9, 
   3.796253050325*^9, {3.7962530846306877`*^9, 3.7962530908424187`*^9}, {
   3.796295687503014*^9, 3.7962956884526367`*^9}, {3.7962957224563093`*^9, 
   3.796295722802951*^9}, {3.796295881455064*^9, 3.796295907619411*^9}, {
   3.7963060313992577`*^9, 3.7963060377093773`*^9}, {3.796306075438685*^9, 
   3.796306091145516*^9}, 3.796312418576045*^9, {3.796312479724236*^9, 
   3.796312517341816*^9}, {3.796312617702938*^9, 3.7963126221981077`*^9}, 
   3.796312689601602*^9, 3.796313007779277*^9, {3.796320176106082*^9, 
   3.7963201778803787`*^9}, {3.796320277642991*^9, 3.796320316294492*^9}, {
   3.796320549479745*^9, 3.7963205502556887`*^9}, {3.7963205815100613`*^9, 
   3.796320586718637*^9}, {3.796321407624894*^9, 3.796321437292712*^9}, {
   3.796321530363267*^9, 3.796321555882612*^9}, 3.7963216374723997`*^9, {
   3.796321711604445*^9, 3.796321713992167*^9}, {3.796321914280046*^9, 
   3.796322020161519*^9}, {3.7963221924036818`*^9, 3.796322211308152*^9}, {
   3.796322336681686*^9, 3.796322338345292*^9}, {3.796322391145218*^9, 
   3.796322392749201*^9}, {3.796322579576172*^9, 3.79632260108709*^9}, {
   3.796322735206897*^9, 3.7963227368883657`*^9}, {3.796322778177374*^9, 
   3.796322780013464*^9}, {3.796322834845953*^9, 3.796322837340107*^9}, {
   3.796322871017562*^9, 3.796322873170538*^9}, 3.796322915626602*^9, 
   3.796323069184888*^9, {3.796323143519342*^9, 3.796323144206091*^9}, 
   3.796323265376017*^9, {3.7963234179379473`*^9, 3.796323429927505*^9}, {
   3.796323620800558*^9, 3.796323647117614*^9}, {3.796323712777069*^9, 
   3.796323718076236*^9}, {3.796323920358451*^9, 3.796323937382332*^9}, 
   3.796323983791066*^9, {3.796324817671887*^9, 3.796324878522645*^9}, 
   3.7963252371975317`*^9, {3.796325268402731*^9, 3.796325315880575*^9}, {
   3.796325373433333*^9, 3.796325373633217*^9}, {3.796325474975294*^9, 
   3.796325507479507*^9}, {3.796325640104815*^9, 3.796325641751205*^9}, {
   3.796325679596095*^9, 3.796325791839862*^9}, {3.7963258545741043`*^9, 
   3.7963258695643587`*^9}, {3.796325908681182*^9, 3.7963259175172987`*^9}, {
   3.796325954800275*^9, 3.796325956141366*^9}, {3.796326012670237*^9, 
   3.796326017037485*^9}, {3.796326052000165*^9, 3.7963260566486807`*^9}, {
   3.796326136209002*^9, 3.7963261638541517`*^9}, {3.7963262416256*^9, 
   3.796326243029296*^9}, {3.796326273740347*^9, 3.796326322798009*^9}, {
   3.796326353027561*^9, 3.796326405505189*^9}, {3.796326604958446*^9, 
   3.79632661970893*^9}, {3.796326699933466*^9, 3.796326723767906*^9}, {
   3.796326844436062*^9, 3.796326847041471*^9}, {3.79632692719629*^9, 
   3.796326929295024*^9}, {3.796327741733053*^9, 3.796327741886134*^9}, {
   3.796328079987413*^9, 3.79632808284973*^9}, {3.7963326614348593`*^9, 
   3.796332666433504*^9}, {3.796332709057082*^9, 3.7963327478045797`*^9}, {
   3.796333211204359*^9, 3.796333211554408*^9}, {3.7963405628734426`*^9, 
   3.796340564909905*^9}, {3.796341543151524*^9, 3.796341652082521*^9}, {
   3.796342645848969*^9, 3.796342674295545*^9}, {3.796343896961636*^9, 
   3.7963439905093327`*^9}, {3.796344165315167*^9, 3.7963441704669724`*^9}, {
   3.796344332610862*^9, 3.796344340714231*^9}, {3.796390038370837*^9, 
   3.796390039831195*^9}, 3.7963900779044857`*^9, {3.796395459850585*^9, 
   3.79639553646961*^9}, {3.7963955690362997`*^9, 3.796395596373686*^9}, {
   3.796395709488295*^9, 3.7963957654063177`*^9}, {3.796396979988605*^9, 
   3.796397010922391*^9}, {3.796397152208412*^9, 3.796397155262257*^9}, {
   3.7963977978902884`*^9, 3.796397799374259*^9}, {3.79639799098955*^9, 
   3.796398000406397*^9}, {3.796398124997229*^9, 3.796398133248746*^9}, {
   3.796398246532144*^9, 3.79639826656104*^9}, {3.796398487738199*^9, 
   3.796398488114697*^9}, {3.796398582952883*^9, 3.796398583301922*^9}, {
   3.7963987942930317`*^9, 3.7963988025136433`*^9}, {3.796398946747178*^9, 
   3.796398954069174*^9}, 3.796399023043483*^9, 3.796399069134364*^9, {
   3.796405380047564*^9, 3.79640542509791*^9}, {3.7964054556528482`*^9, 
   3.796405456852017*^9}, {3.796405497215869*^9, 3.79640551928345*^9}, {
   3.796405646157737*^9, 3.796405695830586*^9}, {3.7964059013194647`*^9, 
   3.79640590172852*^9}, {3.796406463975782*^9, 3.796406464289102*^9}, 
   3.796406634517487*^9, {3.796406830542366*^9, 3.79640687777203*^9}, {
   3.796406908392961*^9, 3.79640692224809*^9}, {3.7964074397208033`*^9, 
   3.796407447972662*^9}, {3.796407649275099*^9, 3.796407658907888*^9}, {
   3.7964796011541433`*^9, 3.796479663291363*^9}, {3.796479730768956*^9, 
   3.796479753092635*^9}, {3.7964798260751247`*^9, 3.796479834246826*^9}, {
   3.796479870101748*^9, 3.7964798734068108`*^9}, {3.796479930608502*^9, 
   3.796479933328643*^9}, {3.796480004398383*^9, 3.7964800209087667`*^9}, {
   3.796480105842852*^9, 3.7964801436081553`*^9}, 3.796481030819693*^9, {
   3.7964810623931093`*^9, 3.7964810626953297`*^9}, {3.796556708501318*^9, 
   3.796556733065422*^9}, {3.796556771397098*^9, 3.796556778233973*^9}, {
   3.796556889988076*^9, 3.796556919818345*^9}, {3.79659233677481*^9, 
   3.7965923802846727`*^9}, {3.7965925293877563`*^9, 3.7965925307733994`*^9}, 
   3.796654597696393*^9, {3.79666802052382*^9, 3.796668218771001*^9}, {
   3.796668251200507*^9, 3.796668361262661*^9}, 3.796738272247373*^9, {
   3.7967383974012003`*^9, 3.7967384092164307`*^9}, {3.796738456110004*^9, 
   3.796738761913396*^9}, {3.796738806009933*^9, 3.796738820797655*^9}, {
   3.796738851363085*^9, 3.796738889984967*^9}, {3.7967389361488533`*^9, 
   3.796738971243726*^9}, {3.7967392245044403`*^9, 3.796739727213695*^9}, {
   3.796739762765933*^9, 3.79674015503539*^9}, {3.796740189670969*^9, 
   3.796740246928989*^9}, {3.796740278116856*^9, 3.796740525984818*^9}, {
   3.796740565280779*^9, 3.796740601552693*^9}, 3.796740635734288*^9, {
   3.796740669195282*^9, 3.7967407057057447`*^9}, {3.796740788119376*^9, 
   3.796740808592654*^9}, {3.796740854214398*^9, 3.796740906591227*^9}, {
   3.796740992476697*^9, 3.796741046279108*^9}, {3.7967411317720623`*^9, 
   3.796741258897694*^9}, {3.7967414060500917`*^9, 3.7967414269790277`*^9}, {
   3.796741482775373*^9, 3.796741528976499*^9}, {3.796741576438642*^9, 
   3.796741576772429*^9}, {3.796741649131901*^9, 3.796741650515518*^9}, {
   3.796741774847653*^9, 3.796741777125358*^9}, {3.796741935435877*^9, 
   3.796742112021306*^9}, {3.796742195940216*^9, 3.7967422874274406`*^9}, {
   3.7967424357846727`*^9, 3.796742438589723*^9}, {3.796742533336337*^9, 
   3.796742533565712*^9}, {3.7968048978124933`*^9, 3.796804939424164*^9}, {
   3.7968049700235662`*^9, 3.796805019649291*^9}, {3.796805122434277*^9, 
   3.796805167809613*^9}, {3.796805223002586*^9, 3.796805309445763*^9}, {
   3.7968055326260843`*^9, 3.796805613728622*^9}, {3.796805665158646*^9, 
   3.796805684291008*^9}, {3.7968057205227957`*^9, 3.796805724941358*^9}, {
   3.796805955008699*^9, 3.796805958318574*^9}, {3.796808988166815*^9, 
   3.796808996408897*^9}, {3.796809067010097*^9, 3.796809072900189*^9}, {
   3.79680912568118*^9, 3.7968092004070883`*^9}, 3.7968092491142187`*^9, 
   3.796809288328081*^9, {3.796809537848546*^9, 3.796809599496406*^9}, 
   3.796809784968053*^9, {3.796809866898178*^9, 3.796809876225396*^9}, {
   3.796812391139627*^9, 3.796812392645032*^9}, {3.79681248172602*^9, 
   3.796812490704588*^9}, {3.796812599334545*^9, 3.796812601642305*^9}, {
   3.796812700067618*^9, 3.79681270144523*^9}, {3.796812819508095*^9, 
   3.796812934857085*^9}, {3.796813177833337*^9, 3.796813279932248*^9}, 
   3.796813375724963*^9, 3.796813435978589*^9, {3.796813519341599*^9, 
   3.796813534294628*^9}, {3.796813593760249*^9, 3.7968136297277946`*^9}, {
   3.796813734785721*^9, 3.7968137474405537`*^9}, {3.796813787515952*^9, 
   3.796813788095991*^9}, {3.7968138482616587`*^9, 3.796813894886375*^9}, {
   3.79681879064122*^9, 3.796818793515326*^9}, {3.796819001056975*^9, 
   3.796819001178825*^9}, {3.796819208828334*^9, 3.796819306318972*^9}, {
   3.79681936366368*^9, 3.7968193648365192`*^9}, {3.7968194145796833`*^9, 
   3.796819417355493*^9}, {3.796819470853385*^9, 3.7968194754589043`*^9}, {
   3.796819542779346*^9, 3.7968195703777943`*^9}, {3.7968196656757507`*^9, 
   3.796819747933282*^9}, {3.796819783997835*^9, 3.7968197847231503`*^9}, {
   3.7968198293751497`*^9, 3.7968198495490026`*^9}, {3.796819987286673*^9, 
   3.796820003538178*^9}, {3.796820127655285*^9, 3.796820128172372*^9}, {
   3.7968202052353077`*^9, 3.796820206500946*^9}, {3.796820318691392*^9, 
   3.7968203338351583`*^9}, {3.796820364274345*^9, 3.796820365584697*^9}, {
   3.796820633791767*^9, 3.796820674501563*^9}, {3.796820728254716*^9, 
   3.7968207295819073`*^9}, {3.79682077257821*^9, 3.7968207729998283`*^9}, 
   3.796820810911643*^9, 3.796820866931031*^9, {3.7968209122270737`*^9, 
   3.796820936140534*^9}, {3.796820990608367*^9, 3.796820991338565*^9}, {
   3.796821141883944*^9, 3.796821156395502*^9}, {3.7968212846096373`*^9, 
   3.7968212885288343`*^9}, {3.796821375096676*^9, 3.7968213919533157`*^9}, {
   3.796931537553316*^9, 3.796931543383704*^9}, {3.796931642517569*^9, 
   3.7969316450253983`*^9}, {3.796931681630418*^9, 3.796931681854556*^9}, {
   3.796931814146784*^9, 3.796931847651236*^9}, {3.796991806574266*^9, 
   3.796991809645267*^9}, {3.796991851848833*^9, 3.796991871064665*^9}, 
   3.797073666550186*^9, {3.797075896981628*^9, 3.797075927604439*^9}, 
   3.797076303676764*^9, {3.797076658123082*^9, 3.797076681144524*^9}, {
   3.797076866624199*^9, 3.7970768929518843`*^9}, {3.797077562550383*^9, 
   3.797077563094884*^9}, {3.7970776024943333`*^9, 3.797077717753242*^9}, {
   3.797077763921255*^9, 3.797077772479678*^9}, {3.797078039590054*^9, 
   3.797078201971435*^9}, 3.797078254890016*^9, {3.7970785674941177`*^9, 
   3.797078568625804*^9}, {3.797078814066539*^9, 3.797078826012979*^9}, {
   3.797078915194463*^9, 3.7970789213556013`*^9}, {3.797079319269014*^9, 
   3.797079361076722*^9}, {3.797079589419943*^9, 3.7970795971465263`*^9}, {
   3.797079984699819*^9, 3.7970800328775787`*^9}, {3.797080647829763*^9, 
   3.797080649061801*^9}, 3.797080682783218*^9, {3.797081383990143*^9, 
   3.7970814082085447`*^9}, {3.797081539687645*^9, 3.797081550050671*^9}, {
   3.797082598933827*^9, 3.79708260316754*^9}, {3.797082676616591*^9, 
   3.797082676791235*^9}, {3.797082735584399*^9, 3.7970827367532167`*^9}, {
   3.797082807024291*^9, 3.797082811753497*^9}, {3.7970828912871103`*^9, 
   3.797082891448464*^9}, 3.797082970191451*^9, {3.797083900018495*^9, 
   3.797083902290001*^9}, {3.797084100037778*^9, 3.797084132233449*^9}, {
   3.797084205766026*^9, 3.797084206228506*^9}, {3.7970844103886557`*^9, 
   3.797084412543486*^9}, {3.79708450863822*^9, 3.797084513075551*^9}, {
   3.797084562556757*^9, 3.7970845639503107`*^9}, 3.7971509800007763`*^9, {
   3.797152059780654*^9, 3.797152113368915*^9}, {3.7971521443851013`*^9, 
   3.797152238001814*^9}, {3.797152276706863*^9, 3.7971523726306257`*^9}, {
   3.7971525787645283`*^9, 3.797152592271656*^9}, {3.797152854615745*^9, 
   3.797153008670083*^9}, {3.797153081431325*^9, 3.79715308283892*^9}, {
   3.7971531146947727`*^9, 3.797153118017477*^9}, {3.7971531595005198`*^9, 
   3.797153166450404*^9}, {3.7971532226558437`*^9, 3.7971532606992598`*^9}, 
   3.797153296196397*^9, {3.79715336576832*^9, 3.797153410172029*^9}, {
   3.79715346311416*^9, 3.797153525523177*^9}, {3.79715356050222*^9, 
   3.7971537264725237`*^9}, {3.7971537601768227`*^9, 3.797153785552458*^9}, {
   3.7971538451158657`*^9, 3.797153867482833*^9}, {3.7971539297328176`*^9, 
   3.797153966006263*^9}, {3.797154115895673*^9, 3.797154134268285*^9}, {
   3.797154177214539*^9, 3.797154183116432*^9}, {3.7971542273611813`*^9, 
   3.797154231729492*^9}, {3.7971542737149153`*^9, 3.797154308335451*^9}, {
   3.79715447221484*^9, 3.7971544833880453`*^9}, {3.7971545360628843`*^9, 
   3.7971545694502974`*^9}, {3.797279823701016*^9, 3.797279943908739*^9}, {
   3.797280013180243*^9, 3.797280044517342*^9}, {3.797280092875927*^9, 
   3.79728038190973*^9}, {3.797281771016262*^9, 3.797281771537709*^9}, {
   3.797281805268008*^9, 3.797281996875202*^9}, {3.797282085588092*^9, 
   3.79728244810813*^9}, {3.7972825095130587`*^9, 3.7972825330720654`*^9}, {
   3.79728259325913*^9, 3.7972826095412703`*^9}, {3.797282641866208*^9, 
   3.797282705116404*^9}, {3.7972827566818943`*^9, 3.797282820801462*^9}, {
   3.797282871312702*^9, 3.797282950398149*^9}, {3.797323177917885*^9, 
   3.7973231793084717`*^9}, {3.797331526907288*^9, 3.7973315665022173`*^9}, {
   3.7973316356439257`*^9, 3.797331640809825*^9}, {3.7973321558640633`*^9, 
   3.797332172017865*^9}, 3.7973342536180353`*^9, {3.797334331280519*^9, 
   3.797334433832974*^9}, 3.7973344676113033`*^9, {3.797334562399995*^9, 
   3.797334564304772*^9}, {3.797334639360813*^9, 3.797334665816297*^9}, {
   3.7973411857020187`*^9, 3.797341213212006*^9}, {3.797341249783452*^9, 
   3.7973412848955107`*^9}, {3.7973413339435596`*^9, 
   3.7973413805093517`*^9}, {3.797341443585741*^9, 3.797341613960485*^9}, {
   3.7973418645708227`*^9, 3.797341865420638*^9}, {3.797344317676363*^9, 
   3.79734431859445*^9}, {3.797344941282493*^9, 3.797344945655978*^9}, {
   3.797345677556473*^9, 3.797345679983494*^9}, {3.797345911026229*^9, 
   3.797345921687931*^9}, {3.797346026147314*^9, 3.7973460486376266`*^9}, {
   3.797346113271574*^9, 3.7973461164422903`*^9}, {3.797346478325686*^9, 
   3.797346490691127*^9}, {3.797346546473172*^9, 3.797346563056287*^9}, {
   3.797346601314229*^9, 3.797346601631826*^9}, {3.797452062281499*^9, 
   3.797452088957478*^9}, {3.7974521368480577`*^9, 3.79745217020685*^9}, {
   3.7974522031831017`*^9, 3.797452298367546*^9}, {3.7974523411460543`*^9, 
   3.79745240817336*^9}, {3.797452442951818*^9, 3.797452468501882*^9}, {
   3.797452527429447*^9, 3.797452590561534*^9}, {3.797452731234803*^9, 
   3.797452775818915*^9}, {3.797452841857147*^9, 3.7974528652273397`*^9}, {
   3.79750889988455*^9, 3.797508902035038*^9}, 3.797510285577508*^9, {
   3.797510461881536*^9, 3.797510510249043*^9}, {3.79751056280264*^9, 
   3.797510568358157*^9}, {3.797510628693767*^9, 3.797510634774271*^9}, {
   3.797510676884959*^9, 3.797510706629484*^9}, {3.797510896859397*^9, 
   3.7975110093843927`*^9}, {3.797511057595298*^9, 3.797511187887596*^9}, {
   3.797511226992189*^9, 3.797511230612555*^9}, {3.7975112898157377`*^9, 
   3.797511290837018*^9}, {3.797513395319191*^9, 3.797513395796212*^9}, 
   3.797514595044245*^9, {3.797514839148265*^9, 3.7975148834683867`*^9}, {
   3.7975150496415033`*^9, 3.797515052598505*^9}, {3.797515261564253*^9, 
   3.797515276391506*^9}, 3.797515323732005*^9, {3.797515655503483*^9, 
   3.7975156808903418`*^9}, {3.797515799748616*^9, 3.797515800569579*^9}, {
   3.797515845906011*^9, 3.797515849462096*^9}, {3.797515892563311*^9, 
   3.797515892917997*^9}, {3.797515969428893*^9, 3.797516007057863*^9}, {
   3.797516104776205*^9, 3.797516128614258*^9}, {3.7975161586803827`*^9, 
   3.797516199469749*^9}, {3.797516236103451*^9, 3.797516251478285*^9}, {
   3.7975162899035482`*^9, 3.79751629003854*^9}, {3.797516450568507*^9, 
   3.797516451527853*^9}, {3.797516485762706*^9, 3.797516530667007*^9}, {
   3.7975168547993317`*^9, 3.797516888046973*^9}, {3.797517029800837*^9, 
   3.79751703890654*^9}, 3.797517137972332*^9, {3.7975172341350594`*^9, 
   3.79751723853578*^9}, {3.79751733189524*^9, 3.797517347924594*^9}, {
   3.7975175065480556`*^9, 3.797517512537572*^9}, {3.797517688549988*^9, 
   3.797517712211672*^9}, {3.797517756153391*^9, 3.797517756442523*^9}, 
   3.7975178357660513`*^9, {3.79751792410627*^9, 3.797517924757914*^9}, {
   3.7975180226803503`*^9, 3.7975180539530163`*^9}, {3.797529408919166*^9, 
   3.797529414480257*^9}, {3.7975294784399242`*^9, 3.797529478705274*^9}, {
   3.797529519491878*^9, 3.797529540344461*^9}, {3.797529634401084*^9, 
   3.797529639350875*^9}, {3.797529829138413*^9, 3.797529852517025*^9}, {
   3.797529936278328*^9, 3.797529940109424*^9}, {3.797537468216333*^9, 
   3.797537469379879*^9}, {3.797537555372847*^9, 3.797537612334179*^9}, {
   3.7975376452030573`*^9, 3.797537730208625*^9}, {3.797537769679658*^9, 
   3.797537829924582*^9}, {3.797537864300857*^9, 3.797537933033333*^9}, 
   3.7975379730271597`*^9, {3.797542077560934*^9, 3.7975421222004213`*^9}, {
   3.797542187373836*^9, 3.797542218607027*^9}, 3.797542320911854*^9, {
   3.797542365589259*^9, 3.797542454984345*^9}, {3.79754249660141*^9, 
   3.797542512519508*^9}, {3.7975425921046457`*^9, 3.797542593739625*^9}, {
   3.797542743298471*^9, 3.797542743472287*^9}, {3.797542880200425*^9, 
   3.7975428873915033`*^9}, {3.797543001637987*^9, 3.797543001937518*^9}, {
   3.797543233295743*^9, 3.797543255873967*^9}, {3.797543289752713*^9, 
   3.7975432901007137`*^9}, {3.797546966475492*^9, 3.797546974204281*^9}, {
   3.797547010909947*^9, 3.797547019209733*^9}, {3.797547201577248*^9, 
   3.797547207116785*^9}, {3.797547275623417*^9, 3.797547331434538*^9}, 
   3.7975476121154947`*^9, {3.797547659036018*^9, 3.79754769543145*^9}, {
   3.797547735526702*^9, 3.7975477367060423`*^9}, {3.797547795647458*^9, 
   3.797547880186749*^9}, {3.797547966509417*^9, 3.797547993574769*^9}, {
   3.7975481195478563`*^9, 3.797548137320519*^9}, {3.7975482810459642`*^9, 
   3.797548282373872*^9}, {3.7975484190851316`*^9, 3.79754841969634*^9}, {
   3.797548486994825*^9, 3.7975484872311583`*^9}, {3.7975486055636377`*^9, 
   3.797548608379395*^9}, {3.797548672896881*^9, 3.7975486857278023`*^9}, {
   3.797548845821978*^9, 3.7975488847692127`*^9}, {3.797549039078047*^9, 
   3.797549053200542*^9}, {3.79754911547482*^9, 3.797549119578959*^9}, {
   3.7975491661249723`*^9, 3.797549167027133*^9}, {3.797549301251759*^9, 
   3.7975493026491613`*^9}, {3.797549407866441*^9, 3.797549410077469*^9}, {
   3.797549466141035*^9, 3.797549466851076*^9}, {3.7975495447946033`*^9, 
   3.79754954542354*^9}, {3.797549593112043*^9, 3.797549595053529*^9}, {
   3.797549739794289*^9, 3.797549740809392*^9}, {3.79754986036379*^9, 
   3.797549871573689*^9}, {3.797549932488205*^9, 3.797549933315956*^9}, {
   3.797549965785204*^9, 3.79754999211331*^9}, {3.7975500789809303`*^9, 
   3.797550079380224*^9}, {3.797550209358759*^9, 3.797550209806868*^9}, {
   3.797582328117691*^9, 3.7975823641412354`*^9}, {3.797582683743925*^9, 
   3.797582720105393*^9}, {3.797582776236977*^9, 3.797582828491601*^9}, {
   3.797582872086775*^9, 3.797582903732768*^9}, {3.797582941052218*^9, 
   3.797582970725237*^9}, {3.797583269758548*^9, 3.7975832776375847`*^9}, {
   3.797583320740802*^9, 3.797583321437213*^9}, {3.797583501846838*^9, 
   3.797583511866633*^9}, {3.7975868553070383`*^9, 3.797586855549313*^9}, {
   3.797586921197991*^9, 3.7975869214402742`*^9}, {3.797586986775113*^9, 
   3.797586990254025*^9}, {3.797595147576544*^9, 3.7975951958896723`*^9}, {
   3.797595236593396*^9, 3.7975952386109333`*^9}, {3.7975952731963377`*^9, 
   3.797595275064049*^9}, {3.797595320340025*^9, 3.7975953375022297`*^9}, {
   3.797595443431616*^9, 3.7975954999061413`*^9}, {3.797595536794709*^9, 
   3.797595537492826*^9}, {3.797595619938777*^9, 3.797595624162072*^9}, {
   3.7975956643069563`*^9, 3.797595692795018*^9}, {3.7975957272881117`*^9, 
   3.7975957302374487`*^9}, {3.7975957742014523`*^9, 
   3.7975958403895683`*^9}, {3.7975959629136887`*^9, 3.797595963293755*^9}, {
   3.797596045994772*^9, 3.7975960815652103`*^9}, {3.797596641865744*^9, 
   3.797596692580517*^9}, {3.797596770371904*^9, 3.797596802696116*^9}, {
   3.797596910524218*^9, 3.797596918289496*^9}, {3.797597102357624*^9, 
   3.797597163583275*^9}, {3.797614968540452*^9, 3.797614972112502*^9}, {
   3.797615016345066*^9, 3.7976150917645617`*^9}, {3.7976177535743513`*^9, 
   3.797617807629401*^9}, {3.797618322642334*^9, 3.7976183694743443`*^9}, {
   3.7976184541407833`*^9, 3.797618455049944*^9}, {3.797621102285034*^9, 
   3.797621191398114*^9}, {3.7976212298492107`*^9, 3.797621240212597*^9}, {
   3.7976215470497913`*^9, 3.797621547267066*^9}, {3.79762160314944*^9, 
   3.7976216202905293`*^9}, {3.7976219403207607`*^9, 
   3.7976219745801077`*^9}, {3.79762206483994*^9, 3.7976220654190493`*^9}, {
   3.797622793643197*^9, 3.7976227939551363`*^9}, {3.797622925293058*^9, 
   3.797622965577745*^9}, {3.7976230147779493`*^9, 3.797623028676499*^9}, {
   3.79762310707235*^9, 3.797623126378867*^9}, 3.7976231768535423`*^9, {
   3.79762323256273*^9, 3.797623274203373*^9}, {3.79762331363022*^9, 
   3.7976233577458897`*^9}, {3.797623653198434*^9, 3.797623671168624*^9}, {
   3.797625069162697*^9, 3.7976250698921003`*^9}, {3.7976251078929243`*^9, 
   3.797625128599909*^9}, {3.797625166790689*^9, 3.797625225405677*^9}, {
   3.797625680689851*^9, 3.797625700322901*^9}, {3.797668001703609*^9, 
   3.7976680018562613`*^9}, {3.797669213262343*^9, 3.797669220685843*^9}, {
   3.797669258368204*^9, 3.797669262038989*^9}, {3.797669305350305*^9, 
   3.797669305504862*^9}, {3.797669418493626*^9, 3.7976695228080606`*^9}, {
   3.797669640680822*^9, 3.797669641586235*^9}, 3.797670037030305*^9, 
   3.797670157351447*^9, {3.7976702840367737`*^9, 3.797670287472938*^9}, {
   3.797670425106696*^9, 3.79767056995201*^9}, {3.797670626943626*^9, 
   3.797670627428151*^9}, 3.797670714607057*^9, {3.797672045578052*^9, 
   3.7976720474825974`*^9}, {3.797672115850759*^9, 3.79767212521134*^9}, {
   3.797672737048945*^9, 3.7976727786865396`*^9}, {3.797672876191622*^9, 
   3.797673012070644*^9}, {3.7976731606818857`*^9, 3.7976732032709227`*^9}, {
   3.797673344189068*^9, 3.797673350479871*^9}, {3.7976734930680513`*^9, 
   3.7976734969990273`*^9}, {3.797673533432909*^9, 3.797673560327662*^9}, {
   3.797674988078849*^9, 3.7976750644458847`*^9}, {3.797675112553336*^9, 
   3.79767512001392*^9}, 3.797720485419755*^9, {3.797754733469994*^9, 
   3.797754743412225*^9}, {3.797771957292604*^9, 3.7977719967746*^9}, {
   3.7977720938459578`*^9, 3.7977721040357933`*^9}, {3.797772252250134*^9, 
   3.79777233717181*^9}, {3.797772404947442*^9, 3.797772415682664*^9}, {
   3.797772454528737*^9, 3.797772516930492*^9}, {3.797772633965805*^9, 
   3.797772659826988*^9}, 3.797773502054852*^9, 3.79777358384023*^9, {
   3.797773675112596*^9, 3.797773721141274*^9}, 3.7977737750212812`*^9, {
   3.797773840340431*^9, 3.797773905975724*^9}, {3.797773991720664*^9, 
   3.7977741291256943`*^9}, {3.7977741655021544`*^9, 3.797774178835925*^9}, {
   3.7977745779716387`*^9, 3.7977746173909187`*^9}, {3.7977746526872807`*^9, 
   3.7977746668958817`*^9}, {3.7977747913034077`*^9, 3.797775184601572*^9}, {
   3.79777527024362*^9, 3.797775317413054*^9}, {3.797775703365657*^9, 
   3.7977757190420437`*^9}, {3.7977760727885237`*^9, 
   3.7977760794340363`*^9}, {3.797776164164837*^9, 3.797776213504047*^9}, {
   3.7977763132057953`*^9, 3.7977763212068787`*^9}, {3.797776451550867*^9, 
   3.7977764676701612`*^9}, {3.797776635351859*^9, 3.797776686114523*^9}, {
   3.7977767244681473`*^9, 3.7977768342244*^9}, {3.797776868353793*^9, 
   3.7977768957426357`*^9}, {3.797777039170573*^9, 3.7977770394939413`*^9}, {
   3.797777213822466*^9, 3.7977772143145933`*^9}, {3.79777730111455*^9, 
   3.797777301423325*^9}, {3.7977773351252117`*^9, 3.797777350314681*^9}, {
   3.797777408901609*^9, 3.797777424997604*^9}, {3.797777594425847*^9, 
   3.797777594854897*^9}, {3.7977776250401697`*^9, 3.7977776602535963`*^9}, {
   3.797777717751348*^9, 3.797777758555829*^9}, {3.7977779153435087`*^9, 
   3.79777791569664*^9}, {3.797778004241736*^9, 3.7977780063083076`*^9}, {
   3.797778420481648*^9, 3.797778524762332*^9}, 3.7977785703082237`*^9, {
   3.7977786320960617`*^9, 3.797778657724875*^9}, {3.79777876055643*^9, 
   3.79777876641574*^9}, {3.797778797172803*^9, 3.797778828940732*^9}, {
   3.797778880101378*^9, 3.797778884057332*^9}, {3.797778922105631*^9, 
   3.797778925089591*^9}, {3.79777897414542*^9, 3.797779007082944*^9}, {
   3.79780290939342*^9, 3.797802963478507*^9}, {3.797803058340691*^9, 
   3.797803063746386*^9}, {3.79788946328209*^9, 3.797889463406644*^9}, {
   3.797893092305187*^9, 3.797893093896185*^9}, {3.7978931269224167`*^9, 
   3.797893139817588*^9}, {3.797893717287829*^9, 3.797893717481608*^9}, {
   3.797893830246911*^9, 3.797893839098949*^9}, 3.797893877355134*^9, {
   3.7978939720407143`*^9, 3.797893972558447*^9}, {3.7978942250952873`*^9, 
   3.797894231443734*^9}, {3.797894423874289*^9, 3.797894461063467*^9}, {
   3.797894606232973*^9, 3.7978946548043756`*^9}, {3.797903723581977*^9, 
   3.797903723934469*^9}, {3.797903785269288*^9, 3.797903799497127*^9}, {
   3.7979044224350224`*^9, 3.7979044246240673`*^9}, {3.797904575848905*^9, 
   3.7979045767060757`*^9}, {3.797904627444029*^9, 3.797904628655478*^9}, {
   3.79790483932099*^9, 3.797904840849924*^9}, {3.797905210547372*^9, 
   3.797905219208447*^9}, {3.797905253041835*^9, 3.79790525683337*^9}, {
   3.797905402323905*^9, 3.79790541503836*^9}, {3.797905455726218*^9, 
   3.797905458242447*^9}, {3.7979055005602818`*^9, 3.797905501108717*^9}, 
   3.7979055468702993`*^9, {3.797905632655157*^9, 3.797905687442583*^9}, {
   3.797905731589205*^9, 3.797905733229107*^9}, {3.797931055531683*^9, 
   3.797931060594227*^9}, {3.797933426046768*^9, 3.797933630584573*^9}, {
   3.797936814970159*^9, 3.797936897628769*^9}, {3.7979369693470097`*^9, 
   3.797937039390317*^9}, {3.7979370713024063`*^9, 3.797937136371656*^9}, {
   3.797937198512368*^9, 3.797937227628222*^9}, {3.7979372791111097`*^9, 
   3.797937305258915*^9}, {3.797937454309372*^9, 3.797937454429723*^9}, {
   3.797937499799117*^9, 3.797937527078933*^9}, {3.797937568502976*^9, 
   3.79793775671656*^9}, {3.7979383662137337`*^9, 3.7979383687194157`*^9}, {
   3.797938842984025*^9, 3.797938946368947*^9}, {3.797961850461128*^9, 
   3.797961852626499*^9}, {3.797962089856297*^9, 3.797962116023144*^9}, {
   3.797976169278831*^9, 3.797976205637557*^9}, {3.7979763108862658`*^9, 
   3.797976330383246*^9}, {3.797976365758539*^9, 3.797976419398527*^9}, 
   3.7979765634307117`*^9, {3.79797743061452*^9, 3.797977446081666*^9}, {
   3.7979774840309973`*^9, 3.7979774844942083`*^9}, {3.797977644018528*^9, 
   3.797977660230929*^9}, {3.797979085541809*^9, 3.797979124940777*^9}, {
   3.797979659902828*^9, 3.797979696938891*^9}, {3.797979736390151*^9, 
   3.7979798126775923`*^9}, {3.79797986724601*^9, 3.797979909018981*^9}, {
   3.7979804544763107`*^9, 3.797980498688059*^9}, {3.797980559618421*^9, 
   3.797980560219599*^9}, {3.7980265127949057`*^9, 3.798026610413505*^9}, 
   3.798026646075066*^9, {3.798026691979535*^9, 3.798026793525146*^9}, {
   3.7980268259943*^9, 3.798026933154195*^9}, {3.798026967322966*^9, 
   3.798027075741189*^9}, {3.7980271657660437`*^9, 3.798027174972373*^9}, {
   3.798027249533502*^9, 3.7980273679160213`*^9}, {3.7980274185594063`*^9, 
   3.798027430409987*^9}, {3.798027499569951*^9, 3.798027508585834*^9}, 
   3.798047107807888*^9, {3.798047220285203*^9, 3.79804722180928*^9}, {
   3.798047369448131*^9, 3.798047378010941*^9}, {3.798047416789997*^9, 
   3.798047421475749*^9}, {3.798048148009152*^9, 3.798048183209127*^9}, {
   3.798048260810451*^9, 3.798048280654661*^9}, {3.7980483140676823`*^9, 
   3.798048380329315*^9}, {3.798048412377964*^9, 3.798048440272663*^9}, {
   3.798048567996892*^9, 3.798048621762022*^9}, {3.798049325504383*^9, 
   3.798049562382885*^9}, {3.79804962833781*^9, 3.798049629126786*^9}, {
   3.7980497859869013`*^9, 3.7980498067103567`*^9}, {3.798049837079083*^9, 
   3.798049987729477*^9}, {3.798050150160358*^9, 3.7980501860794363`*^9}, {
   3.7980502723824263`*^9, 3.798050334154683*^9}, {3.798050369515078*^9, 
   3.798050372062192*^9}, 3.798050442254431*^9, {3.7980505419760733`*^9, 
   3.798050542071302*^9}, {3.798050833151536*^9, 3.798050847174946*^9}, {
   3.7980521127219133`*^9, 3.798052153638287*^9}, {3.798052213577222*^9, 
   3.79805222140876*^9}, {3.7980538345857067`*^9, 3.798053866602314*^9}, {
   3.7980539030452147`*^9, 3.798053956684903*^9}, {3.798054197429389*^9, 
   3.798054203031179*^9}, {3.7980543910451612`*^9, 3.798054411818644*^9}, {
   3.7980546932058268`*^9, 3.798054735253564*^9}, {3.798054813257128*^9, 
   3.79805482577372*^9}, {3.7980548964426203`*^9, 3.798054925162902*^9}, {
   3.798054963402794*^9, 3.79805508270415*^9}, {3.798055117986574*^9, 
   3.798055147570751*^9}, 3.798055181898471*^9, {3.798055225904221*^9, 
   3.798055229324971*^9}, {3.79805527335795*^9, 3.798055304954114*^9}, {
   3.798055353786487*^9, 3.7980553752059727`*^9}, {3.798055669646792*^9, 
   3.798055703295925*^9}, {3.7980557637981462`*^9, 3.7980557903647537`*^9}, 
   3.798055883722403*^9, {3.798055915517198*^9, 3.798055946268072*^9}, {
   3.798055993148244*^9, 3.79805601538556*^9}, {3.7980560883862257`*^9, 
   3.7980560885381947`*^9}, {3.798056158539693*^9, 3.7980561805095453`*^9}, 
   3.798056366813712*^9, 3.798056561155726*^9, {3.798056837054555*^9, 
   3.798056859802792*^9}, {3.79805693122505*^9, 3.7980569639169693`*^9}, {
   3.798056995076429*^9, 3.798057064300713*^9}, {3.798059294330504*^9, 
   3.798059305988307*^9}, {3.798059376458334*^9, 3.7980594089648533`*^9}, {
   3.798059441412032*^9, 3.798059443247561*^9}, {3.798059512053323*^9, 
   3.798059541720304*^9}, {3.798059577073234*^9, 3.798059579779894*^9}, {
   3.7980597256825047`*^9, 3.798059760928886*^9}, {3.7980601310060062`*^9, 
   3.798060134709709*^9}, {3.798063037164015*^9, 3.798063081704625*^9}, {
   3.798063169491325*^9, 3.798063171585589*^9}, {3.7980632081318073`*^9, 
   3.798063235920124*^9}, 3.798063327617244*^9, {3.798133171253236*^9, 
   3.798133197871292*^9}, 3.798134684176628*^9, {3.798144919381536*^9, 
   3.798144922985465*^9}, {3.798144954640765*^9, 3.798144981272437*^9}, {
   3.798145747219286*^9, 3.7981457565055*^9}, {3.798146143751648*^9, 
   3.798146174934678*^9}, {3.7981465529465322`*^9, 3.798146555265069*^9}, {
   3.7981466086926947`*^9, 3.798146649548831*^9}, {3.79814674059582*^9, 
   3.798146742229216*^9}, {3.798146932408803*^9, 3.798146956310627*^9}, {
   3.798147107783904*^9, 3.798147152448831*^9}, {3.798147207297317*^9, 
   3.798147209684864*^9}, {3.798147298088352*^9, 3.7981473132821817`*^9}, {
   3.7981473635486107`*^9, 3.798147364523988*^9}, {3.798147412527814*^9, 
   3.798147416127523*^9}, {3.798148255964527*^9, 3.798148260894539*^9}, {
   3.798148612655978*^9, 3.79814862294201*^9}, {3.798148689249605*^9, 
   3.798148726197002*^9}, {3.79814883456031*^9, 3.798148838101038*^9}, 
   3.7981490686283207`*^9, {3.798149136101178*^9, 3.7981491560841017`*^9}, {
   3.798149280537281*^9, 3.798149390141789*^9}, {3.798149720716406*^9, 
   3.798149879737773*^9}, {3.7981499151206903`*^9, 3.79814992754027*^9}, {
   3.7981499678764563`*^9, 3.798150012138183*^9}, {3.79815005357483*^9, 
   3.798150134194592*^9}, {3.798150170690545*^9, 3.7981501826412563`*^9}, {
   3.798150928850588*^9, 3.798150954174738*^9}, {3.798318068792777*^9, 
   3.798318069655357*^9}, {3.798493121416004*^9, 3.798493230154151*^9}, {
   3.798493283129459*^9, 3.7984933344386578`*^9}, {3.798579245346118*^9, 
   3.79857925248011*^9}, {3.798579292832243*^9, 3.798579296889366*^9}, {
   3.798579767678369*^9, 3.7985797699231052`*^9}, {3.798754532229393*^9, 
   3.798754532652792*^9}, 3.798754569469584*^9, 3.7987547838592663`*^9, {
   3.7988277037235107`*^9, 3.7988277062666483`*^9}, {3.7988279562070913`*^9, 
   3.798827956853524*^9}, {3.798827992216522*^9, 3.798828036549613*^9}, {
   3.798828091196773*^9, 3.798828111837081*^9}, {3.7990128982453203`*^9, 
   3.799012906231395*^9}, 3.799012970223682*^9, {3.799013110824852*^9, 
   3.7990131337985563`*^9}, {3.799246870851081*^9, 3.799246900589385*^9}, {
   3.7992469430494003`*^9, 3.799247265882361*^9}, {3.799247329896159*^9, 
   3.7992473319266167`*^9}, {3.7992474026046*^9, 3.799247873290213*^9}, 
   3.7992479118629704`*^9, {3.799248016283002*^9, 3.799248022986961*^9}, {
   3.7992480783342876`*^9, 3.799248132965448*^9}, {3.799248177965187*^9, 
   3.799248194463954*^9}, {3.799443045945136*^9, 3.799443117186407*^9}, {
   3.7994431560008717`*^9, 3.799443197472163*^9}, {3.799521556290141*^9, 
   3.799521558397606*^9}, {3.799530334430044*^9, 3.7995303346599073`*^9}, {
   3.799530482885274*^9, 3.799530496996481*^9}, {3.7996151943437853`*^9, 
   3.799615202135757*^9}, {3.799876389966445*^9, 3.799876403518902*^9}, {
   3.7998769653175898`*^9, 3.799876995519449*^9}, {3.7998770398158283`*^9, 
   3.799877045296874*^9}, 3.79996255193017*^9, 3.7999625926268806`*^9, {
   3.79996280752701*^9, 3.7999628126345654`*^9}, {3.800221797239027*^9, 
   3.800221880484393*^9}, {3.800726003513762*^9, 3.800726004086603*^9}, {
   3.8007380931435432`*^9, 3.800738093333202*^9}, {3.80073822554125*^9, 
   3.8007382302648497`*^9}, {3.8007383305502167`*^9, 3.800738330874628*^9}, {
   3.800738362767846*^9, 3.800738363342554*^9}, {3.800913675475236*^9, 
   3.8009136760224743`*^9}, {3.800913722308563*^9, 3.800913754782234*^9}, {
   3.800913801672739*^9, 3.8009140402570267`*^9}, {3.8009140713998337`*^9, 
   3.8009141264581947`*^9}, {3.800914161606687*^9, 3.80091420124496*^9}, {
   3.800914243401783*^9, 3.800914243998431*^9}, {3.800914276552603*^9, 
   3.800914293278104*^9}, {3.800997382334255*^9, 3.800997382509181*^9}, {
   3.802033760696176*^9, 3.802033761172234*^9}, {3.80315815639778*^9, 
   3.8031581569678373`*^9}, {3.803499566467369*^9, 3.803499569830131*^9}, {
   3.803499853563367*^9, 3.803499896790113*^9}, {3.80350003929173*^9, 
   3.803500049060433*^9}, {3.8035002177889357`*^9, 3.803500277656765*^9}, {
   3.8035004998708363`*^9, 3.80350050025648*^9}, {3.80350056483624*^9, 
   3.803500582599421*^9}, {3.803500638532484*^9, 3.803500670194105*^9}, {
   3.8035007355526133`*^9, 3.803500756533784*^9}, {3.803500887226787*^9, 
   3.8035009593542767`*^9}, {3.8035009902874002`*^9, 3.803501004581661*^9}, {
   3.803501036246562*^9, 3.80350111753086*^9}, {3.803501415908083*^9, 
   3.8035014373850718`*^9}, {3.80350159703594*^9, 3.803501597228279*^9}, {
   3.803501650378558*^9, 3.80350165815641*^9}, {3.8035018139821157`*^9, 
   3.8035018400631647`*^9}, {3.803501905069599*^9, 3.803501905595152*^9}, {
   3.803502003259143*^9, 3.803502057705173*^9}, {3.803502088926394*^9, 
   3.803502089310277*^9}, {3.803502126399136*^9, 3.803502144269231*^9}, 
   3.803502182883119*^9, {3.803502380925191*^9, 3.803502439005426*^9}, {
   3.803502624572003*^9, 3.8035027156776447`*^9}, {3.803502765782868*^9, 
   3.803502807332707*^9}, {3.803502838229816*^9, 3.803502878619471*^9}, {
   3.803502945133003*^9, 3.803503181845083*^9}, {3.8035032264728394`*^9, 
   3.803503290388134*^9}, {3.803503329541986*^9, 3.8035033459027557`*^9}, {
   3.803503452079899*^9, 3.803503452266693*^9}, {3.8035655598064203`*^9, 
   3.803565560774314*^9}, {3.803565854567338*^9, 3.803565885146791*^9}, {
   3.803567059660019*^9, 3.8035670794362707`*^9}, {3.80356766482614*^9, 
   3.803567680382753*^9}, {3.803569966439579*^9, 3.80356996667831*^9}, {
   3.8035700925348377`*^9, 3.803570093678357*^9}, {3.803570428841351*^9, 
   3.803570446003973*^9}, {3.8035705475917997`*^9, 3.8035705520915527`*^9}, 
   3.803570787548671*^9, 3.803570865326933*^9, {3.803570898233856*^9, 
   3.803570900839662*^9}, {3.803571028714158*^9, 3.803571029082885*^9}, {
   3.803571102168489*^9, 3.803571102490293*^9}, {3.803571224163142*^9, 
   3.803571226674933*^9}, {3.803571434426013*^9, 3.8035714345654497`*^9}, {
   3.8035715025718517`*^9, 3.803571502780285*^9}, {3.8035715872299967`*^9, 
   3.803571591604233*^9}, {3.803665282696433*^9, 3.8036654032209578`*^9}, {
   3.803665453001713*^9, 3.803665457898237*^9}, {3.8036657575187407`*^9, 
   3.8036657579169807`*^9}, {3.803666226890926*^9, 3.803666246440474*^9}, {
   3.803666380906822*^9, 3.803666381406993*^9}, {3.803735689573186*^9, 
   3.8037357139262037`*^9}, {3.803735857352664*^9, 3.80373585794375*^9}, {
   3.803735917752153*^9, 3.803735945310055*^9}, {3.803736007444544*^9, 
   3.803736010357648*^9}, {3.803736069115118*^9, 3.803736128639399*^9}, {
   3.8037361914305687`*^9, 3.8037362094249277`*^9}, {3.803736700544545*^9, 
   3.803736703782632*^9}, {3.803736795156028*^9, 3.803736800181881*^9}, {
   3.8037368404668283`*^9, 3.8037368503802347`*^9}, {3.80373690098542*^9, 
   3.8037369177232647`*^9}, {3.8037369665381947`*^9, 3.803736971754983*^9}, {
   3.8037373154682503`*^9, 3.803737360320997*^9}, {3.803740939280727*^9, 
   3.803740947552836*^9}, {3.80375218547323*^9, 3.803752233042547*^9}, {
   3.803752768591515*^9, 3.803752768708354*^9}, {3.803752836111113*^9, 
   3.803752837011404*^9}, {3.803752969023859*^9, 3.803753012027639*^9}, {
   3.803753045864978*^9, 3.803753046741585*^9}, {3.8037531198910437`*^9, 
   3.8037531589132957`*^9}, {3.80375319534103*^9, 3.8037532618248262`*^9}, {
   3.803753292399753*^9, 3.803753432169763*^9}, {3.803753485802281*^9, 
   3.8037535510012627`*^9}, {3.803753591624552*^9, 3.803753672553968*^9}, {
   3.8037537483523493`*^9, 3.803753816159668*^9}, 3.80375389513713*^9, {
   3.803763199395832*^9, 3.803763241681716*^9}, {3.803764143929504*^9, 
   3.8037641469109364`*^9}, {3.8037641913135033`*^9, 3.8037642185630693`*^9}, 
   3.803764257017077*^9, {3.8037642950538187`*^9, 3.803764311849156*^9}, {
   3.803764376745281*^9, 3.803764401733563*^9}, {3.803764700143983*^9, 
   3.80376470045542*^9}, 3.803937213246241*^9, {3.803937246000005*^9, 
   3.803937246319709*^9}, {3.8043683131876087`*^9, 3.804368412176193*^9}, {
   3.804368500414256*^9, 3.8043687439904327`*^9}, {3.804452835402101*^9, 
   3.804452955909637*^9}, {3.804453027322748*^9, 3.8044530551373034`*^9}, {
   3.804453090549142*^9, 3.804453165972632*^9}, {3.804715228034828*^9, 
   3.8047152285651913`*^9}, {3.804715277357841*^9, 3.804715290001628*^9}, {
   3.804717579575778*^9, 3.8047176136354628`*^9}, {3.8047176667387877`*^9, 
   3.804717674419633*^9}, {3.804967277168483*^9, 3.8049672774451237`*^9}, {
   3.80496818842481*^9, 3.804968224414274*^9}, {3.8052022671030893`*^9, 
   3.80520227070496*^9}, {3.805202316655566*^9, 3.8052023193750677`*^9}, 
   3.8052028227545433`*^9, {3.8052326770367517`*^9, 3.805232677672411*^9}, {
   3.8052327174769907`*^9, 3.8052327642562733`*^9}, {3.805232805714431*^9, 
   3.80523283991269*^9}, {3.8056291408104467`*^9, 3.8056294280270243`*^9}, {
   3.805629678426585*^9, 3.8056296787959757`*^9}, {3.805629724440624*^9, 
   3.805629724623292*^9}, {3.805639053880831*^9, 3.805639055383379*^9}, {
   3.8056584413523083`*^9, 3.805658444899777*^9}, 3.8056584783308477`*^9, {
   3.805658510395722*^9, 3.80565851588988*^9}, {3.8056585468265657`*^9, 
   3.8056586209028378`*^9}, 3.805658661304409*^9, {3.8057267183156853`*^9, 
   3.805726728522727*^9}, {3.805726768378579*^9, 3.805726907747073*^9}, {
   3.805727546818913*^9, 3.805727573922442*^9}, {3.8064420240865593`*^9, 
   3.806442024310762*^9}, {3.806442061621668*^9, 3.806442093429515*^9}, {
   3.8067001072348213`*^9, 3.806700139810835*^9}, {3.806701263274005*^9, 
   3.806701264891706*^9}, {3.807131681989326*^9, 3.8071316841616497`*^9}, {
   3.807738949737762*^9, 3.8077389506681633`*^9}},
 FontFamily->"Times New Roman",
 FontSize->18,
 FontWeight->"Regular",
 Background->RGBColor[1, 1, 0.85],
 CellLabel->"In[31]:=",ExpressionUUID->"95c9d8d2-4802-4646-9de1-e58b9df62b39"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.15, $CellContext`cota$$ = 
    1200000, $CellContext`g$$ = 0.06, $CellContext`ke$$ = 
    1.162*^-7, $CellContext`ki$$ = 
    1.5000000000000002`*^-8, $CellContext`kv$$ = 0.000031, $CellContext`p$$ = 
    0.094, $CellContext`PM$$ = 1500000, $CellContext`r$$ = 
    0.79, $CellContext`tds2$$ = 51, $CellContext`tf2$$ = 
    90, $CellContext`tic$$ = 
    23, $CellContext`tmax$$ = $CellContext`tshow$$, $CellContext`tshow$$ = 
    579, $CellContext`\[Alpha]$$ = 0.07, $CellContext`\[Beta]$$ = 
    0., $CellContext`\[Gamma]$$ = 0.015, $CellContext`\[Delta]$$ = 
    0.038, $CellContext`\[CapitalDelta]kds2$$ = 
    0.23, $CellContext`\[CapitalDelta]kf2$$ = 
    0., $CellContext`\[CapitalDelta]ki$$ = 0.25, $CellContext`\[Epsilon]$$ = 
    0.07, $CellContext`\[Mu]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{
      Hold[
       Style["PLOT BOUND", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`cota$$], 1200000, "cota"}, 5, 9390000}, {
      Hold[
       Style["MAXIMAL TIME", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tmax$$], $CellContext`tshow$$, "tmax"}, 10, 16000}, {
     
      Hold[
       Style["SHOW TIME", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tshow$$], 579, "tshow"}, 10, 1600}, {
      Hold[
       Style["HOUSE CONFINEMENT START", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tic$$], 23, "tic"}, 10, 200}, {
      Hold[
       Style["ECONOMIC PRESSURE INATTENTION", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tds2$$], 51, "tds2"}, 30, 200}, {
      Hold[
       Style["END-DOWN HOME CONFINEMENT", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`tf2$$], 90, "tf2"}, 30, 200}, {
      Hold[
       Style["INFECTION RATE DECREASE AT ti", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[CapitalDelta]ki$$], 0.25, "\[CapitalDelta]ki"}, 0, 
      2}, {
      Hold[
       Style["INFECTION RATE INCREASE AT tds2", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[CapitalDelta]kds2$$], 0.23, "\[CapitalDelta]kds2"},
       0, 2}, {
      Hold[
       Style["INFECTION RATE INCREASE AT HC END at tf2", 12, Bold]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[CapitalDelta]kf2$$], 0., "\[CapitalDelta]kf2"}, 0, 
      50}, {
      Hold[
       Style[
       "\!\(\*StyleBox[\"SUSCEPTIBLE\",FontColor->GrayLevel[0]]\)", 12, 
        Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Mu]$$], 0, "\[Mu]"}, 0., 6.*^-7}, {{
       Hold[$CellContext`PM$$], 1500000, "PM"}, 100, 13000000}, {{
       Hold[$CellContext`kv$$], 0.000031, "kv"}, 1.*^-7, 0.51}, {{
       Hold[$CellContext`ke$$], 1.162*^-7, 
       "\!\(\*StyleBox[\"ke\",FontColor->GrayLevel[0]]\)"}, 0., 0.00001}, {{
       Hold[$CellContext`ki$$], 1.5000000000000002`*^-8, 
       "\!\(\*StyleBox[\"ki\",FontColor->GrayLevel[0]]\)"}, 0., 0.00001}, {
      Hold[
       Style[
       "\!\(\*StyleBox[\"EXPOSED\",FontColor->RGBColor[1, 0, 0]]\)", 12, 
        Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`\[Alpha]$$], 0.07, "\[Alpha]"}, 0.0001, 0.56}, {{
       Hold[$CellContext`\[Beta]$$], 0., "\[Beta]"}, 0., 0.2}, {{
       Hold[$CellContext`\[Epsilon]$$], 0.07, "\[Epsilon]"}, 0., 0.52}, {
      Hold[
       Style[
       "PARAMETERS \!\(\*StyleBox[\"I\",FontColor->GrayLevel[0.5]]\), R AND \
D", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold[
       Style["a+r+g=1", 12, Bold]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`a$$], 0.15, "a"}, 0.001, 0.61}, {{
       Hold[$CellContext`r$$], 0.79, "r"}, 0.001, 1.1}, {{
       Hold[$CellContext`g$$], 0.06, "g"}, 0.001, 0.61}, {{
       Hold[$CellContext`\[Gamma]$$], 0.015, "\[Gamma]"}, 7.6*^-9, 0.1}, {{
       Hold[$CellContext`\[Delta]$$], 0.038, "\[Delta]"}, 7.6*^-9, 0.16}, {{
       Hold[$CellContext`p$$], 0.094, 
       "\!\(\*StyleBox[\"p\",FontColor->GrayLevel[0]]\)"}, 0.001, 1.03}}, 
    Typeset`size$$ = {1199., {520.634033203125, 526.365966796875}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`cota$108051$$ = 0, $CellContext`tmax$108052$$ = 
    0, $CellContext`tshow$108053$$ = 0, $CellContext`tic$108054$$ = 
    0, $CellContext`tds2$108055$$ = 0, $CellContext`tf2$108056$$ = 
    0, $CellContext`\[CapitalDelta]ki$108057$$ = 
    0, $CellContext`\[CapitalDelta]kds2$108058$$ = 
    0, $CellContext`\[CapitalDelta]kf2$108059$$ = 
    0, $CellContext`\[Mu]$108060$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.15, $CellContext`cota$$ = 
        1200000, $CellContext`g$$ = 0.06, $CellContext`ke$$ = 
        1.162*^-7, $CellContext`ki$$ = 
        1.5000000000000002`*^-8, $CellContext`kv$$ = 
        0.000031, $CellContext`p$$ = 0.094, $CellContext`PM$$ = 
        1500000, $CellContext`r$$ = 0.79, $CellContext`tds2$$ = 
        51, $CellContext`tf2$$ = 90, $CellContext`tic$$ = 
        23, $CellContext`tmax$$ = $CellContext`tshow$$, $CellContext`tshow$$ = 
        579, $CellContext`\[Alpha]$$ = 0.07, $CellContext`\[Beta]$$ = 
        0., $CellContext`\[Gamma]$$ = 0.015, $CellContext`\[Delta]$$ = 
        0.038, $CellContext`\[CapitalDelta]kds2$$ = 
        0.23, $CellContext`\[CapitalDelta]kf2$$ = 
        0., $CellContext`\[CapitalDelta]ki$$ = 
        0.25, $CellContext`\[Epsilon]$$ = 0.07, $CellContext`\[Mu]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`cota$$, $CellContext`cota$108051$$, 0], 
        Hold[$CellContext`tmax$$, $CellContext`tmax$108052$$, 0], 
        Hold[$CellContext`tshow$$, $CellContext`tshow$108053$$, 0], 
        Hold[$CellContext`tic$$, $CellContext`tic$108054$$, 0], 
        Hold[$CellContext`tds2$$, $CellContext`tds2$108055$$, 0], 
        Hold[$CellContext`tf2$$, $CellContext`tf2$108056$$, 0], 
        Hold[$CellContext`\[CapitalDelta]ki$$, \
$CellContext`\[CapitalDelta]ki$108057$$, 0], 
        Hold[$CellContext`\[CapitalDelta]kds2$$, \
$CellContext`\[CapitalDelta]kds2$108058$$, 0], 
        Hold[$CellContext`\[CapitalDelta]kf2$$, \
$CellContext`\[CapitalDelta]kf2$108059$$, 0], 
        Hold[$CellContext`\[Mu]$$, $CellContext`\[Mu]$108060$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`s$ = 
         NDSolve[{
           Derivative[
             1][$CellContext`S][$CellContext`t] == $CellContext`\[Mu]$$ \
$CellContext`S[$CellContext`t] - ($CellContext`kv$$ + $CellContext`ke$$ (
                1 - $CellContext`\[CapitalDelta]ki$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Ex[$CellContext`t] + $CellContext`ki$$ (
                1 - $CellContext`\[CapitalDelta]ki$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Inf[$CellContext`t]) $CellContext`S[$CellContext`t], 
            Derivative[
             1][$CellContext`Ex][$CellContext`t] == ($CellContext`kv$$ + \
$CellContext`ke$$ (1 - $CellContext`\[CapitalDelta]ki$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                  HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Ex[$CellContext`t] + $CellContext`ki$$ (
                 1 - $CellContext`\[CapitalDelta]ki$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tic$$] + \
$CellContext`\[CapitalDelta]kf2$$ 
                  HeavisideTheta[$CellContext`t - $CellContext`tf2$$] - \
$CellContext`\[CapitalDelta]kds2$$ 
                 HeavisideTheta[$CellContext`t - $CellContext`tds2$$]) \
$CellContext`Inf[$CellContext`t]) $CellContext`S[$CellContext`t] - \
($CellContext`\[Alpha]$$ + $CellContext`\[Beta]$$) \
$CellContext`Ex[$CellContext`t], 
            Derivative[
             1][$CellContext`Inf][$CellContext`t] == $CellContext`\[Alpha]$$ \
$CellContext`Ex[$CellContext`t] - ($CellContext`\[Gamma]$$ $CellContext`r$$ + \
$CellContext`\[Delta]$$ $CellContext`g$$ + $CellContext`\[Epsilon]$$ \
$CellContext`a$$) $CellContext`Inf[$CellContext`t], 
            Derivative[
             1][$CellContext`A][$CellContext`t] == $CellContext`\[Epsilon]$$ \
$CellContext`a$$ $CellContext`Inf[$CellContext`t] - ($CellContext`\[Delta]$$ \
$CellContext`p$$ + $CellContext`\[Gamma]$$ (
                1 - $CellContext`p$$)) $CellContext`A[$CellContext`t], 
            Derivative[
             1][$CellContext`R][$CellContext`t] == $CellContext`\[Beta]$$ \
$CellContext`Ex[$CellContext`t] + $CellContext`\[Gamma]$$ $CellContext`r$$ \
$CellContext`Inf[$CellContext`t] + $CellContext`\[Gamma]$$ (
               1 - $CellContext`p$$) $CellContext`A[$CellContext`t], 
            Derivative[
             1][$CellContext`d][$CellContext`t] == $CellContext`\[Delta]$$ \
($CellContext`g$$ $CellContext`Inf[$CellContext`t] + $CellContext`p$$ \
$CellContext`A[$CellContext`t]), $CellContext`S[
             0] == $CellContext`PM$$, $CellContext`Ex[0] == 
            0, $CellContext`Inf[0] == 3, $CellContext`A[0] == 
            0., $CellContext`R[0] == 0., $CellContext`d[0] == 
            0.}, {$CellContext`S, $CellContext`Ex, $CellContext`Inf, \
$CellContext`A, $CellContext`R, $CellContext`d}, {$CellContext`t, 
            0, $CellContext`tmax$$}, Method -> "StiffnessSwitching", 
           AccuracyGoal -> 7, PrecisionGoal -> 6]}, 
        Grid[{{$CellContext`QQ2 = Show[
             Plot[
              Evaluate[
               
               ReplaceAll[{$CellContext`Inf[$CellContext`t]; \
$CellContext`Ex[$CellContext`t]; $CellContext`R[$CellContext`t], 
                 $CellContext`d[$CellContext`t], \
$CellContext`A[$CellContext`t]; $CellContext`R[$CellContext`t] + \
$CellContext`d[$CellContext`t] + $CellContext`A[$CellContext`t], \
($CellContext`\[Gamma]$$ $CellContext`r$$ + $CellContext`\[Delta]$$ \
$CellContext`g$$ + $CellContext`\[Epsilon]$$ $CellContext`a$$) NIntegrate[
                    Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t}]; 
                 Null}, $CellContext`s$]], {$CellContext`t, 
               1, $CellContext`tmax$$}, 
              PlotLegends -> {
               "Inf[t]"; "Ex[t]"; "R[t]", "d[t]", "A[t]", "R[t]+d[t]+A[t]"}, 
              PlotRange -> {{5, $CellContext`tshow$$}, {
                0, $CellContext`cota$$}}, AspectRatio -> 1.3, ImageSize -> 
              450, PlotStyle -> {{Red, 
                  Thickness[0.004725], 
                  AbsoluteDashing[{2, 6, 6}]}; {
                  Green[1.5], 
                  AbsoluteDashing[{8, 15}], 
                  Thickness[0.0047251]}; {Magenta, 
                  AbsoluteDashing[{8, 10}], 
                  Thickness[0.00751]}, {Magenta, 
                 AbsoluteDashing[{8, 10}], 
                 Thickness[0.00751]}, {Cyan, 
                  Thickness[0.00751]}; {Magenta, 
                  AbsoluteDashing[{8, 10}], 
                  Thickness[0.00751]}, {Green, 
                 AbsoluteDashing[{3, 3}], 
                 Thickness[0.00751]}}, Frame -> True, GridLines -> None, 
              GridLinesStyle -> Directive[Gray, Dotted, Thin], 
              PlotRange -> {{0, 0.7 $CellContext`tmax$$}, {0, 10000}}, 
              Filling -> None, FillingStyle -> Directive[
                Opacity[0.1], Blue], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20]], 
             
             DateListPlot[{$CellContext`DatosFallecidos, \
$CellContext`DatosRecuperados, $CellContext`DatosAcumulados}, PlotRange -> 
              All, Filling -> Axis, 
              PlotTheme -> {"Bussiness", "OpenMarkersThick"}]], 
           Plot[
            Evaluate[
             ReplaceAll[{
               $CellContext`Inf[$CellContext`t], 
               $CellContext`Ex[$CellContext`t], 
               $CellContext`S[$CellContext`t]}, $CellContext`s$]], \
{$CellContext`t, 1, $CellContext`tmax$$}, PlotLegends -> {"S"; "Inf", "Ex"}, 
            PlotRange -> All, AspectRatio -> 1.3, ImageSize -> 450, 
            PlotStyle -> {{Black}; {
                Darker[Red], 
                AbsoluteDashing[{1, 6, 6}], 
                Thickness[0.00475]}, {
               Green[1.5], 
               AbsoluteDashing[{4, 6, 4}], 
               Thickness[0.004745]}, {Magenta, 
               AbsoluteDashing[{4, 10}], 
               Thickness[0.0075]}, {Black, DotDashed, 
               Thickness[0.0045]}}, Frame -> True, GridLines -> {{130}, None},
             GridLinesStyle -> Directive[Gray, Dashed, Thin], FrameLabel -> {
              Text[
               Style["day since first case", 30]], 
              Text[
               Style["infection probability", 30]]}, FrameStyle -> Directive[
              Thickness[0.005], Black], FrameTicksStyle -> 
            Directive[Black, 20], Filling -> Axis, FillingStyle -> Directive[
              Opacity[0.], Yellow]]}, {$CellContext`Q2 = Show[
             
             ListPlot[{$CellContext`CasosACTIVOS, \
$CellContext`CasosPORdiaHOPKINS, $CellContext`CASOSporDIAresta}, 
              PlotMarkers -> {Automatic, 12}, 
              PlotRange -> {{0, $CellContext`tshow$$}, {-1, 167800}}, 
              AspectRatio -> 1.3, ImageSize -> 450, Frame -> True, 
              GridLines -> {{{$CellContext`DIAMX, Red}, 180}, {}}, 
              GridLinesStyle -> Directive[Gray, Dashed, Thin], 
              FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20]], 
             Plot[
              Evaluate[
               ReplaceAll[{
                 $CellContext`A[$CellContext`t], ($CellContext`\[Gamma]$$ \
$CellContext`r$$ + $CellContext`\[Delta]$$ $CellContext`g$$ + $CellContext`\
\[Epsilon]$$ $CellContext`a$$) (NIntegrate[
                    Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t}] - NIntegrate[
                   Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t - 
                    1}])}, $CellContext`s$]], {$CellContext`t, 
               1, $CellContext`tmax$$}, 
              PlotLegends -> {"S"; "A[t]", "Casos por d\[IAcute]a"}, 
              PlotRange -> Automatic, AspectRatio -> 1.3, ImageSize -> 450, 
              PlotStyle -> {{Black}; {Magenta, 
                  AbsoluteDashing[{8, 10}], 
                  Thickness[0.00751]}, {Magenta, 
                 AbsoluteDashing[{8, 10}], 
                 Thickness[0.00751]}, {Magenta, 
                  AbsoluteDashing[{8, 10}], 
                  Thickness[0.00751]}; {Black, DotDashed, 
                  Thickness[0.0045]}}, Frame -> True, 
              GridLines -> {{98}, None}, GridLinesStyle -> 
              Directive[Gray, Dashed, Thin], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20], Filling -> Axis, FillingStyle -> Directive[
                Opacity[0.], Yellow]]], $CellContext`D2 = Show[
             
             ListPlot[{$CellContext`CASOSporDIAresta}, PlotMarkers -> 
              Graphics3D[{
                 GrayLevel[0], 
                 EdgeForm[None], 
                 Glow[
                  RGBColor[0, 
                   NCache[
                    Rational[2, 3], 0.6666666666666666], 0]], 
                 Cuboid[{0, 0, 0}]}, Boxed -> False, 
                ImageSize -> {13.693338432432654`, 12.}, 
                ViewPoint -> {0.17134623817277983`, 0.2733380173970694, 
                 3.3683715345711907`}, 
                ViewVertical -> {-0.5474806517236538, 0.6107600623868774, 
                 0.5720463986263885}], 
              PlotRange -> {{0, $CellContext`tshow$$}, {0, 9500}}, 
              AspectRatio -> 1.3, ImageSize -> 450, Frame -> True, 
              GridLines -> {{{$CellContext`DIAMX, Red}}, {}}, GridLinesStyle -> 
              Directive[Gray, Dashed, Thin], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["number of cases", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20]], 
             Plot[
              Evaluate[
               
               ReplaceAll[{($CellContext`\[Gamma]$$ $CellContext`r$$ + \
$CellContext`\[Delta]$$ $CellContext`g$$ + $CellContext`\[Epsilon]$$ \
$CellContext`a$$) (NIntegrate[
                    Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t}] - NIntegrate[
                   Evaluate[
                    ReplaceAll[
                    $CellContext`Inf[$CellContext`z], $CellContext`s$]], \
{$CellContext`z, 0, $CellContext`t - 1}]), 0.1 $CellContext`A[$CellContext`t]; 
                 Null}, $CellContext`s$]], {$CellContext`t, 
               1, $CellContext`tmax$$}, PlotLegends -> {"S"; "casos diarios"},
               PlotRange -> Automatic, AspectRatio -> 1.3, ImageSize -> 450, 
              PlotStyle -> {{Black}; {Magenta, 
                  AbsoluteDashing[{8, 10}], 
                  Thickness[0.00751]}, {Red, 
                 AbsoluteDashing[{2, 2, 2}], 
                 Thickness[0.00245]}, {Magenta, 
                 AbsoluteDashing[{4, 10}], 
                 Thickness[0.0075]}, {Black, DotDashed, 
                 Thickness[0.0045]}}, Frame -> True, 
              GridLines -> {{98}, None}, GridLinesStyle -> 
              Directive[Gray, Dashed, Thin], FrameLabel -> {
                Text[
                 Style["day since first case", 30]], 
                Text[
                 Style["infection probability", 30]]}, FrameStyle -> Directive[
                Thickness[0.005], Black], FrameTicksStyle -> 
              Directive[Black, 20], Filling -> Axis, FillingStyle -> Directive[
                Opacity[0.], Yellow]]]}}]], "Specifications" :> {
        Style[
        "PLOT BOUND", 12, Bold], {{$CellContext`cota$$, 1200000, "cota"}, 5, 
         9390000}, 
        Style[
        "MAXIMAL TIME", 12, 
         Bold], {{$CellContext`tmax$$, $CellContext`tshow$$, "tmax"}, 10, 
         16000}, 
        Style[
        "SHOW TIME", 12, Bold], {{$CellContext`tshow$$, 579, "tshow"}, 10, 
         1600}, 
        Style[
        "HOUSE CONFINEMENT START", 12, 
         Bold], {{$CellContext`tic$$, 23, "tic"}, 10, 200}, 
        Style[
        "ECONOMIC PRESSURE INATTENTION", 12, 
         Bold], {{$CellContext`tds2$$, 51, "tds2"}, 30, 200}, 
        Style[
        "END-DOWN HOME CONFINEMENT", 12, 
         Bold], {{$CellContext`tf2$$, 90, "tf2"}, 30, 200}, 
        Style[
        "INFECTION RATE DECREASE AT ti", 12, 
         Bold], {{$CellContext`\[CapitalDelta]ki$$, 0.25, 
          "\[CapitalDelta]ki"}, 0, 2}, 
        Style[
        "INFECTION RATE INCREASE AT tds2", 12, 
         Bold], {{$CellContext`\[CapitalDelta]kds2$$, 0.23, 
          "\[CapitalDelta]kds2"}, 0, 2}, 
        Style[
        "INFECTION RATE INCREASE AT HC END at tf2", 12, 
         Bold], {{$CellContext`\[CapitalDelta]kf2$$, 0., 
          "\[CapitalDelta]kf2"}, 0, 50}, 
        Style[
        "\!\(\*StyleBox[\"SUSCEPTIBLE\",FontColor->GrayLevel[0]]\)", 12, 
         Bold], {{$CellContext`\[Mu]$$, 0, "\[Mu]"}, 0., 
         6.*^-7}, {{$CellContext`PM$$, 1500000, "PM"}, 100, 
         13000000}, {{$CellContext`kv$$, 0.000031, "kv"}, 1.*^-7, 
         0.51}, {{$CellContext`ke$$, 1.162*^-7, 
          "\!\(\*StyleBox[\"ke\",FontColor->GrayLevel[0]]\)"}, 0., 
         0.00001}, {{$CellContext`ki$$, 1.5000000000000002`*^-8, 
          "\!\(\*StyleBox[\"ki\",FontColor->GrayLevel[0]]\)"}, 0., 0.00001}, 
        Delimiter, 
        Style[
        "\!\(\*StyleBox[\"EXPOSED\",FontColor->RGBColor[1, 0, 0]]\)", 12, 
         Bold], {{$CellContext`\[Alpha]$$, 0.07, "\[Alpha]"}, 0.0001, 
         0.56}, {{$CellContext`\[Beta]$$, 0., "\[Beta]"}, 0., 
         0.2}, {{$CellContext`\[Epsilon]$$, 0.07, "\[Epsilon]"}, 0., 0.52}, 
        Delimiter, 
        Style[
        "PARAMETERS \!\(\*StyleBox[\"I\",FontColor->GrayLevel[0.5]]\), R AND \
D", 12, Bold], 
        Style[
        "a+r+g=1", 12, Bold], {{$CellContext`a$$, 0.15, "a"}, 0.001, 
         0.61}, {{$CellContext`r$$, 0.79, "r"}, 0.001, 
         1.1}, {{$CellContext`g$$, 0.06, "g"}, 0.001, 
         0.61}, {{$CellContext`\[Gamma]$$, 0.015, "\[Gamma]"}, 7.6*^-9, 
         0.1}, {{$CellContext`\[Delta]$$, 0.038, "\[Delta]"}, 7.6*^-9, 
         0.16}, {{$CellContext`p$$, 0.094, 
          "\!\(\*StyleBox[\"p\",FontColor->GrayLevel[0]]\)"}, 0.001, 1.03}, 
        Delimiter}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{1520., {551., 557.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.803753554588873*^9, 3.803753601572307*^9, {3.80375364683778*^9, 
   3.80375367587612*^9}, {3.803753827760977*^9, 3.803753832196764*^9}, {
   3.803753898686163*^9, 3.803753901469036*^9}, 3.8037631330325336`*^9, 
   3.803763256340444*^9, 3.803763314632709*^9, 3.803764157343302*^9, 
   3.803764223844387*^9, 3.803764260591535*^9, {3.803764299944263*^9, 
   3.803764315340042*^9}, {3.80376438791199*^9, 3.803764404917745*^9}, 
   3.803764724957212*^9, 3.803769066197515*^9, 3.803769105654401*^9, 
   3.803769203877748*^9, 3.803769357753764*^9, 3.803847907481069*^9, 
   3.80384806141503*^9, 3.803848112696707*^9, 3.803848208799074*^9, 
   3.80393730654482*^9, 3.803937381961643*^9, 3.804026600702433*^9, 
   3.8041085641238527`*^9, 3.804108621296564*^9, 3.80410988875107*^9, 
   3.804193697135521*^9, 3.804193789903295*^9, {3.8043681071736517`*^9, 
   3.804368132001822*^9}, 3.8044525877018948`*^9, 3.804452804211644*^9, {
   3.804452839719989*^9, 3.804452856316914*^9}, 3.804452919403389*^9, {
   3.8044529703038282`*^9, 3.804452985696892*^9}, {3.804453057139617*^9, 
   3.804453075132066*^9}, {3.804453117228636*^9, 3.804453136766395*^9}, 
   3.8044532118433943`*^9, 3.80454444158361*^9, 3.8047151665922937`*^9, 
   3.804715240859671*^9, 3.804715294076601*^9, 3.804717502889174*^9, {
   3.804717586639598*^9, 3.804717614394679*^9}, 3.804717678380211*^9, 
   3.804800233493237*^9, 3.804853861697596*^9, 3.804860591810526*^9, 
   3.804884633465015*^9, 3.804963250513406*^9, 3.804966597224972*^9, 
   3.804967289340611*^9, 3.8049682285842524`*^9, 3.8049709921709948`*^9, 
   3.8050320685056677`*^9, 3.8050498660428953`*^9, 3.80514517758501*^9, 
   3.805145663210724*^9, 3.805145862536806*^9, 3.805146052350675*^9, 
   3.8052019384179792`*^9, 3.8052022775583477`*^9, 3.805202324686179*^9, 
   3.8052028320613403`*^9, 3.805232582062578*^9, 3.80523268459737*^9, 
   3.805232775417912*^9, 3.805232811285006*^9, 3.805232844754896*^9, 
   3.805317687362187*^9, 3.805318481908884*^9, 3.805318565237883*^9, 
   3.8053194578867397`*^9, 3.8053195638088703`*^9, 3.805402872768153*^9, 
   3.805403408625246*^9, 3.805491735597355*^9, 3.805578713019696*^9, 
   3.805629142144199*^9, {3.8056291895157137`*^9, 3.805629271949687*^9}, {
   3.805629313204113*^9, 3.805629399144434*^9}, 3.805629679353664*^9, 
   3.805639035853648*^9, 3.80563906655525*^9, 3.805641712209463*^9, 
   3.805658450146246*^9, 3.805658482397807*^9, 3.805658520001176*^9, 
   3.805658555951951*^9, 3.8056585957194777`*^9, 3.8056586279354343`*^9, 
   3.8056586649543*^9, 3.8056619818477592`*^9, {3.805725926207872*^9, 
   3.805725944205312*^9}, 3.805726035095789*^9, 3.805726732596531*^9, {
   3.805726774600205*^9, 3.805726797194748*^9}, {3.80572689271966*^9, 
   3.805726913026737*^9}, 3.805727590625342*^9, 3.805735869538656*^9, 
   3.805750052606317*^9, 3.8057501028228607`*^9, 3.805750378637309*^9, 
   3.8058083517118053`*^9, 3.805811138727201*^9, 3.805838878940007*^9, 
   3.8059209563839397`*^9, {3.8060721523338203`*^9, 3.806072165968729*^9}, 
   3.8060722253006353`*^9, 3.806072610897406*^9, 3.806072707103797*^9, 
   3.806072822587532*^9, 3.806175571289301*^9, 3.806183942838812*^9, 
   3.80618401001682*^9, 3.806353329465951*^9, 3.806353696971107*^9, 
   3.806441731894939*^9, 3.806441858650786*^9, {3.806442008015483*^9, 
   3.806442027345356*^9}, 3.806442066579732*^9, 3.806442096643639*^9, 
   3.80644214258523*^9, 3.8066996410010967`*^9, 3.806699773594719*^9, 
   3.806700029172958*^9, {3.806700114584756*^9, 3.80670014045472*^9}, 
   3.8067013000464*^9, 3.806701405058613*^9, 3.80677244738556*^9, 
   3.80687205315699*^9, 3.806872167577565*^9, 3.8070067555464354`*^9, 
   3.807006912478187*^9, 3.8071313831520967`*^9, 3.807131684883341*^9, 
   3.8073894319520597`*^9, 3.8073896358968277`*^9, 3.807562312193346*^9, 
   3.80765154020118*^9, 3.807738747872946*^9, 3.807738808934926*^9, 
   3.807738962851637*^9, 3.8079030154929667`*^9, 3.808082944463285*^9, 
   3.808222339890101*^9, 3.808223960496073*^9, 3.808429346945513*^9, 
   3.80860223237784*^9, 3.808651505939649*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"8dc9be21-52be-4110-9b61-f6de1ff61b49"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.805629265049782*^9, 3.805629266456108*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"52ed98fc-4827-4161-a30a-657578dfd186"],

Cell["\<\
The horizontal dashed line corresponds to 38200 death individuals:  \
38200/35200\
\>", "Text",
 CellChangeTimes->{{3.803501127068008*^9, 3.803501141895277*^9}, {
  3.80366664598001*^9, 
  3.8036666809946613`*^9}},ExpressionUUID->"107a157d-6bc5-4933-b69c-\
16536331f2ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{"QQ1", ",", "QQ2"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
     RowBox[{"Show", "[", 
      RowBox[{"D1", ",", "D2"}], "]"}]}], "}"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.803501169602515*^9, 3.803501175590947*^9}, {
  3.8035713117407713`*^9, 3.8035713157375917`*^9}, {3.8037357548218412`*^9, 
  3.803735759217456*^9}, {3.8037360463050833`*^9, 3.8037360497646008`*^9}, {
  3.803736478508419*^9, 3.803736479076961*^9}, {3.803736528985547*^9, 
  3.803736532620862*^9}, {3.803736939016461*^9, 3.80373694896305*^9}, {
  3.803752324621257*^9, 3.803752328615596*^9}, {3.803753057142559*^9, 
  3.803753058431458*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"b47bfad9-acc6-4a48-bf90-c09a89d8802c"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{GraphicsBox[{{{{{{}, {}, 
             TagBox[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[1.6], 
                RGBColor[1, 0.5, 0], 
                AbsoluteDashing[{8, 5}], 
                Thickness[0.00751]], 
               LineBox[CompressedData["
1:eJwV0nk8FPgfx3GrSCy1rsF0OOa7cmwSravW54NiVXKvY8IWKecYjGEGM1RK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                "]]}, 
              Annotation[#, "Charting`Private`Tag$95149#1"]& ], 
             TagBox[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[1.6], 
                RGBColor[1, 0.5, 0], 
                AbsoluteDashing[{8, 5}], 
                Thickness[0.00751]], 
               LineBox[CompressedData["
1:eJwVknk4FHgDx62UNhFK42hLZcugcqwjKt8kichVCYvKVa4xxhgMZpAjVEZZ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                "]]}, 
              Annotation[#, "Charting`Private`Tag$95149#1"]& ], 
             TagBox[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[1.6], 
                RGBColor[1, 0.5, 0], 
                AbsoluteDashing[{8, 5}], 
                Thickness[0.00751]], 
               LineBox[CompressedData["
1:eJwV0Xk8FPgfBvCJVZbFRHJuCJlvdFiRFH0+olApohh+rnKscQ7GYIxB6SBJ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                "]]}, 
              Annotation[#, 
               "Charting`Private`Tag$95149#1"]& ]}}, {}, {}}, {{}, {{{}, {
              EdgeForm[], 
              Directive[
               RGBColor[0.368417, 0.506779, 0.709798], 
               Opacity[0.2]], 
              GraphicsGroupBox[{{
                 PolygonBox[CompressedData["
1:eJxt1ntszWccx/HHFssSI50swTTy0ywy2Ujd7/Mw91uPas1l4zdtkUhclyak
mkdiCyLSZIgE229ESAnrVIW5PNqtsSJzKUWLX93V9R+Jf1wqn3eFxkmaT17n
+3ye70kv57T9jHnpOR8YY/bUf71OPbpa8/YjnvVeJ1Y/0fNeDvNx1MhOTk3H
oVzQBVvZfYoDOah+zF7ZL8LxTHkC9nLYEUeyPf+I/bgAh7JLw5Z5ExzIZsVD
9rNvDo5zdL4t9rjmAfvlYA12su+BQzmuus9+OSrBAfON2MhuDI6zdf5lHftl
W4QjOcjETg5r77Gf8yuxlX02DuS4OTbsK7zL/iz1h2AvRzV32C+7BdhxPoFD
2XTGFp+8zX6ci40cdMDxDN1/7xb7ZZ+PI9lkYMe8Ew7l6OxN9nNfLg44n4wN
9x28wf4f1R+OvWxScISfX2e/7ItxiCdhK9umOJDjQ7Xsl8MMHIfqt8Jetk9j
9stxEXacn4ZD2X2ILf72Gvs5n3WV/fj+FfZN1/nt2Mn+C2xlu6yGPuerqulP
07wddjjvMn3ZfIQN87JL9H/Qvq+xk83ii/Rl928VfdlWXqD/vbIFdrJNnKeP
R1fSl13dOfpTtX8EdrLZcpa+7GrP0Gf+FfZTdP/h0/RlswRbnIQNHvA//cm6
/8Up+njTSfp44Qn6+FgF/UnKZ//RxwewlZ07Th/fKaf/nVz+D31cXUZfNjnY
MG+D/UQ5q5S+bAqP0Wde4ekzLz9KP1N55jB9fP0QfdwMGzz2b/oZyrkH6OOK
/fRxSgl9XFlMf4KyD3Z43176+Pe/6OOlRfTTlXl/0se7dtPHdTvp45bYj1d2
LaSPS3fQxynb6eNgG/2Ecv1W+vjIH/RxZUQff45dmvL0b8zxJ5uZj1NmbGSO
l29gPvZdG5y8jvkYZfZa5vizX5mPVhYXMMeJNcxHKY+vYo7tL8xHKuf/zBwn
ljMfoUxaxhyH+cyHM89jjsPFzIcp/U/MsVtIDlWmLmCOk7AbwuudzRzzf0b9
G7Wy4XPGYN53jRtM8ndocMPvrRvE8/xcTIP5Pjj77j0GmwHkwEb+huze6PlU
sj/5JdmPDMi+ZDLZh2xN9iaTyF7kx2RP0pA9GrnhdT0ZqOz2xq8A6dbCUA==

                  "]]}}]}, {}, {
              EdgeForm[], 
              Directive[
               RGBColor[0.880722, 0.611041, 0.142051], 
               Opacity[0.2]], 
              GraphicsGroupBox[{{
                 PolygonBox[CompressedData["
1:eJxt0WtozXEcBvCvyQwbw9y2N0dYa5103I3hx5i5zS4ucz/YWClGXozIryiL
Fu/NOvICNVqkIeqnNEvyai4l9c8lM8Ow2Mhc/s8z+X9zan379Jzn/5yzM3rL
rqKyOBFp+P335+I11si/L2/7f92WkzbXt4MrulPhGFx1l7Zw3VE6Cmfn0Aau
bB8Fh+COBlr4vF20t833yfG0g2s6R3IfbrtMW/jAbjoKl0yjDTy5ewT34WRH
Cyw7aa/MdySLdnBp13Duw3d20lY5CteFaQPffz+M+/DeOlq4t4f2Sn03j6Qd
nPgkhftw23HawlJAR+Ejl4ZyXzkEX9tDC3w+RHtbfVcWD+G+cgzuGEBbuOnC
YO4rG7itJpn7yqLsbfEdzqcdXNU6iPtwXglt4YLwQO7DoVgS99l/mMh9ZYFb
bgzg/uagHRxLo2Nw5bH+3Ge+ux/3lQ1sHiVwH3YX+3Jf2Yv6np5CO9irjuc+
HBtKWzivtg/34Ug8beD2rt7cVxb2D9JuE57fHcfnwxmdvfg8ZYETymm3Ef+f
58I+XL6PNrDE0wJnNHLPbQjawuZsz76yKLv1QVu4PrWnD1ce7tmHT/am3Tr0
h//E57RwRVI3bOD6MT9ggb3Sb7BbG7RVNnDFk072ld0a3I9f2YdN4Rf24UhN
B/vKriRoC9uWz+zTOz6xr+xW4/O8+Mg+bDJpA0f2t7MPu/IP7K/C+9Pesa9s
YHfuLfuwV93K/kr/Rg+9YR8261vYhyXjNfuw9/4V+yvwfb4/Z1/ZKAscy6Jd
sX9DuR77ygZ2N5+xr+yK4AdP2Yfty8fsw3LiEfvKrjBoSxc8ZB82U2iBbc49
9guCtspGWfT7l6ucDjcxz8d90cicdreZLwta6ELHfClu0i3mynYJ7rjrzOni
q8wXBy306yvMF+Gmn2WubPNUrmwX4jafYU7X1zLPDVroxNPMFwQtC1R/vsqV
bQ5u3SnmynYen3eUubKdq3Jla1SuPYeXv5vMZo+/g8wKfg/JVp4Z/JwyQzlL
eXrwc8s05am8ybxTlCcrT1KeqDxBOcKbwDteOczbPgc3UzlDOf2vfwGnA7Ul

                  "]]}}]}, {}, {
              EdgeForm[], 
              Directive[
               RGBColor[0.560181, 0.691569, 0.194885], 
               Opacity[0.2]], 
              GraphicsGroupBox[{{
                 PolygonBox[CompressedData["
1:eJxt1H9M1HUcx/FPKHkK4VWIaGjneTnXWl0pRJb51awQjS4sRYS6RO2Hf8hW
c7RY+1SuLv4wdWTg5vqu0si1xayca2lfWaNr0aQfWpmjb2azlOxSKzTo1/f1
rM1bbO7l417f1725c3PSstXVK3KMMXv//vNP6iczi784WdaPf5/zf255ePLs
wJ5ctQS78pxSbOUjw3BSbv40Kjvy+K04Inc8ho0cXoD9lYFzrsKe7BVgVy70
J3Ffbt2Bk7J9EjtybS2OyCenYSNXFGN/ReDGMxHuyz3d2JWb27CV1zXgpFxV
hh25Mg9H5HTfpdyXK9qxvzxwrAx7cl3fRO7L8VXYyh2jcZL+lQncl2sSOCIP
5GEjN28r4X5D4NRM7MnrD1zCffnlNdjKrUU4yf7j8dyX51ockU8fG8d9uWcl
9pcFHn6imPtyrBW78trJ2Mq9+8dyX45b7MhvFuGInHSLuC+nSrB/r76PPWO4
LycWYle2OdjKa18v5L6cKseOHHv/Yu7L+Q3YyAM52E/q+2i9iPty23zsyutz
sZVrtl3Iffm1GdiR+9Nh7svuUmzkzlOjuXePPl8ttvLUdAHvJxdnLmAvN03A
3t2Beyvz2csV7Xns5dRPo9jLbhP26gOHz45kLzuN2JHLu0Ps5aYR2KvT91M/
gr0cbj+fvRwahQ19Qy77pYE79g1nL8cvw46cenwYe7npaA772sDeYmzljv7z
2MvhVdjI/pBhvyRwZy22smn5U+nIvTV/yEZOVg/JXk2QmU2DspXju39nL7uH
zrKXzUdn2C8O0r47wF72u35jL3fu+5U9z0ext0iu/4W9HH/1NHv6r0+xlxvz
sXeXcvpJ9nK47mf2sudl2PN8Ifbu1O/79An2eMyP7GXnxePs8TPH2C8MMlL2
A3s5GfqevWxyj7LHQ9+xr9bzPUfYy84L37KX7c7D7GX/nW/Y36HPNw5b2S7y
2eN0H3vZ9B9in1A/eJC97Dz4JXtc/QV72Tt+gOdvV27cTy97zmf0VcruT+hl
Zwq2tynreullu72HfoFy5If0OPYB/Xw9v6ubXjZt79FXql/XRS+b6F76eeqj
Hr1s5u2mr1B+9TY9bt9Ff6vy8530eOxb9LcoN71Bj0t30N+sfLSTHk/Edq7y
8HZ6fLCD/iZl11Z6XPAS/RzlHpcep7bQz1YmN9PjtufpHZ5/jh4PbsSzlOkN
+EZl6Fk8k/dpwTco738KX6+seALP4P0svk6ZeASXKzNr8LVK7yFcxudZjUvx
A3g6v89yPA3X42uU/L9lzNXkv47TJ/CV7Pl3M1ec+znM5efeMVOzXp9CRsgY
WUJGsxzJcnYWZ2VhlsNZr4eyXjf/vf4XVE28Fg==
                  
                  "]]}}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJxd1ntolXUcx/GfRRJUcgzByhGPQ6S8MS0tzcvPW5rX45xlafrothSCUgtB
meMnmKiEDLoQWPlYhDFFnE5F0/x5G7YMb7NVW/lMU3Ne2j9C/3TRPu/nj/Mb
jC+v8/l9nu85DzvnrOfCt0sr7zPGHL77e2/qp2OUKfyxhXwwcC5wt8CPBS4K
HAUuDtwrcO/ATwXuE7hf4AGBSwIPDDwo8DM4u0/PBh6cnWcOCfwcM7uPzzOz
+ziUmd23Yczsvr3AzO7bcGZ2H0Yws9c10hY+z1HBOVtoh90YHh/NfInHM09j
cs7PLOy5V8jHatr5PI6TBeTj6FeSY7uYfLxmbik5LsHmRR5fxsT+XfIJmvEK
cpyrIp9IXk2Oc6vJed35NeR4yXvkk3i+a8nxyQ3kk+lvJMf1NeRTNLt9QI4r
PiSfqln0ETle8wn5tEI7XLaJfLrmw5+R4zOfk+c1n0h4HbgJO/ztFk2PP/6S
/gzN6Cv6uHgrfXz0a/p4UC39Us1Ht9HH7djh7Tvo46qd9Pm7W1VHH2/eRR/v
2U0fD62nX8brxRYX76WPG/fRx2/tpz9Lc+o39PFDB+njS9jjs4fov6zZcJi+
7Bo9ffLaI/TJy4/S1/vMPX6MPu+7Ssz70LVgjxuO058tX2ugj91J+rLZ/x19
/Bc2r+r8kUb6eNn39PGnp+jjf36g/5rmiNP0ce4MfbwSe9kewmaOZt+z9GXX
hh35F+foy37iefpzdb4dW9lObqKP8xfoy6bLj/RfV96ErexONNOXzYqf6Mu+
38/056l/DFvZdP6FPnkV9vjJFvr6XHXNmM9Zu7qVvux7/Uqf81uxiZXfwBEu
/43ryW7sRTnG96dcn/PzcCKnddjL9g5OOd+9jf36HojLcCSnB7GV7QOX2C/7
2djhepx9r/yNPS6+zH45mYDNQs0DOJJ90e/sl91yHMvJOew43/8K+7leGfbk
1TjletexKf9/Rr2vsl82y7HFp3CMB1xjv2zzOJHdUuzlpBWnnB/3B/srlNfi
SE4fuc5+2VfgWLbrsZPjNpzI0ax29nO+Dqfs+xcbfe+7KTfYL6ebsJWTvTgm
b8ZO9oNvsl+ONmL+r7CtOMU9brH/DfXfxJFs1mEr20632S+76diR1+AEX8Be
jp/+k/3sm4nNIvkdHMlRC7ay69rBfrlmIHZySSlO5Lga+8CpnH+/w/4HFK7I
AQ==
               "]]}, {
              Hue[0.9060679774997897, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJxd0WtoT2EcB/AHmWFjGGbz4rittf7p7zIzhmdmM8bs4jL3g42Vskte/Imc
oojEe7OO9gI1WiSXyKM0S/LKraROLhmGYbGRuZzv97w4v1OnX59+53u+z+lM
2FpbXt1fKXX73/1/4upaoMKXDjNeOEk4WThFeLywJTxReLJwOh2cM0M4Uzgi
PJUOviMqPI0z+K7pwjOEZwpnCc8SzsZ08ujZwjn0QnqO8FzhXHoRPU94Pl1M
L+BczqkxWw/zOWGVJ/bCaqHYC6t8zJZT3AsrnjPhdPjcgVUB39fEfYHYF4p8
Yfh5tVjk6UdnuC/CTG/mXlgtEXthtRTz7WXu6Yor3BeHHfyHKde5X4aZeIt7
4eA/lRnuaXOH+5KwHfpVG/cr/OlE2rmn8+9zXxq2FnaEjbAqE3lYZz1mHlal
tKFPPGG+PGwt7MDO66fMw+bhc+Yr4JsvmBd2YKvQY15YrfSnm/OSedj5RTvC
Rlit8qf36Q3zsMp4yzysN3QwD9sH3jG/Gvnj75mHzdkPzMM67SPzwmoNnq/5
zDwc3dvFPKwzvzAP172iVSW+Z+dX5oUduuMb83C0sZv5tWFrYQfWZd+Zh9WX
H8yvw3me9TAv7MBe1U/mhdX6sDXcOuk383BdYh/zsB7zh/kN/jw5QOUhD8cO
0g7cmtoPNrBuptXGsLWwI2zgjLb+zG8KW8MqLuiHa/bQBo69pNVm3/E1QT+c
0RP0CxvY7Qv6bd9F+wfAFtzVS2thG47GDeT7mW+iXdgdFcc+2DtOe/Ds5EHs
3+LbXKAtYQ3rJ/Hsh936wewXduHY0SHs5z5tKPvhjhu02hq2BR95nMB+YRu2
3ET2w6WRYeyHiyqHs5/597QHR0qS2L/Nd2cjbQlrYRtuPz+C/cIu3D10JPvh
WAXtCasq3+esUeyHrzXQGj50kbaFHViVJrMf7jxGGzjhGe3Bj1JGs7/ad7SB
tuDdLbSGH3yibbglMob98N1dtCts4Kpe2mNfzlj2b8f5d9EWnGRoDc/so224
MjuF/fC+etqFOy/RBm7soT345NRx7N/h+0gtbcHdV2kNx7poG87NT2U/3HKY
dvm+e7SB6/poD+7MT8v7CyjBt3c=
               "]]}, {
              Hue[0.1421359549995791, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJx11n9MVXUcxvHTVfIqhLdCREO7Xm7OtVa3FCLLPJgVohFhKV6hTpL2wz9k
qzlarH0rV8Qfho4M3FxnlXZzbTEr51rqiTW6LZr0QytzdDKbpWQ3tUKDfp3n
3R/eLTf3+NpznvO58xdMW7GmdmXIsqy9//z8N/UjM5df2OdmOCsjWVmQlUX/
k8VZGc1yLMvxLE/P2s0gL8/KmeQV5GzySqW5GSeUdg2+mlxKXkP/n3mvacCz
8H24VOk8iMvwGnyt0nsYlysza/F1yppHz/3caYOvV1Y+iW9QPvA0nsPnacM3
KsPP4bm8bwO2lcMb2eHW5+krlJ0v0GNnM/08nt9Cj/e49Dcp81+mxz1b6ecr
D6bo8eHt9Pw5Te2mx49h6xZl6Q56vOlN+luVE9+mx1/spK9Udu2ix1+/Q79A
uWA3vWxiHn2VMvYevWzW99AvVHa+Ty+bXb30i5TxD+nx2I/ob9Pz2/voZau+
n746SHv6p/Sy1Yut24P07M/pZWvjfnr9vfeOH5D5d2DXfsnz+KGvZE82wwfZ
36EcPMReNukB9niJz172Jn3LvjZI/11sy2bnYfay/eJ37GWn7wj7xcqR79nj
nKPsZSf8A3s5WvYj+zv1/mePsccvHWcv+xN+Yo+fOcH+LmVBhr3sedjIkfpf
2PP8rJPslwTZlHeKvWy+wUZOvHaaPX3Dr+z1/5KJ/cZe7t6Hjez3/M6e5/cO
sa9TfnyGveweOsteTuz+g72c2TTMflmQTu0Ie7m/7k/2stX2F3u5O2lVaJ/U
5xvBthxZfZ5s5NQg9mRvaYj98sDNR7Ettz4xir2cuGw0ezm1D1v1uteYw14O
jzufPX0X9uT2hjHs9XWgeUyYvVzei/k6YTeNZS9HzmLr7sBu8zj2cuvP2MiV
Xbns5f6qPPb36P6UC9jLRRls5BnpfPaySY5n7wTuPoWjsrs8wvvkwTR25Ndn
X8j75bpt2JXbcy7inty5EPtyXwe27g08FLqY+3JeI7bl+AfYkVvLC7gvr3sD
u7IJTeC+XLMY+3LLHmyt0PuKC7kvOy625bcKJ3JfThhs5P792JXXlRRxX453
YF8efQJbjfr9WDWJ+/LpY9iW55vJ3JdbP8FG7ii8hPvyK2uxJ7cfwD77OcXc
1/ctLdtwVB7KncJ9ua4GO3LiVcz3PanxU7lPvxp7cv0A9uV42aXcXxm4sgtH
5fQAtuWq3Cj35eoybOT1jdiVWzqxJ/f1Yl9uOoOtVbpfNI378smZ2JaTSezI
5ils5I4d2JULfOzJXn6M+3LoKmzdHziyCEfl1OPYlidvxY7c8hk28pFRJdyX
55ViT65ehn257ZGSir8BL+a5Xg==
               "]]}}, {{
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                GraphicsBox[{
                  Directive[
                   PointSize[0.0055000000000000005`], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1.6], 
                   AbsolutePointSize[6]], {
                   GrayLevel[1], 
                   DiskBox[{0, 0}, 
                    Offset[{3, 3}]]}, 
                  AbsoluteThickness[2], 
                  Dashing[{}], 
                  CircleBox[{0, 0}, 
                   Offset[{3, 3}]]}], {0., 0.}], CompressedData["
1:eJxd1nto1WUcx/FHpRC6cBLBzBE/h0hekqlZmbfHS3nX05x5yfSn2yoQzBuC
MscjWFSEDLoQePtZiLIknE7D8vKoOWwpqc2WbtVvaqkzbf8E/VMpft6/P85z
4PDldT7P53zP+bFzznoveau0sosx5ti9e6d7984mu3WMMYU3W8iugXOBuwd+
PHBR4ChwceA+gfsGfipw/8ADAw8KXBJ4cOAhgYfi7Do9E3hYdp75bODnmNl1
fJ6ZXcfhzOy6vcDMrtsIZnbdRjKz6zCKmb2v0bbwdY4JztlCO+zG8fhY5mQe
zzyDyTk/q7Dn5pCP17SLeBwni8kn0K8kx/ZN8hc1cyvIcQk2L/H4Sib2q8kn
asZryXGuinwSeTU5zm0g533nN5Lj5W+TT+H1vkOOT79PPpX+JnJcX0M+TbP7
h+S44iPy6ZpFH5PjjZ+Szyi0w2WbyWdqPryVHJ/bRp7XfCLhfeAm7PDRHZoe
f/I5/Zc1o530cfEu+vjEbvp4SC39Us1uX9DH7djhPV/Sx1V76fN3t76OPt6+
jz4+sJ8+Hl5Pv4z3iy0uPkgfN35FHy87RH+25vRv6OOHDtPHV7DH54/Qf0Wz
4Rh92TV6+uS1x+mTl5+gr8+Z63mSPp+7Sszn0LVgjxu+pT9Xvt5AH7vT9GVz
6Dv6+B9s5un88Ub6eOX39PGWM/Txf2fpz9cc9QN9nDtHH6/DXrZHsHlVc8B5
+rJrw478swv0ZT/pR/oLdL4dW9lObaKP8xfpy+bRn+i/prwJW9mdaqYvm7U/
05f9wEv0F6p/ElvZPHiZPnkV9vjJFvr6XnXNmO9Zu6GVvuz7/EKf87uwiZXf
whEu/5Xnk9343+QYd0l5fs4vxImc1mEv279xyvkebezX70BchiM5PYytbB+4
wn7Zz8UO1+Psd+Vf7HHxVfbLyURslmh+jSPZF11jv+zW4FhOLmDH+ad/Zz/P
V4Y9eTVOeb6b2JTfn1HfP9gvmzXY4jM4xoOus1+2eZzIbgX2ctKKU85PuMH+
CuW1OJLTR26yX/YVOJbte9jJcRtO5Gh2O/s5X4dT9v2PjX733bRb7JfTzdjK
yUEckzdjJ/thf7JfjjZh/q+wrTjFvW6z/3X1l+JINu9iK9tOd9gvu5nYkdfg
BF/EXo77/cV+9s3C5g15FY7kqAVb2T3WwX65ZjB2ckkpTuS4GvvAqZz/oMPe
BTZSyAM=
               "]]}, {
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                GraphicsBox[{
                  Directive[
                   PointSize[0.0055000000000000005`], 
                   RGBColor[0.880722, 0.611041, 0.142051], 
                   AbsoluteThickness[1.6], 
                   AbsolutePointSize[6]], {
                   GrayLevel[1], 
                   PolygonBox[
                    NCache[{
                    Offset[{0, 4}], 
                    Offset[{(-2) 3^Rational[1, 2], -2}], 
                    Offset[{2 3^Rational[1, 2], -2}]}, {
                    Offset[{0, 4}], 
                    Offset[{-3.4641016151377544`, -2}], 
                    Offset[{3.4641016151377544`, -2}]}]]}, 
                  AbsoluteThickness[2], 
                  Dashing[{}], 
                  JoinedCurveBox[
                   NCache[
                    Line[{
                    Offset[{0, 4}], 
                    Offset[{(-2) 3^Rational[1, 2], -2}], 
                    Offset[{2 3^Rational[1, 2], -2}], 
                    Offset[{0, 4}]}], 
                    Line[{
                    Offset[{0, 4}], 
                    Offset[{-3.4641016151377544`, -2}], 
                    Offset[{3.4641016151377544`, -2}], 
                    Offset[{0, 4}]}]], CurveClosed -> True]}], {0., 
                0.}], CompressedData["
1:eJxd0WtoTnEcB/A/ywwbwzCbF8e1tZ70uIzN9T9jxlyemcvcDzZWare8eIic
orZI9t7oyAvUQ4vkEvkrsSSv3Erq5JJhGBZDxjrf73lxfqdOvz79zvd8/6cz
dnvtqqokpdTt3rtP791XBVfnfBW+dJgpwunCGcKZwmOELeFxwhOEJ9HBOXOE
c4UjwpPp4DuiwlM4g++aKjxNeLpwnvAM4ZmYTiGdL1xAL6BnCc8WnkMvpOcK
z6NL6fmcyzk1ZmsjnxNWhWIvrBaIvbAqwkyc4F5Y8ZypJ8PnDqwW8X2nuF8k
9sUiXxx+Xi0Wefrxae5LMCed4V5YLRF7YbUU891l7unyK9yXhh38h4nXuV+G
mXaLe+HgP5UZ7mlzh/sVYTv063vcr/SnE2njni56wH0sbC3sCBthVSbysM57
wjysYrShjz9lflXYWtiBnTfPmIfNoxfMl8M3XzIv7MBWsce8sFrtT7fgFfOw
84d2hI2wWuNP7/Nb5mGV8455WG9qZx62D75nfi3yxz4wD5uzH5mHdfYn5oXV
Ojxf/YV5OLqvk3lY535lHq57TasKfM/ub8wLO3T7d+bhaEsX8+vD1sIOrMt+
MA+rrz+Z34DzPO9mXtiBvcrfzAurjWFruHX8X+bhurQe5mE98h/zm/zZnKQK
kYfjh2gHbs3qAxtYn6HV5rC1sCNs4Jx7fZnfEraGVXLQD1fvpQ0cf0Wrrb5T
qoN+OKc76Bc2sNsT9Nu+Sw4kwRbc+YvWwjYcTe7H9zN/inZhd3gy+2DvGO3B
+Rn92b/Nt7lAW8Ia1k9T2A+79QPYL+zC8SMD2c999iD2w+03aLU9bAtuepLK
fmEbttw09sOxyGD2wyUVQ9jP/AfagyMr0tm/w3dHC20Ja2Ebbjs/lP3CLtw1
aBj74Xg57QmrSt/nrOHsh6810Bo+fJG2hR1YxTLYD3ccpQ2c+pz24MeZI9hf
5TvaQFvwngSt4YefaRtOREayH75bQ7vCBq78RXvsKxjF/p04fw1twemG1vD0
HtqGK2Zmsh/eX0+7cMcl2sAt3bQHN08ezf5dvptqaQvuukprON5J2/Ccoiz2
w4lG2uX77tMGruuhPbijKLvwP0plt3k=
               "]]}, {
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                GraphicsBox[{
                  Directive[
                   PointSize[0.0055000000000000005`], 
                   RGBColor[0.560181, 0.691569, 0.194885], 
                   AbsoluteThickness[1.6], 
                   AbsolutePointSize[6]], {
                   GrayLevel[1], 
                   PolygonBox[{
                    Offset[{0, 3.75}], 
                    Offset[{3.75, 0}], 
                    Offset[{0, -3.75}], 
                    Offset[{-3.75, 0}]}]}, 
                  AbsoluteThickness[2], 
                  Dashing[{}], 
                  LineBox[{
                    Offset[{0, 3.75}], 
                    Offset[{3.75, 0}], 
                    Offset[{0, -3.75}], 
                    Offset[{-3.75, 0}], 
                    Offset[{0, 3.75}]}]}], {0., 0.}], CompressedData["
1:eJx11n9M1HUcx/Gvh+QphFchoqGdx+Vca3WlEFnmF7NCNCIsxRPqm6T98A/Z
ao4Wa5/K1cUfho4M3Fy3SrtcW8zKuZb6jTW6Fk36oZU5+mY2S8kutUKDyn1f
T//wttzYi8de9/q+b6jAtBVr6lbmWJa199zHqHMfAev8n8xcPrEvzGBWhrKy
MCuL/ydLsjKc5UiWo1menrWbQV6VlTPJq8nZ5DVKcxuOKe1afB25lLye/rx5
rmnEs/CDuEzpPILL8Rp8g9J9DFcoM2vxjcraJy5832mDb1JWPYNvVj78HJ7D
+2nDtyiDL+K5PG8DtpXDG9nhxEv0lcrOl+mxs5l+Hq/fQo/3JOlvVRa8Ro97
ttLPVx5M0ePD2+n5e5raTY+fxNbtyrId9HjTO/R3KCe+R4+/3klfpezaRY+/
e59+gXLBbnrZRFz6amXkQ3rZrO+hX6js/IheNrt66Rcpo5/Q47Gf0t+p12/v
o5ethn76Gj/t6V/Qy1Yvtu7y07W/opetjfvp9e/ePX5A5v+BXfcNr8ePfiu7
shk+yP5u5eAh9rJJD7DHSzz2sjvpB/Z1fnofYFs2Ow+zl+1XfmQvO31H2C9W
jvzEHuceZS87wZ/Zy+HyX9jfo+e/cIw9fvU4e9mb8Ct7/PwJ9vcqCzPsZdfF
Rg41/M6e1886yX6Jn835p9jL5nts5Nibp9nTN/7BXt+XTORP9nL3Pmxkr+cv
9rx+7xD7euVnZ9jLyUNn2cux3X+zlzObhtkv89OpG2Ev99f/w1622v5lL3fH
rUrt43p/I9iWQ6tHyUZODWJXdpcG2C/33XIU23Li6Rz2cuzK0ezl1D5sNehe
Uy57OTjuIvb0XdiV2xvHsNfPgZYxQfZyRS/m54TdPJa9HDqLrft8J1vGsZcT
v2EjV3XlsZf7q/PZ36/7Uy5mLxdnsJFnpAvYyyY+nr3ju/sUDsvJ5SGeJw+m
sSO/NfsSni/Xb8NJuT33Uu7JnQuxJ/d1YOsB30OBy7gv5zdhW45+jB05UVHI
fXnd2zgpm8AE7su1i7Ent+7B1go9r6SI+7KTxLb8btFE7ssxg43cvx8n5XWl
xdyXox3Yk0efwFaTvh6rJnFfPn0M2/J8M5n7cuJzbOSOosu5L7++Frty+wHs
sZ9Twn393tK6DYflobwp3Jfra7Ejx97A/N6TGj+V+/SrsSs3DGBPjpZfwf2V
vqu6cFhOD2Bbrs4Lc1+uKcdGXt+Ek3JrJ3blvl7syc1nsLVK94uncV8+ORPb
cjyOHdk8i43csQMn5UIPu7JbEOG+HLgWWw/5Di3CYTn1FLblyVuxI7d+iY18
JKeU+/K8MuzKNcuwJ7c9Xlr5H1GKuWA=
               
               "]]}, {}}}, {}, {}, {}, {}}}, {{{{{}, {}, 
             TagBox[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[1.6], 
                RGBColor[1, 0, 1], 
                AbsoluteDashing[{8, 10}], 
                Thickness[0.00751]], 
               LineBox[CompressedData["
1:eJwVj3k81AkfgKVCLIqsq8OZmd9PJKyr8v1KcuRIsZE7V4hhGMOMMZO7O9cb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                "]]},
               Annotation[#, "Charting`Private`Tag$108306#1"]& ], 
             TagBox[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[1.6], 
                RGBColor[1, 0, 1], 
                AbsoluteDashing[{8, 10}], 
                Thickness[0.00751]], 
               LineBox[CompressedData["
1:eJwVk2k41Hsfh8dg/v+sHZKtU0SFrEcyIb4/qYTGln0Yyk4ajDEYzOBISYma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                "]]}, 
              Annotation[#, "Charting`Private`Tag$108306#1"]& ], 
             TagBox[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[1.6], 
                RGBColor[1, 0, 1], 
                AbsoluteDashing[{8, 10}], 
                Thickness[0.00751]], 
               LineBox[CompressedData["
1:eJwVknk4FHobhh0+KlLRYg0VZZ+fEOHwvqgkiUHZYlIk6zBjjIwxlg9FJ6dQ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                "]]},
               Annotation[#, 
               "Charting`Private`Tag$108306#1"]& ]}}, {}, {}}, {{}, {{{}, {
              EdgeForm[], 
              Directive[
               RGBColor[0.368417, 0.506779, 0.709798], 
               Opacity[0.2]], 
              GraphicsGroupBox[{{
                 PolygonBox[CompressedData["
1:eJxt1ntszWccx/HHFssSI50swTTy0ywy2Ujd7/Mw91uPas1l4zdtkUhclyak
mkdiCyLSZIgE229ESAnrVIW5PNqtsSJzKUWLX93V9R+Jf1wqn3eFxkmaT17n
+3ye70kv57T9jHnpOR8YY/bUf71OPbpa8/YjnvVeJ1Y/0fNeDvNx1MhOTk3H
oVzQBVvZfYoDOah+zF7ZL8LxTHkC9nLYEUeyPf+I/bgAh7JLw5Z5ExzIZsVD
9rNvDo5zdL4t9rjmAfvlYA12su+BQzmuus9+OSrBAfON2MhuDI6zdf5lHftl
W4QjOcjETg5r77Gf8yuxlX02DuS4OTbsK7zL/iz1h2AvRzV32C+7BdhxPoFD
2XTGFp+8zX6ci40cdMDxDN1/7xb7ZZ+PI9lkYMe8Ew7l6OxN9nNfLg44n4wN
9x28wf4f1R+OvWxScISfX2e/7ItxiCdhK9umOJDjQ7Xsl8MMHIfqt8Jetk9j
9stxEXacn4ZD2X2ILf72Gvs5n3WV/fj+FfZN1/nt2Mn+C2xlu6yGPuerqulP
07wddjjvMn3ZfIQN87JL9H/Qvq+xk83ii/Rl928VfdlWXqD/vbIFdrJNnKeP
R1fSl13dOfpTtX8EdrLZcpa+7GrP0Gf+FfZTdP/h0/RlswRbnIQNHvA//cm6
/8Up+njTSfp44Qn6+FgF/UnKZ//RxwewlZ07Th/fKaf/nVz+D31cXUZfNjnY
MG+D/UQ5q5S+bAqP0Wde4ekzLz9KP1N55jB9fP0QfdwMGzz2b/oZyrkH6OOK
/fRxSgl9XFlMf4KyD3Z43176+Pe/6OOlRfTTlXl/0se7dtPHdTvp45bYj1d2
LaSPS3fQxynb6eNgG/2Ecv1W+vjIH/RxZUQff45dmvL0b8zxJ5uZj1NmbGSO
l29gPvZdG5y8jvkYZfZa5vizX5mPVhYXMMeJNcxHKY+vYo7tL8xHKuf/zBwn
ljMfoUxaxhyH+cyHM89jjsPFzIcp/U/MsVtIDlWmLmCOk7AbwuudzRzzf0b9
G7Wy4XPGYN53jRtM8ndocMPvrRvE8/xcTIP5Pjj77j0GmwHkwEb+huze6PlU
sj/5JdmPDMi+ZDLZh2xN9iaTyF7kx2RP0pA9GrnhdT0ZqOz2xq8A6dbCUA==

                  "]]}}]}, {}, {
              EdgeForm[], 
              Directive[
               RGBColor[0.880722, 0.611041, 0.142051], 
               Opacity[0.2]], 
              GraphicsGroupBox[{{
                 PolygonBox[CompressedData["
1:eJxt0WtozXEcBvCvyQwbw9y2N0dYa5103I3hx5i5zS4ucz/YWClGXozIryiL
Fu/NOvICNVqkIeqnNEvyai4l9c8lM8Ow2Mhc/s8z+X9zan379Jzn/5yzM3rL
rqKyOBFp+P335+I11si/L2/7f92WkzbXt4MrulPhGFx1l7Zw3VE6Cmfn0Aau
bB8Fh+COBlr4vF20t833yfG0g2s6R3IfbrtMW/jAbjoKl0yjDTy5ewT34WRH
Cyw7aa/MdySLdnBp13Duw3d20lY5CteFaQPffz+M+/DeOlq4t4f2Sn03j6Qd
nPgkhftw23HawlJAR+Ejl4ZyXzkEX9tDC3w+RHtbfVcWD+G+cgzuGEBbuOnC
YO4rG7itJpn7yqLsbfEdzqcdXNU6iPtwXglt4YLwQO7DoVgS99l/mMh9ZYFb
bgzg/uagHRxLo2Nw5bH+3Ge+ux/3lQ1sHiVwH3YX+3Jf2Yv6np5CO9irjuc+
HBtKWzivtg/34Ug8beD2rt7cVxb2D9JuE57fHcfnwxmdvfg8ZYETymm3Ef+f
58I+XL6PNrDE0wJnNHLPbQjawuZsz76yKLv1QVu4PrWnD1ce7tmHT/am3Tr0
h//E57RwRVI3bOD6MT9ggb3Sb7BbG7RVNnDFk072ld0a3I9f2YdN4Rf24UhN
B/vKriRoC9uWz+zTOz6xr+xW4/O8+Mg+bDJpA0f2t7MPu/IP7K/C+9Pesa9s
YHfuLfuwV93K/kr/Rg+9YR8261vYhyXjNfuw9/4V+yvwfb4/Z1/ZKAscy6Jd
sX9DuR77ygZ2N5+xr+yK4AdP2Yfty8fsw3LiEfvKrjBoSxc8ZB82U2iBbc49
9guCtspGWfT7l6ucDjcxz8d90cicdreZLwta6ELHfClu0i3mynYJ7rjrzOni
q8wXBy306yvMF+Gmn2WubPNUrmwX4jafYU7X1zLPDVroxNPMFwQtC1R/vsqV
bQ5u3SnmynYen3eUubKdq3Jla1SuPYeXv5vMZo+/g8wKfg/JVp4Z/JwyQzlL
eXrwc8s05am8ybxTlCcrT1KeqDxBOcKbwDteOczbPgc3UzlDOf2vfwGnA7Ul

                  "]]}}]}, {}, {
              EdgeForm[], 
              Directive[
               RGBColor[0.560181, 0.691569, 0.194885], 
               Opacity[0.2]], 
              GraphicsGroupBox[{{
                 PolygonBox[CompressedData["
1:eJxt1H9M1HUcx/FPKHkK4VWIaGjneTnXWl0pRJb51awQjS4sRYS6RO2Hf8hW
c7RY+1SuLv4wdWTg5vqu0si1xayca2lfWaNr0aQfWpmjb2azlOxSKzTo1/f1
rM1bbO7l417f1725c3PSstXVK3KMMXv//vNP6iczi784WdaPf5/zf255ePLs
wJ5ctQS78pxSbOUjw3BSbv40Kjvy+K04Inc8ho0cXoD9lYFzrsKe7BVgVy70
J3Ffbt2Bk7J9EjtybS2OyCenYSNXFGN/ReDGMxHuyz3d2JWb27CV1zXgpFxV
hh25Mg9H5HTfpdyXK9qxvzxwrAx7cl3fRO7L8VXYyh2jcZL+lQncl2sSOCIP
5GEjN28r4X5D4NRM7MnrD1zCffnlNdjKrUU4yf7j8dyX51ockU8fG8d9uWcl
9pcFHn6imPtyrBW78trJ2Mq9+8dyX45b7MhvFuGInHSLuC+nSrB/r76PPWO4
LycWYle2OdjKa18v5L6cKseOHHv/Yu7L+Q3YyAM52E/q+2i9iPty23zsyutz
sZVrtl3Iffm1GdiR+9Nh7svuUmzkzlOjuXePPl8ttvLUdAHvJxdnLmAvN03A
3t2Beyvz2csV7Xns5dRPo9jLbhP26gOHz45kLzuN2JHLu0Ps5aYR2KvT91M/
gr0cbj+fvRwahQ19Qy77pYE79g1nL8cvw46cenwYe7npaA772sDeYmzljv7z
2MvhVdjI/pBhvyRwZy22smn5U+nIvTV/yEZOVg/JXk2QmU2DspXju39nL7uH
zrKXzUdn2C8O0r47wF72u35jL3fu+5U9z0ext0iu/4W9HH/1NHv6r0+xlxvz
sXeXcvpJ9nK47mf2sudl2PN8Ifbu1O/79An2eMyP7GXnxePs8TPH2C8MMlL2
A3s5GfqevWxyj7LHQ9+xr9bzPUfYy84L37KX7c7D7GX/nW/Y36HPNw5b2S7y
2eN0H3vZ9B9in1A/eJC97Dz4JXtc/QV72Tt+gOdvV27cTy97zmf0VcruT+hl
Zwq2tynreullu72HfoFy5If0OPYB/Xw9v6ubXjZt79FXql/XRS+b6F76eeqj
Hr1s5u2mr1B+9TY9bt9Ff6vy8530eOxb9LcoN71Bj0t30N+sfLSTHk/Edq7y
8HZ6fLCD/iZl11Z6XPAS/RzlHpcep7bQz1YmN9PjtufpHZ5/jh4PbsSzlOkN
+EZl6Fk8k/dpwTco738KX6+seALP4P0svk6ZeASXKzNr8LVK7yFcxudZjUvx
A3g6v89yPA3X42uU/L9lzNXkv47TJ/CV7Pl3M1ec+znM5efeMVOzXp9CRsgY
WUJGsxzJcnYWZ2VhlsNZr4eyXjf/vf4XVE28Fg==
                  
                  "]]}}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJxd1ntolXUcx/GfRRJUcgzByhGPQ6S8MS0tzcvPW5rX45xlafrothSCUgtB
meMnmKiEDLoQWPlYhDFFnE5F0/x5G7YMb7NVW/lMU3Ne2j9C/3TRPu/nj/Mb
jC+v8/l9nu85DzvnrOfCt0sr7zPGHL77e2/qp2OUKfyxhXwwcC5wt8CPBS4K
HAUuDtwrcO/ATwXuE7hf4AGBSwIPDDwo8DM4u0/PBh6cnWcOCfwcM7uPzzOz
+ziUmd23Yczsvr3AzO7bcGZ2H0Yws9c10hY+z1HBOVtoh90YHh/NfInHM09j
cs7PLOy5V8jHatr5PI6TBeTj6FeSY7uYfLxmbik5LsHmRR5fxsT+XfIJmvEK
cpyrIp9IXk2Oc6vJed35NeR4yXvkk3i+a8nxyQ3kk+lvJMf1NeRTNLt9QI4r
PiSfqln0ETle8wn5tEI7XLaJfLrmw5+R4zOfk+c1n0h4HbgJO/ztFk2PP/6S
/gzN6Cv6uHgrfXz0a/p4UC39Us1Ht9HH7djh7Tvo46qd9Pm7W1VHH2/eRR/v
2U0fD62nX8brxRYX76WPG/fRx2/tpz9Lc+o39PFDB+njS9jjs4fov6zZcJi+
7Bo9ffLaI/TJy4/S1/vMPX6MPu+7Ssz70LVgjxuO058tX2ugj91J+rLZ/x19
/Bc2r+r8kUb6eNn39PGnp+jjf36g/5rmiNP0ce4MfbwSe9kewmaOZt+z9GXX
hh35F+foy37iefpzdb4dW9lObqKP8xfoy6bLj/RfV96ErexONNOXzYqf6Mu+
38/056l/DFvZdP6FPnkV9vjJFvr6XHXNmM9Zu7qVvux7/Uqf81uxiZXfwBEu
/43ryW7sRTnG96dcn/PzcCKnddjL9g5OOd+9jf36HojLcCSnB7GV7QOX2C/7
2djhepx9r/yNPS6+zH45mYDNQs0DOJJ90e/sl91yHMvJOew43/8K+7leGfbk
1TjletexKf9/Rr2vsl82y7HFp3CMB1xjv2zzOJHdUuzlpBWnnB/3B/srlNfi
SE4fuc5+2VfgWLbrsZPjNpzI0ax29nO+Dqfs+xcbfe+7KTfYL6ebsJWTvTgm
b8ZO9oNvsl+ONmL+r7CtOMU9brH/DfXfxJFs1mEr20632S+76diR1+AEX8Be
jp/+k/3sm4nNIvkdHMlRC7ay69rBfrlmIHZySSlO5Lga+8CpnH+/w/4HFK7I
AQ==
               "]]}, {
              Hue[0.9060679774997897, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJxd0WtoT2EcB/AHmWFjGGbz4rittf7p7zIzhmdmM8bs4jL3g42Vskte/Imc
oojEe7OO9gI1WiSXyKM0S/LKraROLhmGYbGRuZzv97w4v1OnX59+53u+z+lM
2FpbXt1fKXX73/1/4upaoMKXDjNeOEk4WThFeLywJTxReLJwOh2cM0M4Uzgi
PJUOviMqPI0z+K7pwjOEZwpnCc8SzsZ08ujZwjn0QnqO8FzhXHoRPU94Pl1M
L+BczqkxWw/zOWGVJ/bCaqHYC6t8zJZT3AsrnjPhdPjcgVUB39fEfYHYF4p8
Yfh5tVjk6UdnuC/CTG/mXlgtEXthtRTz7WXu6Yor3BeHHfyHKde5X4aZeIt7
4eA/lRnuaXOH+5KwHfpVG/cr/OlE2rmn8+9zXxq2FnaEjbAqE3lYZz1mHlal
tKFPPGG+PGwt7MDO66fMw+bhc+Yr4JsvmBd2YKvQY15YrfSnm/OSedj5RTvC
Rlit8qf36Q3zsMp4yzysN3QwD9sH3jG/Gvnj75mHzdkPzMM67SPzwmoNnq/5
zDwc3dvFPKwzvzAP172iVSW+Z+dX5oUduuMb83C0sZv5tWFrYQfWZd+Zh9WX
H8yvw3me9TAv7MBe1U/mhdX6sDXcOuk383BdYh/zsB7zh/kN/jw5QOUhD8cO
0g7cmtoPNrBuptXGsLWwI2zgjLb+zG8KW8MqLuiHa/bQBo69pNVm3/E1QT+c
0RP0CxvY7Qv6bd9F+wfAFtzVS2thG47GDeT7mW+iXdgdFcc+2DtOe/Ds5EHs
3+LbXKAtYQ3rJ/Hsh936wewXduHY0SHs5z5tKPvhjhu02hq2BR95nMB+YRu2
3ET2w6WRYeyHiyqHs5/597QHR0qS2L/Nd2cjbQlrYRtuPz+C/cIu3D10JPvh
WAXtCasq3+esUeyHrzXQGj50kbaFHViVJrMf7jxGGzjhGe3Bj1JGs7/ad7SB
tuDdLbSGH3yibbglMob98N1dtCts4Kpe2mNfzlj2b8f5d9EWnGRoDc/so224
MjuF/fC+etqFOy/RBm7soT345NRx7N/h+0gtbcHdV2kNx7poG87NT2U/3HKY
dvm+e7SB6/poD+7MT8v7CyjBt3c=
               "]]}, {
              Hue[0.1421359549995791, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJx11n9MVXUcxvHTVfIqhLdCREO7Xm7OtVa3FCLLPJgVohFhKV6hTpL2wz9k
qzlarH0rV8Qfho4M3FxnlXZzbTEr51rqiTW6LZr0QytzdDKbpWQ3tUKDfp3n
3R/eLTf3+NpznvO58xdMW7GmdmXIsqy9//z8N/UjM5df2OdmOCsjWVmQlUX/
k8VZGc1yLMvxLE/P2s0gL8/KmeQV5GzySqW5GSeUdg2+mlxKXkP/n3mvacCz
8H24VOk8iMvwGnyt0nsYlysza/F1yppHz/3caYOvV1Y+iW9QPvA0nsPnacM3
KsPP4bm8bwO2lcMb2eHW5+krlJ0v0GNnM/08nt9Cj/e49Dcp81+mxz1b6ecr
D6bo8eHt9Pw5Te2mx49h6xZl6Q56vOlN+luVE9+mx1/spK9Udu2ix1+/Q79A
uWA3vWxiHn2VMvYevWzW99AvVHa+Ty+bXb30i5TxD+nx2I/ob9Pz2/voZau+
n746SHv6p/Sy1Yut24P07M/pZWvjfnr9vfeOH5D5d2DXfsnz+KGvZE82wwfZ
36EcPMReNukB9niJz172Jn3LvjZI/11sy2bnYfay/eJ37GWn7wj7xcqR79nj
nKPsZSf8A3s5WvYj+zv1/mePsccvHWcv+xN+Yo+fOcH+LmVBhr3sedjIkfpf
2PP8rJPslwTZlHeKvWy+wUZOvHaaPX3Dr+z1/5KJ/cZe7t6Hjez3/M6e5/cO
sa9TfnyGveweOsteTuz+g72c2TTMflmQTu0Ie7m/7k/2stX2F3u5O2lVaJ/U
5xvBthxZfZ5s5NQg9mRvaYj98sDNR7Ettz4xir2cuGw0ezm1D1v1uteYw14O
jzufPX0X9uT2hjHs9XWgeUyYvVzei/k6YTeNZS9HzmLr7sBu8zj2cuvP2MiV
Xbns5f6qPPb36P6UC9jLRRls5BnpfPaySY5n7wTuPoWjsrs8wvvkwTR25Ndn
X8j75bpt2JXbcy7inty5EPtyXwe27g08FLqY+3JeI7bl+AfYkVvLC7gvr3sD
u7IJTeC+XLMY+3LLHmyt0PuKC7kvOy625bcKJ3JfThhs5P792JXXlRRxX453
YF8efQJbjfr9WDWJ+/LpY9iW55vJ3JdbP8FG7ii8hPvyK2uxJ7cfwD77OcXc
1/ctLdtwVB7KncJ9ua4GO3LiVcz3PanxU7lPvxp7cv0A9uV42aXcXxm4sgtH
5fQAtuWq3Cj35eoybOT1jdiVWzqxJ/f1Yl9uOoOtVbpfNI378smZ2JaTSezI
5ils5I4d2JULfOzJXn6M+3LoKmzdHziyCEfl1OPYlidvxY7c8hk28pFRJdyX
55ViT65ehn257ZGSir8BL+a5Xg==
               "]]}}, {{
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                GraphicsBox[{
                  Directive[
                   PointSize[0.0055000000000000005`], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1.6], 
                   AbsolutePointSize[6]], {
                   GrayLevel[1], 
                   DiskBox[{0, 0}, 
                    Offset[{3, 3}]]}, 
                  AbsoluteThickness[2], 
                  Dashing[{}], 
                  CircleBox[{0, 0}, 
                   Offset[{3, 3}]]}], {0., 0.}], CompressedData["
1:eJxd1nto1WUcx/FHpRC6cBLBzBE/h0hekqlZmbfHS3nX05x5yfSn2yoQzBuC
MscjWFSEDLoQePtZiLIknE7D8vKoOWwpqc2WbtVvaqkzbf8E/VMpft6/P85z
4PDldT7P53zP+bFzznoveau0sosx5ti9e6d7984mu3WMMYU3W8iugXOBuwd+
PHBR4ChwceA+gfsGfipw/8ADAw8KXBJ4cOAhgYfi7Do9E3hYdp75bODnmNl1
fJ6ZXcfhzOy6vcDMrtsIZnbdRjKz6zCKmb2v0bbwdY4JztlCO+zG8fhY5mQe
zzyDyTk/q7Dn5pCP17SLeBwni8kn0K8kx/ZN8hc1cyvIcQk2L/H4Sib2q8kn
asZryXGuinwSeTU5zm0g533nN5Lj5W+TT+H1vkOOT79PPpX+JnJcX0M+TbP7
h+S44iPy6ZpFH5PjjZ+Szyi0w2WbyWdqPryVHJ/bRp7XfCLhfeAm7PDRHZoe
f/I5/Zc1o530cfEu+vjEbvp4SC39Us1uX9DH7djhPV/Sx1V76fN3t76OPt6+
jz4+sJ8+Hl5Pv4z3iy0uPkgfN35FHy87RH+25vRv6OOHDtPHV7DH54/Qf0Wz
4Rh92TV6+uS1x+mTl5+gr8+Z63mSPp+7Sszn0LVgjxu+pT9Xvt5AH7vT9GVz
6Dv6+B9s5un88Ub6eOX39PGWM/Txf2fpz9cc9QN9nDtHH6/DXrZHsHlVc8B5
+rJrw478swv0ZT/pR/oLdL4dW9lObaKP8xfpy+bRn+i/prwJW9mdaqYvm7U/
05f9wEv0F6p/ElvZPHiZPnkV9vjJFvr6XnXNmO9Zu6GVvuz7/EKf87uwiZXf
whEu/5Xnk9343+QYd0l5fs4vxImc1mEv279xyvkebezX70BchiM5PYytbB+4
wn7Zz8UO1+Psd+Vf7HHxVfbLyURslmh+jSPZF11jv+zW4FhOLmDH+ad/Zz/P
V4Y9eTVOeb6b2JTfn1HfP9gvmzXY4jM4xoOus1+2eZzIbgX2ctKKU85PuMH+
CuW1OJLTR26yX/YVOJbte9jJcRtO5Gh2O/s5X4dT9v2PjX733bRb7JfTzdjK
yUEckzdjJ/thf7JfjjZh/q+wrTjFvW6z/3X1l+JINu9iK9tOd9gvu5nYkdfg
BF/EXo77/cV+9s3C5g15FY7kqAVb2T3WwX65ZjB2ckkpTuS4GvvAqZz/oMPe
BTZSyAM=
               "]]}, {
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                GraphicsBox[{
                  Directive[
                   PointSize[0.0055000000000000005`], 
                   RGBColor[0.880722, 0.611041, 0.142051], 
                   AbsoluteThickness[1.6], 
                   AbsolutePointSize[6]], {
                   GrayLevel[1], 
                   PolygonBox[
                    NCache[{
                    Offset[{0, 4}], 
                    Offset[{(-2) 3^Rational[1, 2], -2}], 
                    Offset[{2 3^Rational[1, 2], -2}]}, {
                    Offset[{0, 4}], 
                    Offset[{-3.4641016151377544`, -2}], 
                    Offset[{3.4641016151377544`, -2}]}]]}, 
                  AbsoluteThickness[2], 
                  Dashing[{}], 
                  JoinedCurveBox[
                   NCache[
                    Line[{
                    Offset[{0, 4}], 
                    Offset[{(-2) 3^Rational[1, 2], -2}], 
                    Offset[{2 3^Rational[1, 2], -2}], 
                    Offset[{0, 4}]}], 
                    Line[{
                    Offset[{0, 4}], 
                    Offset[{-3.4641016151377544`, -2}], 
                    Offset[{3.4641016151377544`, -2}], 
                    Offset[{0, 4}]}]], CurveClosed -> True]}], {0., 
                0.}], CompressedData["
1:eJxd0WtoTnEcB/A/ywwbwzCbF8e1tZ70uIzN9T9jxlyemcvcDzZWare8eIic
orZI9t7oyAvUQ4vkEvkrsSSv3Erq5JJhGBZDxjrf73lxfqdOvz79zvd8/6cz
dnvtqqokpdTt3rtP791XBVfnfBW+dJgpwunCGcKZwmOELeFxwhOEJ9HBOXOE
c4UjwpPp4DuiwlM4g++aKjxNeLpwnvAM4ZmYTiGdL1xAL6BnCc8WnkMvpOcK
z6NL6fmcyzk1ZmsjnxNWhWIvrBaIvbAqwkyc4F5Y8ZypJ8PnDqwW8X2nuF8k
9sUiXxx+Xi0Wefrxae5LMCed4V5YLRF7YbUU891l7unyK9yXhh38h4nXuV+G
mXaLe+HgP5UZ7mlzh/sVYTv063vcr/SnE2njni56wH0sbC3sCBthVSbysM57
wjysYrShjz9lflXYWtiBnTfPmIfNoxfMl8M3XzIv7MBWsce8sFrtT7fgFfOw
84d2hI2wWuNP7/Nb5mGV8455WG9qZx62D75nfi3yxz4wD5uzH5mHdfYn5oXV
Ojxf/YV5OLqvk3lY535lHq57TasKfM/ub8wLO3T7d+bhaEsX8+vD1sIOrMt+
MA+rrz+Z34DzPO9mXtiBvcrfzAurjWFruHX8X+bhurQe5mE98h/zm/zZnKQK
kYfjh2gHbs3qAxtYn6HV5rC1sCNs4Jx7fZnfEraGVXLQD1fvpQ0cf0Wrrb5T
qoN+OKc76Bc2sNsT9Nu+Sw4kwRbc+YvWwjYcTe7H9zN/inZhd3gy+2DvGO3B
+Rn92b/Nt7lAW8Ia1k9T2A+79QPYL+zC8SMD2c999iD2w+03aLU9bAtuepLK
fmEbttw09sOxyGD2wyUVQ9jP/AfagyMr0tm/w3dHC20Ja2Ebbjs/lP3CLtw1
aBj74Xg57QmrSt/nrOHsh6810Bo+fJG2hR1YxTLYD3ccpQ2c+pz24MeZI9hf
5TvaQFvwngSt4YefaRtOREayH75bQ7vCBq78RXvsKxjF/p04fw1twemG1vD0
HtqGK2Zmsh/eX0+7cMcl2sAt3bQHN08ezf5dvptqaQvuukprON5J2/Ccoiz2
w4lG2uX77tMGruuhPbijKLvwP0plt3k=
               "]]}, {
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                GraphicsBox[{
                  Directive[
                   PointSize[0.0055000000000000005`], 
                   RGBColor[0.560181, 0.691569, 0.194885], 
                   AbsoluteThickness[1.6], 
                   AbsolutePointSize[6]], {
                   GrayLevel[1], 
                   PolygonBox[{
                    Offset[{0, 3.75}], 
                    Offset[{3.75, 0}], 
                    Offset[{0, -3.75}], 
                    Offset[{-3.75, 0}]}]}, 
                  AbsoluteThickness[2], 
                  Dashing[{}], 
                  LineBox[{
                    Offset[{0, 3.75}], 
                    Offset[{3.75, 0}], 
                    Offset[{0, -3.75}], 
                    Offset[{-3.75, 0}], 
                    Offset[{0, 3.75}]}]}], {0., 0.}], CompressedData["
1:eJx11n9M1HUcx/Gvh+QphFchoqGdx+Vca3WlEFnmF7NCNCIsxRPqm6T98A/Z
ao4Wa5/K1cUfho4M3Fy3SrtcW8zKuZb6jTW6Fk36oZU5+mY2S8kutUKDyn1f
T//wttzYi8de9/q+b6jAtBVr6lbmWJa199zHqHMfAev8n8xcPrEvzGBWhrKy
MCuL/ydLsjKc5UiWo1menrWbQV6VlTPJq8nZ5DVKcxuOKe1afB25lLye/rx5
rmnEs/CDuEzpPILL8Rp8g9J9DFcoM2vxjcraJy5832mDb1JWPYNvVj78HJ7D
+2nDtyiDL+K5PG8DtpXDG9nhxEv0lcrOl+mxs5l+Hq/fQo/3JOlvVRa8Ro97
ttLPVx5M0ePD2+n5e5raTY+fxNbtyrId9HjTO/R3KCe+R4+/3klfpezaRY+/
e59+gXLBbnrZRFz6amXkQ3rZrO+hX6js/IheNrt66Rcpo5/Q47Gf0t+p12/v
o5ethn76Gj/t6V/Qy1Yvtu7y07W/opetjfvp9e/ePX5A5v+BXfcNr8ePfiu7
shk+yP5u5eAh9rJJD7DHSzz2sjvpB/Z1fnofYFs2Ow+zl+1XfmQvO31H2C9W
jvzEHuceZS87wZ/Zy+HyX9jfo+e/cIw9fvU4e9mb8Ct7/PwJ9vcqCzPsZdfF
Rg41/M6e1886yX6Jn835p9jL5nts5Nibp9nTN/7BXt+XTORP9nL3Pmxkr+cv
9rx+7xD7euVnZ9jLyUNn2cux3X+zlzObhtkv89OpG2Ev99f/w1622v5lL3fH
rUrt43p/I9iWQ6tHyUZODWJXdpcG2C/33XIU23Li6Rz2cuzK0ezl1D5sNehe
Uy57OTjuIvb0XdiV2xvHsNfPgZYxQfZyRS/m54TdPJa9HDqLrft8J1vGsZcT
v2EjV3XlsZf7q/PZ36/7Uy5mLxdnsJFnpAvYyyY+nr3ju/sUDsvJ5SGeJw+m
sSO/NfsSni/Xb8NJuT33Uu7JnQuxJ/d1YOsB30OBy7gv5zdhW45+jB05UVHI
fXnd2zgpm8AE7su1i7Ent+7B1go9r6SI+7KTxLb8btFE7ssxg43cvx8n5XWl
xdyXox3Yk0efwFaTvh6rJnFfPn0M2/J8M5n7cuJzbOSOosu5L7++Frty+wHs
sZ9Twn393tK6DYflobwp3Jfra7Ejx97A/N6TGj+V+/SrsSs3DGBPjpZfwf2V
vqu6cFhOD2Bbrs4Lc1+uKcdGXt+Ek3JrJ3blvl7syc1nsLVK94uncV8+ORPb
cjyOHdk8i43csQMn5UIPu7JbEOG+HLgWWw/5Di3CYTn1FLblyVuxI7d+iY18
JKeU+/K8MuzKNcuwJ7c9Xlr5H1GKuWA=
               
               "]]}, {}}}, {}, {}, {}, {}}}}, {
        DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
         AxesOrigin -> {5, 0}, FrameTicks -> {{Automatic, 
            Charting`ScaledFrameTicks[{Identity, Identity}]}, {Automatic, 
            Charting`ScaledFrameTicks[{Identity, Identity}]}}, 
         GridLines -> {{}, {38200, 120000}}, DisplayFunction -> Identity, 
         PlotRangePadding -> {{0, 0}, {0, 0}}, PlotRangeClipping -> True, 
         ImagePadding -> All, DisplayFunction -> Identity, AspectRatio -> 1.3,
          Axes -> {True, True}, AxesLabel -> {None, None}, 
         AxesOrigin -> {5., 0}, DisplayFunction :> Identity, 
         Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 StyleBox["\"number of cases\"", 30, StripOnInput -> False], 
                 TextForm]], "InlineText"], 
              Text[
               Style["number of cases", 30]]], TraditionalForm], None}, {
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"day since first case\"", 30, StripOnInput -> False], 
                 TextForm]], "InlineText"], 
              Text[
               Style["day since first case", 30]]], TraditionalForm], None}}, 
         FrameStyle -> Directive[
           Thickness[0.005], 
           GrayLevel[0]], 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         FrameTicksStyle -> Directive[
           GrayLevel[0], 20], GridLines -> {{}, {38200, 120000}}, 
         GridLinesStyle -> Directive[
           GrayLevel[0.5], 
           Dashing[{0, Small}], 
           Thickness[Tiny]], ImageSize -> 450, 
         Method -> {
          "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
           AbsolutePointSize[6], "ScalingFunctions" -> None, 
           "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{5, 579}, {0, 972000}}, 
         PlotRangeClipping -> True, 
         PlotRangePadding -> {{Automatic, Automatic}, {Automatic, Automatic}},
          Ticks -> {Automatic, Automatic}}],FormBox[
        TagBox[
         GridBox[{{
            FormBox[
             
             TemplateBox[{
              "\"R[t]\"", "\"d[t]\"", "\"A[t]\"", "\"R[t]+d[t]+A[t]\""}, 
              "LineLegend", DisplayFunction -> (StyleBox[
                StyleBox[
                 PaneBox[
                  TagBox[
                   GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                    "Grid"], Alignment -> Left, AppearanceElements -> None, 
                  ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                  "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
                False]& ), 
              InterpretationFunction :> (RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0.33333333333333337`, 0.], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0.33333333333333337`, 0.], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0.33333333333333337`, 0.], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& ), Editable -> True], TraditionalForm]}, {
            FormBox[
             
             TemplateBox[{
              "\"R[t]\"", "\"d[t]\"", "\"A[t]\"", "\"R[t]+d[t]+A[t]\""}, 
              "LineLegend", DisplayFunction -> (StyleBox[
                StyleBox[
                 PaneBox[
                  TagBox[
                   GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    AbsoluteDashing[{3, 3}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0], 
                    AbsoluteDashing[{3, 3}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                    "Grid"], Alignment -> Left, AppearanceElements -> None, 
                  ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                  "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
                False]& ), 
              InterpretationFunction :> (RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0., 0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0., 0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0., 0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "1", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "3"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& 
               ), Editable -> True], TraditionalForm]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          GridBoxSpacings -> {"Columns" -> {{0}}}], "Grid"], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )], 
     TemplateBox[{GraphicsBox[{{{{}, {{{
              Directive[
               PointSize[0.007333333333333334], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                BoxData[
                 FormBox[
                  StyleBox[
                  "\"\[FilledCircle]\"", FontSize -> 12, StripOnInput -> 
                   False], TraditionalForm]], {0., 0.}], CompressedData["
1:eJx11luIVVUcx/HVhRiJA0dHRDB0G6Jhk4zaxSnTpZbXmRpPOqOVtjNtetA6
wjREYCxkFDMfjjFFDxWbhrB8kBNGFxl1eeti0ZxkuogS23kQg9CTpU6ZQ9Lv
ux5mQwOH33z4rf/677lwOOPXvFBYd5Mx5uD11w3XXzea8FWdzTd2aNZkMp/J
kZkc/T95WyajjG/PeELGEzO+I5OTyWlkHdlATiEfIuvJR8mpZMvQe2zwdPwk
vluZPoPvUSbP4Xvx8/g+ZbwRz1C69qHPmXTg+5WVV/AD7HN4ptJ34geVn23D
s5TlHXi2cn0JW+Zf5jnwjM30c5TVLfS4/jX6ucp27nO4rot+nnKA53V4YZjn
71DdSY/Lb9A/rOx8hx4vTujnK7u66fHM9+kXKHfvoscrPqBfqLS76XHjHvpF
/Dwf0eObP6ZfrJwc7sf94f4lytoyPR6HTaOyI/T4t730Tcr12OHeT+kfUQ4c
oMebPqHn/7rtc3qc20ffrBxzUGlx3WHOy278UdnTV75gfqn6xuPMy6aH+x39
q5553INNQTn8CPOyO8T9jn7Yl8zjFs6bx9gX5vESzjvZTTnGPO7+mvllch/7
rGy2h3n6zm+Zl+3+CvPLlbO+YV52MXZ4kN+P5/w+7gvvM4u+Y152r/cyj6dh
L/vcCeZb5Tt5HiubBWGevp3e0+e+Z36Ffp4R3Gdx5w/M4w56L5sLYf9K5Uuc
t7JtOMm87Lt+ZJ5+RB/zj6s/jy0++xPzuJX7vWw3/Mz8E/Km08zL5u3w/LJf
GvbL7hQ2eh93w9nH+7r9NeyX/XthnvNH6c0quSnsl6MPU+bpr/QzL9sGerNa
PneGeTnqPs+8HM+5wDz9sCrzTylfxFYu9WInV1ouMi+nTb8zH8sbcSSXz2Ar
V1f/Icdy6TT3Obl4F30i59/EXjZv4ZR972Lz9H9Zf8uf7Jdt4RL75eIG+lh2
J7Cjd5fZL5c6mPey2YJTuTnFZo087gr75fxX3Gdl1z7Afrm+FTvZt+GE89O5
z8tRD07lZDs2+txQHMl8JEfX/mK/HE/6h/18zqihd3L+1r/ZT3+R3tOPpedz
SrT1KvvXKg9zPpLzv4T9crUPx/RjmXf0ubBfdgXs5cSH/XLxEjbr9DyXcSTH
V7GVK0dwjGvDftnNx4nsD/H78nK5nz5l30p686z2LcOR3HyK85b+JI7ldBTn
nVzaihPmj4f9nB/EqVytvcb+Nj3/ubBfTifRW7m4HMdyvAo72e7BiVzKDbJf
bi7gFNcM2n8BsaPxmw==
               "]]}, {
              Directive[
               PointSize[0.007333333333333334], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                BoxData[
                 FormBox[
                  StyleBox[
                  "\"\[FilledSquare]\"", FontSize -> 12, StripOnInput -> 
                   False], TraditionalForm]], {0., 0.}], CompressedData["
1:eJxdkbtKA0EUQEdtUqawSGGxShARkahR4ysZ38+opBIJZIkExSaLhYlosWih
WEhE1DafkE9J6Wf4CQncM4G5C8Ph7JmZ3WHGq/VSbcQYk++Pof4YNu75L/g0
1veE8qTyUWu8J6X6mPJAzZ9QPa36pOpT+DKchrNwxvrz3PsCzKg+B9fgvDDe
xxfwbTyLH+KL+Dm+BI/9/xysz+ElfEVoy/gqPfT/a+Dr8ApusP4Sz8MK5Nxh
DbfCdpV98fCavsl+t3Q8GdG3hNEdHQ/u6Zyz26TjsVu/gz9AvNWg7wo7j3Q8
dPvvMd/tj0dPdO6tg7t7vHimH9Bf6Hjmjc69JmI6nnqlHwlvWnQ8+KRz7/EX
xNsf9BPO807H/3BTFFq3vuh/z5wKyz90vPtLPxNmv20PXg1lSA==
               "]]}, {
              Directive[
               PointSize[0.007333333333333334], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                BoxData[
                 FormBox[
                  StyleBox[
                  "\"\[FilledDiamond]\"", FontSize -> 12, StripOnInput -> 
                   False], TraditionalForm]], {0., 0.}], CompressedData["
1:eJxd1k2IVXUYx/HTZBItZCgXs4i4hsgQEc04TePk5FF7sRxTx7csa26TL1Ng
DoIlGHQYsWCCmFDLwOpWZjWa9jqV1XRoEYbQotUsgm4t2rSRNkVBJPw/T3DP
wOXHd37n9zz///M/59y7YGTP0I7LsyybufS57NKnLfv/L09ycVnSKyvcXuH5
Fe7Is5a/ayt+reJfX+GFFV5UyXfmrX1vyFv73pi39r2JdtGbaW/l/7fR7kq/
xXgJ7aF301uSFisrdVfRW5Pm63Cf6++p1I18P79eWVfUW1rxB5LWg29PWhvB
yyqcW88GdXB9O395a/0C5zv5K/BjfNzY07qPYi/FjX38O5KW+/k4H+PfmXT0
EB/nW/h3qXeAj9uf5DuX9qgf5/Q0NccaLnD7ON+5jB3k4+Zz/HuTXnyGj88/
y1+ddHCSj+e8yB9Muu0wH697gb8maccEH/c2+PclPXGcj/+y3mxt0tMv8/H8
o3z34XEc9+XoS67HhfWWeOEr8uv1e00en39VDq/il3j0mPxQ0u1H5HHP6/K4
Q70S//imvPv2qrfk4z42nwLHvEr8U+Q3Ju1+Wx5PviGP+9+RxzWcbUraNiWP
j6lX4Metr8T/uj7bnHTeKXk8wi9w73vyeOKkvOeg8a48Phn98c4z8vjIWfn7
k85+II//xgW++rQ87rPebGvSJ8wjx7sij6/5WB5PfyT/gPV9Io8H1S/wYvVK
/F3M78Gkf34oj1foV+B96pd47afy25Lutp4c/+z6Av+ifoknP5d/KOmAejme
/UweL+eXuF+97OGkJ5xHjs+9L4/7Io+7puWHk246J4834gK3fSmPV8f8vdcX
mVcN77W/HG+Qj++Vsa/Ux7/r18A/2H+Jx+23iddE/0eSPq9+DV8R/fHcL/TH
W6M//uZr/YPjvHEPbuIL1puNJD1ovfG9eKDUHx9Vv46HY7541Pk08O6433Gn
9Tbx/ji/R5N2z+iPD0V/PPWt/nh93J94pfk28BzzK/E/9tfEM+aZ+Z4fsJ8a
HubnuEP9+F0wbb8Fvi7OH/9qfyW+EPvHf8TztyPp99Zbw/V4nvFv3gd1PB79
cUO/Bn7KekrcGfvHQ7F/v2NmvR9reCrex7jHedbx4Zg/nlC/gcvYP94c/fEC
77NsV9J5nvcaHoz54yXRH3fF+wX3mF8Dn43zx3M9b0289FT+H777lOk=
               
               "]]}, {}}}, {}, {}, {}, {}}, {
           GraphicsComplexBox[CompressedData["
1:eJyl2Pc31+//wHFRKiUyEhp6p0FklIjiYSSRmRCyV/aeL+OFrMommxAZZXul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            "], {{{}, {
               EdgeForm[], 
               Directive[
                Opacity[0.]], 
               GraphicsGroupBox[{
                 PolygonBox[CompressedData["
1:eJwt0uk2FQAABOCLiIiSNbLTopAla/Y9RWiR7BWFexWlQigS4vRIejOfc/z4
ZuYBJnc6NBgMDwQCYfw77xPxn3T7mJdsU0oHQdJ4wRYltLNIKs/Z5B5tLJDC
M35wl1bmSWaYDYpp4QNJDLHOHZp5zzUGWeM2TcyRyFO+c4tGZrnKAN+4yUPe
cYV+vlJEA29J4AmrFFLPG+IpoI4ZLhNHLPnUMs0lHvOFPP5QwxQxHNHHZ3LZ
o5pJovnLI1bI4TcPmOAivSyTTRXjRJFFJWNE0sMnbrBLBa+5wCHdfCSTHcoZ
JYIDulgig1/c5xVnX9mnkxDX+UkZI5wCyWsrcg==
                  "]]}]}, {}, {
               EdgeForm[], 
               Directive[
                Opacity[0.]], 
               GraphicsGroupBox[{
                 PolygonBox[CompressedData["
1:eJwlz/c61nEcx+GHNLU0ZYZKy8k4BAfAoaCSvUey2pSZMpJ2SWYp0aJFEeJ2
+eO+Xp/v+3r++D1xKWnJqcGBQCCIUtJp9+jgkjtJZzV6fdNBtrirdIYod7ue
1Ne6WSv1G5HuNh0gxF2hX4lwt2qivtJNWq5fOOJu0RP6UoO1TD8T7m7WF+vf
G7TxvZ847L6jx/V5YOPPlMg0h9y39RmrFDPFQXuTHtOn+p8iPnLA1qgJ+kRX
KGSS/bZb+phlCvjAPvtNfcQS+bwnzH5D+/lHHhPstV/XhyySyzv22K9pHwvk
8Jbd9qv6gL9kc4Ve/nCRcXb5XYPGa4/Ok8VZ7zHdqfUap906xwXOeI9qqNbp
Ue3S35xnhB22Wr3PL84xzHZ7jd7jJ5mctg3pNr2ssdqpP8jglPcb3arVGqN3
9Ttrildf5g==
                  "]]}]}, {}, {
               EdgeForm[], 
               Directive[
                Opacity[0.]], 
               GraphicsGroupBox[{
                 PolygonBox[CompressedData["
1:eJwNxuc2FgAAANCPN/ECZWTvMiK7JQ2ysvdeTaEiMhtIsslIEXo398c954aU
Nxc1BQcCgSAmuSIX/CeDc4b5xSPa+Eo6b9jjIa18IY3X7FJCC5+5wSt2eEAz
C1znJdsU08Q8qbxgi/s0MkcKz9nkHg3MkswQG9ylnhmSGGSdO9QxTSIDrHGb
Wj6RQD8/KaKGKeIp5BmTxBFLDAVU85Fo+lglnz9UMUEUZ/TygzyOqWScSP7R
wwq5/KaCD1yjm+/kUM57IrjFU94RThfLZHNEGWOEcUonS2RxSCmjhHJCB4vc
5IAnjHCVv7TzjUz2ecxbLgE7qETu
                  
                  "]]}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, \
{{}, {}, 
              TagBox[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[1.6], 
                 RGBColor[1, 0.5, 0], 
                 AbsoluteDashing[{8, 5}], 
                 Thickness[0.0075]], 
                
                LineBox[{1, 89, 48, 130, 26, 111, 70, 137, 2, 90, 49, 131, 27,
                  112, 71, 138, 3, 91, 50, 132, 28, 113, 72, 139, 4, 92, 51, 
                 133, 29, 114, 73, 5, 93, 52, 30, 6, 94, 53, 31, 115, 74, 7, 
                 95, 54, 134, 32, 116, 75, 140, 8, 96, 55, 135, 33, 117, 76, 
                 141, 9, 97, 56, 136, 34, 118, 77, 10, 98, 57, 35, 11, 12, 13,
                  99, 58, 36, 14, 100, 59, 37, 119, 78, 15, 101, 60, 38, 120, 
                 79, 16, 102, 61, 39, 121, 80, 17, 103, 62, 40, 122, 81, 18, 
                 104, 63, 41, 123, 82, 19, 105, 64, 42, 124, 83, 20, 106, 65, 
                 43, 125, 84, 21, 107, 66, 44, 126, 85, 22, 108, 67, 45, 127, 
                 86, 23, 109, 68, 46, 128, 87, 24, 110, 69, 47, 129, 88, 142, 
                 25}]}, Annotation[#, "Charting`Private`Tag$95826#1"]& ], 
              TagBox[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[1.6], 
                 RGBColor[1, 0.5, 0], 
                 AbsoluteDashing[{8, 5}], 
                 Thickness[0.0075]], 
                LineBox[CompressedData["
1:eJwt0elWzWEYxuFNhUIDJUmlQRFOxiE4gDoUUkiTlApNqMjUZKgQpdKgQmSq
CJU06bKWD9f6Pe+997d/8ons41mbAoHABU7ynTYSjZd1qw7rYT2lc7ST5H1F
t+mIZmqO/qCDq4TaRvU0P3lANWH215rLLx5ywFaj23VMj2iezvOIZO9a3aHj
elTP6AKPSfGu0506oWdZpJN6zvGbLq4R7n9vNJ8lurlOhP2tnucPT7hBpP2d
FrDMUxqIsk9qISs8o5Fd9vdaxCo9NLHb/kGLWeM5qbabGq1TWsI6L0iz3dIY
/fj/O/2ll2b22D9pKQF3nxzU2xqrn/Xiv5/cL/UOe91ftIzN7n5N17sap1+1
nCD3gGboPd2n03qJYPeg3ifePaMVhLhf6SFt0f06q5VscQ9pKwnub3pMq3QD
NvheYw==
                 "]]}, 
               Annotation[#, "Charting`Private`Tag$95826#1"]& ], 
              TagBox[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[1.6], 
                 GrayLevel[0], 
                 AbsoluteDashing[{8, 5}], 
                 Thickness[0.0075]], 
                LineBox[CompressedData["
1:eJwV0edaDQAAgOHTpXQDWrRoqCiVcFpEw0G7TjurQhSVk2hStENpL7o5bz/e
5/n+f9GhcLA1KhAIRLgghqhkh1zm6eSYGIapYpc8FujihFjeU80eN/hON6fE
8YEa9snnBz3EM8JDCkhglBCFLNLLRcZ4xAE3WeIpf7nERx5zSBHLPOMfiUR4
whG3WOE5SYxTy22SSSGVT9Rxh8tMUE+QVV5whc80UMwaL0njC42UsE4f6UzS
RCkb9JPBFM2U8ZMBMpmmhXJ+8YqrzHA+8i6/eU0Ws4S5xyZvyGaONirYYpAc
vtLOff7wlmt8o4MHbPOOM67zH22eQ28=
                 "]]}, 
               Annotation[#, 
                "Charting`Private`Tag$95826#1"]& ]}}], {}, {}}}, {{{}, {{{
              Directive[
               PointSize[0.007333333333333334], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                BoxData[
                 FormBox[
                  StyleBox[
                  "\"\[FilledCircle]\"", FontSize -> 12, StripOnInput -> 
                   False], TraditionalForm]], {0., 0.}], CompressedData["
1:eJx11luIVVUcx/HVhRiJA0dHRDB0G6Jhk4zaxSnTpZbXmRpPOqOVtjNtetA6
wjREYCxkFDMfjjFFDxWbhrB8kBNGFxl1eeti0ZxkuogS23kQg9CTpU6ZQ9Lv
ux5mQwOH33z4rf/677lwOOPXvFBYd5Mx5uD11w3XXzea8FWdzTd2aNZkMp/J
kZkc/T95WyajjG/PeELGEzO+I5OTyWlkHdlATiEfIuvJR8mpZMvQe2zwdPwk
vluZPoPvUSbP4Xvx8/g+ZbwRz1C69qHPmXTg+5WVV/AD7HN4ptJ34geVn23D
s5TlHXi2cn0JW+Zf5jnwjM30c5TVLfS4/jX6ucp27nO4rot+nnKA53V4YZjn
71DdSY/Lb9A/rOx8hx4vTujnK7u66fHM9+kXKHfvoscrPqBfqLS76XHjHvpF
/Dwf0eObP6ZfrJwc7sf94f4lytoyPR6HTaOyI/T4t730Tcr12OHeT+kfUQ4c
oMebPqHn/7rtc3qc20ffrBxzUGlx3WHOy278UdnTV75gfqn6xuPMy6aH+x39
q5553INNQTn8CPOyO8T9jn7Yl8zjFs6bx9gX5vESzjvZTTnGPO7+mvllch/7
rGy2h3n6zm+Zl+3+CvPLlbO+YV52MXZ4kN+P5/w+7gvvM4u+Y152r/cyj6dh
L/vcCeZb5Tt5HiubBWGevp3e0+e+Z36Ffp4R3Gdx5w/M4w56L5sLYf9K5Uuc
t7JtOMm87Lt+ZJ5+RB/zj6s/jy0++xPzuJX7vWw3/Mz8E/Km08zL5u3w/LJf
GvbL7hQ2eh93w9nH+7r9NeyX/XthnvNH6c0quSnsl6MPU+bpr/QzL9sGerNa
PneGeTnqPs+8HM+5wDz9sCrzTylfxFYu9WInV1ouMi+nTb8zH8sbcSSXz2Ar
V1f/Icdy6TT3Obl4F30i59/EXjZv4ZR972Lz9H9Zf8uf7Jdt4RL75eIG+lh2
J7Cjd5fZL5c6mPey2YJTuTnFZo087gr75fxX3Gdl1z7Afrm+FTvZt+GE89O5
z8tRD07lZDs2+txQHMl8JEfX/mK/HE/6h/18zqihd3L+1r/ZT3+R3tOPpedz
SrT1KvvXKg9zPpLzv4T9crUPx/RjmXf0ubBfdgXs5cSH/XLxEjbr9DyXcSTH
V7GVK0dwjGvDftnNx4nsD/H78nK5nz5l30p686z2LcOR3HyK85b+JI7ldBTn
nVzaihPmj4f9nB/EqVytvcb+Nj3/ubBfTifRW7m4HMdyvAo72e7BiVzKDbJf
bi7gFNcM2n8BsaPxmw==
               "]]}, {
              Directive[
               PointSize[0.007333333333333334], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                BoxData[
                 FormBox[
                  StyleBox[
                  "\"\[FilledSquare]\"", FontSize -> 12, StripOnInput -> 
                   False], TraditionalForm]], {0., 0.}], CompressedData["
1:eJxdkbtKA0EUQEdtUqawSGGxShARkahR4ysZ38+opBIJZIkExSaLhYlosWih
WEhE1DafkE9J6Wf4CQncM4G5C8Ph7JmZ3WHGq/VSbcQYk++Pof4YNu75L/g0
1veE8qTyUWu8J6X6mPJAzZ9QPa36pOpT+DKchrNwxvrz3PsCzKg+B9fgvDDe
xxfwbTyLH+KL+Dm+BI/9/xysz+ElfEVoy/gqPfT/a+Dr8ApusP4Sz8MK5Nxh
DbfCdpV98fCavsl+t3Q8GdG3hNEdHQ/u6Zyz26TjsVu/gz9AvNWg7wo7j3Q8
dPvvMd/tj0dPdO6tg7t7vHimH9Bf6Hjmjc69JmI6nnqlHwlvWnQ8+KRz7/EX
xNsf9BPO807H/3BTFFq3vuh/z5wKyz90vPtLPxNmv20PXg1lSA==
               "]]}, {
              Directive[
               PointSize[0.007333333333333334], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                BoxData[
                 FormBox[
                  StyleBox[
                  "\"\[FilledDiamond]\"", FontSize -> 12, StripOnInput -> 
                   False], TraditionalForm]], {0., 0.}], CompressedData["
1:eJxd1k2IVXUYx/HTZBItZCgXs4i4hsgQEc04TePk5FF7sRxTx7csa26TL1Ng
DoIlGHQYsWCCmFDLwOpWZjWa9jqV1XRoEYbQotUsgm4t2rSRNkVBJPw/T3DP
wOXHd37n9zz///M/59y7YGTP0I7LsyybufS57NKnLfv/L09ycVnSKyvcXuH5
Fe7Is5a/ayt+reJfX+GFFV5UyXfmrX1vyFv73pi39r2JdtGbaW/l/7fR7kq/
xXgJ7aF301uSFisrdVfRW5Pm63Cf6++p1I18P79eWVfUW1rxB5LWg29PWhvB
yyqcW88GdXB9O395a/0C5zv5K/BjfNzY07qPYi/FjX38O5KW+/k4H+PfmXT0
EB/nW/h3qXeAj9uf5DuX9qgf5/Q0NccaLnD7ON+5jB3k4+Zz/HuTXnyGj88/
y1+ddHCSj+e8yB9Muu0wH697gb8maccEH/c2+PclPXGcj/+y3mxt0tMv8/H8
o3z34XEc9+XoS67HhfWWeOEr8uv1e00en39VDq/il3j0mPxQ0u1H5HHP6/K4
Q70S//imvPv2qrfk4z42nwLHvEr8U+Q3Ju1+Wx5PviGP+9+RxzWcbUraNiWP
j6lX4Metr8T/uj7bnHTeKXk8wi9w73vyeOKkvOeg8a48Phn98c4z8vjIWfn7
k85+II//xgW++rQ87rPebGvSJ8wjx7sij6/5WB5PfyT/gPV9Io8H1S/wYvVK
/F3M78Gkf34oj1foV+B96pd47afy25Lutp4c/+z6Av+ifoknP5d/KOmAejme
/UweL+eXuF+97OGkJ5xHjs+9L4/7Io+7puWHk246J4834gK3fSmPV8f8vdcX
mVcN77W/HG+Qj++Vsa/Ux7/r18A/2H+Jx+23iddE/0eSPq9+DV8R/fHcL/TH
W6M//uZr/YPjvHEPbuIL1puNJD1ovfG9eKDUHx9Vv46HY7541Pk08O6433Gn
9Tbx/ji/R5N2z+iPD0V/PPWt/nh93J94pfk28BzzK/E/9tfEM+aZ+Z4fsJ8a
HubnuEP9+F0wbb8Fvi7OH/9qfyW+EPvHf8TztyPp99Zbw/V4nvFv3gd1PB79
cUO/Bn7KekrcGfvHQ7F/v2NmvR9reCrex7jHedbx4Zg/nlC/gcvYP94c/fEC
77NsV9J5nvcaHoz54yXRH3fF+wX3mF8Dn43zx3M9b0289FT+H777lOk=
               
               "]]}, {}}}, {}, {}, {}, {}}, {
           GraphicsComplexBox[CompressedData["
1:eJyF1mk4FHz3B/ApoVBIhVQSLfZbUrZyCE3WCFkm+76vY+wzCNmyh+xrJIZk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            
            "], {{{}, {
               EdgeForm[], 
               Directive[
                Opacity[0.]], 
               GraphicsGroupBox[{
                 PolygonBox[CompressedData["
1:eJwt0tc3FwAYBuCfGSpKIiGrKCKUFWVkVmalzMouW3ZGRiKk4y/2OMfF837v
5XvxpQ/OdE4HBwKBIM4ub47IJVH/zye2eUI909zhI7/Ip44pEuhiizxeMUk8
H9jkMbVMcJv3bJBLDd+J4x3rF3uo5hu36OQnj6hinFg6WOMhLxnjJu2sks0L
RrlBGytkUckIMTyggmGiuc417vOcIa7SyjKZHFLOIFGc0sISGRxQxlci+cdb
FknnD6V8IYIT3rBAGvuU8JkrvOYHqRQzQDj3eEY/YTQzTwq/eUofoRzTxBzJ
7FFELyEc0cgsSexSSA8XP/OXBma4yw4FdHMO/pgrZw==
                  "]]}]}, {}, {
               EdgeForm[], 
               Directive[
                Opacity[0.]], 
               GraphicsGroupBox[{
                 PolygonBox[CompressedData["
1:eJwt0elWDHAcx+ExpBKhhdBibNXtuIQuoK4FqUTSgkoLokKrNZR2pNKGVltF
WqSnkxfP+Xz/vzMvZs6EMrLOZgYDgcAOLnGONI90yu1U/a5J2qaDhNtl+o1E
u1Xfs9u+qV85ZrfoO8LsGzrPUbtZ37LLvq5zHLGbdICddqnOkmA3aj9Bu0Rn
OGw/0r6t724X6zSH7IfaG9j+UUUyRbz9QHv4xzW+EOfeoN1sUMhnYt3rtYu/
XOUTMe51+oZ1CpjkoPt97WSNK0xwwP2edrDKZcbZ716rr1khn7u84s///2KM
aJ+7oyf0pS6TxxnvUd2ntzWk7fqbXE57f9S9WqPH9YX+IocRotyq9TlLXKSK
ZyySzTB7fK5Sn7LABU65DWmk3tIUfaI/Oc9J7w8aoRWarI/1B5vkxFyO
                  
                  "]]}]}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
              TagBox[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[1.6], 
                 RGBColor[1, 0, 1], 
                 AbsoluteDashing[{8, 10}], 
                 Thickness[0.00751]], 
                
                LineBox[{1, 89, 48, 130, 26, 111, 70, 138, 2, 90, 49, 131, 27,
                  112, 71, 139, 3, 91, 50, 132, 28, 113, 72, 140, 4, 92, 51, 
                 133, 29, 114, 73, 5, 93, 52, 30, 6, 94, 53, 31, 115, 74, 7, 
                 95, 54, 134, 32, 116, 75, 141, 8, 96, 55, 135, 33, 117, 76, 
                 142, 9, 97, 56, 136, 34, 118, 77, 143, 10, 98, 57, 137, 35, 
                 119, 78, 11, 99, 58, 36, 12, 13, 14, 100, 59, 37, 15, 101, 
                 60, 38, 120, 79, 16, 102, 61, 39, 121, 80, 17, 103, 62, 40, 
                 122, 81, 18, 104, 63, 41, 123, 82, 19, 105, 64, 42, 124, 83, 
                 20, 106, 65, 43, 125, 84, 21, 107, 66, 44, 126, 85, 22, 108, 
                 67, 45, 127, 86, 23, 109, 68, 46, 128, 87, 24, 110, 69, 47, 
                 129, 88, 144, 25}]}, 
               Annotation[#, "Charting`Private`Tag$108987#1"]& ], 
              TagBox[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[1.6], 
                 RGBColor[1, 0, 1], 
                 AbsoluteDashing[{8, 10}], 
                 Thickness[0.00751]], 
                LineBox[CompressedData["
1:eJwlzuk2lmEYhuFPSkolmogyZNgfm2ADsi2VhDJTxkxFSFEZK2MSUaFSiAil
TIfVj2Od13Ov98ebkJ6RdjUoEAjc4ho/ecZlx0oN1Um9otd1lefEeVfpMX2v
SXpD13hBNcfdpjSTX3RRw03W6eY+Yb6b1iw26CHerVZP6AdNDvr/j5v0kuBd
pyf1o6Zotv6mj0Tvej2lnzSHP/TTQC5bvKSRcN/N6G3+8ooHnHaf1Tv84zUP
iXCf0zy2GaCJSPfPms8OgzRzxv2LFrDLEI846/5VC9ljmBbOuc9rEQF7RFo5
b3/T4oOzPaptXLC/awmH7Df6mCh7QUsJtse0nWh7Ucs4bL/VJ1y0l/QuR+xx
fUqM/UPvEWK/0w5i7WUt56g9oZ1cslc0VSt0H43MXDc=
                 "]]}, 
               Annotation[#, 
                "Charting`Private`Tag$108987#1"]& ]}}], {}, {}}}}, {
        DisplayFunction -> Identity, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         AxesOrigin -> {0, 0}, PlotRange -> {{0, 579}, {-1, 117800}}, 
         PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
         Identity, AspectRatio -> 1.3, Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
         Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 StyleBox["\"number of cases\"", 30, StripOnInput -> False], 
                 TextForm]], "InlineText"], 
              Text[
               Style["number of cases", 30]]], TraditionalForm], None}, {
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"day since first case\"", 30, StripOnInput -> False], 
                 TextForm]], "InlineText"], 
              Text[
               Style["day since first case", 30]]], TraditionalForm], None}}, 
         FrameStyle -> Directive[
           Thickness[0.005], 
           GrayLevel[0]], 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         FrameTicksStyle -> Directive[
           GrayLevel[0], 20], GridLines -> {{{191, 
             RGBColor[1, 0, 0]}}, {}}, GridLinesStyle -> Directive[
           GrayLevel[0.5], 
           Dashing[{Small, Small}], 
           Thickness[Tiny]], ImageSize -> 450, 
         Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{0, 579}, {-1, 117800}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}],FormBox[
        TagBox[
         GridBox[{{
            FormBox[
             
             TemplateBox[{"\"A[t]\"", "\"Casos por d\[IAcute]a\""}, 
              "LineLegend", DisplayFunction -> (StyleBox[
                StyleBox[
                 PaneBox[
                  TagBox[
                   GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.0675]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.0675]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.0675]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.0675]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                    "Grid"], Alignment -> Left, AppearanceElements -> None, 
                  ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                  "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
                False]& ), 
              InterpretationFunction :> (RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0.33333333333333337`, 0.], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.0075`", "]"}]}], "]"}], ",", 
                    
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0.33333333333333337`, 0.], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.0075`", "]"}]}], "]"}], ",", 
                    
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                    ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.0075`", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& ), Editable -> True], TraditionalForm]}, {
            FormBox[
             
             TemplateBox[{"\"A[t]\"", "\"Casos por d\[IAcute]a\""}, 
              "LineLegend", DisplayFunction -> (StyleBox[
                StyleBox[
                 PaneBox[
                  TagBox[
                   GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                    "Grid"], Alignment -> Left, AppearanceElements -> None, 
                  ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                  "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
                False]& ), 
              InterpretationFunction :> (RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0., 0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0., 0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& ), Editable -> True], TraditionalForm]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          GridBoxSpacings -> {"Columns" -> {{0}}}], "Grid"], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )], 
     TemplateBox[{GraphicsBox[{{{{}, {{{
              Directive[
               PointSize[0.009166666666666668], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                BoxData[
                 FormBox[
                  StyleBox[
                  "\"\[FilledCircle]\"", FontSize -> 8.96, StripOnInput -> 
                   False], TraditionalForm]], {0., 0.}], CompressedData["
1:eJxd1k2IVXUYx/HTZBItZCgXs4i4hsgQEc04TePk5FF7sRxTx7csa26TL1Ng
DoIlGHQYsWCCmFDLwOpWZjWa9jqV1XRoEYbQotUsgm4t2rSRNkVBJPw/T3DP
wOXHd37n9zz///M/59y7YGTP0I7LsyybufS57NKnLfv/L09ycVnSKyvcXuH5
Fe7Is5a/ayt+reJfX+GFFV5UyXfmrX1vyFv73pi39r2JdtGbaW/l/7fR7kq/
xXgJ7aF301uSFisrdVfRW5Pm63Cf6++p1I18P79eWVfUW1rxB5LWg29PWhvB
yyqcW88GdXB9O395a/0C5zv5K/BjfNzY07qPYi/FjX38O5KW+/k4H+PfmXT0
EB/nW/h3qXeAj9uf5DuX9qgf5/Q0NccaLnD7ON+5jB3k4+Zz/HuTXnyGj88/
y1+ddHCSj+e8yB9Muu0wH697gb8maccEH/c2+PclPXGcj/+y3mxt0tMv8/H8
o3z34XEc9+XoS67HhfWWeOEr8uv1e00en39VDq/il3j0mPxQ0u1H5HHP6/K4
Q70S//imvPv2qrfk4z42nwLHvEr8U+Q3Ju1+Wx5PviGP+9+RxzWcbUraNiWP
j6lX4Metr8T/uj7bnHTeKXk8wi9w73vyeOKkvOeg8a48Phn98c4z8vjIWfn7
k85+II//xgW++rQ87rPebGvSJ8wjx7sij6/5WB5PfyT/gPV9Io8H1S/wYvVK
/F3M78Gkf34oj1foV+B96pd47afy25Lutp4c/+z6Av+ifoknP5d/KOmAejme
/UweL+eXuF+97OGkJ5xHjs+9L4/7Io+7puWHk246J4834gK3fSmPV8f8vdcX
mVcN77W/HG+Qj++Vsa/Ux7/r18A/2H+Jx+23iddE/0eSPq9+DV8R/fHcL/TH
W6M//uZr/YPjvHEPbuIL1puNJD1ovfG9eKDUHx9Vv46HY7541Pk08O6433Gn
9Tbx/ji/R5N2z+iPD0V/PPWt/nh93J94pfk28BzzK/E/9tfEM+aZ+Z4fsJ8a
HubnuEP9+F0wbb8Fvi7OH/9qfyW+EPvHf8TztyPp99Zbw/V4nvFv3gd1PB79
cUO/Bn7KekrcGfvHQ7F/v2NmvR9reCrex7jHedbx4Zg/nlC/gcvYP94c/fEC
77NsV9J5nvcaHoz54yXRH3fF+wX3mF8Dn43zx3M9b0289FT+H777lOk=
               
               "]]}, {}}}, {}, {}, {}, {}}, {
           GraphicsComplexBox[CompressedData["
1:eJw1lnk0FAoDxefRqxehLMmS9KIiRMj6ci1JimxJyNgmMpZhxixmMKPJEpWE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            "], {{{}, {
               EdgeForm[], 
               Directive[
                Opacity[0.]], 
               GraphicsGroupBox[{
                 
                 PolygonBox[{{1, 160, 161, 25, 159, 96, 143, 49, 73, 120, 24, 
                  95, 142, 48, 154, 72, 119, 23, 94, 141, 47, 71, 118, 22, 93,
                   140, 46, 153, 70, 117, 21, 92, 139, 45, 152, 69, 116, 20, 
                  91, 138, 44, 68, 115, 19, 90, 137, 43, 151, 67, 114, 18, 89,
                   136, 42, 66, 113, 17, 88, 135, 41, 150, 65, 112, 16, 87, 
                  134, 40, 149, 64, 111, 15, 86, 133, 39, 63, 110, 14, 85, 
                  132, 38, 62, 109, 13, 84, 131, 37, 61, 108, 12, 83, 130, 36,
                   60, 107, 11, 82, 129, 35, 59, 106, 10, 81, 128, 34, 58, 
                  105, 9, 33, 57, 104, 8, 80, 127, 32, 148, 56, 103, 7, 158, 
                  79, 126, 31, 147, 55, 102, 6, 157, 78, 125, 30, 146, 54, 
                  101, 5, 77, 124, 29, 53, 100, 4, 76, 123, 28, 52, 99, 3, 
                  156, 75, 122, 27, 145, 51, 98, 2, 155, 74, 121, 26, 144, 50,
                   97}}]}]}, {}, {}}, {{}, {}, 
              TagBox[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[1.6], 
                 RGBColor[1, 0.5, 0], 
                 AbsoluteDashing[{8, 5}], 
                 Thickness[0.0075]], 
                
                LineBox[{1, 97, 50, 144, 26, 121, 74, 155, 2, 98, 51, 145, 27,
                  122, 75, 156, 3, 99, 52, 28, 123, 76, 4, 100, 53, 29, 124, 
                 77, 5, 101, 54, 146, 30, 125, 78, 157, 6, 102, 55, 147, 31, 
                 126, 79, 158, 7, 103, 56, 148, 32, 127, 80, 8, 104, 57, 33, 
                 9, 105, 58, 34, 128, 81, 10, 106, 59, 35, 129, 82, 11, 107, 
                 60, 36, 130, 83, 12, 108, 61, 37, 131, 84, 13, 109, 62, 38, 
                 132, 85, 14, 110, 63, 39, 133, 86, 15, 111, 64, 149, 40, 134,
                  87, 16, 112, 65, 150, 41, 135, 88, 17, 113, 66, 42, 136, 89,
                  18, 114, 67, 151, 43, 137, 90, 19, 115, 68, 44, 138, 91, 20,
                  116, 69, 152, 45, 139, 92, 21, 117, 70, 153, 46, 140, 93, 
                 22, 118, 71, 47, 141, 94, 23, 119, 72, 154, 48, 142, 95, 24, 
                 120, 73, 49, 143, 96, 159, 25}]}, 
               Annotation[#, 
                "Charting`Private`Tag$102136#1"]& ]}}], {}, {}}}, {{{}, {{{
              Directive[
               PointSize[0.009166666666666668], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6], 
               AbsolutePointSize[6]], 
              GeometricTransformationBox[
               InsetBox[
                Graphics3DBox[{
                  Directive[
                   PointSize[0.009166666666666668], 
                   RGBColor[0.368417, 0.506779, 0.709798], 
                   AbsoluteThickness[1.6], 
                   AbsolutePointSize[6]], 
                  GrayLevel[0], 
                  EdgeForm[None], 
                  Glow[
                   RGBColor[0, 0.6666666666666666, 0]], 
                  CuboidBox[{0, 0, 0}]}, Boxed -> False, 
                 ImageSize -> {13.693338432432654`, 12.}, 
                 ViewPoint -> {0.17134623817277983`, 0.2733380173970694, 
                  3.3683715345711907`}, 
                 ViewVertical -> {-0.5474806517236538, 0.6107600623868774, 
                  0.5720463986263885}], {0., 0.}], CompressedData["
1:eJxd1k2IVXUYx/HTZBItZCgXs4i4hsgQEc04TePk5FF7sRxTx7csa26TL1Ng
DoIlGHQYsWCCmFDLwOpWZjWa9jqV1XRoEYbQotUsgm4t2rSRNkVBJPw/T3DP
wOXHd37n9zz///M/59y7YGTP0I7LsyybufS57NKnLfv/L09ycVnSKyvcXuH5
Fe7Is5a/ayt+reJfX+GFFV5UyXfmrX1vyFv73pi39r2JdtGbaW/l/7fR7kq/
xXgJ7aF301uSFisrdVfRW5Pm63Cf6++p1I18P79eWVfUW1rxB5LWg29PWhvB
yyqcW88GdXB9O395a/0C5zv5K/BjfNzY07qPYi/FjX38O5KW+/k4H+PfmXT0
EB/nW/h3qXeAj9uf5DuX9qgf5/Q0NccaLnD7ON+5jB3k4+Zz/HuTXnyGj88/
y1+ddHCSj+e8yB9Muu0wH697gb8maccEH/c2+PclPXGcj/+y3mxt0tMv8/H8
o3z34XEc9+XoS67HhfWWeOEr8uv1e00en39VDq/il3j0mPxQ0u1H5HHP6/K4
Q70S//imvPv2qrfk4z42nwLHvEr8U+Q3Ju1+Wx5PviGP+9+RxzWcbUraNiWP
j6lX4Metr8T/uj7bnHTeKXk8wi9w73vyeOKkvOeg8a48Phn98c4z8vjIWfn7
k85+II//xgW++rQ87rPebGvSJ8wjx7sij6/5WB5PfyT/gPV9Io8H1S/wYvVK
/F3M78Gkf34oj1foV+B96pd47afy25Lutp4c/+z6Av+ifoknP5d/KOmAejme
/UweL+eXuF+97OGkJ5xHjs+9L4/7Io+7puWHk246J4834gK3fSmPV8f8vdcX
mVcN77W/HG+Qj++Vsa/Ux7/r18A/2H+Jx+23iddE/0eSPq9+DV8R/fHcL/TH
W6M//uZr/YPjvHEPbuIL1puNJD1ovfG9eKDUHx9Vv46HY7541Pk08O6433Gn
9Tbx/ji/R5N2z+iPD0V/PPWt/nh93J94pfk28BzzK/E/9tfEM+aZ+Z4fsJ8a
HubnuEP9+F0wbb8Fvi7OH/9qfyW+EPvHf8TztyPp99Zbw/V4nvFv3gd1PB79
cUO/Bn7KekrcGfvHQ7F/v2NmvR9reCrex7jHedbx4Zg/nlC/gcvYP94c/fEC
77NsV9J5nvcaHoz54yXRH3fF+wX3mF8Dn43zx3M9b0289FT+H777lOk=
               
               "]]}, {}}}, {}, {}, {}, {}}, {
           GraphicsComplexBox[CompressedData["
1:eJw1Vnk0FAofnZdHLxRSJF74eIoGyVO2cq1N9iRZJsYy9jS2MfaZiCKyTqZk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            "], {{{}, {
               EdgeForm[], 
               Directive[
                Opacity[0.]], 
               GraphicsGroupBox[{
                 
                 PolygonBox[{{1, 152, 153, 25, 151, 95, 141, 49, 73, 119, 24, 
                  94, 140, 48, 72, 118, 23, 93, 139, 47, 71, 117, 22, 92, 138,
                   46, 70, 116, 21, 91, 137, 45, 69, 115, 20, 90, 136, 44, 68,
                   114, 19, 89, 135, 43, 67, 113, 18, 88, 134, 42, 66, 112, 
                  17, 87, 133, 41, 65, 111, 16, 86, 132, 40, 64, 110, 15, 85, 
                  131, 39, 63, 109, 14, 84, 130, 38, 62, 108, 13, 83, 129, 37,
                   61, 107, 12, 82, 128, 36, 60, 106, 11, 81, 127, 35, 59, 
                  105, 10, 34, 58, 104, 9, 80, 126, 33, 146, 57, 103, 8, 150, 
                  79, 125, 32, 145, 56, 102, 7, 149, 78, 124, 31, 144, 55, 
                  101, 6, 77, 123, 30, 54, 100, 5, 29, 53, 99, 4, 76, 122, 28,
                   52, 98, 3, 148, 75, 121, 27, 143, 51, 97, 2, 147, 74, 120, 
                  26, 142, 50, 
                  96}}]}]}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, {}, 
              TagBox[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[1.6], 
                 RGBColor[1, 0, 1], 
                 AbsoluteDashing[{8, 10}], 
                 Thickness[0.00751]], 
                
                LineBox[{1, 96, 50, 142, 26, 120, 74, 147, 2, 97, 51, 143, 27,
                  121, 75, 148, 3, 98, 52, 28, 122, 76, 4, 99, 53, 29, 5, 100,
                  54, 30, 123, 77, 6, 101, 55, 144, 31, 124, 78, 149, 7, 102, 
                 56, 145, 32, 125, 79, 150, 8, 103, 57, 146, 33, 126, 80, 9, 
                 104, 58, 34, 10, 105, 59, 35, 127, 81, 11, 106, 60, 36, 128, 
                 82, 12, 107, 61, 37, 129, 83, 13, 108, 62, 38, 130, 84, 14, 
                 109, 63, 39, 131, 85, 15, 110, 64, 40, 132, 86, 16, 111, 65, 
                 41, 133, 87, 17, 112, 66, 42, 134, 88, 18, 113, 67, 43, 135, 
                 89, 19, 114, 68, 44, 136, 90, 20, 115, 69, 45, 137, 91, 21, 
                 116, 70, 46, 138, 92, 22, 117, 71, 47, 139, 93, 23, 118, 72, 
                 48, 140, 94, 24, 119, 73, 49, 141, 95, 151, 25}]}, 
               Annotation[#, 
                "Charting`Private`Tag$114939#1"]& ]}}], {}, {}}}}, {
        DisplayFunction -> Identity, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         AxesOrigin -> {0, 0}, PlotRange -> {{0, 579}, {0, 9500}}, 
         PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
         Identity, AspectRatio -> 1.3, Axes -> {True, True}, 
         AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
         Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 StyleBox["\"number of cases\"", 30, StripOnInput -> False], 
                 TextForm]], "InlineText"], 
              Text[
               Style["number of cases", 30]]], TraditionalForm], None}, {
            FormBox[
             InterpretationBox[
              Cell[
               BoxData[
                FormBox[
                 StyleBox[
                 "\"day since first case\"", 30, StripOnInput -> False], 
                 TextForm]], "InlineText"], 
              Text[
               Style["day since first case", 30]]], TraditionalForm], None}}, 
         FrameStyle -> Directive[
           Thickness[0.005], 
           GrayLevel[0]], 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         FrameTicksStyle -> Directive[
           GrayLevel[0], 20], GridLines -> {{{191, 
             RGBColor[1, 0, 0]}}, {}}, GridLinesStyle -> Directive[
           GrayLevel[0.5], 
           Dashing[{Small, Small}], 
           Thickness[Tiny]], ImageSize -> 450, 
         Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), "CopiedValueFunction" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& )}}, PlotRange -> {{0, 579}, {0, 9500}}, 
         PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
         Ticks -> {Automatic, Automatic}}],FormBox[
        TagBox[
         GridBox[{{
            FormBox[
             
             TemplateBox[{"\"casos diarios\""}, "LineLegend", 
              DisplayFunction -> (StyleBox[
                StyleBox[
                 PaneBox[
                  TagBox[
                   GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.0675]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0.5, 0], 
                    AbsoluteDashing[{8, 5}], 
                    Thickness[0.0675]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                    "Grid"], Alignment -> Left, AppearanceElements -> None, 
                  ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                  "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
                False]& ), 
              InterpretationFunction :> (RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "5"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.0075`", "]"}]}], "]"}], 
                    "}"}], ",", 
                   RowBox[{"{", #, "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& ), Editable -> True], TraditionalForm]}, {
            FormBox[
             
             TemplateBox[{"\"casos diarios\""}, "LineLegend", 
              DisplayFunction -> (StyleBox[
                StyleBox[
                 PaneBox[
                  TagBox[
                   GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 1], 
                    AbsoluteDashing[{8, 10}], 
                    Thickness[0.06759]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                    "Grid"], Alignment -> Left, AppearanceElements -> None, 
                  ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                  "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
                False]& ), 
              InterpretationFunction :> (RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[
                    0.6666666666666666, 0., 0.6666666666666666], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00751`", "]"}]}], "]"}], ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.00245`", "]"}]}], "]"}]}], 
                    "}"}], ",", 
                   RowBox[{"{", #, "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& ), Editable -> True], TraditionalForm]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, AutoDelete -> False, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
          GridBoxSpacings -> {"Columns" -> {{0}}}], "Grid"], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.8035013674394817`*^9, 3.803501398108254*^9, 3.8035014455161877`*^9, 
   3.803501613476871*^9, 3.803501733490983*^9, {3.8035018265444527`*^9, 
   3.803501849002879*^9}, 3.803502213561082*^9, 3.803502451537005*^9, 
   3.803502528847595*^9, 3.8035025715665007`*^9, 3.8035033799695063`*^9, 
   3.8035034623976088`*^9, 3.8035040010050087`*^9, 3.8035050408113413`*^9, 
   3.803505091617178*^9, 3.803565369079356*^9, 3.8035654246071053`*^9, 
   3.803565549853313*^9, 3.8035656188579617`*^9, 3.8035659051219482`*^9, 
   3.803565964258895*^9, 3.803566333821042*^9, 3.8035671590093813`*^9, 
   3.803567716131692*^9, 3.8035677652420053`*^9, 3.803569977099828*^9, 
   3.803571203366865*^9, 3.803571316445422*^9, 3.8035714060140877`*^9, 
   3.803571467220931*^9, 3.803571523482995*^9, 3.803571604326353*^9, 
   3.80357165234779*^9, 3.803591521940722*^9, 3.803591667531494*^9, 
   3.803664651836499*^9, 3.803664800546015*^9, 3.803665419783601*^9, 
   3.803665556651681*^9, 3.803665646152676*^9, 3.8036660458998737`*^9, 
   3.8036662617645283`*^9, 3.8036663133138638`*^9, 3.803666435164356*^9, 
   3.803666483324888*^9, 3.803666570815468*^9, 3.8036666371556664`*^9, 
   3.803667254404439*^9, 3.80366730530751*^9, 3.803667448958898*^9, 
   3.8036675610991993`*^9, 3.803735730935544*^9, 3.803735761585218*^9, 
   3.803735832063184*^9, {3.8037359577267227`*^9, 3.8037359844906588`*^9}, {
   3.803736022701873*^9, 3.803736051417492*^9}, 3.803736158789359*^9, 
   3.80373622022024*^9, 3.803736266379346*^9, 3.8037364094137173`*^9, {
   3.803736443669479*^9, 3.803736480173361*^9}, {3.803736522993697*^9, 
   3.803736533353253*^9}, 3.8037366352180643`*^9, 3.803736722654442*^9, {
   3.803736784660934*^9, 3.803736828763345*^9}, 3.803736863750496*^9, {
   3.80373693360419*^9, 3.803736950613255*^9}, 3.803736982846328*^9, 
   3.803737372884038*^9, 3.803740906955192*^9, 3.803740962162786*^9, 
   3.803752329709807*^9, 3.803752601565238*^9, 3.803752648003056*^9, 
   3.8037527785936613`*^9, 3.803752931371305*^9, 3.803763144325306*^9, 
   3.803763261213274*^9, 3.803763317773046*^9, 3.803764158091695*^9, 
   3.803764728411592*^9, 3.803769069520632*^9, 3.803769108947997*^9, 
   3.803769361159233*^9, 3.803847910880508*^9, 3.803848064637438*^9, 
   3.8038481159828053`*^9, 3.803848157631599*^9, 3.8038482131230593`*^9, 
   3.803937309936986*^9, 3.8040266045542507`*^9, 3.804108567419468*^9, {
   3.804108699277371*^9, 3.804108748309621*^9}, {3.804109889274341*^9, 
   3.804109898858755*^9}, {3.804193700658987*^9, 3.804193712281592*^9}, 
   3.804193790342588*^9, 3.804368113658361*^9, 3.804452591403783*^9, 
   3.8044528052713614`*^9, 3.804452971298677*^9, 3.804453078691062*^9, 
   3.804453216332445*^9, 3.8045444465916853`*^9, 3.804715170637471*^9, 
   3.804715241387738*^9, 3.804715312613604*^9, 3.804717507244824*^9, 
   3.80471763692085*^9, 3.804800238197377*^9, 3.804853877401217*^9, 
   3.8048605971502666`*^9, 3.804884637180581*^9, 3.804884684032073*^9, 
   3.804963253925371*^9, 3.804966600479681*^9, 3.804967289962377*^9, 
   3.80496824229493*^9, 3.804970995626523*^9, 3.8050320736910954`*^9, 
   3.805049872456955*^9, 3.805145181519505*^9, 3.805145667690352*^9, 
   3.805145866207296*^9, 3.805146055836748*^9, 3.805201944562419*^9, 
   3.805232586293619*^9, 3.805232776406262*^9, 3.805317706837775*^9, 
   3.8053184879978123`*^9, 3.8053185706273537`*^9, 3.805319461610642*^9, 
   3.8053195672673693`*^9, 3.805402876764868*^9, 3.8054034120387983`*^9, 
   3.8054917391766863`*^9, 3.8055787166294727`*^9, 3.80563903963715*^9, {
   3.8057259296528053`*^9, 3.8057259474245663`*^9}, 3.805726038351343*^9, 
   3.8057268078078117`*^9, 3.805735872354117*^9, 3.805750055925503*^9, 
   3.805750109029882*^9, 3.805750381818185*^9, 3.805808355592061*^9, 
   3.805811139018689*^9, 3.805838879230769*^9, 3.8059209571518393`*^9, {
   3.806072152604855*^9, 3.806072166209917*^9}, 3.806072228696726*^9, 
   3.806072611284976*^9, 3.806072826787101*^9, 3.806175571787541*^9, 
   3.806183943606696*^9, 3.806184013524786*^9, 3.806353339200959*^9, 
   3.806353701334045*^9, 3.806441735386765*^9, 3.806441861797269*^9, 
   3.80644214575375*^9, 3.806699644590127*^9, 3.806699776791752*^9, 
   3.8067013030841303`*^9, 3.806701408400619*^9, 3.806772451300345*^9, 
   3.806872056403091*^9, 3.806872171067964*^9, 3.807006759102865*^9, 
   3.807006915625461*^9, 3.807131387431198*^9, 3.8073894351799*^9, 
   3.8073896393429823`*^9, 3.807562316178154*^9, 3.807651543488595*^9, 
   3.8077387510420103`*^9, 3.8077389672959337`*^9, 3.80790301902052*^9, 
   3.808082947897414*^9, 3.808222343273402*^9, 3.80822396368147*^9, 
   3.8084293500142*^9, 3.808602235735402*^9, 3.808651510032804*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"be04f09d-bb49-4913-9005-51c50c081ac0"]
}, Open  ]],

Cell["Dead number factor proportions", "Text",
 CellChangeTimes->{{3.80581062409221*^9, 
  3.805810656038106*^9}},ExpressionUUID->"35633aee-4f7f-4542-97b1-\
9dc32916325c"],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["65200.0", "34730"]], "Input",
 CellChangeTimes->{{3.803567166582449*^9, 3.80356720377124*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"5a44b9f2-6da5-4e70-8ce7-a7fcd1bad1f1"],

Cell[BoxData["1.8773394759573856`"], "Output",
 CellChangeTimes->{{3.80356720104384*^9, 3.803567204243026*^9}, 
   3.803567716584922*^9, 3.8035677657000523`*^9, 3.803571467684334*^9, 
   3.803571523939139*^9, 3.803571605640923*^9, 3.803591522408287*^9, 
   3.803664652266719*^9, 3.8036654202812233`*^9, 3.803665557099119*^9, 
   3.803666483800106*^9, 3.803667561636002*^9, 3.803735732503847*^9, 
   3.80373598469175*^9, 3.803736445845504*^9, 3.8037365236002493`*^9, 
   3.803736636827208*^9, 3.803736815321619*^9, 3.803740907381756*^9, 
   3.803763144842679*^9, 3.803763261685876*^9, 3.803763318152471*^9, 
   3.803764158654696*^9, 3.803764729116733*^9, 3.8037690700681543`*^9, 
   3.803769109448126*^9, 3.803769361677635*^9, 3.803847911317321*^9, 
   3.803848065024081*^9, 3.8038481163982067`*^9, 3.803848213666806*^9, 
   3.803937310226712*^9, 3.804026604931548*^9, 3.80410856786101*^9, 
   3.804109889608891*^9, 3.8041937010882072`*^9, 3.8041937906442204`*^9, 
   3.804368114197238*^9, 3.804452591842368*^9, 3.804452805494588*^9, 
   3.80445297182156*^9, 3.804453079009714*^9, 3.8044532169761753`*^9, 
   3.804544447342304*^9, 3.804715171089375*^9, 3.804715241711268*^9, 
   3.804717507769641*^9, 3.804800238921031*^9, 3.8048538790574293`*^9, 
   3.804860597686656*^9, 3.804884637665021*^9, 3.804963254271487*^9, 
   3.80496660077378*^9, 3.804967290315296*^9, 3.804970996011671*^9, 
   3.805032074142584*^9, 3.8050498729931383`*^9, 3.80514518188207*^9, 
   3.8051456680612783`*^9, 3.805145866578497*^9, 3.805146056129793*^9, 
   3.805201945337042*^9, 3.805232586737088*^9, 3.805232776489463*^9, 
   3.805317711843791*^9, 3.805318488280694*^9, 3.805318571113187*^9, 
   3.8053194619151278`*^9, 3.8053195675537033`*^9, 3.805402877150983*^9, 
   3.805403412327826*^9, 3.805491739547936*^9, 3.80557871706279*^9, 
   3.8056390397188253`*^9, {3.805725929952422*^9, 3.805725947707383*^9}, 
   3.805726038632708*^9, 3.805735872673484*^9, 3.805750056447144*^9, 
   3.805750110060566*^9, 3.805750382165739*^9, 3.805808356153837*^9, 
   3.805811139059249*^9, 3.8058388792909613`*^9, 3.8059209572740192`*^9, {
   3.80607215267384*^9, 3.8060721662628736`*^9}, 3.806072228949456*^9, 
   3.806072611350456*^9, 3.8060728270425673`*^9, 3.806175571844717*^9, 
   3.806183943814443*^9, 3.806184013790764*^9, 3.8063533448890953`*^9, 
   3.806353701668303*^9, 3.806441735768732*^9, 3.8064418621025553`*^9, 
   3.8064421460687532`*^9, 3.8066996450182533`*^9, 3.8066997770885363`*^9, 
   3.806701303405325*^9, 3.80670140880468*^9, 3.806772451670211*^9, 
   3.8068720568080387`*^9, 3.8068721715089607`*^9, 3.807006759519597*^9, 
   3.807006915933914*^9, 3.8071313878110847`*^9, 3.8073894355575047`*^9, 
   3.807389639715477*^9, 3.807562316673809*^9, 3.807651543888179*^9, 
   3.807738751413583*^9, 3.807738967704636*^9, 3.80790301942859*^9, 
   3.808082948258027*^9, 3.808222343584147*^9, 3.808223964078106*^9, 
   3.8084293503841343`*^9, 3.8086022361258593`*^9, 3.808651510530953*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"193a7c4f-e203-407b-a7c3-32387856d27e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["38200.0", "35006"]], "Input",
 CellChangeTimes->{{3.8036666943435287`*^9, 3.8036667044527683`*^9}, {
  3.803667038924336*^9, 3.803667044035432*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"c7ca852b-3773-41ae-9360-54fb2dbec75f"],

Cell[BoxData["1.091241501456893`"], "Output",
 CellChangeTimes->{
  3.8036667051356153`*^9, 3.80366704491006*^9, 3.803667561768231*^9, 
   3.80373573271229*^9, 3.803735985024436*^9, 3.803736446096517*^9, 
   3.803736523749875*^9, 3.803736636936965*^9, 3.8037368154531116`*^9, 
   3.803740907532785*^9, 3.803763145015234*^9, 3.803763261891163*^9, 
   3.803763318268875*^9, 3.8037641588232603`*^9, 3.803764729484844*^9, 
   3.8037690704476347`*^9, 3.803769109768553*^9, 3.803769362230713*^9, 
   3.803847911567936*^9, 3.803848065259584*^9, 3.8038481168149548`*^9, 
   3.8038482140147867`*^9, 3.803937310399892*^9, 3.804026605226061*^9, 
   3.804108568277272*^9, 3.8041098898782387`*^9, 3.8041937015574493`*^9, 
   3.804193790876053*^9, 3.804368116073361*^9, 3.804452592269245*^9, 
   3.8044528059574623`*^9, 3.804452972205576*^9, 3.804453079661004*^9, 
   3.804453217161086*^9, 3.8045444476900167`*^9, 3.8047151715090227`*^9, 
   3.8047152419985847`*^9, 3.80471750903542*^9, 3.804800239273493*^9, 
   3.804853881009383*^9, 3.8048605979801483`*^9, 3.8048846382726917`*^9, 
   3.804963254568735*^9, 3.8049666009395*^9, 3.804967290631619*^9, 
   3.8049709964135447`*^9, 3.805032074483324*^9, 3.805049873297027*^9, 
   3.8051451822138987`*^9, 3.8051456684310303`*^9, 3.8051458668961678`*^9, 
   3.80514605636335*^9, 3.805201945807294*^9, 3.8052325871995296`*^9, 
   3.8052327767574472`*^9, 3.805317712430964*^9, 3.805318488674679*^9, 
   3.805318571631353*^9, 3.805319462220793*^9, 3.805319567871375*^9, 
   3.805402877591119*^9, 3.805403412583984*^9, 3.805491741091083*^9, 
   3.805578717487998*^9, 3.805639039970648*^9, {3.805725930244685*^9, 
   3.805725948003159*^9}, 3.805726038850099*^9, 3.805735873029524*^9, 
   3.8057500570659523`*^9, 3.805750112759459*^9, 3.805750382461998*^9, 
   3.805808356387804*^9, 3.805811139109969*^9, 3.805838879318843*^9, 
   3.80592095736786*^9, {3.806072152741469*^9, 3.806072166571733*^9}, 
   3.806072229050374*^9, 3.806072611399127*^9, 3.80607282706714*^9, 
   3.806175571888267*^9, 3.806183944031837*^9, 3.806184013914299*^9, 
   3.806353345094198*^9, 3.806353701786333*^9, 3.806441735957985*^9, 
   3.806441862169244*^9, 3.80644214618567*^9, 3.806699645251652*^9, 
   3.8066997771568527`*^9, 3.806701303489058*^9, 3.8067014089947863`*^9, 
   3.806772451750134*^9, 3.8068720569918947`*^9, 3.806872171675552*^9, 
   3.807006759598115*^9, 3.8070069160017853`*^9, 3.807131387943866*^9, 
   3.8073894357293262`*^9, 3.807389639844719*^9, 3.807562316783387*^9, 
   3.807651544072742*^9, 3.8077387515471783`*^9, 3.807738967802855*^9, 
   3.807903019645732*^9, 3.8080829484086437`*^9, 3.8082223436678047`*^9, 
   3.808223964258552*^9, 3.8084293505337*^9, 3.808602236280376*^9, 
   3.808651510652807*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"024df1c0-5d1f-4fe2-ad32-ac1ace541735"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.0 MILLIONS", "Title",
 CellChangeTimes->{{3.80496640979391*^9, 3.8049664455787582`*^9}, {
   3.804966507973947*^9, 3.804966534337294*^9}, 3.8057505189700603`*^9, {
   3.805810887323379*^9, 3.805810895097776*^9}, {3.805811021164616*^9, 
   3.805811028289117*^9}},
 Background->RGBColor[
  0.94, 0.88, 0.94],ExpressionUUID->"3a4f85a9-3112-4ffc-aacb-138b5d2d4208"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", "=", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          StyleBox[
           RowBox[{"(*", " ", "SUSCEPTIBLE", "*)"}],
           FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->GrayLevel[0]], 
          RowBox[{
           StyleBox[
            RowBox[{
             RowBox[{
              RowBox[{"S", "'"}], "[", "t", "]"}], "\[Equal]", 
             RowBox[{
              RowBox[{"\[Mu]", "*", 
               RowBox[{"S", "[", "t", "]"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"kv", "+", " ", 
                 RowBox[{"ke", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Ex", "[", "t", "]"}]}], "+", 
                 RowBox[{"ki", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Inf", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"S", "[", "t", "]"}]}]}]}],
            FontColor->GrayLevel[0]], 
           StyleBox[",",
            FontColor->GrayLevel[0]], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0.5, 0]], 
           StyleBox[
            RowBox[{"(*", "EXPOSED", "*)"}],
            FontColor->RGBColor[1, 0, 1]], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0, 1],
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{
            StyleBox[
             RowBox[{
              RowBox[{"Ex", "'"}], "[", "t", "]"}],
             FontColor->GrayLevel[0]], 
            StyleBox["\[Equal]",
             FontColor->GrayLevel[0]], 
            RowBox[{
             StyleBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{"kv", "+", " ", 
                 RowBox[{"ke", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Ex", "[", "t", "]"}]}], "+", 
                 RowBox[{"ki", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"\[CapitalDelta]ki", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tic"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kf2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tf2"}], "]"}]}], "-", 
                    RowBox[{"\[CapitalDelta]kds2", "*", 
                    RowBox[{"HeavisideTheta", "[", 
                    RowBox[{"t", "-", "tds2"}], "]"}]}]}], ")"}], "*", 
                  RowBox[{"Inf", "[", "t", "]"}]}]}], ")"}], "*", 
               RowBox[{"S", "[", "t", "]"}]}],
              FontColor->GrayLevel[0]], 
             StyleBox["-",
              FontColor->GrayLevel[0]], 
             RowBox[{
              RowBox[{
               StyleBox["(",
                FontColor->GrayLevel[0]], 
               RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "*", 
              RowBox[{"Ex", "[", "t", "]"}]}]}]}], ",", 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{"(*", " ", "INFECTED", "*)"}], 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{
            RowBox[{
             RowBox[{"Inf", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Alpha]", "*", 
              RowBox[{"Ex", "[", "t", "]"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Gamma]", "*", "r"}], "+", 
                RowBox[{"\[Delta]", "*", "g"}], "+", 
                RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
              RowBox[{"Inf", "[", "t", "]"}]}]}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "ACTIVE", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"A", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Epsilon]", "*", "a", "*", 
              RowBox[{"Inf", "[", "t", "]"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Delta]", "*", 
                 StyleBox["p",
                  FontColor->RGBColor[1, 0, 0]]}], 
                StyleBox["+",
                 FontColor->RGBColor[1, 0, 0]], 
                RowBox[{"\[Gamma]", "*", 
                 StyleBox[
                  RowBox[{"(", 
                   RowBox[{"1", "-", "p"}], ")"}],
                  FontColor->RGBColor[1, 0, 0]]}]}], ")"}], "*", 
              RowBox[{"A", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
           
           RowBox[{"(*", " ", "RECOVERED", " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"R", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
            RowBox[{
             RowBox[{"\[Beta]", "*", 
              RowBox[{"Ex", "[", "t", "]"}]}], "+", 
             RowBox[{"\[Gamma]", "*", 
              StyleBox["r",
               FontColor->RGBColor[1, 0, 0]], 
              StyleBox["*",
               FontColor->RGBColor[1, 0, 0]], 
              RowBox[{"Inf", "[", "t", "]"}]}], "+", 
             RowBox[{"\[Gamma]", "*", 
              StyleBox[
               RowBox[{"(", 
                RowBox[{"1", "-", "p"}], ")"}],
               FontColor->RGBColor[1, 0, 0]], "*", 
              RowBox[{"A", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", " ", "DEAD", " ", "*)"}], 
           StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[1, 0.5, 0]], 
           RowBox[{
            RowBox[{
             RowBox[{"d", "'"}], "[", "t", "]"}], "\[Equal]", 
            RowBox[{"\[Delta]", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"g", "*", 
                RowBox[{"Inf", "[", "t", "]"}]}], "+", 
               RowBox[{
                StyleBox["p",
                 FontColor->RGBColor[1, 0, 0]], "*", " ", 
                RowBox[{"A", "[", "t", "]"}]}]}], ")"}]}]}], ",", " ", 
           RowBox[{"(*", 
            RowBox[{
            "0.1", " ", "pq", " ", "es", " ", "el", " ", "10", " ", "por", 
             " ", "ciento", " ", "de", " ", "los", " ", "infectados"}], 
            "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
           StyleBox["\[IndentingNewLine]",
            Background->RGBColor[0.87, 0.94, 1]], 
           RowBox[{"(*", " ", 
            RowBox[{"INITIAL", " ", "CONDITIONS"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"S", "[", "0", "]"}], "\[Equal]", "PM"}], ",", 
           RowBox[{
            RowBox[{"Ex", "[", "0", "]"}], "\[Equal]", "0"}], ",", " ", 
           RowBox[{
            RowBox[{"Inf", "[", "0", "]"}], "\[Equal]", "3"}], ",", 
           RowBox[{
            RowBox[{"A", "[", "0", "]"}], "\[Equal]", "0.0"}], ",", 
           RowBox[{
            RowBox[{"R", "[", "0", "]"}], "\[Equal]", "0.0"}], ",", 
           RowBox[{
            RowBox[{"d", "[", "0", "]"}], "\[Equal]", "0.0"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"S", ",", "Ex", ",", "Inf", ",", "A", ",", "R", ",", "d"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
         RowBox[{"Method", "\[Rule]", "\"\<StiffnessSwitching\>\""}], ",", 
         RowBox[{"AccuracyGoal", "\[Rule]", "7"}], ",", 
         RowBox[{"PrecisionGoal", "\[Rule]", "6"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"REPRESENTATION", " ", "AND", " ", "PLOTS"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Grid", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"QQ13", "=", 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{
              StyleBox["Plot",
               FontColor->RGBColor[1, 0.5, 0]], 
              StyleBox["[",
               FontColor->RGBColor[1, 0.5, 0]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox["[",
                 FontColor->RGBColor[1, 0.5, 0]], 
                RowBox[{
                 RowBox[{
                  StyleBox["{",
                   FontColor->RGBColor[1, 0.5, 0]], 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Inf", "[", "t", "]"}], ";", 
                    StyleBox[
                    RowBox[{"Ex", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[";",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[
                    RowBox[{"R", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]]}], 
                   StyleBox[",",
                    FontColor->RGBColor[1, 0.5, 0]], 
                   StyleBox[
                    RowBox[{"d", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], ",", 
                   RowBox[{
                    RowBox[{"A", "[", "t", "]"}], ";", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"R", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox["+",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox[
                    RowBox[{"d", "[", "t", "]"}],
                    FontColor->RGBColor[1, 0.5, 0]], 
                    StyleBox["+",
                    FontColor->RGBColor[1, 0.5, 0]], 
                    RowBox[{"A", "[", "t", "]"}]}]}]}], 
                  StyleBox["}",
                   FontColor->RGBColor[1, 0.5, 0]]}], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[" ",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\t",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "\"\<Inf[t]\>\"", ";", "\"\<Ex[t]\>\"", ";", 
                    "\"\<R[t]\>\""}], ",", "\"\<d[t]\>\"", ",", 
                   "\"\<A[t]\>\"", ",", "\"\<R[t]+d[t]+A[t]\>\""}], "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[" ",
                FontColor->RGBColor[1, 0.5, 0]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"5", ",", "tshow"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "cota"}], "}"}]}], "}"}],
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"Thickness", "[", ".004725", "]"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "6", ",", "6"}], "}"}], "]"}]}], "}"}], 
                    ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Green", "[", "1.5", "]"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "15"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0047251", "]"}]}], "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ",", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Cyan", ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Green", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"8", ",", "12"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               RowBox[{
                StyleBox["GridLines",
                 FontColor->RGBColor[1, 0.5, 0]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0.5, 0]], "None"}], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dotted", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"PlotRange", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"0.7", "*", "tmax"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "10000"}], "}"}]}], "}"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "None"}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FillingStyle", "->", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.1", "]"}], ",", "Blue"}], 
                  "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[",",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[1, 0.5, 0]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[1, 0.5, 0]]}], 
              StyleBox["]",
               FontColor->RGBColor[1, 0.5, 0]]}], 
             StyleBox[",",
              FontColor->RGBColor[1, 0.5, 0]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[1, 0.5, 0]], 
             RowBox[{"DateListPlot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "DatosFallecidos", ",", "DatosRecuperados", ",", 
                 "DatosAcumulados"}], "}"}], ",", 
               RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotTheme",
                 FontColor->RGBColor[1, 0, 0]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Bussiness\>\"", ",", "\"\<OpenMarkersThick\>\""}], 
                  "}"}],
                 FontColor->RGBColor[0, 0, 1]]}]}], "]"}]}], "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           StyleBox["Plot",
            FontColor->RGBColor[1, 0, 0]], 
           StyleBox["[",
            FontColor->RGBColor[1, 0, 0]], 
           RowBox[{
            RowBox[{
             StyleBox["Evaluate",
              FontColor->RGBColor[1, 0, 0]], 
             StyleBox["[",
              FontColor->RGBColor[0, 0, 1]], 
             RowBox[{
              RowBox[{
               StyleBox["{",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox[
                 RowBox[{"Inf", "[", "t", "]"}],
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[",",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox[
                 RowBox[{"Ex", "[", "t", "]"}],
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox["}",
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["/.",
               FontColor->RGBColor[1, 0.5, 0]], 
              StyleBox["s",
               FontColor->RGBColor[1, 0.5, 0]]}], 
             StyleBox["]",
              FontColor->RGBColor[1, 0.5, 0]]}], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[" ",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"{", 
              RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\t",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             StyleBox["PlotLegends",
              FontColor->RGBColor[1, 0, 0]], 
             StyleBox["\[Rule]",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox[
              RowBox[{"{", 
               RowBox[{
                RowBox[{"\"\<S\>\"", ";", "\"\<Inf\>\""}], ",", 
                "\"\<Ex\>\""}], "}"}],
              FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             StyleBox["PlotRange",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox["\[Rule]",
              FontColor->RGBColor[1, 0, 1]], 
             StyleBox["All",
              FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[",",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox[
             RowBox[{"ImageSize", "\[Rule]", "450"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", "Black", "}"}], ";", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Darker", "[", "Red", "]"}], 
                   RowBox[{"(*", 
                    RowBox[{"Blue", "[", "2", "]"}], "*)"}], ",", 
                   RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                   RowBox[{"Thickness", "[", ".00475", "]"}]}], "}"}]}], ",", 
                
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Green", "[", "1.5", "]"}], 
                  RowBox[{"(*", "Red", "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"4", ",", "6", ",", "4"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".004745", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Magenta", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                  RowBox[{"AbsoluteDashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", 
                  RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Black", 
                  RowBox[{"(*", 
                   RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", "DotDashed",
                   ",", 
                  RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], "}"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"Frame", "->", "True"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"GridLines", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", "130", "}"}], ",", "None"}], "}"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"GridLinesStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             FormBox[
              RowBox[{"\[IndentingNewLine]", 
               RowBox[{"FrameLabel", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"Text", "[", 
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<infection probability\>\"", ",", "30"}], 
                    "]"}], "]"}]}], "}"}]}]}],
              TraditionalForm],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FrameStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
               "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox["\[IndentingNewLine]",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FrameTicksStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{"Black", ",", "20"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"Filling", "\[Rule]", "Axis"}],
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[",",
             FontColor->RGBColor[1, 0, 0]], 
            StyleBox[
             RowBox[{"FillingStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
               RowBox[{
                RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], "]"}]}],
             FontColor->RGBColor[1, 0, 0]]}], 
           StyleBox["]",
            FontColor->RGBColor[1, 0, 0]]}]}], "}"}], ",", 
        RowBox[{
         StyleBox["{",
          FontColor->RGBColor[0, 0, 1]], " ", 
         RowBox[{
          RowBox[{"Q13", "=", 
           RowBox[{
            StyleBox["Show",
             FontColor->RGBColor[0, 0, 1]], 
            StyleBox["[",
             FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
             RowBox[{
              StyleBox["ListPlot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               StyleBox[
                RowBox[{"{", 
                 RowBox[{
                 "CasosACTIVOS", ",", "CasosPORdiaHOPKINS", ",", 
                  "CASOSporDIAresta"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotMarkers", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Automatic", ",", "12"}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "tshow"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "167800"}], "}"}]}], "}"}],
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"DIAMX", ",", "Red"}], "}"}], ",", "180"}], "}"}],
                    ",", 
                   RowBox[{"{", "}"}]}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}], 
             StyleBox[",",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox[
              RowBox[{"(*", "THEORETICAL", "*)"}],
              FontColor->RGBColor[0, 0, 1]], 
             StyleBox["\[IndentingNewLine]",
              FontColor->RGBColor[0, 0, 1]], 
             RowBox[{
              StyleBox["Plot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["[",
                 FontColor->RGBColor[0, 0, 1]], 
                RowBox[{
                 StyleBox[
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"A", "[", "t", "]"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Gamma]", "*", "r"}], "+", 
                    RowBox[{"\[Delta]", "*", "g"}], "+", 
                    RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", "t"}], "}"}]}], "]"}], "-", 
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", 
                    RowBox[{"t", "-", "1"}]}], "}"}]}], "]"}]}], ")"}]}]}], 
                   "}"}],
                  FontColor->RGBColor[0, 0, 1]], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\t",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\"\<S\>\"", ";", "\"\<A[t]\>\""}], ",", 
                   "\"\<Casos por d\[IAcute]a\>\""}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotRange", "\[Rule]", "Automatic"}],
                FontColor->RGBColor[1, 0, 1]], 
               RowBox[{
                StyleBox["(*",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox[
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", "370"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "25000"}], "}"}]}], "}"}],
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["*)",
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", "Black", "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Black", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    "DotDashed", ",", 
                    RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", "98", "}"}], ",", "None"}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FillingStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}]}], 
            StyleBox["]",
             FontColor->RGBColor[0, 0, 1]]}]}], 
          StyleBox[",",
           FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
           FontColor->RGBColor[0, 0, 1]], 
          RowBox[{
           StyleBox["D13",
            FontColor->RGBColor[0, 0, 1]], 
           StyleBox["=",
            FontColor->RGBColor[0, 0, 1]], 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{
              StyleBox["ListPlot",
               FontColor->RGBColor[0, 0, 1]], 
              StyleBox["[",
               FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
               StyleBox[
                RowBox[{"{", "CASOSporDIAresta", "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotMarkers",
                 FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[0, 0, 1]], 
                Graphics3DBox[
                 {GrayLevel[0], EdgeForm[None], Glow[
                   RGBColor[0, 
                    NCache[
                    Rational[2, 3], 0.6666666666666666], 0]], 
                  CuboidBox[{0, 0, 0}]},
                 Boxed->False,
                 ImageSize->{13.693338432432654`, 12.},
                 
                 ViewPoint->{0.17134623817277983`, 0.2733380173970694, 
                  3.3683715345711907`},
                 
                 ViewVertical->{-0.5474806517236538, 0.6107600623868774, 
                  0.5720463986263885}]}], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "tshow"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "12100"}], "}"}]}], "}"}]}], ",", 
               RowBox[{"AspectRatio", "\[Rule]", "1.63"}], ",", 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"DIAMX", ",", "Red"}], "}"}], "}"}], ",", 
                   RowBox[{"{", "}"}]}], "}"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<number of cases\>\"", ",", "30"}], "]"}], 
                    "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->RGBColor[0, 0, 1]]}], 
              StyleBox["]",
               FontColor->RGBColor[0, 0, 1]]}], 
             StyleBox[",",
              FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
             RowBox[{
              StyleBox["Plot",
               FontColor->GrayLevel[0]], 
              StyleBox["[",
               FontColor->GrayLevel[0]], 
              RowBox[{
               RowBox[{
                StyleBox["Evaluate",
                 FontColor->GrayLevel[0]], 
                StyleBox["[",
                 FontColor->GrayLevel[0]], 
                RowBox[{
                 StyleBox[
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"\[Gamma]", "*", "r"}], "+", 
                    RowBox[{"\[Delta]", "*", "g"}], "+", 
                    RowBox[{"\[Epsilon]", "*", "a"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", "t"}], "}"}]}], "]"}], "-", 
                    RowBox[{"NIntegrate", "[", 
                    RowBox[{
                    RowBox[{"Evaluate", "[", 
                    RowBox[{
                    RowBox[{"Inf", "[", "z", "]"}], "/.", "s"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"z", ",", "0", ",", 
                    RowBox[{"t", "-", "1"}]}], "}"}]}], "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"0.1", "*", 
                    RowBox[{"A", "[", "t", "]"}]}], ";"}]}], "}"}],
                  FontColor->GrayLevel[0]], 
                 StyleBox["/.",
                  FontColor->RGBColor[1, 0.5, 0]], 
                 StyleBox["s",
                  FontColor->RGBColor[1, 0.5, 0]]}], 
                StyleBox["]",
                 FontColor->RGBColor[1, 0.5, 0]]}], 
               StyleBox[
                RowBox[{"(*", 
                 RowBox[{"Evaluate", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ki", "*", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Inf", "[", "t", "]"}]}], "PM"]}], ",", 
                    RowBox[{"ke", "*", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"S", "[", "t", "]"}], "*", 
                    RowBox[{"Ex", "[", "t", "]"}]}], "PM"]}], ",", 
                    RowBox[{
                    FractionBox["1", "1000"], 
                    FractionBox[
                    RowBox[{"Ex", "[", "t", "]"}], 
                    RowBox[{"Inf", "[", "t", "]"}]]}]}], "}"}], "/.", "s"}], 
                  "]"}], "*)"}],
                FontColor->GrayLevel[0.5]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"{", 
                 RowBox[{"t", ",", "1", ",", "tmax"}], "}"}],
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[",",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox["\t",
                FontColor->RGBColor[0, 0, 1]], 
               StyleBox[
                RowBox[{"PlotLegends", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"\"\<S\>\"", ";", "\"\<casos diarios\>\""}], 
                  RowBox[{"(*", 
                   RowBox[{
                   "\"\<ki*\!\(\*FractionBox[\(S[t]*Inf[t]\), \(PM\)]\)\>\"", 
                    ",", "\"\<ke*\!\(\*FractionBox[\(S[t]*Ex[t]\), \
\(PM\)]\)\>\"", ",", 
                    "\"\<\!\(\*FractionBox[\(1\), \
\(1000\)]\)\!\(\*FractionBox[\(Ex[t]\), \(Inf[t]\)]\)\>\""}], "*)"}], "}"}]}],
                
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[" ",
                FontColor->GrayLevel[0]], 
               RowBox[{
                StyleBox["PlotRange",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["\[Rule]",
                 FontColor->RGBColor[1, 0, 1]], 
                StyleBox["Automatic",
                 FontColor->RGBColor[0, 0, 1]]}], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"AspectRatio", "\[Rule]", "1.3"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"ImageSize", "\[Rule]", "450"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", "Black", "}"}], ";", 
                    RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Red", ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "6", ",", "6"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".00751", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Magenta", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    RowBox[{"AbsoluteDashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", "10"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", ".0075", "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Black", 
                    RowBox[{"(*", 
                    RowBox[{"Green", "[", "2", "]"}], "*)"}], ",", 
                    "DotDashed", ",", 
                    RowBox[{"Thickness", "[", ".0045", "]"}]}], "}"}]}], 
                  "}"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"Frame", "->", "True"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"GridLines", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", "98", "}"}], ",", "None"}], "}"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"GridLinesStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Gray", ",", " ", "Dashed", ",", "Thin"}], "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                FormBox[
                 RowBox[{"\[IndentingNewLine]", 
                  RowBox[{"FrameLabel", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<day since first case\>\"", ",", "30"}], 
                    "]"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Text", "[", 
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<infection probability\>\"", ",", "30"}], 
                    "]"}], "]"}]}], "}"}]}]}],
                 TraditionalForm],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FrameStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Thickness", "[", "0.0050", "]"}], ",", "Black"}], 
                  "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox["\[IndentingNewLine]",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FrameTicksStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{"Black", ",", "20"}], "]"}]}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"Filling", "\[Rule]", "Axis"}],
                FontColor->GrayLevel[0]], 
               StyleBox[",",
                FontColor->GrayLevel[0]], 
               StyleBox[
                RowBox[{"FillingStyle", "\[Rule]", 
                 RowBox[{"Directive", "[", 
                  RowBox[{
                   RowBox[{"Opacity", "[", "0.0", "]"}], ",", "Yellow"}], 
                  "]"}]}],
                FontColor->GrayLevel[0]]}], 
              StyleBox["]",
               FontColor->GrayLevel[0]]}]}], "\[IndentingNewLine]", "]"}]}]}], 
         StyleBox["\[IndentingNewLine]",
          FontColor->RGBColor[0, 0, 1]], 
         StyleBox["}",
          FontColor->RGBColor[0, 0, 1]]}]}], 
       StyleBox["}",
        FontColor->RGBColor[0, 0, 1]]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<PLOT BOUND\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cota", ",", "3900000", ",", "\"\<cota\>\""}], "}"}], ",", "5", 
     ",", "9390000"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<MAXIMAL TIME\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmax", ",", "tshow", ",", "\"\<tmax\>\""}], "}"}], ",", "10", 
     ",", "16000"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<SHOW TIME\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tshow", ",", "579", ",", "\"\<tshow\>\""}], "}"}], ",", "10", 
     ",", "1600"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<HOUSE CONFINEMENT START\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tic", ",", "23", ",", "\"\<tic\>\""}], "}"}], ",", "10", ",", 
     "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<ECONOMIC PRESSURE INATTENTION\>\"", ",", "12", ",", "Bold"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tds2", ",", "51", ",", "\"\<tds2\>\""}], "}"}], ",", "30", ",",
      "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<END-DOWN HOME CONFINEMENT\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tf2", ",", "90", ",", "\"\<tf2\>\""}], "}"}], ",", "30", ",", 
     "200"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<INFECTION RATE DECREASE AT ti\>\"", ",", "12", ",", "Bold"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]ki", ",", "0.25", 
       RowBox[{"(*", 
        RowBox[{"de", " ", "uno", " ", "solo", " ", "es", " ", "0.41"}], 
        "*)"}], ",", "\"\<\[CapitalDelta]ki\>\""}], "}"}], ",", "0", ",", 
     "2"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<INFECTION RATE INCREASE AT tds2\>\"", ",", "12", ",", "Bold"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]kds2", ",", "0.23", ",", 
       "\"\<\[CapitalDelta]kds2\>\""}], "}"}], ",", "0", ",", "2"}], "}"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<INFECTION RATE INCREASE AT HC END at tf2\>\"", ",", "12", ",", 
     "Bold"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[CapitalDelta]kf2", ",", "0.0", ",", "\"\<\[CapitalDelta]kf2\>\""}], 
      "}"}], ",", "0", ",", "50"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"PARAMETERS", " ", "SUSCEPTIBLE"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"SUSCEPTIBLE\",FontColor->GrayLevel[0]]\)\>\"", ",", 
     "12", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Mu]", ",", "0", ",", "\"\<\[Mu]\>\""}], "}"}], ",", "0.0", 
     ",", "0.0000006"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"PM", ",", 
       RowBox[{"(*", 
        RowBox[{"1860", "*", 
         SuperscriptBox["10", "3"]}], "*)"}], 
       RowBox[{"3000", "*", 
        SuperscriptBox["10", "3"]}], ",", "\"\<PM\>\""}], "}"}], ",", "100", 
     ",", 
     RowBox[{"130", "*", 
      SuperscriptBox["10", "5"]}]}], "}"}], ",", " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "THE", " ", "ESTIMATION", " ", "OF", " ", "THE", " ", "NUMBER", " ", 
      "OF", " ", "SUSCEPTIBLE", " ", "INDIVIDUALS"}], ",", " ", 
     RowBox[{"1.5", " ", "million"}], ",", " ", 
     RowBox[{"1.0", " ", "million"}], ",", " ", 
     RowBox[{"0.85", " ", "million"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"kv", ",", "0.000031", ",", "\"\<kv\>\""}], "}"}], ",", 
     "0.0000001", ",", "0.51"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ke", ",", 
       RowBox[{"5.66", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"7.7", "*", 
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]]}], "-", 
         RowBox[{"1.3", "millones"}]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"0.905", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "7"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"7.6", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"6.6", "*", 
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]]}], "-", 
         RowBox[{"1.5", "millones"}]}], "*)"}], ",", 
       "\"\<\!\(\*StyleBox[\"ke\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.00", ",", "0.00001"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ki", ",", 
       RowBox[{"0.950", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}], 
       RowBox[{"(*", 
        RowBox[{"6.5", "*", 
         RowBox[{
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]], "--"}], "1.3", "millones"}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"1.0", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "7"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{"7.6", "*", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], "*)"}], 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"5.4", "*", 
          SuperscriptBox["10", 
           RowBox[{"-", "8"}]]}], "-", 
         RowBox[{"1.5", "millones"}]}], "*)"}], ",", 
       "\"\<\!\(\*StyleBox[\"ki\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.00", ",", "0.00001"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"13", "Million"}], ":", " ", "ke"}], " ", "=", " ", 
      RowBox[{"7.7", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"6.5", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"kv", "=", "0.000009"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"5", "Million"}], ":", " ", "ke"}], " ", "=", " ", 
      RowBox[{"2.66", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"6.2", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"kv", "=", "0.000031"}], ",", " ", 
     RowBox[{"\[CapitalDelta]ki", "=", "0.25"}], ",", " ", 
     RowBox[{"\[CapitalDelta]kds2", "=", "0.23"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"3", "Million"}], ":", " ", "ke"}], " ", "=", " ", 
      RowBox[{"5.66", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"0.950", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}], ",", " ", 
     RowBox[{"kv", "=", "0.000031"}], ",", " ", 
     RowBox[{"\[CapitalDelta]ki", "=", "0.25"}], ",", " ", 
     RowBox[{"\[CapitalDelta]kds2", "=", "0.23"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"1.5", "Million"}], ":", " ", "ke"}], " ", "=", " ", 
      RowBox[{"11.62", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"15.50", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"1.0", 
        RowBox[{"Million", ":", " ", "ke"}]}]}], " ", "=", " ", 
      RowBox[{"1.105", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"0.94", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Fit", ":", " ", 
       RowBox[{"0.85", 
        RowBox[{"Million", ":", " ", "ke"}]}]}], " ", "=", " ", 
      RowBox[{"1.46", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}], ",", " ", 
     RowBox[{"ki", " ", "=", " ", 
      RowBox[{"1.0", "*", 
       SuperscriptBox["10", 
        RowBox[{"-", "7"}]]}]}]}], "*)"}], "\[IndentingNewLine]", "Delimiter",
    ",", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"PARAMETERS", " ", "EXPOSED"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<\!\(\*StyleBox[\"EXPOSED\",FontColor->RGBColor[1, 0, 0]]\)\>\"", ",",
      "12", ",", "Bold"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "0.07", ",", "\"\<\[Alpha]\>\""}], "}"}], ",", 
     "0.0001", ",", "0.56"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Beta]", ",", "0.0", ",", "\"\<\[Beta]\>\""}], "}"}], ",", 
     "0.0", ",", "0.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Epsilon]", ",", "0.07", ",", "\"\<\[Epsilon]\>\""}], "}"}], 
     ",", "0.0", ",", "0.52"}], "}"}], ",", "Delimiter", ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"PARAMETROS", " ", "INFECTED"}], ",", " ", 
     RowBox[{"RECOVERED", " ", "AND", " ", "DEAD"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
    "\"\<PARAMETERS \!\(\*StyleBox[\"I\",FontColor->GrayLevel[0.5]]\), R AND \
D\>\"", ",", "12", ",", "Bold"}], "]"}], ",", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<a+r+g=1\>\"", ",", "12", ",", "Bold"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "0.15", ",", "\"\<a\>\""}], "}"}], ",", "0.001", ",", 
     "0.61"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", "0.79", ",", "\"\<r\>\""}], "}"}], ",", "0.001", ",", 
     "1.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", ",", "0.06", ",", "\"\<g\>\""}], "}"}], ",", "0.001", ",", 
     "0.61"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Fit", " ", "1"}], ":", " ", 
       RowBox[{
       "all", " ", "difference", " ", "is", " ", "passed", " ", "to", " ", 
        "deaths", " ", "a"}]}], "=", "0.1"}], ",", " ", 
     RowBox[{"r", "=", "0.79"}], ",", " ", 
     RowBox[{"g", "=", "0.11"}], ",", " ", 
     RowBox[{"no", " ", "fit", " ", "of", " ", "active", " ", "data"}]}], 
    "*)"}], "\t", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Fit", " ", "2"}], ":", " ", 
       RowBox[{
       "the", " ", "difference", " ", "is", " ", "divided", " ", "between", 
        " ", "deaths", " ", "and", " ", "active", " ", "a"}]}], "=", "0.15"}],
      ",", " ", 
     RowBox[{"r", "=", "0.79"}], ",", " ", 
     RowBox[{"g", "=", "0.06"}], ",", " ", 
     RowBox[{"fits", " ", "active", " ", "data"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Gamma]", ",", "0.015", ",", "\"\<\[Gamma]\>\""}], "}"}], ",", 
     RowBox[{"7.6", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "9"}]]}], ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Delta]", ",", "0.038", ",", "\"\<\[Delta]\>\""}], "}"}], ",", 
     RowBox[{"7.6", "*", 
      SuperscriptBox["10", 
       RowBox[{"-", "9"}]]}], ",", "0.16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["p",
        FontColor->GrayLevel[0]], ",", "0.094", ",", 
       "\"\<\!\(\*StyleBox[\"p\",FontColor->GrayLevel[0]]\)\>\""}], "}"}], 
     ",", "0.001", ",", "1.03"}], "}"}], ",", "Delimiter"}], "]"}]], "Input",
 CellChangeTimes->{{3.711729954340054*^9, 3.711729956324499*^9}, {
   3.711738971008939*^9, 3.711739003865344*^9}, {3.711739071037417*^9, 
   3.711739073781252*^9}, {3.712164671563403*^9, 3.7121647245927362`*^9}, {
   3.7121649553407907`*^9, 3.712164982647224*^9}, {3.712165387900572*^9, 
   3.712165388235567*^9}, {3.7121658711976223`*^9, 3.712165881043228*^9}, {
   3.712166061448382*^9, 3.712166151474473*^9}, {3.712274099753539*^9, 
   3.712274130071575*^9}, {3.712274280570286*^9, 3.712274331045611*^9}, {
   3.712274382535644*^9, 3.712274401902049*^9}, {3.713737129072657*^9, 
   3.713737166582645*^9}, {3.713737260799563*^9, 3.713737388466825*^9}, {
   3.713737454428985*^9, 3.7137374906047*^9}, {3.713737566576869*^9, 
   3.7137376029806433`*^9}, {3.713737658956127*^9, 3.713737669348387*^9}, {
   3.713738122417261*^9, 3.713738213406781*^9}, {3.713738363109664*^9, 
   3.713738376556579*^9}, {3.714077117026526*^9, 3.714077215134033*^9}, {
   3.714077270680789*^9, 3.714077288521551*^9}, {3.714077611146154*^9, 
   3.714077613892441*^9}, {3.714077748002359*^9, 3.714077786241764*^9}, {
   3.714077905595498*^9, 3.714077908897132*^9}, {3.714078543563571*^9, 
   3.714078554793433*^9}, {3.71407868294701*^9, 3.714078700083721*^9}, {
   3.714153549994382*^9, 3.7141535543193703`*^9}, {3.714153636150062*^9, 
   3.714153729234756*^9}, {3.7141538608724117`*^9, 3.7141538736245604`*^9}, {
   3.714154022538254*^9, 3.7141540755120077`*^9}, {3.714154213546674*^9, 
   3.714154214562076*^9}, {3.714154593540373*^9, 3.714154610274098*^9}, {
   3.714155228083674*^9, 3.7141552608320303`*^9}, {3.714155745380722*^9, 
   3.714155745485972*^9}, {3.7141557817788973`*^9, 3.714155785867587*^9}, {
   3.71415587815765*^9, 3.714155895192087*^9}, {3.7141559405292673`*^9, 
   3.714155955919264*^9}, {3.714156104670073*^9, 3.714156112073913*^9}, {
   3.7141562876058207`*^9, 3.7141563111267033`*^9}, {3.714156684779256*^9, 
   3.714156711074024*^9}, {3.714156760106388*^9, 3.714156798912208*^9}, {
   3.7141568351064167`*^9, 3.714156835324641*^9}, {3.714156962407461*^9, 
   3.714156967380425*^9}, {3.7141570136701612`*^9, 3.714157013845169*^9}, {
   3.7141573557611437`*^9, 3.7141573766467323`*^9}, {3.714157453862186*^9, 
   3.7141574715011587`*^9}, {3.71415752931112*^9, 3.714157549229629*^9}, {
   3.7142182106688547`*^9, 3.714218301450759*^9}, {3.714218720643467*^9, 
   3.7142187411565237`*^9}, {3.714218778588337*^9, 3.714218798530044*^9}, {
   3.714219061823141*^9, 3.714219062222157*^9}, {3.7142191073505173`*^9, 
   3.714219107748465*^9}, {3.71421916122999*^9, 3.714219184549033*^9}, {
   3.714220016628824*^9, 3.714220017491983*^9}, {3.714221875626923*^9, 
   3.714221875957148*^9}, {3.7142234934637003`*^9, 3.7142235922138147`*^9}, {
   3.714223658901909*^9, 3.714223689373168*^9}, {3.714223757116069*^9, 
   3.714223790667165*^9}, {3.7142238219221897`*^9, 3.7142238242659483`*^9}, {
   3.714224176109393*^9, 3.714224178484573*^9}, {3.714254957427874*^9, 
   3.714254990304831*^9}, {3.714255192399744*^9, 3.71425525692743*^9}, {
   3.7142558967880983`*^9, 3.7142560265826387`*^9}, {3.714480607780813*^9, 
   3.714480694764051*^9}, {3.7144816756794453`*^9, 3.714481705145686*^9}, {
   3.714481752207869*^9, 3.7144818923550997`*^9}, {3.7144819360517883`*^9, 
   3.7144822548085213`*^9}, {3.714482293945115*^9, 3.7144823155944967`*^9}, {
   3.7144823967523537`*^9, 3.71448240250736*^9}, {3.714482554835663*^9, 
   3.714482558973225*^9}, {3.714482591946042*^9, 3.714482632846595*^9}, {
   3.7144829762508917`*^9, 3.7144829767282887`*^9}, {3.714483335762742*^9, 
   3.714483338138266*^9}, {3.714483371050714*^9, 3.714483379709846*^9}, {
   3.7144835656192503`*^9, 3.714483584917036*^9}, {3.714483629367248*^9, 
   3.7144836685943832`*^9}, {3.714483763492577*^9, 3.714483812670677*^9}, {
   3.714483936705875*^9, 3.714483978240472*^9}, {3.714484016038878*^9, 
   3.714484036777749*^9}, {3.714484160784383*^9, 3.714484167464107*^9}, {
   3.714484265783801*^9, 3.714484286228016*^9}, {3.714484361896934*^9, 
   3.7144843643272142`*^9}, {3.714484619222576*^9, 3.714484656925007*^9}, {
   3.714484745111253*^9, 3.71448494340764*^9}, {3.714485121244102*^9, 
   3.714485284675353*^9}, {3.714485355583222*^9, 3.714485360863946*^9}, {
   3.714485833764636*^9, 3.71448587230623*^9}, {3.714486062143754*^9, 
   3.714486064403838*^9}, {3.7144861027240877`*^9, 3.714486118239365*^9}, {
   3.714486150266515*^9, 3.7144862013793364`*^9}, {3.714486390329928*^9, 
   3.714486390636106*^9}, {3.7144864572787533`*^9, 3.714486468900818*^9}, {
   3.714486526051447*^9, 3.7144865644872217`*^9}, {3.7144867818769293`*^9, 
   3.71448687388052*^9}, {3.7144869049769793`*^9, 3.7144869054731627`*^9}, {
   3.714487065468987*^9, 3.714487139819433*^9}, {3.714487183410347*^9, 
   3.71448738833537*^9}, {3.717349693320345*^9, 3.717349740453195*^9}, {
   3.717350079168056*^9, 3.717350086380246*^9}, {3.71845690929853*^9, 
   3.71845695398526*^9}, {3.7184572214710903`*^9, 3.718457222852251*^9}, {
   3.718816638664481*^9, 3.718816661542137*^9}, {3.718816800003872*^9, 
   3.718816865906147*^9}, {3.718817085865926*^9, 3.71881709162357*^9}, {
   3.718817176704772*^9, 3.718817270224373*^9}, {3.718817305763151*^9, 
   3.718817338336203*^9}, {3.718817370909346*^9, 3.718817387608567*^9}, {
   3.718817556716817*^9, 3.718817563675448*^9}, {3.7188331351875153`*^9, 
   3.718833582993123*^9}, {3.7188336605246277`*^9, 3.71883366642411*^9}, {
   3.718833795557376*^9, 3.7188338112253942`*^9}, {3.718833858783062*^9, 
   3.718833860507453*^9}, {3.718833938318581*^9, 3.718833993299055*^9}, {
   3.71883406564876*^9, 3.718834188554323*^9}, {3.718834340226613*^9, 
   3.7188343812737083`*^9}, {3.718834420356894*^9, 3.7188344223231564`*^9}, {
   3.718834458196169*^9, 3.718834580327383*^9}, {3.718834629078668*^9, 
   3.718834671951363*^9}, {3.718834811705233*^9, 3.71883481383969*^9}, {
   3.718835150774345*^9, 3.7188351982555532`*^9}, {3.718835291268371*^9, 
   3.718835298128435*^9}, {3.71883541892013*^9, 3.71883561316371*^9}, 
   3.718836177353386*^9, 3.7188363187304068`*^9, {3.7188372124374743`*^9, 
   3.71883721502043*^9}, 3.718920796592367*^9, {3.718921264274316*^9, 
   3.7189213106504717`*^9}, {3.718921727148834*^9, 3.718921770858821*^9}, {
   3.7189221315661488`*^9, 3.718922197028365*^9}, {3.718922284818552*^9, 
   3.718922329443248*^9}, {3.718923118932888*^9, 3.718923120772099*^9}, {
   3.795542833486764*^9, 3.7955428689584293`*^9}, {3.79554292552002*^9, 
   3.795542968561204*^9}, {3.795543050114479*^9, 3.795543121634713*^9}, {
   3.795543259490137*^9, 3.79554335328308*^9}, {3.7955434292288847`*^9, 
   3.7955434953754272`*^9}, {3.795543536550571*^9, 3.795543629443152*^9}, {
   3.7955436698698606`*^9, 3.7955437094943132`*^9}, {3.79554376062488*^9, 
   3.795543763574217*^9}, {3.795544091574581*^9, 3.795544181638977*^9}, {
   3.795544234105466*^9, 3.795544242376464*^9}, {3.7955442751855507`*^9, 
   3.7955443767703876`*^9}, {3.79554441525065*^9, 3.795544445418798*^9}, {
   3.795544481619906*^9, 3.795544737148284*^9}, {3.7955447830389547`*^9, 
   3.795544840901479*^9}, {3.795544880217484*^9, 3.795544943819026*^9}, {
   3.795544975865534*^9, 3.795545401715242*^9}, {3.795545442316824*^9, 
   3.795545545653615*^9}, {3.795545615465994*^9, 3.795545641856735*^9}, {
   3.795545806572172*^9, 3.7955458167863894`*^9}, {3.795545855026129*^9, 
   3.795545857301654*^9}, {3.795546016906817*^9, 3.795546020896883*^9}, {
   3.795546071523148*^9, 3.79554610355268*^9}, {3.795546149016691*^9, 
   3.795546149246221*^9}, {3.7955461803008957`*^9, 3.795546200161718*^9}, 
   3.7955463121976433`*^9, {3.79554639390663*^9, 3.795546484705008*^9}, {
   3.795546529562613*^9, 3.7955465576466427`*^9}, {3.795546623599684*^9, 
   3.7955467089033813`*^9}, {3.795546765817113*^9, 3.7955467745895567`*^9}, {
   3.795546804795845*^9, 3.7955468320431643`*^9}, {3.795547793519363*^9, 
   3.7955478434120903`*^9}, {3.79554906007896*^9, 3.795549068183605*^9}, {
   3.795549203657187*^9, 3.795549206627883*^9}, {3.795549314288898*^9, 
   3.795549366964684*^9}, 3.7955493999694977`*^9, {3.7955494796254063`*^9, 
   3.795549588248067*^9}, {3.795549626052507*^9, 3.795549671647861*^9}, {
   3.795549764337006*^9, 3.795549828495717*^9}, {3.795549889785903*^9, 
   3.795549959245913*^9}, {3.795549997418252*^9, 3.795550001665606*^9}, {
   3.7955500602511377`*^9, 3.795550096456211*^9}, {3.795550164870023*^9, 
   3.795550234078429*^9}, {3.795550274843696*^9, 3.795550287651503*^9}, {
   3.7955503188745613`*^9, 3.7955504671761637`*^9}, {3.795550500831319*^9, 
   3.795550501108577*^9}, {3.795550540770461*^9, 3.79555054106678*^9}, {
   3.795550642259984*^9, 3.795550696530199*^9}, {3.795550758856057*^9, 
   3.795550774570706*^9}, {3.795550839779332*^9, 3.795550867832979*^9}, {
   3.795550943571944*^9, 3.795550958371125*^9}, {3.7955513320814657`*^9, 
   3.7955513740830307`*^9}, {3.795551448524562*^9, 3.795551450610718*^9}, {
   3.7955515553295*^9, 3.795551556297287*^9}, {3.7955516013845243`*^9, 
   3.795551601838323*^9}, {3.7955516460941687`*^9, 3.795551671725256*^9}, {
   3.795551961421616*^9, 3.795551961736171*^9}, {3.795552291168591*^9, 
   3.7955522998775883`*^9}, {3.79555241213992*^9, 3.7955524512904243`*^9}, {
   3.7955524818950787`*^9, 3.795552482239216*^9}, {3.7955525224177*^9, 
   3.795552631029708*^9}, 3.795552666820373*^9, {3.795552772392921*^9, 
   3.7955527786726637`*^9}, {3.7955528956652412`*^9, 
   3.7955529051819363`*^9}, {3.7955529352005987`*^9, 3.7955529394172163`*^9}, 
   3.795552999243191*^9, {3.7955530372920237`*^9, 3.7955530488779497`*^9}, {
   3.795553082611936*^9, 3.795553089971964*^9}, {3.795619758878785*^9, 
   3.79561986744661*^9}, {3.7956201674531403`*^9, 3.795620291205554*^9}, {
   3.795621117321761*^9, 3.795621118054132*^9}, {3.79562116077145*^9, 
   3.7956211777577677`*^9}, {3.795621261114653*^9, 3.795621354689126*^9}, {
   3.795621425337575*^9, 3.7956214257403793`*^9}, {3.795621656777135*^9, 
   3.795621686537797*^9}, {3.795621746782164*^9, 3.795621759347026*^9}, {
   3.795621802584236*^9, 3.795621811032847*^9}, {3.7956218421093073`*^9, 
   3.795621842526598*^9}, {3.795621908343255*^9, 3.795621908747498*^9}, {
   3.795622025823073*^9, 3.795622038510187*^9}, {3.795622071711728*^9, 
   3.7956221001721363`*^9}, {3.795628535270376*^9, 3.795628577925654*^9}, {
   3.795628610605863*^9, 3.7956286433155622`*^9}, {3.795628679367074*^9, 
   3.795628707583602*^9}, {3.795628742783091*^9, 3.7956287459951067`*^9}, {
   3.795628787663509*^9, 3.795628801526518*^9}, {3.795628922522523*^9, 
   3.7956289456147547`*^9}, {3.79562906866321*^9, 3.795629141331089*^9}, {
   3.795629229443163*^9, 3.795629230245015*^9}, 3.7956296628177233`*^9, {
   3.7956297537535343`*^9, 3.79562976979946*^9}, {3.795629877018758*^9, 
   3.795629975815221*^9}, {3.7956301053017597`*^9, 3.795630135255445*^9}, {
   3.7956301932189417`*^9, 3.795630207161447*^9}, {3.795630238385459*^9, 
   3.795630321365858*^9}, {3.795630439800235*^9, 3.7956304475886*^9}, {
   3.795630515236383*^9, 3.795630522841693*^9}, {3.79563057851457*^9, 
   3.795630614623487*^9}, {3.7956306967809877`*^9, 3.795630728797262*^9}, {
   3.795630777418799*^9, 3.79563082718865*^9}, {3.7956309542611*^9, 
   3.795630960533284*^9}, {3.795631066538382*^9, 3.795631067658787*^9}, {
   3.795631264225235*^9, 3.795631264603104*^9}, {3.795631359712523*^9, 
   3.7956313726504927`*^9}, {3.795631497181748*^9, 3.795631500708872*^9}, {
   3.795631613554055*^9, 3.795631614332947*^9}, {3.795631768763275*^9, 
   3.7956318097362843`*^9}, {3.795631949939711*^9, 3.795631973448934*^9}, {
   3.795632015476939*^9, 3.795632016841352*^9}, {3.7956320752522583`*^9, 
   3.795632134585699*^9}, {3.795632172494339*^9, 3.7956322218183537`*^9}, {
   3.795633317991721*^9, 3.795633484183844*^9}, {3.795633561920763*^9, 
   3.795633628229082*^9}, {3.79563366217828*^9, 3.795633733418969*^9}, {
   3.7956338166385593`*^9, 3.795633855817371*^9}, {3.7956338954258432`*^9, 
   3.795633899505522*^9}, {3.795633947672361*^9, 3.795633947856947*^9}, {
   3.7956340930491257`*^9, 3.7956341061102533`*^9}, {3.7956342542349253`*^9, 
   3.795634260512282*^9}, {3.795634294529277*^9, 3.795634307223027*^9}, {
   3.7956343759492407`*^9, 3.7956343765209713`*^9}, {3.795634409994919*^9, 
   3.795634462146207*^9}, 3.79563461018738*^9, {3.795634651524535*^9, 
   3.795634653004127*^9}, {3.795634840615506*^9, 3.795634848639057*^9}, 
   3.795634998797332*^9, {3.795635079995406*^9, 3.795635107959752*^9}, {
   3.795635205986425*^9, 3.795635206343422*^9}, {3.795635252665676*^9, 
   3.795635253244371*^9}, 3.795635398156228*^9, 3.795635610749309*^9, {
   3.7956356537967587`*^9, 3.795635654338224*^9}, {3.795635793244348*^9, 
   3.795635824855201*^9}, {3.795635934068881*^9, 3.7956360044485703`*^9}, {
   3.795636097593938*^9, 3.7956361032554407`*^9}, {3.795636134463891*^9, 
   3.7956361727213182`*^9}, {3.795636252290803*^9, 3.795636252524802*^9}, {
   3.795636414294186*^9, 3.7956364365539703`*^9}, {3.795636473148243*^9, 
   3.7956364811840982`*^9}, {3.795782038550267*^9, 3.7957820425561323`*^9}, {
   3.795782158066917*^9, 3.795782190858387*^9}, {3.795782318071961*^9, 
   3.795782379459877*^9}, {3.795782409609447*^9, 3.795782430968006*^9}, {
   3.795782467107799*^9, 3.795782469777012*^9}, {3.795782528996743*^9, 
   3.795782541043078*^9}, {3.795782583486823*^9, 3.7957826400352182`*^9}, {
   3.7957827217478123`*^9, 3.795782780936268*^9}, {3.79578284243869*^9, 
   3.795782844526272*^9}, {3.7957828880539417`*^9, 3.795782908253017*^9}, {
   3.795782967365428*^9, 3.795782975150702*^9}, {3.7957830478185883`*^9, 
   3.79578304830961*^9}, 3.79578316061954*^9, {3.795783206263489*^9, 
   3.7957832755958433`*^9}, {3.795783336921857*^9, 3.795783373835546*^9}, 
   3.795783429996449*^9, {3.795783926568275*^9, 3.795783962362857*^9}, {
   3.7957841357063427`*^9, 3.7957841436143436`*^9}, {3.795784210681275*^9, 
   3.795784227507436*^9}, {3.795784275375592*^9, 3.7957843585651207`*^9}, {
   3.795784430402952*^9, 3.7957845764459*^9}, {3.7957846073810787`*^9, 
   3.79578464978973*^9}, {3.795784690186502*^9, 3.79578469557662*^9}, {
   3.795784726720399*^9, 3.79578477557012*^9}, {3.795784879537244*^9, 
   3.795784896727394*^9}, {3.795784931712525*^9, 3.7957849612629957`*^9}, {
   3.795785091865172*^9, 3.79578509352359*^9}, {3.7957851342284803`*^9, 
   3.795785202223896*^9}, {3.795785240601211*^9, 3.795785517246338*^9}, {
   3.7957855717382708`*^9, 3.795785691170412*^9}, {3.795785724811449*^9, 
   3.7957857456163883`*^9}, {3.795785780222782*^9, 3.795785857457346*^9}, {
   3.79578590881527*^9, 3.7957859385660753`*^9}, {3.7957860088510237`*^9, 
   3.7957860187191057`*^9}, {3.7957860799316063`*^9, 3.795786197387046*^9}, {
   3.79578626058457*^9, 3.795786342884363*^9}, {3.795786401088601*^9, 
   3.795786421582399*^9}, {3.795786491543186*^9, 3.795786493111671*^9}, {
   3.795786561005953*^9, 3.795786669933839*^9}, {3.7957867097704697`*^9, 
   3.7957867161298113`*^9}, {3.795786747371985*^9, 3.79578679880169*^9}, {
   3.795786897867231*^9, 3.795786917981254*^9}, {3.795786952349931*^9, 
   3.795787029015183*^9}, {3.795787070412734*^9, 3.7957870882648573`*^9}, {
   3.795787129608507*^9, 3.7957873221813183`*^9}, {3.795787462003189*^9, 
   3.795787503328148*^9}, {3.7957875436611223`*^9, 3.795787577010062*^9}, {
   3.795787631212851*^9, 3.7957876998340797`*^9}, {3.7957877422529573`*^9, 
   3.795787836704728*^9}, {3.7957878828711042`*^9, 3.795787886003565*^9}, {
   3.795788040892144*^9, 3.795788043815192*^9}, {3.79578812161808*^9, 
   3.795788292746806*^9}, {3.7957883797882843`*^9, 3.7957883850250273`*^9}, 
   3.795788461287445*^9, {3.795788496652103*^9, 3.795788509781102*^9}, {
   3.795788560811792*^9, 3.795788565974078*^9}, 3.795788701731401*^9, {
   3.795788860061337*^9, 3.79578887258953*^9}, {3.795788938469411*^9, 
   3.795788965083379*^9}, {3.795789086526349*^9, 3.795789121737391*^9}, {
   3.795789197027936*^9, 3.79578919804062*^9}, {3.795789235390772*^9, 
   3.7957892504128*^9}, {3.795789396553404*^9, 3.795789495191134*^9}, {
   3.7957895380845337`*^9, 3.795789614413537*^9}, {3.795789686063385*^9, 
   3.795789696532198*^9}, {3.795789732313293*^9, 3.795789785336784*^9}, 
   3.795789816211685*^9, {3.7957898590734053`*^9, 3.79578993557655*^9}, {
   3.7957900148586893`*^9, 3.795790067259357*^9}, {3.795790155133347*^9, 
   3.795790155336876*^9}, {3.795790212473962*^9, 3.7957902246112843`*^9}, {
   3.795790390463283*^9, 3.7957904766086617`*^9}, {3.795790515825863*^9, 
   3.7957905196037617`*^9}, 3.795790562923875*^9, 3.795790607603211*^9, {
   3.7957906537881947`*^9, 3.795790698528111*^9}, {3.7957907736974707`*^9, 
   3.7957907923333397`*^9}, {3.7957908325218153`*^9, 3.795790832719103*^9}, {
   3.7957908732771873`*^9, 3.795790893808628*^9}, {3.79579097657778*^9, 
   3.795790995378788*^9}, {3.795791075748415*^9, 3.795791105673283*^9}, {
   3.795791154627924*^9, 3.7957911812033052`*^9}, {3.795791239902069*^9, 
   3.79579124312953*^9}, {3.795791343901161*^9, 3.79579137222087*^9}, {
   3.795791407952795*^9, 3.795791487581029*^9}, {3.795791527029274*^9, 
   3.795791534845467*^9}, {3.795791699343894*^9, 3.795791699591612*^9}, 
   3.795791755176799*^9, {3.795791954410819*^9, 3.795792022417221*^9}, {
   3.795792056614357*^9, 3.795792069917982*^9}, 3.7957921218508167`*^9, {
   3.795792183610845*^9, 3.7957921837900057`*^9}, {3.795792250989039*^9, 
   3.79579226699269*^9}, {3.795792359012446*^9, 3.795792370768964*^9}, {
   3.795792424573536*^9, 3.7957924889027853`*^9}, {3.795792556135523*^9, 
   3.7957925792284813`*^9}, {3.795792644707506*^9, 3.795792648977167*^9}, {
   3.795792684767106*^9, 3.795792691401483*^9}, {3.795792834066074*^9, 
   3.795792842253647*^9}, {3.795792893016034*^9, 3.7957929166082363`*^9}, 
   3.795795069933032*^9, {3.795871800234085*^9, 3.795871800972404*^9}, {
   3.795872252446134*^9, 3.7958722653669853`*^9}, {3.795872306995584*^9, 
   3.795872308458313*^9}, {3.795872354899898*^9, 3.795872356566513*^9}, {
   3.7958723950608664`*^9, 3.7958723987124643`*^9}, {3.795884821169723*^9, 
   3.795884822513941*^9}, 3.795885284130666*^9, {3.795885757435296*^9, 
   3.795885757667183*^9}, {3.79588582512621*^9, 3.795885826973892*^9}, 
   3.795885988470344*^9, {3.795886192310576*^9, 3.795886192783255*^9}, {
   3.795886406104313*^9, 3.795886406377469*^9}, {3.7958864829633703`*^9, 
   3.795886484287353*^9}, {3.795886685833653*^9, 3.795886699210099*^9}, {
   3.7959619746843033`*^9, 3.795962079190208*^9}, {3.795962281801262*^9, 
   3.7959622930745993`*^9}, {3.795962396099584*^9, 3.795962412702341*^9}, {
   3.795962520729247*^9, 3.795962523393054*^9}, 3.795962555213168*^9, {
   3.79596263222163*^9, 3.795962669889114*^9}, {3.795962915781598*^9, 
   3.7959629195094643`*^9}, {3.795962971705114*^9, 3.795963127249728*^9}, {
   3.795963224793157*^9, 3.795963226627987*^9}, {3.795963281725286*^9, 
   3.795963415452134*^9}, {3.795963473425249*^9, 3.795963513818653*^9}, {
   3.7959635820623817`*^9, 3.795963712128467*^9}, {3.795963754910881*^9, 
   3.7959637593392553`*^9}, {3.795963978463779*^9, 3.795963982623062*^9}, {
   3.7959666351679993`*^9, 3.7959666571581*^9}, {3.795966793618206*^9, 
   3.795966793945874*^9}, 3.795967009845729*^9, 3.7959671283216667`*^9, {
   3.795967182576317*^9, 3.795967244988328*^9}, {3.795967321475349*^9, 
   3.795967321836473*^9}, {3.795967445386503*^9, 3.795967445809318*^9}, {
   3.795967513816394*^9, 3.795967519050474*^9}, {3.7959676927197523`*^9, 
   3.795967693114888*^9}, {3.795967736097077*^9, 3.795967752014271*^9}, {
   3.795973688438389*^9, 3.7959737159460773`*^9}, {3.7959743168115892`*^9, 
   3.79597432554944*^9}, {3.7959744107132673`*^9, 3.795974465293338*^9}, {
   3.795974523968869*^9, 3.7959745246391487`*^9}, {3.795974557761415*^9, 
   3.795974558503807*^9}, {3.795974691548337*^9, 3.795974693749115*^9}, {
   3.795974823787969*^9, 3.7959748429633207`*^9}, 3.795975595403973*^9, {
   3.795975863186112*^9, 3.795975864211837*^9}, {3.795976048360815*^9, 
   3.795976050698009*^9}, {3.795976391963375*^9, 3.795976395653542*^9}, {
   3.795976873313151*^9, 3.795976878533328*^9}, 3.795977021027217*^9, 
   3.795977968770607*^9, {3.7959781961778793`*^9, 3.795978197801511*^9}, {
   3.795978310880726*^9, 3.795978311468658*^9}, 3.795978382391324*^9, 
   3.795978445228447*^9, {3.795978824109964*^9, 3.795978858036015*^9}, {
   3.7959788914687634`*^9, 3.795978920647616*^9}, {3.7959789774917088`*^9, 
   3.795978981707431*^9}, {3.79598065898599*^9, 3.7959806727971363`*^9}, {
   3.795980769872815*^9, 3.79598082792426*^9}, {3.795984537384864*^9, 
   3.795984693379177*^9}, {3.795984750695738*^9, 3.795984805027725*^9}, {
   3.795984886089673*^9, 3.79598492562556*^9}, {3.795985005324977*^9, 
   3.79598506521591*^9}, {3.795985103627927*^9, 3.795985104165694*^9}, {
   3.795985253089327*^9, 3.795985253333955*^9}, {3.795987665089242*^9, 
   3.795987667840519*^9}, {3.79598771784698*^9, 3.7959877845517673`*^9}, {
   3.795987832462161*^9, 3.795987833001898*^9}, {3.795987895554861*^9, 
   3.7959879014633207`*^9}, {3.795987946779649*^9, 3.7959879533421173`*^9}, {
   3.795988007547707*^9, 3.795988018366753*^9}, {3.79598808486059*^9, 
   3.7959881100792027`*^9}, {3.795988370836257*^9, 3.795988378327428*^9}, {
   3.79604319976866*^9, 3.796043203544798*^9}, {3.796063034107813*^9, 
   3.796063040666891*^9}, {3.796067755179847*^9, 3.796067802263405*^9}, {
   3.7960678629482937`*^9, 3.796067942509198*^9}, 3.7960680076913652`*^9, {
   3.79614399872834*^9, 3.7961440061692057`*^9}, {3.796144114063304*^9, 
   3.796144125360137*^9}, {3.796144351838642*^9, 3.7961443631417933`*^9}, 
   3.796144557902656*^9, {3.7961446252074738`*^9, 3.796144628890374*^9}, {
   3.796144744097889*^9, 3.796144745207116*^9}, {3.7961448753804617`*^9, 
   3.796144948334313*^9}, {3.7961450559452457`*^9, 3.796145061741774*^9}, {
   3.796145123936844*^9, 3.7961451261866417`*^9}, {3.7961451885587063`*^9, 
   3.796145251863511*^9}, {3.796145320444511*^9, 3.796145331588994*^9}, {
   3.796145391789847*^9, 3.7961454153941803`*^9}, {3.796145823491817*^9, 
   3.796145850845285*^9}, {3.796148166824999*^9, 3.796148221329546*^9}, 
   3.7961482682110767`*^9, {3.796148327682073*^9, 3.796148333663377*^9}, {
   3.796148426774181*^9, 3.796148439219535*^9}, {3.796148473621236*^9, 
   3.796148518362858*^9}, {3.796148587808404*^9, 3.796148589019163*^9}, {
   3.796148772516304*^9, 3.79614887158712*^9}, {3.796148954380567*^9, 
   3.7961489608349*^9}, {3.7961490533623667`*^9, 3.796149092203207*^9}, {
   3.796149324480781*^9, 3.796149324937952*^9}, 3.79614936300769*^9, {
   3.796149472118259*^9, 3.7961494824228277`*^9}, {3.796149822542852*^9, 
   3.796149843601817*^9}, {3.796150103253405*^9, 3.796150103559535*^9}, {
   3.796150382278118*^9, 3.7961504275863132`*^9}, {3.7961505105954227`*^9, 
   3.796150512387224*^9}, {3.79615066872824*^9, 3.796150697260598*^9}, {
   3.7961508191177187`*^9, 3.796150852190157*^9}, {3.796153296356193*^9, 
   3.796153305131878*^9}, 3.796153488333665*^9, {3.79615355500797*^9, 
   3.796153561657349*^9}, {3.796153613266623*^9, 3.796153613615288*^9}, {
   3.796153730075674*^9, 3.7961537303493433`*^9}, {3.796154678561607*^9, 
   3.796154690732443*^9}, 3.7961547265171213`*^9, {3.796154834823373*^9, 
   3.796154857645343*^9}, {3.7961553193122873`*^9, 3.796155334012926*^9}, {
   3.7961554988427963`*^9, 3.79615549979047*^9}, {3.796155608743649*^9, 
   3.7961556093953943`*^9}, {3.7961661135176077`*^9, 3.796166222112976*^9}, {
   3.796166515764112*^9, 3.796166516433709*^9}, {3.796166578851849*^9, 
   3.7961665794552717`*^9}, {3.796166619051751*^9, 3.796166636235293*^9}, {
   3.796167058728642*^9, 3.79616708290261*^9}, 3.796231628961974*^9, {
   3.79623173450136*^9, 3.796231748894548*^9}, {3.796232015211972*^9, 
   3.796232016643446*^9}, {3.796232056675623*^9, 3.796232059822484*^9}, {
   3.796232116089229*^9, 3.79623214102667*^9}, {3.7962324248969393`*^9, 
   3.796232477975512*^9}, {3.796232612117436*^9, 3.796232639781281*^9}, 
   3.7962369978912897`*^9, {3.796238414582427*^9, 3.796238414865282*^9}, {
   3.796238775038488*^9, 3.796238775818585*^9}, {3.796243243246073*^9, 
   3.7962432496462593`*^9}, {3.7962434258022537`*^9, 3.796243426047179*^9}, {
   3.796243861414206*^9, 3.7962438796430283`*^9}, {3.796243946365484*^9, 
   3.796243946628785*^9}, {3.796244023245954*^9, 3.7962440259268847`*^9}, {
   3.796244084379698*^9, 3.796244096911824*^9}, 3.796244505817897*^9, {
   3.796244734108919*^9, 3.796244734747982*^9}, {3.79624487019346*^9, 
   3.7962450631252213`*^9}, {3.79624512914935*^9, 3.7962453912196074`*^9}, {
   3.7962454234871798`*^9, 3.7962455292475653`*^9}, 3.796245588786468*^9, {
   3.7962456228575487`*^9, 3.796245686458912*^9}, {3.79624571779784*^9, 
   3.7962457297902803`*^9}, {3.796245790400628*^9, 3.79624582815373*^9}, 
   3.796245859361577*^9, {3.796245895663015*^9, 3.7962459432639303`*^9}, {
   3.7962461012150393`*^9, 3.796246128723042*^9}, 3.796246631594844*^9, 
   3.796253050325*^9, {3.7962530846306877`*^9, 3.7962530908424187`*^9}, {
   3.796295687503014*^9, 3.7962956884526367`*^9}, {3.7962957224563093`*^9, 
   3.796295722802951*^9}, {3.796295881455064*^9, 3.796295907619411*^9}, {
   3.7963060313992577`*^9, 3.7963060377093773`*^9}, {3.796306075438685*^9, 
   3.796306091145516*^9}, 3.796312418576045*^9, {3.796312479724236*^9, 
   3.796312517341816*^9}, {3.796312617702938*^9, 3.7963126221981077`*^9}, 
   3.796312689601602*^9, 3.796313007779277*^9, {3.796320176106082*^9, 
   3.7963201778803787`*^9}, {3.796320277642991*^9, 3.796320316294492*^9}, {
   3.796320549479745*^9, 3.7963205502556887`*^9}, {3.7963205815100613`*^9, 
   3.796320586718637*^9}, {3.796321407624894*^9, 3.796321437292712*^9}, {
   3.796321530363267*^9, 3.796321555882612*^9}, 3.7963216374723997`*^9, {
   3.796321711604445*^9, 3.796321713992167*^9}, {3.796321914280046*^9, 
   3.796322020161519*^9}, {3.7963221924036818`*^9, 3.796322211308152*^9}, {
   3.796322336681686*^9, 3.796322338345292*^9}, {3.796322391145218*^9, 
   3.796322392749201*^9}, {3.796322579576172*^9, 3.79632260108709*^9}, {
   3.796322735206897*^9, 3.7963227368883657`*^9}, {3.796322778177374*^9, 
   3.796322780013464*^9}, {3.796322834845953*^9, 3.796322837340107*^9}, {
   3.796322871017562*^9, 3.796322873170538*^9}, 3.796322915626602*^9, 
   3.796323069184888*^9, {3.796323143519342*^9, 3.796323144206091*^9}, 
   3.796323265376017*^9, {3.7963234179379473`*^9, 3.796323429927505*^9}, {
   3.796323620800558*^9, 3.796323647117614*^9}, {3.796323712777069*^9, 
   3.796323718076236*^9}, {3.796323920358451*^9, 3.796323937382332*^9}, 
   3.796323983791066*^9, {3.796324817671887*^9, 3.796324878522645*^9}, 
   3.7963252371975317`*^9, {3.796325268402731*^9, 3.796325315880575*^9}, {
   3.796325373433333*^9, 3.796325373633217*^9}, {3.796325474975294*^9, 
   3.796325507479507*^9}, {3.796325640104815*^9, 3.796325641751205*^9}, {
   3.796325679596095*^9, 3.796325791839862*^9}, {3.7963258545741043`*^9, 
   3.7963258695643587`*^9}, {3.796325908681182*^9, 3.7963259175172987`*^9}, {
   3.796325954800275*^9, 3.796325956141366*^9}, {3.796326012670237*^9, 
   3.796326017037485*^9}, {3.796326052000165*^9, 3.7963260566486807`*^9}, {
   3.796326136209002*^9, 3.7963261638541517`*^9}, {3.7963262416256*^9, 
   3.796326243029296*^9}, {3.796326273740347*^9, 3.796326322798009*^9}, {
   3.796326353027561*^9, 3.796326405505189*^9}, {3.796326604958446*^9, 
   3.79632661970893*^9}, {3.796326699933466*^9, 3.796326723767906*^9}, {
   3.796326844436062*^9, 3.796326847041471*^9}, {3.79632692719629*^9, 
   3.796326929295024*^9}, {3.796327741733053*^9, 3.796327741886134*^9}, {
   3.796328079987413*^9, 3.79632808284973*^9}, {3.7963326614348593`*^9, 
   3.796332666433504*^9}, {3.796332709057082*^9, 3.7963327478045797`*^9}, {
   3.796333211204359*^9, 3.796333211554408*^9}, {3.7963405628734426`*^9, 
   3.796340564909905*^9}, {3.796341543151524*^9, 3.796341652082521*^9}, {
   3.796342645848969*^9, 3.796342674295545*^9}, {3.796343896961636*^9, 
   3.7963439905093327`*^9}, {3.796344165315167*^9, 3.7963441704669724`*^9}, {
   3.796344332610862*^9, 3.796344340714231*^9}, {3.796390038370837*^9, 
   3.796390039831195*^9}, 3.7963900779044857`*^9, {3.796395459850585*^9, 
   3.79639553646961*^9}, {3.7963955690362997`*^9, 3.796395596373686*^9}, {
   3.796395709488295*^9, 3.7963957654063177`*^9}, {3.796396979988605*^9, 
   3.796397010922391*^9}, {3.796397152208412*^9, 3.796397155262257*^9}, {
   3.7963977978902884`*^9, 3.796397799374259*^9}, {3.79639799098955*^9, 
   3.796398000406397*^9}, {3.796398124997229*^9, 3.796398133248746*^9}, {
   3.796398246532144*^9, 3.79639826656104*^9}, {3.796398487738199*^9, 
   3.796398488114697*^9}, {3.796398582952883*^9, 3.796398583301922*^9}, {
   3.7963987942930317`*^9, 3.7963988025136433`*^9}, {3.796398946747178*^9, 
   3.796398954069174*^9}, 3.796399023043483*^9, 3.796399069134364*^9, {
   3.796405380047564*^9, 3.79640542509791*^9}, {3.7964054556528482`*^9, 
   3.796405456852017*^9}, {3.796405497215869*^9, 3.79640551928345*^9}, {
   3.796405646157737*^9, 3.796405695830586*^9}, {3.7964059013194647`*^9, 
   3.79640590172852*^9}, {3.796406463975782*^9, 3.796406464289102*^9}, 
   3.796406634517487*^9, {3.796406830542366*^9, 3.79640687777203*^9}, {
   3.796406908392961*^9, 3.79640692224809*^9}, {3.7964074397208033`*^9, 
   3.796407447972662*^9}, {3.796407649275099*^9, 3.796407658907888*^9}, {
   3.7964796011541433`*^9, 3.796479663291363*^9}, {3.796479730768956*^9, 
   3.796479753092635*^9}, {3.7964798260751247`*^9, 3.796479834246826*^9}, {
   3.796479870101748*^9, 3.7964798734068108`*^9}, {3.796479930608502*^9, 
   3.796479933328643*^9}, {3.796480004398383*^9, 3.7964800209087667`*^9}, {
   3.796480105842852*^9, 3.7964801436081553`*^9}, 3.796481030819693*^9, {
   3.7964810623931093`*^9, 3.7964810626953297`*^9}, {3.796556708501318*^9, 
   3.796556733065422*^9}, {3.796556771397098*^9, 3.796556778233973*^9}, {
   3.796556889988076*^9, 3.796556919818345*^9}, {3.79659233677481*^9, 
   3.7965923802846727`*^9}, {3.7965925293877563`*^9, 3.7965925307733994`*^9}, 
   3.796654597696393*^9, {3.79666802052382*^9, 3.796668218771001*^9}, {
   3.796668251200507*^9, 3.796668361262661*^9}, 3.796738272247373*^9, {
   3.7967383974012003`*^9, 3.7967384092164307`*^9}, {3.796738456110004*^9, 
   3.796738761913396*^9}, {3.796738806009933*^9, 3.796738820797655*^9}, {
   3.796738851363085*^9, 3.796738889984967*^9}, {3.7967389361488533`*^9, 
   3.796738971243726*^9}, {3.7967392245044403`*^9, 3.796739727213695*^9}, {
   3.796739762765933*^9, 3.79674015503539*^9}, {3.796740189670969*^9, 
   3.796740246928989*^9}, {3.796740278116856*^9, 3.796740525984818*^9}, {
   3.796740565280779*^9, 3.796740601552693*^9}, 3.796740635734288*^9, {
   3.796740669195282*^9, 3.7967407057057447`*^9}, {3.796740788119376*^9, 
   3.796740808592654*^9}, {3.796740854214398*^9, 3.796740906591227*^9}, {
   3.796740992476697*^9, 3.796741046279108*^9}, {3.7967411317720623`*^9, 
   3.796741258897694*^9}, {3.7967414060500917`*^9, 3.7967414269790277`*^9}, {
   3.796741482775373*^9, 3.796741528976499*^9}, {3.796741576438642*^9, 
   3.796741576772429*^9}, {3.796741649131901*^9, 3.796741650515518*^9}, {
   3.796741774847653*^9, 3.796741777125358*^9}, {3.796741935435877*^9, 
   3.796742112021306*^9}, {3.796742195940216*^9, 3.7967422874274406`*^9}, {
   3.7967424357846727`*^9, 3.796742438589723*^9}, {3.796742533336337*^9, 
   3.796742533565712*^9}, {3.7968048978124933`*^9, 3.796804939424164*^9}, {
   3.7968049700235662`*^9, 3.796805019649291*^9}, {3.796805122434277*^9, 
   3.796805167809613*^9}, {3.796805223002586*^9, 3.796805309445763*^9}, {
   3.7968055326260843`*^9, 3.796805613728622*^9}, {3.796805665158646*^9, 
   3.796805684291008*^9}, {3.7968057205227957`*^9, 3.796805724941358*^9}, {
   3.796805955008699*^9, 3.796805958318574*^9}, {3.796808988166815*^9, 
   3.796808996408897*^9}, {3.796809067010097*^9, 3.796809072900189*^9}, {
   3.79680912568118*^9, 3.7968092004070883`*^9}, 3.7968092491142187`*^9, 
   3.796809288328081*^9, {3.796809537848546*^9, 3.796809599496406*^9}, 
   3.796809784968053*^9, {3.796809866898178*^9, 3.796809876225396*^9}, {
   3.796812391139627*^9, 3.796812392645032*^9}, {3.79681248172602*^9, 
   3.796812490704588*^9}, {3.796812599334545*^9, 3.796812601642305*^9}, {
   3.796812700067618*^9, 3.79681270144523*^9}, {3.796812819508095*^9, 
   3.796812934857085*^9}, {3.796813177833337*^9, 3.796813279932248*^9}, 
   3.796813375724963*^9, 3.796813435978589*^9, {3.796813519341599*^9, 
   3.796813534294628*^9}, {3.796813593760249*^9, 3.7968136297277946`*^9}, {
   3.796813734785721*^9, 3.7968137474405537`*^9}, {3.796813787515952*^9, 
   3.796813788095991*^9}, {3.7968138482616587`*^9, 3.796813894886375*^9}, {
   3.79681879064122*^9, 3.796818793515326*^9}, {3.796819001056975*^9, 
   3.796819001178825*^9}, {3.796819208828334*^9, 3.796819306318972*^9}, {
   3.79681936366368*^9, 3.7968193648365192`*^9}, {3.7968194145796833`*^9, 
   3.796819417355493*^9}, {3.796819470853385*^9, 3.7968194754589043`*^9}, {
   3.796819542779346*^9, 3.7968195703777943`*^9}, {3.7968196656757507`*^9, 
   3.796819747933282*^9}, {3.796819783997835*^9, 3.7968197847231503`*^9}, {
   3.7968198293751497`*^9, 3.7968198495490026`*^9}, {3.796819987286673*^9, 
   3.796820003538178*^9}, {3.796820127655285*^9, 3.796820128172372*^9}, {
   3.7968202052353077`*^9, 3.796820206500946*^9}, {3.796820318691392*^9, 
   3.7968203338351583`*^9}, {3.796820364274345*^9, 3.796820365584697*^9}, {
   3.796820633791767*^9, 3.796820674501563*^9}, {3.796820728254716*^9, 
   3.7968207295819073`*^9}, {3.79682077257821*^9, 3.7968207729998283`*^9}, 
   3.796820810911643*^9, 3.796820866931031*^9, {3.7968209122270737`*^9, 
   3.796820936140534*^9}, {3.796820990608367*^9, 3.796820991338565*^9}, {
   3.796821141883944*^9, 3.796821156395502*^9}, {3.7968212846096373`*^9, 
   3.7968212885288343`*^9}, {3.796821375096676*^9, 3.7968213919533157`*^9}, {
   3.796931537553316*^9, 3.796931543383704*^9}, {3.796931642517569*^9, 
   3.7969316450253983`*^9}, {3.796931681630418*^9, 3.796931681854556*^9}, {
   3.796931814146784*^9, 3.796931847651236*^9}, {3.796991806574266*^9, 
   3.796991809645267*^9}, {3.796991851848833*^9, 3.796991871064665*^9}, 
   3.797073666550186*^9, {3.797075896981628*^9, 3.797075927604439*^9}, 
   3.797076303676764*^9, {3.797076658123082*^9, 3.797076681144524*^9}, {
   3.797076866624199*^9, 3.7970768929518843`*^9}, {3.797077562550383*^9, 
   3.797077563094884*^9}, {3.7970776024943333`*^9, 3.797077717753242*^9}, {
   3.797077763921255*^9, 3.797077772479678*^9}, {3.797078039590054*^9, 
   3.797078201971435*^9}, 3.797078254890016*^9, {3.7970785674941177`*^9, 
   3.797078568625804*^9}, {3.797078814066539*^9, 3.797078826012979*^9}, {
   3.797078915194463*^9, 3.7970789213556013`*^9}, {3.797079319269014*^9, 
   3.797079361076722*^9}, {3.797079589419943*^9, 3.7970795971465263`*^9}, {
   3.797079984699819*^9, 3.7970800328775787`*^9}, {3.797080647829763*^9, 
   3.797080649061801*^9}, 3.797080682783218*^9, {3.797081383990143*^9, 
   3.7970814082085447`*^9}, {3.797081539687645*^9, 3.797081550050671*^9}, {
   3.797082598933827*^9, 3.79708260316754*^9}, {3.797082676616591*^9, 
   3.797082676791235*^9}, {3.797082735584399*^9, 3.7970827367532167`*^9}, {
   3.797082807024291*^9, 3.797082811753497*^9}, {3.7970828912871103`*^9, 
   3.797082891448464*^9}, 3.797082970191451*^9, {3.797083900018495*^9, 
   3.797083902290001*^9}, {3.797084100037778*^9, 3.797084132233449*^9}, {
   3.797084205766026*^9, 3.797084206228506*^9}, {3.7970844103886557`*^9, 
   3.797084412543486*^9}, {3.79708450863822*^9, 3.797084513075551*^9}, {
   3.797084562556757*^9, 3.7970845639503107`*^9}, 3.7971509800007763`*^9, {
   3.797152059780654*^9, 3.797152113368915*^9}, {3.7971521443851013`*^9, 
   3.797152238001814*^9}, {3.797152276706863*^9, 3.7971523726306257`*^9}, {
   3.7971525787645283`*^9, 3.797152592271656*^9}, {3.797152854615745*^9, 
   3.797153008670083*^9}, {3.797153081431325*^9, 3.79715308283892*^9}, {
   3.7971531146947727`*^9, 3.797153118017477*^9}, {3.7971531595005198`*^9, 
   3.797153166450404*^9}, {3.7971532226558437`*^9, 3.7971532606992598`*^9}, 
   3.797153296196397*^9, {3.79715336576832*^9, 3.797153410172029*^9}, {
   3.79715346311416*^9, 3.797153525523177*^9}, {3.79715356050222*^9, 
   3.7971537264725237`*^9}, {3.7971537601768227`*^9, 3.797153785552458*^9}, {
   3.7971538451158657`*^9, 3.797153867482833*^9}, {3.7971539297328176`*^9, 
   3.797153966006263*^9}, {3.797154115895673*^9, 3.797154134268285*^9}, {
   3.797154177214539*^9, 3.797154183116432*^9}, {3.7971542273611813`*^9, 
   3.797154231729492*^9}, {3.7971542737149153`*^9, 3.797154308335451*^9}, {
   3.79715447221484*^9, 3.7971544833880453`*^9}, {3.7971545360628843`*^9, 
   3.7971545694502974`*^9}, {3.797279823701016*^9, 3.797279943908739*^9}, {
   3.797280013180243*^9, 3.797280044517342*^9}, {3.797280092875927*^9, 
   3.79728038190973*^9}, {3.797281771016262*^9, 3.797281771537709*^9}, {
   3.797281805268008*^9, 3.797281996875202*^9}, {3.797282085588092*^9, 
   3.79728244810813*^9}, {3.7972825095130587`*^9, 3.7972825330720654`*^9}, {
   3.79728259325913*^9, 3.7972826095412703`*^9}, {3.797282641866208*^9, 
   3.797282705116404*^9}, {3.7972827566818943`*^9, 3.797282820801462*^9}, {
   3.797282871312702*^9, 3.797282950398149*^9}, {3.797323177917885*^9, 
   3.7973231793084717`*^9}, {3.797331526907288*^9, 3.7973315665022173`*^9}, {
   3.7973316356439257`*^9, 3.797331640809825*^9}, {3.7973321558640633`*^9, 
   3.797332172017865*^9}, 3.7973342536180353`*^9, {3.797334331280519*^9, 
   3.797334433832974*^9}, 3.7973344676113033`*^9, {3.797334562399995*^9, 
   3.797334564304772*^9}, {3.797334639360813*^9, 3.797334665816297*^9}, {
   3.7973411857020187`*^9, 3.797341213212006*^9}, {3.797341249783452*^9, 
   3.7973412848955107`*^9}, {3.7973413339435596`*^9, 
   3.7973413805093517`*^9}, {3.797341443585741*^9, 3.797341613960485*^9}, {
   3.7973418645708227`*^9, 3.797341865420638*^9}, {3.797344317676363*^9, 
   3.79734431859445*^9}, {3.797344941282493*^9, 3.797344945655978*^9}, {
   3.797345677556473*^9, 3.797345679983494*^9}, {3.797345911026229*^9, 
   3.797345921687931*^9}, {3.797346026147314*^9, 3.7973460486376266`*^9}, {
   3.797346113271574*^9, 3.7973461164422903`*^9}, {3.797346478325686*^9, 
   3.797346490691127*^9}, {3.797346546473172*^9, 3.797346563056287*^9}, {
   3.797346601314229*^9, 3.797346601631826*^9}, {3.797452062281499*^9, 
   3.797452088957478*^9}, {3.7974521368480577`*^9, 3.79745217020685*^9}, {
   3.7974522031831017`*^9, 3.797452298367546*^9}, {3.7974523411460543`*^9, 
   3.79745240817336*^9}, {3.797452442951818*^9, 3.797452468501882*^9}, {
   3.797452527429447*^9, 3.797452590561534*^9}, {3.797452731234803*^9, 
   3.797452775818915*^9}, {3.797452841857147*^9, 3.7974528652273397`*^9}, {
   3.79750889988455*^9, 3.797508902035038*^9}, 3.797510285577508*^9, {
   3.797510461881536*^9, 3.797510510249043*^9}, {3.79751056280264*^9, 
   3.797510568358157*^9}, {3.797510628693767*^9, 3.797510634774271*^9}, {
   3.797510676884959*^9, 3.797510706629484*^9}, {3.797510896859397*^9, 
   3.7975110093843927`*^9}, {3.797511057595298*^9, 3.797511187887596*^9}, {
   3.797511226992189*^9, 3.797511230612555*^9}, {3.7975112898157377`*^9, 
   3.797511290837018*^9}, {3.797513395319191*^9, 3.797513395796212*^9}, 
   3.797514595044245*^9, {3.797514839148265*^9, 3.7975148834683867`*^9}, {
   3.7975150496415033`*^9, 3.797515052598505*^9}, {3.797515261564253*^9, 
   3.797515276391506*^9}, 3.797515323732005*^9, {3.797515655503483*^9, 
   3.7975156808903418`*^9}, {3.797515799748616*^9, 3.797515800569579*^9}, {
   3.797515845906011*^9, 3.797515849462096*^9}, {3.797515892563311*^9, 
   3.797515892917997*^9}, {3.797515969428893*^9, 3.797516007057863*^9}, {
   3.797516104776205*^9, 3.797516128614258*^9}, {3.7975161586803827`*^9, 
   3.797516199469749*^9}, {3.797516236103451*^9, 3.797516251478285*^9}, {
   3.7975162899035482`*^9, 3.79751629003854*^9}, {3.797516450568507*^9, 
   3.797516451527853*^9}, {3.797516485762706*^9, 3.797516530667007*^9}, {
   3.7975168547993317`*^9, 3.797516888046973*^9}, {3.797517029800837*^9, 
   3.79751703890654*^9}, 3.797517137972332*^9, {3.7975172341350594`*^9, 
   3.79751723853578*^9}, {3.79751733189524*^9, 3.797517347924594*^9}, {
   3.7975175065480556`*^9, 3.797517512537572*^9}, {3.797517688549988*^9, 
   3.797517712211672*^9}, {3.797517756153391*^9, 3.797517756442523*^9}, 
   3.7975178357660513`*^9, {3.79751792410627*^9, 3.797517924757914*^9}, {
   3.7975180226803503`*^9, 3.7975180539530163`*^9}, {3.797529408919166*^9, 
   3.797529414480257*^9}, {3.7975294784399242`*^9, 3.797529478705274*^9}, {
   3.797529519491878*^9, 3.797529540344461*^9}, {3.797529634401084*^9, 
   3.797529639350875*^9}, {3.797529829138413*^9, 3.797529852517025*^9}, {
   3.797529936278328*^9, 3.797529940109424*^9}, {3.797537468216333*^9, 
   3.797537469379879*^9}, {3.797537555372847*^9, 3.797537612334179*^9}, {
   3.7975376452030573`*^9, 3.797537730208625*^9}, {3.797537769679658*^9, 
   3.797537829924582*^9}, {3.797537864300857*^9, 3.797537933033333*^9}, 
   3.7975379730271597`*^9, {3.797542077560934*^9, 3.7975421222004213`*^9}, {
   3.797542187373836*^9, 3.797542218607027*^9}, 3.797542320911854*^9, {
   3.797542365589259*^9, 3.797542454984345*^9}, {3.79754249660141*^9, 
   3.797542512519508*^9}, {3.7975425921046457`*^9, 3.797542593739625*^9}, {
   3.797542743298471*^9, 3.797542743472287*^9}, {3.797542880200425*^9, 
   3.7975428873915033`*^9}, {3.797543001637987*^9, 3.797543001937518*^9}, {
   3.797543233295743*^9, 3.797543255873967*^9}, {3.797543289752713*^9, 
   3.7975432901007137`*^9}, {3.797546966475492*^9, 3.797546974204281*^9}, {
   3.797547010909947*^9, 3.797547019209733*^9}, {3.797547201577248*^9, 
   3.797547207116785*^9}, {3.797547275623417*^9, 3.797547331434538*^9}, 
   3.7975476121154947`*^9, {3.797547659036018*^9, 3.79754769543145*^9}, {
   3.797547735526702*^9, 3.7975477367060423`*^9}, {3.797547795647458*^9, 
   3.797547880186749*^9}, {3.797547966509417*^9, 3.797547993574769*^9}, {
   3.7975481195478563`*^9, 3.797548137320519*^9}, {3.7975482810459642`*^9, 
   3.797548282373872*^9}, {3.7975484190851316`*^9, 3.79754841969634*^9}, {
   3.797548486994825*^9, 3.7975484872311583`*^9}, {3.7975486055636377`*^9, 
   3.797548608379395*^9}, {3.797548672896881*^9, 3.7975486857278023`*^9}, {
   3.797548845821978*^9, 3.7975488847692127`*^9}, {3.797549039078047*^9, 
   3.797549053200542*^9}, {3.79754911547482*^9, 3.797549119578959*^9}, {
   3.7975491661249723`*^9, 3.797549167027133*^9}, {3.797549301251759*^9, 
   3.7975493026491613`*^9}, {3.797549407866441*^9, 3.797549410077469*^9}, {
   3.797549466141035*^9, 3.797549466851076*^9}, {3.7975495447946033`*^9, 
   3.79754954542354*^9}, {3.797549593112043*^9, 3.797549595053529*^9}, {
   3.797549739794289*^9, 3.797549740809392*^9}, {3.79754986036379*^9, 
   3.797549871573689*^9}, {3.797549932488205*^9, 3.797549933315956*^9}, {
   3.797549965785204*^9, 3.79754999211331*^9}, {3.7975500789809303`*^9, 
   3.797550079380224*^9}, {3.797550209358759*^9, 3.797550209806868*^9}, {
   3.797582328117691*^9, 3.7975823641412354`*^9}, {3.797582683743925*^9, 
   3.797582720105393*^9}, {3.797582776236977*^9, 3.797582828491601*^9}, {
   3.797582872086775*^9, 3.797582903732768*^9}, {3.797582941052218*^9, 
   3.797582970725237*^9}, {3.797583269758548*^9, 3.7975832776375847`*^9}, {
   3.797583320740802*^9, 3.797583321437213*^9}, {3.797583501846838*^9, 
   3.797583511866633*^9}, {3.7975868553070383`*^9, 3.797586855549313*^9}, {
   3.797586921197991*^9, 3.7975869214402742`*^9}, {3.797586986775113*^9, 
   3.797586990254025*^9}, {3.797595147576544*^9, 3.7975951958896723`*^9}, {
   3.797595236593396*^9, 3.7975952386109333`*^9}, {3.7975952731963377`*^9, 
   3.797595275064049*^9}, {3.797595320340025*^9, 3.7975953375022297`*^9}, {
   3.797595443431616*^9, 3.7975954999061413`*^9}, {3.797595536794709*^9, 
   3.797595537492826*^9}, {3.797595619938777*^9, 3.797595624162072*^9}, {
   3.7975956643069563`*^9, 3.797595692795018*^9}, {3.7975957272881117`*^9, 
   3.7975957302374487`*^9}, {3.7975957742014523`*^9, 
   3.7975958403895683`*^9}, {3.7975959629136887`*^9, 3.797595963293755*^9}, {
   3.797596045994772*^9, 3.7975960815652103`*^9}, {3.797596641865744*^9, 
   3.797596692580517*^9}, {3.797596770371904*^9, 3.797596802696116*^9}, {
   3.797596910524218*^9, 3.797596918289496*^9}, {3.797597102357624*^9, 
   3.797597163583275*^9}, {3.797614968540452*^9, 3.797614972112502*^9}, {
   3.797615016345066*^9, 3.7976150917645617`*^9}, {3.7976177535743513`*^9, 
   3.797617807629401*^9}, {3.797618322642334*^9, 3.7976183694743443`*^9}, {
   3.7976184541407833`*^9, 3.797618455049944*^9}, {3.797621102285034*^9, 
   3.797621191398114*^9}, {3.7976212298492107`*^9, 3.797621240212597*^9}, {
   3.7976215470497913`*^9, 3.797621547267066*^9}, {3.79762160314944*^9, 
   3.7976216202905293`*^9}, {3.7976219403207607`*^9, 
   3.7976219745801077`*^9}, {3.79762206483994*^9, 3.7976220654190493`*^9}, {
   3.797622793643197*^9, 3.7976227939551363`*^9}, {3.797622925293058*^9, 
   3.797622965577745*^9}, {3.7976230147779493`*^9, 3.797623028676499*^9}, {
   3.79762310707235*^9, 3.797623126378867*^9}, 3.7976231768535423`*^9, {
   3.79762323256273*^9, 3.797623274203373*^9}, {3.79762331363022*^9, 
   3.7976233577458897`*^9}, {3.797623653198434*^9, 3.797623671168624*^9}, {
   3.797625069162697*^9, 3.7976250698921003`*^9}, {3.7976251078929243`*^9, 
   3.797625128599909*^9}, {3.797625166790689*^9, 3.797625225405677*^9}, {
   3.797625680689851*^9, 3.797625700322901*^9}, {3.797668001703609*^9, 
   3.7976680018562613`*^9}, {3.797669213262343*^9, 3.797669220685843*^9}, {
   3.797669258368204*^9, 3.797669262038989*^9}, {3.797669305350305*^9, 
   3.797669305504862*^9}, {3.797669418493626*^9, 3.7976695228080606`*^9}, {
   3.797669640680822*^9, 3.797669641586235*^9}, 3.797670037030305*^9, 
   3.797670157351447*^9, {3.7976702840367737`*^9, 3.797670287472938*^9}, {
   3.797670425106696*^9, 3.79767056995201*^9}, {3.797670626943626*^9, 
   3.797670627428151*^9}, 3.797670714607057*^9, {3.797672045578052*^9, 
   3.7976720474825974`*^9}, {3.797672115850759*^9, 3.79767212521134*^9}, {
   3.797672737048945*^9, 3.7976727786865396`*^9}, {3.797672876191622*^9, 
   3.797673012070644*^9}, {3.7976731606818857`*^9, 3.7976732032709227`*^9}, {
   3.797673344189068*^9, 3.797673350479871*^9}, {3.7976734930680513`*^9, 
   3.7976734969990273`*^9}, {3.797673533432909*^9, 3.797673560327662*^9}, {
   3.797674988078849*^9, 3.7976750644458847`*^9}, {3.797675112553336*^9, 
   3.79767512001392*^9}, 3.797720485419755*^9, {3.797754733469994*^9, 
   3.797754743412225*^9}, {3.797771957292604*^9, 3.7977719967746*^9}, {
   3.7977720938459578`*^9, 3.7977721040357933`*^9}, {3.797772252250134*^9, 
   3.79777233717181*^9}, {3.797772404947442*^9, 3.797772415682664*^9}, {
   3.797772454528737*^9, 3.797772516930492*^9}, {3.797772633965805*^9, 
   3.797772659826988*^9}, 3.797773502054852*^9, 3.79777358384023*^9, {
   3.797773675112596*^9, 3.797773721141274*^9}, 3.7977737750212812`*^9, {
   3.797773840340431*^9, 3.797773905975724*^9}, {3.797773991720664*^9, 
   3.7977741291256943`*^9}, {3.7977741655021544`*^9, 3.797774178835925*^9}, {
   3.7977745779716387`*^9, 3.7977746173909187`*^9}, {3.7977746526872807`*^9, 
   3.7977746668958817`*^9}, {3.7977747913034077`*^9, 3.797775184601572*^9}, {
   3.79777527024362*^9, 3.797775317413054*^9}, {3.797775703365657*^9, 
   3.7977757190420437`*^9}, {3.7977760727885237`*^9, 
   3.7977760794340363`*^9}, {3.797776164164837*^9, 3.797776213504047*^9}, {
   3.7977763132057953`*^9, 3.7977763212068787`*^9}, {3.797776451550867*^9, 
   3.7977764676701612`*^9}, {3.797776635351859*^9, 3.797776686114523*^9}, {
   3.7977767244681473`*^9, 3.7977768342244*^9}, {3.797776868353793*^9, 
   3.7977768957426357`*^9}, {3.797777039170573*^9, 3.7977770394939413`*^9}, {
   3.797777213822466*^9, 3.7977772143145933`*^9}, {3.79777730111455*^9, 
   3.797777301423325*^9}, {3.7977773351252117`*^9, 3.797777350314681*^9}, {
   3.797777408901609*^9, 3.797777424997604*^9}, {3.797777594425847*^9, 
   3.797777594854897*^9}, {3.7977776250401697`*^9, 3.7977776602535963`*^9}, {
   3.797777717751348*^9, 3.797777758555829*^9}, {3.7977779153435087`*^9, 
   3.79777791569664*^9}, {3.797778004241736*^9, 3.7977780063083076`*^9}, {
   3.797778420481648*^9, 3.797778524762332*^9}, 3.7977785703082237`*^9, {
   3.7977786320960617`*^9, 3.797778657724875*^9}, {3.79777876055643*^9, 
   3.79777876641574*^9}, {3.797778797172803*^9, 3.797778828940732*^9}, {
   3.797778880101378*^9, 3.797778884057332*^9}, {3.797778922105631*^9, 
   3.797778925089591*^9}, {3.79777897414542*^9, 3.797779007082944*^9}, {
   3.79780290939342*^9, 3.797802963478507*^9}, {3.797803058340691*^9, 
   3.797803063746386*^9}, {3.79788946328209*^9, 3.797889463406644*^9}, {
   3.797893092305187*^9, 3.797893093896185*^9}, {3.7978931269224167`*^9, 
   3.797893139817588*^9}, {3.797893717287829*^9, 3.797893717481608*^9}, {
   3.797893830246911*^9, 3.797893839098949*^9}, 3.797893877355134*^9, {
   3.7978939720407143`*^9, 3.797893972558447*^9}, {3.7978942250952873`*^9, 
   3.797894231443734*^9}, {3.797894423874289*^9, 3.797894461063467*^9}, {
   3.797894606232973*^9, 3.7978946548043756`*^9}, {3.797903723581977*^9, 
   3.797903723934469*^9}, {3.797903785269288*^9, 3.797903799497127*^9}, {
   3.7979044224350224`*^9, 3.7979044246240673`*^9}, {3.797904575848905*^9, 
   3.7979045767060757`*^9}, {3.797904627444029*^9, 3.797904628655478*^9}, {
   3.79790483932099*^9, 3.797904840849924*^9}, {3.797905210547372*^9, 
   3.797905219208447*^9}, {3.797905253041835*^9, 3.79790525683337*^9}, {
   3.797905402323905*^9, 3.79790541503836*^9}, {3.797905455726218*^9, 
   3.797905458242447*^9}, {3.7979055005602818`*^9, 3.797905501108717*^9}, 
   3.7979055468702993`*^9, {3.797905632655157*^9, 3.797905687442583*^9}, {
   3.797905731589205*^9, 3.797905733229107*^9}, {3.797931055531683*^9, 
   3.797931060594227*^9}, {3.797933426046768*^9, 3.797933630584573*^9}, {
   3.797936814970159*^9, 3.797936897628769*^9}, {3.7979369693470097`*^9, 
   3.797937039390317*^9}, {3.7979