function [N,Tc,Tw,Th,theta,sigma,gamma,IC,beta_h,beta_c,beta_w]=setup_LHS(LHSmatrix, x)
% USAGE: [N,Tc,Tw,Th,theta,sigma,gamma,IC,beta_h,beta_c,beta_w]=setup_LHS(LHSmatrix, x)
% 
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 28 April 2020, last updated 3 June 2020
%
% modified from code from Shaw et al. 2017 Ecology & Shaw et al. 2018 BMB

N     = LHSmatrix(x,1);  % population size
Tc    = LHSmatrix(x,2);  % fraction of day commuting each day
Tw    = LHSmatrix(x,3);  % fraction of the day at work
theta = LHSmatrix(x,4);  % fraction of the population commuting to campus to work
sigma = LHSmatrix(x,5);  % rate of moving from exposed to infected = 1 / latent period
gamma = LHSmatrix(x,6);  % recovery rate = 1 / infection duration
R0_h  = LHSmatrix(x,7);  % reproductive number at home
R0_c  = LHSmatrix(x,8);  % reproductive number during commutes
R0_w  = LHSmatrix(x,9);  % reproductive number at work

Th = 1-2*Tc-Tw;      % fraction of the day at home
I_init = 1;          % initial infected
S_init = N-I_init;   % intial susceptible
E_init = 0;          % initial exposed
R_init = 0;          % initial removed
IC = [S_init E_init I_init R_init];
beta_h = R0_h*gamma;  % transmission at home
beta_c = R0_c*gamma;  % transmission commuting
beta_w = R0_w*gamma;  % transmission at work
end