% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 27 April 2020, last updated 3 June 2020
%
% set up for Monotonicity Checks
% sets all parameters to their baseline values

N = b_N;             % population size
Tc = b_Tc;           % fraction of day commuting each day
Tw = b_Tw;           % fraction of the day at work
theta = b_theta;     % fraction of the population commuting to campus to work
sigma = b_sigma;     % rate of moving from exposed to infected = 1 / latent period
gamma = b_gamma;     % recovery rate = 1 / infection duration
R0_h = b_R0_h;       % reproductive number at home
R0_c = b_R0_c;       % reproductive number during commutes
R0_w = b_R0_w;       % reproductive number at work

Th = 1-2*Tc-Tw;      % fraction of the day at home
I_init = 1;          % initial infected
S_init = N-I_init;   % intial susceptible
E_init = 0;          % initial exposed
R_init = 0;          % initial removed
IC = [S_init E_init I_init R_init];
beta_h = R0_h*gamma;  % transmission at home
beta_c = R0_c*gamma;  % transmission commuting
beta_w = R0_w*gamma;  % transmission at work
