% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 27 April 2020, last updated 3 June 2020

% generate parameter distributions from min, mean, max, std, sample,
% distribution
% note std not needed if using uniform distribution
v_N     = LHS_Call(b_N/2,     b_N,     b_N*2,     0, runs, 'unif');
v_Tc    = LHS_Call(b_Tc/2,    b_Tc,    b_Tc*2,    0, runs, 'unif');
v_Tw    = LHS_Call(2/24,      b_Tw,    12/24,     0, runs, 'unif');
v_theta = LHS_Call(0.0001,    b_theta, 1,         0, runs, 'unif');
v_sigma = LHS_Call(1/5.1,     b_sigma, 1/3.5,     0, runs, 'unif');
v_gamma = LHS_Call(1/11,      b_gamma, 1/6,       0, runs, 'unif');
v_R0_h  = LHS_Call(b_R0_h/2,  b_R0_h,  b_R0_h*2,  0, runs, 'unif');
v_R0_c  = LHS_Call(1,         b_R0_c,  4*R0_base, 0, runs, 'unif');
v_R0_w  = LHS_Call(b_R0_w/2,  b_R0_w,  b_R0_w*2,  0, runs, 'unif');

%%LHS matrix and Parameter Labels 
LHSmatrix=[v_N v_Tc v_Tw v_theta v_sigma v_gamma v_R0_h v_R0_c v_R0_w];

%Parameter Labels: 
PRCC_var={'N', 'T_c', 'T_w',  '\theta', '\sigma' , '\gamma', 'R_{e-h}', 'R_{e-c}', 'R_{e-w}'};
