clear all; clc
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 28 April 2020, last updated 3 June 2020
%
% takes 2.5 hrs to run 1000 reps
%
% LHS-PRCC analysis files downloaded from:
% http://malthus.micro.med.umich.edu/lab/usadata/
% > LHS_call.m
% > PRCC.m

runs = 1000;    % Number of samples to run

tf = 1000; % number of days to run for

set_parameters % set default parameter values
set_LHSdistributions % get parameter distributions

tic
EpiSize = zeros(1,runs);
EpiPeak = zeros(1,runs);
for x=1:runs %Run solution x times choosing different values
    x
    [N,Tc,Tw,Th,theta,sigma,gamma,IC,beta_h,beta_c,beta_w]=setup_LHS(LHSmatrix, x); %sets global variables
    
    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    % fraction infected
    EpiSize(x)=R_series(end)/N;
    EpiPeak(x)=max(I_series)/N;
    
    
end
toc

%Calculate PRCC
alpha=0.5; %Can be used for check if you want to PRCC is significant 

%PRCC for TimeToThresh
% inputs: matrix of param values, output values, points to test, param
% names, alpha for sig
[prcc1 pval1 sign_label]=PRCC(LHSmatrix,EpiSize,1,PRCC_var,alpha);
[prcc2 pval2 sign_label]=PRCC(LHSmatrix,EpiPeak,1,PRCC_var,alpha);
save('output_PRCC.mat')

%%
clear all
load('output/output_PRCC.mat')
pval1
pval2
% define figure settings
lw = 2;
fs1 = 10;  % axes labels
fs3 = 9; % axis numbering
sx = 0.08;
sy = 0.25;
d2 = 0.07;
w = 0.9;
hei = 0.7;
figure(1); clf
hh = gcf;
set(hh,'PaperUnits','inches');
set(hh,'Units','inches');
width = 7.5; height = 2;
xpos = 5;
ypos = 4;
set(gcf,'Position',[xpos ypos width height])

axes('position',[sx sy w hei])
    bar([prcc1; prcc2]');
    set(gca,'XTickLabel',PRCC_var(1:9),'XTick',[1:9]);
    ylim([-1 1]);
    xlabel('Model parameter','FontSize',fs1)
    ylabel('PRCC value','FontSize',fs1)
    set(gca,'FontSize',fs3);

    % label non sig
    axes('position',[0 0 1 1],'visible','off')
    hold on
    text(0.105,0.65,'ns','FontSize',fs3);
    text(0.135,0.65,'ns','FontSize',fs3);
    text(0.505,0.65,'ns','FontSize',fs3);
    text(0.61,0.65,'ns','FontSize',fs3);
axis([0 1 0 1])

% Backup previous settings
prePaperType = get(hh,'PaperType');
prePaperPosition = get(hh,'PaperPosition');
prePaperSize = get(hh,'PaperSize');

% Make changing paper type possible
set(hh,'PaperType','<custom>');
% Set the page size and position to match the figure's dimensions
position = get(hh,'Position');
set(hh,'PaperPosition',[0,0,position(3:4)]);
set(hh,'PaperSize',position(3:4));

saveas(1,'fig4.jpg')
print(1,'-dtiff','fig4.tiff','-r300')

% Restore the previous settings
set(hh,'PaperType',prePaperType);
set(hh,'PaperPosition',prePaperPosition);
set(hh,'PaperSize',prePaperSize);
