clear all
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% takes 24 min to run

%----- SETUP--------------------------------------------------------------%
    % define initial conditions
    N = 3000;          % population size
    I_init = 1;         % initial infected    
    S_init = N-I_init;  % intial susceptible
    E_init = 0;         % initial exposed
    R_init = 0;         % initial removed
    IC = [S_init E_init I_init R_init];

    tf = 1400; % number of days to run for

    Tc = 1/24; % fraction of day commuting each day

    theta = 1; % vector of theta values = fraction of pop commuting to campus

    Tvec = linspace(0,1,11); % fraction of workday on campus
%----- SETUP--------------------------------------------------------------%


%-----INFECTION PARAMETERS------------------------------------------------%
    % set infection parameters
    gamma = 1/9.5; % recovery rate = 1 / infection duration
                  %    units of per time
                  
    sigma = 1/4.2; % rate of moving from exposed to infected
    
    % infection parameters in each environment
    R0_base = 2.5; % current estimate of R0 in normal setting
    R0_h = R0_base*0.5; % current estimate, with physical distancing
    R0_c = R0_base; % commuting: unmitigated
    xvec = linspace(0,1,11); % amount of increase in contact compared to home
     
    % transmission rate for frequency-dependent, units of per time
    beta_h = R0_h*gamma;  % transmission at home
    beta_c = R0_c*gamma;  % transmission commuting
%-----INFECTION PARAMETERS------------------------------------------------%

R_end = NaN(size(xvec,2),size(Tvec,2));
I_max = NaN(size(xvec,2),size(Tvec,2));

tic
for i = 1:length(Tvec)
    
    Tw = Tvec(i)*8/24; % fraction of the day at work
    Th = 1-Tw; % fraction of the day at home
    
    for ii = 1:length(xvec)
        R0_w = R0_base*0.5*(1+xvec(ii));
        beta_w = R0_w*gamma;  % transmission at work
        
        
        [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
        
        
        eps1=1e-5;
        if abs(R_series(end)-R_series(end-10))>eps1
            error('simulation has not converged')
        end
        R_end(i,ii) = R_series(end);
        I_max(i,ii) = max(I_series);
    end
end
toc

save fig3c_R0work_tw.mat *
