clear all
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% takes 25 min to run

%----- SETUP--------------------------------------------------------------%
    % define initial conditions
    N = 3000;          % population size
    I_init = 1;         % initial infected    
    S_init = N-I_init;  % intial susceptible
    E_init = 0;         % initial exposed
    R_init = 0;         % initial removed
    IC = [S_init E_init I_init R_init];

    tf = 1400; % number of days to run for

    Tc = 1/24; % fraction of day commuting each day
    Tw = 8/24; % fraction of the day at work
    Th = 1-2*Tc-Tw; % fraction of the day at home

    thetavec = linspace(0,1,11); % vector of theta values = fraction of pop commuting to campus
%----- SETUP--------------------------------------------------------------%


%-----INFECTION PARAMETERS------------------------------------------------%
    % set infection parameters
    gamma = 1/9.5; % recovery rate = 1 / infection duration
                  %    units of per time
                  
    sigma = 1/4.2; % rate of moving from exposed to infected
    
    % infection parameters in each environment
    R0_base = 2.5; % current estimate of R0 in normal setting
    R0_h = R0_base*0.5; % current estimate, with physical distancing
    R0_c = R0_base; % commuting: unmitigated
    xvec = linspace(0,1,11); % amount of increase in contact compared to home

    % transmission rate for frequency-dependent, units of per time
    beta_c = R0_c*gamma;  % transmission commuting
    beta_h = R0_h*gamma;  % transmission at home
%-----INFECTION PARAMETERS------------------------------------------------%

R_end = NaN(size(thetavec,2),size(xvec,2));
I_max = NaN(size(thetavec,2),size(xvec,2));

tic
for i = 1:length(thetavec)
    theta = thetavec(i);  % fraction commuting to campus
    
    for ii = 1:length(xvec)
        
        R0_w = R0_base*0.5*(1+xvec(ii));
        beta_w = R0_w*gamma;  % transmission at work
        
        [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
        
        eps1=1e-5;
        if abs(R_series(end)-R_series(end-10))>eps1
            error('simulation has not converged')
        end
        R_end(i,ii) = R_series(end);
        I_max(i,ii) = max(I_series);
    end
end
toc

save fig3b_R0work_theta.mat *
