clear all; clc

% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% last updated 3 June 2020

    x1 = 0.2
    x2 = 0.9

load fig3a_tw_theta.mat
% tw = xaxis = 2nd index
% theta = yaxis = first index

    ind1=find(thetavec==x1);
    ind2=find(Tvec==x2);
    [R_end(ind1,ind2)/N     I_max(ind1,ind2)/N]

    ind1=find(thetavec==x2);
    ind2=find(Tvec==x1);
    [R_end(ind1,ind2)/N     I_max(ind1,ind2)/N]

load fig3b_R0work_theta.mat
% ROwork = xaxis = second index
% theta = yaxis = first index

    ind1=find(thetavec==x2);
    ind2=find(xvec==x1);
    [R_end(ind1,ind2)/N     I_max(ind1,ind2)/N]

    ind1=find(thetavec==x1);
    ind2=find(xvec==x2);
    [R_end(ind1,ind2)/N     I_max(ind1,ind2)/N]

load fig3c_R0work_tw.mat
% ROwork = xaxis = 2nd index
% tw = yaxis = 1st index

    ind1=find(Tvec==x2);
    ind2=find(xvec==x1);
    [R_end(ind1,ind2)/N     I_max(ind1,ind2)/N]

    ind1=find(Tvec==x1);
    ind2=find(xvec==x2);
    [R_end(ind1,ind2)/N     I_max(ind1,ind2)/N]


%%
% define figure settings
lw = 2;
fs1 = 10;  % axes labels
fs3 = 9; % axis numbering
sx = 0.06;
sy = 0.19;
d2 = 0.09;
w = 0.25;
hei = 0.7;
figure(1); clf
hh = gcf;
set(hh,'PaperUnits','inches');
set(hh,'Units','inches');
width = 7.5; height = 2.2;
xpos = 5;
ypos = 4;
set(gcf,'Position',[xpos ypos width height])

axes('position',[sx sy w hei])
load fig3a_tw_theta.mat
    imagesc(flipud(R_end/N),[0.3 0.7]);
    axis square
    set(gca,'XTickLabel',Tvec(1:2:end))
    set(gca,'XTick',1:2:length(Tvec))
    xlabel('Time on campus','FontSize',fs1)
    set(gca,'YTick',1:2:length(thetavec))
    set(gca,'YTickLabel',fliplr(thetavec(1:2:end)))
    ylabel('Commuting','FontSize',fs1)
    title('Final epidemic size','FontSize',fs1)
    colorbar
    set(gca,'FontSize',fs3);

axes('position',[sx+d2+w sy w hei])
load fig3b_R0work_theta.mat
    imagesc(flipud(R_end/N),[0.3 0.7]);
    axis square
    set(gca,'XTick',1:2:length(xvec))
    xvec = xvec(1:2:end);
    set(gca,'XTickLabel',xvec)
    xlabel('Increased transmission','FontSize',fs1)
    set(gca,'YTick',1:2:length(thetavec))
    set(gca,'YTickLabel',fliplr(thetavec(1:2:end)))
    ylabel('Commuting','FontSize',fs1)
    title('Final epidemic size','FontSize',fs1)
    colorbar
    set(gca,'FontSize',fs3);

axes('position',[sx+2*d2+2*w sy w hei])
load fig3c_R0work_tw.mat
    imagesc(flipud(R_end/N),[0.3 0.7]);
    axis square
    set(gca,'XTick',1:2:length(xvec))
    xvec = xvec(1:2:end);
    set(gca,'XTickLabel',xvec)
    xlabel('Increased transmission','FontSize',fs1)
    set(gca,'YTick',1:2:length(Tvec))
    set(gca,'YTickLabel',fliplr(Tvec(1:2:end)))
    ylabel('Time on campus','FontSize',fs1)
    title('Final epidemic size','FontSize',fs1)
    colorbar
    set(gca,'FontSize',fs3);


% label subpanels
    axes('position',[0 0 1 1],'visible','off')
    hold on
    text(0       ,0.96,'a)','FontSize',fs1);
    text(d2+w    ,0.96,'b)','FontSize',fs1);
    text(2*d2+2*w,0.96,'c)','FontSize',fs1);
axis([0 1 0 1])

% Backup previous settings
prePaperType = get(hh,'PaperType');
prePaperPosition = get(hh,'PaperPosition');
prePaperSize = get(hh,'PaperSize');

% Make changing paper type possible
set(hh,'PaperType','<custom>');
% Set the page size and position to match the figure's dimensions
position = get(hh,'Position');
set(hh,'PaperPosition',[0,0,position(3:4)]);
set(hh,'PaperSize',position(3:4));

saveas(1,'fig3.jpg')
print(1,'-dtiff','fig3.tiff','-r300')

% Restore the previous settings
set(hh,'PaperType',prePaperType);
set(hh,'PaperPosition',prePaperPosition);
set(hh,'PaperSize',prePaperSize);

%%
% define figure settings
lw = 2;
fs1 = 10;  % axes labels
fs3 = 9; % axis numbering
sx = 0.06;
sy = 0.19;
d2 = 0.09;
w = 0.25;
hei = 0.7;
figure(1); clf
hh = gcf;
set(hh,'PaperUnits','inches');
set(hh,'Units','inches');
width = 7.5; height = 2.2;
xpos = 5;
ypos = 4;
set(gcf,'Position',[xpos ypos width height])

axes('position',[sx sy w hei])
load fig3a_tw_theta.mat
    imagesc(flipud(I_max/N),[0 0.08]);
    axis square
    set(gca,'XTickLabel',Tvec(1:2:end))
    set(gca,'XTick',1:2:length(Tvec))
    xlabel('Time on campus','FontSize',fs1)
    set(gca,'YTick',1:2:length(thetavec))
    set(gca,'YTickLabel',fliplr(thetavec(1:2:end)))
    ylabel('Commuting','FontSize',fs1)
    title('Epidemic peak size','FontSize',fs1)
    colorbar
    set(gca,'FontSize',fs3);

axes('position',[sx+d2+w sy w hei])
load fig3b_R0work_theta.mat
    imagesc(flipud(I_max/N),[0 0.08]);
    axis square
    set(gca,'XTick',1:2:length(xvec))
    xvec = xvec(1:2:end);
    set(gca,'XTickLabel',xvec)
    xlabel('Increased transmission','FontSize',fs1)
    set(gca,'YTick',1:2:length(thetavec))
    set(gca,'YTickLabel',fliplr(thetavec(1:2:end)))
    ylabel('Commuting','FontSize',fs1)
    title('Epidemic peak size','FontSize',fs1)
    colorbar
    set(gca,'FontSize',fs3);

axes('position',[sx+2*d2+2*w sy w hei])
load fig3c_R0work_tw.mat
    imagesc(flipud(I_max/N),[0 0.08]);
    axis square
    set(gca,'XTick',1:2:length(xvec))
    xvec = xvec(1:2:end);
    set(gca,'XTickLabel',xvec)
    xlabel('Increased transmission','FontSize',fs1)
    set(gca,'YTick',1:2:length(Tvec))
    set(gca,'YTickLabel',fliplr(Tvec(1:2:end)))
    ylabel('Time on campus','FontSize',fs1)
    title('Epidemic peak size','FontSize',fs1)
    colorbar
    set(gca,'FontSize',fs3);


% label subpanels
    axes('position',[0 0 1 1],'visible','off')
    hold on
    text(0       ,0.96,'a)','FontSize',fs1);
    text(d2+w    ,0.96,'b)','FontSize',fs1);
    text(2*d2+2*w,0.96,'c)','FontSize',fs1);
axis([0 1 0 1])

% Backup previous settings
prePaperType = get(hh,'PaperType');
prePaperPosition = get(hh,'PaperPosition');
prePaperSize = get(hh,'PaperSize');

% Make changing paper type possible
set(hh,'PaperType','<custom>');
% Set the page size and position to match the figure's dimensions
position = get(hh,'Position');
set(hh,'PaperPosition',[0,0,position(3:4)]);
set(hh,'PaperSize',position(3:4));

saveas(1,'figS4.jpg')
print(1,'-dtiff','figS4.tiff','-r300')

% Restore the previous settings
set(hh,'PaperType',prePaperType);
set(hh,'PaperPosition',prePaperPosition);
set(hh,'PaperSize',prePaperSize);
