clear all; clc
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 28 April 2020, last updated 3 June 2020
%
% takes ~14 hours hours to run
% figure out how many parameter values we should use in the LHS
% distributions
%
% LHS-PRCC analysis files downloaded from:
% http://malthus.micro.med.umich.edu/lab/usadata/
% > LHS_call.m
% > PRCC.m

tic

tf = 1000; % number of days to run for

set_parameters % set default parameter values

%Calculate PRCC
alpha=0.5; %Can be used for check if you want to PRCC is significant

%runs_vec = [10 50 100 200 500 800 1000];    % Number of samples to run
runs_vec = [50 100 500 1000 1500 2000];    % Number of samples to run

prcc_all1 = NaN(9,length(runs_vec));
prcc_all2 = NaN(9,length(runs_vec));


for i = 1:length(runs_vec)
    i
    runs = runs_vec(i);
    set_LHSdistributions % get parameter distributions
    
    EpiSize = zeros(1,runs);
    EpiPeak = zeros(1,runs);
    for x=1:runs %Run solution x times choosing different values
        [N,Tc,Tw,Th,theta,sigma,gamma,IC,beta_h,beta_c,beta_w]=setup_LHS(LHSmatrix, x); %sets global variables

        [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
        % fraction infected
        EpiSize(x)=R_series(end)/N;
        EpiPeak(x)=max(I_series)/N;

    end
    
    %PRCC for TimeToThresh
    % inputs: matrix of param values, output values, points to test, param
    % names, alpha for sig
    [prcc1,~,~]=PRCC(LHSmatrix,EpiSize,1,PRCC_var,alpha);
    prcc_all1(:,i)=prcc1;
    [prcc2,~,~]=PRCC(LHSmatrix,EpiPeak,1,PRCC_var,alpha);
    prcc_all2(:,i)=prcc2;
    save('output_numruns.mat')
end

toc


    %%


    figure(1); clf
    plot(runs_vec,abs(prcc_all1),'o-')
    xlabel('number of runs')
    ylabel('abs PRCC')

    print('-djpeg','-r300','figS3_numruns1.jpg')
    print(1,'-dtiff','figS3.tiff','-r300')
    
    figure(2); clf
    plot(runs_vec,abs(prcc_all2),'o-')
    xlabel('number of runs')
    ylabel('abs PRCC')

