clear all; clc
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 27 April 2020, last updated 3 June 2020
%
%Check for monotonicity  
% Output measure used: epidemic size, R(inf). 
% takes ~15min to run
%
% LHS-PRCC analysis files downloaded from:
% http://malthus.micro.med.umich.edu/lab/usadata/
% > LHS_call.m
%
tic

runs = 10;    % Number of samples to run
tf = 1000; % number of days to run for

set_parameters % set default parameter values
set_LHSdistributions % get parameter distributions


EpiSize = NaN(9,runs);


%%Check N%%
j=1
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    N=v_N(i);
    
    S_init = N-I_init;  % intial susceptible
    IC = [S_init E_init I_init R_init];
    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end



%%Check Tc%%
j=2
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    Tc=v_Tc(i);
    Th = 1-2*Tc-Tw;      % fraction of the day at home

    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end

%%Check Tw%%
j=3
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    Tw=v_Tw(i);
    Th = 1-2*Tc-Tw;      % fraction of the day at home

    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end

%%Check theta%%
j=4
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    theta=v_theta(i);
    
    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end

%%Check sigma%%
j=5
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    sigma=v_sigma(i);
    
    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end


%%Check gamma%%
j=6
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    gamma=v_gamma(i);
    beta_h = R0_h*gamma;  % transmission at home
    beta_c = R0_c*gamma;  % transmission commuting
    beta_w = R0_w*gamma;  % transmission at work
    
    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end

%%Check R0-h%%
j=7
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    R0_h=v_R0_h(i);
    beta_h = R0_h*gamma;  % transmission at home

    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end

%%Check R0-c%%
j=8
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    R0_c=v_R0_c(i);
    beta_c = R0_c*gamma;  % transmission commuting

    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end

%%Check R0-w%%
j=9
set_parameters_monotonicity; %sets ALL variables to baseline values 
for i=1:runs
    R0_w=v_R0_w(i);
    beta_w = R0_w*gamma;  % transmission at work

    [S_series,E_series,I_series,R_series] = run_SEIR_spatial(IC,beta_c,beta_h,beta_w,sigma,gamma,Tc,Th,Tw,tf,theta);
    
    % fraction infected
    EpiSize(j,i)=R_series(end)/N;
end

save('output_MonoPlots1.mat')
toc
%%
% 
clear all; close all
load('output/output_MonoPlots1.mat')
% 
lw1 = 1;  % lines
% lw2 = 1; % fig edges
% fs3 = 10;  % axis numbering
fs1 = 12;  % axes labels
ms=3;

figure(10); clf;
hh = gcf;
set(hh,'PaperUnits','inches');
set(hh,'Units','inches');
width = 7.5; height = 7.5;
xpos = 5;
ypos = 4;

j=1;  subplot(3,3,j); plot(v_N, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it N', 'FontSize', fs1);          ylim([0.7 0.8]);
j=2;  subplot(3,3,j); plot(v_Tc, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it T_c', 'FontSize', fs1);       ylim([0.7 0.8]);
j=3;  subplot(3,3,j); plot(v_Tw, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it T_w', 'FontSize', fs1);       ylim([0.6 0.8]);
j=4;  subplot(3,3,j); plot(v_theta, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it \theta', 'FontSize', fs1); ylim([0.4 0.8]);
j=5;  subplot(3,3,j); plot(v_sigma, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it \sigma', 'FontSize', fs1); ylim([0.7 0.8]);
j=6;  subplot(3,3,j); plot(v_gamma, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it \gamma', 'FontSize', fs1); ylim([0.7 0.8]);
j=7;  subplot(3,3,j); plot(v_R0_h, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it R_{e-h}', 'FontSize', fs1); ylim([0.5 1]);
j=8;  subplot(3,3,j); plot(v_R0_c, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it R_{e-c}', 'FontSize', fs1); ylim([0.7 0.9]);
j=9;  subplot(3,3,j); plot(v_R0_w, EpiSize(j,:), 'ko','MarkerSize',ms, 'LineWidth',lw1); title('\it R_{e-w}', 'FontSize', fs1); ylim([0.5 1]);
%set(gca,'YTick',[0.5 0.75 1])

%     ylim([10 51]); set(gca,'YTick',10:20:50);  set(gca,'FontSize',fs3,'LineWidth',lw2);

% label subpanels
    axes('position',[0 0 1 1],'visible','off')
    hold on
    text(0.08,0.92,'a)','FontSize',fs1);
    text(0.35,0.92,'b)','FontSize',fs1);
    text(0.63,0.92,'c)','FontSize',fs1);
    
    text(0.08,0.62,'d)','FontSize',fs1);
    text(0.35,0.62,'e)','FontSize',fs1);
    text(0.63,0.62,'f)','FontSize',fs1);
    
    text(0.08,0.32,'g)','FontSize',fs1);
    text(0.35,0.32,'h)','FontSize',fs1);
    text(0.63,0.32,'i)','FontSize',fs1);

    
axis([0 1 0 1])

% Backup previous settings
prePaperType = get(hh,'PaperType');
prePaperPosition = get(hh,'PaperPosition');
prePaperSize = get(hh,'PaperSize');

% Make changing paper type possible
set(hh,'PaperType','<custom>');
% Set the page size and position to match the figure's dimensions
position = get(hh,'Position');
set(hh,'PaperPosition',[0,0,position(3:4)]);
set(hh,'PaperSize',position(3:4));

saveas(10,'figS1_mono1.jpg')
print(10,'-dtiff','figS1_mono1.tiff','-r300')

% Restore the previous settings
set(hh,'PaperType',prePaperType);
set(hh,'PaperPosition',prePaperPosition);
set(hh,'PaperSize',prePaperSize);
