clear all; close all; clc
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 28 April 2020

load('output/output_PRCC.mat')
disp('first metric - final epidemic size')
    prcc_ode = abs(prcc1); % just consider the magnitude of each parameter's effect
    nn = runs;
    p = length(prcc_ode);
    prcc_ode_prime = (1/2)*log(abs((1+prcc_ode)./(1-prcc_ode)));
    for i = 1:length(prcc_ode_prime)
        for j = 1:length(prcc_ode_prime)
            z_ode(i,j) = (prcc_ode_prime(i) - prcc_ode_prime(j))/ sqrt( 1/(nn-3-p) + 1/(nn-3-p) );
        end
    end
    % sort the PRCC values in ascending order
    [y,i]=sort(abs(prcc_ode));
    % sort the cooresponding parameters
    PRCC_var(i)'
    % sum params by negative numbers
    x=sum(z_ode<0,1);
    [y2,i2]=sort(x);
    % sort the cooresponding parameters
    PRCC_var(i2)'

disp('second metric - epidemic peak size')
    prcc_ode = abs(prcc2); % just consider the magnitude of each parameter's effect
    nn = runs;
    p = length(prcc_ode);
    prcc_ode_prime = (1/2)*log(abs((1+prcc_ode)./(1-prcc_ode)));
    for i = 1:length(prcc_ode_prime)
        for j = 1:length(prcc_ode_prime)
            z_ode(i,j) = (prcc_ode_prime(i) - prcc_ode_prime(j))/ sqrt( 1/(nn-3-p) + 1/(nn-3-p) );
        end
    end
    % sort the PRCC values in ascending order
    [y,i]=sort(abs(prcc_ode));
    % sort the cooresponding parameters
    PRCC_var(i)'
    % sum params by negative numbers
    x=sum(z_ode<0,1);
    [y2,i2]=sort(x);
    % sort the cooresponding parameters
    PRCC_var(i2)'
