clear all; clc
% written by Allison Shaw, Contact ashaw@umn.edu for assistance.
% created 28 April 2020, last updated 3 June 2020
%
%Check that parameter distributions are indeed uniform 
%
% LHS-PRCC analysis files downloaded from:
% http://malthus.micro.med.umich.edu/lab/usadata/
% > LHS_call.m

runs = 100;    % Number of samples to run

set_parameters % set default parameter values
set_LHSdistributions % get parameter distributions

fs1 = 12;  % axes labels

figure(10); clf;

j=1;  subplot(3,3,j); hist(v_N); title('\it N', 'FontSize', fs1)
j=2;  subplot(3,3,j); hist(v_Tc); title('\it T_c', 'FontSize', fs1)
j=3;  subplot(3,3,j); hist(v_Tw); title('\it T_w', 'FontSize', fs1)
j=4;  subplot(3,3,j); hist(v_theta); title('\it \theta', 'FontSize', fs1)
j=5;  subplot(3,3,j); hist(v_sigma); title('\it \sigma', 'FontSize', fs1)
j=6;  subplot(3,3,j); hist(v_gamma); title('\it \gamma', 'FontSize', fs1)
j=7;  subplot(3,3,j); hist(v_R0_h); title('\it R_e home', 'FontSize', fs1)
j=8;  subplot(3,3,j); hist(v_R0_c); title('\it R_e commute', 'FontSize', fs1)
j=9;  subplot(3,3,j); hist(v_R0_w); title('\it R_e work', 'FontSize', fs1)

print('-djpeg','-r300','fig_LHSdistributions.jpg')
