% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{web_matrix_to_df}
\alias{web_matrix_to_df}
\title{Transform web matrix to expanded data frame}
\usage{
web_matrix_to_df(web, seed = 42)
}
\arguments{
\item{web}{A web matrix, e.g. \code{Safariland} from \code{\link{bipartite}}.}

\item{seed}{Passed to \code{set.seed()}. Used for shuffling rows in a reproducible way.}
}
\value{
Returns an expanded data frame needed as input for the bootstrap functions.
Rows are shuffled.
}
\description{
Transform a web matrix to an expanded data frame which is needed as input
for the bootstrap functions. Each row (interaction) is repeated as many
times as it was observed. This is important for the sampling procedure. Rows
are shuffled.
}
\examples{

library(bootstrapnet)
library(bipartite)
data(Safariland)

Safariland_df <- web_matrix_to_df(Safariland)

}
